/**
 * @class webapp.audiosetting.dataBase
 * @namespace webapp.audiosetting
 */
dojo.provide("webapp.audiosetting.dataBase");
dojo.declare("webapp.audiosetting.dataBase", null, {

	/**
	 * Is the ring volume is locked
	 * @property
	 * @type Boolean
	 */
	isRingVolumeLocked  : false,
	/**
	 * Current volume for each voicemode
	 * @property
	 * @type IntArray
	 */
	arrVolumeValues		: [],

	constructor : function() {
		ICTouchAPI.settingServices.getSettingValue("AudioRingLock", this, this.gotRingLockValue);

	},

	/**
	 * Get the mute value from audio module
	 */
	getMuteValue : function (){
		ICTouchAPI.APIServices.IctAudio.getMute({
			context:this,
			callback: this.gotMuteValue
			});
	},

	/**
	 * Get the current voicemode value from audio module
	 */
	getCurrentVoicemode : function(){
		ICTouchAPI.APIServices.IctAudio.getCurrentVoicemode({
			context:this,
			callback: this.gotCurrentVoicemode
			});
	},

	/**
	 * Get the voicemode status from audio module
	 */
	getVoicemodesStatus : function(){
		ICTouchAPI.APIServices.IctAudio.getVoicemodeStatus({
			context:this,
			callback: this.gotVoicemodesStatus
			});
	},



	getMaxVolume : function(voicemode){
		ICTouchAPI.APIServices.IctAudio.getVoicemodeMaxVol({
			params :[voicemode],
			context:this,
			callback:this.gotVoicemodeMaxVolume,
			callbackParams:voicemode
		});
		voicemode = null;
	}

});
