/**
 * @class webapp.audiosetting.controlBase
 * @namespace webapp.audiosetting
 */
dojo.provide("webapp.audiosetting.controlBase");
dojo.declare("webapp.audiosetting.controlBase",[ICTouchAPI.webApplication],
{
	constructor : function() {
		ICTouchAPI.settingServices.subscribeToSetting(this, "AudioRingLock", this.onAudioRingLockChanged);
	},

	/**
	 * Callback on the AudioRingLock setting
	 * @param {Object} audioRingLockSetting The AudioRingLock setting
	 */
	onAudioRingLockChanged : function(audioRingLockSetting){
		//Save the new value
		this.data.isRingVolumeLocked = audioRingLockSetting.jsValue;
		audioRingLockSetting=null;
	}
});
