dojo.provide("webapp.userservices.controlBase");
dojo.declare("webapp.userservices.controlBase",[ICTouchAPI.webApplication],
{

	constructor : function()
	{
		ICTouchAPI.skinServices.linkWebappsStyles("webapp.userservices","webapp.communication", true, true, true);
		ICTouchAPI.skinServices.linkWebappsStyles("webapp.getProgKeysPreview","webapp.communication", true, false, true, false);
		ICTouchAPI.skinServices.linkWebappsStyles("UIElements.Keyboard","webapp.userservices",true,true,true);
	},

    load : function() {
		// Suscribe to setting
		ICTouchAPI.settingServices.subscribeToSetting(this, "TelephonyVmNumber", this.onVmNumberChanged);
		ICTouchAPI.settingServices.subscribeToSetting(this, "ActiveRouting", this.onActiveRoutingChanged);
		ICTouchAPI.settingServices.subscribeToSetting(this, "TelephonySimplifiedForward", this.onSimplifiedForwardChanged);
		ICTouchAPI.settingServices.subscribeToSetting(this, "DndRequiresPassword", this.onDndRequiresPasswordChanged);
		ICTouchAPI.settingServices.subscribeToSetting(this, "TelephonyDndState", this.onDndChanged);
		ICTouchAPI.settingServices.subscribeToSetting(this, "EnableRoutingLed", this.onRoutingLedChanged);
		// To init webapp after a boot
		ICTouchAPI.settingServices.getSetting('TelephonyVmNumber', this, this.onVmNumberChanged);
		ICTouchAPI.settingServices.getSetting('ActiveRouting', this, this.onActiveRoutingChanged);
		ICTouchAPI.settingServices.getSetting('TelephonySimplifiedForward', this, this.onSimplifiedForwardChanged);
		ICTouchAPI.settingServices.getSetting('DndRequiresPassword', this, this.onDndRequiresPasswordChanged);
		ICTouchAPI.settingServices.getSetting('TelephonyDndState', this, this.onDndChanged);
		ICTouchAPI.settingServices.getSetting('EnableRoutingLed', this, this.onRoutingLedChanged);

		ICTouchAPI.CapabilityServices.subscribeToCapability("Video", "LocalVideoEnabled", this, this.onLocalVideoEnabledChanged);

		// Subscribe to connectivity_changed event
		ICTouchAPI.eventServices.subscribeToEvent(this, "connectivity_changed", this.onConnectivityChanged);

		// Help Event
		var widgetsTab = [];
		for(var i in this.data._arrAppBarSkeleton){
			widgetsTab.push("userservicesstatus"+i);
		}
		dojo.publish("needHelpEvent",["userservices",widgetsTab]);
	},

	loaded : function() {
		// Capability subscription
		ICTouchAPI.CapabilityServices.subscribeToCapability("Telephony", "multideviceRouting", this, this.multiDeviceRoutingSelectionAvailability);

		// Register to senskey
		ICTouchAPI.eventServices.subscribeToEvent(this, "SENSKEY_USER", this.eventPhysicalKeyUser);
		ICTouchAPI.eventServices.subscribeToEvent(this, "SENSKEY_HOME", this.eventPhysicalKeyHome);

		ICTouchAPI.eventServices.subscribeToEvent(this, "BasicRoutingFailedEvent", this.onForwardFailed);
		ICTouchAPI.eventServices.subscribeToEvent(this, "OutOfTheOfficeStatusEvent", this.onOutOfTheOfficeStatusChanged);
		
		ICTouchAPI.eventServices.subscribeToEvent(this, "DeactivateForwardEvent", this.eventDeactivateForwardEvent);

		dojo.subscribe("ModeHotel", this, this.onForbidAccess);
		dojo.subscribe("RequestCurrentProfile", this, this.onRequestProfile);
		
		dojo.subscribe("userservices.selectUserDevice", this, this.onSelectUserDeviceRequest);
		
		ICTouchAPI.settingServices.subscribeToSetting(this, "EnableUserDetails", this.onSettingChanged);
		ICTouchAPI.settingServices.subscribeToSetting(this, "EnableUserPresence", this.onSettingChanged);
		ICTouchAPI.settingServices.subscribeToSetting(this, "EnableRouting", this.onSettingChanged);
		ICTouchAPI.settingServices.subscribeToSetting(this, "EnableOverflow", this.onSettingChanged);
		ICTouchAPI.settingServices.subscribeToSetting(this, "AllowDirectCustomForward", this.onAllowDirectCustomForwardChanged);
		ICTouchAPI.settingServices.subscribeToSetting(this, "TelephonyHideIdentityByUserAllowed", this.onAllowHideIdentityByUser);
		ICTouchAPI.settingServices.subscribeToSetting(this, "TelephonyHideIdentityBarringRule", this.onHideIdentityBarringRuleChanged);
		ICTouchAPI.settingServices.getSetting("EnableRouting",this , this.onSettingChanged);
		ICTouchAPI.settingServices.getSetting("EnableOverflow",this , this.onSettingChanged);
		ICTouchAPI.settingServices.getSetting("EnableUserDetails",this , this.onSettingChanged);
		ICTouchAPI.settingServices.getSetting("EnableUserPresence",this , this.onSettingChanged);
		ICTouchAPI.settingServices.getSetting("AllowDirectCustomForward",this, this.onAllowDirectCustomForwardChanged);
		ICTouchAPI.settingServices.getSetting("TelephonyHideIdentityByUserAllowed",this, this.onAllowHideIdentityByUser);
		ICTouchAPI.settingServices.getSetting("TelephonyHideIdentityBarringRule",this, this.onHideIdentityBarringRuleChanged);
		dojo.subscribe("IM_AVAILABILITY_CHANGED",this,this.onIMAvailabilityChanged);

		//Profiles modification event
		ICTouchAPI.eventServices.subscribeToEvent(this, "RoutingStateChanged", this.routingStateChangedEvent);

		//Cache numbers gestion
		ICTouchAPI.settingServices.getSetting("TelephonyAttendantNumber",this , this.onNumberChanged);
		ICTouchAPI.settingServices.getSetting("TelephonyAssociateNumber",this , this.onNumberChanged);
		ICTouchAPI.settingServices.getSetting("TelephonyMobileNumber",this , this.onNumberChanged);
		ICTouchAPI.settingServices.getSetting("TelephonyVmNumber",this , this.onNumberChanged);
		ICTouchAPI.settingServices.getSetting("LatestNumbersCache",this , this.onNumberChanged);
		ICTouchAPI.settingServices.subscribeToSetting(this, "TelephonyAttendantNumber", this.onNumberChanged);
		ICTouchAPI.settingServices.subscribeToSetting(this, "TelephonyAssociateNumber", this.onNumberChanged);
		ICTouchAPI.settingServices.subscribeToSetting(this, "TelephonyMobileNumber", this.onNumberChanged);
		ICTouchAPI.settingServices.subscribeToSetting(this, "TelephonyVmNumber", this.onNumberChanged);
		ICTouchAPI.settingServices.subscribeToSetting(this, "LatestNumbersCache", this.onNumberChanged);

		dojo.subscribe("iframe.show",this,this.onUserServicesShow);

		//this.data.loadRoutingDetails();
	},

	setProfilesFromSummaryList : function(profilesSummaryList){
		this.data._arrProfilesSummaryList = profilesSummaryList;
		profilesSummaryList = null;
	},
	

	onSettingChanged : function(objUserServicesSetting){
		if(objUserServicesSetting && objUserServicesSetting.id){
			switch (objUserServicesSetting.id) {
				case "EnableUserDetails":
					if (objUserServicesSetting.jsValue) {
						this.data._arrListEntries[this.data.USER_INFO_SCREEN] = {
							intIndex: this.data.USER_INFO_SCREEN,
							strPrimaryContent: _("UserInfo", "webapp.userservices")
						};
					}else{
						this.data._arrListEntries[this.data.USER_INFO_SCREEN] = null;
					}
					break;
				case "EnableRouting":
					if (objUserServicesSetting.jsValue) {
						this.data.intSelectListItem = this.data.ROUTING_SCREEN;
						this.data._arrListEntries[this.data.ROUTING_SCREEN] = {
							intIndex: this.data.ROUTING_SCREEN,
							strPrimaryContent: _("Routing", "webapp.userservices")
						};
					}else{
						this.data._arrListEntries[this.data.ROUTING_SCREEN] = null;
					}
					break;
				case "EnableUserPresence":
					if (objUserServicesSetting.jsValue && webapp.userinfo && webapp.userinfo.boolIMAvailable) {
						this.data._arrListEntries[this.data.PRESENCE_IM_SCREEN] = {
							intIndex: this.data.PRESENCE_IM_SCREEN,
							strPrimaryContent: _("Presence", "webapp.userservices")
						};
					}else{
						this.data._arrListEntries[this.data.PRESENCE_IM_SCREEN] = null;
					}
					break;
				case "EnableOverflow":
					if (objUserServicesSetting.jsValue) {
						this.data._arrListEntries[this.data.OVERFLOW_SCREEN] = {
							intIndex: this.data.OVERFLOW_SCREEN,
							strPrimaryContent: _("Overflow", "webapp.userservices")
						};
					}else{
						this.data._arrListEntries[this.data.OVERFLOW_SCREEN] = null;
					}
					break;
				default:
					break;
			}
			if (this.data.mainWidget) {
				this.data.mainWidget.reload();
			}
		}
		objUserServicesSetting = null;
	},

	updateVideoEntry : function () {
		var needReload = false;
		if(this.data.isWebcamAvailable && this.data.isLocalVideoEnabled &&
			!this.data._arrListEntries[this.data.VIDEO_SCREEN]){
			this.data._arrListEntries[this.data.VIDEO_SCREEN] = {
				intIndex: this.data.VIDEO_SCREEN,
				strPrimaryContent: _("Video", "ICTouchAPI")
			};
			needReload = true;
		} else if((!this.data.isWebcamAvailable || !this.data.isLocalVideoEnabled) &&
			this.data._arrListEntries[this.data.VIDEO_SCREEN]){
			this.data._arrListEntries[this.data.VIDEO_SCREEN] = null;
			needReload = true;
		}
		if (this.data.mainWidget && needReload) {
				this.data.mainWidget.reload();
		}
	},

	onLocalVideoEnabledChanged : function(capability, value) {
		ICTouchAPI.debugServices.debug("webapp.userservices / onLocalVideoEnabledChanged capability="+capability+" value="+value);
		if (value == ICTouchAPI.CapabilityServices.AVAILABLE) {
			this.data.isLocalVideoEnabled = true;
		} else {
			this.data.isLocalVideoEnabled = false;
		}
		this.updateVideoEntry();
		capability=null;
		value=null;
	},

	onConnectivityChanged : function() {
		var args = ICTouchAPI.tools.getEventArguments(arguments);
		var item = args.item;
		var status = args.status;
		ICTouchAPI.debugServices.debug("webapp.userservices.controlBase / onConnectivityChanged item="+item+" status="+status);
		
		if(item==="camera" && (status==="ok" || status==="ko")){
			if(status==="ko"){
				this.data.isWebcamAvailable = false;
			} else if(status==="ok") {
				this.data.isWebcamAvailable = true;
			}
			this.updateVideoEntry();
		} else if(item == "supervision"){
			var statusIcon;

			// if supervision is activated, set the status icon to on, otherwise to off
			if(status == "on"){
				statusIcon = this.data.STATUS_ON_ICON;
			} else {
				statusIcon = this.data.STATUS_OFF_ICON;
			}

			// update the button
			var appBar = ICTouchAPI.AppBarServices.getAppBar("userservices","userservicesstatus"+this.data.USER_INFO_SCREEN);
			var supervisionButton = appBar.getButton(this.data.SUPERVISION);
			if(supervisionButton){
				supervisionButton.setStatusIcon(statusIcon);
			}
		} else if(item == "hideIdentity"){
			var hideIdentityStatus;
			
			// if hide identity is activated, set the status icon to on, otherwise to off
			if(status == "on"){
				hideIdentityStatus = true;
			} else {
				hideIdentityStatus = false;
			}
			
			// Update state
			this.data.setHideIdentityState(hideIdentityStatus);
			
			// update the button
			this.data.setHideUserIdentityButtonStatus(hideIdentityStatus);
			
			if(this.data.isUserInfoDisplayed()){
				this.data.loadUserInfoDetails();
			}
		}
	},

	onNumberChanged : function(objNumberSetting){
		if(objNumberSetting && objNumberSetting.id){
			if(objNumberSetting.id=="TelephonyAttendantNumber"){
				if (objNumberSetting.jsValue) {
					this.data.setTelephonyAttendantNumber(objNumberSetting.jsValue);
				}
			}else if(objNumberSetting.id=="TelephonyAssociateNumber"){
				if (objNumberSetting.jsValue) {
					this.data.setTelephonyAssociateNumber(objNumberSetting.jsValue);
				}
			}else if(objNumberSetting.id=="TelephonyMobileNumber"){
				if (objNumberSetting.jsValue) {
					this.data.setTelephonyMobileNumber(objNumberSetting.jsValue);
				}
			}else if(objNumberSetting.id=="TelephonyVmNumber"){
				if (objNumberSetting.jsValue) {
					this.data.setTelephonyVmNumber(objNumberSetting.jsValue);
				}
			}else if(objNumberSetting.id=="LatestNumbersCache"){
				if (objNumberSetting.jsValue) {
					this.data.setArrLatestNumbers(objNumberSetting.jsValue);
				}
			}else{
				//TODO : Default case : BNe devrait pas arriver : Erreur
			}
		}
		objNumberSetting = null;
	},

	onOutOfTheOfficeStatusChanged : function(status){
		if(this.data._arrListEntries[this.data.PRESENCE_IM_SCREEN]!=null){
		if (status.value && (status.value === true || status.value === "true" || status.value === 1)) {
			ICTouchAPI.ledServices.activate('userInfo', 'OUTOFOFFICE');
		}else{
			ICTouchAPI.ledServices.desactivate('userInfo', 'OUTOFOFFICE');
		}
		}else{
			ICTouchAPI.debugServices.error("webapp.userservices.controlBase - onOutOfTheOfficeStatusChanged - Out of office event received without user presence enabled");
		}
		status = null;
	},

	onIMAvailabilityChanged : function(imEnabled){
		this.data.setIMAvailability(imEnabled)
		if(this.data.getIMAvailability() && webapp.userinfo.boolIMAvailable){
			this.data._arrListEntries[this.data.PRESENCE_IM_SCREEN] = {
				intIndex: this.data.PRESENCE_IM_SCREEN,
				strPrimaryContent: _("Presence", "webapp.userservices")
			};
		}
		else{
			this.data._arrListEntries[this.data.PRESENCE_IM_SCREEN]=null;
		}
		//Refresh the container to reload the menu
		if (this.data.mainWidget) {
            this.data.mainWidget.reload();
		}
		imEnabled = null;

	},

	onUserServicesShow : function (strScreenName) {
	    if (strScreenName === "webapp.userservices.getUserService") {
			if (this.data.intSelectListItem === this.data.VIDEO_SCREEN) {
				this.data.mainWidget.reloadContainer();
			}
	    }
	},

	onDndRequiresPasswordChanged : function(objSetting) {
		if(objSetting){
			this.data.boolDndRequiresPassword = objSetting.jsValue;
		}
		objSetting = null;
	},

	/**
	 * Update the Dnd button status
	 */
	onDndChanged : function(objSetting) {
		if(objSetting){
			this.data.setDndButtonStatus(objSetting.jsValue);
			if (objSetting.jsValue) {
				ICTouchAPI.ledServices.activate('userInfo', 'DND-ON');
			}else{
				ICTouchAPI.ledServices.desactivate('userInfo', 'DND-ON');
			}
		}
		objSetting = null;
	},

	/**
	 * Update the led status
	 */
	onRoutingLedChanged : function(objSetting) {
		if(objSetting){
			this.data.boolRoutingLedActivated = objSetting.jsValue;
			if(objSetting.jsValue) {
				ICTouchAPI.ledServices.desactivate('userInfo', 'FORCE-OFF');
			} else {
				ICTouchAPI.ledServices.activate('userInfo', 'FORCE-OFF');
			}
		}
		objSetting = null;
	},

	/**
	 * Update the direct custom forward
	 */
	onAllowDirectCustomForwardChanged : function(objSetting) {
		if(objSetting){
			this.data.setAllowDirectCustomForward(objSetting.jsValue);
		}
		objSetting = null;
		if ((this.data.getContainerPath() === "webapp.userservices.getRoutingContent" || this.data.getContainerPath() === "webapp.userservices.getOverflowContent") && this.data.mainWidget) {
			this.data.mainWidget.reloadContainer();
		}
	},
	
	/**
	 * Show/hide the button "hide identity"
	 */
	onAllowHideIdentityByUser : function(objSetting) {
		ICTouchAPI.debugServices.info("webapp.userservices.controlBase / entering onAllowHideIdentityByUser");

		if(objSetting){
			ICTouchAPI.debugServices.debug("webapp.userservices.controlBase / onAllowHideIdentityByUser, new value is : " + objSetting.jsValue);
			// update the button
			var appBarHI = ICTouchAPI.AppBarServices.getAppBar("userservices","userservicesstatus"+this.data.USER_INFO_SCREEN);
			var HIButton = appBarHI.getButton(this.data.HIDE_IDENTITY);
			if(HIButton){
				if(objSetting.jsValue){
					HIButton.show();
				} else {
					HIButton.hide();
				}
			}
		}
		objSetting = null;
	},
	
	onHideIdentityBarringRuleChanged : function(objTHIBRSetting) {
		ICTouchAPI.debugServices.info("webapp.userservices.controlBase / entering onHideIdentityBarringRuleChanged");
		
		if(objTHIBRSetting){
			ICTouchAPI.debugServices.debug("webapp.userservices.controlBase / onHideIdentityBarringRuleChanged, new value is : " + objTHIBRSetting.value);
			this.data.setHideIdentityBarringRuleAllowedValues(objTHIBRSetting.allowedValues);
			this.data.setHideIdentityBarringRule(objTHIBRSetting.value);
		}
	},

	initDnd : function(boolDndStatus) {
		var appBar = ICTouchAPI.AppBarServices.getAppBar("userservices","userservicesstatus"+this.data.USER_INFO_SCREEN);
		this.data.setDndButtonStatus(boolDndStatus, appBar);
		this.data.dndButtonStatus = boolDndStatus;
		boolDndStatus = null;
	},

	/**
	 *	Set a bool to know if a vmNumber is set.
	 *	Reload the routing list if it is the current widget
	 *	@params {Object} objSetting : the complete 'TelephonyVmNumber' setting object
	 */
	onVmNumberChanged : function(objSetting) {
		var boolVmNumber;
		if (objSetting && objSetting.jsValue !== '') {
			boolVmNumber = true;
		} else {
			boolVmNumber = false;
		}
		if (boolVmNumber !== this.data.boolVmNumber) {
			//this.data.reloadRoutingDetailsWithOrWithoutVm(boolVmNumber);
			if ((this.data.getContainerPath() === "webapp.userservices.getRoutingContent" || this.data.getContainerPath() === "webapp.userservices.getOverflowContent") && this.data.mainWidget) {
				this.data.mainWidget.reloadContainer();
			}
			if(!this.data.getMultiDeviceRoutingAvailability()){
				if (!boolVmNumber && this.data.currentRoutingID == -2){
					this.onClickRouting(0);
				}
			}
		}
		this.data.boolVmNumber = boolVmNumber;
		objSetting = null;
	},

	/**
	 *	Callback of event BasicRoutingFailedEvent.
	 *	Routing set failed but is still selected in the selectList
	 *	So, reload the routing list if it is the current widget
	 */
	onForwardFailed : function() {
		if(this.data.getContainerPath() === "webapp.userservices.getRoutingContent" && this.data.mainWidget) {
			this.data.mainWidget.reloadContainer();
		}
		// 'unselect' the current routing ID
		this.data.currentRoutingID = null;
	},

	// When the setting TelephonySimplifiedForward change, store it
	onSimplifiedForwardChanged : function(objSetting) {
		if(objSetting && (objSetting.jsValue === true || objSetting.jsValue === false)) {
			this.data.boolSimplifiedForwardMode = objSetting.jsValue;
			this.data.changeMode(this.data.NORMAL_MODE);
			if (this.data.getContainerPath() === "webapp.userservices.getRoutingContent") {
				this.data.loadRoutingDetails();
			}
			this.data.updateAppButtons();
		}
		objSetting = null;
	},

	onForbidAccess:function(){
		this.data.setRightToUserServices(false);
	},

    // CallBack for the physical Key Event User
   eventPhysicalKeyUser : function(objEvent) {
	   // Value may be 0 or 1, 1 for press and 0 for release. Do action only on press.
		if(objEvent && objEvent.value !== 0){
			// show webapp userServices
			if (this.data.getRightToUserServices()){
				if((!webapp.lock|| !webapp.lock.isLocked())){
					ICTouchAPI.transitionServices.getScreen({name: "webapp.userservices.getUserService", params: {}});
					if(this.data.getMultiDeviceRoutingAvailability() && !this.data.isGetRoutingProfilesMade()){
						ICTouchAPI.APIServices.Telephony.getRoutingProfiles({context: this});
						this.data.setGetRoutingProfilesMade(true);
					}
				}
			}else{
				this.launchDndActivation();
			}
		}
		objEvent = null;
	},

	eventDeactivateForwardEvent : function() {
		if(this.data && this.data.yesCallback) {
			this.data.yesCallback();
		}
	},	
	
	// CallBack for the physical Key Event Home
   eventPhysicalKeyHome : function(objEvent) {
	   // Value may be 0 or 1, 1 for press and 0 for release. Do action only on press.
		if(objEvent && objEvent.value !== 0){
			//if(ICTouchAPI.transitionServices.getCurrentScreenName().indexOf("webapp.userservices") != -1){
				if(webapp.communication && webapp.communication.data) {
					webapp.communication.setSelectStatus(-1);
					webapp.communication.updateAppBar();
				}
			//}
		}
		objEvent = null;
	},

	// Public method that update settings : "RoutingIcon", "RoutingLabel" and "ActiveRouting".
	// The object must have the form : { strTrigger:, strDest:, strNumber:, boolOther:}
	setActiveRouting : function(objRouting) {
		//var label = webapp.userservices.data.formatRoutingLabel(objRouting.strTrigger, objRouting.strDest, objRouting.strNumber, objRouting.boolOther);
		var label = ICTouchAPI.tools.formatRoutingLabel(objRouting.strTrigger, objRouting.strDest, objRouting.strNumber, objRouting.boolOther);
		if (!ICTouchAPI.i18nServices.areI18nStringsEquals(label,this.data.currentRoutingLabel)) {

			if(webapp.progkeys) {
				webapp.progkeys.updateRoutingProgKeysDisplay("FWD_UNCONDITIONAL;Other;"+objRouting.strNumber+";true;FWD_UNCONDITIONAL;"+objRouting.strNumber);
			}

			if (objRouting.boolOther) {
				ICTouchAPI.APIServices.Telephony.activateForward({params: [objRouting.strTrigger + ";" + objRouting.strNumber], context: this});
			}
			else {
				ICTouchAPI.APIServices.Telephony.activateForwardDest({params: [objRouting.strTrigger + ";" + objRouting.strDest], context: this});
			}
		}else{
			////webapp.userservices.data.currentRoutingLabel="";
			this.onClickRouting(0);
		}
		objRouting = null;
	},


	// Copie of setActiveRouting, for the onClickRouting callback, because setActiveRouting is also used by other functions :
	//Public method that update settings : "RoutingIcon", "RoutingLabel" and "ActiveRouting".
	// The object must have the form : { strTrigger:, strDest:, strNumber:, boolOther:}
	setActiveRoutingOnClickRouting : function(objRouting) {
		//var label = webapp.userservices.data.formatRoutingLabel(objRouting.strTrigger, objRouting.strDest, objRouting.strNumber, objRouting.boolOther);
		var label = ICTouchAPI.tools.formatRoutingLabel(objRouting.strTrigger, objRouting.strDest, objRouting.strNumber, objRouting.boolOther);
		if (label !== this.data.currentRoutingLabel) {
			if (objRouting.boolOther) {
				ICTouchAPI.APIServices.Telephony.activateForward({params: [objRouting.strTrigger + ";" + objRouting.strNumber], context: this});
			}
			else {
				ICTouchAPI.APIServices.Telephony.activateForwardDest({params: [objRouting.strTrigger + ";" + objRouting.strDest], context: this});
			}
		}
		objRouting = null;
	},

	/**
	 * Routing is activated, updateLedStatus
	 **/
	onActiveRoutingChanged : function(objSetting) {
		if(!this.data.getMultiDeviceRoutingAvailability()){
			var strRouting = objSetting.value;
			var arrRouting = strRouting.split(":");
			if (arrRouting.length < 1) {
				return;
			}
			var strTrigger = arrRouting[0];

			this.data.currentRoutingLabel = ICTouchAPI.tools.formatRoutingLabel(arrRouting[0], arrRouting[1], arrRouting[2], (arrRouting[2]?true:false));
			// Set off or ON the led

			var modeTmp = null;
			if (strTrigger === "None" || strTrigger === "") {
				//modeTmp = 'BACK_OWNER';
				ICTouchAPI.ledServices.desactivate('userInfo', 'ROUTING');
			}else {
				//modeTmp = 'ROUTING';
				ICTouchAPI.ledServices.activate('userInfo', 'ROUTING');
			}


			// Select the Active routing in the routing list
			var arrRoutingData = this.data.getRoutingData();
			var boolRoutingMatched = false;
			for(var i in arrRoutingData){
				if (arrRouting[0] === arrRoutingData[i].strTrigger && (!arrRouting[1] || (arrRouting[1] === arrRoutingData[i].strDest && (arrRouting[2] === arrRoutingData[i].strNumber || !arrRouting[2])))){
					if (this.data.currentRoutingID !== arrRoutingData[i].intIndex){
						//If current routing isn't the active routing (external activation), set it
						this.data.currentRoutingID = arrRoutingData[i].intIndex;
						if (this.data.getContainerPath() === "webapp.userservices.getRoutingContent" && this.data.mainWidget) {
							this.data._loadedActiveRouting(strRouting);
						}
					}
					boolRoutingMatched = true;
					break;
				}
			}
			if (!boolRoutingMatched) {
				// No routing rule matched and the current routing has changed (case of external setting)
				this.data._loadedActiveRouting(strRouting);
			}
			objSetting = null;
		}
	},


    callbackCustomOk :function(strContent){
        this.data.objCurrentPresenceStatus.message=strContent;
        ICTouchAPI.APIServices.InstantMessaging.setStatus({context: this, params: [this.data.objCurrentPresenceStatus.idIMStatus, this.data.objCurrentPresenceStatus.message]});
		strContent = null;
    },

	launchDndActivation : function(){
		if (ICTouchAPI.CapabilityServices.getCapability("Telephony", "allowDnd") == ICTouchAPI.CapabilityServices.AVAILABLE){
			var that = this;
			if(this.data.boolDndRequiresPassword  && !this.data.dndButtonStatus){
				ICTouchAPI.keyboardServices.deployKeyboard(ICTouchAPI.KeyboardTypes.PASSWORD, null, {funcCallbackOk: function(strPassword) {that.setDND(strPassword);}});
			} else {
				this.openDNDConfirmPopup();
			}
		}
	},

	// Open the delete popup with type choice
	openDNDConfirmPopup : function() {
		// Avoid multiple entrance in this function while the popup is not properly closed.
		if(!this.bPopupDND) {
			this.bPopupDND = true;
			// Save context
			var context = this;
			
			var strTitle = "";
			if(this.data.dndButtonStatus) {
				strTitle = _("Unset do not disturb mode?", "webapp.userservices");
			} else {
				strTitle = _("Set do not disturb mode?", "webapp.userservices");
			}

			// Create the popup data
			var popupDND = {
				strTitle: _("Do not disturb", 'webapp.userservices'),
				strContent : strTitle,
				strType: "warning",
				boolMultiselect: true,
				arrPopupButtons: [ {
						strButtonName: "YES_BTN",
						strButtonLabel:  _("Yes", 'ICTouchAPI'),
						strButtonIcon: "generic-ok",
						callback : {
							func: function() {
								context.setDND("");
								context.closeDNDPopup();
							},
							context: context
						}
					}, {
						strButtonName: "NO_BTN",
						strButtonLabel:  _("No", 'ICTouchAPI'),
						strButtonIcon: "generic-cancel",
						callback : function(){
							context.closeDNDPopup();
						}
					}
				]
			};

			// Show the popup
			this.data.objPopupConfirmDND = ICTouchAPI.popupServices.addNewPopup(popupDND, "MEDIUM");
			
			this.data.hPopupConfirmDND = setTimeout(function() {
				context.closeDNDPopup();
			}, 30000);
		}
	},
	
	closeDNDPopup : function() {
		if(this.data.objPopupConfirmDND){
			ICTouchAPI.popupServices.removePopupByID(this.data.objPopupConfirmDND);
			this.data.objPopupConfirmDND = null;
		}
		if(this.data.hPopupConfirmDND){
			clearTimeout(this.data.hPopupConfirmDND);
			this.data.hPopupConfirmDND = null;
		}
		this.bPopupDND = false;
	},

	// Set a new value for the DND with a password (if required)
	setDND : function(password) {
		// According th the status of the DND to set, activate or deactivate it
		if(!this.data.dndButtonStatus) {
			ICTouchAPI.APIServices.Telephony.activateDnd({params: [password], context:this});
		} else {
			ICTouchAPI.APIServices.Telephony.deactivateDnd({context:this});
		}
		password = null;
	},

	changeDndSetting: function() {
		ICTouchAPI.settingServices.getSettingValue("DoNotDisturb", this, this._gotDndSetting);
	},

	_gotDndSetting: function(value) {
		ICTouchAPI.settingServices.setSettingValue("DoNotDisturb", !value);
		value = null;
	},

	onListClick : function(listId)
	{
		this.data.changeMode(this.data.NORMAL_MODE);
		switch (listId)
		{
			case this.data.PRESENCE_IM_SCREEN:
				this.data.intSelectListItem = this.data.PRESENCE_IM_SCREEN;
				this.data.loadPresenceDetails();
				//this.handlePresence();
				break;
			case this.data.ROUTING_SCREEN:
				this.data.intSelectListItem = this.data.ROUTING_SCREEN;
				this.data.loadRoutingDetails();
				break;
			case this.data.OVERFLOW_SCREEN:
				this.data.intSelectListItem = this.data.OVERFLOW_SCREEN;
				this.data.loadOverflowDetails();
				break;
			case this.data.USER_INFO_SCREEN:
				this.data.intSelectListItem = this.data.USER_INFO_SCREEN;
				this.data.loadUserInfoDetails();
				break;
			case this.data.VIDEO_SCREEN:
				this.data.intSelectListItem = this.data.VIDEO_SCREEN;
				this.data.loadVideoDetails();
				break;
		}
		listId = null;
	},

	onClickRouting : function(id, isSelected, progkey) {
		var routingData = this.data.getRoutingData();
		var selectedIndex = 0;
		for(var i in routingData) {
			if (routingData[i].intIndex === id) {
				selectedIndex = i;
			}
		}
		if(this.data.currentMode === this.data.DELETE_MODE && progkey!==true) {
			this.data.deletePopup(selectedIndex);
		} else if(this.data.currentMode === this.data.MODIFY_MODE && progkey!==true) {
			var dest = routingData[selectedIndex].strDest;
			var type = routingData[selectedIndex].strTrigger;
			if(routingData[selectedIndex].boolOther) {
				dest = dest + ":" + routingData[selectedIndex].strNumber;
			}
			this.data.currentRouting = {routingType: type,routingDestination: dest, id: selectedIndex};
			this.data.loadRoutingTypeDetails();
		} else {
			if(id!==this.data.currentRoutingID)
			{
				switch(id)
				{
					case 0:
						// No routing => deactivate (id 0 is "none")
						ICTouchAPI.APIServices.Telephony.deactivateForward({context: this});
						if(webapp.progkeys) {
							webapp.progkeys.desactivateProgKeys();
						}
						break;
					case -1:
						// Custom routing ( id -1 )
						this.data.onOtherSearch();
						break;
					case -2:
						// Case Immediate Forward to VOICEMAIL on Simplified forward mode.
						var objRouting = {strTrigger:this.data.FWD_UNCONDITIONAL, strDest:this.data.DST_VOICEMAIL};
						this.setActiveRoutingOnClickRouting(objRouting);
						if(webapp.progkeys) {
							webapp.progkeys.updateRoutingProgKeysDisplay(id);
						}
						break;
					default:
						this.setActiveRoutingOnClickRouting(routingData[selectedIndex]);
						if(webapp.progkeys) {
							webapp.progkeys.updateRoutingProgKeysDisplay(id);
						}
						break;
				}
			}else{
				if(id == -1) {
					this.data.onOtherSearch();
				}
			}
		}
		id = null;
		isSelected = null;
		progkey = null;
	},

	onClickOverflow : function(id) {
		var overflowData = this.data.getOverflowData();
		var selectedIndex = 0;
		for(var i in overflowData) {
			if (overflowData[i].intIndex === id) {
				selectedIndex = i;
				this.data.setCurrentOverflow(overflowData[i]);
			}
		}
		if(id == 0){//None case
			ICTouchAPI.APIServices.Telephony.cancelRoutingOverflow({context: this});
		}else if(id == -11){//Custom overflow case OVF_ON_NO_REPLY
			if(this.data.otherOverflowNumberNoReply!=null){
				var overflowDestination = {
					overflowType : this.data.OVF_ON_NO_REPLY,
					targetType : this.data.OVF_DESTINATION_NUMBER,
					phoneNumber : this.data.otherOverflowNumberNoReply,
					isSelected : true,
					userInformation : null
				};
				ICTouchAPI.APIServices.Telephony.setRoutingOverflow({params: [overflowDestination,true], context: this});
			}else if(this.data.otherOverflowUserNoReply!=null){
				var overflowDestination = {
					overflowType : this.data.OVF_ON_NO_REPLY,
					targetType : this.data.OVF_DESTINATION_NUMBER,
					phoneNumber : this.data.otherOverflowUserNoReply.phoneNumber,
					isSelected : true,
					userInformation : null
				};
				ICTouchAPI.APIServices.Telephony.setRoutingOverflow({params: [overflowDestination,true], context: this});
			}else{
				this.data.currentOverflowType = "OVF_ON_NO_REPLY";
				this.data.onOtherSearch();
			}
		}else if(id == -12){//Custom overflow case OVF_ON_BUSY_OR_NO_REPLY
			if(this.data.otherOverflowNumber!=null){
				var overflowDestination = {
					overflowType : this.data.OVF_ON_BUSY_OR_NO_REPLY,
					targetType : this.data.OVF_DESTINATION_NUMBER,
					phoneNumber : this.data.otherOverflowNumber,
					isSelected : true,
					userInformation : null
				};
				ICTouchAPI.APIServices.Telephony.setRoutingOverflow({params: [overflowDestination,true], context: this});
			}else if(this.data.otherOverflowUser!=null){
				var overflowDestination = {
					overflowType : this.data.OVF_ON_BUSY_OR_NO_REPLY,
					targetType : this.data.OVF_DESTINATION_NUMBER,
					phoneNumber : this.data.otherOverflowUser.phoneNumber,
					isSelected : true,
					userInformation : null
				};
				ICTouchAPI.APIServices.Telephony.setRoutingOverflow({params: [overflowDestination,true], context: this});
			}else{
				this.data.currentOverflowType = "OVF_ON_BUSY_OR_NO_REPLY";
				this.data.onOtherSearch();
			}
		}else if(id == -2){//Voicemail overflow
			var overflowDestination = {
				overflowType : this.data.OVF_ON_BUSY_OR_NO_REPLY,
				targetType : this.data.OVF_DESTINATION_VOICEMAIL,
				phoneNumber : null,
				isSelected : true,
				userInformation : null
			};
			ICTouchAPI.APIServices.Telephony.setRoutingOverflow({
				params:[overflowDestination,false],
				context: this
			});
		}else if(id == -4){//Voicemail overflow
			var overflowDestination = {
				overflowType : this.data.OVF_ON_NO_REPLY,
				targetType : this.data.OVF_DESTINATION_VOICEMAIL,
				phoneNumber : null,
				isSelected : true,
				userInformation : null
			};
			ICTouchAPI.APIServices.Telephony.setRoutingOverflow({
				params:[overflowDestination,false],
				context: this
			});
		}else{
			this.setActiveOverflow(overflowData[selectedIndex]);
		}

		//}
		//this.data.currentOverflow = overflowData[selectedIndex];
		id = null;
	},

	setActiveOverflow : function(overflowRoute){
		ICTouchAPI.APIServices.Telephony.setRoutingOverflow({
				params:[overflowRoute,true],
				context: this
			});
		overflowRoute = null;
	},

	onClickRoutingType : function(id) {
		this.data.currentRouting.routingType = this.data.getRoutingTypeData()[id].label;
		id = null;
	},

	onClickRoutingDestination : function(id) {
		var arrRoutingDestination = this.data.getRoutingDestinationData();
		if (id === arrRoutingDestination.length - 1) {
			this.data.onOtherSearch();
		} else {
			this.data.currentRouting.routingDestination = this.data.getRoutingDestinationData()[id].label;
		}
		id = null;
	},

	onClickPresence : function(id) {
		if (this.data.intSelectListItem === this.data.PRESENCE_IM_SCREEN) {
			this.data.objCurrentPresenceStatus.idIMStatus = id;
			ICTouchAPI.APIServices.InstantMessaging.setStatus({context: this, params: [this.data.objCurrentPresenceStatus.idIMStatus, this.data.objCurrentPresenceStatus.message]});
		}
		id = null;
	},

	handlePresence: function() {
		var objPresence;
		if (webapp.userinfo){
			objPresence = webapp.userinfo.data.getUserInfo().objPresence;
		}
		if (objPresence && objPresence.imPresenceValue && objPresence.personnalizedMessage) {
			this.data.objCurrentPresenceStatus.idIMStatus = objPresence.imPresenceValue.value.idStatus;
			this.data.objCurrentPresenceStatus.message = objPresence.personnalizedMessage;
			if (this.data.mainWidget && this.data.getContainerPath() === "webapp.userservices.getPresenceContent") {
				var objContent = this.data.mainWidget.container.getContent();
				if (this.data.objCurrentPresenceStatus) {
					if (this.data.intSelectListItem === this.data.PRESENCE_IM_SCREEN && objPresence.imPresenceValue.value.idStatus > 0) {
						objContent.selectAtIndex(objPresence.imPresenceValue.value.idStatus - 1);
					}
				}
			}
		}
	},

	onClickUserInfo : function(objSetting) {
		var func = dojo.hitch(this, this.saveSetting, objSetting.id);
		ICTouchAPI.keyboardServices.deployKeyboard(ICTouchAPI.KeyboardTypes.ALPHANUM, null, {funcCallbackOk: func, strDefaultText: objSetting.value});
		objSetting = null;
	},

	saveSetting : function(settingId, strKeyboardText) {
		ICTouchAPI.settingServices.setSettingValue(settingId, strKeyboardText, this, this.savedSetting);
		settingId = null;
		strKeyboardText = null;
	},

	savedSetting : function() {
		this.data.loadUserInfoDetails();
	},

	doCustomRouting : function(num)	{
		var str = dojox.string.sprintf(this.data.IMMEDIATE_CUSTOM, num);
		// Execute routing
		ICTouchAPI.APIServices.Telephony.activateForward({params:[str], context:this});
		this.buttonCallback(this.data.BACK);
		num = null;
	},

	/**
	 * onProgKeyConfig
	 * for Add/Edit progkey Arguments Testing.
	 */
	onProgKeyConfig : function(objAction, domNode, parentWidget){
		var appBar = ICTouchAPI.AppBarServices.getAppBar("progkeys", "getProgKeyAdd");
		this.data._nextPKButton = appBar.getButton("NEXT_BTN");
		this.data._nextPKButton.hide();
		if (objAction.action === "routing") {
			var that = this;
			var container = new UIElements.ApplicationMode.FullControl({
				content : {
					name    :	"UIElements.Container.ContainerControl",
					params  : {
						objTitle: {
							strLabel : webapp.userservices.data.getUserServiceListTitle()
						},
						objContent: {
							name : "webapp.userservices.getRoutingList",
							params : {
								itemCallback : function(intIndex) {that._progKeySetArgs(intIndex, "")},
								objAction : objAction,
								parentWidget : parentWidget
				}
			}
					}
				}
			}, domNode);

			objAction.arguments = (typeof objAction.arguments == "string") ? dojo.fromJson(objAction.arguments) : objAction.arguments;
			this.data.PKWidget = container.getContent().getContent();
			this.data.PKWidget.selectRouting(objAction.arguments);
			if(objAction.arguments && objAction.arguments.routingId) {
				this.data.PKWidget.selectRouting(objAction.arguments.routingId);
			}
			return this.onProgKeyConfigReturn(container);
		}
		else {
			return null;
		}
		objAction = null;
		domNode = null;
		parentWidget = null;
	},

	onProgKeyConfigReturn : function(container) {
		return {
			list : container,
			domNode : container.domNode,
			validate : function() {
				return webapp.userservices.data.intPKArgs;
			},
			destroy : function() {
				container.getContent().destroy();
				container.destroy();
			}
		}
		container= null;
	},

	_progKeySetArgs : function(routingID, number) {
		if (routingID) {
			if (routingID !== -1) {
				this.data._nextPKButton.show();
				var arguments				= {};
				arguments.strContent		= "";
				arguments.routingId			= routingID;
				arguments.strNotifStatus	= "notif-off";
				this.data.intPKArgs	= arguments;
				webapp.progkeys.setProgkeysArgumentsNextStep(arguments);
			} else {
				webapp.communication.onProgkeyConfigRouting();
				// get and save the callId
				var selected = webapp.communication.data.getSelectedEntry();
				webapp.communication.data._objFirstSelected = selected;

				var funcExit = {
					context: this,
					func: this.cancelPKImmediateRouting
				}

				var objSearch = {
					searchType				: webapp.communication.getKeyPadActionFromSelectStatus(),
					contactDataTypes : ["Phone"],
					secondaryInformation	: "phoneNumber", // information of the contact to be displayed at the right of the contact's display name in the search results
					useDefaultCallMethod	: true,
					showVoicemailButton		: false,
					showAddcontactButton	: false,
					dialpadObject			: {
						funcCallbackOk		:  function() {
							var callback = objSearch.lineClickCallback;
							callback.func.apply(callback.context, [null, {
							strContent: this.getValue()
							}]);
						},
						funcCallbackExit	: funcExit,
						strDefaultText		: (Number) ? Number : "",
						strOkLabel			: _("Add call to favorite", "webapp.progkeys"),
						strOkIcon			: "progkeys-add",
						numPadLengthLimit	: 40
					}
				};

				// define a right icon for the search results, for which the callback is to display the contact card
				objSearch.rightIconClickCallback = {
					neededData : "Contact",
					rightIconImage  : "contacts-card-32",
					rightIconImageRemoteContact : "contacts-contact-card-remote-32",
									context: webapp.userservices,
					func: function (objContact) {
						dojo.publish("e_contact_showContact",[{
							objContact: objContact,
								clbkBack: function() {
								ICTouchAPI.transitionServices.getScreen({
									name: "webapp.search.getSearch",
									params: {}
								});
							}
						}]);
						}
				};

				var byNameObject = {
					funcCallbackOk : function(){
						var callback = objSearch.lineClickCallback;
						callback.func.apply(callback.context, [null, {
						strContent: this.getValue()
						}]);
					},
					funcCallbackExit: funcExit
				}

				// define the action for the search results (click on the line of on the left icon), for which the callback is to add the contact to favorite
				objSearch.lineClickCallback = {
					neededData : "phoneNumber",
					leftIconImage  : "progkeys-add-32",
					leftIconImageConditionnalDisplay  : "phoneNumber",
					context:webapp.userservices,
					func:webapp.userservices._progKeySetNumber
				};

				// byNameObject allows to overwrite the callback of the dialpadObject if they are redefined
				objSearch.byNameObject = byNameObject;

				if(webapp.search){
					webapp.search.doSearch(objSearch, null, function() {
						webapp.progkeys.currentAddWidget.boolReset = false;
						ICTouchAPI.transitionServices.getScreen({
							name: "webapp.progkeys.getProgKeyAdd",
							params: {}
						});
					});
					// show numeric
					ICTouchAPI.keyboardServices.deployKeyboard(ICTouchAPI.KeyboardTypes.DIALPAD, null, objSearch.dialpadObject);
						}
				}
			}

		routingID	= null;
		Number		= null;
	},

	_progKeySetNumber : function(number, objEntry) {
		webapp.communication.setSelectStatus(-1);
		routingID = null;
		number = null;
		this.selectPKImmediateRouting(number);
		number = null;
		this.data._nextPKButton.show();
		num = null;
	},

	cancelPKImmediateRouting : function(param,param2) {
		this.data.intPKArgs = null;
		this.data._nextPKButton.hide();
		this.data.PKWidget.listUI.unselectAll();
		param = null;
		param2 = null;
	},

	onProgKeyDisplay : function(objAction, progkey) {
		objAction.arguments = (typeof objAction.arguments == "string") ? dojo.fromJson(objAction.arguments) : objAction.arguments;

		if(objAction.arguments.routingId == -2){
			progkey.icon = "communication-deflect-to-voice-mail";
		} else if(!isNaN(objAction.arguments.routingId)) {
			var routingData = this.data.getRoutingData();
			var selectedIndex = 0;

			for(var i in routingData) {
				if (routingData[i].intIndex === parseInt(objAction.arguments.routingId)) {
					selectedIndex = i;
					break;
				}
			}

			if(routingData[selectedIndex].strDest == this.data.DST_VOICEMAIL){
				progkey.icon = "communication-deflect-to-voice-mail";
			}
		}
		objAction = null;
		progkey = null;
	},

	/**
	 * onProgKeyAction
	 * @return : list of Template of actions
	 */
	/*onProgKeyAction : function() {
		var listActions = [];
		listActions.push({
			webAppName : "userservices",
			action : "routing",
			type : 1,
			icon : "communication-transfer-to",
			label : "Define a forward action"
		});
		return listActions;
	},*/

	onProgKeyClick : function(objAction) {
		if (objAction.action === "routing") {
			objAction.arguments = (typeof objAction.arguments == "string") ? dojo.fromJson(objAction.arguments) : objAction.arguments;

			if(!isNaN(objAction.arguments.routingId)) {
				if (objAction.arguments.routingId == this.data.currentRoutingID) {
					this.onClickRouting(0, true, true);
				}else{
					this.onClickRouting(parseInt(objAction.arguments.routingId), true, true);
				}
			}else{
				var tabArgs = objAction.arguments.routingId.split(";");
				var routing = {
					strTrigger:tabArgs[0],
					strDest:tabArgs[1],
					strNumber:tabArgs[2],
					boolOther:tabArgs[3],
					routingType:tabArgs[4],
					routingDestination:tabArgs[5]
				};
				this.setActiveRouting(routing);
			}
		}
		objAction = null;
	},

	getCurrentPresence: function() {
		return this.data.objCurrentPresenceStatus;
	},

	setImmediateActiveRouting : function(number) {
		if (number) {
			ICTouchAPI.transitionServices.getScreen({name: "webapp.userservices.getUserService", params: {}});
			var routing = {strTrigger:this.data.FWD_UNCONDITIONAL, strDest:this.data.ST_OTHER, strNumber:number, boolOther:true};
			this.data.currentRouting = {routingType: routing.strTrigger,routingDestination: routing.strDest+":"+number};
			this.setActiveRouting(routing);
		}
		number = null;
	},

	editOverflowNumber : function(index){
		if(index == -11){
			this.data.currentOverflowType = "OVF_ON_NO_REPLY";
			this.data.onOtherSearch();
		}else if(index == -12){
			this.data.currentOverflowType = "OVF_ON_BUSY_OR_NO_REPLY";
			this.data.onOtherSearch();
		}else{
			ICTouchAPI.debugServices.error("editOverflowNumber : Bad index recieved");
		}
	},

	setOverflow : function(number,doDialableNumber) {
		if (number) {
			ICTouchAPI.transitionServices.getScreen({name: "webapp.userservices.getUserService", params: {}});
			this.addNumberToCache(number);

			if(this.data.currentOverflowType == "OVF_ON_NO_REPLY"){
				this.data.otherOverflowNumberNoReply = number;
				this.data.currentOverflow.phoneNumber = number;
				var overflowDestination = {
					overflowType : this.data.OVF_ON_NO_REPLY,
					targetType : this.data.OVF_DESTINATION_NUMBER,
					phoneNumber : number,
					isSelected : true,
					userInformation : null
				};
				ICTouchAPI.APIServices.Telephony.setRoutingOverflow({params: [overflowDestination,doDialableNumber], context: this});
				var overflowData = this.data.getOverflowData();
				var selectedIndex = 0;
				for(var i in overflowData) {
					if (overflowData[i].intIndex === -11) {
						selectedIndex = i;
					}
				}
				this.data.currentOverflow = overflowData[selectedIndex];
			}else if(this.data.currentOverflowType == "OVF_ON_BUSY_OR_NO_REPLY"){
				this.data.otherOverflowNumber = number;
				this.data.currentOverflow.phoneNumber = number;
				var overflowDestination = {
					overflowType : this.data.OVF_ON_BUSY_OR_NO_REPLY,
					targetType : this.data.OVF_DESTINATION_NUMBER,
					phoneNumber : number,
					isSelected : true,
					userInformation : null
				};
				ICTouchAPI.APIServices.Telephony.setRoutingOverflow({params: [overflowDestination,doDialableNumber], context: this});
				var overflowData = this.data.getOverflowData();
				var selectedIndex = 0;
				for(var i in overflowData) {
					if (overflowData[i].intIndex === -12) {
						selectedIndex = i;
					}
				}
				this.data.currentOverflow = overflowData[selectedIndex];
			}

			/*this.data.loadOverflowDetails();*/
			/*if (this.data.getContainerPath() === "webapp.userservices.getOverflowContent" && this.data.mainWidget) {
				this.data.mainWidget.reloadContainer();
			}*/

		}
		number = null;
	},

	_setUserRouting : function(number) {
		if (number) {
			//ICTouchAPI.transitionServices.getScreen({name: "webapp.userservices.getUserService", params: {}});
			this.addNumberToCache(number);
			this.data.otherUserNumber = number;
			var forwardDestination = {
				forwardDestinationType: {
					type : "ForwardDestinationType",
					value : {
						value : this.data.FWD_DESTINATION_USER
					}
				},
				phoneNumber:number,
				isSelected:true,
				userInformation:null
			}
			ICTouchAPI.APIServices.Telephony.setRoutingForward({params: [forwardDestination], context: this})
		}
	},

	setDestinationRouting : function(number) {
		var arrDest = this.data.getRoutingDestinationData();
		arrDest[arrDest.length-1].strLabel = number;
		for(var i in arrDest) {
			arrDest[i].boolSelected = false;
		}
		arrDest[arrDest.length-1].boolSelected = true;
		this.data.currentRouting.routingDestination = "Other:"+number;
		ICTouchAPI.settingServices.getSettingValue("RoutingList", this.data, this.data.saveRoutingList);
		this.data.switchContainer("getRoutingContent",this.data.ROUTING_SCREEN, this.data.getUserServiceContainerTitle());
		ICTouchAPI.transitionServices.getScreen({name: "webapp.userservices.getUserService", params: {}});
		number = null;
	},

	multiDeviceRoutingSelectionAvailability : function(capability,value){
		if(value == ICTouchAPI.CapabilityServices.AVAILABLE){
			this.data.setMultiDeviceRoutingAvailability(true);
			this.data._arrAllDetails[this.data.ROUTING_SCREEN] = [];
			this.data._arrAllDetails[this.data.OVERFLOW_SCREEN] = [];
			this.hideEditionButton();
			ICTouchAPI.settingServices.setSettingValue("EnableOverflow", true);
			dojo.publish("ModeMultiDeviceRouting");
			if(!this.data.isGetRoutingProfilesMade() && ICTouchAPI.transitionServices.getCurrentScreenName().indexOf("userservices") != -1){
				ICTouchAPI.APIServices.Telephony.getRoutingProfiles({context: this});
				this.data.setGetRoutingProfilesMade(true);
			}
			if ((this.data.getContainerPath() === "webapp.userservices.getRoutingContent" || this.data.getContainerPath() === "webapp.userservices.getOverflowContent") && this.data.mainWidget) {
				this.data.mainWidget.reloadContainer();
			}
		}else{
			this.data.setMultiDeviceRoutingAvailability(false);
			this.data.loadRoutingDetails();
			ICTouchAPI.settingServices.setSettingValue("EnableOverflow", false);
		}
		value=null;
	},

	hideEditionButton : function(){
		for(var appbarId in this.data._arrAppBarSkeleton){
			var appBar = ICTouchAPI.AppBarServices._getAppBarWidget("userservices", "userservicesstatus" + appbarId);
			var btnAdd = appBar.getButton(this.data.ADD_ROUTING);
			var btnEdit = appBar.getButton(this.data.MODIFY_ROUTING);
			var btnDelete = appBar.getButton(this.data.DELETE_ROUTING);
			if(btnAdd){
				btnAdd.hide();
			}
			if(btnEdit){
				btnEdit.hide();
			}
			if(btnDelete){
				btnDelete.hide();
			}
		}
	},

	loadProfileDetails : function(_profileIndex){
		//FWD User case
		if(_profileIndex == -3){
			this.data.onOtherSearch();
		}else{
			var routingData = this.data.getRoutingData();
			var selectedProfile;
			for(var i in routingData) {
				if (routingData[i].intIndex == _profileIndex) {
					routingData[i].boolSelected = true;
					selectedProfile = routingData[i];
				}
			}
			var profileId = {id:selectedProfile.profileId};
			this.data.currentProfileId = selectedProfile.profileId;
			ICTouchAPI.APIServices.Telephony.getRoutingProfile({
				params:[profileId],
				context: this,
				callback: this.loadedProfileDetails
			});
		}

		_profileIndex = null;
	},

	loadedProfileDetails : function(profileDetails){
		this.data.switchContainer("getProfileDetails",this.data.PROFILE_DETAILS_SCREEN,_(["Routing profile",profileDetails.profileName], "webapp.userservices"));
		ICTouchAPI.transitionServices.getScreen({
			name: "webapp.userservices.getProfileDetails",
			params: {_profileDetails : profileDetails}
		});
		if(this.data.widgetProfileDetails){
			this.data.widgetProfileDetails.reloadList(profileDetails,false);
		}
		profileDetails = null;
	},


	displayCacheNumbersPopup : function(){
		var cacheNumber = this.data.getCacheNumbers();
		var index = 0;
		for(var i in cacheNumber){
			cacheNumber[i].intIndex = index;
			index++;
		}
		var context = this;
		// Create the popup data
		var popup = popup = {
			strTitle: _("Select one of the latest entries", "webapp.userservices"),
			strWidgetName : "UIElements.SelectList.SelectListControl",
			arrItems: cacheNumber,
			itemCallback : function(intIndex) {
				var cacheNumber = context.data.getCacheNumbers();
				context.data.latestEntrySelected = cacheNumber[intIndex];
			},
			boolMultiselect: false,
			arrPopupButtons: [ {
					strButtonName: "YES_BTN",
					strButtonLabel: _('Yes', "ICTouchAPI"),
					strButtonIcon: "generic-ok",
					callback : function(){
						ICTouchAPI.keyboardServices.getCurrentKeyboard().getInputField().setInputFieldContent(context.data.latestEntrySelected.number);
						ICTouchAPI.popupServices.removePopup(context.data.objPopup);
					}
				}, {
					strButtonName: "CANCEL_BTN",
					strButtonLabel: _('Cancel', "ICTouchAPI"),
					strButtonIcon: "generic-cancel",
					callback : function(){
						context.data.latestEntrySelected = null;
						ICTouchAPI.popupServices.removePopup(context.data.objPopup);
					}
				}
			]
		};
		// Show the popup
		this.data.objPopup = ICTouchAPI.popupServices.addNewPopup(popup, "MEDIUM");
	},

	addNumberToCache : function(number){
		var oldCache = this.data.getArrLatestNumbers();
		var newValue = "";
		var boolFind = false;
		var posFind;
		var lgt = oldCache.length;
		for (var i = 0 ; i < lgt; i++){
			if(oldCache[i]==number){
				boolFind = true;
				posFind = i;
			}
		}
		if(boolFind){
			oldCache.splice(posFind,1);
			oldCache.push(number);
		}else{
			oldCache.push(number);
		}
		if(oldCache.length > 5){
			oldCache.splice(0,oldCache.length-5);
		}
		newValue = oldCache.toString();
		ICTouchAPI.settingServices.setSettingValue("LatestNumbersCache", newValue);
		number = null;
	},

	storeSelectedDevices : function(deviceIndex){
		if(!this.data.boolCustomRoute){
			this.data.boolCustomRoute = true;
		}
		var availableDevices = this.data.getCurrentAvailableDevices();
		if(availableDevices[deviceIndex].presentationDestinationType.value.value == this.data.DEVICE_OTHER){
			if(availableDevices[deviceIndex].phoneNumber==""){
				this.data.onOtherSearch();
			}/*else{
				availableDevices[deviceIndex].phoneNumber="";
			}*/
		}
				//if(availableDevices[deviceIndex].presentationDestinationType.value.value != this.data.DEVICE_OTHER){
		if(availableDevices[deviceIndex].isSelected){
			this.data.objDetailsScreen.getContent().unselectAtIndex(deviceIndex);
		}else{
			this.data.objDetailsScreen.getContent().selectAtIndex(deviceIndex);
		}
		//}
		availableDevices[deviceIndex].isSelected = !availableDevices[deviceIndex].isSelected;
		this.data.setCurrentAvailableDevices(availableDevices);
		deviceIndex = null;
	},

	setCustomRoute : function(useOldCustom) {
		if (this.data.boolCustomRoute) {
			if (useOldCustom) {
				var availableDevices = this.data.customRoute;
			} else {
				var availableDevices = this.data.getCurrentAvailableDevices();
			}

			var arrDevices = [];
			var doDialableOtherNumber = false;
			for(var device in availableDevices){
				if(availableDevices[device].isSelected){
					if(availableDevices[device].presentationDestinationType.value.value == this.data.DEVICE_OTHER){
						doDialableOtherNumber = (availableDevices[device].doDialableOtherNumber!= undefined && availableDevices[device].doDialableOtherNumber!= null) ? availableDevices[device].doDialableOtherNumber : false;
						arrDevices.push(availableDevices[device].presentationDestinationType.value.value + "=" + availableDevices[device].phoneNumber)
					}else{
						arrDevices.push(availableDevices[device].presentationDestinationType.value.value);
					}
				}
			}
			if(arrDevices.length == 0){
				var popupData = {
					strTitle:  _("Selected devices", 'webapp.userservices'),
					strType: "info",
					strContent: _("Some fields are invalid. Modifications can't be applied.", 'webapp.userservices'),
					arrPopupButtons: [{
						strButtonName: "Ok",
						strButtonLabel:  _("Ok", 'ICTouchAPI'),
						strButtonIcon: "generic-ok",
						callback: function() {
							ICTouchAPI.popupServices.removePopup(webapp.userservices.data.objPopup);
						}
					}]
				};
				this.data.objPopup = ICTouchAPI.popupServices.addNewPopup(popupData, "MEDIUM");
			}else{
				this.data.customRoute = this.data.getCurrentAvailableDevices();
				this.data.changeMode(this.data.NORMAL_MODE);
				this.data.boolCustomRoute = false;
				ICTouchAPI.APIServices.Telephony.setRoutingRoutes({
					params: [arrDevices,doDialableOtherNumber],
					context: this,
					callback: function(){
						this.data.hRoutingDetailsReload = setTimeout(function() {webapp.userservices.data.loadRoutingDetails();}, 5000);
						ICTouchAPI.transitionServices.getScreen({name: "webapp.userservices.getUserService", params: {}});
					}
				});
			}
		}else{
			this.data.changeMode(this.data.NORMAL_MODE);
			this.data.boolCustomRoute = false;
			this.data.loadRoutingDetails();
			ICTouchAPI.transitionServices.getScreen({name: "webapp.userservices.getUserService", params: {}});
		}
	},

	_setOtherNumber : function(number,doDialableOtherNumber){
		var availableDevices = this.data.getCurrentAvailableDevices();
		if(number){
			this.data.otherRoutingNumber = number;
			this.data.otherRoutingNumberIsDialable = doDialableOtherNumber;
			this.addNumberToCache(number);
			for(var device in availableDevices){
				if(availableDevices[device].presentationDestinationType.value.value == this.data.DEVICE_OTHER){
					availableDevices[device].phoneNumber = number;
					availableDevices[device].isSelected = true;
					availableDevices[device].doDialableOtherNumber = doDialableOtherNumber;
					this.data.objDetailsScreen.getContent().selectAtIndex(device);

					//Force storeSelectedDevice
					this.data.boolCustomRoute = true;
				}
			}
			this.data.setCurrentAvailableDevices(availableDevices);
			this.data.widgetProfileDetails.reloadList(null,true);
			if(webapp.communication && webapp.communication.data) {
				webapp.communication.setSelectStatus(-1);
				webapp.communication.updateAppBar();
			}
			number = null;
		}else{
			if(!this.data.otherRoutingNumber){
				for(var device in availableDevices){
					if(availableDevices[device].presentationDestinationType.value.value == this.data.DEVICE_OTHER){
						availableDevices[device].isSelected = false;
						this.data.objDetailsScreen.getContent().unselectAtIndex(device);
					}
				}
			}
		}
	},

	routingStateChangedEvent : function(_routingState,boolByPassMutex){
		if(this.data.boolMutex != true || boolByPassMutex === true){
			this.data.boolMutex = true;
			this.manageRoutingProfile(_routingState);
			if(this.data.waitingProfiles.length >= 1){
				this.routingStateChangedEvent(this.data.waitingProfiles.shift(),true)
			}else{
				this.data.boolMutex = false;
			}
		}else{
			this.data.waitingProfiles.push(_routingState);
		}
	},

	manageRoutingProfile : function(_routingState){
		var routingState = _routingState.value;
		this.data.setRoutingProfileData(routingState);
		var label;
		var custom;
		this.data.boolForwardSet = false;
		this.data.lastIsRoutingTarget = routingState.isRoutingTarget;
		if(routingState.appliedProfile != null){
			if(routingState.appliedProfile.value.profileId.value.id!="" && routingState.appliedProfile.value.profileId.value.id!="CUSTOM"){
				this.data.setCurrentProfile(routingState.appliedProfile);
				dojo.publish("ProfileChanged",[this.data.getCurrentProfile()]);
				this.data.currentProfileLabel = this.data.getCurrentProfile();
			}else{
				custom = {
					type : "ProfileSummary",
					value : {
						profileId : {
							type : "ProfileId",
							value : {
								id : "CUSTOM"
							}
						}
					},
					profileName : "CUSTOM"
				}
				this.data.setCurrentProfile(custom);
				if(routingState.listForwardDestination != null && routingState.listForwardDestination.length!=0){
					for(var i in routingState.listForwardDestination){
						if(routingState.listForwardDestination[i].isSelected){
							this.data.boolForwardSet = true;
							if(routingState.listForwardDestination[i].forwardDestinationType.value.value == this.data.FWD_DESTINATION_VOICEMAIL){
								label = "VOICEMAIL_DEVICE";
							}else{
								var infos = "";
								if(this.data.isUserInfoNotEmpty(routingState.listForwardDestination[i])){
									infos = ICTouchAPI.tools.getContactDisplayName(routingState.listForwardDestination[i].userInformation.value);
								}
								label = ["USER_DEVICE","("+infos+")"];
							}
						}
					}
				}
				if(!this.data.boolForwardSet){
					dojo.publish("ProfileChanged",[custom]);
					this.data.currentProfileLabel = custom;
				}else{
					var fakeProfile = {
						type : "ProfileSummary",
						value : {
							profileId : {
								type : "ProfileId",
								value : {
									id : label
								}
							}
						},
						profileName : label
					};
					dojo.publish("ProfileChanged",[fakeProfile]);
					this.data.currentProfileLabel = fakeProfile;
				}
			}
		}
		if(routingState.activableProfiles != null && routingState.activableProfiles!=0){
			this.setProfilesFromSummaryList(routingState.activableProfiles);
		}
		if(routingState.isRoutingTarget){
			ICTouchAPI.ledServices.desactivate('userInfo', 'ROUTING');
		}else{
			ICTouchAPI.ledServices.activate('userInfo', 'ROUTING');
		}
		if(routingState.listOverflowDestination != null && routingState.listOverflowDestination.length!=0){
			this.data.setOverflowList(routingState.listOverflowDestination);
		}
		if(routingState.listForwardDestination != null && routingState.listForwardDestination.length!=0){
			this.data.setForwardList(routingState.listForwardDestination);
		}
		// Reload current displayed screen
		if ((this.data.getContainerPath() === "webapp.userservices.getRoutingContent" || this.data.getContainerPath() === "webapp.userservices.getOverflowContent") && this.data.mainWidget) {
			if(this.data.getContainerPath() == "webapp.userservices.getRoutingContent"){
				this.data.loadRoutingDetails();
			}else if(this.data.getContainerPath() == "webapp.userservices.getOverflowContent"){
				this.data.loadOverflowDetails();
			}
			this.data.mainWidget.reloadContainer();
		}
		routingState = null;
	},

	onClickProfile : function(index){
		var routingData = this.data.getRoutingData();
		var selectedProfile;
		for(var i in routingData) {
			if (routingData[i].intIndex === index) {
				routingData[i].boolSelected = true;
				selectedProfile = routingData[i];
			}
		}

		//if(!this.data.currentProfile || (selectedProfile.profileId!==this.data.currentProfile.profileId))
		//{
		if (selectedProfile) {
		switch(selectedProfile.intIndex)
		{
			case -2:
				// Case VOICEMAIL
				var forwardDestination = {
					forwardDestinationType: {
						type : "ForwardDestinationType",
						value : {
							value : this.data.FWD_DESTINATION_VOICEMAIL
						}
					},
					phoneNumber:null,
					isSelected:true,
					userInformation:null
				}
				ICTouchAPI.APIServices.Telephony.setRoutingForward({params: [forwardDestination], context: this})
				break;
			case -3:
				if(this.data.otherUserNumber){
					var forwardDestination = {
						forwardDestinationType: {
							type : "ForwardDestinationType",
							value : {
								value : this.data.FWD_DESTINATION_USER
							}
						},
						phoneNumber:this.data.otherUserNumber,
						isSelected:true,
						userInformation:null
					}
					ICTouchAPI.APIServices.Telephony.setRoutingForward({params: [forwardDestination], context: this})
				}else{
					this.data.onOtherSearch();
				}

				break;
			case 0:
				if(this.data.customRoute){
					this.data.boolCustomRoute = true;
					this.setCustomRoute(true);
				}else{
					// If no custom route, directly show details window to define it.
					this.loadProfileDetails(selectedProfile.intIndex);
				}
				break;
			default:
				var profileId = {id:selectedProfile.profileId}
				ICTouchAPI.APIServices.Telephony.activateRoutingProfile({params: [profileId], context: this})
				break;
		}
		}
		else {
			ICTouchAPI.debugServices.warning("webapp.userservices.controlBase - onClickProfile / could't select the specified entry as no profile was found with intIndex: " + index);
		}
		//}
		index = null;
	},

	onRequestProfile : function(){
		dojo.publish("ProfileChanged",[this.data.currentProfileLabel]);
	},

	onSelectUserDeviceRequest : function(){
		// Select the entry "User" of Routing Profile (used to enable ManagerAssistant Backup)
		this.onClickProfile(-3);
	},

	dump : function(boolAdvancedLogs) {
		this.inherited(arguments);
		ICTouchAPI.debugServices.dump("---------------------------------------------");
		ICTouchAPI.debugServices.dump("UserServices settings :");

		ICTouchAPI.debugServices.dump(" - EnableUserPresence: " + ((this.data._arrListEntries[this.data.PRESENCE_IM_SCREEN]!=null)?"true":"false"));
		ICTouchAPI.debugServices.dump(" - EnableRouting: " + ((this.data._arrListEntries[this.data.ROUTING_SCREEN]!=null)?"true":"false"));
		ICTouchAPI.debugServices.dump(" - EnableOverflow: " + ((this.data._arrListEntries[this.data.OVERFLOW_SCREEN]!=null)?"true":"false"));
		ICTouchAPI.debugServices.dump(" - EnableUserDetails: " + ((this.data._arrListEntries[this.data.USER_INFO_SCREEN]!=null)?"true":"false"));

		ICTouchAPI.debugServices.dump(" - AllowDirectCustomForward: " + (this.data.allowDirectCustomForward));
		ICTouchAPI.debugServices.dump(" - Bool VM Number: " + (this.data.boolVmNumber));
		ICTouchAPI.debugServices.dump(" - TelephonySimplifiedForward: " + ((this.data.boolSimplifiedForwardMode)?"true":"false"));
		ICTouchAPI.debugServices.dump(" - DndRequiresPassword: " + ((this.data.boolDndRequiresPassword)?"true":"false"));
		ICTouchAPI.debugServices.dump(" - TelephonyVmNumber: " + ((this.data.boolVmNumber)?"true":"false"));
		ICTouchAPI.debugServices.dump(" - EnableRoutingLed: " + ((this.data.boolRoutingLedActivated)?"true":"false"));

		ICTouchAPI.debugServices.dump(" - TelephonyAttendantNumber: " + this.data.telephonyAttendantNumber);
		ICTouchAPI.debugServices.dump(" - TelephonyAssociateNumber: " + this.data.telephonyAssociateNumber);
		ICTouchAPI.debugServices.dump(" - TelephonyMobileNumber: " + this.data.telephonyMobileNumber);
		ICTouchAPI.debugServices.dump(" - TelephonyVmNumber: " + this.data.telephonyVmNumber);
		ICTouchAPI.debugServices.dump(" - LatestNumbersCache: " + dojo.toJson(this.data.arrLatestNumbers));

		ICTouchAPI.debugServices.dump("---------------------------------------------");

		ICTouchAPI.debugServices.dump("Current Mode : " + this.data.currentMode);
		ICTouchAPI.debugServices.dump("Current Routing ID (currentRoutingID): " + this.data.currentRoutingID);
		if(this.data.currentRoutingLabel){
			if(this.data.currentRoutingLabel.isI18Ned){
				ICTouchAPI.debugServices.dump("Current Routing Label i18n (currentRoutingLabel): " + this.data.currentRoutingLabel.getTranslation());
			}else{
				ICTouchAPI.debugServices.dump("Current Routing Label (currentRoutingLabel): " + this.data.currentRoutingLabel);
			}
		}
		ICTouchAPI.debugServices.dump("Current Routing (currentRouting): " + dojo.toJson(this.data.currentRouting));
		ICTouchAPI.debugServices.dump("---------------------------------------------");
		ICTouchAPI.debugServices.dump("Current Overflow (currentOverflow): " + dojo.toJson(this.data.currentOverflow));
		ICTouchAPI.debugServices.dump("Current Profile (currentProfile): " + dojo.toJson(this.data.currentProfile));
		ICTouchAPI.debugServices.dump("Current Overflow Number (otherOverflowNumber): " + this.data.otherOverflowNumber);
		ICTouchAPI.debugServices.dump("Is Multi Device Routing Selection Activated ? : " + ((this.data.multiDeviceRoutingAvailability) ? "true" : "false"));

		if (boolAdvancedLogs) {
			ICTouchAPI.debugServices.dump("---------------------------------------------");
			ICTouchAPI.debugServices.dump("Advanced Logs");

			if(this.data._arrListEntries[this.data.PRESENCE_IM_SCREEN]!=null){
				ICTouchAPI.debugServices.dump("---------------------------------------------");
				ICTouchAPI.debugServices.dump(" - Presence Tab : ");
				var presenceData = this.data.getPresenceData();
				for(var presenceEntry in presenceData){
					ICTouchAPI.debugServices.dump("---------------------------------------------");
					ICTouchAPI.debugServices.dump(dojo.toJson(presenceData[presenceEntry]));
				}
			}
			if(this.data._arrListEntries[this.data.ROUTING_SCREEN]!=null){
				ICTouchAPI.debugServices.dump("---------------------------------------------");
				ICTouchAPI.debugServices.dump(" - Routing Tab : ");
				var routingData = this.data.getRoutingData();
				for(var routingEntry in routingData){
					ICTouchAPI.debugServices.dump("---------------------------------------------");
					ICTouchAPI.debugServices.dump(dojo.toJson(routingData[routingEntry]));
				}
			}
			if(this.data._arrListEntries[this.data.OVERFLOW_SCREEN]!=null){
				ICTouchAPI.debugServices.dump("---------------------------------------------");
				ICTouchAPI.debugServices.dump(" - Overflow Tab : ");
				var overflowData = this.data.getOverflowData();
				for(var overflowEntry in overflowData){
					ICTouchAPI.debugServices.dump("---------------------------------------------");
					ICTouchAPI.debugServices.dump(dojo.toJson(overflowData[overflowEntry]));
				}
			}
			if(this.data._arrListEntries[this.data.USER_INFO_SCREEN]!=null){
				ICTouchAPI.debugServices.dump("---------------------------------------------");
				ICTouchAPI.debugServices.dump(" - User Info Tab : ");
				var userinfoData = this.data.getUserInfoData();
				for(var infoEntry in userinfoData){
					ICTouchAPI.debugServices.dump("---------------------------------------------");
					ICTouchAPI.debugServices.dump(dojo.toJson(userinfoData[infoEntry]));
				}
			}

		}
	}
});

dojo.require("webapp.userservices.controlBase");
dojo.provide("webapp.userservices");
dojo.declare("webapp.userservices",webapp.userservices.controlBase,{


	// Called for the common buttonCallback of VHE and MR
	buttonCallback: function(buttonId) {
		switch(buttonId)
		{
			case this.data.BACK:
				switch(this.data._strContainerPath) {
					case "webapp.userservices.getRoutingAdd2Content" :
					case "webapp.userservices.getRoutingAdd1Content" :
						this.data.changeMode(this.data.NORMAL_MODE) ;
						this.data.loadRoutingDetails();
						break;
					case "webapp.userservices.getOverflowContent" :
						this.data.changeMode(this.data.NORMAL_MODE) ;
						this.data.loadOverflowDetails();
						if(webapp.communication && webapp.communication.data) {
							webapp.communication.setSelectStatus(-1);
							webapp.communication.updateAppBar();
						}
						dojo.publish("OpenHomepage");
						break;
					case "webapp.userservices.getRoutingContent" :
						this.data.changeMode(this.data.NORMAL_MODE) ;
						this.data.loadRoutingDetails();
						if(webapp.communication && webapp.communication.data) {
							webapp.communication.setSelectStatus(-1);
							webapp.communication.updateAppBar();
						}
						dojo.publish("OpenHomepage");
						break;
					case "webapp.userservices.getProfileDetails" :
						this.setCustomRoute(false);
						break;
					default :
						if(webapp.communication && webapp.communication.data) {
							webapp.communication.setSelectStatus(-1);
							webapp.communication.updateAppBar();
						}
						dojo.publish("OpenHomepage");
						break;
				}
				break;
			case this.data.ADD_ROUTING:
				if(this.data.currentMode === this.data.DELETE_MODE || this.data.currentMode === this.data.MODIFY_MODE){
				    this.data.changeMode(this.data.NORMAL_MODE);
				}
				this.data.currentRouting = {};
				this.data.loadRoutingTypeDetails();
				break;
			case this.data.MODIFY_ROUTING:
				this.data.changeMode((this.data.currentMode === this.data.MODIFY_MODE) ? this.data.NORMAL_MODE : this.data.MODIFY_MODE);
				this.data.loadRoutingDetails();
				break;
			case this.data.DELETE_ROUTING:
				this.data.changeMode((this.data.currentMode === this.data.DELETE_MODE) ? this.data.NORMAL_MODE : this.data.DELETE_MODE);
				this.data.loadRoutingDetails();
				break;
			case this.data.NEXT:
				this.data.loadRoutingDestinationDetails();
				break;
			case this.data.SAVE:
				ICTouchAPI.settingServices.getSettingValue("RoutingList", this.data, this.data.saveRoutingList);
				break;
			case this.data.CUSTOM:
				ICTouchAPI.keyboardServices.deployKeyboard(ICTouchAPI.KeyboardTypes.ALPHANUM, null,{strDefaultText: this.data.objCurrentPresenceStatus.message, funcCallbackOk: this.callbackCustomOk});
				break;
			case this.data.DND:
				this.launchDndActivation();
				break;
			case this.data.SR_SAVE:
				ICTouchAPI.APIServices.ICTSaveRestore.save();
				break;
			case this.data.SR_RESTORE:
				ICTouchAPI.APIServices.ICTSaveRestore.restore();
				break;
			case this.data.LOGIN:
				ICTouchAPI.APIServices.IctUser.login();
				break;
			case this.data.SUPERVISION:
				ICTouchAPI.APIServices.Telephony.loginLogoffSupervision({});
				break;
			case this.data.HIDE_IDENTITY:
				// Update the button status immediately to have a quick response on the UI
				this.data.setHideUserIdentityButtonStatus(!this.data.getHideIdentityState());
				// Call core application method
				ICTouchAPI.APIServices.Telephony.modifyHideIdentity({params:[!this.data.getHideIdentityState()]});
				// Set a spinner during the CLIR activation/deactivation as it take some time.
				this.data.createClirSpinner();
				// Set a security for if call fails and we don't get an answer
				this.data.hresetButtonStatus = setTimeout(function() {webapp.userservices.data.setHideUserIdentityButtonStatus(webapp.userservices.data.getHideIdentityState());}, 5000);
				break;
			default :
				break;
		}
		buttonId = null;
	}
});

webapp.userservices = new webapp.userservices();
dojo.provide("webapp.userservices.dataBase");
dojo.declare("webapp.userservices.dataBase", null, {

	_arrAppButtons                  : [], //Buttons definition
	_arrAppBarSkeleton				: [], //Appbar definition - order button
	_strUserServiceContainerTitle   : "",
	_strUserServiceListTitle        : _("User service", "webapp.userservices"),
	_strContainerPath               : "",
	_arrListEntries                 : [], //Entry tabs in the MenuList
	_arrAllDetails                  : [],  // 2-dimensions array
	_arrProfilesSummaryList			: [],
	_arrOverflowList				: [],
	_arrForwardList					: null,
	objUserServiceContent           : null,
	objContent						: null,
	objListUI                       : null,
	objDetailsScreen				: null,
	intSelectListItem               : (-1),
	dndButtonStatus					: false,
	dndAvailability					: true,
	objPopup						: null,
	objCurrentPresenceStatus		: {
		idIMStatus: -1,
		message:""
	},
	objLastPresenceStatus			: {
		idIMStatus: -1,
		message:""
	},
	intPKArgs						: null,
	_nextPKButton					: null,

	//  Widgets and others DOM Elements
	PKWidget				: null,
	mainWidget				: null,
	widgetProfileDetails	: null,

	// The current mode : normal, modify routing or delete routing
	currentMode						: 0,
	NORMAL_MODE						: 0,
	MODIFY_MODE						: 1,
	DELETE_MODE						: 2,

	// Full forward (add, modify...) : false, or simplified (just 3 choices) : true
	boolSimplifiedForwardMode		: false,
	allowDirectCustomForward		: false,
	boolDndRequiresPassword			: false,
	boolVmNumber					: false,

	objPopupConfirmDND 			: null,
	boolLockDNDPopup 			: false,

	accessRightToUserServices		: true,
	boolIMAvailabilityChanged		: false,
	isVMSelected					: false,
	boolCustomRoute					: false,
	boolForwardSet					: false,
	isLocalVideoEnabled				: false,

	currentRoutingID				: -2,
	currentRoutingLabel				: "",
	currentRouting					: {},
	currentOverflow					: {},
	currentProfile					: {},
	currentProfileLabel				: "",
	otherRoutingNumber				: null,
	otherRoutingNumberIsDialable			: null,
	otherOverflowNumber				: null,
	otherOverflowNumberNoReply			: null,
	otherOverflowUser				: null,
	otherOverflowUserNoReply			: null,
	currentOverflowType				: null,
	currentUserInfo					: "",
	currentProfileId				: "",
	otherUserNumber					: null,
	customRoute						: null,

	//Capability
	multiDeviceRoutingAvailability : false,

	// Status Icons for appButtons
	STATUS_ON_ICON			: 'notif-on',
	STATUS_OFF_ICON			: 'notif-off',

	// Contact addressMap keys constants managed by UserServices
	ADDRESSKEY_MAINPHONE    : "Phone",
	ADDRESSKEY_MOBILEPHONE  : "Mobile",
	ADDRESSKEY_EXTRAPHONE   : "Other phone",

	// Constants for routing
	NONE					: "None",
	FWD_UNCONDITIONAL		: "FWD_UNCONDITIONAL",
	FWD_ON_BUSY_OR_NO_REPLY : "FWD_ON_BUSY_OR_NO_REPLY",
	DST_VOICEMAIL			: "DST_VOICE_MAIL",
	DST_OTHER				: "Other",
	DST_UNDEFINED			: "DST_UNDEFINED",
	DST_ATTENDANT			: "DST_ATTENDANT",
	DST_ASSOCIATE			: "DST_ASSOCIATE",
	DST_MOBILE				: "DST_MOBILE",
	DST_USER				: "DST_USER",
	IMMEDIATE_CUSTOM		: "FWD_UNCONDITIONAL;%s",


	OVF_NONE					:"OVF_NONE",
	OVF_ON_NO_REPLY				:"OVF_ON_NO_REPLY",
	OVF_ON_BUSY					:"OVF_ON_BUSY",
	OVF_ON_BUSY_OR_NO_REPLY		:"OVF_ON_BUSY_OR_NO_REPLY",
	OVF_UNKNOWN_TYPE			:"OVF_UNKNOWN_TYPE",

	OVF_DESTINATION_UNKNOWN		:"OVF_DESTINATION_UNKNOWN",
	OVF_DESTINATION_VOICEMAIL	:"OVF_DESTINATION_VOICEMAIL",
	OVF_DESTINATION_USER		:"OVF_DESTINATION_USER",
	OVF_DESTINATION_NUMBER		:"OVF_DESTINATION_NUMBER",

	FWD_DESTINATION_VOICEMAIL	:"FWD_DESTINATION_VOICEMAIL",
	FWD_DESTINATION_USER		:"FWD_DESTINATION_USER",

	// constant values for subscreen ids ( MUST be sequential )
	PRESENCE_IM_SCREEN		: 0,
	ROUTING_SCREEN			: 1,
	OVERFLOW_SCREEN			: 2,
	USER_INFO_SCREEN		: 3,
	ADD_ROUTING_1_SCREEN	: 4,
	ADD_ROUTING_2_SCREEN	: 5,
	ADD_OVERFLOW_1_SCREEN	: 6,
	ADD_OVERFLOW_2_SCREEN	: 7,
	PROFILE_DETAILS_SCREEN	: 8,
	VIDEO_SCREEN			: 9,
	NB_STATUS				: 10,

	// Constant values for the button's id
	BACK			: "BACK_BTN",
	ADD_ROUTING		: "ADD_ROUTING_BTN",
	MODIFY_ROUTING	: "MODIFY_ROUTING_BTN",
	DELETE_ROUTING	: "DELETE_ROUTING_BTN",
	CUSTOM			: "CUSTOM_BTN",
	DND				: "DND_BTN",
	SR_SAVE			: "SR_SAVE_BTN",
	SR_RESTORE		: "SR_RESTORE_BTN",
	NEXT			: "NEXT_BTN",
	SAVE			: "SAVE_BTN",
	YES				: "YES_BTN",
	NO				: "NO_BTN",
	LOGIN			: "LOGIN_BTN",
	SUPERVISION		: "SUPERVISION_BTN",
	HIDE_IDENTITY	: "HIDE_IDENTITY_BTN",

	// LEDS and LEDS STATUS
	LED_USERSERVICE : 4,
	LED_STATUS_OFF : 0,
	LED_STATUS_ON  : 1,

	//Constant list of device types
	DEVICE_OFFICE	: "OFFICE_DEVICE",
	DEVICE_MOBILE	: "MOBILE_DEVICE",
	DEVICE_PC		: "PERSONAL_COMPUTER_DEVICE",
	DEVICE_TABLET	: "TABLET_DEVICE",
	DEVICE_VIDEO	: "VIDEO_DEVICE",
	DEVICE_HOME		: "HOME_DEVICE",
	DEVICE_OTHER	: "OTHER_DEVICE",
	DEVICE_VM		: "VOICEMAIL_DEVICE",
	DEVICE_USER		: "USER_DEVICE",
	DEVICE_UNKNOWN	: "DEVICE_TYPE_UNKNOWN",

	//Cache numbers
	telephonyAttendantNumber : null,
	telephonyAssociateNumber : null,
	telephonyMobileNumber : null,
	telephonyVmNumber : null,
	arrLatestNumbers : [],
	_tempCacheNumber : null,
	currentAvailableDevices : [],
	objRoutingState : null,
	lastIsRoutingTarget : null,
	boolIsGetRoutingProfilesMade : false,
	boolMutex : false,
	waitingProfiles : [],

	// Hide identity
	hideIdentityStatus : true,
	hideIdentityBarringRule : null,
	hresetButtonStatus : null,
	hCLIRSpinner : null,
	objCLIRSpinner : null,
	/*
	 * Filled by allowedValues of setting TelephonyHideIdentityBarringRule : 
	 */
	lstHideIdentityBarringRules : {},
	
	// Supervision hidden state
	_supervisionHiddenState : null,

	constructor : function(){
		var func = dojo.hitch(webapp.userservices, webapp.userservices.buttonCallback);
		
		this._supervisionHiddenState = ICTouchAPI.supervisionServices.getSupervisionHidden();
		dojo.subscribe("supervision.hiddenStateChanged", this, function(boolState){
			this._supervisionHiddenState = boolState;
			// If user info was the displayed entry, reload it to update the status.
			if(this._strContainerPath == "webapp.userservices.getUserInfoContent"){
				ICTouchAPI.debugServices.debug("webapp.userservices.dataBase / supervision hidden state changed: reload user info card");
				this.loadUserInfoDetails();
			}
		});
		
		//Definition of all buttons
		this._arrAppButtons[this.CUSTOM] = {
			strButtonName: this.CUSTOM,
			strButtonLabel: _("Custom", "webapp.userservices"),
			strButtonIcon: 'generic-modify',
			strStatusText:'',
			strStatusIcon:'',
			callback: func
		}
		this._arrAppButtons[this.ADD_ROUTING] = {
			strButtonName: this.ADD_ROUTING,
			strButtonLabel: _('Add', 'ICTouchAPI'),
			strButtonIcon: 'generic-add',
			strStatusText:'',
			strStatusIcon:'',
			callback: func
		}
		this._arrAppButtons[this.MODIFY_ROUTING] = {
			strButtonName: this.MODIFY_ROUTING,
			strButtonLabel: _('Modify', 'ICTouchAPI'),
			strButtonIcon: 'generic-modify',
			strStatusText:'',
			strStatusIcon: 'notif-off',
			callback: func
		}
		this._arrAppButtons[this.DELETE_ROUTING] = {
			strButtonName: this.DELETE_ROUTING,
			strButtonLabel: _('Delete', 'ICTouchAPI'),
			strButtonIcon: 'generic-mode-delete',
			strStatusText:'',
			strStatusIcon:'notif-off',
			callback: func
		}
		this._arrAppButtons[this.NEXT] = {
			strButtonName: this.NEXT,
			strButtonLabel: _('Next', 'ICTouchAPI'),
			strButtonIcon: 'generic-next',
			strStatusText:'',
			strStatusIcon:'',
			callback: func
		}
		this._arrAppButtons[this.SAVE] = {
			strButtonName: this.SAVE,
			strButtonLabel: _("Save", "ICTouchAPI"),
			strButtonIcon: 'generic-save',
			strStatusText:'',
			strStatusIcon:'',
			callback: func
		}
		this._arrAppButtons[this.LOGIN] = {
			strButtonName: this.LOGIN,
			strButtonLabel: _("Login", "webapp.userservices"),
			strButtonIcon: 'admin-application',
			strStatusText:'',
			strStatusIcon:'',
			callback: func,
			arrCapabilities: [{
				module : "WSManager",
				capability : "WSLoginAvailable"
			}]
		}
		this._arrAppButtons[this.SUPERVISION] = {
			strButtonName: this.SUPERVISION,
			strButtonLabel: _("Supervision", "webapp.userservices"),
			strButtonIcon: 'supervision-application',
			strStatusText: '',
			strStatusIcon: this.STATUS_OFF_ICON,
			callback: func,
			arrCapabilities: [{
				module : "Telephony",
				capability : "isLogSupervisionAllowed"
			}]
		}
		this._arrAppButtons[this.DND] = {
			strButtonName: this.DND,
			strButtonLabel: _("DND", "webapp.userservices"),
			strButtonIcon: 'communication-do-not-disturb',
			strStatusText:'',
			strStatusIcon:'',
			callback: func,
			arrCapabilities: [{
				module : "Telephony",
				capability : "allowDnd"
			}]
		}
		this._arrAppButtons[this.SR_SAVE] = {
			strButtonName: this.SR_SAVE,
			strButtonLabel: _("Save", "ICTouchAPI"),
			strButtonIcon: 'generic-save',
			strStatusText:'',
			strStatusIcon:'',
			callback: func,
			arrCapabilities: [{
				module : "ICTSaveRestore",
				capability : "SAVE_RESTORE_ENABLE"
			}]
		}
		this._arrAppButtons[this.SR_RESTORE] = {
			strButtonName: this.SR_RESTORE,
			strButtonLabel: _("Restore", "webapp.userservices"),
			strButtonIcon: 'generic-next',
			strStatusText:'',
			strStatusIcon:'',
			callback: func,
			arrCapabilities: [{
				module : "ICTSaveRestore",
				capability : "SAVE_RESTORE_ENABLE"
			}]
		}
		this._arrAppButtons[this.HIDE_IDENTITY] = {
			strButtonName: this.HIDE_IDENTITY,
			strButtonLabel: _("CLIR", "webapp.userservices"),
			strButtonIcon: 'generic-anonymous',
			strStatusText:'',
			strStatusIcon: this.STATUS_OFF_ICON,
			callback: func
		}


		this._arrAppBarSkeleton[this.PRESENCE_IM_SCREEN] = [this.CUSTOM,"MAGNIFY","homepageBtnHelp"];
		this._arrAppBarSkeleton[this.ROUTING_SCREEN] = [this.ADD_ROUTING,this.MODIFY_ROUTING,this.DELETE_ROUTING,"MAGNIFY","homepageBtnHelp"];
		this._arrAppBarSkeleton[this.OVERFLOW_SCREEN] = [this.ADD_ROUTING,this.MODIFY_ROUTING,this.DELETE_ROUTING,"MAGNIFY","homepageBtnHelp"];
		this._arrAppBarSkeleton[this.USER_INFO_SCREEN] = [this.LOGIN,this.SUPERVISION,this.HIDE_IDENTITY,this.DND,this.SR_SAVE,this.SR_RESTORE,"MAGNIFY","homepageBtnHelp"];
		this._arrAppBarSkeleton[this.ADD_ROUTING_1_SCREEN] = [this.NEXT,"MAGNIFY","homepageBtnHelp"];
		this._arrAppBarSkeleton[this.ADD_ROUTING_2_SCREEN] = [this.SAVE,"MAGNIFY","homepageBtnHelp"];
		this._arrAppBarSkeleton[this.ADD_OVERFLOW_1_SCREEN] = [this.NEXT,"MAGNIFY","homepageBtnHelp"];
		this._arrAppBarSkeleton[this.VIDEO_SCREEN] = [];
		this._arrAppBarSkeleton[this.ADD_OVERFLOW_2_SCREEN] = [this.SAVE,"MAGNIFY","homepageBtnHelp"];
		this._arrAppBarSkeleton[this.PROFILE_DETAILS_SCREEN] = ["MAGNIFY","homepageBtnHelp"];

		var backFunc={
			context: webapp.userservices,
			func: webapp.userservices.buttonCallback,
			param: this.BACK
		};

		for(var i in this._arrAppBarSkeleton){
			var appBar = ICTouchAPI.AppBarServices.createAppBar("userservices", "userservicesstatus" + i , this._arrAppBarSkeleton[i]);
			// Create the static back button
			ICTouchAPI.AppBarServices.addExitButton("userservices", "userservicesstatus" + i, true, backFunc);
			for(var j in this._arrAppBarSkeleton[i]){
				var currentBtn = this._arrAppBarSkeleton[i][j];
				//Button from communication webapp
				if(this._arrAppButtons[currentBtn]){
					var objButton = new UIElements.AppButton.AppButtonControl(this._arrAppButtons[currentBtn]);
					appBar.addAppButton(objButton,false);
				//Button from other webapps
				}else{
					appBar.addAppButton(currentBtn,false);
				}
			}
			appBar.buildDom();
		}
	},


	// Called when we click on "presence" in the menuList
	loadPresenceDetails : function() {
		// Set data
		this._strUserServiceContainerTitle =  _("Select your presence", "webapp.userservices");
		if (this._arrAllDetails[this.PRESENCE_IM_SCREEN] && this._arrAllDetails[this.PRESENCE_IM_SCREEN].length !== 0) {
			this.switchContainer("getPresenceContent",this.PRESENCE_IM_SCREEN,this._strUserServiceContainerTitle);
			return null;
		}
		this._arrAllDetails[this.PRESENCE_IM_SCREEN] = [];
		ICTouchAPI.APIServices.InstantMessaging.getAvailableStatuses({
			params :[],
			context : this,
			callback : this.loadedPresenceDetails
		});
	},


	// Callback of getAvailableStatuses
	loadedPresenceDetails: function(_arr) {
		var objPresence = null;
		if (_arr && _arr.length !== 0) {
			for (var i in _arr) {
				objPresence = _arr[i];
				if (objPresence) {
					objPresence.labelStatus=ICTouchAPI.tools.getPresenceLabel(objPresence.labelStatus);
					this._arrAllDetails[this.PRESENCE_IM_SCREEN].push({
						strLabel: _(objPresence.labelStatus, "webapp.userservices"),
						intIndex: objPresence.idStatus,
						itemId: objPresence.idStatus,
						strSecondaryContentIcon : ICTouchAPI.tools.getPresenceIconPath(objPresence.labelStatus, "32")
					});
				}
			}
		}
		this.switchContainer("getPresenceContent",this.PRESENCE_IM_SCREEN,this._strUserServiceContainerTitle);
		_arr = null;
	},

	// Called when we click on "routing" in the menuList
	loadRoutingDetails : function() {
		if(this.hRoutingDetailsReload){
			clearTimeout(this.hRoutingDetailsReload);
		}
		switch(this.currentMode) {
			case this.NORMAL_MODE :
				if(!this.getMultiDeviceRoutingAvailability()){
					this._strUserServiceContainerTitle = _("Select your routing", "webapp.userservices");
				}else{
					this._strUserServiceContainerTitle = _("Select your profile", "webapp.userservices");
				}
				break;
			case this.MODIFY_MODE :
				this._strUserServiceContainerTitle = _("Modify your routing", "webapp.userservices");
				break;
			case this.DELETE_MODE :
				this._strUserServiceContainerTitle = _("Delete your routing", "webapp.userservices");
				break;
		}
		// Set data
		this._strContainerPath = "webapp.userservices.getRoutingContent";
		this.intSelectListItem = this.ROUTING_SCREEN;
		this._arrAllDetails[this.ROUTING_SCREEN] = [];

		var currentProfileId = (this.currentProfile.profileId)? this.currentProfile.profileId.value.id: null;

		//Build list for multi device routing selection
		if(this.getMultiDeviceRoutingAvailability()){
			if(this.currentMode === this.NORMAL_MODE) {
				//First entry : Custom
				var select;
				if(this.boolForwardSet){
					select = false;
				}else{
					if("CUSTOM"==currentProfileId){
						select = true;
					}else{
						select = false;
					}
				}
				
				if(this._arrForwardList!=null){
					//First : VM entry
					var vmEntry = false;
					for(var forward in this._arrForwardList){
						if(this._arrForwardList[forward].forwardDestinationType.value.value == this.FWD_DESTINATION_VOICEMAIL){
							vmEntry = this._arrForwardList[forward].isSelected;
						}
					}
					if(this.boolVmNumber){
						var entry = this.buildForwardToVoicemailElement("PROFILE");
						entry.boolSelected = vmEntry;
						this._arrAllDetails[this.ROUTING_SCREEN].push(entry);
					}

					
				
					//Second : User entry
					var userEntry = false;
					for(var forward in this._arrForwardList){
						if(this._arrForwardList[forward].forwardDestinationType.value.value == this.FWD_DESTINATION_USER){
							if(this.isUserInfoNotEmpty(this._arrForwardList[forward])){
								this.currentUserInfo = ICTouchAPI.tools.getContactDisplayName(this._arrForwardList[forward].userInformation.value);
								this.otherUserNumber = this._arrForwardList[forward].userInformation.value.phoneNumber;
								userEntry = this._arrForwardList[forward].isSelected;
							}
						}
					}
					//var label = ICTouchAPI.tools.formatRoutingLabel(this._arrForwardList[forward].forwardDestinationType.value.value, userInfo, null, false);
					this._arrAllDetails[this.ROUTING_SCREEN].push({
						intIndex: -3,
						strLabel: _(["USER_DEVICE", "("+this.currentUserInfo+")"],"webapp.userservices"),
						boolSelected : ((this.boolForwardSet) ? userEntry : false),
						strDest: this._arrForwardList[forward].forwardDestinationType.value.value,
						strSecondaryContentIcon : "communication-routing-generic-32",
						strActionIcon : "userservices-more",
						itemCallback: webapp.userservices.onClickProfile
					});
				}

				//Second : Default
				for(var profile in this._arrProfilesSummaryList){
					if(this._arrProfilesSummaryList[profile].profileName=="DEFAULT"){
						this._arrAllDetails[this.ROUTING_SCREEN].push({
							intIndex: 1,
							profileId : this._arrProfilesSummaryList[profile].profileId.value.id,
							boolSelected : (this._arrProfilesSummaryList[profile].profileId.value.id==currentProfileId),
							strLabel: (this._arrProfilesSummaryList[profile].profileName!="") ? _(this._arrProfilesSummaryList[profile].profileName,"webapp.userservices") : _(this._arrProfilesSummaryList[profile].profileId.value.id,"webapp.userservices"),
							strSecondaryContentIcon : "communication-routing-generic-32",
							strActionIcon : "userservices-more",
							itemCallback: webapp.userservices.onClickProfile,
							buttonCallback : webapp.userservices.loadProfileDetails,
							buttonCallbackParams : {
								id : this._arrProfilesSummaryList[profile].profileId.value.id
							}
						});
					}
					if(this._arrProfilesSummaryList[profile].profileId.value.id==currentProfileId){
						for(var routing in this._arrAllDetails[this.ROUTING_SCREEN]){
							if(this._arrAllDetails[this.ROUTING_SCREEN][routing].intIndex == -3 || this._arrAllDetails[this.ROUTING_SCREEN][routing].intIndex == -2){
								this._arrAllDetails[this.ROUTING_SCREEN][routing].boolSelected = false;
							}
						}

					}
				}

				this._arrAllDetails[this.ROUTING_SCREEN].push({
					intIndex: 0,
					profileId : "CUSTOM",
					boolSelected : select,
					strLabel: _("CUSTOM","webapp.userservices"),
					strSecondaryContentIcon : "communication-routing-generic-32",
					strActionIcon : "userservices-more",
					itemCallback: webapp.userservices.onClickProfile,
					buttonCallback : webapp.userservices.loadProfileDetails,
					buttonCallbackParams : {
						id : "CUSTOM"
					}
				});
				
				if(select){
					for(var routing in this._arrAllDetails[this.ROUTING_SCREEN]){
						if(this._arrAllDetails[this.ROUTING_SCREEN][routing].intIndex == -3 || this._arrAllDetails[this.ROUTING_SCREEN][routing].intIndex == -2){
							this._arrAllDetails[this.ROUTING_SCREEN][routing].boolSelected = false;
						}
					}

				}

				//Others profiles
				var index = 2;
				for(var profile in this._arrProfilesSummaryList){
					if(this._arrProfilesSummaryList[profile].profileName!="DEFAULT" && this._arrProfilesSummaryList[profile].profileName!="CUSTOM"){
						this._arrAllDetails[this.ROUTING_SCREEN].push({
							intIndex: index,
							profileId:this._arrProfilesSummaryList[profile].profileId.value.id,
							boolSelected : (this._arrProfilesSummaryList[profile].profileId.value.id==currentProfileId),
							strLabel: (this._arrProfilesSummaryList[profile].profileName!="") ? _(this._arrProfilesSummaryList[profile].profileName,"webapp.userservices") : _(this._arrProfilesSummaryList[profile].profileId.value.id,"webapp.userservices"),
							strSecondaryContentIcon : "communication-routing-generic-32",
							strActionIcon : "userservices-more",
							itemCallback: webapp.userservices.onClickProfile,
							buttonCallback : webapp.userservices.loadProfileDetails,
							buttonCallbackParams : {
								id : this._arrProfilesSummaryList[profile].profileId.value.id
							}
						});
						index++;
					}
					if(this._arrProfilesSummaryList[profile].profileId.value.id==currentProfileId){
						for(var routing in this._arrAllDetails[this.ROUTING_SCREEN]){
							if(this._arrAllDetails[this.ROUTING_SCREEN][routing].intIndex == -3 || this._arrAllDetails[this.ROUTING_SCREEN][routing].intIndex == -2){
								this._arrAllDetails[this.ROUTING_SCREEN][routing].boolSelected = false;
							}
						}

					}
				}
				this.switchContainer("getRoutingContent",this.ROUTING_SCREEN, this.getUserServiceContainerTitle());
			}
		}else{//Build list of routing R200
			if(this.currentMode === this.NORMAL_MODE) {
				this._arrAllDetails[this.ROUTING_SCREEN].push({
					intIndex: 0,
					strTrigger: this.NONE,
					strLabel: _("My office phone", "webapp.userservices"),
					strSecondaryContentIcon : "empty-to-align-text", //not an icon but it's used to align the text with all the others
					itemCallback: webapp.userservices.onClickRouting
				});
				if(this.getAllowDirectCustomForward()){
					this._arrAllDetails[this.ROUTING_SCREEN].push({
						intIndex: -1,
						strTrigger: this.FWD_UNCONDITIONAL,
						strDest: this.DST_OTHER,
						strLabel: _("Immediate forward to...", "webapp.userservices"),
						strSecondaryContentIcon : "communication-routing-generic-32",
						itemCallback: webapp.userservices.onClickRouting
					});
					// We add immediate forward to voicemail only if a number is defined in ths setting
					if(this.boolVmNumber){
						this._arrAllDetails[this.ROUTING_SCREEN].push(this.buildForwardToVoicemailElement("ROUTING"));
					}
				}
			}
			if(!this.boolSimplifiedForwardMode) {
				// call function _loadedRoutingList in a callback
				ICTouchAPI.settingServices.getSettingValue("RoutingList", this, this._loadedRoutingList);
			} else {
				this._loadedRoutingList();
			}
			
		}
	},

	buildFakeOverflow : function(type,destination){
		var fEntry = {
			overflowType : type,
			targetType : destination,
			phoneNumber : "",
			isSelected : 0,
			userInformation : {
				type : "UserInformation",
				value : {
					phoneNumber : "",
					login : "",
					name : "",
					firstName : ""
				}
			}
		}
		return fEntry;
	},

	// Called when we click on "overflow" in the menuList
	loadOverflowDetails : function() {
		switch(this.currentMode) {
			case this.NORMAL_MODE :
				this._strUserServiceContainerTitle = _("Select your overflow", "webapp.userservices");
				break;
			case this.MODIFY_MODE :
				this._strUserServiceContainerTitle = _("Modify your overflow", "webapp.userservices");
				break;
			case this.DELETE_MODE :
				this._strUserServiceContainerTitle = _("Delete your overflow", "webapp.userservices");
				break;
		}
		// Set data
		this._strContainerPath = "webapp.userservices.getOverflowContent";
		this.intSelectListItem = this.OVERFLOW_SCREEN;
		this._arrAllDetails[this.OVERFLOW_SCREEN] = [];


		if(this.currentMode === this.NORMAL_MODE) {
			this._arrAllDetails[this.OVERFLOW_SCREEN].push({
				intIndex: 0,
				strTrigger: this.NONE,
				boolSelected : true,
				strLabel: _("No overflow", "webapp.userservices"),
				strSecondaryContentIcon : "empty-to-align-text", //not an icon but it's used to align the text with all the others
				itemCallback: webapp.userservices.onClickOverflow
			});
		}

		var availableOverflow = [];
		availableOverflow["NUMBER"] = [];
		availableOverflow["VM"] = [];
		availableOverflow["USER"] = [];
		for(var overflow in this._arrOverflowList){
			if(this._arrOverflowList[overflow].targetType == this.OVF_DESTINATION_USER){
				if(this._arrOverflowList[overflow].overflowType == "OVF_ON_NO_REPLY"){
					availableOverflow["USER"]["OVF_ON_NO_REPLY"] = this._arrOverflowList[overflow];
					availableOverflow["USER"]["OVF_ON_BUSY_OR_NO_REPLY"] = this.buildFakeOverflow("OVF_ON_BUSY_OR_NO_REPLY","OVF_DESTINATION_USER");
				}else{
					availableOverflow["USER"]["OVF_ON_NO_REPLY"] = this.buildFakeOverflow("OVF_ON_NO_REPLY","OVF_DESTINATION_USER");
					availableOverflow["USER"]["OVF_ON_BUSY_OR_NO_REPLY"] = this._arrOverflowList[overflow];
				}
			}else if(this._arrOverflowList[overflow].targetType == this.OVF_DESTINATION_VOICEMAIL){
				if(this._arrOverflowList[overflow].overflowType == "OVF_ON_NO_REPLY"){
					availableOverflow["VM"]["OVF_ON_NO_REPLY"] = this._arrOverflowList[overflow];
					availableOverflow["VM"]["OVF_ON_BUSY_OR_NO_REPLY"] = this.buildFakeOverflow("OVF_ON_BUSY_OR_NO_REPLY","OVF_DESTINATION_VOICEMAIL");
				}else{
					availableOverflow["VM"]["OVF_ON_NO_REPLY"] = this.buildFakeOverflow("OVF_ON_NO_REPLY","OVF_DESTINATION_VOICEMAIL");
					availableOverflow["VM"]["OVF_ON_BUSY_OR_NO_REPLY"] = this._arrOverflowList[overflow];
				}
			}else if(this._arrOverflowList[overflow].targetType == this.OVF_DESTINATION_NUMBER){
				if(this._arrOverflowList[overflow].overflowType == "OVF_ON_NO_REPLY"){
					availableOverflow["NUMBER"]["OVF_ON_NO_REPLY"] = this._arrOverflowList[overflow];
					availableOverflow["NUMBER"]["OVF_ON_BUSY_OR_NO_REPLY"] = this.buildFakeOverflow("OVF_ON_BUSY_OR_NO_REPLY","OVF_DESTINATION_NUMBER");
				}else{
					availableOverflow["NUMBER"]["OVF_ON_NO_REPLY"] = this.buildFakeOverflow("OVF_ON_NO_REPLY","OVF_DESTINATION_NUMBER");
					availableOverflow["NUMBER"]["OVF_ON_BUSY_OR_NO_REPLY"] = this._arrOverflowList[overflow];
				}
			}
		}

		var entry = null;

		//Entry If no reply to VM
		if(availableOverflow["VM"]["OVF_ON_NO_REPLY"]!=null){
			if(this.boolVmNumber){
				entry = this.buildForwardToVoicemailElement("OVERFLOWBIS");
			}
		}
		if(entry){
			//if(availableOverflow["VM"]["OVF_ON_NO_REPLY"].overflowType == "OVF_ON_NO_REPLY"){
				entry.boolSelected = availableOverflow["VM"]["OVF_ON_NO_REPLY"].isSelected;
				if(entry.boolSelected){
					for(var i in this._arrAllDetails[this.OVERFLOW_SCREEN]){
						if(this._arrAllDetails[this.OVERFLOW_SCREEN][i].intIndex == 0){
							this._arrAllDetails[this.OVERFLOW_SCREEN][i].boolSelected = false;
							break;
						}
					}
				}
			//}
			this._arrAllDetails[this.OVERFLOW_SCREEN].push(entry);
		}
		entry = null;

		var label = null;
		if((availableOverflow["USER"]["OVF_ON_NO_REPLY"]!=null && availableOverflow["USER"]["OVF_ON_NO_REPLY"].isSelected)  ||
			(availableOverflow["NUMBER"]["OVF_ON_NO_REPLY"]!=null && availableOverflow["NUMBER"]["OVF_ON_NO_REPLY"].isSelected)){
			if(availableOverflow["USER"]["OVF_ON_NO_REPLY"]!=null && availableOverflow["USER"]["OVF_ON_NO_REPLY"].isSelected){
				if(this.isUserInfoNotEmpty(availableOverflow["USER"]["OVF_ON_NO_REPLY"])){
					label = ICTouchAPI.tools.getContactDisplayName(availableOverflow["USER"]["OVF_ON_NO_REPLY"].userInformation.value);
					this.otherOverflowUserNoReply = availableOverflow["USER"]["OVF_ON_NO_REPLY"].userInformation.value;
					this.otherOverflowNumberNoReply = null;
				}
				entry = {
					intIndex: -11,
					strTrigger: this.NONE,
					strLabel: _(["OVF_ON_NO_REPLY"," ("+label+")"], "webapp.userservices"),
					strSecondaryContentIcon : "empty-to-align-text", //not an icon but it's used to align the text with all the others
					itemCallback: webapp.userservices.onClickOverflow,
					strActionIcon : "userservices-more",
					buttonCallback : webapp.userservices.editOverflowNumber,
					boolSelected :availableOverflow["USER"]["OVF_ON_NO_REPLY"].isSelected,
					buttonCallbackParams : {
						id : -11
					}
				}
			}else if(availableOverflow["NUMBER"]["OVF_ON_NO_REPLY"]!=null && availableOverflow["NUMBER"]["OVF_ON_NO_REPLY"].isSelected){
				if(availableOverflow["NUMBER"]["OVF_ON_NO_REPLY"].phoneNumber!="" && availableOverflow["NUMBER"]["OVF_ON_NO_REPLY"].isSelected){
					var objContact = ICTouchAPI.dataStoreServices.getStore('contacts').find(["officePhone", "personalHome", "personalMobile","officePhoneCan", "personalHomeCan", "personalMobileCan", "personalFax"],availableOverflow["NUMBER"]["OVF_ON_NO_REPLY"].phoneNumber)[0];
					if(objContact){
						label = _(["OVF_ON_NO_REPLY"," ("+objContact.name+" "+objContact.firstName+")"], "webapp.userservices");
					}else{
						label = _(["OVF_ON_NO_REPLY"," ("+availableOverflow["NUMBER"]["OVF_ON_NO_REPLY"].phoneNumber+")"], "webapp.userservices");
					}
					this.otherOverflowUserNoReply = null;
					this.otherOverflowNumberNoReply = availableOverflow["NUMBER"]["OVF_ON_NO_REPLY"].phoneNumber;
				}
				entry = {
					intIndex: -11,
					strTrigger: this.NONE,
					strLabel: label,
					strSecondaryContentIcon : "empty-to-align-text", //not an icon but it's used to align the text with all the others
					itemCallback: webapp.userservices.onClickOverflow,
					strActionIcon : "userservices-more",
					buttonCallback : webapp.userservices.editOverflowNumber,
					boolSelected :availableOverflow["NUMBER"]["OVF_ON_NO_REPLY"].isSelected,
					buttonCallbackParams : {
						id : -11
					}
				}
			}else{
				label = _(["OVF_ON_NO_REPLY"," ()"], "webapp.userservices");
				entry = {
					intIndex: -11,
					strTrigger: this.NONE,
					strLabel: label,
					strSecondaryContentIcon : "empty-to-align-text", //not an icon but it's used to align the text with all the others
					itemCallback: webapp.userservices.onClickOverflow,
					strActionIcon : "userservices-more",
					buttonCallback : webapp.userservices.editOverflowNumber,
					boolSelected :false,
					buttonCallbackParams : {
						id : -11
					}
				}
			}
		}else{
			if(this.otherOverflowUserNoReply){
				var info = ICTouchAPI.tools.getContactDisplayName(this.otherOverflowUserNoReply);
				label = _(["OVF_ON_NO_REPLY"," ("+info+")"], "webapp.userservices");
			}else if(this.otherOverflowNumberNoReply){
				var objContact = ICTouchAPI.dataStoreServices.getStore('contacts').find(["officePhone", "personalHome", "personalMobile","officePhoneCan", "personalHomeCan", "personalMobileCan", "personalFax"],this.otherOverflowNumberNoReply)[0];
				if(objContact){
					label = _(["OVF_ON_NO_REPLY"," ("+objContact.name+" "+objContact.firstName+")"], "webapp.userservices");
				}else{
					label = _(["OVF_ON_NO_REPLY"," ("+this.otherOverflowNumberNoReply+")"], "webapp.userservices");
				}
			}else{
				label = _(["OVF_ON_NO_REPLY"," ()"], "webapp.userservices");
			}
			entry = {
					intIndex: -11,
					strTrigger: this.NONE,
					strLabel: label,
					strSecondaryContentIcon : "empty-to-align-text", //not an icon but it's used to align the text with all the others
					itemCallback: webapp.userservices.onClickOverflow,
					strActionIcon : "userservices-more",
					buttonCallback : webapp.userservices.editOverflowNumber,
					boolSelected :false,
					buttonCallbackParams : {
						id : -11
					}
				}
		}

		if(entry){
			this._arrAllDetails[this.OVERFLOW_SCREEN].push(entry);
			if(entry.boolSelected){
				for(var i in this._arrAllDetails[this.OVERFLOW_SCREEN]){
					if(this._arrAllDetails[this.OVERFLOW_SCREEN][i].intIndex == 0){
						this._arrAllDetails[this.OVERFLOW_SCREEN][i].boolSelected = false;
						break;
					}
				}
			}
		}
		entry = null;

		//Entry If busy or no reply to VM
		if(availableOverflow["VM"]["OVF_ON_BUSY_OR_NO_REPLY"]){
			if(this.boolVmNumber){
				entry = this.buildForwardToVoicemailElement("OVERFLOW");
			}
		}
		if(entry){
			//if(availableOverflow["VM"].overflowType == "OVF_ON_BUSY_OR_NO_REPLY"){
				entry.boolSelected = availableOverflow["VM"]["OVF_ON_BUSY_OR_NO_REPLY"].isSelected;
				if(entry.boolSelected){
					for(var i in this._arrAllDetails[this.OVERFLOW_SCREEN]){
						if(this._arrAllDetails[this.OVERFLOW_SCREEN][i].intIndex == 0){
							this._arrAllDetails[this.OVERFLOW_SCREEN][i].boolSelected = false;
							break;
						}
					}
				}
			//}
			this._arrAllDetails[this.OVERFLOW_SCREEN].push(entry);
		}
		entry = null;


		var label = null;
		if((availableOverflow["USER"]["OVF_ON_BUSY_OR_NO_REPLY"]!=null && availableOverflow["USER"]["OVF_ON_BUSY_OR_NO_REPLY"].isSelected)  ||
			(availableOverflow["NUMBER"]["OVF_ON_BUSY_OR_NO_REPLY"]!=null && availableOverflow["NUMBER"]["OVF_ON_BUSY_OR_NO_REPLY"].isSelected)){
			if(availableOverflow["USER"]["OVF_ON_BUSY_OR_NO_REPLY"]!=null && availableOverflow["USER"]["OVF_ON_BUSY_OR_NO_REPLY"].isSelected){
				if(this.isUserInfoNotEmpty(availableOverflow["USER"]["OVF_ON_BUSY_OR_NO_REPLY"])){
					label = ICTouchAPI.tools.getContactDisplayName(availableOverflow["USER"]["OVF_ON_BUSY_OR_NO_REPLY"].userInformation.value);
					this.otherOverflowUser = availableOverflow["USER"]["OVF_ON_BUSY_OR_NO_REPLY"].userInformation.value;
					this.otherOverflowNumber = null;
				}
				entry = {
					intIndex: -12,
					strTrigger: this.NONE,
					strLabel: _(["OVF_ON_BUSY_OR_NO_REPLY"," ("+label+")"], "webapp.userservices"),
					strSecondaryContentIcon : "empty-to-align-text", //not an icon but it's used to align the text with all the others
					itemCallback: webapp.userservices.onClickOverflow,
					strActionIcon : "userservices-more",
					buttonCallback : webapp.userservices.editOverflowNumber,
					boolSelected :availableOverflow["USER"]["OVF_ON_BUSY_OR_NO_REPLY"].isSelected,
					buttonCallbackParams : {
						id : -12
					}
				}
			}else if(availableOverflow["NUMBER"]["OVF_ON_BUSY_OR_NO_REPLY"]!=null && availableOverflow["NUMBER"]["OVF_ON_BUSY_OR_NO_REPLY"].isSelected){
				if(availableOverflow["NUMBER"]["OVF_ON_BUSY_OR_NO_REPLY"].phoneNumber!="" && availableOverflow["NUMBER"]["OVF_ON_BUSY_OR_NO_REPLY"].isSelected){
					var objContact = ICTouchAPI.dataStoreServices.getStore('contacts').find(["officePhone", "personalHome", "personalMobile","officePhoneCan", "personalHomeCan", "personalMobileCan", "personalFax"],availableOverflow["NUMBER"]["OVF_ON_BUSY_OR_NO_REPLY"].phoneNumber)[0];
					if(objContact){
						label = _(["OVF_ON_BUSY_OR_NO_REPLY"," ("+objContact.name+" "+objContact.firstName+")"], "webapp.userservices");
					}else{
						label = _(["OVF_ON_BUSY_OR_NO_REPLY"," ("+availableOverflow["NUMBER"]["OVF_ON_BUSY_OR_NO_REPLY"].phoneNumber+")"], "webapp.userservices");
					}
					this.otherOverflowUser = null;
					this.otherOverflowNumber = availableOverflow["NUMBER"]["OVF_ON_BUSY_OR_NO_REPLY"].phoneNumber;
				}
				entry = {
					intIndex: -12,
					strTrigger: this.NONE,
					strLabel: label,
					strSecondaryContentIcon : "empty-to-align-text", //not an icon but it's used to align the text with all the others
					itemCallback: webapp.userservices.onClickOverflow,
					strActionIcon : "userservices-more",
					buttonCallback : webapp.userservices.editOverflowNumber,
					boolSelected :availableOverflow["NUMBER"]["OVF_ON_BUSY_OR_NO_REPLY"].isSelected,
					buttonCallbackParams : {
						id : -12
					}
				}
			}else{
				label = _(["OVF_ON_BUSY_OR_NO_REPLY"," ()"], "webapp.userservices");
				entry = {
					intIndex: -12,
					strTrigger: this.NONE,
					strLabel: label,
					strSecondaryContentIcon : "empty-to-align-text", //not an icon but it's used to align the text with all the others
					itemCallback: webapp.userservices.onClickOverflow,
					strActionIcon : "userservices-more",
					buttonCallback : webapp.userservices.editOverflowNumber,
					boolSelected :false,
					buttonCallbackParams : {
						id : -12
					}
				}
			}
		}else{
			if(this.otherOverflowUser){
				var info = ICTouchAPI.tools.getContactDisplayName(this.otherOverflowUser);
				label = _(["OVF_ON_BUSY_OR_NO_REPLY"," ("+info+")"], "webapp.userservices");
			}else if(this.otherOverflowNumber){
				var objContact = ICTouchAPI.dataStoreServices.getStore('contacts').find(["officePhone", "personalHome", "personalMobile","officePhoneCan", "personalHomeCan", "personalMobileCan", "personalFax"],this.otherOverflowNumber)[0];
				if(objContact){
					label = _(["OVF_ON_BUSY_OR_NO_REPLY"," ("+objContact.name+" "+objContact.firstName+")"], "webapp.userservices");
				}else{
					label = _(["OVF_ON_BUSY_OR_NO_REPLY"," ("+this.otherOverflowNumber+")"], "webapp.userservices");
				}
			}else{
				label = _(["OVF_ON_BUSY_OR_NO_REPLY"," ()"], "webapp.userservices");
			}
			entry = {
				intIndex: -12,
				strTrigger: this.NONE,
				strLabel: label,
				strSecondaryContentIcon : "empty-to-align-text", //not an icon but it's used to align the text with all the others
				itemCallback: webapp.userservices.onClickOverflow,
				strActionIcon : "userservices-more",
				buttonCallback : webapp.userservices.editOverflowNumber,
				boolSelected :false,
				buttonCallbackParams : {
					id : -12
				}
			}
		}

		if(entry){
			this._arrAllDetails[this.OVERFLOW_SCREEN].push(entry);
			if(entry.boolSelected){
				for(var i in this._arrAllDetails[this.OVERFLOW_SCREEN]){
					if(this._arrAllDetails[this.OVERFLOW_SCREEN][i].intIndex == 0){
						this._arrAllDetails[this.OVERFLOW_SCREEN][i].boolSelected = false;
						break;
					}
				}
			}
		}
		
		this.switchContainer("getOverflowContent",this.OVERFLOW_SCREEN, this.getUserServiceContainerTitle());
	},

	isUserInfoNotEmpty : function(info){
		var res = false;
		if(info.userInformation){
			var userInfo = info.userInformation.value;
			if(userInfo.phoneNumber != "" || userInfo.login != "" || userInfo.name != "" || userInfo.firstName != ""){
				res = true;
			}
		}
		if(info.phoneNumber != ""){
			res = true;
		}
		return res;
	},


	reloadRoutingDetailsWithOrWithoutVm : function (withVm){
		var arrRouting = [];
		for (var i=0; i< this._arrAllDetails[this.ROUTING_SCREEN].length;i++){
			if (this._arrAllDetails[this.ROUTING_SCREEN][i].intIndex != -2){
				arrRouting.push(this._arrAllDetails[this.ROUTING_SCREEN][i])
			}
		}
		if (withVm){
			arrRouting.push(this.buildForwardToVoicemailElement("ROUTING"));
		}
		this._arrAllDetails[this.ROUTING_SCREEN] = arrRouting;
		withVm = null;
	},

	// Calback of get TelephonyVmNumber setting's value
	_gotVmNumber : function(strNumber) {
		if (strNumber !== "") {
			this._arrAllDetails[this.ROUTING_SCREEN].push(this.buildForwardToVoicemailElement("ROUTING"));
		}
		strNumber = null;
	},

	buildForwardToVoicemailElement : function (_type){
		if(_type == "ROUTING"){
			var i18nLabel = ICTouchAPI.tools.formatRoutingLabel(this.FWD_UNCONDITIONAL, this.DST_VOICEMAIL);
			var icon = ICTouchAPI.tools.getRoutingIcon(this.DST_VOICEMAIL);
			return {
				intIndex: -2,
				strLabel: i18nLabel,
				strTrigger: this.FWD_UNCONDITIONAL,
				strDest: this.DST_VOICEMAIL,
				strSecondaryContentIcon : icon,
				itemCallback: webapp.userservices.onClickRouting
			};
		}else if(_type == "OVERFLOW"){
			var i18nLabel = ICTouchAPI.tools.formatRoutingLabel(this.OVF_ON_BUSY_OR_NO_REPLY, this.OVF_DESTINATION_VOICEMAIL);
			var icon = ICTouchAPI.tools.getRoutingIcon(this.DST_VOICEMAIL);
			return {
				intIndex: -2,
				strLabel: i18nLabel,
				strTrigger: this.OVF_ON_BUSY_OR_NO_REPLY,
				strDest: this.OVF_DESTINATION_VOICEMAIL,
				strSecondaryContentIcon : icon,
				itemCallback: webapp.userservices.onClickOverflow
			};
		}else if(_type == "OVERFLOWBIS"){
			var i18nLabel = ICTouchAPI.tools.formatRoutingLabel(this.OVF_ON_NO_REPLY, this.OVF_DESTINATION_VOICEMAIL);
			var icon = ICTouchAPI.tools.getRoutingIcon(this.DST_VOICEMAIL);
			return {
				intIndex: -4,
				strLabel: i18nLabel,
				strTrigger: this.OVF_ON_NO_REPLY,
				strDest: this.OVF_DESTINATION_VOICEMAIL,
				strSecondaryContentIcon : icon,
				itemCallback: webapp.userservices.onClickOverflow
			};
		}else if(_type == "PROFILE"){
			var icon = ICTouchAPI.tools.getRoutingIcon(this.DST_VOICEMAIL);
			return {
				intIndex: -2,
				id: "LOCAL_VM",
				strLabel: _("LOCAL_VM","webapp.userservices"),
				strTrigger: this.FWD_UNCONDITIONAL,
				strDest: this.OVF_DESTINATION_VOICEMAIL,
				strSecondaryContentIcon : icon,
				itemCallback: webapp.userservices.onClickProfile
			};
		}else{
			//TODO message d'erreur
		}
		_type = null;
	},


	// Callback of loadedRoutingDetails
	_loadedRoutingList : function(arr) {
		// first item is "None"
		if (arr) {
			for (var i = 0; i < arr.length; i++) {
				// Setting value is in the form "routing_type:routing_dest:routing_number"
				var arrRoutingData = arr[i].split(":");
				var boolOther = (arrRoutingData[1] === this.DST_OTHER);
				//var label = this.formatRoutingLabel(arrRoutingData[0], arrRoutingData[1], arrRoutingData[2], boolOther);
				var objContact = ICTouchAPI.dataStoreServices.getStore('contacts').find(["officePhone", "personalHome", "personalMobile","officePhoneCan", "personalHomeCan", "personalMobileCan", "personalFax"],arrRoutingData[2])[0];
				var routingDest = null;
				if(objContact){
					routingDest = objContact.name+" "+objContact.firstName;
				}else{
					routingDest = arrRoutingData[2];
				}

				var label = ICTouchAPI.tools.formatRoutingLabel(arrRoutingData[0], arrRoutingData[1], routingDest, boolOther);
				var icon = ICTouchAPI.tools.getRoutingIcon(arrRoutingData[1]);
				this._arrAllDetails[this.ROUTING_SCREEN].push({
					intIndex: i + 1,
					strLabel: label,
					boolOther: boolOther,
					strTrigger: arrRoutingData[0],
					strDest: arrRoutingData[1],
					strNumber: arrRoutingData[2],
					strSecondaryContentIcon : icon,
					itemCallback: webapp.userservices.onClickRouting
				});
			}
		}
		ICTouchAPI.settingServices.getSettingValue("ActiveRouting", this, this._loadedActiveRouting);
		arr = null;
	},


	_loadedActiveRouting: function(str) {
		var selected = false;
		var arrRoutingList = this.getRoutingData();
		var i;
		var label;
		var arrActiveRoutingData;
		// Reset the selected routing
		for (i in arrRoutingList) {
			arrRoutingList[i].boolSelected = false;
		}
		if (str) {
			// Setting value is in the form "routing_type:routing_dest:routing_number"
			arrActiveRoutingData = str.split(":");

			var boolOther = (arrActiveRoutingData[1] === this.DST_OTHER);
			//var label = this.formatRoutingLabel(arrActiveRoutingData[0], arrActiveRoutingData[1], arrActiveRoutingData[2], boolOther);
			label = ICTouchAPI.tools.formatRoutingLabel(arrActiveRoutingData[0], arrActiveRoutingData[1], arrActiveRoutingData[2], boolOther);
			// Select the activate routing
			// We select the active Routing if it is on the list
			for (i in arrRoutingList)
			{
				if(arrRoutingList[i].strTrigger === arrActiveRoutingData[0] && arrRoutingList[i].strDest === arrActiveRoutingData[1] && arrRoutingList[i].strNumber === arrActiveRoutingData[2]) {
					selected = true;
					arrRoutingList[i].boolSelected = true;
					this.currentRoutingID = arrRoutingList[i].intIndex;
					break;
				}
			}
			// If the routing isn't on the list but is of type "Immediate...", we select "Immediate forward to..."
			if (selected === false && arrRoutingList[1] && arrRoutingList[1].intIndex === -1 && arrActiveRoutingData[0] === this.FWD_UNCONDITIONAL) {
				arrRoutingList[1].boolSelected = true;
				selected = true;
				this.currentRoutingID = arrRoutingList[1].intIndex;
			}
		}
		if (selected === false && this.currentMode === this.NORMAL_MODE) {
			// If no item selected but a routing set, add it on the local list and on the setting
			if(label && arrActiveRoutingData[1]){ // If not none
				var routingDestination = "";
				if(arrActiveRoutingData[2]){
					routingDestination = arrActiveRoutingData[1] + ":" + arrActiveRoutingData[2];
				} else {
					routingDestination = arrActiveRoutingData[1];
				}
				this.currentRouting = {
					routingType: arrActiveRoutingData[0],
					routingDestination : routingDestination
				};
				var detailsLength = this._arrAllDetails[this.ROUTING_SCREEN].length;
				var lastIndex;
				if(detailsLength){
					lastIndex = this._arrAllDetails[this.ROUTING_SCREEN][detailsLength-1].intIndex;
				} else {
					lastIndex = 0;
				}

				if(this.boolSimplifiedForwardMode){
					// The routing set does not exist, so create it
					this._arrAllDetails[this.ROUTING_SCREEN].push({
						intIndex: lastIndex+1,
						strLabel: label,
						strTrigger: arrActiveRoutingData[0],
						strDest: arrActiveRoutingData[1],
						strNumber: arrActiveRoutingData[2],
						strSecondaryContentIcon : this._arrDestinationsIcons[arrActiveRoutingData[1]],
						itemCallback: webapp.userservices.onClickRouting,
						boolSelected:true
					});
					this.currentRoutingID = lastIndex+1;
				} else {
					var noSwitch = true;
					ICTouchAPI.settingServices.getSettingValue("RoutingList", this, this.saveRoutingList);
				}
			} else { // If none
				arrRoutingList[0].boolSelected = true;
				this.currentRoutingID = arrRoutingList[0].intIndex;
			}
		}
		if(!noSwitch){
			this.switchContainer("getRoutingContent",this.ROUTING_SCREEN, this.getUserServiceContainerTitle());
		}
		str = null;
	},

	// Called when we click on "add" appButton
	loadRoutingTypeDetails : function() {
		// Set data
		this._strContainerPath = "webapp.userservices.getRoutingAdd1Content";
		this._arrAllDetails[this.ADD_ROUTING_1_SCREEN] = [];
		// Get forward list setting
		ICTouchAPI.settingServices.getSettingValue("TelephonyForwardTypes",this,this.loadedRoutingTypeDetails);
	},

	// Callback of loadRoutingTypeDetails
	loadedRoutingTypeDetails: function(arr) {
		// arr contains the jsValue (Array) of TelephonyForwardTypes setting
		var selected = false;
		if(arr != null && arr.length > 0)
		{
			for (var i in arr) {
				this._arrAllDetails[this.ADD_ROUTING_1_SCREEN].push({
					strLabel: _(arr[i], "webapp.userservices"),
					intIndex: i,
					label : arr[i]
				});
				if (this.currentRouting.routingType === arr[i]) {
					selected = true;
					this._arrAllDetails[this.ADD_ROUTING_1_SCREEN][i].boolSelected = true;
				}
			}
			if (selected === false) {
				this.currentRouting.routingType = arr[0];
				this._arrAllDetails[this.ADD_ROUTING_1_SCREEN][0].boolSelected = true;
			}
			this.switchContainer("getRoutingAdd1Content",this.ADD_ROUTING_1_SCREEN, _("Add routing on event", "webapp.userservices"));
		}
		arr = null;
	},

	// Called when we click on "next" appButton
	loadRoutingDestinationDetails : function() {
		// Set data
		this._strContainerPath = "webapp.userservices.getRoutingAdd2Content";
		this._arrAllDetails[this.ADD_ROUTING_2_SCREEN] = [];
		// Get forward list setting value
		ICTouchAPI.settingServices.getSettingValue("TelephonyForwardDestinations",this,this.loadedRoutingDestinationDetails);
	},

	// Callback of loadRoutingDestinationDetails
	loadedRoutingDestinationDetails: function(arr) {
		// arr contains the jsValue (Array) of TelephonyForwardDestinations setting
		if(arr != null && arr.length > 0)
		{
			var selected = false;
			for (var i in arr) {
				var icon = ICTouchAPI.tools.getRoutingIcon(arr[i]);
				this._arrAllDetails[this.ADD_ROUTING_2_SCREEN].push({
					strLabel: _(arr[i], "webapp.userservices"),
					intIndex: i,
					strSecondaryContentIcon : icon,
					label : arr[i]
				});
				if (this.currentRouting.routingDestination && this.currentRouting.routingDestination === arr[i]) {
					selected = true;
					this._arrAllDetails[this.ADD_ROUTING_2_SCREEN][i].boolSelected = true;
				}
			}
			var last = this._arrAllDetails[this.ADD_ROUTING_2_SCREEN].length ;
			var icon = ICTouchAPI.tools.getRoutingIcon("Other");
			this._arrAllDetails[this.ADD_ROUTING_2_SCREEN].push({
				strLabel: _("Other...", "webapp.userservices"),
				intIndex: last,
				strSecondaryContentIcon : icon,
				label :this.DST_OTHER
			});
			if(this.currentRouting.routingDestination && this.currentRouting.routingDestination == this._arrAllDetails[this.ADD_ROUTING_2_SCREEN][last].label) {
				this._arrAllDetails[this.ADD_ROUTING_2_SCREEN][last].boolSelected = true;
				selected = true;
			}
			if(selected != true) {
				this.currentRouting.routingDestination = arr[0];
				this._arrAllDetails[this.ADD_ROUTING_2_SCREEN][0].boolSelected = true;
			}
			this.switchContainer("getRoutingAdd2Content",this.ADD_ROUTING_2_SCREEN, _("Routing destination", "webapp.userservices"));
		}
		arr = null;
	},

	// Called when you save a new or modified routing
	saveRoutingList : function(arr) {
		var i;
		var arrRoutingList = this.getRoutingData();
		var newArr = arr;
		if (newArr == null)	// Handle undefined setting value
			newArr = [];
		if(this.currentMode == this.NORMAL_MODE) {
			// Check if the arouting rule is already defined before adding it, in order to avoid duplicated entries
			var boolRoutingAlreadyDefined = false;
			for (i in arrRoutingList) {
				if (arrRoutingList[i].strTrigger == this.currentRouting.routingType && (arrRoutingList[i].strDest == this.currentRouting.routingDestination || arrRoutingList[i].strDest+":"+arrRoutingList[i].strNumber == this.currentRouting.routingDestination )) {
					boolRoutingAlreadyDefined = true;
					break;
				}
			}
			if (!boolRoutingAlreadyDefined) {
				newArr.push(this.currentRouting.routingType+ ":" +this.currentRouting.routingDestination);
				ICTouchAPI.settingServices.setSettingValue("RoutingList", newArr, this, this._savedRoutingList);
			} else {
				this.switchContainer("getRoutingContent",this.ROUTING_SCREEN, this.getUserServiceContainerTitle());
			}
		}

		else { // MODIFY_MODE
			if(this.currentRouting && this.currentRouting.id){
				if(this.currentRouting.routingType===this.FWD_UNCONDITIONAL && this.currentRouting.routingDestination===this.DST_VOICEMAIL) {
					boolRoutingAlreadyDefined = true;
				}
				else {
					for (i in arrRoutingList) {
						if (arrRoutingList[i].strTrigger == this.currentRouting.routingType && arrRoutingList[i].strDest == this.currentRouting.routingDestination) {
							boolRoutingAlreadyDefined = true;
							break;
						}
					}
				}
				if (!boolRoutingAlreadyDefined) {
					var strPreviousRouting = newArr[this.currentRouting.id]; // save the previous value of the modified routing
					newArr[this.currentRouting.id] = this.currentRouting.routingType+ ":" +this.currentRouting.routingDestination;
					ICTouchAPI.settingServices.getSettingValue("ActiveRouting", this, this._checkActiveRoutingForModify, {
						strPreviousRouting: strPreviousRouting,
						arr: newArr
					});
				}
				else {
					this.changeMode(this.NORMAL_MODE);
					this.loadRoutingDetails();
				}

			// Get the active routing : if the modified routing is the active routing, we have to activate the forward for the modified routing
			// otherwize, the activated routing will stay active in the list, and the modified routing will be added to the list of routings
			}
		}
		arr = null;
	},

	// Callback of getSettingValue for ActiveRouting, in case of modify routing
	_checkActiveRoutingForModify : function(strActiveRouting, params) {
		var arrActiveRoutingData = strActiveRouting.split(":"); // data of the active routing
		var previousRoutingData = params.strPreviousRouting.split(":"); // data of the modified routing before the modifications
		var modifiedRoutingData = params.arr[this.currentRouting.id].split(":"); // data of the modified routing after the modifications

		// If the routing to modify was the active routing, call setActiveRoutingOnClickRouting to set the modified routing as the active routing
		if (previousRoutingData[0] == arrActiveRoutingData[0] && previousRoutingData[1] == arrActiveRoutingData[1] && previousRoutingData[2] == arrActiveRoutingData[2]) {
			var boolOther = false;
			if (modifiedRoutingData[2]) {
				boolOther = true;
			}
			var objRouting = {
				strTrigger :modifiedRoutingData[0],
				strDest:modifiedRoutingData[1],
				strNumber:modifiedRoutingData[2],
				boolOther:boolOther
			};
			webapp.userservices.setActiveRoutingOnClickRouting(objRouting);
		}
		ICTouchAPI.settingServices.setSettingValue("RoutingList", params.arr, this, this._savedRoutingList);
		strActiveRouting=null;
		params=null;
	},

	// Callback of saveRoutingList
	_savedRoutingList : function() {
		this.changeMode(this.NORMAL_MODE) ;
		this.loadRoutingDetails();
	},

	// Open a new popup with a specific name and the id of the selected line
	deletePopup : function(id) {
		var _id = id;
		var context = this;
		var popupData = {
			strTitle:  _("Confirm deletion ?", 'webapp.userservices'),
			strType: "warning",
			strContent: _("CONFIRM_DELETION", 'webapp.userservices'),
			arrPopupButtons: [{
				strButtonName: this.YES,
				strButtonLabel:  _("Yes", 'ICTouchAPI'),
				strButtonIcon: "generic-ok",
				callback: function() {
					context.yesPopup(_id);
				}
			},{
				strButtonName: this.NO,
				strButtonLabel:  _("No", 'ICTouchAPI'),
				strButtonIcon: "generic-cancel",
				callback: function() {
					context.closePopup();
				}
			}]
		};
		this.objPopup = ICTouchAPI.popupServices.addNewPopup(popupData, "MEDIUM");
		id = null;
	},

	// "yes" callback of the popup
	yesPopup : function(id) {
		var arr = this.getRoutingData();
		var newArr = [];
		for(var i=0; i<arr.length;i++)
		{
			if(id != i) {
				var dest = arr[i].strDest;
				var type = arr[i].strTrigger;
				if(arr[i].boolOther){
					dest = dest + ":" + arr[i].strNumber;
				}
				newArr.push(type+":"+dest);
			}
		}
		ICTouchAPI.settingServices.getSettingValue("ActiveRouting", this, this._yesPopup, {
			line : arr[id],
			arr : newArr
		});
		id = null;
	},

	// Callback of yesPopup
	_yesPopup : function(str, params) {
		var arrActiveRouting = str.split(':');
		if (arrActiveRouting[0] == params.line.strTrigger && arrActiveRouting[1] == params.line.strDest && arrActiveRouting[2] == params.line.strNumber) {
			/* In the case the routine to delete is currently enabled:
			Diseable the forward, and simulate a click on the "None" active routing before deleting the routine */
			ICTouchAPI.APIServices.Telephony.deactivateForward({
				context: webapp.userservices
			});
			this.yesCallback = function() {
				webapp.userservices.data.changeMode(this.NORMAL_MODE);
				ICTouchAPI.settingServices.setSettingValue("RoutingList", params.arr, this, this.closePopup );
				webapp.userservices.data.yesCallback = null;
			};

			if(webapp.progkeys) {
				webapp.progkeys.desactivateProgKeys();
			}

			//ICTouchAPI.APIServices.Telephony.deactivateDnd({context: webapp.userservices});
			/* Set the global webapp variable "currentRoutingLabel" to an empty string, so that the function "setActiveRouting"
			(webapp.userservices.controlBase) can know that the current routing has been changed to none*/
			//webapp.userservices.data.currentRoutingLabel = "";
			/* Set the global webapp variable "currentRoutingID" to "0", so that the callback "onClickRouting"
			(webapp.userservices.controlBase) can know that the current routing has been changed to None*/
			this.currentRoutingID = 0;
		//ICTouchAPI.settingServices.setSettingValue("ActiveRouting", "None");
		}
		else {
			// the routing to delete is not currently set, just remove it from the list
			this.changeMode(this.NORMAL_MODE);
			ICTouchAPI.settingServices.setSettingValue("RoutingList", params.arr, this, this.closePopup );
		}
		str=null;
		params=null;
	},

	// Hide the popup
	closePopup : function() {
		ICTouchAPI.popupServices.removePopup(this.objPopup);
		this.loadRoutingDetails();
	},

	// Called when we click on "Voicemail" in the menuList
	loadVoicemailDetails: function() {
		this.switchContainer("getVoicemailContent", this.VOICEMAIL_SCREEN, _("Voicemail Message", "webapp.userservices"));
	},

	// Called when we click on "UserInfo" in the menuList
	loadUserInfoDetails: function() {
		this._arrAllDetails[this.USER_INFO_SCREEN] = [];
		var arrIds = ICTouchAPI.tools.isFirstNameFirstDisplayed() ? ["UserFirstName", "UserName"] : ["UserName", "UserFirstName"];
		arrIds.push("SIPUserName");
		ICTouchAPI.settingServices.getSettingsFromIds(arrIds, this, this.loadedUserInfoDetails);
	},

	// Callback of loadUserInfoDetails
	loadedUserInfoDetails: function(arr) {
		var obj = {};
		for(var i in arr)
		{
			obj = {
				strContent: arr[i].value,
				strLabel: _(arr[i].label, "webapp.settings"),
				callback: dojo.hitch(webapp.userservices, webapp.userservices.onClickUserInfo, arr[i]),
				objSetting: arr[i],
				boolEnabled : (arr[i].user_rights == 2) ? true : false
			};

			this._arrAllDetails[this.USER_INFO_SCREEN].push(obj);
		}
		
		// Add a last entry for CLIR, which is composed of 2 settings
		var HideIdentityLabel;
		if(this.getHideIdentityState()){
			HideIdentityLabel = "Activated " + '(' + this.lstHideIdentityBarringRules[this.getHideIdentityBarringRule()] + ')';
		} else {
			HideIdentityLabel = "Not active";
		}
		obj = {
			strContent: _(HideIdentityLabel, "webapp.userservices"),
			strLabel: _("Hide User Identity", "webapp.userservices"),
			boolEnabled : false
		};

		this._arrAllDetails[this.USER_INFO_SCREEN].push(obj);
		
		// Add a new entry for supervision hidden state
		if(this._supervisionHiddenState){
			obj = {
				strContent: _("Contact your administrator", "ICTouchAPI"),
				strLabel: _("Supervision", "webapp.userservices"),
				boolEnabled : false
			};

			this._arrAllDetails[this.USER_INFO_SCREEN].push(obj);
		}
		
		this.switchContainer("getUserInfoContent", this.USER_INFO_SCREEN, _("UserInfo", "webapp.userservices"));

		arr = null;
	},

	// Callback of loadUserInfoDetails
	//loadedUserInfoDnd: function(value) {
	//	var appBar = ICTouchAPI.AppBarServices.getAppBar("userservices","userservicesstatus"+this.USER_INFO_SCREEN);
	//	this.setDndButtonStatus(value, appBar);
	//	this.switchContainer("getUserInfoContent", this.USER_INFO_SCREEN, _("UserInfo", "webapp.userservices"));
	//},

	// Called when we click on "Video" in the menuList
	loadVideoDetails: function() {
		this.switchContainer("getVideoContent", this.VIDEO_SCREEN, _("Video", "ICTouchAPI"));
	},

	// Change the status text in the dnd Button of "appBar" according to "value"
	setDndButtonStatus: function(boolDnd) {
		this.dndButtonStatus = boolDnd;
		var _strStatus = (boolDnd) ? 'notif-on' : 'notif-off';//_("on", "ICTouchAPI") : _("off", "ICTouchAPI");
		var appBar = ICTouchAPI.AppBarServices.getAppBar("userservices","userservicesstatus"+this.USER_INFO_SCREEN);
		var dndButton = appBar.getButton(this.DND);
		if(dndButton){
			dndButton.setStatusIcon(_strStatus);
		//dndButton.attr("strStatusText", _strStatus);
		}
		boolDnd = null;
	},

	// Call to the webapp Search to find a number
	onOtherSearch : function() {
		var strWidget = this.getContainerPath();
		var func = null;
		var funcExit = null;
		if(strWidget == "webapp.userservices.getRoutingContent") {
			if(!this.getMultiDeviceRoutingAvailability()){
				func = {
					context: webapp.userservices.data,
					func: webapp.userservices.data.searchForImmediateRouting
				};
				funcExit = dojo.hitch(webapp.userservices.data, webapp.userservices.data.loadRoutingDetails);
			}else{
				func = {
					neededData	: "phoneNumber",
					context: webapp.userservices.data,
					func: webapp.userservices.data.setUserRouting,
					leftIconImage  : "generic-ok-32",
					leftIconImageConditionnalDisplay  : "phoneNumber"
				};
				funcExit = dojo.hitch(webapp.userservices.data, webapp.userservices.data.loadRoutingDetails);
			}
			
		}else if(strWidget == "webapp.userservices.getRoutingAdd2Content") {
			func = {
				neededData	: "phoneNumber",
				context: webapp.userservices.data,
				func: webapp.userservices.data.searchForRoutingDestination
			};
		}else if(strWidget == "webapp.userservices.getOverflowContent") {
			func = {
				neededData	: "phoneNumber",
				context: webapp.userservices.data,
				func: webapp.userservices.data.searchForOverflow,
				leftIconImage  : "generic-ok-32",
				leftIconImageConditionnalDisplay  : "phoneNumber"
			};
			funcExit = dojo.hitch(webapp.userservices.data, webapp.userservices.data.loadOverflowDetails);
		}else if(strWidget == "webapp.userservices.getProfileDetails") {
			func = {
				neededData	: "phoneNumber",
				context: webapp.userservices.data,
				func: webapp.userservices.data.setOtherNumber,
				leftIconImage  : "generic-ok-32",
				leftIconImageConditionnalDisplay  : "phoneNumber"
			};
			funcExit = dojo.hitch(webapp.userservices, webapp.userservices._setOtherNumber);
		}
		var objSearch = {
			contactDataTypes		: ["Phone"],
			lineClickCallback		: func,
			secondaryInformation : "phoneNumber", // information of the contact to be displayed at the right of the contact's display name in the search results
			useDefaultCallMethod	: true,
			funcCallbackExit		: funcExit,
			callingWebapp			: "userservices"
		};

		if(webapp.communication && webapp.communication.data){
			// Set select mode
			if(strWidget == "webapp.userservices.getProfileDetails"){
				webapp.communication.setSelectStatus(webapp.communication.data.STATUS_MDR_ROUTING);
			}else if(strWidget == "webapp.userservices.getOverflowContent"){
				webapp.communication.setSelectStatus(webapp.communication.data.STATUS_MDR_OVERFLOW);
			}else if(strWidget == "webapp.userservices.getRoutingContent"){
				if(this.getMultiDeviceRoutingAvailability()){
					webapp.communication.setSelectStatus(webapp.communication.data.STATUS_MDR_USER);
				}else{
					webapp.communication.setSelectStatus(webapp.communication.data.STATUS_BASIC_IMMEDIATE_ROUTING);
				}
			}else if(strWidget == "webapp.userservices.getRoutingAdd2Content"){
				webapp.communication.setSelectStatus(webapp.communication.data.STATUS_BASIC_ADD_ROUTING);
			}
			webapp.communication.updateAppBar();
			// get and save the callId
			webapp.communication.data._objFirstSelected = webapp.communication.data.getSelectedEntry();
			objSearch.searchType = webapp.communication.getKeyPadActionFromSelectStatus();
		}

		if(webapp.history && webapp.history.data){
			// Set select mode
			if(strWidget == "webapp.userservices.getProfileDetails"){
				webapp.history.setSelectStatus(webapp.history.data.STATUS_MDR_ROUTING);
			}else if(strWidget == "webapp.userservices.getOverflowContent"){
				webapp.history.setSelectStatus(webapp.history.data.STATUS_MDR_OVERFLOW);
			}else if(strWidget == "webapp.userservices.getRoutingContent"){
				if(this.getMultiDeviceRoutingAvailability()){
					webapp.history.setSelectStatus(webapp.history.data.STATUS_MDR_USER);
				}else{
					webapp.history.setSelectStatus(webapp.history.data.STATUS_BASIC_IMMEDIATE_ROUTING);
				}
			}else if(strWidget == "webapp.userservices.getRoutingAdd2Content"){
				webapp.history.setSelectStatus(webapp.history.data.STATUS_BASIC_ADD_ROUTING);
			}
			webapp.history.updateAppBar();
			// get and save the callId
			webapp.history.data._objFirstSelected = webapp.history.data.getSelectedEntry();
		}

		//Set right icon callback
		objSearch.rightIconClickCallback = {
			neededData : "Contact",
			rightIconImage  : "contacts-card-32",
			rightIconImageRemoteContact : "contacts-contact-card-remote-32",
			context:webapp.userservices,
			func: function (objContact) {
				dojo.publish("e_contact_showContact",[{
					objContact: objContact,
					needStealth : true,
					clbkBack: function() {
						if(webapp.userservices.data.getContainerPath() == "webapp.userservices.getProfileDetails"){
							webapp.userservices._setOtherNumber("");
						}else if(webapp.userservices.data.getContainerPath() == "webapp.userservices.getOverflowContent"){
							webapp.userservices.data.loadOverflowDetails();
						}
						ICTouchAPI.transitionServices.unstealth("webapp.contacts.getContact");
						ICTouchAPI.transitionServices.back();
					}
				}]);
			}
		};

		var byNameObject = {
			funcCallbackOk : function(){
				if(!webapp.communication.data.getBoolInitiateByName()){
					var callback = objSearch.lineClickCallback;
						callback.func.apply(callback.context, [null, {
						strContent: this.getValue()
					}]);
				} else {
					webapp.communication.data.setBoolInitiateByName(false);
				}
			},
			funcCallbackExit : function () {
				//ICTouchAPI.transitionServices.back();
			}
		}
		objSearch.byNameObject = byNameObject;

		if (webapp.search) {
			webapp.search.doSearch(objSearch,
				function() {
					if(webapp.userservices.data.getContainerPath() == "webapp.userservices.getProfileDetails"){
						webapp.userservices._setOtherNumber("");
					}else if(webapp.userservices.data.getContainerPath() == "webapp.userservices.getOverflowContent"){
						webapp.userservices.data.loadOverflowDetails();
					}else if(webapp.userservices.data.getContainerPath() == "webapp.userservices.getRoutingContent"){
						webapp.userservices.data.loadRoutingDetails();
					}
					ICTouchAPI.transitionServices.back();
					/*ICTouchAPI.transitionServices.getScreen({
						name: "webapp.userservices.getUserService",
						params: {}
					});*/
					webapp.userservices.data.mainWidget.reloadContainer();

				}
				);
		} else {
			// show numeric
			ICTouchAPI.keyboardServices.deployKeyboard(ICTouchAPI.KeyboardTypes.NUM, null,{
				strDefaultText: "",
				funcCallbackOk : function(){
					objSearch.clickCallback(null, {
						strContent: this.getValue()
					});
				},
				funcCallbackExit : function(){
					objSearch.funcCallbackExit();
				}
			});
		}
	},

	// When we click on "immediate forward to..."
	searchForImmediateRouting : function(phoneNumber, objNumber) {
		var number = "";
		if(objNumber && objNumber.strContent){
			number = objNumber.strContent;
			ICTouchAPI.keyboardServices.closeKeyboard(ICTouchAPI.keyboardServices.CLOSE_ACTION_EXIT);
			webapp.userservices.setImmediateActiveRouting(number);
		} else if(phoneNumber) {
			webapp.userservices.setImmediateActiveRouting(phoneNumber);
			/*ICTouchAPI.APIServices.Telephony.makeCanonicalNumber({
				params:[number],
				context: webapp.userservices,
				callback: webapp.userservices.setImmediateActiveRouting
			});*/
		}
		phoneNumber=null;
		objNumber=null;
	},

	setOtherNumber : function(phoneNumber, objNumber) {
		var number = "";
		if(phoneNumber) {
			ICTouchAPI.transitionServices.back();
			if(webapp.communication && webapp.communication.data) {
				ICTouchAPI.transitionServices.back();
				webapp.communication.setSelectStatus(-1);
				webapp.communication.updateAppBar();
			}
			/*ICTouchAPI.APIServices.Telephony.makeCanonicalNumber({
				params:[number],
				context: webapp.userservices,
				callback: webapp.userservices._setOtherNumber
			});*/
			webapp.userservices._setOtherNumber(phoneNumber,true);
		}else if(objNumber && objNumber.strContent !=""){
			if(webapp.communication && webapp.communication.data) {
				if(objNumber.boolBack){
					ICTouchAPI.transitionServices.back();
				}
				webapp.communication.setSelectStatus(-1);
				webapp.communication.updateAppBar();
			}
			number = objNumber.strContent;
			ICTouchAPI.keyboardServices.closeKeyboard(ICTouchAPI.keyboardServices.CLOSE_ACTION_EXIT);
			webapp.userservices._setOtherNumber(number,false);
		}else{
			var availableDevices = this.getCurrentAvailableDevices();
			for(var device in availableDevices){
				if(availableDevices[device].presentationDestinationType.value.value == this.DEVICE_OTHER){
					availableDevices[device].isSelected = false;
					this.objDetailsScreen.getContent().unselectAtIndex(device);
				}
			}
		}
		phoneNumber = null;
		objNumber = null;
	},

	searchForOverflow : function(phoneNumber, objNumber) {
		var number = "";
		if(phoneNumber) {
			if(webapp.communication && webapp.communication.data) {
				ICTouchAPI.transitionServices.back();
				webapp.communication.setSelectStatus(-1);
				webapp.communication.updateAppBar();
			}
			webapp.userservices.setOverflow(phoneNumber,true);
		}else if(objNumber && objNumber.strContent){
			number = objNumber.strContent;
			ICTouchAPI.keyboardServices.closeKeyboard(ICTouchAPI.keyboardServices.CLOSE_ACTION_EXIT);
			webapp.userservices.setOverflow(number,false);
			if(webapp.communication && webapp.communication.data) {
				if(objNumber.boolBack){
					ICTouchAPI.transitionServices.back();
				}
				webapp.communication.setSelectStatus(-1);
				webapp.communication.updateAppBar();
			}
		}
		phoneNumber=null;
		objNumber=null;
	},

	setUserRouting : function(phoneNumber, objNumber) {
		var number = "";
		if(objNumber && objNumber.strContent){
			if(webapp.communication && webapp.communication.data) {
				if(objNumber.boolBack){
					ICTouchAPI.transitionServices.back();
				}
					webapp.communication.setSelectStatus(-1);
					webapp.communication.updateAppBar();
				}
			number = objNumber.strContent;
			ICTouchAPI.keyboardServices.closeKeyboard(ICTouchAPI.keyboardServices.CLOSE_ACTION_EXIT);
			webapp.userservices._setUserRouting(number);
		}else if(phoneNumber) {
			if(webapp.communication && webapp.communication.data) {
				ICTouchAPI.transitionServices.back();
				webapp.communication.setSelectStatus(-1);
				webapp.communication.updateAppBar();
			}
			ICTouchAPI.APIServices.Telephony.makeCanonicalNumber({
				params:[phoneNumber],
				context: webapp.userservices,
				callback: webapp.userservices._setUserRouting
			});
		}
		phoneNumber=null;
		objNumber=null;
	},

	// Callback of searchForImmediateRouting
	_searchedForImmediateRouting : function() {
		this.loadRoutingDetails();
	},

	// When we click on "other" in the second step of adding routing
	searchForRoutingDestination : function (phoneNumber, objNumber) {
		var number = null;
		if(objNumber && objNumber.strContent){
			number = objNumber.strContent;
			ICTouchAPI.keyboardServices.closeKeyboard(ICTouchAPI.keyboardServices.CLOSE_ACTION_EXIT);
		} else if (phoneNumber) {
			number = phoneNumber;
		}
		if(number){
			ICTouchAPI.APIServices.Telephony.makeCanonicalNumber({
				params:[number],
				context: webapp.userservices,
				callback: webapp.userservices.setDestinationRouting
			});
		}
		phoneNumber = null;
		objNumber = null;
	},



	// Change the currentMode and the statusIcon for delete and modify appButton
	changeMode : function(mode) {
		this.currentMode = mode;
		var appBar = ICTouchAPI.AppBarServices.getAppBar("userservices","userservicesstatus"+this.ROUTING_SCREEN);
		var modifyButton = appBar.getButton(this.MODIFY_ROUTING);
		var deleteButton = appBar.getButton(this.DELETE_ROUTING);
		switch (mode)
		{
			case this.NORMAL_MODE :
				modifyButton.setStatusIcon(this.STATUS_OFF_ICON);
				deleteButton.setStatusIcon(this.STATUS_OFF_ICON);
				break;
			case this.MODIFY_MODE :
				modifyButton.setStatusIcon(this.STATUS_ON_ICON);
				deleteButton.setStatusIcon(this.STATUS_OFF_ICON);
				break;
			case this.DELETE_MODE :
				modifyButton.setStatusIcon(this.STATUS_OFF_ICON);
				deleteButton.setStatusIcon(this.STATUS_ON_ICON);
				break;
			default :
				break;
		}
		mode = null;
	},

	getContainerPath : function() {
		return this._strContainerPath;
	},

	getAppBarAppButtons : function() {
		var arrTranslated = dojo.clone(this._arrAppButtons);
		dojo.forEach(arrTranslated, function(objButton) {
			objButton.strButtonLabel = ICTouchAPI.i18nServices.translate(objButton.strButtonLabel, "webapp.userservices");
		});
		return arrTranslated;
	},


	getUserServiceListTitle : function() {
		return this._strUserServiceListTitle;
	},

	getUserServiceList : function() {
		var availableList = [];
		for(var i=0; i<this.NB_STATUS; ++i)
		{
			if( this._arrListEntries[i] != null )
				availableList.push(this._arrListEntries[i]);
		}
		return availableList;
	},

	getUserServiceContainerTitle : function(){
		return this._strUserServiceContainerTitle;
	},

	getRoutingData : function() {
		return this._arrAllDetails[this.ROUTING_SCREEN];
	},

	getOverflowData : function() {
		return this._arrAllDetails[this.OVERFLOW_SCREEN];
	},

	getRoutingTypeData : function() {
		return this._arrAllDetails[this.ADD_ROUTING_1_SCREEN];
	},

	getRoutingDestinationData: function() {
		return this._arrAllDetails[this.ADD_ROUTING_2_SCREEN];
	},

	getOverflowTypeData : function() {
		return this._arrAllDetails[this.ADD_OVERFLOW_1_SCREEN];
	},

	getOverflowDestinationData: function() {
		return this._arrAllDetails[this.ADD_OVERFLOW_2_SCREEN];
	},

	getPresenceData : function() {
		return this._arrAllDetails[this.PRESENCE_IM_SCREEN];
	},

	getUserInfoData : function() {
		return this._arrAllDetails[this.USER_INFO_SCREEN];
	},

	// Set a new routing message
	updateCustomRouting: function() {
		var str = ICTouchAPI.keyboardServices.getValue();
		var last = this._arrAllDetails[this.PRESENCE_IM_SCREEN].length-1;
		this._arrAllDetails[this.PRESENCE_IM_SCREEN][last].strLabel = str;
		ICTouchAPI.settingServices.setSettingValue("UserPresenceCustomMsg", str, this, this._updatedCustomRouting);
	},

	// Callback of updateCustomRouting
	_updatedCustomRouting : function() {
		this.switchContainer("getPresenceContent",this.PRESENCE_IM_SCREEN, _("Select your presence", "webapp.userservices"));
	},

	// set a new content for the container of the userservices and call an update of the appBar
	switchContainer: function(pageName, status, pageTitle) {
		this._strContainerPath = "webapp.userservices."+pageName;
		if(pageTitle){
			this._strUserServiceContainerTitle = pageTitle;
		}
		this.updateAppBar(status);
		if(this.mainWidget){
			this.mainWidget.reloadContainer();
		}
		pageName = null;
		status = null;
		pageTitle = null;
	},

	// set the appBar corresponding to the status
	updateAppBar: function(status) {
		// set the status
		webapp.userservices.currentStatus = status;

		// button callback
		var backFunc = dojo.hitch( webapp.userservices, webapp.userservices.buttonCallback, this.BACK);

		// Create the static back button
		ICTouchAPI.AppBarServices.addExitButton("userservices","userservicesstatus"+status, this.isPreviousHome(), backFunc);

		// Register appBar according to state
		if(this.mainWidget){
			if(status != this.PROFILE_DETAILS_SCREEN){
				ICTouchAPI.AppBarServices.setAppBar("userservices","userservicesstatus"+status, "getUserService")
			}else{
				ICTouchAPI.AppBarServices.setAppBar("userservices","userservicesstatus"+status, "getProfileDetails")
			}
		}
		this.updateAppButtons();
		status = null;
	// var appBar = ICTouchAPI.AppBarServices.getAppBar("userservices","userservicesstatus"+status);
	// appBar.updateAppBar();
	},

	// Hide or show routing buttons according to mode (simplified or not)
	updateAppButtons : function() {
		if(this.getContainerPath() == "webapp.userservices.getRoutingContent"){
			if(this.getMultiDeviceRoutingAvailability()){
				webapp.userservices.hideEditionButton();
			}else{
				var appBar = ICTouchAPI.AppBarServices.getAppBar("userservices","userservicesstatus"+webapp.userservices.currentStatus);
				var addButton = appBar.getButton(this.ADD_ROUTING);
				var modifyButton = appBar.getButton(this.MODIFY_ROUTING);
				var deleteButton = appBar.getButton(this.DELETE_ROUTING);
				if(this.boolSimplifiedForwardMode) {
					addButton.hide();
					modifyButton.hide();
					deleteButton.hide();
				} else {
					addButton.show();
					modifyButton.show();
					deleteButton.show();
				}
			}
		}
	},


	isPreviousHome : function() {
		switch(this._strContainerPath) {
			case "webapp.userservices.getRoutingAdd2Content" :
				return false;
				break;
			case "webapp.userservices.getRoutingAdd1Content" :
				return false;
				break;
			case "webapp.userservices.getProfileDetails" :
				return false;
				break;
			default :
				return true;
				break;
		}
	},

	setRightToUserServices : function(){
		this.accessRightToUserServices = false;
	},

	getRightToUserServices : function(){
		return this.accessRightToUserServices;
	},

	setIMAvailability : function(_value){
		this.boolIMAvailabilityChanged = _value;
		_value = null;
	},

	getIMAvailability : function(){
		return this.boolIMAvailabilityChanged;
	},

	setMultiDeviceRoutingAvailability : function(_value){
		this.multiDeviceRoutingAvailability = _value;
		_value = null;
	},

	getMultiDeviceRoutingAvailability : function(){
		return this.multiDeviceRoutingAvailability;
	},

	setAllowDirectCustomForward : function(_value){
		this.allowDirectCustomForward = _value;
		_value = null;
	},

	getAllowDirectCustomForward : function(){
		return this.allowDirectCustomForward;
	},

	getCurrentOverflow : function(){
		return this.currentOverflow;
	},

	setCurrentOverflow : function(_overFlow){
		this.currentOverflow=_overFlow;
		_overFlow = null;
	},

	getTelephonyAttendantNumber : function(){
		return this.telephonyAttendantNumber;
	},

	setTelephonyAttendantNumber : function(number){
		this.telephonyAttendantNumber=number;
		number = null;
	},

	getTelephonyAssociateNumber : function(){
		return this.telephonyAssociateNumber;
	},

	setTelephonyAssociateNumber : function(number){
		this.telephonyAssociateNumber=number;
		number = null;
	},

	getTelephonyMobileNumber : function(){
		return this.telephonyMobileNumber;
	},

	setTelephonyMobileNumber : function(number){
		this.telephonyMobileNumber=number;
		number = null;
	},

	getTelephonyVmNumber : function(){
		return this.telephonyVmNumber;
	},

	setTelephonyVmNumber : function(number){
		this.telephonyVmNumber=number;
		number = null;
	},

	getArrLatestNumbers : function(){
		return this.arrLatestNumbers;
	},

	setArrLatestNumbers : function(value){
		this.arrLatestNumbers=value.split(",");
		value = null;

	},

	getCacheNumbers : function(){
		var results = [];
		/*var attendantNumber = this.getTelephonyAttendantNumber();
		var associateNumber = this.getTelephonyAssociateNumber();
		var mobileNumber = this.getTelephonyMobileNumber();
		var vmNumber = this.getTelephonyVmNumber();*/
		var latestNumbers = this.getArrLatestNumbers();
		if(latestNumbers){
			var i = latestNumbers.length;
			for(i ; i > 0 ; i--){
				results.push({strLabel : latestNumbers[i-1], type : this.DST_UNDEFINED, number : latestNumbers[i-1]});
			}
		}
		/*if(attendantNumber){
			results.push({strLabel : _(this.DST_ATTENDANT,"webapp.userservices") , type : this.DST_ATTENDANT , number : attendantNumber});
		}
		if(associateNumber){
			results.push({strLabel : _(this.DST_ASSOCIATE,"webapp.userservices") , type : this.DST_ATTENDANT , number : associateNumber});
		}
		if(mobileNumber){
			results.push({strLabel : _(this.DST_MOBILE,"webapp.userservices") , type : this.DST_MOBILE , number : mobileNumber});
		}
		if(vmNumber){
			results.push({strLabel : _(this.DST_VOICEMAIL,"webapp.userservices") , type : this.DST_VOICEMAIL , number : vmNumber});
		}*/
		this._tempCacheNumber=results;
		return results;
	},

	setCurrentAvailableDevices : function(_arrDevices){
		this.currentAvailableDevices = _arrDevices;
		_arrDevices = null;
	},

	getCurrentAvailableDevices : function(){
		return this.currentAvailableDevices;
	},


	setCurrentRoutingState : function(_routingState){
		this.objRoutingState = _routingState;
		_routingState = null;
	},

	getCurrentRoutingState : function(){
		return this.objRoutingState;
	},

	setCurrentProfile : function(_profile){
		this.currentProfile = _profile.value;
		_profile = null;
	},

	getCurrentProfile : function(){
		return this.currentProfile;
	},

	setOverflowList : function(_list){
		this._arrOverflowList = _list;
		_list = null;
	},

	getOverflowList : function(){
		return this._arrOverflowList;
	},

	setForwardList : function(_list){
		this._arrForwardList = _list;
		_list = null;
	},

	getForwardList : function(){
		return this._arrForwardList;
	},
	
	setRoutingProfileData : function(_data){
		this.routingProfileData = _data;
		_data = null;
	},

	getRoutingProfileData : function(){
		return this.routingProfileData;
	},

	isGetRoutingProfilesMade : function(){
		return this.boolIsGetRoutingProfilesMade;
	},

	setGetRoutingProfilesMade : function(isMade){
		this.boolIsGetRoutingProfilesMade = isMade;
	},
	
	getHideIdentityState : function() {
		return this.hideIdentityStatus;
	},
	
	setHideIdentityState : function(boolNewStatus) {
		this.hideIdentityStatus = boolNewStatus;
	},
	
	getHideIdentityBarringRule : function() {
		return this.hideIdentityBarringRule;
	},
	
	setHideIdentityBarringRule : function(strNewRule) {
		if(this.lstHideIdentityBarringRules[strNewRule] && this.hideIdentityBarringRule !== strNewRule){
			this.hideIdentityBarringRule = strNewRule
			if(this.isUserInfoDisplayed()){
				this.loadUserInfoDetails();
			}
		} else {
			ICTouchAPI.debugServices.warning("webapp.userservices.dataBase - onClickProfile / incorrect value: " + strNewRule + ". Current value is: " + this.hideIdentityBarringRule);
		}
	},
	
	setHideIdentityBarringRuleAllowedValues : function(objAllowedValues) {
		this.lstHideIdentityBarringRules = {};
		for(var i in objAllowedValues){
			this.lstHideIdentityBarringRules[objAllowedValues[i].id] = objAllowedValues[i].name;
		}
	},
	
	isUserInfoDisplayed : function() {
		if(this._strContainerPath == "webapp.userservices.getUserInfoContent"){
			return true;
		}
		else {
			return false;
		}
	},
	
	setHideUserIdentityButtonStatus : function(hideIdentityStatus) {
		var statusIconHI;
		if(hideIdentityStatus){
			statusIconHI = this.STATUS_ON_ICON;
		} else {
			statusIconHI = this.STATUS_OFF_ICON;
		}
		// update the button
		var appBarHI = ICTouchAPI.AppBarServices.getAppBar("userservices","userservicesstatus"+this.USER_INFO_SCREEN);
		var HIButton = appBarHI.getButton(this.HIDE_IDENTITY);
		if(HIButton){
			HIButton.setStatusIcon(statusIconHI);
		}
		if(this.hresetButtonStatus){
			clearTimeout(this.hresetButtonStatus); 
			this.hresetButtonStatus = null;
		}
		this.destroyClirSpinner();
	},
	
	createClirSpinner : function() {
		this.destroyClirSpinner();
		this.objCLIRSpinner = new UIElements.Spinner.SpinnerControl({strMessage : _("Please wait...", "ICTouchAPI"), boolForeground:true}, document.body);
		this.hCLIRSpinner = setTimeout(dojo.hitch(this, this.destroyClirSpinner), 5000);
	},
    
	destroyClirSpinner : function() {
		if(this.objCLIRSpinner){
			this.objCLIRSpinner.destroy();
			this.objCLIRSpinner = null;
		}
		if(this.hCLIRSpinner){
			clearTimeout(this.hCLIRSpinner);
			this.hCLIRSpinner = null;
		}
	}

});
dojo.require("webapp.userservices.dataBase");
dojo.provide("webapp.userservices.data");
dojo.declare("webapp.userservices.data", webapp.userservices.dataBase, {

});

webapp.userservices.data = new webapp.userservices.data();
dojo.provide("webapp.userservices.getUserServiceBase");
dojo.declare("webapp.userservices.getUserServiceBase",
	[ICTouchAPI.webWidget, dojox.dtl._Templated],
	{
		reload : function(){
			if(this.container){
				this.reloadContainer();
			}
			if(this.menu){
				this.reloadMenu();
			}
		}
	}
);
dojo.require("webapp.userservices.getUserServiceBase");
dojo.provide("webapp.userservices.getUserService");
dojo.declare("webapp.userservices.getUserService",
	webapp.userservices.getUserServiceBase,
	{
		templatePath: dojo.moduleUrl("webapp.userservices","templates/getUserService8082.html"),
		objContent : {},
		container : null,
		menu : null,

		postCreate : function(){
			this.initVariables();
			var list = this.webapp.data.getUserServiceList();
			if(list.length > 1){
				this._createNormal();
			}else{
				if(list[0]) {
					this._createFull(list[0].intIndex);
				}else{
					console.error("Error : webapp.userservices.getUSerService.postCreate");
				}
				this.webapp.updateAppBar(this.webapp.MENU_MR_SCREEN);
			}
		},

		initVariables : function(){
			this.objContent = {};
			var arrSelectListData = [];
			var funcCallback = null;
			switch (this.webapp.data.getContainerPath()){
				//Routing tab
				case "webapp.userservices.getRoutingContent" :
					arrSelectListData = this.webapp.data.getRoutingData();
					if(this.webapp.data.getMultiDeviceRoutingAvailability()){
						funcCallback = dojo.hitch(this.webapp, this.webapp.onClickProfile);
					}else{
						funcCallback = dojo.hitch(this.webapp, this.webapp.onClickRouting);
					}
					break;
				//Overflow tab
				case "webapp.userservices.getOverflowContent" :
					arrSelectListData = this.webapp.data.getOverflowData();
					funcCallback = dojo.hitch(this.webapp, this.webapp.onClickOverflow);
					break;
				//Presence tab
				case "webapp.userservices.getPresenceContent" :
					arrSelectListData = this.webapp.data.getPresenceData();
					var objUserPresence = null;
					if (webapp.userinfo) {
						objUserPresence = webapp.userinfo.data.getUserInfo().objPresence;
					}
					if (objUserPresence && objUserPresence.imPresenceValue) {
						for (var i = 0; i < arrSelectListData.length; i++) {
							arrSelectListData[i].boolSelected = (arrSelectListData[i].intIndex == objUserPresence.imPresenceValue.value.idStatus);
						}
					}
					funcCallback = dojo.hitch(this.webapp, this.webapp.onClickPresence);
					break;
				// First screen to add a routing rule : Select type
				case "webapp.userservices.getRoutingAdd1Content" :
					arrSelectListData = this.webapp.data.getRoutingTypeData();
					funcCallback = dojo.hitch(this.webapp, this.webapp.onClickRoutingType);
					break;
				// Second screen to add a routing rule : Select destination
				case "webapp.userservices.getRoutingAdd2Content" :
					arrSelectListData = this.webapp.data.getRoutingDestinationData();
					funcCallback = dojo.hitch(this.webapp, this.webapp.onClickRoutingDestination);
					break;
				// Userinfo tab
				case "webapp.userservices.getUserInfoContent" :
					arrSelectListData = this.webapp.data.getUserInfoData();
					break;
				default :
					arrSelectListData = [];
					funcCallback = null;
					break;
			}
			if(!arrSelectListData){
				arrSelectListData = [];
			}
			switch (this.webapp.data.getContainerPath()){
				case "webapp.userservices.getRoutingContent" :
					this.objContent = {
						name : "UIElements.SelectList.SelectListControl",
						params : {
							arrItems: arrSelectListData,
							boolMultiselect: false,
							itemCallback : funcCallback,
							buttonCallback : dojo.hitch(this.webapp, this.webapp.loadProfileDetails)
						}
					};
					this.webapp.data.objContent = this.objContent;
					break;
				case "webapp.userservices.getOverflowContent" :
					this.objContent = {
						name : "UIElements.SelectList.SelectListControl",
						params : {
							arrItems: arrSelectListData,
							boolMultiselect: false,
							itemCallback : funcCallback,
							buttonCallback : dojo.hitch(this.webapp, this.webapp.editOverflowNumber)
						}
					};
					this.webapp.data.objContent = this.objContent;
					break;
				case "webapp.userservices.getPresenceContent" :
				case "webapp.userservices.getRoutingAdd1Content" :
				case "webapp.userservices.getRoutingAdd2Content" :
					this.objContent = {
						name : "UIElements.SelectList.SelectListControl",
						params : {
							arrItems: arrSelectListData,
							boolMultiselect: false,
							itemCallback : funcCallback
						}
					};
					this.webapp.data.objContent = this.objContent;
					break;
				case "webapp.userservices.getUserInfoContent" :
					this.objContent = {
						name : "UIElements.PresentationList.PresentationListControl",
						params : {
							arrItems: arrSelectListData,
							boolShowLabel: true
						}
					};
					break;
				case "webapp.userservices.getVideoContent" :
					this.objContent = {
						name : "UIElements.Video.VideoControl",
						params : {
						}
					};
				default :
					break;
			}
			arrSelectListData = null;
			funcCallback = null;
		},

		_createNormal : function(){
			this.webapp.data.mainWidget = this;
			var am = new UIElements.ApplicationMode.ThirdControl({
				menu : {
					name    : "UIElements.MenuList.MenuListControl",
					params  : {
						arrItems: this.webapp.data.getUserServiceList(),
						autoSelectFirst : false,
						callback: dojo.hitch(this.webapp, this.webapp.onListClick)
					}
				},
				container : this.objContent,
				objMenuTitle: {
                    strLabel : this.webapp.data.getUserServiceListTitle()
                },
				objContainerTitle: {
                    strLabel :  this.webapp.data.getUserServiceContainerTitle()
                }
			},this.mainPart);
			this.container = am.getContainer();
			this.menu = am.getMenu();

			//Select the item from the menu
			if(this.webapp.data.intSelectListItem != -1){
				this.menu.getContent().selectItemByIndex(this.webapp.data.intSelectListItem, true);
			}else{
				this.menu.getContent().selectItemByPosition(0, true);
			}
			am = null;

		},

		_createFull : function(id){
			var am = new UIElements.ApplicationMode.FullControl({
				content : this.objContent,
				objTitle: {
                    strLabel :  this.webapp.data.getUserServiceContainerTitle()
                }
			},this.mainPart);
			this.container = am.getContent();
			this.menu = null;
			this.webapp.data.mainWidget = this;
			this.webapp.servicesList = null;
			this.webapp.onListClick(id);
			id = null;
		},

		reloadContainer: function() {
			ICTouchAPI.debugServices.debug('webapp.userservices.getUserService8082 - reloadContainer');
			if(this.webapp.data.getContainerPath() !== "webapp.userservices.getVideoContent" && this.container._uiContent.namespace == "UIElements.Video"){
				// If we destroy the video widget from userservices, the default value is to destroy completely the video
				// instead of just hiding it
				this.container._uiContent.destroy(true);
			}
			
			this.initVariables();
			this.container.reload({
                objTitle: {
					strLabel : this.webapp.data.getUserServiceContainerTitle()
				},
                objContent: this.objContent
            });
			// workaround to call the startup() method of the Video UIElements
			// when the video entry is selected
			if(this.webapp.data.getContainerPath() === "webapp.userservices.getVideoContent"){
				ICTouchAPI.debugServices.debug('webapp.userservices.getUserService8082 - reloadContainer / send startup()');
				this.container._uiContent.startup()
			}
		},

		reloadMenu: function() {
			this.menu.reload({
                objTitle: {
					strLabel : this.webapp.data.getUserServiceListTitle()
				},
                objContent: {
                    name    : "UIElements.MenuList.MenuListControl",
					params  : {
						arrItems: this.webapp.data.getUserServiceList(),
						autoSelectFirst : true,
						callback: dojo.hitch(this.webapp, this.webapp.onListClick)
					}
                }
            });
		}
	}
);
dojo.provide("webapp.userservices.getRoutingListBase");
dojo.declare("webapp.userservices.getRoutingListBase",
	[ICTouchAPI.webWidget, dojox.dtl._Templated],
	{
		domRoutingListTitle	: null,
		domRoutingList		: null,
		listUI			: null,
		itemCallback	: null,
		removeNoneElem	: false,

		postCreate : function() {
			var routingList = this.webapp.data.getRoutingData();
			if(routingList[0].intIndex===0) {
			routingList.splice(0,1);
			}
			for(var i in routingList)
				{
					routingList[i].strContent=routingList[i].strLabel;
				}
			this.listUI = new UIElements.SelectList.SelectListControl({
				arrItems: routingList,
				intContainerSize: 7,
				boolMultiselect: false,
				boolScroll: true,
				itemCallback: this.itemCallback
			}, this.domRoutingList);
			this.listUI.unselectAll();
		},

		selectRouting : function(intIndex) {
			var position = 0;
			var boolSelect = false;
			if(intIndex && intIndex != ""){
				if(!isNaN(intIndex)){
					for (var i = 0; i < this.listUI.arrItems.length; i++) {
						if(this.listUI.arrItems[i].intIndex == intIndex){
							position = i;
							boolSelect = true;
							break;
						}
					}
					if(boolSelect){
						this.listUI.selectAtIndex(position);
					}
				}else{
					this.listUI.selectAtIndex(0);
					this.webapp._progKeySetArgs(-1, intIndex.split(";")[2]);
				}
				if(this.itemCallback) {
					this.itemCallback(position);
				}
			}
			intIndex = null;
		},

		destroy : function() {
			this.listUI.destroy();
			this.inherited(arguments);
		}

	}
);
dojo.require("webapp.userservices.getRoutingListBase");
dojo.provide("webapp.userservices.getRoutingList");
dojo.declare("webapp.userservices.getRoutingList",
	webapp.userservices.getRoutingListBase,
	{
		templatePath: dojo.moduleUrl("webapp.userservices","templates/getRoutingList8082.html")
	});
dojo.provide("webapp.userservices.getProfileDetailsBase");
dojo.declare("webapp.userservices.getProfileDetailsBase",
	[ICTouchAPI.webWidget, dojox.dtl._Templated],
	{
		domProfileDetails	: null,
		_profileDetails		: null,

		postCreate : function() {
			var arrItemsDevice = this.buildArrItems(this._profileDetails,null);
			var strTitle = _(["Routing profile",this._profileDetails.profileName], "webapp.userservices");
			var listDevice = new UIElements.ApplicationMode.FullControl(
			{
				content : {
					name	: "UIElements.SelectList.SelectListControl",
					params  : {
						arrItems : arrItemsDevice,
						boolMultiselect: true,
						boolScroll: true,
						itemCallback : dojo.hitch(this.webapp, this.webapp.storeSelectedDevices),
						buttonCallback : dojo.hitch(this.webapp.data, this.webapp.data.onOtherSearch)
					}
				},
				objTitle : {
					strLabel: strTitle
				}
			}, this.domProfileDetails);
			this.webapp.data.objDetailsScreen = listDevice.getContent();
			this.webapp.data.widgetProfileDetails = this;
			this.inherited(arguments);
		},

		reloadList: function(newDetails,reloadCurrent) {
			if(newDetails){
				this._profileDetails = newDetails;
			}
			var arrItemsDevice;
			if(reloadCurrent){
				arrItemsDevice = this.buildArrItems(null,this.webapp.data.getCurrentAvailableDevices());
			}else{
				arrItemsDevice = this.buildArrItems(this._profileDetails,null);
			}
			
			this.webapp.data.objDetailsScreen.reload({
				objTitle: {
						strLabel : _(["Routing profile",this._profileDetails.profileName], "webapp.userservices")
					},
				objContent : {
					name	: "UIElements.SelectList.SelectListControl",
					params  : {
						arrItems : arrItemsDevice,
						boolMultiselect: true,
						itemCallback : dojo.hitch(this.webapp, this.webapp.storeSelectedDevices),
						buttonCallback : dojo.hitch(this.webapp.data, this.webapp.data.onOtherSearch)
					}
				}
			});
		},

		buildArrItems : function(_profileDetails,_devicesList){
			if(_profileDetails){
				var _listRoute = _profileDetails.listPresentationRoute;
				var _forwardRoute = _profileDetails.listForwardDestination;
				for(var forward in _forwardRoute){
					if(_forwardRoute[forward].forwardDestinationType.value.value == this.webapp.data.FWD_DESTINATION_USER){
						_listRoute.push({
							presentationDestinationType :{
								type	: "PresentationDestinationType",
								value	: {
									value : this.webapp.data.DEVICE_USER
								}
							},
							phoneNumber : _forwardRoute[forward].phoneNumber,
							isSelected	: _forwardRoute[forward].isSelected,
							userInformation : _forwardRoute[forward].userInformation
						});
					}else if(_forwardRoute[forward].forwardDestinationType.value.value == this.webapp.data.FWD_DESTINATION_VOICEMAIL){
						if(this.webapp.data.boolVmNumber){
							_listRoute.push({
								presentationDestinationType :{
									type	: "PresentationDestinationType",
									value	: {
										value : this.webapp.data.DEVICE_VM
									}
								},
								phoneNumber : _forwardRoute[forward].phoneNumber,
								isSelected	: _forwardRoute[forward].isSelected,
								userInformation : _forwardRoute[forward].userInformation
							});
						}
					}
				}
			}else if(_devicesList){
				_listRoute = _devicesList;
			}else{
				ICTouchAPI.debugServices.error("Error : List of devices is empty");
			}
			var _arrDevice = [];
			var index = 0;
			for(var route in _listRoute){
				if(_listRoute[route].presentationDestinationType.value.value==this.webapp.data.DEVICE_USER){
					if(this.webapp.data.currentProfileId != "CUSTOM"){
						if(this.webapp.data.isUserInfoNotEmpty(_listRoute[route])){
						var _i18nLabel;
							if(this.webapp.data.isUserInfoNotEmpty(_listRoute[route])){
								_i18nLabel = _([_listRoute[route].presentationDestinationType.value.value,ICTouchAPI.tools.getContactDisplayName(_listRoute[route].userInformation.value)],"webapp.userservices");
							}else{
								_i18nLabel = _([_listRoute[route].presentationDestinationType.value.value],"webapp.userservices");
							}
							_arrDevice.push({
								boolEnabled : false,
								intIndex: index,
								boolSelected: _listRoute[route].isSelected,
								strLabel: _i18nLabel
							});
						}
					}
				}else if(_listRoute[route].presentationDestinationType.value.value==this.webapp.data.DEVICE_OTHER){
					var _i18nLabel;
					if(_listRoute[route].phoneNumber!="" && _listRoute[route].isSelected ){
						this.webapp.data.otherRoutingNumber = _listRoute[route].phoneNumber;
						var objContact = ICTouchAPI.dataStoreServices.getStore('contacts').find(["officePhone", "personalHome", "personalMobile","officePhoneCan", "personalHomeCan", "personalMobileCan", "personalFax"],_listRoute[route].phoneNumber)[0];
						if(objContact){
							_i18nLabel = _([_listRoute[route].presentationDestinationType.value.value, "("+objContact.name+" "+objContact.firstName+")"], "webapp.userservices");
						}else{
							_i18nLabel = _([_listRoute[route].presentationDestinationType.value.value, "("+_listRoute[route].phoneNumber+")" ],"webapp.userservices");
						}
					}else{
						if (this.webapp.data.otherRoutingNumber) {
							_listRoute[route].phoneNumber = this.webapp.data.otherRoutingNumber;
							_listRoute[route].doDialableOtherNumber = this.webapp.data.otherRoutingNumberIsDialable;
						}
						else {
							_listRoute[route].phoneNumber = "";
						}
						_i18nLabel = _([_listRoute[route].presentationDestinationType.value.value, "("+_listRoute[route].phoneNumber+")" ],"webapp.userservices");
					}
					_arrDevice.push({
						boolEnabled : (this.webapp.data.currentProfileId != "CUSTOM") ? false : true,
						intIndex: index,
						boolSelected: _listRoute[route].isSelected,
						strLabel: _i18nLabel,
						strActionIcon : "userservices-more"
					});
				}else if(_listRoute[route].presentationDestinationType.value.value==this.webapp.data.DEVICE_VM){
					if(this.webapp.data.currentProfileId != "CUSTOM"){
						this.webapp.data.isVMSelected = _listRoute[route].isSelected;
						_arrDevice.push({
							boolEnabled : (this.webapp.data.currentProfileId != "CUSTOM") ? false : true,
							intIndex: index,
							boolSelected: _listRoute[route].isSelected,
							strLabel: _(_listRoute[route].presentationDestinationType.value.value,"webapp.userservices")
						});
					}
				}else{
					_arrDevice.push({
						boolEnabled : (this.webapp.data.currentProfileId != "CUSTOM") ? false : true,
						intIndex: index,
						boolSelected: _listRoute[route].isSelected,
						strLabel: _(_listRoute[route].presentationDestinationType.value.value,"webapp.userservices")
					});
				}
				index++;
			}
			this.webapp.data.setCurrentAvailableDevices(_listRoute);
			_profileDetails = null;
			return _arrDevice;
		}
	}
);
dojo.require("webapp.userservices.getProfileDetailsBase");
dojo.provide("webapp.userservices.getProfileDetails");
dojo.declare("webapp.userservices.getProfileDetails",
	webapp.userservices.getProfileDetailsBase,
	{
		templatePath: dojo.moduleUrl("webapp.userservices","templates/getProfileDetails8082.html")
	});