dojo.require("webapp.userservices.getUserServiceBase");
dojo.provide("webapp.userservices.getUserService");
dojo.declare("webapp.userservices.getUserService",
	webapp.userservices.getUserServiceBase,
	{
		templatePath: dojo.moduleUrl("webapp.userservices","templates/getUserService8082.html"),
		objContent : {},
		container : null,
		menu : null,

		postCreate : function(){
			this.initVariables();
			var list = this.webapp.data.getUserServiceList();
			if(list.length > 1){
				this._createNormal();
			}else{
				if(list[0]) {
					this._createFull(list[0].intIndex);
				}else{
					console.error("Error : webapp.userservices.getUSerService.postCreate");
				}
				this.webapp.updateAppBar(this.webapp.MENU_MR_SCREEN);
			}
		},

		initVariables : function(){
			this.objContent = {};
			var arrSelectListData = [];
			var funcCallback = null;
			switch (this.webapp.data.getContainerPath()){
				//Routing tab
				case "webapp.userservices.getRoutingContent" :
					arrSelectListData = this.webapp.data.getRoutingData();
					if(this.webapp.data.getMultiDeviceRoutingAvailability()){
						funcCallback = dojo.hitch(this.webapp, this.webapp.onClickProfile);
					}else{
						funcCallback = dojo.hitch(this.webapp, this.webapp.onClickRouting);
					}
					break;
				//Overflow tab
				case "webapp.userservices.getOverflowContent" :
					arrSelectListData = this.webapp.data.getOverflowData();
					funcCallback = dojo.hitch(this.webapp, this.webapp.onClickOverflow);
					break;
				//Presence tab
				case "webapp.userservices.getPresenceContent" :
					arrSelectListData = this.webapp.data.getPresenceData();
					var objUserPresence = null;
					if (webapp.userinfo) {
						objUserPresence = webapp.userinfo.data.getUserInfo().objPresence;
					}
					if (objUserPresence && objUserPresence.imPresenceValue) {
						for (var i = 0; i < arrSelectListData.length; i++) {
							arrSelectListData[i].boolSelected = (arrSelectListData[i].intIndex == objUserPresence.imPresenceValue.value.idStatus);
						}
					}
					funcCallback = dojo.hitch(this.webapp, this.webapp.onClickPresence);
					break;
				// First screen to add a routing rule : Select type
				case "webapp.userservices.getRoutingAdd1Content" :
					arrSelectListData = this.webapp.data.getRoutingTypeData();
					funcCallback = dojo.hitch(this.webapp, this.webapp.onClickRoutingType);
					break;
				// Second screen to add a routing rule : Select destination
				case "webapp.userservices.getRoutingAdd2Content" :
					arrSelectListData = this.webapp.data.getRoutingDestinationData();
					funcCallback = dojo.hitch(this.webapp, this.webapp.onClickRoutingDestination);
					break;
				// Userinfo tab
				case "webapp.userservices.getUserInfoContent" :
					arrSelectListData = this.webapp.data.getUserInfoData();
					break;
				default :
					arrSelectListData = [];
					funcCallback = null;
					break;
			}
			if(!arrSelectListData){
				arrSelectListData = [];
			}
			switch (this.webapp.data.getContainerPath()){
				case "webapp.userservices.getRoutingContent" :
					this.objContent = {
						name : "UIElements.SelectList.SelectListControl",
						params : {
							arrItems: arrSelectListData,
							boolMultiselect: false,
							itemCallback : funcCallback,
							buttonCallback : dojo.hitch(this.webapp, this.webapp.loadProfileDetails)
						}
					};
					this.webapp.data.objContent = this.objContent;
					break;
				case "webapp.userservices.getOverflowContent" :
					this.objContent = {
						name : "UIElements.SelectList.SelectListControl",
						params : {
							arrItems: arrSelectListData,
							boolMultiselect: false,
							itemCallback : funcCallback,
							buttonCallback : dojo.hitch(this.webapp, this.webapp.editOverflowNumber)
						}
					};
					this.webapp.data.objContent = this.objContent;
					break;
				case "webapp.userservices.getPresenceContent" :
				case "webapp.userservices.getRoutingAdd1Content" :
				case "webapp.userservices.getRoutingAdd2Content" :
					this.objContent = {
						name : "UIElements.SelectList.SelectListControl",
						params : {
							arrItems: arrSelectListData,
							boolMultiselect: false,
							itemCallback : funcCallback
						}
					};
					this.webapp.data.objContent = this.objContent;
					break;
				case "webapp.userservices.getUserInfoContent" :
					this.objContent = {
						name : "UIElements.PresentationList.PresentationListControl",
						params : {
							arrItems: arrSelectListData,
							boolShowLabel: true
						}
					};
					break;
				case "webapp.userservices.getVideoContent" :
					this.objContent = {
						name : "UIElements.Video.VideoControl",
						params : {
						}
					};
				default :
					break;
			}
			arrSelectListData = null;
			funcCallback = null;
		},

		_createNormal : function(){
			this.webapp.data.mainWidget = this;
			var am = new UIElements.ApplicationMode.ThirdControl({
				menu : {
					name    : "UIElements.MenuList.MenuListControl",
					params  : {
						arrItems: this.webapp.data.getUserServiceList(),
						autoSelectFirst : false,
						callback: dojo.hitch(this.webapp, this.webapp.onListClick)
					}
				},
				container : this.objContent,
				objMenuTitle: {
                    strLabel : this.webapp.data.getUserServiceListTitle()
                },
				objContainerTitle: {
                    strLabel :  this.webapp.data.getUserServiceContainerTitle()
                }
			},this.mainPart);
			this.container = am.getContainer();
			this.menu = am.getMenu();

			//Select the item from the menu
			if(this.webapp.data.intSelectListItem != -1){
				this.menu.getContent().selectItemByIndex(this.webapp.data.intSelectListItem, true);
			}else{
				this.menu.getContent().selectItemByPosition(0, true);
			}
			am = null;

		},

		_createFull : function(id){
			var am = new UIElements.ApplicationMode.FullControl({
				content : this.objContent,
				objTitle: {
                    strLabel :  this.webapp.data.getUserServiceContainerTitle()
                }
			},this.mainPart);
			this.container = am.getContent();
			this.menu = null;
			this.webapp.data.mainWidget = this;
			this.webapp.servicesList = null;
			this.webapp.onListClick(id);
			id = null;
		},

		reloadContainer: function() {
			ICTouchAPI.debugServices.debug('webapp.userservices.getUserService8082 - reloadContainer');
			if(this.webapp.data.getContainerPath() !== "webapp.userservices.getVideoContent" && this.container._uiContent.namespace == "UIElements.Video"){
				// If we destroy the video widget from userservices, the default value is to destroy completely the video
				// instead of just hiding it
				this.container._uiContent.destroy(true);
			}
			
			this.initVariables();
			this.container.reload({
                objTitle: {
					strLabel : this.webapp.data.getUserServiceContainerTitle()
				},
                objContent: this.objContent
            });
			// workaround to call the startup() method of the Video UIElements
			// when the video entry is selected
			if(this.webapp.data.getContainerPath() === "webapp.userservices.getVideoContent"){
				ICTouchAPI.debugServices.debug('webapp.userservices.getUserService8082 - reloadContainer / send startup()');
				this.container._uiContent.startup()
			}
		},

		reloadMenu: function() {
			this.menu.reload({
                objTitle: {
					strLabel : this.webapp.data.getUserServiceListTitle()
				},
                objContent: {
                    name    : "UIElements.MenuList.MenuListControl",
					params  : {
						arrItems: this.webapp.data.getUserServiceList(),
						autoSelectFirst : true,
						callback: dojo.hitch(this.webapp, this.webapp.onListClick)
					}
                }
            });
		}
	}
);
