dojo.provide("webapp.userservices.getProfileDetailsBase");
dojo.declare("webapp.userservices.getProfileDetailsBase",
	[ICTouchAPI.webWidget, dojox.dtl._Templated],
	{
		domProfileDetails	: null,
		_profileDetails		: null,

		postCreate : function() {
			var arrItemsDevice = this.buildArrItems(this._profileDetails,null);
			var strTitle = _(["Routing profile",this._profileDetails.profileName], "webapp.userservices");
			var listDevice = new UIElements.ApplicationMode.FullControl(
			{
				content : {
					name	: "UIElements.SelectList.SelectListControl",
					params  : {
						arrItems : arrItemsDevice,
						boolMultiselect: true,
						boolScroll: true,
						itemCallback : dojo.hitch(this.webapp, this.webapp.storeSelectedDevices),
						buttonCallback : dojo.hitch(this.webapp.data, this.webapp.data.onOtherSearch)
					}
				},
				objTitle : {
					strLabel: strTitle
				}
			}, this.domProfileDetails);
			this.webapp.data.objDetailsScreen = listDevice.getContent();
			this.webapp.data.widgetProfileDetails = this;
			this.inherited(arguments);
		},

		reloadList: function(newDetails,reloadCurrent) {
			if(newDetails){
				this._profileDetails = newDetails;
			}
			var arrItemsDevice;
			if(reloadCurrent){
				arrItemsDevice = this.buildArrItems(null,this.webapp.data.getCurrentAvailableDevices());
			}else{
				arrItemsDevice = this.buildArrItems(this._profileDetails,null);
			}
			
			this.webapp.data.objDetailsScreen.reload({
				objTitle: {
						strLabel : _(["Routing profile",this._profileDetails.profileName], "webapp.userservices")
					},
				objContent : {
					name	: "UIElements.SelectList.SelectListControl",
					params  : {
						arrItems : arrItemsDevice,
						boolMultiselect: true,
						itemCallback : dojo.hitch(this.webapp, this.webapp.storeSelectedDevices),
						buttonCallback : dojo.hitch(this.webapp.data, this.webapp.data.onOtherSearch)
					}
				}
			});
		},

		buildArrItems : function(_profileDetails,_devicesList){
			if(_profileDetails){
				var _listRoute = _profileDetails.listPresentationRoute;
				var _forwardRoute = _profileDetails.listForwardDestination;
				for(var forward in _forwardRoute){
					if(_forwardRoute[forward].forwardDestinationType.value.value == this.webapp.data.FWD_DESTINATION_USER){
						_listRoute.push({
							presentationDestinationType :{
								type	: "PresentationDestinationType",
								value	: {
									value : this.webapp.data.DEVICE_USER
								}
							},
							phoneNumber : _forwardRoute[forward].phoneNumber,
							isSelected	: _forwardRoute[forward].isSelected,
							userInformation : _forwardRoute[forward].userInformation
						});
					}else if(_forwardRoute[forward].forwardDestinationType.value.value == this.webapp.data.FWD_DESTINATION_VOICEMAIL){
						if(this.webapp.data.boolVmNumber){
							_listRoute.push({
								presentationDestinationType :{
									type	: "PresentationDestinationType",
									value	: {
										value : this.webapp.data.DEVICE_VM
									}
								},
								phoneNumber : _forwardRoute[forward].phoneNumber,
								isSelected	: _forwardRoute[forward].isSelected,
								userInformation : _forwardRoute[forward].userInformation
							});
						}
					}
				}
			}else if(_devicesList){
				_listRoute = _devicesList;
			}else{
				ICTouchAPI.debugServices.error("Error : List of devices is empty");
			}
			var _arrDevice = [];
			var index = 0;
			for(var route in _listRoute){
				if(_listRoute[route].presentationDestinationType.value.value==this.webapp.data.DEVICE_USER){
					if(this.webapp.data.currentProfileId != "CUSTOM"){
						if(this.webapp.data.isUserInfoNotEmpty(_listRoute[route])){
						var _i18nLabel;
							if(this.webapp.data.isUserInfoNotEmpty(_listRoute[route])){
								_i18nLabel = _([_listRoute[route].presentationDestinationType.value.value,ICTouchAPI.tools.getContactDisplayName(_listRoute[route].userInformation.value)],"webapp.userservices");
							}else{
								_i18nLabel = _([_listRoute[route].presentationDestinationType.value.value],"webapp.userservices");
							}
							_arrDevice.push({
								boolEnabled : false,
								intIndex: index,
								boolSelected: _listRoute[route].isSelected,
								strLabel: _i18nLabel
							});
						}
					}
				}else if(_listRoute[route].presentationDestinationType.value.value==this.webapp.data.DEVICE_OTHER){
					var _i18nLabel;
					if(_listRoute[route].phoneNumber!="" && _listRoute[route].isSelected ){
						this.webapp.data.otherRoutingNumber = _listRoute[route].phoneNumber;
						var objContact = ICTouchAPI.dataStoreServices.getStore('contacts').find(["officePhone", "personalHome", "personalMobile","officePhoneCan", "personalHomeCan", "personalMobileCan", "personalFax"],_listRoute[route].phoneNumber)[0];
						if(objContact){
							_i18nLabel = _([_listRoute[route].presentationDestinationType.value.value, "("+objContact.name+" "+objContact.firstName+")"], "webapp.userservices");
						}else{
							_i18nLabel = _([_listRoute[route].presentationDestinationType.value.value, "("+_listRoute[route].phoneNumber+")" ],"webapp.userservices");
						}
					}else{
						if (this.webapp.data.otherRoutingNumber) {
							_listRoute[route].phoneNumber = this.webapp.data.otherRoutingNumber;
							_listRoute[route].doDialableOtherNumber = this.webapp.data.otherRoutingNumberIsDialable;
						}
						else {
							_listRoute[route].phoneNumber = "";
						}
						_i18nLabel = _([_listRoute[route].presentationDestinationType.value.value, "("+_listRoute[route].phoneNumber+")" ],"webapp.userservices");
					}
					_arrDevice.push({
						boolEnabled : (this.webapp.data.currentProfileId != "CUSTOM") ? false : true,
						intIndex: index,
						boolSelected: _listRoute[route].isSelected,
						strLabel: _i18nLabel,
						strActionIcon : "userservices-more"
					});
				}else if(_listRoute[route].presentationDestinationType.value.value==this.webapp.data.DEVICE_VM){
					if(this.webapp.data.currentProfileId != "CUSTOM"){
						this.webapp.data.isVMSelected = _listRoute[route].isSelected;
						_arrDevice.push({
							boolEnabled : (this.webapp.data.currentProfileId != "CUSTOM") ? false : true,
							intIndex: index,
							boolSelected: _listRoute[route].isSelected,
							strLabel: _(_listRoute[route].presentationDestinationType.value.value,"webapp.userservices")
						});
					}
				}else{
					_arrDevice.push({
						boolEnabled : (this.webapp.data.currentProfileId != "CUSTOM") ? false : true,
						intIndex: index,
						boolSelected: _listRoute[route].isSelected,
						strLabel: _(_listRoute[route].presentationDestinationType.value.value,"webapp.userservices")
					});
				}
				index++;
			}
			this.webapp.data.setCurrentAvailableDevices(_listRoute);
			_profileDetails = null;
			return _arrDevice;
		}
	}
);
