dojo.provide("webapp.userservices.dataBase");
dojo.declare("webapp.userservices.dataBase", null, {

	_arrAppButtons                  : [], //Buttons definition
	_arrAppBarSkeleton				: [], //Appbar definition - order button
	_strUserServiceContainerTitle   : "",
	_strUserServiceListTitle        : _("User service", "webapp.userservices"),
	_strContainerPath               : "",
	_arrListEntries                 : [], //Entry tabs in the MenuList
	_arrAllDetails                  : [],  // 2-dimensions array
	_arrProfilesSummaryList			: [],
	_arrOverflowList				: [],
	_arrForwardList					: null,
	objUserServiceContent           : null,
	objContent						: null,
	objListUI                       : null,
	objDetailsScreen				: null,
	intSelectListItem               : (-1),
	dndButtonStatus					: false,
	dndAvailability					: true,
	objPopup						: null,
	objCurrentPresenceStatus		: {
		idIMStatus: -1,
		message:""
	},
	objLastPresenceStatus			: {
		idIMStatus: -1,
		message:""
	},
	intPKArgs						: null,
	_nextPKButton					: null,

	//  Widgets and others DOM Elements
	PKWidget				: null,
	mainWidget				: null,
	widgetProfileDetails	: null,

	// The current mode : normal, modify routing or delete routing
	currentMode						: 0,
	NORMAL_MODE						: 0,
	MODIFY_MODE						: 1,
	DELETE_MODE						: 2,

	// Full forward (add, modify...) : false, or simplified (just 3 choices) : true
	boolSimplifiedForwardMode		: false,
	allowDirectCustomForward		: false,
	boolDndRequiresPassword			: false,
	boolVmNumber					: false,

	objPopupConfirmDND 			: null,
	boolLockDNDPopup 			: false,

	accessRightToUserServices		: true,
	boolIMAvailabilityChanged		: false,
	isVMSelected					: false,
	boolCustomRoute					: false,
	boolForwardSet					: false,
	isLocalVideoEnabled				: false,

	currentRoutingID				: -2,
	currentRoutingLabel				: "",
	currentRouting					: {},
	currentOverflow					: {},
	currentProfile					: {},
	currentProfileLabel				: "",
	otherRoutingNumber				: null,
	otherRoutingNumberIsDialable			: null,
	otherOverflowNumber				: null,
	otherOverflowNumberNoReply			: null,
	otherOverflowUser				: null,
	otherOverflowUserNoReply			: null,
	currentOverflowType				: null,
	currentUserInfo					: "",
	currentProfileId				: "",
	otherUserNumber					: null,
	customRoute						: null,

	//Capability
	multiDeviceRoutingAvailability : false,

	// Status Icons for appButtons
	STATUS_ON_ICON			: 'notif-on',
	STATUS_OFF_ICON			: 'notif-off',

	// Contact addressMap keys constants managed by UserServices
	ADDRESSKEY_MAINPHONE    : "Phone",
	ADDRESSKEY_MOBILEPHONE  : "Mobile",
	ADDRESSKEY_EXTRAPHONE   : "Other phone",

	// Constants for routing
	NONE					: "None",
	FWD_UNCONDITIONAL		: "FWD_UNCONDITIONAL",
	FWD_ON_BUSY_OR_NO_REPLY : "FWD_ON_BUSY_OR_NO_REPLY",
	DST_VOICEMAIL			: "DST_VOICE_MAIL",
	DST_OTHER				: "Other",
	DST_UNDEFINED			: "DST_UNDEFINED",
	DST_ATTENDANT			: "DST_ATTENDANT",
	DST_ASSOCIATE			: "DST_ASSOCIATE",
	DST_MOBILE				: "DST_MOBILE",
	DST_USER				: "DST_USER",
	IMMEDIATE_CUSTOM		: "FWD_UNCONDITIONAL;%s",


	OVF_NONE					:"OVF_NONE",
	OVF_ON_NO_REPLY				:"OVF_ON_NO_REPLY",
	OVF_ON_BUSY					:"OVF_ON_BUSY",
	OVF_ON_BUSY_OR_NO_REPLY		:"OVF_ON_BUSY_OR_NO_REPLY",
	OVF_UNKNOWN_TYPE			:"OVF_UNKNOWN_TYPE",

	OVF_DESTINATION_UNKNOWN		:"OVF_DESTINATION_UNKNOWN",
	OVF_DESTINATION_VOICEMAIL	:"OVF_DESTINATION_VOICEMAIL",
	OVF_DESTINATION_USER		:"OVF_DESTINATION_USER",
	OVF_DESTINATION_NUMBER		:"OVF_DESTINATION_NUMBER",

	FWD_DESTINATION_VOICEMAIL	:"FWD_DESTINATION_VOICEMAIL",
	FWD_DESTINATION_USER		:"FWD_DESTINATION_USER",

	// constant values for subscreen ids ( MUST be sequential )
	PRESENCE_IM_SCREEN		: 0,
	ROUTING_SCREEN			: 1,
	OVERFLOW_SCREEN			: 2,
	USER_INFO_SCREEN		: 3,
	ADD_ROUTING_1_SCREEN	: 4,
	ADD_ROUTING_2_SCREEN	: 5,
	ADD_OVERFLOW_1_SCREEN	: 6,
	ADD_OVERFLOW_2_SCREEN	: 7,
	PROFILE_DETAILS_SCREEN	: 8,
	VIDEO_SCREEN			: 9,
	NB_STATUS				: 10,

	// Constant values for the button's id
	BACK			: "BACK_BTN",
	ADD_ROUTING		: "ADD_ROUTING_BTN",
	MODIFY_ROUTING	: "MODIFY_ROUTING_BTN",
	DELETE_ROUTING	: "DELETE_ROUTING_BTN",
	CUSTOM			: "CUSTOM_BTN",
	DND				: "DND_BTN",
	SR_SAVE			: "SR_SAVE_BTN",
	SR_RESTORE		: "SR_RESTORE_BTN",
	NEXT			: "NEXT_BTN",
	SAVE			: "SAVE_BTN",
	YES				: "YES_BTN",
	NO				: "NO_BTN",
	LOGIN			: "LOGIN_BTN",
	SUPERVISION		: "SUPERVISION_BTN",
	HIDE_IDENTITY	: "HIDE_IDENTITY_BTN",

	// LEDS and LEDS STATUS
	LED_USERSERVICE : 4,
	LED_STATUS_OFF : 0,
	LED_STATUS_ON  : 1,

	//Constant list of device types
	DEVICE_OFFICE	: "OFFICE_DEVICE",
	DEVICE_MOBILE	: "MOBILE_DEVICE",
	DEVICE_PC		: "PERSONAL_COMPUTER_DEVICE",
	DEVICE_TABLET	: "TABLET_DEVICE",
	DEVICE_VIDEO	: "VIDEO_DEVICE",
	DEVICE_HOME		: "HOME_DEVICE",
	DEVICE_OTHER	: "OTHER_DEVICE",
	DEVICE_VM		: "VOICEMAIL_DEVICE",
	DEVICE_USER		: "USER_DEVICE",
	DEVICE_UNKNOWN	: "DEVICE_TYPE_UNKNOWN",

	//Cache numbers
	telephonyAttendantNumber : null,
	telephonyAssociateNumber : null,
	telephonyMobileNumber : null,
	telephonyVmNumber : null,
	arrLatestNumbers : [],
	_tempCacheNumber : null,
	currentAvailableDevices : [],
	objRoutingState : null,
	lastIsRoutingTarget : null,
	boolIsGetRoutingProfilesMade : false,
	boolMutex : false,
	waitingProfiles : [],

	// Hide identity
	hideIdentityStatus : true,
	hideIdentityBarringRule : null,
	hresetButtonStatus : null,
	hCLIRSpinner : null,
	objCLIRSpinner : null,
	/*
	 * Filled by allowedValues of setting TelephonyHideIdentityBarringRule : 
	 */
	lstHideIdentityBarringRules : {},
	
	// Supervision hidden state
	_supervisionHiddenState : null,

	constructor : function(){
		var func = dojo.hitch(webapp.userservices, webapp.userservices.buttonCallback);
		
		this._supervisionHiddenState = ICTouchAPI.supervisionServices.getSupervisionHidden();
		dojo.subscribe("supervision.hiddenStateChanged", this, function(boolState){
			this._supervisionHiddenState = boolState;
			// If user info was the displayed entry, reload it to update the status.
			if(this._strContainerPath == "webapp.userservices.getUserInfoContent"){
				ICTouchAPI.debugServices.debug("webapp.userservices.dataBase / supervision hidden state changed: reload user info card");
				this.loadUserInfoDetails();
			}
		});
		
		//Definition of all buttons
		this._arrAppButtons[this.CUSTOM] = {
			strButtonName: this.CUSTOM,
			strButtonLabel: _("Custom", "webapp.userservices"),
			strButtonIcon: 'generic-modify',
			strStatusText:'',
			strStatusIcon:'',
			callback: func
		}
		this._arrAppButtons[this.ADD_ROUTING] = {
			strButtonName: this.ADD_ROUTING,
			strButtonLabel: _('Add', 'ICTouchAPI'),
			strButtonIcon: 'generic-add',
			strStatusText:'',
			strStatusIcon:'',
			callback: func
		}
		this._arrAppButtons[this.MODIFY_ROUTING] = {
			strButtonName: this.MODIFY_ROUTING,
			strButtonLabel: _('Modify', 'ICTouchAPI'),
			strButtonIcon: 'generic-modify',
			strStatusText:'',
			strStatusIcon: 'notif-off',
			callback: func
		}
		this._arrAppButtons[this.DELETE_ROUTING] = {
			strButtonName: this.DELETE_ROUTING,
			strButtonLabel: _('Delete', 'ICTouchAPI'),
			strButtonIcon: 'generic-mode-delete',
			strStatusText:'',
			strStatusIcon:'notif-off',
			callback: func
		}
		this._arrAppButtons[this.NEXT] = {
			strButtonName: this.NEXT,
			strButtonLabel: _('Next', 'ICTouchAPI'),
			strButtonIcon: 'generic-next',
			strStatusText:'',
			strStatusIcon:'',
			callback: func
		}
		this._arrAppButtons[this.SAVE] = {
			strButtonName: this.SAVE,
			strButtonLabel: _("Save", "ICTouchAPI"),
			strButtonIcon: 'generic-save',
			strStatusText:'',
			strStatusIcon:'',
			callback: func
		}
		this._arrAppButtons[this.LOGIN] = {
			strButtonName: this.LOGIN,
			strButtonLabel: _("Login", "webapp.userservices"),
			strButtonIcon: 'admin-application',
			strStatusText:'',
			strStatusIcon:'',
			callback: func,
			arrCapabilities: [{
				module : "WSManager",
				capability : "WSLoginAvailable"
			}]
		}
		this._arrAppButtons[this.SUPERVISION] = {
			strButtonName: this.SUPERVISION,
			strButtonLabel: _("Supervision", "webapp.userservices"),
			strButtonIcon: 'supervision-application',
			strStatusText: '',
			strStatusIcon: this.STATUS_OFF_ICON,
			callback: func,
			arrCapabilities: [{
				module : "Telephony",
				capability : "isLogSupervisionAllowed"
			}]
		}
		this._arrAppButtons[this.DND] = {
			strButtonName: this.DND,
			strButtonLabel: _("DND", "webapp.userservices"),
			strButtonIcon: 'communication-do-not-disturb',
			strStatusText:'',
			strStatusIcon:'',
			callback: func,
			arrCapabilities: [{
				module : "Telephony",
				capability : "allowDnd"
			}]
		}
		this._arrAppButtons[this.SR_SAVE] = {
			strButtonName: this.SR_SAVE,
			strButtonLabel: _("Save", "ICTouchAPI"),
			strButtonIcon: 'generic-save',
			strStatusText:'',
			strStatusIcon:'',
			callback: func,
			arrCapabilities: [{
				module : "ICTSaveRestore",
				capability : "SAVE_RESTORE_ENABLE"
			}]
		}
		this._arrAppButtons[this.SR_RESTORE] = {
			strButtonName: this.SR_RESTORE,
			strButtonLabel: _("Restore", "webapp.userservices"),
			strButtonIcon: 'generic-next',
			strStatusText:'',
			strStatusIcon:'',
			callback: func,
			arrCapabilities: [{
				module : "ICTSaveRestore",
				capability : "SAVE_RESTORE_ENABLE"
			}]
		}
		this._arrAppButtons[this.HIDE_IDENTITY] = {
			strButtonName: this.HIDE_IDENTITY,
			strButtonLabel: _("CLIR", "webapp.userservices"),
			strButtonIcon: 'generic-anonymous',
			strStatusText:'',
			strStatusIcon: this.STATUS_OFF_ICON,
			callback: func
		}


		this._arrAppBarSkeleton[this.PRESENCE_IM_SCREEN] = [this.CUSTOM,"MAGNIFY","homepageBtnHelp"];
		this._arrAppBarSkeleton[this.ROUTING_SCREEN] = [this.ADD_ROUTING,this.MODIFY_ROUTING,this.DELETE_ROUTING,"MAGNIFY","homepageBtnHelp"];
		this._arrAppBarSkeleton[this.OVERFLOW_SCREEN] = [this.ADD_ROUTING,this.MODIFY_ROUTING,this.DELETE_ROUTING,"MAGNIFY","homepageBtnHelp"];
		this._arrAppBarSkeleton[this.USER_INFO_SCREEN] = [this.LOGIN,this.SUPERVISION,this.HIDE_IDENTITY,this.DND,this.SR_SAVE,this.SR_RESTORE,"MAGNIFY","homepageBtnHelp"];
		this._arrAppBarSkeleton[this.ADD_ROUTING_1_SCREEN] = [this.NEXT,"MAGNIFY","homepageBtnHelp"];
		this._arrAppBarSkeleton[this.ADD_ROUTING_2_SCREEN] = [this.SAVE,"MAGNIFY","homepageBtnHelp"];
		this._arrAppBarSkeleton[this.ADD_OVERFLOW_1_SCREEN] = [this.NEXT,"MAGNIFY","homepageBtnHelp"];
		this._arrAppBarSkeleton[this.VIDEO_SCREEN] = [];
		this._arrAppBarSkeleton[this.ADD_OVERFLOW_2_SCREEN] = [this.SAVE,"MAGNIFY","homepageBtnHelp"];
		this._arrAppBarSkeleton[this.PROFILE_DETAILS_SCREEN] = ["MAGNIFY","homepageBtnHelp"];

		var backFunc={
			context: webapp.userservices,
			func: webapp.userservices.buttonCallback,
			param: this.BACK
		};

		for(var i in this._arrAppBarSkeleton){
			var appBar = ICTouchAPI.AppBarServices.createAppBar("userservices", "userservicesstatus" + i , this._arrAppBarSkeleton[i]);
			// Create the static back button
			ICTouchAPI.AppBarServices.addExitButton("userservices", "userservicesstatus" + i, true, backFunc);
			for(var j in this._arrAppBarSkeleton[i]){
				var currentBtn = this._arrAppBarSkeleton[i][j];
				//Button from communication webapp
				if(this._arrAppButtons[currentBtn]){
					var objButton = new UIElements.AppButton.AppButtonControl(this._arrAppButtons[currentBtn]);
					appBar.addAppButton(objButton,false);
				//Button from other webapps
				}else{
					appBar.addAppButton(currentBtn,false);
				}
			}
			appBar.buildDom();
		}
	},


	// Called when we click on "presence" in the menuList
	loadPresenceDetails : function() {
		// Set data
		this._strUserServiceContainerTitle =  _("Select your presence", "webapp.userservices");
		if (this._arrAllDetails[this.PRESENCE_IM_SCREEN] && this._arrAllDetails[this.PRESENCE_IM_SCREEN].length !== 0) {
			this.switchContainer("getPresenceContent",this.PRESENCE_IM_SCREEN,this._strUserServiceContainerTitle);
			return null;
		}
		this._arrAllDetails[this.PRESENCE_IM_SCREEN] = [];
		ICTouchAPI.APIServices.InstantMessaging.getAvailableStatuses({
			params :[],
			context : this,
			callback : this.loadedPresenceDetails
		});
	},


	// Callback of getAvailableStatuses
	loadedPresenceDetails: function(_arr) {
		var objPresence = null;
		if (_arr && _arr.length !== 0) {
			for (var i in _arr) {
				objPresence = _arr[i];
				if (objPresence) {
					objPresence.labelStatus=ICTouchAPI.tools.getPresenceLabel(objPresence.labelStatus);
					this._arrAllDetails[this.PRESENCE_IM_SCREEN].push({
						strLabel: _(objPresence.labelStatus, "webapp.userservices"),
						intIndex: objPresence.idStatus,
						itemId: objPresence.idStatus,
						strSecondaryContentIcon : ICTouchAPI.tools.getPresenceIconPath(objPresence.labelStatus, "32")
					});
				}
			}
		}
		this.switchContainer("getPresenceContent",this.PRESENCE_IM_SCREEN,this._strUserServiceContainerTitle);
		_arr = null;
	},

	// Called when we click on "routing" in the menuList
	loadRoutingDetails : function() {
		if(this.hRoutingDetailsReload){
			clearTimeout(this.hRoutingDetailsReload);
		}
		switch(this.currentMode) {
			case this.NORMAL_MODE :
				if(!this.getMultiDeviceRoutingAvailability()){
					this._strUserServiceContainerTitle = _("Select your routing", "webapp.userservices");
				}else{
					this._strUserServiceContainerTitle = _("Select your profile", "webapp.userservices");
				}
				break;
			case this.MODIFY_MODE :
				this._strUserServiceContainerTitle = _("Modify your routing", "webapp.userservices");
				break;
			case this.DELETE_MODE :
				this._strUserServiceContainerTitle = _("Delete your routing", "webapp.userservices");
				break;
		}
		// Set data
		this._strContainerPath = "webapp.userservices.getRoutingContent";
		this.intSelectListItem = this.ROUTING_SCREEN;
		this._arrAllDetails[this.ROUTING_SCREEN] = [];

		var currentProfileId = (this.currentProfile.profileId)? this.currentProfile.profileId.value.id: null;

		//Build list for multi device routing selection
		if(this.getMultiDeviceRoutingAvailability()){
			if(this.currentMode === this.NORMAL_MODE) {
				//First entry : Custom
				var select;
				if(this.boolForwardSet){
					select = false;
				}else{
					if("CUSTOM"==currentProfileId){
						select = true;
					}else{
						select = false;
					}
				}
				
				if(this._arrForwardList!=null){
					//First : VM entry
					var vmEntry = false;
					for(var forward in this._arrForwardList){
						if(this._arrForwardList[forward].forwardDestinationType.value.value == this.FWD_DESTINATION_VOICEMAIL){
							vmEntry = this._arrForwardList[forward].isSelected;
						}
					}
					if(this.boolVmNumber){
						var entry = this.buildForwardToVoicemailElement("PROFILE");
						entry.boolSelected = vmEntry;
						this._arrAllDetails[this.ROUTING_SCREEN].push(entry);
					}

					
				
					//Second : User entry
					var userEntry = false;
					for(var forward in this._arrForwardList){
						if(this._arrForwardList[forward].forwardDestinationType.value.value == this.FWD_DESTINATION_USER){
							if(this.isUserInfoNotEmpty(this._arrForwardList[forward])){
								this.currentUserInfo = ICTouchAPI.tools.getContactDisplayName(this._arrForwardList[forward].userInformation.value);
								this.otherUserNumber = this._arrForwardList[forward].userInformation.value.phoneNumber;
								userEntry = this._arrForwardList[forward].isSelected;
							}
						}
					}
					//var label = ICTouchAPI.tools.formatRoutingLabel(this._arrForwardList[forward].forwardDestinationType.value.value, userInfo, null, false);
					this._arrAllDetails[this.ROUTING_SCREEN].push({
						intIndex: -3,
						strLabel: _(["USER_DEVICE", "("+this.currentUserInfo+")"],"webapp.userservices"),
						boolSelected : ((this.boolForwardSet) ? userEntry : false),
						strDest: this._arrForwardList[forward].forwardDestinationType.value.value,
						strSecondaryContentIcon : "communication-routing-generic-32",
						strActionIcon : "userservices-more",
						itemCallback: webapp.userservices.onClickProfile
					});
				}

				//Second : Default
				for(var profile in this._arrProfilesSummaryList){
					if(this._arrProfilesSummaryList[profile].profileName=="DEFAULT"){
						this._arrAllDetails[this.ROUTING_SCREEN].push({
							intIndex: 1,
							profileId : this._arrProfilesSummaryList[profile].profileId.value.id,
							boolSelected : (this._arrProfilesSummaryList[profile].profileId.value.id==currentProfileId),
							strLabel: (this._arrProfilesSummaryList[profile].profileName!="") ? _(this._arrProfilesSummaryList[profile].profileName,"webapp.userservices") : _(this._arrProfilesSummaryList[profile].profileId.value.id,"webapp.userservices"),
							strSecondaryContentIcon : "communication-routing-generic-32",
							strActionIcon : "userservices-more",
							itemCallback: webapp.userservices.onClickProfile,
							buttonCallback : webapp.userservices.loadProfileDetails,
							buttonCallbackParams : {
								id : this._arrProfilesSummaryList[profile].profileId.value.id
							}
						});
					}
					if(this._arrProfilesSummaryList[profile].profileId.value.id==currentProfileId){
						for(var routing in this._arrAllDetails[this.ROUTING_SCREEN]){
							if(this._arrAllDetails[this.ROUTING_SCREEN][routing].intIndex == -3 || this._arrAllDetails[this.ROUTING_SCREEN][routing].intIndex == -2){
								this._arrAllDetails[this.ROUTING_SCREEN][routing].boolSelected = false;
							}
						}

					}
				}

				this._arrAllDetails[this.ROUTING_SCREEN].push({
					intIndex: 0,
					profileId : "CUSTOM",
					boolSelected : select,
					strLabel: _("CUSTOM","webapp.userservices"),
					strSecondaryContentIcon : "communication-routing-generic-32",
					strActionIcon : "userservices-more",
					itemCallback: webapp.userservices.onClickProfile,
					buttonCallback : webapp.userservices.loadProfileDetails,
					buttonCallbackParams : {
						id : "CUSTOM"
					}
				});
				
				if(select){
					for(var routing in this._arrAllDetails[this.ROUTING_SCREEN]){
						if(this._arrAllDetails[this.ROUTING_SCREEN][routing].intIndex == -3 || this._arrAllDetails[this.ROUTING_SCREEN][routing].intIndex == -2){
							this._arrAllDetails[this.ROUTING_SCREEN][routing].boolSelected = false;
						}
					}

				}

				//Others profiles
				var index = 2;
				for(var profile in this._arrProfilesSummaryList){
					if(this._arrProfilesSummaryList[profile].profileName!="DEFAULT" && this._arrProfilesSummaryList[profile].profileName!="CUSTOM"){
						this._arrAllDetails[this.ROUTING_SCREEN].push({
							intIndex: index,
							profileId:this._arrProfilesSummaryList[profile].profileId.value.id,
							boolSelected : (this._arrProfilesSummaryList[profile].profileId.value.id==currentProfileId),
							strLabel: (this._arrProfilesSummaryList[profile].profileName!="") ? _(this._arrProfilesSummaryList[profile].profileName,"webapp.userservices") : _(this._arrProfilesSummaryList[profile].profileId.value.id,"webapp.userservices"),
							strSecondaryContentIcon : "communication-routing-generic-32",
							strActionIcon : "userservices-more",
							itemCallback: webapp.userservices.onClickProfile,
							buttonCallback : webapp.userservices.loadProfileDetails,
							buttonCallbackParams : {
								id : this._arrProfilesSummaryList[profile].profileId.value.id
							}
						});
						index++;
					}
					if(this._arrProfilesSummaryList[profile].profileId.value.id==currentProfileId){
						for(var routing in this._arrAllDetails[this.ROUTING_SCREEN]){
							if(this._arrAllDetails[this.ROUTING_SCREEN][routing].intIndex == -3 || this._arrAllDetails[this.ROUTING_SCREEN][routing].intIndex == -2){
								this._arrAllDetails[this.ROUTING_SCREEN][routing].boolSelected = false;
							}
						}

					}
				}
				this.switchContainer("getRoutingContent",this.ROUTING_SCREEN, this.getUserServiceContainerTitle());
			}
		}else{//Build list of routing R200
			if(this.currentMode === this.NORMAL_MODE) {
				this._arrAllDetails[this.ROUTING_SCREEN].push({
					intIndex: 0,
					strTrigger: this.NONE,
					strLabel: _("My office phone", "webapp.userservices"),
					strSecondaryContentIcon : "empty-to-align-text", //not an icon but it's used to align the text with all the others
					itemCallback: webapp.userservices.onClickRouting
				});
				if(this.getAllowDirectCustomForward()){
					this._arrAllDetails[this.ROUTING_SCREEN].push({
						intIndex: -1,
						strTrigger: this.FWD_UNCONDITIONAL,
						strDest: this.DST_OTHER,
						strLabel: _("Immediate forward to...", "webapp.userservices"),
						strSecondaryContentIcon : "communication-routing-generic-32",
						itemCallback: webapp.userservices.onClickRouting
					});
					// We add immediate forward to voicemail only if a number is defined in ths setting
					if(this.boolVmNumber){
						this._arrAllDetails[this.ROUTING_SCREEN].push(this.buildForwardToVoicemailElement("ROUTING"));
					}
				}
			}
			if(!this.boolSimplifiedForwardMode) {
				// call function _loadedRoutingList in a callback
				ICTouchAPI.settingServices.getSettingValue("RoutingList", this, this._loadedRoutingList);
			} else {
				this._loadedRoutingList();
			}
			
		}
	},

	buildFakeOverflow : function(type,destination){
		var fEntry = {
			overflowType : type,
			targetType : destination,
			phoneNumber : "",
			isSelected : 0,
			userInformation : {
				type : "UserInformation",
				value : {
					phoneNumber : "",
					login : "",
					name : "",
					firstName : ""
				}
			}
		}
		return fEntry;
	},

	// Called when we click on "overflow" in the menuList
	loadOverflowDetails : function() {
		switch(this.currentMode) {
			case this.NORMAL_MODE :
				this._strUserServiceContainerTitle = _("Select your overflow", "webapp.userservices");
				break;
			case this.MODIFY_MODE :
				this._strUserServiceContainerTitle = _("Modify your overflow", "webapp.userservices");
				break;
			case this.DELETE_MODE :
				this._strUserServiceContainerTitle = _("Delete your overflow", "webapp.userservices");
				break;
		}
		// Set data
		this._strContainerPath = "webapp.userservices.getOverflowContent";
		this.intSelectListItem = this.OVERFLOW_SCREEN;
		this._arrAllDetails[this.OVERFLOW_SCREEN] = [];


		if(this.currentMode === this.NORMAL_MODE) {
			this._arrAllDetails[this.OVERFLOW_SCREEN].push({
				intIndex: 0,
				strTrigger: this.NONE,
				boolSelected : true,
				strLabel: _("No overflow", "webapp.userservices"),
				strSecondaryContentIcon : "empty-to-align-text", //not an icon but it's used to align the text with all the others
				itemCallback: webapp.userservices.onClickOverflow
			});
		}

		var availableOverflow = [];
		availableOverflow["NUMBER"] = [];
		availableOverflow["VM"] = [];
		availableOverflow["USER"] = [];
		for(var overflow in this._arrOverflowList){
			if(this._arrOverflowList[overflow].targetType == this.OVF_DESTINATION_USER){
				if(this._arrOverflowList[overflow].overflowType == "OVF_ON_NO_REPLY"){
					availableOverflow["USER"]["OVF_ON_NO_REPLY"] = this._arrOverflowList[overflow];
					availableOverflow["USER"]["OVF_ON_BUSY_OR_NO_REPLY"] = this.buildFakeOverflow("OVF_ON_BUSY_OR_NO_REPLY","OVF_DESTINATION_USER");
				}else{
					availableOverflow["USER"]["OVF_ON_NO_REPLY"] = this.buildFakeOverflow("OVF_ON_NO_REPLY","OVF_DESTINATION_USER");
					availableOverflow["USER"]["OVF_ON_BUSY_OR_NO_REPLY"] = this._arrOverflowList[overflow];
				}
			}else if(this._arrOverflowList[overflow].targetType == this.OVF_DESTINATION_VOICEMAIL){
				if(this._arrOverflowList[overflow].overflowType == "OVF_ON_NO_REPLY"){
					availableOverflow["VM"]["OVF_ON_NO_REPLY"] = this._arrOverflowList[overflow];
					availableOverflow["VM"]["OVF_ON_BUSY_OR_NO_REPLY"] = this.buildFakeOverflow("OVF_ON_BUSY_OR_NO_REPLY","OVF_DESTINATION_VOICEMAIL");
				}else{
					availableOverflow["VM"]["OVF_ON_NO_REPLY"] = this.buildFakeOverflow("OVF_ON_NO_REPLY","OVF_DESTINATION_VOICEMAIL");
					availableOverflow["VM"]["OVF_ON_BUSY_OR_NO_REPLY"] = this._arrOverflowList[overflow];
				}
			}else if(this._arrOverflowList[overflow].targetType == this.OVF_DESTINATION_NUMBER){
				if(this._arrOverflowList[overflow].overflowType == "OVF_ON_NO_REPLY"){
					availableOverflow["NUMBER"]["OVF_ON_NO_REPLY"] = this._arrOverflowList[overflow];
					availableOverflow["NUMBER"]["OVF_ON_BUSY_OR_NO_REPLY"] = this.buildFakeOverflow("OVF_ON_BUSY_OR_NO_REPLY","OVF_DESTINATION_NUMBER");
				}else{
					availableOverflow["NUMBER"]["OVF_ON_NO_REPLY"] = this.buildFakeOverflow("OVF_ON_NO_REPLY","OVF_DESTINATION_NUMBER");
					availableOverflow["NUMBER"]["OVF_ON_BUSY_OR_NO_REPLY"] = this._arrOverflowList[overflow];
				}
			}
		}

		var entry = null;

		//Entry If no reply to VM
		if(availableOverflow["VM"]["OVF_ON_NO_REPLY"]!=null){
			if(this.boolVmNumber){
				entry = this.buildForwardToVoicemailElement("OVERFLOWBIS");
			}
		}
		if(entry){
			//if(availableOverflow["VM"]["OVF_ON_NO_REPLY"].overflowType == "OVF_ON_NO_REPLY"){
				entry.boolSelected = availableOverflow["VM"]["OVF_ON_NO_REPLY"].isSelected;
				if(entry.boolSelected){
					for(var i in this._arrAllDetails[this.OVERFLOW_SCREEN]){
						if(this._arrAllDetails[this.OVERFLOW_SCREEN][i].intIndex == 0){
							this._arrAllDetails[this.OVERFLOW_SCREEN][i].boolSelected = false;
							break;
						}
					}
				}
			//}
			this._arrAllDetails[this.OVERFLOW_SCREEN].push(entry);
		}
		entry = null;

		var label = null;
		if((availableOverflow["USER"]["OVF_ON_NO_REPLY"]!=null && availableOverflow["USER"]["OVF_ON_NO_REPLY"].isSelected)  ||
			(availableOverflow["NUMBER"]["OVF_ON_NO_REPLY"]!=null && availableOverflow["NUMBER"]["OVF_ON_NO_REPLY"].isSelected)){
			if(availableOverflow["USER"]["OVF_ON_NO_REPLY"]!=null && availableOverflow["USER"]["OVF_ON_NO_REPLY"].isSelected){
				if(this.isUserInfoNotEmpty(availableOverflow["USER"]["OVF_ON_NO_REPLY"])){
					label = ICTouchAPI.tools.getContactDisplayName(availableOverflow["USER"]["OVF_ON_NO_REPLY"].userInformation.value);
					this.otherOverflowUserNoReply = availableOverflow["USER"]["OVF_ON_NO_REPLY"].userInformation.value;
					this.otherOverflowNumberNoReply = null;
				}
				entry = {
					intIndex: -11,
					strTrigger: this.NONE,
					strLabel: _(["OVF_ON_NO_REPLY"," ("+label+")"], "webapp.userservices"),
					strSecondaryContentIcon : "empty-to-align-text", //not an icon but it's used to align the text with all the others
					itemCallback: webapp.userservices.onClickOverflow,
					strActionIcon : "userservices-more",
					buttonCallback : webapp.userservices.editOverflowNumber,
					boolSelected :availableOverflow["USER"]["OVF_ON_NO_REPLY"].isSelected,
					buttonCallbackParams : {
						id : -11
					}
				}
			}else if(availableOverflow["NUMBER"]["OVF_ON_NO_REPLY"]!=null && availableOverflow["NUMBER"]["OVF_ON_NO_REPLY"].isSelected){
				if(availableOverflow["NUMBER"]["OVF_ON_NO_REPLY"].phoneNumber!="" && availableOverflow["NUMBER"]["OVF_ON_NO_REPLY"].isSelected){
					var objContact = ICTouchAPI.dataStoreServices.getStore('contacts').find(["officePhone", "personalHome", "personalMobile","officePhoneCan", "personalHomeCan", "personalMobileCan", "personalFax"],availableOverflow["NUMBER"]["OVF_ON_NO_REPLY"].phoneNumber)[0];
					if(objContact){
						label = _(["OVF_ON_NO_REPLY"," ("+objContact.name+" "+objContact.firstName+")"], "webapp.userservices");
					}else{
						label = _(["OVF_ON_NO_REPLY"," ("+availableOverflow["NUMBER"]["OVF_ON_NO_REPLY"].phoneNumber+")"], "webapp.userservices");
					}
					this.otherOverflowUserNoReply = null;
					this.otherOverflowNumberNoReply = availableOverflow["NUMBER"]["OVF_ON_NO_REPLY"].phoneNumber;
				}
				entry = {
					intIndex: -11,
					strTrigger: this.NONE,
					strLabel: label,
					strSecondaryContentIcon : "empty-to-align-text", //not an icon but it's used to align the text with all the others
					itemCallback: webapp.userservices.onClickOverflow,
					strActionIcon : "userservices-more",
					buttonCallback : webapp.userservices.editOverflowNumber,
					boolSelected :availableOverflow["NUMBER"]["OVF_ON_NO_REPLY"].isSelected,
					buttonCallbackParams : {
						id : -11
					}
				}
			}else{
				label = _(["OVF_ON_NO_REPLY"," ()"], "webapp.userservices");
				entry = {
					intIndex: -11,
					strTrigger: this.NONE,
					strLabel: label,
					strSecondaryContentIcon : "empty-to-align-text", //not an icon but it's used to align the text with all the others
					itemCallback: webapp.userservices.onClickOverflow,
					strActionIcon : "userservices-more",
					buttonCallback : webapp.userservices.editOverflowNumber,
					boolSelected :false,
					buttonCallbackParams : {
						id : -11
					}
				}
			}
		}else{
			if(this.otherOverflowUserNoReply){
				var info = ICTouchAPI.tools.getContactDisplayName(this.otherOverflowUserNoReply);
				label = _(["OVF_ON_NO_REPLY"," ("+info+")"], "webapp.userservices");
			}else if(this.otherOverflowNumberNoReply){
				var objContact = ICTouchAPI.dataStoreServices.getStore('contacts').find(["officePhone", "personalHome", "personalMobile","officePhoneCan", "personalHomeCan", "personalMobileCan", "personalFax"],this.otherOverflowNumberNoReply)[0];
				if(objContact){
					label = _(["OVF_ON_NO_REPLY"," ("+objContact.name+" "+objContact.firstName+")"], "webapp.userservices");
				}else{
					label = _(["OVF_ON_NO_REPLY"," ("+this.otherOverflowNumberNoReply+")"], "webapp.userservices");
				}
			}else{
				label = _(["OVF_ON_NO_REPLY"," ()"], "webapp.userservices");
			}
			entry = {
					intIndex: -11,
					strTrigger: this.NONE,
					strLabel: label,
					strSecondaryContentIcon : "empty-to-align-text", //not an icon but it's used to align the text with all the others
					itemCallback: webapp.userservices.onClickOverflow,
					strActionIcon : "userservices-more",
					buttonCallback : webapp.userservices.editOverflowNumber,
					boolSelected :false,
					buttonCallbackParams : {
						id : -11
					}
				}
		}

		if(entry){
			this._arrAllDetails[this.OVERFLOW_SCREEN].push(entry);
			if(entry.boolSelected){
				for(var i in this._arrAllDetails[this.OVERFLOW_SCREEN]){
					if(this._arrAllDetails[this.OVERFLOW_SCREEN][i].intIndex == 0){
						this._arrAllDetails[this.OVERFLOW_SCREEN][i].boolSelected = false;
						break;
					}
				}
			}
		}
		entry = null;

		//Entry If busy or no reply to VM
		if(availableOverflow["VM"]["OVF_ON_BUSY_OR_NO_REPLY"]){
			if(this.boolVmNumber){
				entry = this.buildForwardToVoicemailElement("OVERFLOW");
			}
		}
		if(entry){
			//if(availableOverflow["VM"].overflowType == "OVF_ON_BUSY_OR_NO_REPLY"){
				entry.boolSelected = availableOverflow["VM"]["OVF_ON_BUSY_OR_NO_REPLY"].isSelected;
				if(entry.boolSelected){
					for(var i in this._arrAllDetails[this.OVERFLOW_SCREEN]){
						if(this._arrAllDetails[this.OVERFLOW_SCREEN][i].intIndex == 0){
							this._arrAllDetails[this.OVERFLOW_SCREEN][i].boolSelected = false;
							break;
						}
					}
				}
			//}
			this._arrAllDetails[this.OVERFLOW_SCREEN].push(entry);
		}
		entry = null;


		var label = null;
		if((availableOverflow["USER"]["OVF_ON_BUSY_OR_NO_REPLY"]!=null && availableOverflow["USER"]["OVF_ON_BUSY_OR_NO_REPLY"].isSelected)  ||
			(availableOverflow["NUMBER"]["OVF_ON_BUSY_OR_NO_REPLY"]!=null && availableOverflow["NUMBER"]["OVF_ON_BUSY_OR_NO_REPLY"].isSelected)){
			if(availableOverflow["USER"]["OVF_ON_BUSY_OR_NO_REPLY"]!=null && availableOverflow["USER"]["OVF_ON_BUSY_OR_NO_REPLY"].isSelected){
				if(this.isUserInfoNotEmpty(availableOverflow["USER"]["OVF_ON_BUSY_OR_NO_REPLY"])){
					label = ICTouchAPI.tools.getContactDisplayName(availableOverflow["USER"]["OVF_ON_BUSY_OR_NO_REPLY"].userInformation.value);
					this.otherOverflowUser = availableOverflow["USER"]["OVF_ON_BUSY_OR_NO_REPLY"].userInformation.value;
					this.otherOverflowNumber = null;
				}
				entry = {
					intIndex: -12,
					strTrigger: this.NONE,
					strLabel: _(["OVF_ON_BUSY_OR_NO_REPLY"," ("+label+")"], "webapp.userservices"),
					strSecondaryContentIcon : "empty-to-align-text", //not an icon but it's used to align the text with all the others
					itemCallback: webapp.userservices.onClickOverflow,
					strActionIcon : "userservices-more",
					buttonCallback : webapp.userservices.editOverflowNumber,
					boolSelected :availableOverflow["USER"]["OVF_ON_BUSY_OR_NO_REPLY"].isSelected,
					buttonCallbackParams : {
						id : -12
					}
				}
			}else if(availableOverflow["NUMBER"]["OVF_ON_BUSY_OR_NO_REPLY"]!=null && availableOverflow["NUMBER"]["OVF_ON_BUSY_OR_NO_REPLY"].isSelected){
				if(availableOverflow["NUMBER"]["OVF_ON_BUSY_OR_NO_REPLY"].phoneNumber!="" && availableOverflow["NUMBER"]["OVF_ON_BUSY_OR_NO_REPLY"].isSelected){
					var objContact = ICTouchAPI.dataStoreServices.getStore('contacts').find(["officePhone", "personalHome", "personalMobile","officePhoneCan", "personalHomeCan", "personalMobileCan", "personalFax"],availableOverflow["NUMBER"]["OVF_ON_BUSY_OR_NO_REPLY"].phoneNumber)[0];
					if(objContact){
						label = _(["OVF_ON_BUSY_OR_NO_REPLY"," ("+objContact.name+" "+objContact.firstName+")"], "webapp.userservices");
					}else{
						label = _(["OVF_ON_BUSY_OR_NO_REPLY"," ("+availableOverflow["NUMBER"]["OVF_ON_BUSY_OR_NO_REPLY"].phoneNumber+")"], "webapp.userservices");
					}
					this.otherOverflowUser = null;
					this.otherOverflowNumber = availableOverflow["NUMBER"]["OVF_ON_BUSY_OR_NO_REPLY"].phoneNumber;
				}
				entry = {
					intIndex: -12,
					strTrigger: this.NONE,
					strLabel: label,
					strSecondaryContentIcon : "empty-to-align-text", //not an icon but it's used to align the text with all the others
					itemCallback: webapp.userservices.onClickOverflow,
					strActionIcon : "userservices-more",
					buttonCallback : webapp.userservices.editOverflowNumber,
					boolSelected :availableOverflow["NUMBER"]["OVF_ON_BUSY_OR_NO_REPLY"].isSelected,
					buttonCallbackParams : {
						id : -12
					}
				}
			}else{
				label = _(["OVF_ON_BUSY_OR_NO_REPLY"," ()"], "webapp.userservices");
				entry = {
					intIndex: -12,
					strTrigger: this.NONE,
					strLabel: label,
					strSecondaryContentIcon : "empty-to-align-text", //not an icon but it's used to align the text with all the others
					itemCallback: webapp.userservices.onClickOverflow,
					strActionIcon : "userservices-more",
					buttonCallback : webapp.userservices.editOverflowNumber,
					boolSelected :false,
					buttonCallbackParams : {
						id : -12
					}
				}
			}
		}else{
			if(this.otherOverflowUser){
				var info = ICTouchAPI.tools.getContactDisplayName(this.otherOverflowUser);
				label = _(["OVF_ON_BUSY_OR_NO_REPLY"," ("+info+")"], "webapp.userservices");
			}else if(this.otherOverflowNumber){
				var objContact = ICTouchAPI.dataStoreServices.getStore('contacts').find(["officePhone", "personalHome", "personalMobile","officePhoneCan", "personalHomeCan", "personalMobileCan", "personalFax"],this.otherOverflowNumber)[0];
				if(objContact){
					label = _(["OVF_ON_BUSY_OR_NO_REPLY"," ("+objContact.name+" "+objContact.firstName+")"], "webapp.userservices");
				}else{
					label = _(["OVF_ON_BUSY_OR_NO_REPLY"," ("+this.otherOverflowNumber+")"], "webapp.userservices");
				}
			}else{
				label = _(["OVF_ON_BUSY_OR_NO_REPLY"," ()"], "webapp.userservices");
			}
			entry = {
				intIndex: -12,
				strTrigger: this.NONE,
				strLabel: label,
				strSecondaryContentIcon : "empty-to-align-text", //not an icon but it's used to align the text with all the others
				itemCallback: webapp.userservices.onClickOverflow,
				strActionIcon : "userservices-more",
				buttonCallback : webapp.userservices.editOverflowNumber,
				boolSelected :false,
				buttonCallbackParams : {
					id : -12
				}
			}
		}

		if(entry){
			this._arrAllDetails[this.OVERFLOW_SCREEN].push(entry);
			if(entry.boolSelected){
				for(var i in this._arrAllDetails[this.OVERFLOW_SCREEN]){
					if(this._arrAllDetails[this.OVERFLOW_SCREEN][i].intIndex == 0){
						this._arrAllDetails[this.OVERFLOW_SCREEN][i].boolSelected = false;
						break;
					}
				}
			}
		}
		
		this.switchContainer("getOverflowContent",this.OVERFLOW_SCREEN, this.getUserServiceContainerTitle());
	},

	isUserInfoNotEmpty : function(info){
		var res = false;
		if(info.userInformation){
			var userInfo = info.userInformation.value;
			if(userInfo.phoneNumber != "" || userInfo.login != "" || userInfo.name != "" || userInfo.firstName != ""){
				res = true;
			}
		}
		if(info.phoneNumber != ""){
			res = true;
		}
		return res;
	},


	reloadRoutingDetailsWithOrWithoutVm : function (withVm){
		var arrRouting = [];
		for (var i=0; i< this._arrAllDetails[this.ROUTING_SCREEN].length;i++){
			if (this._arrAllDetails[this.ROUTING_SCREEN][i].intIndex != -2){
				arrRouting.push(this._arrAllDetails[this.ROUTING_SCREEN][i])
			}
		}
		if (withVm){
			arrRouting.push(this.buildForwardToVoicemailElement("ROUTING"));
		}
		this._arrAllDetails[this.ROUTING_SCREEN] = arrRouting;
		withVm = null;
	},

	// Calback of get TelephonyVmNumber setting's value
	_gotVmNumber : function(strNumber) {
		if (strNumber !== "") {
			this._arrAllDetails[this.ROUTING_SCREEN].push(this.buildForwardToVoicemailElement("ROUTING"));
		}
		strNumber = null;
	},

	buildForwardToVoicemailElement : function (_type){
		if(_type == "ROUTING"){
			var i18nLabel = ICTouchAPI.tools.formatRoutingLabel(this.FWD_UNCONDITIONAL, this.DST_VOICEMAIL);
			var icon = ICTouchAPI.tools.getRoutingIcon(this.DST_VOICEMAIL);
			return {
				intIndex: -2,
				strLabel: i18nLabel,
				strTrigger: this.FWD_UNCONDITIONAL,
				strDest: this.DST_VOICEMAIL,
				strSecondaryContentIcon : icon,
				itemCallback: webapp.userservices.onClickRouting
			};
		}else if(_type == "OVERFLOW"){
			var i18nLabel = ICTouchAPI.tools.formatRoutingLabel(this.OVF_ON_BUSY_OR_NO_REPLY, this.OVF_DESTINATION_VOICEMAIL);
			var icon = ICTouchAPI.tools.getRoutingIcon(this.DST_VOICEMAIL);
			return {
				intIndex: -2,
				strLabel: i18nLabel,
				strTrigger: this.OVF_ON_BUSY_OR_NO_REPLY,
				strDest: this.OVF_DESTINATION_VOICEMAIL,
				strSecondaryContentIcon : icon,
				itemCallback: webapp.userservices.onClickOverflow
			};
		}else if(_type == "OVERFLOWBIS"){
			var i18nLabel = ICTouchAPI.tools.formatRoutingLabel(this.OVF_ON_NO_REPLY, this.OVF_DESTINATION_VOICEMAIL);
			var icon = ICTouchAPI.tools.getRoutingIcon(this.DST_VOICEMAIL);
			return {
				intIndex: -4,
				strLabel: i18nLabel,
				strTrigger: this.OVF_ON_NO_REPLY,
				strDest: this.OVF_DESTINATION_VOICEMAIL,
				strSecondaryContentIcon : icon,
				itemCallback: webapp.userservices.onClickOverflow
			};
		}else if(_type == "PROFILE"){
			var icon = ICTouchAPI.tools.getRoutingIcon(this.DST_VOICEMAIL);
			return {
				intIndex: -2,
				id: "LOCAL_VM",
				strLabel: _("LOCAL_VM","webapp.userservices"),
				strTrigger: this.FWD_UNCONDITIONAL,
				strDest: this.OVF_DESTINATION_VOICEMAIL,
				strSecondaryContentIcon : icon,
				itemCallback: webapp.userservices.onClickProfile
			};
		}else{
			//TODO message d'erreur
		}
		_type = null;
	},


	// Callback of loadedRoutingDetails
	_loadedRoutingList : function(arr) {
		// first item is "None"
		if (arr) {
			for (var i = 0; i < arr.length; i++) {
				// Setting value is in the form "routing_type:routing_dest:routing_number"
				var arrRoutingData = arr[i].split(":");
				var boolOther = (arrRoutingData[1] === this.DST_OTHER);
				//var label = this.formatRoutingLabel(arrRoutingData[0], arrRoutingData[1], arrRoutingData[2], boolOther);
				var objContact = ICTouchAPI.dataStoreServices.getStore('contacts').find(["officePhone", "personalHome", "personalMobile","officePhoneCan", "personalHomeCan", "personalMobileCan", "personalFax"],arrRoutingData[2])[0];
				var routingDest = null;
				if(objContact){
					routingDest = objContact.name+" "+objContact.firstName;
				}else{
					routingDest = arrRoutingData[2];
				}

				var label = ICTouchAPI.tools.formatRoutingLabel(arrRoutingData[0], arrRoutingData[1], routingDest, boolOther);
				var icon = ICTouchAPI.tools.getRoutingIcon(arrRoutingData[1]);
				this._arrAllDetails[this.ROUTING_SCREEN].push({
					intIndex: i + 1,
					strLabel: label,
					boolOther: boolOther,
					strTrigger: arrRoutingData[0],
					strDest: arrRoutingData[1],
					strNumber: arrRoutingData[2],
					strSecondaryContentIcon : icon,
					itemCallback: webapp.userservices.onClickRouting
				});
			}
		}
		ICTouchAPI.settingServices.getSettingValue("ActiveRouting", this, this._loadedActiveRouting);
		arr = null;
	},


	_loadedActiveRouting: function(str) {
		var selected = false;
		var arrRoutingList = this.getRoutingData();
		var i;
		var label;
		var arrActiveRoutingData;
		// Reset the selected routing
		for (i in arrRoutingList) {
			arrRoutingList[i].boolSelected = false;
		}
		if (str) {
			// Setting value is in the form "routing_type:routing_dest:routing_number"
			arrActiveRoutingData = str.split(":");

			var boolOther = (arrActiveRoutingData[1] === this.DST_OTHER);
			//var label = this.formatRoutingLabel(arrActiveRoutingData[0], arrActiveRoutingData[1], arrActiveRoutingData[2], boolOther);
			label = ICTouchAPI.tools.formatRoutingLabel(arrActiveRoutingData[0], arrActiveRoutingData[1], arrActiveRoutingData[2], boolOther);
			// Select the activate routing
			// We select the active Routing if it is on the list
			for (i in arrRoutingList)
			{
				if(arrRoutingList[i].strTrigger === arrActiveRoutingData[0] && arrRoutingList[i].strDest === arrActiveRoutingData[1] && arrRoutingList[i].strNumber === arrActiveRoutingData[2]) {
					selected = true;
					arrRoutingList[i].boolSelected = true;
					this.currentRoutingID = arrRoutingList[i].intIndex;
					break;
				}
			}
			// If the routing isn't on the list but is of type "Immediate...", we select "Immediate forward to..."
			if (selected === false && arrRoutingList[1] && arrRoutingList[1].intIndex === -1 && arrActiveRoutingData[0] === this.FWD_UNCONDITIONAL) {
				arrRoutingList[1].boolSelected = true;
				selected = true;
				this.currentRoutingID = arrRoutingList[1].intIndex;
			}
		}
		if (selected === false && this.currentMode === this.NORMAL_MODE) {
			// If no item selected but a routing set, add it on the local list and on the setting
			if(label && arrActiveRoutingData[1]){ // If not none
				var routingDestination = "";
				if(arrActiveRoutingData[2]){
					routingDestination = arrActiveRoutingData[1] + ":" + arrActiveRoutingData[2];
				} else {
					routingDestination = arrActiveRoutingData[1];
				}
				this.currentRouting = {
					routingType: arrActiveRoutingData[0],
					routingDestination : routingDestination
				};
				var detailsLength = this._arrAllDetails[this.ROUTING_SCREEN].length;
				var lastIndex;
				if(detailsLength){
					lastIndex = this._arrAllDetails[this.ROUTING_SCREEN][detailsLength-1].intIndex;
				} else {
					lastIndex = 0;
				}

				if(this.boolSimplifiedForwardMode){
					// The routing set does not exist, so create it
					this._arrAllDetails[this.ROUTING_SCREEN].push({
						intIndex: lastIndex+1,
						strLabel: label,
						strTrigger: arrActiveRoutingData[0],
						strDest: arrActiveRoutingData[1],
						strNumber: arrActiveRoutingData[2],
						strSecondaryContentIcon : this._arrDestinationsIcons[arrActiveRoutingData[1]],
						itemCallback: webapp.userservices.onClickRouting,
						boolSelected:true
					});
					this.currentRoutingID = lastIndex+1;
				} else {
					var noSwitch = true;
					ICTouchAPI.settingServices.getSettingValue("RoutingList", this, this.saveRoutingList);
				}
			} else { // If none
				arrRoutingList[0].boolSelected = true;
				this.currentRoutingID = arrRoutingList[0].intIndex;
			}
		}
		if(!noSwitch){
			this.switchContainer("getRoutingContent",this.ROUTING_SCREEN, this.getUserServiceContainerTitle());
		}
		str = null;
	},

	// Called when we click on "add" appButton
	loadRoutingTypeDetails : function() {
		// Set data
		this._strContainerPath = "webapp.userservices.getRoutingAdd1Content";
		this._arrAllDetails[this.ADD_ROUTING_1_SCREEN] = [];
		// Get forward list setting
		ICTouchAPI.settingServices.getSettingValue("TelephonyForwardTypes",this,this.loadedRoutingTypeDetails);
	},

	// Callback of loadRoutingTypeDetails
	loadedRoutingTypeDetails: function(arr) {
		// arr contains the jsValue (Array) of TelephonyForwardTypes setting
		var selected = false;
		if(arr != null && arr.length > 0)
		{
			for (var i in arr) {
				this._arrAllDetails[this.ADD_ROUTING_1_SCREEN].push({
					strLabel: _(arr[i], "webapp.userservices"),
					intIndex: i,
					label : arr[i]
				});
				if (this.currentRouting.routingType === arr[i]) {
					selected = true;
					this._arrAllDetails[this.ADD_ROUTING_1_SCREEN][i].boolSelected = true;
				}
			}
			if (selected === false) {
				this.currentRouting.routingType = arr[0];
				this._arrAllDetails[this.ADD_ROUTING_1_SCREEN][0].boolSelected = true;
			}
			this.switchContainer("getRoutingAdd1Content",this.ADD_ROUTING_1_SCREEN, _("Add routing on event", "webapp.userservices"));
		}
		arr = null;
	},

	// Called when we click on "next" appButton
	loadRoutingDestinationDetails : function() {
		// Set data
		this._strContainerPath = "webapp.userservices.getRoutingAdd2Content";
		this._arrAllDetails[this.ADD_ROUTING_2_SCREEN] = [];
		// Get forward list setting value
		ICTouchAPI.settingServices.getSettingValue("TelephonyForwardDestinations",this,this.loadedRoutingDestinationDetails);
	},

	// Callback of loadRoutingDestinationDetails
	loadedRoutingDestinationDetails: function(arr) {
		// arr contains the jsValue (Array) of TelephonyForwardDestinations setting
		if(arr != null && arr.length > 0)
		{
			var selected = false;
			for (var i in arr) {
				var icon = ICTouchAPI.tools.getRoutingIcon(arr[i]);
				this._arrAllDetails[this.ADD_ROUTING_2_SCREEN].push({
					strLabel: _(arr[i], "webapp.userservices"),
					intIndex: i,
					strSecondaryContentIcon : icon,
					label : arr[i]
				});
				if (this.currentRouting.routingDestination && this.currentRouting.routingDestination === arr[i]) {
					selected = true;
					this._arrAllDetails[this.ADD_ROUTING_2_SCREEN][i].boolSelected = true;
				}
			}
			var last = this._arrAllDetails[this.ADD_ROUTING_2_SCREEN].length ;
			var icon = ICTouchAPI.tools.getRoutingIcon("Other");
			this._arrAllDetails[this.ADD_ROUTING_2_SCREEN].push({
				strLabel: _("Other...", "webapp.userservices"),
				intIndex: last,
				strSecondaryContentIcon : icon,
				label :this.DST_OTHER
			});
			if(this.currentRouting.routingDestination && this.currentRouting.routingDestination == this._arrAllDetails[this.ADD_ROUTING_2_SCREEN][last].label) {
				this._arrAllDetails[this.ADD_ROUTING_2_SCREEN][last].boolSelected = true;
				selected = true;
			}
			if(selected != true) {
				this.currentRouting.routingDestination = arr[0];
				this._arrAllDetails[this.ADD_ROUTING_2_SCREEN][0].boolSelected = true;
			}
			this.switchContainer("getRoutingAdd2Content",this.ADD_ROUTING_2_SCREEN, _("Routing destination", "webapp.userservices"));
		}
		arr = null;
	},

	// Called when you save a new or modified routing
	saveRoutingList : function(arr) {
		var i;
		var arrRoutingList = this.getRoutingData();
		var newArr = arr;
		if (newArr == null)	// Handle undefined setting value
			newArr = [];
		if(this.currentMode == this.NORMAL_MODE) {
			// Check if the arouting rule is already defined before adding it, in order to avoid duplicated entries
			var boolRoutingAlreadyDefined = false;
			for (i in arrRoutingList) {
				if (arrRoutingList[i].strTrigger == this.currentRouting.routingType && (arrRoutingList[i].strDest == this.currentRouting.routingDestination || arrRoutingList[i].strDest+":"+arrRoutingList[i].strNumber == this.currentRouting.routingDestination )) {
					boolRoutingAlreadyDefined = true;
					break;
				}
			}
			if (!boolRoutingAlreadyDefined) {
				newArr.push(this.currentRouting.routingType+ ":" +this.currentRouting.routingDestination);
				ICTouchAPI.settingServices.setSettingValue("RoutingList", newArr, this, this._savedRoutingList);
			} else {
				this.switchContainer("getRoutingContent",this.ROUTING_SCREEN, this.getUserServiceContainerTitle());
			}
		}

		else { // MODIFY_MODE
			if(this.currentRouting && this.currentRouting.id){
				if(this.currentRouting.routingType===this.FWD_UNCONDITIONAL && this.currentRouting.routingDestination===this.DST_VOICEMAIL) {
					boolRoutingAlreadyDefined = true;
				}
				else {
					for (i in arrRoutingList) {
						if (arrRoutingList[i].strTrigger == this.currentRouting.routingType && arrRoutingList[i].strDest == this.currentRouting.routingDestination) {
							boolRoutingAlreadyDefined = true;
							break;
						}
					}
				}
				if (!boolRoutingAlreadyDefined) {
					var strPreviousRouting = newArr[this.currentRouting.id]; // save the previous value of the modified routing
					newArr[this.currentRouting.id] = this.currentRouting.routingType+ ":" +this.currentRouting.routingDestination;
					ICTouchAPI.settingServices.getSettingValue("ActiveRouting", this, this._checkActiveRoutingForModify, {
						strPreviousRouting: strPreviousRouting,
						arr: newArr
					});
				}
				else {
					this.changeMode(this.NORMAL_MODE);
					this.loadRoutingDetails();
				}

			// Get the active routing : if the modified routing is the active routing, we have to activate the forward for the modified routing
			// otherwize, the activated routing will stay active in the list, and the modified routing will be added to the list of routings
			}
		}
		arr = null;
	},

	// Callback of getSettingValue for ActiveRouting, in case of modify routing
	_checkActiveRoutingForModify : function(strActiveRouting, params) {
		var arrActiveRoutingData = strActiveRouting.split(":"); // data of the active routing
		var previousRoutingData = params.strPreviousRouting.split(":"); // data of the modified routing before the modifications
		var modifiedRoutingData = params.arr[this.currentRouting.id].split(":"); // data of the modified routing after the modifications

		// If the routing to modify was the active routing, call setActiveRoutingOnClickRouting to set the modified routing as the active routing
		if (previousRoutingData[0] == arrActiveRoutingData[0] && previousRoutingData[1] == arrActiveRoutingData[1] && previousRoutingData[2] == arrActiveRoutingData[2]) {
			var boolOther = false;
			if (modifiedRoutingData[2]) {
				boolOther = true;
			}
			var objRouting = {
				strTrigger :modifiedRoutingData[0],
				strDest:modifiedRoutingData[1],
				strNumber:modifiedRoutingData[2],
				boolOther:boolOther
			};
			webapp.userservices.setActiveRoutingOnClickRouting(objRouting);
		}
		ICTouchAPI.settingServices.setSettingValue("RoutingList", params.arr, this, this._savedRoutingList);
		strActiveRouting=null;
		params=null;
	},

	// Callback of saveRoutingList
	_savedRoutingList : function() {
		this.changeMode(this.NORMAL_MODE) ;
		this.loadRoutingDetails();
	},

	// Open a new popup with a specific name and the id of the selected line
	deletePopup : function(id) {
		var _id = id;
		var context = this;
		var popupData = {
			strTitle:  _("Confirm deletion ?", 'webapp.userservices'),
			strType: "warning",
			strContent: _("CONFIRM_DELETION", 'webapp.userservices'),
			arrPopupButtons: [{
				strButtonName: this.YES,
				strButtonLabel:  _("Yes", 'ICTouchAPI'),
				strButtonIcon: "generic-ok",
				callback: function() {
					context.yesPopup(_id);
				}
			},{
				strButtonName: this.NO,
				strButtonLabel:  _("No", 'ICTouchAPI'),
				strButtonIcon: "generic-cancel",
				callback: function() {
					context.closePopup();
				}
			}]
		};
		this.objPopup = ICTouchAPI.popupServices.addNewPopup(popupData, "MEDIUM");
		id = null;
	},

	// "yes" callback of the popup
	yesPopup : function(id) {
		var arr = this.getRoutingData();
		var newArr = [];
		for(var i=0; i<arr.length;i++)
		{
			if(id != i) {
				var dest = arr[i].strDest;
				var type = arr[i].strTrigger;
				if(arr[i].boolOther){
					dest = dest + ":" + arr[i].strNumber;
				}
				newArr.push(type+":"+dest);
			}
		}
		ICTouchAPI.settingServices.getSettingValue("ActiveRouting", this, this._yesPopup, {
			line : arr[id],
			arr : newArr
		});
		id = null;
	},

	// Callback of yesPopup
	_yesPopup : function(str, params) {
		var arrActiveRouting = str.split(':');
		if (arrActiveRouting[0] == params.line.strTrigger && arrActiveRouting[1] == params.line.strDest && arrActiveRouting[2] == params.line.strNumber) {
			/* In the case the routine to delete is currently enabled:
			Diseable the forward, and simulate a click on the "None" active routing before deleting the routine */
			ICTouchAPI.APIServices.Telephony.deactivateForward({
				context: webapp.userservices
			});
			this.yesCallback = function() {
				webapp.userservices.data.changeMode(this.NORMAL_MODE);
				ICTouchAPI.settingServices.setSettingValue("RoutingList", params.arr, this, this.closePopup );
				webapp.userservices.data.yesCallback = null;
			};

			if(webapp.progkeys) {
				webapp.progkeys.desactivateProgKeys();
			}

			//ICTouchAPI.APIServices.Telephony.deactivateDnd({context: webapp.userservices});
			/* Set the global webapp variable "currentRoutingLabel" to an empty string, so that the function "setActiveRouting"
			(webapp.userservices.controlBase) can know that the current routing has been changed to none*/
			//webapp.userservices.data.currentRoutingLabel = "";
			/* Set the global webapp variable "currentRoutingID" to "0", so that the callback "onClickRouting"
			(webapp.userservices.controlBase) can know that the current routing has been changed to None*/
			this.currentRoutingID = 0;
		//ICTouchAPI.settingServices.setSettingValue("ActiveRouting", "None");
		}
		else {
			// the routing to delete is not currently set, just remove it from the list
			this.changeMode(this.NORMAL_MODE);
			ICTouchAPI.settingServices.setSettingValue("RoutingList", params.arr, this, this.closePopup );
		}
		str=null;
		params=null;
	},

	// Hide the popup
	closePopup : function() {
		ICTouchAPI.popupServices.removePopup(this.objPopup);
		this.loadRoutingDetails();
	},

	// Called when we click on "Voicemail" in the menuList
	loadVoicemailDetails: function() {
		this.switchContainer("getVoicemailContent", this.VOICEMAIL_SCREEN, _("Voicemail Message", "webapp.userservices"));
	},

	// Called when we click on "UserInfo" in the menuList
	loadUserInfoDetails: function() {
		this._arrAllDetails[this.USER_INFO_SCREEN] = [];
		var arrIds = ICTouchAPI.tools.isFirstNameFirstDisplayed() ? ["UserFirstName", "UserName"] : ["UserName", "UserFirstName"];
		arrIds.push("SIPUserName");
		ICTouchAPI.settingServices.getSettingsFromIds(arrIds, this, this.loadedUserInfoDetails);
	},

	// Callback of loadUserInfoDetails
	loadedUserInfoDetails: function(arr) {
		var obj = {};
		for(var i in arr)
		{
			obj = {
				strContent: arr[i].value,
				strLabel: _(arr[i].label, "webapp.settings"),
				callback: dojo.hitch(webapp.userservices, webapp.userservices.onClickUserInfo, arr[i]),
				objSetting: arr[i],
				boolEnabled : (arr[i].user_rights == 2) ? true : false
			};

			this._arrAllDetails[this.USER_INFO_SCREEN].push(obj);
		}
		
		// Add a last entry for CLIR, which is composed of 2 settings
		var HideIdentityLabel;
		if(this.getHideIdentityState()){
			HideIdentityLabel = "Activated " + '(' + this.lstHideIdentityBarringRules[this.getHideIdentityBarringRule()] + ')';
		} else {
			HideIdentityLabel = "Not active";
		}
		obj = {
			strContent: _(HideIdentityLabel, "webapp.userservices"),
			strLabel: _("Hide User Identity", "webapp.userservices"),
			boolEnabled : false
		};

		this._arrAllDetails[this.USER_INFO_SCREEN].push(obj);
		
		// Add a new entry for supervision hidden state
		if(this._supervisionHiddenState){
			obj = {
				strContent: _("Contact your administrator", "ICTouchAPI"),
				strLabel: _("Supervision", "webapp.userservices"),
				boolEnabled : false
			};

			this._arrAllDetails[this.USER_INFO_SCREEN].push(obj);
		}
		
		this.switchContainer("getUserInfoContent", this.USER_INFO_SCREEN, _("UserInfo", "webapp.userservices"));

		arr = null;
	},

	// Callback of loadUserInfoDetails
	//loadedUserInfoDnd: function(value) {
	//	var appBar = ICTouchAPI.AppBarServices.getAppBar("userservices","userservicesstatus"+this.USER_INFO_SCREEN);
	//	this.setDndButtonStatus(value, appBar);
	//	this.switchContainer("getUserInfoContent", this.USER_INFO_SCREEN, _("UserInfo", "webapp.userservices"));
	//},

	// Called when we click on "Video" in the menuList
	loadVideoDetails: function() {
		this.switchContainer("getVideoContent", this.VIDEO_SCREEN, _("Video", "ICTouchAPI"));
	},

	// Change the status text in the dnd Button of "appBar" according to "value"
	setDndButtonStatus: function(boolDnd) {
		this.dndButtonStatus = boolDnd;
		var _strStatus = (boolDnd) ? 'notif-on' : 'notif-off';//_("on", "ICTouchAPI") : _("off", "ICTouchAPI");
		var appBar = ICTouchAPI.AppBarServices.getAppBar("userservices","userservicesstatus"+this.USER_INFO_SCREEN);
		var dndButton = appBar.getButton(this.DND);
		if(dndButton){
			dndButton.setStatusIcon(_strStatus);
		//dndButton.attr("strStatusText", _strStatus);
		}
		boolDnd = null;
	},

	// Call to the webapp Search to find a number
	onOtherSearch : function() {
		var strWidget = this.getContainerPath();
		var func = null;
		var funcExit = null;
		if(strWidget == "webapp.userservices.getRoutingContent") {
			if(!this.getMultiDeviceRoutingAvailability()){
				func = {
					context: webapp.userservices.data,
					func: webapp.userservices.data.searchForImmediateRouting
				};
				funcExit = dojo.hitch(webapp.userservices.data, webapp.userservices.data.loadRoutingDetails);
			}else{
				func = {
					neededData	: "phoneNumber",
					context: webapp.userservices.data,
					func: webapp.userservices.data.setUserRouting,
					leftIconImage  : "generic-ok-32",
					leftIconImageConditionnalDisplay  : "phoneNumber"
				};
				funcExit = dojo.hitch(webapp.userservices.data, webapp.userservices.data.loadRoutingDetails);
			}
			
		}else if(strWidget == "webapp.userservices.getRoutingAdd2Content") {
			func = {
				neededData	: "phoneNumber",
				context: webapp.userservices.data,
				func: webapp.userservices.data.searchForRoutingDestination
			};
		}else if(strWidget == "webapp.userservices.getOverflowContent") {
			func = {
				neededData	: "phoneNumber",
				context: webapp.userservices.data,
				func: webapp.userservices.data.searchForOverflow,
				leftIconImage  : "generic-ok-32",
				leftIconImageConditionnalDisplay  : "phoneNumber"
			};
			funcExit = dojo.hitch(webapp.userservices.data, webapp.userservices.data.loadOverflowDetails);
		}else if(strWidget == "webapp.userservices.getProfileDetails") {
			func = {
				neededData	: "phoneNumber",
				context: webapp.userservices.data,
				func: webapp.userservices.data.setOtherNumber,
				leftIconImage  : "generic-ok-32",
				leftIconImageConditionnalDisplay  : "phoneNumber"
			};
			funcExit = dojo.hitch(webapp.userservices, webapp.userservices._setOtherNumber);
		}
		var objSearch = {
			contactDataTypes		: ["Phone"],
			lineClickCallback		: func,
			secondaryInformation : "phoneNumber", // information of the contact to be displayed at the right of the contact's display name in the search results
			useDefaultCallMethod	: true,
			funcCallbackExit		: funcExit,
			callingWebapp			: "userservices"
		};

		if(webapp.communication && webapp.communication.data){
			// Set select mode
			if(strWidget == "webapp.userservices.getProfileDetails"){
				webapp.communication.setSelectStatus(webapp.communication.data.STATUS_MDR_ROUTING);
			}else if(strWidget == "webapp.userservices.getOverflowContent"){
				webapp.communication.setSelectStatus(webapp.communication.data.STATUS_MDR_OVERFLOW);
			}else if(strWidget == "webapp.userservices.getRoutingContent"){
				if(this.getMultiDeviceRoutingAvailability()){
					webapp.communication.setSelectStatus(webapp.communication.data.STATUS_MDR_USER);
				}else{
					webapp.communication.setSelectStatus(webapp.communication.data.STATUS_BASIC_IMMEDIATE_ROUTING);
				}
			}else if(strWidget == "webapp.userservices.getRoutingAdd2Content"){
				webapp.communication.setSelectStatus(webapp.communication.data.STATUS_BASIC_ADD_ROUTING);
			}
			webapp.communication.updateAppBar();
			// get and save the callId
			webapp.communication.data._objFirstSelected = webapp.communication.data.getSelectedEntry();
			objSearch.searchType = webapp.communication.getKeyPadActionFromSelectStatus();
		}

		if(webapp.history && webapp.history.data){
			// Set select mode
			if(strWidget == "webapp.userservices.getProfileDetails"){
				webapp.history.setSelectStatus(webapp.history.data.STATUS_MDR_ROUTING);
			}else if(strWidget == "webapp.userservices.getOverflowContent"){
				webapp.history.setSelectStatus(webapp.history.data.STATUS_MDR_OVERFLOW);
			}else if(strWidget == "webapp.userservices.getRoutingContent"){
				if(this.getMultiDeviceRoutingAvailability()){
					webapp.history.setSelectStatus(webapp.history.data.STATUS_MDR_USER);
				}else{
					webapp.history.setSelectStatus(webapp.history.data.STATUS_BASIC_IMMEDIATE_ROUTING);
				}
			}else if(strWidget == "webapp.userservices.getRoutingAdd2Content"){
				webapp.history.setSelectStatus(webapp.history.data.STATUS_BASIC_ADD_ROUTING);
			}
			webapp.history.updateAppBar();
			// get and save the callId
			webapp.history.data._objFirstSelected = webapp.history.data.getSelectedEntry();
		}

		//Set right icon callback
		objSearch.rightIconClickCallback = {
			neededData : "Contact",
			rightIconImage  : "contacts-card-32",
			rightIconImageRemoteContact : "contacts-contact-card-remote-32",
			context:webapp.userservices,
			func: function (objContact) {
				dojo.publish("e_contact_showContact",[{
					objContact: objContact,
					needStealth : true,
					clbkBack: function() {
						if(webapp.userservices.data.getContainerPath() == "webapp.userservices.getProfileDetails"){
							webapp.userservices._setOtherNumber("");
						}else if(webapp.userservices.data.getContainerPath() == "webapp.userservices.getOverflowContent"){
							webapp.userservices.data.loadOverflowDetails();
						}
						ICTouchAPI.transitionServices.unstealth("webapp.contacts.getContact");
						ICTouchAPI.transitionServices.back();
					}
				}]);
			}
		};

		var byNameObject = {
			funcCallbackOk : function(){
				if(!webapp.communication.data.getBoolInitiateByName()){
					var callback = objSearch.lineClickCallback;
						callback.func.apply(callback.context, [null, {
						strContent: this.getValue()
					}]);
				} else {
					webapp.communication.data.setBoolInitiateByName(false);
				}
			},
			funcCallbackExit : function () {
				//ICTouchAPI.transitionServices.back();
			}
		}
		objSearch.byNameObject = byNameObject;

		if (webapp.search) {
			webapp.search.doSearch(objSearch,
				function() {
					if(webapp.userservices.data.getContainerPath() == "webapp.userservices.getProfileDetails"){
						webapp.userservices._setOtherNumber("");
					}else if(webapp.userservices.data.getContainerPath() == "webapp.userservices.getOverflowContent"){
						webapp.userservices.data.loadOverflowDetails();
					}else if(webapp.userservices.data.getContainerPath() == "webapp.userservices.getRoutingContent"){
						webapp.userservices.data.loadRoutingDetails();
					}
					ICTouchAPI.transitionServices.back();
					/*ICTouchAPI.transitionServices.getScreen({
						name: "webapp.userservices.getUserService",
						params: {}
					});*/
					webapp.userservices.data.mainWidget.reloadContainer();

				}
				);
		} else {
			// show numeric
			ICTouchAPI.keyboardServices.deployKeyboard(ICTouchAPI.KeyboardTypes.NUM, null,{
				strDefaultText: "",
				funcCallbackOk : function(){
					objSearch.clickCallback(null, {
						strContent: this.getValue()
					});
				},
				funcCallbackExit : function(){
					objSearch.funcCallbackExit();
				}
			});
		}
	},

	// When we click on "immediate forward to..."
	searchForImmediateRouting : function(phoneNumber, objNumber) {
		var number = "";
		if(objNumber && objNumber.strContent){
			number = objNumber.strContent;
			ICTouchAPI.keyboardServices.closeKeyboard(ICTouchAPI.keyboardServices.CLOSE_ACTION_EXIT);
			webapp.userservices.setImmediateActiveRouting(number);
		} else if(phoneNumber) {
			webapp.userservices.setImmediateActiveRouting(phoneNumber);
			/*ICTouchAPI.APIServices.Telephony.makeCanonicalNumber({
				params:[number],
				context: webapp.userservices,
				callback: webapp.userservices.setImmediateActiveRouting
			});*/
		}
		phoneNumber=null;
		objNumber=null;
	},

	setOtherNumber : function(phoneNumber, objNumber) {
		var number = "";
		if(phoneNumber) {
			ICTouchAPI.transitionServices.back();
			if(webapp.communication && webapp.communication.data) {
				ICTouchAPI.transitionServices.back();
				webapp.communication.setSelectStatus(-1);
				webapp.communication.updateAppBar();
			}
			/*ICTouchAPI.APIServices.Telephony.makeCanonicalNumber({
				params:[number],
				context: webapp.userservices,
				callback: webapp.userservices._setOtherNumber
			});*/
			webapp.userservices._setOtherNumber(phoneNumber,true);
		}else if(objNumber && objNumber.strContent !=""){
			if(webapp.communication && webapp.communication.data) {
				if(objNumber.boolBack){
					ICTouchAPI.transitionServices.back();
				}
				webapp.communication.setSelectStatus(-1);
				webapp.communication.updateAppBar();
			}
			number = objNumber.strContent;
			ICTouchAPI.keyboardServices.closeKeyboard(ICTouchAPI.keyboardServices.CLOSE_ACTION_EXIT);
			webapp.userservices._setOtherNumber(number,false);
		}else{
			var availableDevices = this.getCurrentAvailableDevices();
			for(var device in availableDevices){
				if(availableDevices[device].presentationDestinationType.value.value == this.DEVICE_OTHER){
					availableDevices[device].isSelected = false;
					this.objDetailsScreen.getContent().unselectAtIndex(device);
				}
			}
		}
		phoneNumber = null;
		objNumber = null;
	},

	searchForOverflow : function(phoneNumber, objNumber) {
		var number = "";
		if(phoneNumber) {
			if(webapp.communication && webapp.communication.data) {
				ICTouchAPI.transitionServices.back();
				webapp.communication.setSelectStatus(-1);
				webapp.communication.updateAppBar();
			}
			webapp.userservices.setOverflow(phoneNumber,true);
		}else if(objNumber && objNumber.strContent){
			number = objNumber.strContent;
			ICTouchAPI.keyboardServices.closeKeyboard(ICTouchAPI.keyboardServices.CLOSE_ACTION_EXIT);
			webapp.userservices.setOverflow(number,false);
			if(webapp.communication && webapp.communication.data) {
				if(objNumber.boolBack){
					ICTouchAPI.transitionServices.back();
				}
				webapp.communication.setSelectStatus(-1);
				webapp.communication.updateAppBar();
			}
		}
		phoneNumber=null;
		objNumber=null;
	},

	setUserRouting : function(phoneNumber, objNumber) {
		var number = "";
		if(objNumber && objNumber.strContent){
			if(webapp.communication && webapp.communication.data) {
				if(objNumber.boolBack){
					ICTouchAPI.transitionServices.back();
				}
					webapp.communication.setSelectStatus(-1);
					webapp.communication.updateAppBar();
				}
			number = objNumber.strContent;
			ICTouchAPI.keyboardServices.closeKeyboard(ICTouchAPI.keyboardServices.CLOSE_ACTION_EXIT);
			webapp.userservices._setUserRouting(number);
		}else if(phoneNumber) {
			if(webapp.communication && webapp.communication.data) {
				ICTouchAPI.transitionServices.back();
				webapp.communication.setSelectStatus(-1);
				webapp.communication.updateAppBar();
			}
			ICTouchAPI.APIServices.Telephony.makeCanonicalNumber({
				params:[phoneNumber],
				context: webapp.userservices,
				callback: webapp.userservices._setUserRouting
			});
		}
		phoneNumber=null;
		objNumber=null;
	},

	// Callback of searchForImmediateRouting
	_searchedForImmediateRouting : function() {
		this.loadRoutingDetails();
	},

	// When we click on "other" in the second step of adding routing
	searchForRoutingDestination : function (phoneNumber, objNumber) {
		var number = null;
		if(objNumber && objNumber.strContent){
			number = objNumber.strContent;
			ICTouchAPI.keyboardServices.closeKeyboard(ICTouchAPI.keyboardServices.CLOSE_ACTION_EXIT);
		} else if (phoneNumber) {
			number = phoneNumber;
		}
		if(number){
			ICTouchAPI.APIServices.Telephony.makeCanonicalNumber({
				params:[number],
				context: webapp.userservices,
				callback: webapp.userservices.setDestinationRouting
			});
		}
		phoneNumber = null;
		objNumber = null;
	},



	// Change the currentMode and the statusIcon for delete and modify appButton
	changeMode : function(mode) {
		this.currentMode = mode;
		var appBar = ICTouchAPI.AppBarServices.getAppBar("userservices","userservicesstatus"+this.ROUTING_SCREEN);
		var modifyButton = appBar.getButton(this.MODIFY_ROUTING);
		var deleteButton = appBar.getButton(this.DELETE_ROUTING);
		switch (mode)
		{
			case this.NORMAL_MODE :
				modifyButton.setStatusIcon(this.STATUS_OFF_ICON);
				deleteButton.setStatusIcon(this.STATUS_OFF_ICON);
				break;
			case this.MODIFY_MODE :
				modifyButton.setStatusIcon(this.STATUS_ON_ICON);
				deleteButton.setStatusIcon(this.STATUS_OFF_ICON);
				break;
			case this.DELETE_MODE :
				modifyButton.setStatusIcon(this.STATUS_OFF_ICON);
				deleteButton.setStatusIcon(this.STATUS_ON_ICON);
				break;
			default :
				break;
		}
		mode = null;
	},

	getContainerPath : function() {
		return this._strContainerPath;
	},

	getAppBarAppButtons : function() {
		var arrTranslated = dojo.clone(this._arrAppButtons);
		dojo.forEach(arrTranslated, function(objButton) {
			objButton.strButtonLabel = ICTouchAPI.i18nServices.translate(objButton.strButtonLabel, "webapp.userservices");
		});
		return arrTranslated;
	},


	getUserServiceListTitle : function() {
		return this._strUserServiceListTitle;
	},

	getUserServiceList : function() {
		var availableList = [];
		for(var i=0; i<this.NB_STATUS; ++i)
		{
			if( this._arrListEntries[i] != null )
				availableList.push(this._arrListEntries[i]);
		}
		return availableList;
	},

	getUserServiceContainerTitle : function(){
		return this._strUserServiceContainerTitle;
	},

	getRoutingData : function() {
		return this._arrAllDetails[this.ROUTING_SCREEN];
	},

	getOverflowData : function() {
		return this._arrAllDetails[this.OVERFLOW_SCREEN];
	},

	getRoutingTypeData : function() {
		return this._arrAllDetails[this.ADD_ROUTING_1_SCREEN];
	},

	getRoutingDestinationData: function() {
		return this._arrAllDetails[this.ADD_ROUTING_2_SCREEN];
	},

	getOverflowTypeData : function() {
		return this._arrAllDetails[this.ADD_OVERFLOW_1_SCREEN];
	},

	getOverflowDestinationData: function() {
		return this._arrAllDetails[this.ADD_OVERFLOW_2_SCREEN];
	},

	getPresenceData : function() {
		return this._arrAllDetails[this.PRESENCE_IM_SCREEN];
	},

	getUserInfoData : function() {
		return this._arrAllDetails[this.USER_INFO_SCREEN];
	},

	// Set a new routing message
	updateCustomRouting: function() {
		var str = ICTouchAPI.keyboardServices.getValue();
		var last = this._arrAllDetails[this.PRESENCE_IM_SCREEN].length-1;
		this._arrAllDetails[this.PRESENCE_IM_SCREEN][last].strLabel = str;
		ICTouchAPI.settingServices.setSettingValue("UserPresenceCustomMsg", str, this, this._updatedCustomRouting);
	},

	// Callback of updateCustomRouting
	_updatedCustomRouting : function() {
		this.switchContainer("getPresenceContent",this.PRESENCE_IM_SCREEN, _("Select your presence", "webapp.userservices"));
	},

	// set a new content for the container of the userservices and call an update of the appBar
	switchContainer: function(pageName, status, pageTitle) {
		this._strContainerPath = "webapp.userservices."+pageName;
		if(pageTitle){
			this._strUserServiceContainerTitle = pageTitle;
		}
		this.updateAppBar(status);
		if(this.mainWidget){
			this.mainWidget.reloadContainer();
		}
		pageName = null;
		status = null;
		pageTitle = null;
	},

	// set the appBar corresponding to the status
	updateAppBar: function(status) {
		// set the status
		webapp.userservices.currentStatus = status;

		// button callback
		var backFunc = dojo.hitch( webapp.userservices, webapp.userservices.buttonCallback, this.BACK);

		// Create the static back button
		ICTouchAPI.AppBarServices.addExitButton("userservices","userservicesstatus"+status, this.isPreviousHome(), backFunc);

		// Register appBar according to state
		if(this.mainWidget){
			if(status != this.PROFILE_DETAILS_SCREEN){
				ICTouchAPI.AppBarServices.setAppBar("userservices","userservicesstatus"+status, "getUserService")
			}else{
				ICTouchAPI.AppBarServices.setAppBar("userservices","userservicesstatus"+status, "getProfileDetails")
			}
		}
		this.updateAppButtons();
		status = null;
	// var appBar = ICTouchAPI.AppBarServices.getAppBar("userservices","userservicesstatus"+status);
	// appBar.updateAppBar();
	},

	// Hide or show routing buttons according to mode (simplified or not)
	updateAppButtons : function() {
		if(this.getContainerPath() == "webapp.userservices.getRoutingContent"){
			if(this.getMultiDeviceRoutingAvailability()){
				webapp.userservices.hideEditionButton();
			}else{
				var appBar = ICTouchAPI.AppBarServices.getAppBar("userservices","userservicesstatus"+webapp.userservices.currentStatus);
				var addButton = appBar.getButton(this.ADD_ROUTING);
				var modifyButton = appBar.getButton(this.MODIFY_ROUTING);
				var deleteButton = appBar.getButton(this.DELETE_ROUTING);
				if(this.boolSimplifiedForwardMode) {
					addButton.hide();
					modifyButton.hide();
					deleteButton.hide();
				} else {
					addButton.show();
					modifyButton.show();
					deleteButton.show();
				}
			}
		}
	},


	isPreviousHome : function() {
		switch(this._strContainerPath) {
			case "webapp.userservices.getRoutingAdd2Content" :
				return false;
				break;
			case "webapp.userservices.getRoutingAdd1Content" :
				return false;
				break;
			case "webapp.userservices.getProfileDetails" :
				return false;
				break;
			default :
				return true;
				break;
		}
	},

	setRightToUserServices : function(){
		this.accessRightToUserServices = false;
	},

	getRightToUserServices : function(){
		return this.accessRightToUserServices;
	},

	setIMAvailability : function(_value){
		this.boolIMAvailabilityChanged = _value;
		_value = null;
	},

	getIMAvailability : function(){
		return this.boolIMAvailabilityChanged;
	},

	setMultiDeviceRoutingAvailability : function(_value){
		this.multiDeviceRoutingAvailability = _value;
		_value = null;
	},

	getMultiDeviceRoutingAvailability : function(){
		return this.multiDeviceRoutingAvailability;
	},

	setAllowDirectCustomForward : function(_value){
		this.allowDirectCustomForward = _value;
		_value = null;
	},

	getAllowDirectCustomForward : function(){
		return this.allowDirectCustomForward;
	},

	getCurrentOverflow : function(){
		return this.currentOverflow;
	},

	setCurrentOverflow : function(_overFlow){
		this.currentOverflow=_overFlow;
		_overFlow = null;
	},

	getTelephonyAttendantNumber : function(){
		return this.telephonyAttendantNumber;
	},

	setTelephonyAttendantNumber : function(number){
		this.telephonyAttendantNumber=number;
		number = null;
	},

	getTelephonyAssociateNumber : function(){
		return this.telephonyAssociateNumber;
	},

	setTelephonyAssociateNumber : function(number){
		this.telephonyAssociateNumber=number;
		number = null;
	},

	getTelephonyMobileNumber : function(){
		return this.telephonyMobileNumber;
	},

	setTelephonyMobileNumber : function(number){
		this.telephonyMobileNumber=number;
		number = null;
	},

	getTelephonyVmNumber : function(){
		return this.telephonyVmNumber;
	},

	setTelephonyVmNumber : function(number){
		this.telephonyVmNumber=number;
		number = null;
	},

	getArrLatestNumbers : function(){
		return this.arrLatestNumbers;
	},

	setArrLatestNumbers : function(value){
		this.arrLatestNumbers=value.split(",");
		value = null;

	},

	getCacheNumbers : function(){
		var results = [];
		/*var attendantNumber = this.getTelephonyAttendantNumber();
		var associateNumber = this.getTelephonyAssociateNumber();
		var mobileNumber = this.getTelephonyMobileNumber();
		var vmNumber = this.getTelephonyVmNumber();*/
		var latestNumbers = this.getArrLatestNumbers();
		if(latestNumbers){
			var i = latestNumbers.length;
			for(i ; i > 0 ; i--){
				results.push({strLabel : latestNumbers[i-1], type : this.DST_UNDEFINED, number : latestNumbers[i-1]});
			}
		}
		/*if(attendantNumber){
			results.push({strLabel : _(this.DST_ATTENDANT,"webapp.userservices") , type : this.DST_ATTENDANT , number : attendantNumber});
		}
		if(associateNumber){
			results.push({strLabel : _(this.DST_ASSOCIATE,"webapp.userservices") , type : this.DST_ATTENDANT , number : associateNumber});
		}
		if(mobileNumber){
			results.push({strLabel : _(this.DST_MOBILE,"webapp.userservices") , type : this.DST_MOBILE , number : mobileNumber});
		}
		if(vmNumber){
			results.push({strLabel : _(this.DST_VOICEMAIL,"webapp.userservices") , type : this.DST_VOICEMAIL , number : vmNumber});
		}*/
		this._tempCacheNumber=results;
		return results;
	},

	setCurrentAvailableDevices : function(_arrDevices){
		this.currentAvailableDevices = _arrDevices;
		_arrDevices = null;
	},

	getCurrentAvailableDevices : function(){
		return this.currentAvailableDevices;
	},


	setCurrentRoutingState : function(_routingState){
		this.objRoutingState = _routingState;
		_routingState = null;
	},

	getCurrentRoutingState : function(){
		return this.objRoutingState;
	},

	setCurrentProfile : function(_profile){
		this.currentProfile = _profile.value;
		_profile = null;
	},

	getCurrentProfile : function(){
		return this.currentProfile;
	},

	setOverflowList : function(_list){
		this._arrOverflowList = _list;
		_list = null;
	},

	getOverflowList : function(){
		return this._arrOverflowList;
	},

	setForwardList : function(_list){
		this._arrForwardList = _list;
		_list = null;
	},

	getForwardList : function(){
		return this._arrForwardList;
	},
	
	setRoutingProfileData : function(_data){
		this.routingProfileData = _data;
		_data = null;
	},

	getRoutingProfileData : function(){
		return this.routingProfileData;
	},

	isGetRoutingProfilesMade : function(){
		return this.boolIsGetRoutingProfilesMade;
	},

	setGetRoutingProfilesMade : function(isMade){
		this.boolIsGetRoutingProfilesMade = isMade;
	},
	
	getHideIdentityState : function() {
		return this.hideIdentityStatus;
	},
	
	setHideIdentityState : function(boolNewStatus) {
		this.hideIdentityStatus = boolNewStatus;
	},
	
	getHideIdentityBarringRule : function() {
		return this.hideIdentityBarringRule;
	},
	
	setHideIdentityBarringRule : function(strNewRule) {
		if(this.lstHideIdentityBarringRules[strNewRule] && this.hideIdentityBarringRule !== strNewRule){
			this.hideIdentityBarringRule = strNewRule
			if(this.isUserInfoDisplayed()){
				this.loadUserInfoDetails();
			}
		} else {
			ICTouchAPI.debugServices.warning("webapp.userservices.dataBase - onClickProfile / incorrect value: " + strNewRule + ". Current value is: " + this.hideIdentityBarringRule);
		}
	},
	
	setHideIdentityBarringRuleAllowedValues : function(objAllowedValues) {
		this.lstHideIdentityBarringRules = {};
		for(var i in objAllowedValues){
			this.lstHideIdentityBarringRules[objAllowedValues[i].id] = objAllowedValues[i].name;
		}
	},
	
	isUserInfoDisplayed : function() {
		if(this._strContainerPath == "webapp.userservices.getUserInfoContent"){
			return true;
		}
		else {
			return false;
		}
	},
	
	setHideUserIdentityButtonStatus : function(hideIdentityStatus) {
		var statusIconHI;
		if(hideIdentityStatus){
			statusIconHI = this.STATUS_ON_ICON;
		} else {
			statusIconHI = this.STATUS_OFF_ICON;
		}
		// update the button
		var appBarHI = ICTouchAPI.AppBarServices.getAppBar("userservices","userservicesstatus"+this.USER_INFO_SCREEN);
		var HIButton = appBarHI.getButton(this.HIDE_IDENTITY);
		if(HIButton){
			HIButton.setStatusIcon(statusIconHI);
		}
		if(this.hresetButtonStatus){
			clearTimeout(this.hresetButtonStatus); 
			this.hresetButtonStatus = null;
		}
		this.destroyClirSpinner();
	},
	
	createClirSpinner : function() {
		this.destroyClirSpinner();
		this.objCLIRSpinner = new UIElements.Spinner.SpinnerControl({strMessage : _("Please wait...", "ICTouchAPI"), boolForeground:true}, document.body);
		this.hCLIRSpinner = setTimeout(dojo.hitch(this, this.destroyClirSpinner), 5000);
	},
    
	destroyClirSpinner : function() {
		if(this.objCLIRSpinner){
			this.objCLIRSpinner.destroy();
			this.objCLIRSpinner = null;
		}
		if(this.hCLIRSpinner){
			clearTimeout(this.hCLIRSpinner);
			this.hCLIRSpinner = null;
		}
	}

});
