dojo.provide("webapp.userservices.controlBase");
dojo.declare("webapp.userservices.controlBase",[ICTouchAPI.webApplication],
{

	constructor : function()
	{
		ICTouchAPI.skinServices.linkWebappsStyles("webapp.userservices","webapp.communication", true, true, true);
		ICTouchAPI.skinServices.linkWebappsStyles("webapp.getProgKeysPreview","webapp.communication", true, false, true, false);
		ICTouchAPI.skinServices.linkWebappsStyles("UIElements.Keyboard","webapp.userservices",true,true,true);
	},

    load : function() {
		// Suscribe to setting
		ICTouchAPI.settingServices.subscribeToSetting(this, "TelephonyVmNumber", this.onVmNumberChanged);
		ICTouchAPI.settingServices.subscribeToSetting(this, "ActiveRouting", this.onActiveRoutingChanged);
		ICTouchAPI.settingServices.subscribeToSetting(this, "TelephonySimplifiedForward", this.onSimplifiedForwardChanged);
		ICTouchAPI.settingServices.subscribeToSetting(this, "DndRequiresPassword", this.onDndRequiresPasswordChanged);
		ICTouchAPI.settingServices.subscribeToSetting(this, "TelephonyDndState", this.onDndChanged);
		ICTouchAPI.settingServices.subscribeToSetting(this, "EnableRoutingLed", this.onRoutingLedChanged);
		// To init webapp after a boot
		ICTouchAPI.settingServices.getSetting('TelephonyVmNumber', this, this.onVmNumberChanged);
		ICTouchAPI.settingServices.getSetting('ActiveRouting', this, this.onActiveRoutingChanged);
		ICTouchAPI.settingServices.getSetting('TelephonySimplifiedForward', this, this.onSimplifiedForwardChanged);
		ICTouchAPI.settingServices.getSetting('DndRequiresPassword', this, this.onDndRequiresPasswordChanged);
		ICTouchAPI.settingServices.getSetting('TelephonyDndState', this, this.onDndChanged);
		ICTouchAPI.settingServices.getSetting('EnableRoutingLed', this, this.onRoutingLedChanged);

		ICTouchAPI.CapabilityServices.subscribeToCapability("Video", "LocalVideoEnabled", this, this.onLocalVideoEnabledChanged);

		// Subscribe to connectivity_changed event
		ICTouchAPI.eventServices.subscribeToEvent(this, "connectivity_changed", this.onConnectivityChanged);

		// Help Event
		var widgetsTab = [];
		for(var i in this.data._arrAppBarSkeleton){
			widgetsTab.push("userservicesstatus"+i);
		}
		dojo.publish("needHelpEvent",["userservices",widgetsTab]);
	},

	loaded : function() {
		// Capability subscription
		ICTouchAPI.CapabilityServices.subscribeToCapability("Telephony", "multideviceRouting", this, this.multiDeviceRoutingSelectionAvailability);

		// Register to senskey
		ICTouchAPI.eventServices.subscribeToEvent(this, "SENSKEY_USER", this.eventPhysicalKeyUser);
		ICTouchAPI.eventServices.subscribeToEvent(this, "SENSKEY_HOME", this.eventPhysicalKeyHome);

		ICTouchAPI.eventServices.subscribeToEvent(this, "BasicRoutingFailedEvent", this.onForwardFailed);
		ICTouchAPI.eventServices.subscribeToEvent(this, "OutOfTheOfficeStatusEvent", this.onOutOfTheOfficeStatusChanged);
		
		ICTouchAPI.eventServices.subscribeToEvent(this, "DeactivateForwardEvent", this.eventDeactivateForwardEvent);

		dojo.subscribe("ModeHotel", this, this.onForbidAccess);
		dojo.subscribe("RequestCurrentProfile", this, this.onRequestProfile);
		
		dojo.subscribe("userservices.selectUserDevice", this, this.onSelectUserDeviceRequest);
		
		ICTouchAPI.settingServices.subscribeToSetting(this, "EnableUserDetails", this.onSettingChanged);
		ICTouchAPI.settingServices.subscribeToSetting(this, "EnableUserPresence", this.onSettingChanged);
		ICTouchAPI.settingServices.subscribeToSetting(this, "EnableRouting", this.onSettingChanged);
		ICTouchAPI.settingServices.subscribeToSetting(this, "EnableOverflow", this.onSettingChanged);
		ICTouchAPI.settingServices.subscribeToSetting(this, "AllowDirectCustomForward", this.onAllowDirectCustomForwardChanged);
		ICTouchAPI.settingServices.subscribeToSetting(this, "TelephonyHideIdentityByUserAllowed", this.onAllowHideIdentityByUser);
		ICTouchAPI.settingServices.subscribeToSetting(this, "TelephonyHideIdentityBarringRule", this.onHideIdentityBarringRuleChanged);
		ICTouchAPI.settingServices.getSetting("EnableRouting",this , this.onSettingChanged);
		ICTouchAPI.settingServices.getSetting("EnableOverflow",this , this.onSettingChanged);
		ICTouchAPI.settingServices.getSetting("EnableUserDetails",this , this.onSettingChanged);
		ICTouchAPI.settingServices.getSetting("EnableUserPresence",this , this.onSettingChanged);
		ICTouchAPI.settingServices.getSetting("AllowDirectCustomForward",this, this.onAllowDirectCustomForwardChanged);
		ICTouchAPI.settingServices.getSetting("TelephonyHideIdentityByUserAllowed",this, this.onAllowHideIdentityByUser);
		ICTouchAPI.settingServices.getSetting("TelephonyHideIdentityBarringRule",this, this.onHideIdentityBarringRuleChanged);
		dojo.subscribe("IM_AVAILABILITY_CHANGED",this,this.onIMAvailabilityChanged);

		//Profiles modification event
		ICTouchAPI.eventServices.subscribeToEvent(this, "RoutingStateChanged", this.routingStateChangedEvent);

		//Cache numbers gestion
		ICTouchAPI.settingServices.getSetting("TelephonyAttendantNumber",this , this.onNumberChanged);
		ICTouchAPI.settingServices.getSetting("TelephonyAssociateNumber",this , this.onNumberChanged);
		ICTouchAPI.settingServices.getSetting("TelephonyMobileNumber",this , this.onNumberChanged);
		ICTouchAPI.settingServices.getSetting("TelephonyVmNumber",this , this.onNumberChanged);
		ICTouchAPI.settingServices.getSetting("LatestNumbersCache",this , this.onNumberChanged);
		ICTouchAPI.settingServices.subscribeToSetting(this, "TelephonyAttendantNumber", this.onNumberChanged);
		ICTouchAPI.settingServices.subscribeToSetting(this, "TelephonyAssociateNumber", this.onNumberChanged);
		ICTouchAPI.settingServices.subscribeToSetting(this, "TelephonyMobileNumber", this.onNumberChanged);
		ICTouchAPI.settingServices.subscribeToSetting(this, "TelephonyVmNumber", this.onNumberChanged);
		ICTouchAPI.settingServices.subscribeToSetting(this, "LatestNumbersCache", this.onNumberChanged);

		dojo.subscribe("iframe.show",this,this.onUserServicesShow);

		//this.data.loadRoutingDetails();
	},

	setProfilesFromSummaryList : function(profilesSummaryList){
		this.data._arrProfilesSummaryList = profilesSummaryList;
		profilesSummaryList = null;
	},
	

	onSettingChanged : function(objUserServicesSetting){
		if(objUserServicesSetting && objUserServicesSetting.id){
			switch (objUserServicesSetting.id) {
				case "EnableUserDetails":
					if (objUserServicesSetting.jsValue) {
						this.data._arrListEntries[this.data.USER_INFO_SCREEN] = {
							intIndex: this.data.USER_INFO_SCREEN,
							strPrimaryContent: _("UserInfo", "webapp.userservices")
						};
					}else{
						this.data._arrListEntries[this.data.USER_INFO_SCREEN] = null;
					}
					break;
				case "EnableRouting":
					if (objUserServicesSetting.jsValue) {
						this.data.intSelectListItem = this.data.ROUTING_SCREEN;
						this.data._arrListEntries[this.data.ROUTING_SCREEN] = {
							intIndex: this.data.ROUTING_SCREEN,
							strPrimaryContent: _("Routing", "webapp.userservices")
						};
					}else{
						this.data._arrListEntries[this.data.ROUTING_SCREEN] = null;
					}
					break;
				case "EnableUserPresence":
					if (objUserServicesSetting.jsValue && webapp.userinfo && webapp.userinfo.boolIMAvailable) {
						this.data._arrListEntries[this.data.PRESENCE_IM_SCREEN] = {
							intIndex: this.data.PRESENCE_IM_SCREEN,
							strPrimaryContent: _("Presence", "webapp.userservices")
						};
					}else{
						this.data._arrListEntries[this.data.PRESENCE_IM_SCREEN] = null;
					}
					break;
				case "EnableOverflow":
					if (objUserServicesSetting.jsValue) {
						this.data._arrListEntries[this.data.OVERFLOW_SCREEN] = {
							intIndex: this.data.OVERFLOW_SCREEN,
							strPrimaryContent: _("Overflow", "webapp.userservices")
						};
					}else{
						this.data._arrListEntries[this.data.OVERFLOW_SCREEN] = null;
					}
					break;
				default:
					break;
			}
			if (this.data.mainWidget) {
				this.data.mainWidget.reload();
			}
		}
		objUserServicesSetting = null;
	},

	updateVideoEntry : function () {
		var needReload = false;
		if(this.data.isWebcamAvailable && this.data.isLocalVideoEnabled &&
			!this.data._arrListEntries[this.data.VIDEO_SCREEN]){
			this.data._arrListEntries[this.data.VIDEO_SCREEN] = {
				intIndex: this.data.VIDEO_SCREEN,
				strPrimaryContent: _("Video", "ICTouchAPI")
			};
			needReload = true;
		} else if((!this.data.isWebcamAvailable || !this.data.isLocalVideoEnabled) &&
			this.data._arrListEntries[this.data.VIDEO_SCREEN]){
			this.data._arrListEntries[this.data.VIDEO_SCREEN] = null;
			needReload = true;
		}
		if (this.data.mainWidget && needReload) {
				this.data.mainWidget.reload();
		}
	},

	onLocalVideoEnabledChanged : function(capability, value) {
		ICTouchAPI.debugServices.debug("webapp.userservices / onLocalVideoEnabledChanged capability="+capability+" value="+value);
		if (value == ICTouchAPI.CapabilityServices.AVAILABLE) {
			this.data.isLocalVideoEnabled = true;
		} else {
			this.data.isLocalVideoEnabled = false;
		}
		this.updateVideoEntry();
		capability=null;
		value=null;
	},

	onConnectivityChanged : function() {
		var args = ICTouchAPI.tools.getEventArguments(arguments);
		var item = args.item;
		var status = args.status;
		ICTouchAPI.debugServices.debug("webapp.userservices.controlBase / onConnectivityChanged item="+item+" status="+status);
		
		if(item==="camera" && (status==="ok" || status==="ko")){
			if(status==="ko"){
				this.data.isWebcamAvailable = false;
			} else if(status==="ok") {
				this.data.isWebcamAvailable = true;
			}
			this.updateVideoEntry();
		} else if(item == "supervision"){
			var statusIcon;

			// if supervision is activated, set the status icon to on, otherwise to off
			if(status == "on"){
				statusIcon = this.data.STATUS_ON_ICON;
			} else {
				statusIcon = this.data.STATUS_OFF_ICON;
			}

			// update the button
			var appBar = ICTouchAPI.AppBarServices.getAppBar("userservices","userservicesstatus"+this.data.USER_INFO_SCREEN);
			var supervisionButton = appBar.getButton(this.data.SUPERVISION);
			if(supervisionButton){
				supervisionButton.setStatusIcon(statusIcon);
			}
		} else if(item == "hideIdentity"){
			var hideIdentityStatus;
			
			// if hide identity is activated, set the status icon to on, otherwise to off
			if(status == "on"){
				hideIdentityStatus = true;
			} else {
				hideIdentityStatus = false;
			}
			
			// Update state
			this.data.setHideIdentityState(hideIdentityStatus);
			
			// update the button
			this.data.setHideUserIdentityButtonStatus(hideIdentityStatus);
			
			if(this.data.isUserInfoDisplayed()){
				this.data.loadUserInfoDetails();
			}
		}
	},

	onNumberChanged : function(objNumberSetting){
		if(objNumberSetting && objNumberSetting.id){
			if(objNumberSetting.id=="TelephonyAttendantNumber"){
				if (objNumberSetting.jsValue) {
					this.data.setTelephonyAttendantNumber(objNumberSetting.jsValue);
				}
			}else if(objNumberSetting.id=="TelephonyAssociateNumber"){
				if (objNumberSetting.jsValue) {
					this.data.setTelephonyAssociateNumber(objNumberSetting.jsValue);
				}
			}else if(objNumberSetting.id=="TelephonyMobileNumber"){
				if (objNumberSetting.jsValue) {
					this.data.setTelephonyMobileNumber(objNumberSetting.jsValue);
				}
			}else if(objNumberSetting.id=="TelephonyVmNumber"){
				if (objNumberSetting.jsValue) {
					this.data.setTelephonyVmNumber(objNumberSetting.jsValue);
				}
			}else if(objNumberSetting.id=="LatestNumbersCache"){
				if (objNumberSetting.jsValue) {
					this.data.setArrLatestNumbers(objNumberSetting.jsValue);
				}
			}else{
				//TODO : Default case : BNe devrait pas arriver : Erreur
			}
		}
		objNumberSetting = null;
	},

	onOutOfTheOfficeStatusChanged : function(status){
		if(this.data._arrListEntries[this.data.PRESENCE_IM_SCREEN]!=null){
		if (status.value && (status.value === true || status.value === "true" || status.value === 1)) {
			ICTouchAPI.ledServices.activate('userInfo', 'OUTOFOFFICE');
		}else{
			ICTouchAPI.ledServices.desactivate('userInfo', 'OUTOFOFFICE');
		}
		}else{
			ICTouchAPI.debugServices.error("webapp.userservices.controlBase - onOutOfTheOfficeStatusChanged - Out of office event received without user presence enabled");
		}
		status = null;
	},

	onIMAvailabilityChanged : function(imEnabled){
		this.data.setIMAvailability(imEnabled)
		if(this.data.getIMAvailability() && webapp.userinfo.boolIMAvailable){
			this.data._arrListEntries[this.data.PRESENCE_IM_SCREEN] = {
				intIndex: this.data.PRESENCE_IM_SCREEN,
				strPrimaryContent: _("Presence", "webapp.userservices")
			};
		}
		else{
			this.data._arrListEntries[this.data.PRESENCE_IM_SCREEN]=null;
		}
		//Refresh the container to reload the menu
		if (this.data.mainWidget) {
            this.data.mainWidget.reload();
		}
		imEnabled = null;

	},

	onUserServicesShow : function (strScreenName) {
	    if (strScreenName === "webapp.userservices.getUserService") {
			if (this.data.intSelectListItem === this.data.VIDEO_SCREEN) {
				this.data.mainWidget.reloadContainer();
			}
	    }
	},

	onDndRequiresPasswordChanged : function(objSetting) {
		if(objSetting){
			this.data.boolDndRequiresPassword = objSetting.jsValue;
		}
		objSetting = null;
	},

	/**
	 * Update the Dnd button status
	 */
	onDndChanged : function(objSetting) {
		if(objSetting){
			this.data.setDndButtonStatus(objSetting.jsValue);
			if (objSetting.jsValue) {
				ICTouchAPI.ledServices.activate('userInfo', 'DND-ON');
			}else{
				ICTouchAPI.ledServices.desactivate('userInfo', 'DND-ON');
			}
		}
		objSetting = null;
	},

	/**
	 * Update the led status
	 */
	onRoutingLedChanged : function(objSetting) {
		if(objSetting){
			this.data.boolRoutingLedActivated = objSetting.jsValue;
			if(objSetting.jsValue) {
				ICTouchAPI.ledServices.desactivate('userInfo', 'FORCE-OFF');
			} else {
				ICTouchAPI.ledServices.activate('userInfo', 'FORCE-OFF');
			}
		}
		objSetting = null;
	},

	/**
	 * Update the direct custom forward
	 */
	onAllowDirectCustomForwardChanged : function(objSetting) {
		if(objSetting){
			this.data.setAllowDirectCustomForward(objSetting.jsValue);
		}
		objSetting = null;
		if ((this.data.getContainerPath() === "webapp.userservices.getRoutingContent" || this.data.getContainerPath() === "webapp.userservices.getOverflowContent") && this.data.mainWidget) {
			this.data.mainWidget.reloadContainer();
		}
	},
	
	/**
	 * Show/hide the button "hide identity"
	 */
	onAllowHideIdentityByUser : function(objSetting) {
		ICTouchAPI.debugServices.info("webapp.userservices.controlBase / entering onAllowHideIdentityByUser");

		if(objSetting){
			ICTouchAPI.debugServices.debug("webapp.userservices.controlBase / onAllowHideIdentityByUser, new value is : " + objSetting.jsValue);
			// update the button
			var appBarHI = ICTouchAPI.AppBarServices.getAppBar("userservices","userservicesstatus"+this.data.USER_INFO_SCREEN);
			var HIButton = appBarHI.getButton(this.data.HIDE_IDENTITY);
			if(HIButton){
				if(objSetting.jsValue){
					HIButton.show();
				} else {
					HIButton.hide();
				}
			}
		}
		objSetting = null;
	},
	
	onHideIdentityBarringRuleChanged : function(objTHIBRSetting) {
		ICTouchAPI.debugServices.info("webapp.userservices.controlBase / entering onHideIdentityBarringRuleChanged");
		
		if(objTHIBRSetting){
			ICTouchAPI.debugServices.debug("webapp.userservices.controlBase / onHideIdentityBarringRuleChanged, new value is : " + objTHIBRSetting.value);
			this.data.setHideIdentityBarringRuleAllowedValues(objTHIBRSetting.allowedValues);
			this.data.setHideIdentityBarringRule(objTHIBRSetting.value);
		}
	},

	initDnd : function(boolDndStatus) {
		var appBar = ICTouchAPI.AppBarServices.getAppBar("userservices","userservicesstatus"+this.data.USER_INFO_SCREEN);
		this.data.setDndButtonStatus(boolDndStatus, appBar);
		this.data.dndButtonStatus = boolDndStatus;
		boolDndStatus = null;
	},

	/**
	 *	Set a bool to know if a vmNumber is set.
	 *	Reload the routing list if it is the current widget
	 *	@params {Object} objSetting : the complete 'TelephonyVmNumber' setting object
	 */
	onVmNumberChanged : function(objSetting) {
		var boolVmNumber;
		if (objSetting && objSetting.jsValue !== '') {
			boolVmNumber = true;
		} else {
			boolVmNumber = false;
		}
		if (boolVmNumber !== this.data.boolVmNumber) {
			//this.data.reloadRoutingDetailsWithOrWithoutVm(boolVmNumber);
			if ((this.data.getContainerPath() === "webapp.userservices.getRoutingContent" || this.data.getContainerPath() === "webapp.userservices.getOverflowContent") && this.data.mainWidget) {
				this.data.mainWidget.reloadContainer();
			}
			if(!this.data.getMultiDeviceRoutingAvailability()){
				if (!boolVmNumber && this.data.currentRoutingID == -2){
					this.onClickRouting(0);
				}
			}
		}
		this.data.boolVmNumber = boolVmNumber;
		objSetting = null;
	},

	/**
	 *	Callback of event BasicRoutingFailedEvent.
	 *	Routing set failed but is still selected in the selectList
	 *	So, reload the routing list if it is the current widget
	 */
	onForwardFailed : function() {
		if(this.data.getContainerPath() === "webapp.userservices.getRoutingContent" && this.data.mainWidget) {
			this.data.mainWidget.reloadContainer();
		}
		// 'unselect' the current routing ID
		this.data.currentRoutingID = null;
	},

	// When the setting TelephonySimplifiedForward change, store it
	onSimplifiedForwardChanged : function(objSetting) {
		if(objSetting && (objSetting.jsValue === true || objSetting.jsValue === false)) {
			this.data.boolSimplifiedForwardMode = objSetting.jsValue;
			this.data.changeMode(this.data.NORMAL_MODE);
			if (this.data.getContainerPath() === "webapp.userservices.getRoutingContent") {
				this.data.loadRoutingDetails();
			}
			this.data.updateAppButtons();
		}
		objSetting = null;
	},

	onForbidAccess:function(){
		this.data.setRightToUserServices(false);
	},

    // CallBack for the physical Key Event User
   eventPhysicalKeyUser : function(objEvent) {
	   // Value may be 0 or 1, 1 for press and 0 for release. Do action only on press.
		if(objEvent && objEvent.value !== 0){
			// show webapp userServices
			if (this.data.getRightToUserServices()){
				if((!webapp.lock|| !webapp.lock.isLocked())){
					ICTouchAPI.transitionServices.getScreen({name: "webapp.userservices.getUserService", params: {}});
					if(this.data.getMultiDeviceRoutingAvailability() && !this.data.isGetRoutingProfilesMade()){
						ICTouchAPI.APIServices.Telephony.getRoutingProfiles({context: this});
						this.data.setGetRoutingProfilesMade(true);
					}
				}
			}else{
				this.launchDndActivation();
			}
		}
		objEvent = null;
	},

	eventDeactivateForwardEvent : function() {
		if(this.data && this.data.yesCallback) {
			this.data.yesCallback();
		}
	},	
	
	// CallBack for the physical Key Event Home
   eventPhysicalKeyHome : function(objEvent) {
	   // Value may be 0 or 1, 1 for press and 0 for release. Do action only on press.
		if(objEvent && objEvent.value !== 0){
			//if(ICTouchAPI.transitionServices.getCurrentScreenName().indexOf("webapp.userservices") != -1){
				if(webapp.communication && webapp.communication.data) {
					webapp.communication.setSelectStatus(-1);
					webapp.communication.updateAppBar();
				}
			//}
		}
		objEvent = null;
	},

	// Public method that update settings : "RoutingIcon", "RoutingLabel" and "ActiveRouting".
	// The object must have the form : { strTrigger:, strDest:, strNumber:, boolOther:}
	setActiveRouting : function(objRouting) {
		//var label = webapp.userservices.data.formatRoutingLabel(objRouting.strTrigger, objRouting.strDest, objRouting.strNumber, objRouting.boolOther);
		var label = ICTouchAPI.tools.formatRoutingLabel(objRouting.strTrigger, objRouting.strDest, objRouting.strNumber, objRouting.boolOther);
		if (!ICTouchAPI.i18nServices.areI18nStringsEquals(label,this.data.currentRoutingLabel)) {

			if(webapp.progkeys) {
				webapp.progkeys.updateRoutingProgKeysDisplay("FWD_UNCONDITIONAL;Other;"+objRouting.strNumber+";true;FWD_UNCONDITIONAL;"+objRouting.strNumber);
			}

			if (objRouting.boolOther) {
				ICTouchAPI.APIServices.Telephony.activateForward({params: [objRouting.strTrigger + ";" + objRouting.strNumber], context: this});
			}
			else {
				ICTouchAPI.APIServices.Telephony.activateForwardDest({params: [objRouting.strTrigger + ";" + objRouting.strDest], context: this});
			}
		}else{
			////webapp.userservices.data.currentRoutingLabel="";
			this.onClickRouting(0);
		}
		objRouting = null;
	},


	// Copie of setActiveRouting, for the onClickRouting callback, because setActiveRouting is also used by other functions :
	//Public method that update settings : "RoutingIcon", "RoutingLabel" and "ActiveRouting".
	// The object must have the form : { strTrigger:, strDest:, strNumber:, boolOther:}
	setActiveRoutingOnClickRouting : function(objRouting) {
		//var label = webapp.userservices.data.formatRoutingLabel(objRouting.strTrigger, objRouting.strDest, objRouting.strNumber, objRouting.boolOther);
		var label = ICTouchAPI.tools.formatRoutingLabel(objRouting.strTrigger, objRouting.strDest, objRouting.strNumber, objRouting.boolOther);
		if (label !== this.data.currentRoutingLabel) {
			if (objRouting.boolOther) {
				ICTouchAPI.APIServices.Telephony.activateForward({params: [objRouting.strTrigger + ";" + objRouting.strNumber], context: this});
			}
			else {
				ICTouchAPI.APIServices.Telephony.activateForwardDest({params: [objRouting.strTrigger + ";" + objRouting.strDest], context: this});
			}
		}
		objRouting = null;
	},

	/**
	 * Routing is activated, updateLedStatus
	 **/
	onActiveRoutingChanged : function(objSetting) {
		if(!this.data.getMultiDeviceRoutingAvailability()){
			var strRouting = objSetting.value;
			var arrRouting = strRouting.split(":");
			if (arrRouting.length < 1) {
				return;
			}
			var strTrigger = arrRouting[0];

			this.data.currentRoutingLabel = ICTouchAPI.tools.formatRoutingLabel(arrRouting[0], arrRouting[1], arrRouting[2], (arrRouting[2]?true:false));
			// Set off or ON the led

			var modeTmp = null;
			if (strTrigger === "None" || strTrigger === "") {
				//modeTmp = 'BACK_OWNER';
				ICTouchAPI.ledServices.desactivate('userInfo', 'ROUTING');
			}else {
				//modeTmp = 'ROUTING';
				ICTouchAPI.ledServices.activate('userInfo', 'ROUTING');
			}


			// Select the Active routing in the routing list
			var arrRoutingData = this.data.getRoutingData();
			var boolRoutingMatched = false;
			for(var i in arrRoutingData){
				if (arrRouting[0] === arrRoutingData[i].strTrigger && (!arrRouting[1] || (arrRouting[1] === arrRoutingData[i].strDest && (arrRouting[2] === arrRoutingData[i].strNumber || !arrRouting[2])))){
					if (this.data.currentRoutingID !== arrRoutingData[i].intIndex){
						//If current routing isn't the active routing (external activation), set it
						this.data.currentRoutingID = arrRoutingData[i].intIndex;
						if (this.data.getContainerPath() === "webapp.userservices.getRoutingContent" && this.data.mainWidget) {
							this.data._loadedActiveRouting(strRouting);
						}
					}
					boolRoutingMatched = true;
					break;
				}
			}
			if (!boolRoutingMatched) {
				// No routing rule matched and the current routing has changed (case of external setting)
				this.data._loadedActiveRouting(strRouting);
			}
			objSetting = null;
		}
	},


    callbackCustomOk :function(strContent){
        this.data.objCurrentPresenceStatus.message=strContent;
        ICTouchAPI.APIServices.InstantMessaging.setStatus({context: this, params: [this.data.objCurrentPresenceStatus.idIMStatus, this.data.objCurrentPresenceStatus.message]});
		strContent = null;
    },

	launchDndActivation : function(){
		if (ICTouchAPI.CapabilityServices.getCapability("Telephony", "allowDnd") == ICTouchAPI.CapabilityServices.AVAILABLE){
			var that = this;
			if(this.data.boolDndRequiresPassword  && !this.data.dndButtonStatus){
				ICTouchAPI.keyboardServices.deployKeyboard(ICTouchAPI.KeyboardTypes.PASSWORD, null, {funcCallbackOk: function(strPassword) {that.setDND(strPassword);}});
			} else {
				this.openDNDConfirmPopup();
			}
		}
	},

	// Open the delete popup with type choice
	openDNDConfirmPopup : function() {
		// Avoid multiple entrance in this function while the popup is not properly closed.
		if(!this.bPopupDND) {
			this.bPopupDND = true;
			// Save context
			var context = this;
			
			var strTitle = "";
			if(this.data.dndButtonStatus) {
				strTitle = _("Unset do not disturb mode?", "webapp.userservices");
			} else {
				strTitle = _("Set do not disturb mode?", "webapp.userservices");
			}

			// Create the popup data
			var popupDND = {
				strTitle: _("Do not disturb", 'webapp.userservices'),
				strContent : strTitle,
				strType: "warning",
				boolMultiselect: true,
				arrPopupButtons: [ {
						strButtonName: "YES_BTN",
						strButtonLabel:  _("Yes", 'ICTouchAPI'),
						strButtonIcon: "generic-ok",
						callback : {
							func: function() {
								context.setDND("");
								context.closeDNDPopup();
							},
							context: context
						}
					}, {
						strButtonName: "NO_BTN",
						strButtonLabel:  _("No", 'ICTouchAPI'),
						strButtonIcon: "generic-cancel",
						callback : function(){
							context.closeDNDPopup();
						}
					}
				]
			};

			// Show the popup
			this.data.objPopupConfirmDND = ICTouchAPI.popupServices.addNewPopup(popupDND, "MEDIUM");
			
			this.data.hPopupConfirmDND = setTimeout(function() {
				context.closeDNDPopup();
			}, 30000);
		}
	},
	
	closeDNDPopup : function() {
		if(this.data.objPopupConfirmDND){
			ICTouchAPI.popupServices.removePopupByID(this.data.objPopupConfirmDND);
			this.data.objPopupConfirmDND = null;
		}
		if(this.data.hPopupConfirmDND){
			clearTimeout(this.data.hPopupConfirmDND);
			this.data.hPopupConfirmDND = null;
		}
		this.bPopupDND = false;
	},

	// Set a new value for the DND with a password (if required)
	setDND : function(password) {
		// According th the status of the DND to set, activate or deactivate it
		if(!this.data.dndButtonStatus) {
			ICTouchAPI.APIServices.Telephony.activateDnd({params: [password], context:this});
		} else {
			ICTouchAPI.APIServices.Telephony.deactivateDnd({context:this});
		}
		password = null;
	},

	changeDndSetting: function() {
		ICTouchAPI.settingServices.getSettingValue("DoNotDisturb", this, this._gotDndSetting);
	},

	_gotDndSetting: function(value) {
		ICTouchAPI.settingServices.setSettingValue("DoNotDisturb", !value);
		value = null;
	},

	onListClick : function(listId)
	{
		this.data.changeMode(this.data.NORMAL_MODE);
		switch (listId)
		{
			case this.data.PRESENCE_IM_SCREEN:
				this.data.intSelectListItem = this.data.PRESENCE_IM_SCREEN;
				this.data.loadPresenceDetails();
				//this.handlePresence();
				break;
			case this.data.ROUTING_SCREEN:
				this.data.intSelectListItem = this.data.ROUTING_SCREEN;
				this.data.loadRoutingDetails();
				break;
			case this.data.OVERFLOW_SCREEN:
				this.data.intSelectListItem = this.data.OVERFLOW_SCREEN;
				this.data.loadOverflowDetails();
				break;
			case this.data.USER_INFO_SCREEN:
				this.data.intSelectListItem = this.data.USER_INFO_SCREEN;
				this.data.loadUserInfoDetails();
				break;
			case this.data.VIDEO_SCREEN:
				this.data.intSelectListItem = this.data.VIDEO_SCREEN;
				this.data.loadVideoDetails();
				break;
		}
		listId = null;
	},

	onClickRouting : function(id, isSelected, progkey) {
		var routingData = this.data.getRoutingData();
		var selectedIndex = 0;
		for(var i in routingData) {
			if (routingData[i].intIndex === id) {
				selectedIndex = i;
			}
		}
		if(this.data.currentMode === this.data.DELETE_MODE && progkey!==true) {
			this.data.deletePopup(selectedIndex);
		} else if(this.data.currentMode === this.data.MODIFY_MODE && progkey!==true) {
			var dest = routingData[selectedIndex].strDest;
			var type = routingData[selectedIndex].strTrigger;
			if(routingData[selectedIndex].boolOther) {
				dest = dest + ":" + routingData[selectedIndex].strNumber;
			}
			this.data.currentRouting = {routingType: type,routingDestination: dest, id: selectedIndex};
			this.data.loadRoutingTypeDetails();
		} else {
			if(id!==this.data.currentRoutingID)
			{
				switch(id)
				{
					case 0:
						// No routing => deactivate (id 0 is "none")
						ICTouchAPI.APIServices.Telephony.deactivateForward({context: this});
						if(webapp.progkeys) {
							webapp.progkeys.desactivateProgKeys();
						}
						break;
					case -1:
						// Custom routing ( id -1 )
						this.data.onOtherSearch();
						break;
					case -2:
						// Case Immediate Forward to VOICEMAIL on Simplified forward mode.
						var objRouting = {strTrigger:this.data.FWD_UNCONDITIONAL, strDest:this.data.DST_VOICEMAIL};
						this.setActiveRoutingOnClickRouting(objRouting);
						if(webapp.progkeys) {
							webapp.progkeys.updateRoutingProgKeysDisplay(id);
						}
						break;
					default:
						this.setActiveRoutingOnClickRouting(routingData[selectedIndex]);
						if(webapp.progkeys) {
							webapp.progkeys.updateRoutingProgKeysDisplay(id);
						}
						break;
				}
			}else{
				if(id == -1) {
					this.data.onOtherSearch();
				}
			}
		}
		id = null;
		isSelected = null;
		progkey = null;
	},

	onClickOverflow : function(id) {
		var overflowData = this.data.getOverflowData();
		var selectedIndex = 0;
		for(var i in overflowData) {
			if (overflowData[i].intIndex === id) {
				selectedIndex = i;
				this.data.setCurrentOverflow(overflowData[i]);
			}
		}
		if(id == 0){//None case
			ICTouchAPI.APIServices.Telephony.cancelRoutingOverflow({context: this});
		}else if(id == -11){//Custom overflow case OVF_ON_NO_REPLY
			if(this.data.otherOverflowNumberNoReply!=null){
				var overflowDestination = {
					overflowType : this.data.OVF_ON_NO_REPLY,
					targetType : this.data.OVF_DESTINATION_NUMBER,
					phoneNumber : this.data.otherOverflowNumberNoReply,
					isSelected : true,
					userInformation : null
				};
				ICTouchAPI.APIServices.Telephony.setRoutingOverflow({params: [overflowDestination,true], context: this});
			}else if(this.data.otherOverflowUserNoReply!=null){
				var overflowDestination = {
					overflowType : this.data.OVF_ON_NO_REPLY,
					targetType : this.data.OVF_DESTINATION_NUMBER,
					phoneNumber : this.data.otherOverflowUserNoReply.phoneNumber,
					isSelected : true,
					userInformation : null
				};
				ICTouchAPI.APIServices.Telephony.setRoutingOverflow({params: [overflowDestination,true], context: this});
			}else{
				this.data.currentOverflowType = "OVF_ON_NO_REPLY";
				this.data.onOtherSearch();
			}
		}else if(id == -12){//Custom overflow case OVF_ON_BUSY_OR_NO_REPLY
			if(this.data.otherOverflowNumber!=null){
				var overflowDestination = {
					overflowType : this.data.OVF_ON_BUSY_OR_NO_REPLY,
					targetType : this.data.OVF_DESTINATION_NUMBER,
					phoneNumber : this.data.otherOverflowNumber,
					isSelected : true,
					userInformation : null
				};
				ICTouchAPI.APIServices.Telephony.setRoutingOverflow({params: [overflowDestination,true], context: this});
			}else if(this.data.otherOverflowUser!=null){
				var overflowDestination = {
					overflowType : this.data.OVF_ON_BUSY_OR_NO_REPLY,
					targetType : this.data.OVF_DESTINATION_NUMBER,
					phoneNumber : this.data.otherOverflowUser.phoneNumber,
					isSelected : true,
					userInformation : null
				};
				ICTouchAPI.APIServices.Telephony.setRoutingOverflow({params: [overflowDestination,true], context: this});
			}else{
				this.data.currentOverflowType = "OVF_ON_BUSY_OR_NO_REPLY";
				this.data.onOtherSearch();
			}
		}else if(id == -2){//Voicemail overflow
			var overflowDestination = {
				overflowType : this.data.OVF_ON_BUSY_OR_NO_REPLY,
				targetType : this.data.OVF_DESTINATION_VOICEMAIL,
				phoneNumber : null,
				isSelected : true,
				userInformation : null
			};
			ICTouchAPI.APIServices.Telephony.setRoutingOverflow({
				params:[overflowDestination,false],
				context: this
			});
		}else if(id == -4){//Voicemail overflow
			var overflowDestination = {
				overflowType : this.data.OVF_ON_NO_REPLY,
				targetType : this.data.OVF_DESTINATION_VOICEMAIL,
				phoneNumber : null,
				isSelected : true,
				userInformation : null
			};
			ICTouchAPI.APIServices.Telephony.setRoutingOverflow({
				params:[overflowDestination,false],
				context: this
			});
		}else{
			this.setActiveOverflow(overflowData[selectedIndex]);
		}

		//}
		//this.data.currentOverflow = overflowData[selectedIndex];
		id = null;
	},

	setActiveOverflow : function(overflowRoute){
		ICTouchAPI.APIServices.Telephony.setRoutingOverflow({
				params:[overflowRoute,true],
				context: this
			});
		overflowRoute = null;
	},

	onClickRoutingType : function(id) {
		this.data.currentRouting.routingType = this.data.getRoutingTypeData()[id].label;
		id = null;
	},

	onClickRoutingDestination : function(id) {
		var arrRoutingDestination = this.data.getRoutingDestinationData();
		if (id === arrRoutingDestination.length - 1) {
			this.data.onOtherSearch();
		} else {
			this.data.currentRouting.routingDestination = this.data.getRoutingDestinationData()[id].label;
		}
		id = null;
	},

	onClickPresence : function(id) {
		if (this.data.intSelectListItem === this.data.PRESENCE_IM_SCREEN) {
			this.data.objCurrentPresenceStatus.idIMStatus = id;
			ICTouchAPI.APIServices.InstantMessaging.setStatus({context: this, params: [this.data.objCurrentPresenceStatus.idIMStatus, this.data.objCurrentPresenceStatus.message]});
		}
		id = null;
	},

	handlePresence: function() {
		var objPresence;
		if (webapp.userinfo){
			objPresence = webapp.userinfo.data.getUserInfo().objPresence;
		}
		if (objPresence && objPresence.imPresenceValue && objPresence.personnalizedMessage) {
			this.data.objCurrentPresenceStatus.idIMStatus = objPresence.imPresenceValue.value.idStatus;
			this.data.objCurrentPresenceStatus.message = objPresence.personnalizedMessage;
			if (this.data.mainWidget && this.data.getContainerPath() === "webapp.userservices.getPresenceContent") {
				var objContent = this.data.mainWidget.container.getContent();
				if (this.data.objCurrentPresenceStatus) {
					if (this.data.intSelectListItem === this.data.PRESENCE_IM_SCREEN && objPresence.imPresenceValue.value.idStatus > 0) {
						objContent.selectAtIndex(objPresence.imPresenceValue.value.idStatus - 1);
					}
				}
			}
		}
	},

	onClickUserInfo : function(objSetting) {
		var func = dojo.hitch(this, this.saveSetting, objSetting.id);
		ICTouchAPI.keyboardServices.deployKeyboard(ICTouchAPI.KeyboardTypes.ALPHANUM, null, {funcCallbackOk: func, strDefaultText: objSetting.value});
		objSetting = null;
	},

	saveSetting : function(settingId, strKeyboardText) {
		ICTouchAPI.settingServices.setSettingValue(settingId, strKeyboardText, this, this.savedSetting);
		settingId = null;
		strKeyboardText = null;
	},

	savedSetting : function() {
		this.data.loadUserInfoDetails();
	},

	doCustomRouting : function(num)	{
		var str = dojox.string.sprintf(this.data.IMMEDIATE_CUSTOM, num);
		// Execute routing
		ICTouchAPI.APIServices.Telephony.activateForward({params:[str], context:this});
		this.buttonCallback(this.data.BACK);
		num = null;
	},

	/**
	 * onProgKeyConfig
	 * for Add/Edit progkey Arguments Testing.
	 */
	onProgKeyConfig : function(objAction, domNode, parentWidget){
		var appBar = ICTouchAPI.AppBarServices.getAppBar("progkeys", "getProgKeyAdd");
		this.data._nextPKButton = appBar.getButton("NEXT_BTN");
		this.data._nextPKButton.hide();
		if (objAction.action === "routing") {
			var that = this;
			var container = new UIElements.ApplicationMode.FullControl({
				content : {
					name    :	"UIElements.Container.ContainerControl",
					params  : {
						objTitle: {
							strLabel : webapp.userservices.data.getUserServiceListTitle()
						},
						objContent: {
							name : "webapp.userservices.getRoutingList",
							params : {
								itemCallback : function(intIndex) {that._progKeySetArgs(intIndex, "")},
								objAction : objAction,
								parentWidget : parentWidget
				}
			}
					}
				}
			}, domNode);

			objAction.arguments = (typeof objAction.arguments == "string") ? dojo.fromJson(objAction.arguments) : objAction.arguments;
			this.data.PKWidget = container.getContent().getContent();
			this.data.PKWidget.selectRouting(objAction.arguments);
			if(objAction.arguments && objAction.arguments.routingId) {
				this.data.PKWidget.selectRouting(objAction.arguments.routingId);
			}
			return this.onProgKeyConfigReturn(container);
		}
		else {
			return null;
		}
		objAction = null;
		domNode = null;
		parentWidget = null;
	},

	onProgKeyConfigReturn : function(container) {
		return {
			list : container,
			domNode : container.domNode,
			validate : function() {
				return webapp.userservices.data.intPKArgs;
			},
			destroy : function() {
				container.getContent().destroy();
				container.destroy();
			}
		}
		container= null;
	},

	_progKeySetArgs : function(routingID, number) {
		if (routingID) {
			if (routingID !== -1) {
				this.data._nextPKButton.show();
				var arguments				= {};
				arguments.strContent		= "";
				arguments.routingId			= routingID;
				arguments.strNotifStatus	= "notif-off";
				this.data.intPKArgs	= arguments;
				webapp.progkeys.setProgkeysArgumentsNextStep(arguments);
			} else {
				webapp.communication.onProgkeyConfigRouting();
				// get and save the callId
				var selected = webapp.communication.data.getSelectedEntry();
				webapp.communication.data._objFirstSelected = selected;

				var funcExit = {
					context: this,
					func: this.cancelPKImmediateRouting
				}

				var objSearch = {
					searchType				: webapp.communication.getKeyPadActionFromSelectStatus(),
					contactDataTypes : ["Phone"],
					secondaryInformation	: "phoneNumber", // information of the contact to be displayed at the right of the contact's display name in the search results
					useDefaultCallMethod	: true,
					showVoicemailButton		: false,
					showAddcontactButton	: false,
					dialpadObject			: {
						funcCallbackOk		:  function() {
							var callback = objSearch.lineClickCallback;
							callback.func.apply(callback.context, [null, {
							strContent: this.getValue()
							}]);
						},
						funcCallbackExit	: funcExit,
						strDefaultText		: (Number) ? Number : "",
						strOkLabel			: _("Add call to favorite", "webapp.progkeys"),
						strOkIcon			: "progkeys-add",
						numPadLengthLimit	: 40
					}
				};

				// define a right icon for the search results, for which the callback is to display the contact card
				objSearch.rightIconClickCallback = {
					neededData : "Contact",
					rightIconImage  : "contacts-card-32",
					rightIconImageRemoteContact : "contacts-contact-card-remote-32",
									context: webapp.userservices,
					func: function (objContact) {
						dojo.publish("e_contact_showContact",[{
							objContact: objContact,
								clbkBack: function() {
								ICTouchAPI.transitionServices.getScreen({
									name: "webapp.search.getSearch",
									params: {}
								});
							}
						}]);
						}
				};

				var byNameObject = {
					funcCallbackOk : function(){
						var callback = objSearch.lineClickCallback;
						callback.func.apply(callback.context, [null, {
						strContent: this.getValue()
						}]);
					},
					funcCallbackExit: funcExit
				}

				// define the action for the search results (click on the line of on the left icon), for which the callback is to add the contact to favorite
				objSearch.lineClickCallback = {
					neededData : "phoneNumber",
					leftIconImage  : "progkeys-add-32",
					leftIconImageConditionnalDisplay  : "phoneNumber",
					context:webapp.userservices,
					func:webapp.userservices._progKeySetNumber
				};

				// byNameObject allows to overwrite the callback of the dialpadObject if they are redefined
				objSearch.byNameObject = byNameObject;

				if(webapp.search){
					webapp.search.doSearch(objSearch, null, function() {
						webapp.progkeys.currentAddWidget.boolReset = false;
						ICTouchAPI.transitionServices.getScreen({
							name: "webapp.progkeys.getProgKeyAdd",
							params: {}
						});
					});
					// show numeric
					ICTouchAPI.keyboardServices.deployKeyboard(ICTouchAPI.KeyboardTypes.DIALPAD, null, objSearch.dialpadObject);
						}
				}
			}

		routingID	= null;
		Number		= null;
	},

	_progKeySetNumber : function(number, objEntry) {
		webapp.communication.setSelectStatus(-1);
		routingID = null;
		number = null;
		this.selectPKImmediateRouting(number);
		number = null;
		this.data._nextPKButton.show();
		num = null;
	},

	cancelPKImmediateRouting : function(param,param2) {
		this.data.intPKArgs = null;
		this.data._nextPKButton.hide();
		this.data.PKWidget.listUI.unselectAll();
		param = null;
		param2 = null;
	},

	onProgKeyDisplay : function(objAction, progkey) {
		objAction.arguments = (typeof objAction.arguments == "string") ? dojo.fromJson(objAction.arguments) : objAction.arguments;

		if(objAction.arguments.routingId == -2){
			progkey.icon = "communication-deflect-to-voice-mail";
		} else if(!isNaN(objAction.arguments.routingId)) {
			var routingData = this.data.getRoutingData();
			var selectedIndex = 0;

			for(var i in routingData) {
				if (routingData[i].intIndex === parseInt(objAction.arguments.routingId)) {
					selectedIndex = i;
					break;
				}
			}

			if(routingData[selectedIndex].strDest == this.data.DST_VOICEMAIL){
				progkey.icon = "communication-deflect-to-voice-mail";
			}
		}
		objAction = null;
		progkey = null;
	},

	/**
	 * onProgKeyAction
	 * @return : list of Template of actions
	 */
	/*onProgKeyAction : function() {
		var listActions = [];
		listActions.push({
			webAppName : "userservices",
			action : "routing",
			type : 1,
			icon : "communication-transfer-to",
			label : "Define a forward action"
		});
		return listActions;
	},*/

	onProgKeyClick : function(objAction) {
		if (objAction.action === "routing") {
			objAction.arguments = (typeof objAction.arguments == "string") ? dojo.fromJson(objAction.arguments) : objAction.arguments;

			if(!isNaN(objAction.arguments.routingId)) {
				if (objAction.arguments.routingId == this.data.currentRoutingID) {
					this.onClickRouting(0, true, true);
				}else{
					this.onClickRouting(parseInt(objAction.arguments.routingId), true, true);
				}
			}else{
				var tabArgs = objAction.arguments.routingId.split(";");
				var routing = {
					strTrigger:tabArgs[0],
					strDest:tabArgs[1],
					strNumber:tabArgs[2],
					boolOther:tabArgs[3],
					routingType:tabArgs[4],
					routingDestination:tabArgs[5]
				};
				this.setActiveRouting(routing);
			}
		}
		objAction = null;
	},

	getCurrentPresence: function() {
		return this.data.objCurrentPresenceStatus;
	},

	setImmediateActiveRouting : function(number) {
		if (number) {
			ICTouchAPI.transitionServices.getScreen({name: "webapp.userservices.getUserService", params: {}});
			var routing = {strTrigger:this.data.FWD_UNCONDITIONAL, strDest:this.data.ST_OTHER, strNumber:number, boolOther:true};
			this.data.currentRouting = {routingType: routing.strTrigger,routingDestination: routing.strDest+":"+number};
			this.setActiveRouting(routing);
		}
		number = null;
	},

	editOverflowNumber : function(index){
		if(index == -11){
			this.data.currentOverflowType = "OVF_ON_NO_REPLY";
			this.data.onOtherSearch();
		}else if(index == -12){
			this.data.currentOverflowType = "OVF_ON_BUSY_OR_NO_REPLY";
			this.data.onOtherSearch();
		}else{
			ICTouchAPI.debugServices.error("editOverflowNumber : Bad index recieved");
		}
	},

	setOverflow : function(number,doDialableNumber) {
		if (number) {
			ICTouchAPI.transitionServices.getScreen({name: "webapp.userservices.getUserService", params: {}});
			this.addNumberToCache(number);

			if(this.data.currentOverflowType == "OVF_ON_NO_REPLY"){
				this.data.otherOverflowNumberNoReply = number;
				this.data.currentOverflow.phoneNumber = number;
				var overflowDestination = {
					overflowType : this.data.OVF_ON_NO_REPLY,
					targetType : this.data.OVF_DESTINATION_NUMBER,
					phoneNumber : number,
					isSelected : true,
					userInformation : null
				};
				ICTouchAPI.APIServices.Telephony.setRoutingOverflow({params: [overflowDestination,doDialableNumber], context: this});
				var overflowData = this.data.getOverflowData();
				var selectedIndex = 0;
				for(var i in overflowData) {
					if (overflowData[i].intIndex === -11) {
						selectedIndex = i;
					}
				}
				this.data.currentOverflow = overflowData[selectedIndex];
			}else if(this.data.currentOverflowType == "OVF_ON_BUSY_OR_NO_REPLY"){
				this.data.otherOverflowNumber = number;
				this.data.currentOverflow.phoneNumber = number;
				var overflowDestination = {
					overflowType : this.data.OVF_ON_BUSY_OR_NO_REPLY,
					targetType : this.data.OVF_DESTINATION_NUMBER,
					phoneNumber : number,
					isSelected : true,
					userInformation : null
				};
				ICTouchAPI.APIServices.Telephony.setRoutingOverflow({params: [overflowDestination,doDialableNumber], context: this});
				var overflowData = this.data.getOverflowData();
				var selectedIndex = 0;
				for(var i in overflowData) {
					if (overflowData[i].intIndex === -12) {
						selectedIndex = i;
					}
				}
				this.data.currentOverflow = overflowData[selectedIndex];
			}

			/*this.data.loadOverflowDetails();*/
			/*if (this.data.getContainerPath() === "webapp.userservices.getOverflowContent" && this.data.mainWidget) {
				this.data.mainWidget.reloadContainer();
			}*/

		}
		number = null;
	},

	_setUserRouting : function(number) {
		if (number) {
			//ICTouchAPI.transitionServices.getScreen({name: "webapp.userservices.getUserService", params: {}});
			this.addNumberToCache(number);
			this.data.otherUserNumber = number;
			var forwardDestination = {
				forwardDestinationType: {
					type : "ForwardDestinationType",
					value : {
						value : this.data.FWD_DESTINATION_USER
					}
				},
				phoneNumber:number,
				isSelected:true,
				userInformation:null
			}
			ICTouchAPI.APIServices.Telephony.setRoutingForward({params: [forwardDestination], context: this})
		}
	},

	setDestinationRouting : function(number) {
		var arrDest = this.data.getRoutingDestinationData();
		arrDest[arrDest.length-1].strLabel = number;
		for(var i in arrDest) {
			arrDest[i].boolSelected = false;
		}
		arrDest[arrDest.length-1].boolSelected = true;
		this.data.currentRouting.routingDestination = "Other:"+number;
		ICTouchAPI.settingServices.getSettingValue("RoutingList", this.data, this.data.saveRoutingList);
		this.data.switchContainer("getRoutingContent",this.data.ROUTING_SCREEN, this.data.getUserServiceContainerTitle());
		ICTouchAPI.transitionServices.getScreen({name: "webapp.userservices.getUserService", params: {}});
		number = null;
	},

	multiDeviceRoutingSelectionAvailability : function(capability,value){
		if(value == ICTouchAPI.CapabilityServices.AVAILABLE){
			this.data.setMultiDeviceRoutingAvailability(true);
			this.data._arrAllDetails[this.data.ROUTING_SCREEN] = [];
			this.data._arrAllDetails[this.data.OVERFLOW_SCREEN] = [];
			this.hideEditionButton();
			ICTouchAPI.settingServices.setSettingValue("EnableOverflow", true);
			dojo.publish("ModeMultiDeviceRouting");
			if(!this.data.isGetRoutingProfilesMade() && ICTouchAPI.transitionServices.getCurrentScreenName().indexOf("userservices") != -1){
				ICTouchAPI.APIServices.Telephony.getRoutingProfiles({context: this});
				this.data.setGetRoutingProfilesMade(true);
			}
			if ((this.data.getContainerPath() === "webapp.userservices.getRoutingContent" || this.data.getContainerPath() === "webapp.userservices.getOverflowContent") && this.data.mainWidget) {
				this.data.mainWidget.reloadContainer();
			}
		}else{
			this.data.setMultiDeviceRoutingAvailability(false);
			this.data.loadRoutingDetails();
			ICTouchAPI.settingServices.setSettingValue("EnableOverflow", false);
		}
		value=null;
	},

	hideEditionButton : function(){
		for(var appbarId in this.data._arrAppBarSkeleton){
			var appBar = ICTouchAPI.AppBarServices._getAppBarWidget("userservices", "userservicesstatus" + appbarId);
			var btnAdd = appBar.getButton(this.data.ADD_ROUTING);
			var btnEdit = appBar.getButton(this.data.MODIFY_ROUTING);
			var btnDelete = appBar.getButton(this.data.DELETE_ROUTING);
			if(btnAdd){
				btnAdd.hide();
			}
			if(btnEdit){
				btnEdit.hide();
			}
			if(btnDelete){
				btnDelete.hide();
			}
		}
	},

	loadProfileDetails : function(_profileIndex){
		//FWD User case
		if(_profileIndex == -3){
			this.data.onOtherSearch();
		}else{
			var routingData = this.data.getRoutingData();
			var selectedProfile;
			for(var i in routingData) {
				if (routingData[i].intIndex == _profileIndex) {
					routingData[i].boolSelected = true;
					selectedProfile = routingData[i];
				}
			}
			var profileId = {id:selectedProfile.profileId};
			this.data.currentProfileId = selectedProfile.profileId;
			ICTouchAPI.APIServices.Telephony.getRoutingProfile({
				params:[profileId],
				context: this,
				callback: this.loadedProfileDetails
			});
		}

		_profileIndex = null;
	},

	loadedProfileDetails : function(profileDetails){
		this.data.switchContainer("getProfileDetails",this.data.PROFILE_DETAILS_SCREEN,_(["Routing profile",profileDetails.profileName], "webapp.userservices"));
		ICTouchAPI.transitionServices.getScreen({
			name: "webapp.userservices.getProfileDetails",
			params: {_profileDetails : profileDetails}
		});
		if(this.data.widgetProfileDetails){
			this.data.widgetProfileDetails.reloadList(profileDetails,false);
		}
		profileDetails = null;
	},


	displayCacheNumbersPopup : function(){
		var cacheNumber = this.data.getCacheNumbers();
		var index = 0;
		for(var i in cacheNumber){
			cacheNumber[i].intIndex = index;
			index++;
		}
		var context = this;
		// Create the popup data
		var popup = popup = {
			strTitle: _("Select one of the latest entries", "webapp.userservices"),
			strWidgetName : "UIElements.SelectList.SelectListControl",
			arrItems: cacheNumber,
			itemCallback : function(intIndex) {
				var cacheNumber = context.data.getCacheNumbers();
				context.data.latestEntrySelected = cacheNumber[intIndex];
			},
			boolMultiselect: false,
			arrPopupButtons: [ {
					strButtonName: "YES_BTN",
					strButtonLabel: _('Yes', "ICTouchAPI"),
					strButtonIcon: "generic-ok",
					callback : function(){
						ICTouchAPI.keyboardServices.getCurrentKeyboard().getInputField().setInputFieldContent(context.data.latestEntrySelected.number);
						ICTouchAPI.popupServices.removePopup(context.data.objPopup);
					}
				}, {
					strButtonName: "CANCEL_BTN",
					strButtonLabel: _('Cancel', "ICTouchAPI"),
					strButtonIcon: "generic-cancel",
					callback : function(){
						context.data.latestEntrySelected = null;
						ICTouchAPI.popupServices.removePopup(context.data.objPopup);
					}
				}
			]
		};
		// Show the popup
		this.data.objPopup = ICTouchAPI.popupServices.addNewPopup(popup, "MEDIUM");
	},

	addNumberToCache : function(number){
		var oldCache = this.data.getArrLatestNumbers();
		var newValue = "";
		var boolFind = false;
		var posFind;
		var lgt = oldCache.length;
		for (var i = 0 ; i < lgt; i++){
			if(oldCache[i]==number){
				boolFind = true;
				posFind = i;
			}
		}
		if(boolFind){
			oldCache.splice(posFind,1);
			oldCache.push(number);
		}else{
			oldCache.push(number);
		}
		if(oldCache.length > 5){
			oldCache.splice(0,oldCache.length-5);
		}
		newValue = oldCache.toString();
		ICTouchAPI.settingServices.setSettingValue("LatestNumbersCache", newValue);
		number = null;
	},

	storeSelectedDevices : function(deviceIndex){
		if(!this.data.boolCustomRoute){
			this.data.boolCustomRoute = true;
		}
		var availableDevices = this.data.getCurrentAvailableDevices();
		if(availableDevices[deviceIndex].presentationDestinationType.value.value == this.data.DEVICE_OTHER){
			if(availableDevices[deviceIndex].phoneNumber==""){
				this.data.onOtherSearch();
			}/*else{
				availableDevices[deviceIndex].phoneNumber="";
			}*/
		}
				//if(availableDevices[deviceIndex].presentationDestinationType.value.value != this.data.DEVICE_OTHER){
		if(availableDevices[deviceIndex].isSelected){
			this.data.objDetailsScreen.getContent().unselectAtIndex(deviceIndex);
		}else{
			this.data.objDetailsScreen.getContent().selectAtIndex(deviceIndex);
		}
		//}
		availableDevices[deviceIndex].isSelected = !availableDevices[deviceIndex].isSelected;
		this.data.setCurrentAvailableDevices(availableDevices);
		deviceIndex = null;
	},

	setCustomRoute : function(useOldCustom) {
		if (this.data.boolCustomRoute) {
			if (useOldCustom) {
				var availableDevices = this.data.customRoute;
			} else {
				var availableDevices = this.data.getCurrentAvailableDevices();
			}

			var arrDevices = [];
			var doDialableOtherNumber = false;
			for(var device in availableDevices){
				if(availableDevices[device].isSelected){
					if(availableDevices[device].presentationDestinationType.value.value == this.data.DEVICE_OTHER){
						doDialableOtherNumber = (availableDevices[device].doDialableOtherNumber!= undefined && availableDevices[device].doDialableOtherNumber!= null) ? availableDevices[device].doDialableOtherNumber : false;
						arrDevices.push(availableDevices[device].presentationDestinationType.value.value + "=" + availableDevices[device].phoneNumber)
					}else{
						arrDevices.push(availableDevices[device].presentationDestinationType.value.value);
					}
				}
			}
			if(arrDevices.length == 0){
				var popupData = {
					strTitle:  _("Selected devices", 'webapp.userservices'),
					strType: "info",
					strContent: _("Some fields are invalid. Modifications can't be applied.", 'webapp.userservices'),
					arrPopupButtons: [{
						strButtonName: "Ok",
						strButtonLabel:  _("Ok", 'ICTouchAPI'),
						strButtonIcon: "generic-ok",
						callback: function() {
							ICTouchAPI.popupServices.removePopup(webapp.userservices.data.objPopup);
						}
					}]
				};
				this.data.objPopup = ICTouchAPI.popupServices.addNewPopup(popupData, "MEDIUM");
			}else{
				this.data.customRoute = this.data.getCurrentAvailableDevices();
				this.data.changeMode(this.data.NORMAL_MODE);
				this.data.boolCustomRoute = false;
				ICTouchAPI.APIServices.Telephony.setRoutingRoutes({
					params: [arrDevices,doDialableOtherNumber],
					context: this,
					callback: function(){
						this.data.hRoutingDetailsReload = setTimeout(function() {webapp.userservices.data.loadRoutingDetails();}, 5000);
						ICTouchAPI.transitionServices.getScreen({name: "webapp.userservices.getUserService", params: {}});
					}
				});
			}
		}else{
			this.data.changeMode(this.data.NORMAL_MODE);
			this.data.boolCustomRoute = false;
			this.data.loadRoutingDetails();
			ICTouchAPI.transitionServices.getScreen({name: "webapp.userservices.getUserService", params: {}});
		}
	},

	_setOtherNumber : function(number,doDialableOtherNumber){
		var availableDevices = this.data.getCurrentAvailableDevices();
		if(number){
			this.data.otherRoutingNumber = number;
			this.data.otherRoutingNumberIsDialable = doDialableOtherNumber;
			this.addNumberToCache(number);
			for(var device in availableDevices){
				if(availableDevices[device].presentationDestinationType.value.value == this.data.DEVICE_OTHER){
					availableDevices[device].phoneNumber = number;
					availableDevices[device].isSelected = true;
					availableDevices[device].doDialableOtherNumber = doDialableOtherNumber;
					this.data.objDetailsScreen.getContent().selectAtIndex(device);

					//Force storeSelectedDevice
					this.data.boolCustomRoute = true;
				}
			}
			this.data.setCurrentAvailableDevices(availableDevices);
			this.data.widgetProfileDetails.reloadList(null,true);
			if(webapp.communication && webapp.communication.data) {
				webapp.communication.setSelectStatus(-1);
				webapp.communication.updateAppBar();
			}
			number = null;
		}else{
			if(!this.data.otherRoutingNumber){
				for(var device in availableDevices){
					if(availableDevices[device].presentationDestinationType.value.value == this.data.DEVICE_OTHER){
						availableDevices[device].isSelected = false;
						this.data.objDetailsScreen.getContent().unselectAtIndex(device);
					}
				}
			}
		}
	},

	routingStateChangedEvent : function(_routingState,boolByPassMutex){
		if(this.data.boolMutex != true || boolByPassMutex === true){
			this.data.boolMutex = true;
			this.manageRoutingProfile(_routingState);
			if(this.data.waitingProfiles.length >= 1){
				this.routingStateChangedEvent(this.data.waitingProfiles.shift(),true)
			}else{
				this.data.boolMutex = false;
			}
		}else{
			this.data.waitingProfiles.push(_routingState);
		}
	},

	manageRoutingProfile : function(_routingState){
		var routingState = _routingState.value;
		this.data.setRoutingProfileData(routingState);
		var label;
		var custom;
		this.data.boolForwardSet = false;
		this.data.lastIsRoutingTarget = routingState.isRoutingTarget;
		if(routingState.appliedProfile != null){
			if(routingState.appliedProfile.value.profileId.value.id!="" && routingState.appliedProfile.value.profileId.value.id!="CUSTOM"){
				this.data.setCurrentProfile(routingState.appliedProfile);
				dojo.publish("ProfileChanged",[this.data.getCurrentProfile()]);
				this.data.currentProfileLabel = this.data.getCurrentProfile();
			}else{
				custom = {
					type : "ProfileSummary",
					value : {
						profileId : {
							type : "ProfileId",
							value : {
								id : "CUSTOM"
							}
						}
					},
					profileName : "CUSTOM"
				}
				this.data.setCurrentProfile(custom);
				if(routingState.listForwardDestination != null && routingState.listForwardDestination.length!=0){
					for(var i in routingState.listForwardDestination){
						if(routingState.listForwardDestination[i].isSelected){
							this.data.boolForwardSet = true;
							if(routingState.listForwardDestination[i].forwardDestinationType.value.value == this.data.FWD_DESTINATION_VOICEMAIL){
								label = "VOICEMAIL_DEVICE";
							}else{
								var infos = "";
								if(this.data.isUserInfoNotEmpty(routingState.listForwardDestination[i])){
									infos = ICTouchAPI.tools.getContactDisplayName(routingState.listForwardDestination[i].userInformation.value);
								}
								label = ["USER_DEVICE","("+infos+")"];
							}
						}
					}
				}
				if(!this.data.boolForwardSet){
					dojo.publish("ProfileChanged",[custom]);
					this.data.currentProfileLabel = custom;
				}else{
					var fakeProfile = {
						type : "ProfileSummary",
						value : {
							profileId : {
								type : "ProfileId",
								value : {
									id : label
								}
							}
						},
						profileName : label
					};
					dojo.publish("ProfileChanged",[fakeProfile]);
					this.data.currentProfileLabel = fakeProfile;
				}
			}
		}
		if(routingState.activableProfiles != null && routingState.activableProfiles!=0){
			this.setProfilesFromSummaryList(routingState.activableProfiles);
		}
		if(routingState.isRoutingTarget){
			ICTouchAPI.ledServices.desactivate('userInfo', 'ROUTING');
		}else{
			ICTouchAPI.ledServices.activate('userInfo', 'ROUTING');
		}
		if(routingState.listOverflowDestination != null && routingState.listOverflowDestination.length!=0){
			this.data.setOverflowList(routingState.listOverflowDestination);
		}
		if(routingState.listForwardDestination != null && routingState.listForwardDestination.length!=0){
			this.data.setForwardList(routingState.listForwardDestination);
		}
		// Reload current displayed screen
		if ((this.data.getContainerPath() === "webapp.userservices.getRoutingContent" || this.data.getContainerPath() === "webapp.userservices.getOverflowContent") && this.data.mainWidget) {
			if(this.data.getContainerPath() == "webapp.userservices.getRoutingContent"){
				this.data.loadRoutingDetails();
			}else if(this.data.getContainerPath() == "webapp.userservices.getOverflowContent"){
				this.data.loadOverflowDetails();
			}
			this.data.mainWidget.reloadContainer();
		}
		routingState = null;
	},

	onClickProfile : function(index){
		var routingData = this.data.getRoutingData();
		var selectedProfile;
		for(var i in routingData) {
			if (routingData[i].intIndex === index) {
				routingData[i].boolSelected = true;
				selectedProfile = routingData[i];
			}
		}

		//if(!this.data.currentProfile || (selectedProfile.profileId!==this.data.currentProfile.profileId))
		//{
		if (selectedProfile) {
		switch(selectedProfile.intIndex)
		{
			case -2:
				// Case VOICEMAIL
				var forwardDestination = {
					forwardDestinationType: {
						type : "ForwardDestinationType",
						value : {
							value : this.data.FWD_DESTINATION_VOICEMAIL
						}
					},
					phoneNumber:null,
					isSelected:true,
					userInformation:null
				}
				ICTouchAPI.APIServices.Telephony.setRoutingForward({params: [forwardDestination], context: this})
				break;
			case -3:
				if(this.data.otherUserNumber){
					var forwardDestination = {
						forwardDestinationType: {
							type : "ForwardDestinationType",
							value : {
								value : this.data.FWD_DESTINATION_USER
							}
						},
						phoneNumber:this.data.otherUserNumber,
						isSelected:true,
						userInformation:null
					}
					ICTouchAPI.APIServices.Telephony.setRoutingForward({params: [forwardDestination], context: this})
				}else{
					this.data.onOtherSearch();
				}

				break;
			case 0:
				if(this.data.customRoute){
					this.data.boolCustomRoute = true;
					this.setCustomRoute(true);
				}else{
					// If no custom route, directly show details window to define it.
					this.loadProfileDetails(selectedProfile.intIndex);
				}
				break;
			default:
				var profileId = {id:selectedProfile.profileId}
				ICTouchAPI.APIServices.Telephony.activateRoutingProfile({params: [profileId], context: this})
				break;
		}
		}
		else {
			ICTouchAPI.debugServices.warning("webapp.userservices.controlBase - onClickProfile / could't select the specified entry as no profile was found with intIndex: " + index);
		}
		//}
		index = null;
	},

	onRequestProfile : function(){
		dojo.publish("ProfileChanged",[this.data.currentProfileLabel]);
	},

	onSelectUserDeviceRequest : function(){
		// Select the entry "User" of Routing Profile (used to enable ManagerAssistant Backup)
		this.onClickProfile(-3);
	},

	dump : function(boolAdvancedLogs) {
		this.inherited(arguments);
		ICTouchAPI.debugServices.dump("---------------------------------------------");
		ICTouchAPI.debugServices.dump("UserServices settings :");

		ICTouchAPI.debugServices.dump(" - EnableUserPresence: " + ((this.data._arrListEntries[this.data.PRESENCE_IM_SCREEN]!=null)?"true":"false"));
		ICTouchAPI.debugServices.dump(" - EnableRouting: " + ((this.data._arrListEntries[this.data.ROUTING_SCREEN]!=null)?"true":"false"));
		ICTouchAPI.debugServices.dump(" - EnableOverflow: " + ((this.data._arrListEntries[this.data.OVERFLOW_SCREEN]!=null)?"true":"false"));
		ICTouchAPI.debugServices.dump(" - EnableUserDetails: " + ((this.data._arrListEntries[this.data.USER_INFO_SCREEN]!=null)?"true":"false"));

		ICTouchAPI.debugServices.dump(" - AllowDirectCustomForward: " + (this.data.allowDirectCustomForward));
		ICTouchAPI.debugServices.dump(" - Bool VM Number: " + (this.data.boolVmNumber));
		ICTouchAPI.debugServices.dump(" - TelephonySimplifiedForward: " + ((this.data.boolSimplifiedForwardMode)?"true":"false"));
		ICTouchAPI.debugServices.dump(" - DndRequiresPassword: " + ((this.data.boolDndRequiresPassword)?"true":"false"));
		ICTouchAPI.debugServices.dump(" - TelephonyVmNumber: " + ((this.data.boolVmNumber)?"true":"false"));
		ICTouchAPI.debugServices.dump(" - EnableRoutingLed: " + ((this.data.boolRoutingLedActivated)?"true":"false"));

		ICTouchAPI.debugServices.dump(" - TelephonyAttendantNumber: " + this.data.telephonyAttendantNumber);
		ICTouchAPI.debugServices.dump(" - TelephonyAssociateNumber: " + this.data.telephonyAssociateNumber);
		ICTouchAPI.debugServices.dump(" - TelephonyMobileNumber: " + this.data.telephonyMobileNumber);
		ICTouchAPI.debugServices.dump(" - TelephonyVmNumber: " + this.data.telephonyVmNumber);
		ICTouchAPI.debugServices.dump(" - LatestNumbersCache: " + dojo.toJson(this.data.arrLatestNumbers));

		ICTouchAPI.debugServices.dump("---------------------------------------------");

		ICTouchAPI.debugServices.dump("Current Mode : " + this.data.currentMode);
		ICTouchAPI.debugServices.dump("Current Routing ID (currentRoutingID): " + this.data.currentRoutingID);
		if(this.data.currentRoutingLabel){
			if(this.data.currentRoutingLabel.isI18Ned){
				ICTouchAPI.debugServices.dump("Current Routing Label i18n (currentRoutingLabel): " + this.data.currentRoutingLabel.getTranslation());
			}else{
				ICTouchAPI.debugServices.dump("Current Routing Label (currentRoutingLabel): " + this.data.currentRoutingLabel);
			}
		}
		ICTouchAPI.debugServices.dump("Current Routing (currentRouting): " + dojo.toJson(this.data.currentRouting));
		ICTouchAPI.debugServices.dump("---------------------------------------------");
		ICTouchAPI.debugServices.dump("Current Overflow (currentOverflow): " + dojo.toJson(this.data.currentOverflow));
		ICTouchAPI.debugServices.dump("Current Profile (currentProfile): " + dojo.toJson(this.data.currentProfile));
		ICTouchAPI.debugServices.dump("Current Overflow Number (otherOverflowNumber): " + this.data.otherOverflowNumber);
		ICTouchAPI.debugServices.dump("Is Multi Device Routing Selection Activated ? : " + ((this.data.multiDeviceRoutingAvailability) ? "true" : "false"));

		if (boolAdvancedLogs) {
			ICTouchAPI.debugServices.dump("---------------------------------------------");
			ICTouchAPI.debugServices.dump("Advanced Logs");

			if(this.data._arrListEntries[this.data.PRESENCE_IM_SCREEN]!=null){
				ICTouchAPI.debugServices.dump("---------------------------------------------");
				ICTouchAPI.debugServices.dump(" - Presence Tab : ");
				var presenceData = this.data.getPresenceData();
				for(var presenceEntry in presenceData){
					ICTouchAPI.debugServices.dump("---------------------------------------------");
					ICTouchAPI.debugServices.dump(dojo.toJson(presenceData[presenceEntry]));
				}
			}
			if(this.data._arrListEntries[this.data.ROUTING_SCREEN]!=null){
				ICTouchAPI.debugServices.dump("---------------------------------------------");
				ICTouchAPI.debugServices.dump(" - Routing Tab : ");
				var routingData = this.data.getRoutingData();
				for(var routingEntry in routingData){
					ICTouchAPI.debugServices.dump("---------------------------------------------");
					ICTouchAPI.debugServices.dump(dojo.toJson(routingData[routingEntry]));
				}
			}
			if(this.data._arrListEntries[this.data.OVERFLOW_SCREEN]!=null){
				ICTouchAPI.debugServices.dump("---------------------------------------------");
				ICTouchAPI.debugServices.dump(" - Overflow Tab : ");
				var overflowData = this.data.getOverflowData();
				for(var overflowEntry in overflowData){
					ICTouchAPI.debugServices.dump("---------------------------------------------");
					ICTouchAPI.debugServices.dump(dojo.toJson(overflowData[overflowEntry]));
				}
			}
			if(this.data._arrListEntries[this.data.USER_INFO_SCREEN]!=null){
				ICTouchAPI.debugServices.dump("---------------------------------------------");
				ICTouchAPI.debugServices.dump(" - User Info Tab : ");
				var userinfoData = this.data.getUserInfoData();
				for(var infoEntry in userinfoData){
					ICTouchAPI.debugServices.dump("---------------------------------------------");
					ICTouchAPI.debugServices.dump(dojo.toJson(userinfoData[infoEntry]));
				}
			}

		}
	}
});

