dojo.require("webapp.userservices.controlBase");
dojo.provide("webapp.userservices");
dojo.declare("webapp.userservices",webapp.userservices.controlBase,{


	// Called for the common buttonCallback of VHE and MR
	buttonCallback: function(buttonId) {
		switch(buttonId)
		{
			case this.data.BACK:
				switch(this.data._strContainerPath) {
					case "webapp.userservices.getRoutingAdd2Content" :
					case "webapp.userservices.getRoutingAdd1Content" :
						this.data.changeMode(this.data.NORMAL_MODE) ;
						this.data.loadRoutingDetails();
						break;
					case "webapp.userservices.getOverflowContent" :
						this.data.changeMode(this.data.NORMAL_MODE) ;
						this.data.loadOverflowDetails();
						if(webapp.communication && webapp.communication.data) {
							webapp.communication.setSelectStatus(-1);
							webapp.communication.updateAppBar();
						}
						dojo.publish("OpenHomepage");
						break;
					case "webapp.userservices.getRoutingContent" :
						this.data.changeMode(this.data.NORMAL_MODE) ;
						this.data.loadRoutingDetails();
						if(webapp.communication && webapp.communication.data) {
							webapp.communication.setSelectStatus(-1);
							webapp.communication.updateAppBar();
						}
						dojo.publish("OpenHomepage");
						break;
					case "webapp.userservices.getProfileDetails" :
						this.setCustomRoute(false);
						break;
					default :
						if(webapp.communication && webapp.communication.data) {
							webapp.communication.setSelectStatus(-1);
							webapp.communication.updateAppBar();
						}
						dojo.publish("OpenHomepage");
						break;
				}
				break;
			case this.data.ADD_ROUTING:
				if(this.data.currentMode === this.data.DELETE_MODE || this.data.currentMode === this.data.MODIFY_MODE){
				    this.data.changeMode(this.data.NORMAL_MODE);
				}
				this.data.currentRouting = {};
				this.data.loadRoutingTypeDetails();
				break;
			case this.data.MODIFY_ROUTING:
				this.data.changeMode((this.data.currentMode === this.data.MODIFY_MODE) ? this.data.NORMAL_MODE : this.data.MODIFY_MODE);
				this.data.loadRoutingDetails();
				break;
			case this.data.DELETE_ROUTING:
				this.data.changeMode((this.data.currentMode === this.data.DELETE_MODE) ? this.data.NORMAL_MODE : this.data.DELETE_MODE);
				this.data.loadRoutingDetails();
				break;
			case this.data.NEXT:
				this.data.loadRoutingDestinationDetails();
				break;
			case this.data.SAVE:
				ICTouchAPI.settingServices.getSettingValue("RoutingList", this.data, this.data.saveRoutingList);
				break;
			case this.data.CUSTOM:
				ICTouchAPI.keyboardServices.deployKeyboard(ICTouchAPI.KeyboardTypes.ALPHANUM, null,{strDefaultText: this.data.objCurrentPresenceStatus.message, funcCallbackOk: this.callbackCustomOk});
				break;
			case this.data.DND:
				this.launchDndActivation();
				break;
			case this.data.SR_SAVE:
				ICTouchAPI.APIServices.ICTSaveRestore.save();
				break;
			case this.data.SR_RESTORE:
				ICTouchAPI.APIServices.ICTSaveRestore.restore();
				break;
			case this.data.LOGIN:
				ICTouchAPI.APIServices.IctUser.login();
				break;
			case this.data.SUPERVISION:
				ICTouchAPI.APIServices.Telephony.loginLogoffSupervision({});
				break;
			case this.data.HIDE_IDENTITY:
				// Update the button status immediately to have a quick response on the UI
				this.data.setHideUserIdentityButtonStatus(!this.data.getHideIdentityState());
				// Call core application method
				ICTouchAPI.APIServices.Telephony.modifyHideIdentity({params:[!this.data.getHideIdentityState()]});
				// Set a spinner during the CLIR activation/deactivation as it take some time.
				this.data.createClirSpinner();
				// Set a security for if call fails and we don't get an answer
				this.data.hresetButtonStatus = setTimeout(function() {webapp.userservices.data.setHideUserIdentityButtonStatus(webapp.userservices.data.getHideIdentityState());}, 5000);
				break;
			default :
				break;
		}
		buttonId = null;
	}
});

webapp.userservices = new webapp.userservices();
