dojo.provide("webapp.filesmanager.controlBase");
dojo.declare("webapp.filesmanager.controlBase",[ICTouchAPI.webApplication],{currentStatus:0,objAppBar:null,popup:null,uiFile:null,player:null,_clickHandler:null,strCategoryToOpen:"",strFileToOpen:"",uiFilters:null,uiScreensaver:null,screensaversView:"screensaverSlideshow",boolPlayed:false,constructor:function(){ICTouchAPI.skinServices.linkWebappsStyles("webapp.filesmanager","webapp.screensaver");
ICTouchAPI.skinServices.linkWebappsStyles("UIElements.Keyboard","webapp.filesmanager",true,false,true,false);
ICTouchAPI.tools.registerHomepageButton(["webapp.filesmanager.getFilesManager","FILESMANAGER_BTN","filesmanager-application",_("My files","webapp.filesmanager")]);
ICTouchAPI.tools.registerHomepageKey(["webapp.filesmanager.getFilesManager","FILESMANAGER_BTN","filesmanager-application",_("My files","webapp.filesmanager"),null,function(){ICTouchAPI.transitionServices.getScreen({name:"webapp.filesmanager.getFilesManager",params:{}})
}]);
ICTouchAPI.eventServices.subscribeToEvent(this,"MPLoading",this.notifyPlayerLoading);
ICTouchAPI.eventServices.subscribeToEvent(this,"MPStopped",this.notifyPlayerStopped);
ICTouchAPI.eventServices.subscribeToEvent(this,"MPPlaying",this.notifyPlayerPlaying);
ICTouchAPI.eventServices.subscribeToEvent(this,"MPBuffering",this.notifyPlayerBuffering);
ICTouchAPI.eventServices.subscribeToEvent(this,"MPPaused",this.notifyPlayerPaused);
ICTouchAPI.eventServices.subscribeToEvent(this,"MPError",this.notifyPlayerError);
ICTouchAPI.eventServices.subscribeToEvent(this,"MPFinished",this.notifyPlayerFinished);
ICTouchAPI.eventServices.subscribeToEvent(this,"MPState",this.notifyPlayerState);
ICTouchAPI.eventServices.subscribeToEvent(this,"FILE_LIST_CHANGED",this.notifyFileListChanged);
ICTouchAPI.eventServices.subscribeToEvent(this,"MediaSessionInfos",this.notifyMediaSessionInfosReceived)
},loaded:function(){ICTouchAPI.eventServices.subscribeToEvent(this,"TelephonyRunningEvent",this.notifyTelephonyRunningEvent);
ICTouchAPI.settingServices.subscribeToSetting(this,"UserBackgroundPicture",this.onUserBackgroundPictureChanged);
ICTouchAPI.settingServices.getSetting("UserBackgroundPicture",this,this.onUserBackgroundPictureChanged);
ICTouchAPI.settingServices.subscribeToSetting(this,"UserPhoto",this.onUserPhotoChanged);
ICTouchAPI.settingServices.getSetting("UserPhoto",this,this.onUserPhotoChanged)
},load:function(){var widgetsTab=[];
for(var i=0;
i<webapp.filesmanager.data.NB_STATUS;
i++){widgetsTab.push("filesmanagerstatus"+i)
}dojo.publish("needHelpEvent",["filesmanager",widgetsTab]);
ICTouchAPI.settingServices.subscribeToSetting(this,"FilesManagerFilter",dojo.hitch(this.data,this.data.filtersLoaded))
},onUserBackgroundPictureChanged:function(objSetting){if(objSetting){this.data.setUserBackgroundPicture(objSetting.jsValue)
}},onUserPhotoChanged:function(objSetting){if(objSetting){this.data.setUserPicture(objSetting.jsValue)
}},openCategory:function(strName){ICTouchAPI.transitionServices.getScreen({name:"webapp.filesmanager.getFilesManager",params:{}});
if(strName!=this.data.getCurrentType()){this.strCategoryToOpen=strName;
this._openCategory()
}},tryOpenCategoryOrFile:function(strCategoryName,strFileName){ICTouchAPI.transitionServices.getScreen({name:"webapp.filesmanager.getFilesManager",params:{}});
this.strCategoryToOpen=strCategoryName;
if(strFileName!=""){this.strFileToOpen=strFileName
}if(!this._clickHandler){this._clickHandler=dojo.subscribe("iframe.show",dojo.hitch(this,function(currentIframeId){if(currentIframeId=="webapp.filesmanager.getFilesManager"){this._openCategory();
this._openFile()
}}))
}},_openCategory:function(){if(!isNaN(parseInt(this.strCategoryToOpen))){this.data.objListUI.selectItemByIndex(parseInt(this.strCategoryToOpen),true)
}else{var category=webapp.filesmanager.data.getCategoryByName(this.strCategoryToOpen);
if(category!==null){this.data.objListUI.selectItemByIndex(category.intIndex,true)
}else{console.error("Error 404 : No category with this name")
}}this.strCategoryToOpen=""
},_openFile:function(){if(this.strFileToOpen!=""){ICTouchAPI.APIServices.FileManager.getFile({params:[this.strFileToOpen],context:this,callback:this.gotFileForPK});
this.strFileToOpen=""
}},onScreensaverOn:function(){if(this.uiScreensaver!=null){this.uiScreensaver.launchSlideshow()
}},onScreensaverOff:function(){if(this.uiScreensaver!=null){this.uiScreensaver.stopSlideshow()
}},buttonCallback:function(buttonId){var data=webapp.filesmanager.data;
switch(buttonId){case data.PAUSE:case data.PLAY:this.uiFile.playPause();
break;
case data.PLAY_ALL:if(!this.data.boolPlayList||this.data.intPlayStatus===this.data.STOP_STATUS){data.clearPlayNotifs();
var that=this;
var notif={strNotificationName:"play",strNotificationLabel:_("Play all","webapp.filesmanager"),intNotificationValue:1,callback:function(){that.openCategory(that.data.TYPE_AUDIO)
}};
data.addPlayNotif(notif);
data.boolPlayList=true;
data.switchContainer("",data.STATUS_LIST);
data.intCurrentPlayed=-1;
if(data.boolMediaPlayerIsPlaying){ICTouchAPI.APIServices.IctMPInterface.stopMP({params:[data.getCurrentElement().intIndex]})
}else{this.notifyPlayerFinished()
}}else{ICTouchAPI.APIServices.IctMPInterface.playPauseMP({params:[this.data.currentIdFilePlayed]})
}break;
case data.STOP_ALL:data.stopPlayList(data.STATUS_LIST);
data.switchContainer("",data.STATUS_LIST,this.data.getCurrentType());
break;
case data.STOP:data.stop();
if(data.isFileChanged){data.refreshFileList()
}else{data.switchToListView()
}break;
case data.NEXT:this.nextPlaylist();
break;
case data.SHUFFLE:data.setShuffleStatus();
break;
case data.FILTERS:this.showFilters();
break;
case data.DELETE:(data.boolDeleteMode)?data.setDeleteMode(false):data.setDeleteMode(true);
data.updateAppBar(data.STATUS_LIST);
break;
case data.SSPOOL:if(!data.boolIsInScreenSaverPool){this.addInPool(ICTouchAPI.tools.POOL_SS,data.getCurrentElement().path)
}else{this.removeFromPool(ICTouchAPI.tools.POOL_SS,data.getCurrentElement().path)
}break;
case data.SET_BACKGROUND:var strOldBackgroundPicture=data.getUserBackgroundPicture();
var strNewBackgroundPicture=data.getCurrentElement().path;
if(strOldBackgroundPicture==strNewBackgroundPicture){ICTouchAPI.settingServices.setSettingValue("UserBackgroundPicture","")
}else{ICTouchAPI.settingServices.setSettingValue("UserBackgroundPicture",strNewBackgroundPicture)
}break;
case data.SET_USER_PICTURE:var strOldPicture=data.getUserPicture();
var strNewPicture=data.getCurrentElement().path;
if(strOldPicture==strNewPicture){ICTouchAPI.settingServices.setSettingValue("UserPhoto","")
}else{ICTouchAPI.settingServices.setSettingValue("UserPhoto",strNewPicture)
}break;
case data.COPY:var currentElement=data.getCurrentElement();
if(currentElement.device!=data.DEVICE_USERSPACE){this.copyFile(currentElement.intIndex,data.DEVICE_USERSPACE,false)
}break;
case data.SELECT_ALL:data.selectAllFilters();
break;
case data.DESELECT_ALL:data.deselectAllFilters();
break;
default:console.warn("buttonCallback > No callback set for Button Id : "+buttonId);
break
}},notifyPlayerLoading:function(objEvent){},notifyPlayerStopped:function(objEvent){if(objEvent&&objEvent.value&&(objEvent.value==-100||objEvent.value==-200)){this.data.setPreviewPlaying(false);
return
}this.data.intPlayStatus=this.data.STOP_STATUS;
dojo.publish("filesmanager/MediaPlayerStopped");
this.notifyPlayerFinished(objEvent)
},notifyPlayerPlaying:function(objEvent,objEvent2){if(objEvent&&objEvent.value&&(objEvent.value==-100||objEvent.value==-200)){this.data.setPreviewPlaying(true);
return
}dojo.publish("filesmanager/MediaPlayerPlayed");
this.data.intPlayStatus=this.data.PLAY_STATUS;
var intDuration=10000;
if(objEvent2&&objEvent2.value){intDuration=objEvent2.value
}this.data.currentIdFilePlayed=objEvent.value;
var node=this.data.getElementById(objEvent.value);
if(node){node.boolSelected=true
}if(this.mainWidget){this.mainWidget.unselectAllFile();
this.mainWidget.selectFile(objEvent.value)
}if(!this.data.boolPlayList){this.data.boolMediaPlayerIsPlaying=true;
this.data.boolMPLaunching=false;
var appBar=ICTouchAPI.AppBarServices.getAppBar("filesmanager","filesmanagerstatus"+this.data.STATUS_PLAY);
appBar.getButton(this.data.PLAY).hide();
appBar.getButton(this.data.PAUSE).show();
if(this.player!=null){var max=intDuration>250?intDuration-250:1;
this.player.setMediaDuration(max);
this.player.mediaPlay()
}}else{this.data.formatAppBar(this.data.STATUS_LIST)
}},notifyPlayerBuffering:function(objEvent){},notifyPlayerPaused:function(objEvent,objEvent2){this.data.intPlayStatus=this.data.PAUSE_STATUS;
var data=webapp.filesmanager.data;
var intTime=0;
if(objEvent2&&objEvent2.value){intTime=objEvent2.value
}if(data.boolPlayList){this.data.formatAppBar(this.data.STATUS_LIST);
return
}else{var appBar=ICTouchAPI.AppBarServices.getAppBar("filesmanager","filesmanagerstatus"+this.data.STATUS_PLAY);
appBar.getButton(this.data.PLAY).show();
appBar.getButton(this.data.PAUSE).hide();
if(this.player!=null){this.player.setToTime(intTime/1000);
this.player.mediaPause()
}}},notifyPlayerError:function(objEvent,objEvent2,objEvent3){this.notifyPlayerStopped(objEvent3);
this.data.clearPlayNotifs();
ICTouchAPI.popupServices.errorPopup(_("Error","ICTouchAPI"),_("Could not load media","webapp.filesmanager"),_("Ok","ICTouchAPI"),666)
},notifyPlayerFinished:function(objEvent){if(objEvent!=null){if(objEvent.value&&(objEvent.value==-100||objEvent.value==-200)){this.data.setPreviewPlaying(false);
return
}this.data.currentIdFilePlayed=null;
var node=this.data.getElementById(objEvent.value);
if(node){node.boolSelected=false
}if(this.mainWidget){this.mainWidget.unselectAllFile();
this.mainWidget.unselectFile(objEvent.value)
}}this.data.intPlayStatus=this.data.STOP_STATUS;
if(this.data.boolPlayList){this.data.formatAppBar(this.data.STATUS_LIST);
this.data.boolMediaPlayerIsPlaying=false;
var max=this.data.getFilesManagerContainerContent().length-1;
if(this.data.boolShuffle){this.data.intCurrentPlayed=Math.round(Math.random()*max)
}else{this.data.intCurrentPlayed=(this.data.intCurrentPlayed==max)?0:this.data.intCurrentPlayed+1
}var currentSong=this.data.getFilesManagerContainerContent()[this.data.intCurrentPlayed];
this.data.currentIdFilePlayed=currentSong.intIndex;
ICTouchAPI.APIServices.IctMPInterface.playMedia({params:[currentSong.intIndex,currentSong.path]})
}else{if(this.data.boolMediaPlayerIsPlaying||this.data.boolMPLaunching){if(!this.data.boolMPLaunching){this.data.clearPlayNotifs()
}this.data.boolMPLaunching=false;
this.data.boolMediaPlayerIsPlaying=false;
var appBar=ICTouchAPI.AppBarServices.getAppBar("filesmanager","filesmanagerstatus"+this.data.STATUS_PLAY);
appBar.getButton(this.data.PLAY).show();
appBar.getButton(this.data.PAUSE).hide();
dojo.publish("filesmanager/MediaPlayerFinished")
}}},mediaSessionInfosReceived:function(args){var appBar=ICTouchAPI.AppBarServices.getAppBar("filesmanager","filesmanagerstatus"+this.data.STATUS_PLAY);
if(args.sessionState===2&&this.data.getMediaCapability()){appBar.getButton(this.data.PLAY).hide();
appBar.getButton(this.data.PAUSE).show()
}else{appBar.getButton(this.data.PLAY).show();
appBar.getButton(this.data.PAUSE).hide()
}if(this.player){var max=args.totalTime>250?args.totalTime-250:1;
this.player.setMediaDuration(max);
this.player.setToTime((args.currentIndex)/1000);
if(args.sessionState===2&&this.data.getMediaCapability()){this.player.mediaPlay()
}else{this.player.mediaPause()
}}},notifyFileListChanged:function(objEvent){var data=webapp.filesmanager.data;
data.isFileChanged=true;
if(data.getContainerPath()==data.WEBAPP_PATH+"."+data.FILE_LIST_WIDGET){for(var i in objEvent.value){if(objEvent.value[i].categoryName==data.getCurrentType()){data.refreshFileList()
}}}},notifyPlayerState:function(intDevice,boolDistant,intIndex,intState,intTotalTime,doubleVolume){var appBar=ICTouchAPI.AppBarServices.getAppBar("filesmanager","filesmanagerstatus"+this.data.STATUS_PLAY);
if(intState.value===2&&this.data.getMediaCapability()){appBar.getButton(this.data.PLAY).hide();
appBar.getButton(this.data.PAUSE).show()
}else{appBar.getButton(this.data.PLAY).show();
appBar.getButton(this.data.PAUSE).hide()
}if(this.player){var max=intTotalTime.value>250?intTotalTime.value-250:1;
this.player.setMediaDuration(max);
this.player.setToTime((intIndex.value)/1000);
if(intState.value===2&&this.data.getMediaCapability()){this.player.mediaPlay()
}else{this.player.mediaPause()
}}},notifyTelephonyRunningEvent:function(objStatus){this.data._boolTelephonyRunning=(objStatus.value===1);
this.data.enableOrDisableMediaUI()
},notifyMPCapabilityChange:function(strCapability,intStatus){this.data._boolMPCapabilityEnable=(intStatus===ICTouchAPI.CapabilityServices.AVAILABLE);
this.data.enableOrDisableMediaUI()
},nextPlaylist:function(){var data=webapp.filesmanager.data;
ICTouchAPI.APIServices.IctMPInterface.stopMP({params:[data.getFilesManagerContainerContent()[data.intCurrentPlayed].intIndex],callback:function(){webapp.filesmanager.notifyPlayerFinished()
},errorCallback:function(args){console.error("----------- nextErrorCallback ----------");
console.error(args)
}})
},onClickMediaList:function(id){var data=webapp.filesmanager.data;
var file=data.getElementById(id);
data.previousElement=dojo.clone(data.getCurrentElement());
data.setCurrentElement(file);
if(data.getCurrentElement().canOpen==0){this.getWarningPopup();
return
}this.mainWidget.unselectFile(id);
data.getElementById(id).boolSelected=false;
if(data.boolDeleteMode){if(data.getCurrentElement().device=="USERSPACE"){data.deleteElement(id);
if(data.currentIdFilePlayed!=null){var playedFile=data.getElementById(data.currentIdFilePlayed);
playedFile.boolSelected=true;
this.mainWidget.selectFile(this.data.currentIdFilePlayed)
}}else{this.errorManager(-6,null)
}}else{if(data.getCurrentType()==data.TYPE_BOOKMARKS){webapp.browser.openLink(file.path)
}else{data.switchToFileView(id)
}}},getWarningPopup:function(){var context=this;
var strContent=_("The selected file could not be displayed. The image size exceeds the limit viewable.","webapp.filesmanager");
var strTitle=_("Warning","ICTouchAPI");
var popupData={strTitle:strTitle,strType:"warning",strContent:strContent,arrPopupButtons:[{strButtonLabel:_("Ok","ICTouchAPI"),callback:function(){ICTouchAPI.popupServices.removePopup(context.objPopup)
}}]};
this.objPopup=ICTouchAPI.popupServices.addNewPopup(popupData,"MEDIUM")
},pausePlayer:function(){if(webapp.filesmanager.player){webapp.filesmanager.player.domMedia.pause()
}},openPopup:function(strType,strMessage){var data=webapp.filesmanager.data;
var context=this;
var func=function(){ICTouchAPI.popupServices.removePopup(context.popup)
};
var popup={strTitle:_(strType,"webapp.filesmanager"),strContent:strMessage,strType:strType,arrPopupButtons:[{strButtonName:data.OK,strButtonLabel:_("Ok","ICTouchAPI"),strButtonIcon:"generic-ok",callback:func},]};
this.popup=ICTouchAPI.popupServices.addNewPopup(popup,"MEDIUM")
},removeFromPool:function(strPool,strPath){var that=this;
ICTouchAPI.APIServices.FileManager.removeFileFromPool({params:[strPool,strPath],context:this,callback:this.errorManager,callbackParams:function(intReturn){that.onPoolChanged(strPool,intReturn,"remove",strPath)
}})
},addInPool:function(strPool,strPath){var that=this;
ICTouchAPI.APIServices.FileManager.addFileInPool({params:[strPool,strPath],context:this,callback:this.errorManager,callbackParams:function(intReturn){that.onPoolChanged(strPool,intReturn,"add",strPath)
}})
},onPoolChanged:function(strPool,intReturn,strAction,filePath){if(intReturn===0){this.poolChanged(strPool,strAction,filePath)
}},copyFile:function(idFile,device,boolOverwrite){ICTouchAPI.APIServices.FileManager.copyFileToDevice({params:[idFile,device,boolOverwrite],context:webapp.filesmanager,callback:webapp.filesmanager.errorManager});
this.createCopySpinner()
},cancelCopy:function(){this.destroyCopySpinner();
ICTouchAPI.popupServices.removePopup(this.popupOverwrite)
},createCopySpinner:function(){this.destroyCopySpinner();
this._objSpinner=new UIElements.Spinner.SpinnerControl({strMessage:_("Copy in progress...","webapp.filesmanager"),boolForeground:true},document.body);
this._spinnerHandler=setTimeout(dojo.hitch(this,this.destroyCopySpinner),2000)
},destroyCopySpinner:function(){if(this._objSpinner){this._objSpinner.destroy();
this._objSpinner=null
}if(this._spinnerHandler){clearTimeout(this._spinnerHandler);
this._spinnerHandler=null
}},errorManager:function(intReturn,funcCallback){var data=webapp.filesmanager.data;
var boolError=true;
var strMessage="";
switch(intReturn){case -1:strMessage="TECHNICAL_PROBLEM";
break;
case -2:strMessage="CATEGORY_DOES_NOT_EXIST";
break;
case -3:strMessage="UNKNOWN_FILE_IDENTIFIER";
break;
case -4:strMessage="URL_ALREADY_EXIST";
break;
case -5:strMessage="NAME_ALREADY_EXIST";
break;
case -6:strMessage="PERMISSION_DENIED";
break;
case -7:strMessage="FILE_DOES_NOT_EXIST";
break;
case -8:strMessage="FILE_IS_A_LINK";
break;
case -9:strMessage="FILE_ALREADY_ON_THE_DEVICE";
break;
case -10:strMessage="USB_KEY_NOT_CONNECTED";
break;
case -11:strMessage="UNKNOWN_DEVICE_IDENTIFIER";
break;
case -12:strMessage="DEVICE_FULL";
break;
case -13:boolError=false;
var context=this;
var popupOverwrite={strTitle:_("FILE_ALREADY_EXIST","webapp.filesmanager"),strContent:_("DO_OVERWRITE","webapp.filesmanager"),strType:"warning",arrPopupButtons:[{strButtonName:"Yes",strButtonIcon:"generic-ok",strButtonLabel:_("Yes","ICTouchAPI"),callback:function(){context.copyFile(data.getCurrentElement().intIndex,data.DEVICE_USERSPACE,true);
ICTouchAPI.popupServices.removePopup(context.popupOverwrite)
}},{strButtonName:"No",strButtonIcon:"generic-cancel",strButtonLabel:_("No","ICTouchAPI"),callback:function(){context.cancelCopy()
}},]};
this.popupOverwrite=ICTouchAPI.popupServices.addNewPopup(popupOverwrite,"MEDIUM");
break;
case -14:strMessage="NEGATIVE_ORDER";
break;
case -15:strMessage="CATEGORY_ALREADY_EXIST";
break;
case -16:strMessage="POOL_ALREADY_EXIST";
break;
case -17:strMessage="POOL_DOES_NOT_EXIST";
break;
case -18:strMessage="FILE_TYPE_ALREADY_EXIST";
break;
default:boolError=false;
break
}if(funcCallback){funcCallback(intReturn)
}if(boolError){ICTouchAPI.popupServices.errorPopup(_("Error","ICTouchAPI"),_(strMessage,"webapp.filesmanager"),_("Ok","ICTouchAPI"))
}},gotFileForPK:function(arrFiles){if(arrFiles.length==0){ICTouchAPI.popupServices.errorPopup(_("Error","ICTouchAPI"),_("FILE_DOES_NOT_EXIST","webapp.filesmanager"),_("Ok","ICTouchAPI"))
}else{webapp.filesmanager.data.formatFileObject(arrFiles[0]);
webapp.filesmanager.data.setCurrentElement(arrFiles[0]);
webapp.filesmanager.data.switchToFileView()
}},poolChanged:function(strPoolName,strAction,filePath){var data=webapp.filesmanager.data;
var strPoolNameToi18n;
var btnAddButton;
var appBar=ICTouchAPI.AppBarServices.getAppBar("filesmanager","filesmanagerstatus"+data.STATUS_PLAY);
if(strPoolName==ICTouchAPI.tools.POOL_SS){strPoolNameToi18n="Screensaver Pool";
btnAddButton=appBar.getButton(data.SSPOOL);
data.boolIsInScreenSaverPool=!data.boolIsInScreenSaverPool;
if(strAction=="add"){this.data.addFileInScreensaverPool(filePath)
}else{if(strAction=="remove"){this.data.removeFileInScreensaverPool(filePath)
}}if(this.uiScreensaver){this.uiScreensaver.updateSlideshow(this.data.getScreensaverPoolFiles())
}}if(strAction=="add"){btnAddButton.setStatusIcon(data.STATUS_ON_ICON)
}else{if(strAction=="remove"){btnAddButton.setStatusIcon(data.STATUS_OFF_ICON)
}}},showFilters:function(){ICTouchAPI.transitionServices.getScreen({name:"webapp.filesmanager.getFilters",params:{}})
}});
dojo.require("webapp.filesmanager.controlBase");
dojo.provide("webapp.filesmanager");
dojo.declare("webapp.filesmanager",webapp.filesmanager.controlBase,{buttonCallback:function(buttonId){var data=webapp.filesmanager.data;
var params;
switch(buttonId){case data.BACK:switch(data.getContainerPath()){case data.WEBAPP_PATH+"."+data.FILE_WIDGET:if(data.isFileChanged){data.refreshFileList()
}else{data.switchToListView()
}break;
case data.WEBAPP_PATH+"."+data.FILE_LIST_WIDGET:params={};
params.continue_play=true;
dojo.publish("OpenHomepage");
break;
case data.WEBAPP_PATH+".getAddLink":if(data.boolAddLink){data.refreshFileList()
}else{data.switchContainer(data.FILE_WIDGET,data.STATUS_PLAY,data.getCurrentElement().name)
}break;
case data.WEBAPP_PATH+".getRename":data.switchContainer(data.FILE_WIDGET,data.STATUS_PLAY,data.getCurrentElement().name);
break;
case data.WEBAPP_PATH+"."+data.FILTERS_WIDGET:data.boolFilterMode=false;
data.loadList();
break;
default:params={};
params.continue_play=true;
dojo.publish("OpenHomepage");
break
}break;
default:this.inherited(arguments)
}}});
webapp.filesmanager=new webapp.filesmanager();
dojo.provide("webapp.filesmanager.dataBase");
dojo.declare("webapp.filesmanager.dataBase",null,{_arrAppButtons:[],_arrSysButtons:[],_mediaUIEnabled:true,isFileChanged:false,objListUI:null,boolFilterMode:false,boolDeleteMode:false,boolShuffle:false,boolIsInScreenSaverPool:false,boolPlayList:false,boolMediaPlayerIsPlaying:false,boolMPLaunching:false,intCurrentPlayed:0,currentIdFilePlayed:null,intPlayStatus:0,_boolTelephonyRunning:false,_boolMPCapabilityEnable:true,_boolPreviewPlaying:false,objFiltersContainer:null,STATUS_LIST:0,STATUS_PLAY:1,STATUS_FILTERS:2,STATUS_NONE:3,NB_STATUS:4,DEVICE_USERSPACE:0,DEVICE_USB:1,_arrTypeList:[],_arrFilterList:[],_arrFilterInSetting:[],_arrFileList:[],_arrDeviceList:[],_arrNotifs:[],_arrScreensaverPoolFiles:[],_currentCategory:"",_currentElement:null,previousElement:null,DEVICE:"Device",TYPE_AUDIO:"Audio",TYPE_VIDEO:"Video",TYPE_PICTURE:"Picture",TYPE_WEBRADIO:"Web Radio",TYPE_WEBTV:"Webtv",TYPE_BOOKMARKS:"Bookmark",STATUS_ON_ICON:"notif-on",STATUS_OFF_ICON:"notif-off",FILE_LIST_WIDGET:"getFilesManagerFileList",FILE_WIDGET:"getFilesManagerFile",TYPE_LIST_WIDGET:"getFilesManagerList",FILTERS_WIDGET:"getFilters",WEBAPP_PATH:"webapp.filesmanager",strFilesManagerListTitle:_("My files ShortTtl","webapp.filesmanager"),strFilesManagerContainerTitle:"Title",_strContainerPath:"",FILTERS:"FILTERS_BTN",DELETE:"DELETE_BTN",PLAY_ALL:"PLAY_ALL_BTN",STOP_ALL:"STOP_ALL_BTN",NEXT:"NEXT_BTN",SHUFFLE:"SHUFFLE_BTN",PLAY:"PLAY_BTN",SSPOOL:"SSPOOL_BTN",SET_BACKGROUND:"SET_BACKGROUND_BTN",SET_USER_PICTURE:"SET_USER_PICTURE_BTN",COPY:"COPY_BTN",STOP:"STOP_BTN",PAUSE:"PAUSE_BTN",SELECT_ALL:"SELECT_ALL_BTN",DESELECT_ALL:"DESELECT_ALL_BTN",CANCEL:"CANCEL_BTN",OK:"OK_BTN",BACK:"BACK_BTN",STOP_STATUS:0,PLAY_STATUS:1,PAUSE_STATUS:2,_maxSize:200,_boolDeletable:false,strUserBackgroundPicture:"",strUserPicture:"",constructor:function(){this.populateFields();
this.loadList();
this._arrFilterList=[{intIndex:this.DEVICE_USERSPACE,strLabel:_("Show files stored in the phone","webapp.filesmanager"),enabled:true,icon:"filesmanager_filter-userspace"},{intIndex:this.DEVICE_USB,strLabel:_("Show files stored in the connected USB device","webapp.filesmanager"),enabled:true,icon:"filesmanager_filter-usb"}]
},populateFields:function(){var func=dojo.hitch(webapp.filesmanager,webapp.filesmanager.buttonCallback);
var arrButtons=[];
arrButtons.push({strButtonName:this.FILTERS,strButtonLabel:_("Filter","ICTouchAPI"),strButtonIcon:"generic-filter",callback:func});
arrButtons.push({strButtonName:this.DELETE,strButtonLabel:_("Delete","ICTouchAPI"),strButtonIcon:"generic-mode-delete",callback:func,strStatusIcon:this.STATUS_OFF_ICON});
arrButtons.push({strButtonName:this.PLAY_ALL,strButtonLabel:_("Play all","webapp.filesmanager"),strButtonIcon:"filesmanager-play-all",callback:func});
arrButtons.push({strButtonName:this.STOP_ALL,strButtonLabel:_("Stop all","webapp.filesmanager"),strButtonIcon:"filesmanager-stop",callback:func});
arrButtons.push({strButtonName:this.NEXT,strButtonLabel:_("Next","webapp.filesmanager"),strButtonIcon:"filesmanager-next",callback:func});
arrButtons.push({strButtonName:this.SHUFFLE,strButtonLabel:_("Shuffle","webapp.filesmanager"),strButtonIcon:"filesmanager-shuffle",callback:func,strStatusIcon:this.STATUS_OFF_ICON});
this._arrAppButtons[this.STATUS_LIST]=arrButtons;
arrButtons=[];
arrButtons.push({strButtonName:this.PLAY,strButtonLabel:_("Play","webapp.filesmanager"),strButtonIcon:"filesmanager-play",callback:func});
arrButtons.push({strButtonName:this.PAUSE,strButtonLabel:_("Pause","webapp.filesmanager"),strButtonIcon:"filesmanager-pause",callback:func});
arrButtons.push({strButtonName:this.STOP,strButtonLabel:_("Stop","webapp.filesmanager"),strButtonIcon:"filesmanager-stop",callback:func});
arrButtons.push({strButtonName:this.SSPOOL,strButtonLabel:_("Add to SsPool","webapp.filesmanager"),strButtonIcon:"screensaver-application",callback:func,strStatusIcon:this.STATUS_OFF_ICON});
arrButtons.push({strButtonName:this.SET_BACKGROUND,strButtonLabel:_("Set background","webapp.filesmanager"),strButtonIcon:"filesmanager-set-as-background",callback:func});
arrButtons.push({strButtonName:this.SET_USER_PICTURE,strButtonLabel:_("Set user picture","webapp.filesmanager"),strButtonIcon:"filesmanager-user-photo-avatars",callback:func});
arrButtons.push({strButtonName:this.COPY,strButtonLabel:_("Copy","webapp.filesmanager"),strButtonIcon:"filesmanager-copy-files",callback:func});
this._arrAppButtons[this.STATUS_PLAY]=arrButtons;
arrButtons=[];
arrButtons.push({strButtonName:this.SELECT_ALL,strButtonLabel:_("Select all","webapp.filesmanager"),strButtonIcon:"filesmanager-select-all",callback:func});
arrButtons.push({strButtonName:this.DESELECT_ALL,strButtonLabel:_("Deselect all","webapp.filesmanager"),strButtonIcon:"filesmanager-unselect-all",callback:func});
this._arrAppButtons[this.STATUS_FILTERS]=arrButtons;
this._arrAppButtons[this.STATUS_NONE]=[];
for(var j=0;
j<this.NB_STATUS;
j++){var appBar=ICTouchAPI.AppBarServices.getAppBar("filesmanager","filesmanagerstatus"+j);
for(var k in this._arrAppButtons[j]){var objButton=new UIElements.AppButton.AppButtonControl(this._arrAppButtons[j][k]);
appBar.addActionButton(objButton)
}}ICTouchAPI.APIServices.FileManager.getPoolSize({params:[ICTouchAPI.tools.POOL_SS],context:this,callback:this._gotScreensaverPoolSize})
},_gotScreensaverPoolSize:function(size){ICTouchAPI.APIServices.FileManager.getFilesInPool({params:[ICTouchAPI.tools.POOL_SS,0,size],context:this,callback:this._gotFilesInScreensaverPool})
},_gotFilesInScreensaverPool:function(arr){for(var i=0;
i<arr.length;
i++){this._arrScreensaverPoolFiles.push(arr[i].url)
}},addFileInScreensaverPool:function(file){this._arrScreensaverPoolFiles.push(file)
},removeFileInScreensaverPool:function(file){for(var i=0;
i<this._arrScreensaverPoolFiles.length;
i++){if(this._arrScreensaverPoolFiles[i]==file){this._arrScreensaverPoolFiles.splice(i,1)
}}},getScreensaverPoolFiles:function(){return this._arrScreensaverPoolFiles
},getFilesManagerListTitle:function(){return this.strFilesManagerListTitle
},getFilesManagerContainerTitle:function(){return this.strFilesManagerContainerTitle
},getFilesManagerListContent:function(){return this._arrTypeList
},getFilesManagerContainerContent:function(){return this._arrFileList
},getContainerPath:function(){return this._strContainerPath
},getCurrentElement:function(){return this._currentElement
},setCurrentElement:function(elem){this._currentElement=elem
},getFilters:function(strCategory){if(this._arrFilters[strCategory]){return this._arrFilters[strCategory]
}else{return[]
}},setFilters:function(magicNumber){var found=false;
var category=this.getCurrentType();
if(this._arrFilters[category]!==undefined){for(var i=0;
i<this._arrFilters[category].length;
i++){if(this._arrFilters[category][i]===magicNumber){this._arrFilters[category].splice(i,1);
found=true
}}if(!found){this._arrFilters[category].push(magicNumber)
}}else{this._arrFilters[category]=[];
this._arrFilters[category].push(magicNumber)
}},getUserBackgroundPicture:function(){return this.strUserBackgroundPicture
},setUserBackgroundPicture:function(strPicture){this.strUserBackgroundPicture=strPicture;
if(webapp.filesmanager.currentStatus==this.STATUS_PLAY){this.formatAppBar(this.STATUS_PLAY)
}},getUserPicture:function(){return this.strUserPicture
},setUserPicture:function(strPicture){this.strUserPicture=strPicture;
if(webapp.filesmanager.currentStatus==this.STATUS_PLAY){this.formatAppBar(this.STATUS_PLAY)
}},getNotifs:function(){return this._arrNotifs
},getCategoryByName:function(strName){var list=this.getFilesManagerListContent();
for(var i=0;
i<list.length;
i++){if(list[i].category===strName){return list[i]
}}return null
},getCategoryById:function(intId){var list=this.getFilesManagerListContent();
for(var i=0;
i<list.length;
i++){if(list[i].intIndex===intId){return list[i].category
}}return null
},getElementById:function(intId){var list=this.getFilesManagerContainerContent();
for(var i=0;
i<list.length;
i++){if(list[i].intIndex===intId){return list[i]
}}return null
},getCurrentType:function(){return this._currentCategory
},setCurrentType:function(strCategory){this._currentCategory=strCategory
},stopPlayList:function(status){if(this.boolPlayList){this.boolPlayList=false;
ICTouchAPI.APIServices.IctMPInterface.stopMP({params:[this.currentIdFilePlayed]});
this.clearPlayNotifs()
}},stop:function(){ICTouchAPI.APIServices.IctMPInterface.stopMP({params:[this._currentElement.intIndex]});
this.clearPlayNotifs()
},addPlayNotif:function(objNotif){objNotif.strNotificationName+=this.getNotifs().length;
ICTouchAPI.notificationServices.addNotification(objNotif);
this._arrNotifs.push(objNotif)
},clearPlayNotifs:function(strType){for(var i=0;
i<this.getNotifs().length;
i++){ICTouchAPI.notificationServices.removeNotification(this.getNotifs()[i].strNotificationName)
}this._arrNotifs=[]
},setFilesManagerContainerContent:function(intTypeId){for(var i=0;
i<this._arrTypeList.length;
i++){if(this._arrTypeList[i].intIndex===intTypeId){this.strFilesManagerContainerTitle=this._arrTypeList[i].category;
break
}}},loadList:function(){ICTouchAPI.APIServices.FileManager.getAllFileCategories({params:[1,2],context:this,callback:this.loadedList})
},loadedList:function(args){var arrList=args;
this._arrTypeList=[];
if(this.boolFilterMode){this._arrTypeList.push({strType:"normal",intIndex:-1,category:this.DEVICE,strPrimaryContent:_(this.DEVICE,"webapp.filesmanager")})
}for(var i=0;
i<arrList.length;
i++){this._arrTypeList.push({strType:"normal",intIndex:arrList[i].idFileCategory,category:arrList[i].categoryName,strPrimaryContent:_(arrList[i].categoryName,"webapp.filesmanager")})
}if(webapp.filesmanager.mainWidget){webapp.filesmanager.mainWidget.reloadMenu();
if(this.boolFilterMode){this.onClickCategory(-1)
}else{if(this._arrTypeList[0]){this.onClickCategory(this._arrTypeList[0].intIndex)
}else{this.updateAppBar(this.STATUS_NONE)
}}}},onClickCategory:function(intMediaTypeId){this.setCurrentType(this.getCategoryById(intMediaTypeId));
this.setFilesManagerContainerContent(intMediaTypeId);
ICTouchAPI.APIServices.FileManager.getFilesInCategorySize({context:this,params:[this.getCurrentType()],callback:this.loadFileList})
},loadFileList:function(intSize,params){this.isFileChanged=false;
if(intSize){if(!this._arrFilterInSetting.length){ICTouchAPI.settingServices.getSetting("FilesManagerFilter",this,this.filtersLoaded,params)
}else{this.filtersLoaded(null,params)
}}else{this.loadedFileList([],params)
}},filtersLoaded:function(filterList,params){if(filterList){this._arrFilterInSetting=filterList.jsValue.split(";")
}if(this._arrFilterInSetting.length==this._arrFilterList.length||!this._arrFilterInSetting.length){ICTouchAPI.APIServices.FileManager.getFileDescriptions({params:[this.getCurrentType(),0,this._maxSize],context:this,callback:this.loadedFileList,callbackParams:params})
}else{ICTouchAPI.APIServices.FileManager.getExtensions({params:[this.getCurrentType()],context:this,callback:this.loadFilesWithFilter})
}},loadFilesWithFilter:function(strList){ICTouchAPI.APIServices.FileManager.getFilesWithFilter({params:[this.getCurrentType(),0,this._maxSize,strList,this._arrFilterInSetting.join(";")],context:this,callback:this.loadedFileList})
},loadedFilterList:function(strList){var arrList;
if(strList){arrList=strList.split(";")
}this._arrFilterList=[];
if(this.getCurrentType()===this.DEVICE){this._arrFilterList.push({intIndex:""+this.DEVICE_USERSPACE,strLabel:_("USERSPACE","webapp.filesmanager"),boolSelected:this.isFiltered(""+this.DEVICE_USERSPACE)});
this._arrFilterList.push({intIndex:""+this.DEVICE_USB,strLabel:_("USB","webapp.filesmanager"),boolSelected:this.isFiltered(""+this.DEVICE_USB)})
}else{if(arrList){if(arrList[0]!==""){for(var i=0;
i<arrList.length;
i++){var strLabel=arrList[i];
this._arrFilterList.push({intIndex:arrList[i],strLabel:strLabel,boolSelected:this.isFiltered(arrList[i])})
}}}}this.checkMagicNumberValidity();
this.switchToFiltersView()
},checkMagicNumberValidity:function(){var filterList=this.getFilterList();
var filters=this.getFilters(this.getCurrentType());
var found=false;
for(var i in filters){for(var j in filterList){if(filters[i]===filterList[j].intIndex){found=true
}}if(!found){this._arrFilterList.push({intIndex:filters[i],strLabel:filters[i],boolSelected:true})
}found=false
}},getCurrentFilters:function(){var arrFilters=[];
for(var i in this._arrFilterList){if(this._arrFilterList[i].enabled){arrFilters.push(this._arrFilterList[i].intIndex)
}}return arrFilters
},loadedFileList:function(arrList,params){this.storeFileList(arrList);
this.switchToListView();
if(this.boolDeleteMode&&!this._boolDeletable){this.setDeleteMode(false)
}},storeFileList:function(arrFileList){this._boolDeletable=false;
if(arrFileList){this._arrFileList=[];
for(var i=0;
i<arrFileList.length;
i++){var objFile=dojo.clone(arrFileList[i]);
this.formatFileObject(objFile);
if(objFile.intIndex===this.currentIdFilePlayed){objFile.boolSelected=true
}this._arrFileList.push(objFile);
if((!this._boolDeletable)&&(objFile.device=="USERSPACE")){this._boolDeletable=true
}}}},formatFileObject:function(objFile){if(objFile.intIndex===undefined){objFile.intIndex=objFile.id
}delete objFile.id;
objFile.type=this.getCurrentType();
objFile.size=(objFile.size)?objFile.size:null;
objFile.device=(objFile.device)?objFile.device:null;
objFile.path=objFile.url;
objFile.strCheckedIcon="filesmanager-play-32";
if(objFile.canOpen==0){objFile.additionalStyle="unavailable"
}var device="";
if(objFile.device==="USERSPACE"||objFile.device==="System"){device=objFile.device
}else{device="USB"
}var filesize=this.getSizeLabel(objFile.size);
var strLabel=_([objFile.name,filesize,device],"webapp.filesmanager");
objFile.strLabel=strLabel
},getSizeLabel:function(size){if(!size){return""
}var extTab=["b","kb","Mb","Gb"];
var extIndex=0;
while(size/1024>=1){extIndex++;
size=size/1024
}var finalSize=size.toFixed(2);
finalSize=finalSize.toString().replace(/0*$/,"");
if(finalSize[finalSize.length-1]=="."){finalSize=finalSize.replace(".","")
}return finalSize+" "+extTab[extIndex]
},switchToFileView:function(){this.strFilesManagerContainerTitle=this.getCurrentElement().name;
this.isInPools()
},switchedToFileView:function(){this.switchContainer(this.FILE_WIDGET,this.STATUS_PLAY,this.getFilesManagerContainerTitle())
},isInPools:function(){var context=this;
this.boolIsInScreenSaverPool=false;
var currentType=this.getCurrentType();
if(currentType==this.TYPE_PICTURE){ICTouchAPI.APIServices.FileManager.fileExistsInPool({params:[ICTouchAPI.tools.POOL_SS,context.getCurrentElement().intIndex],context:webapp.filesmanager,callback:webapp.filesmanager.errorManager,callbackParams:function(boolInPool){context.boolIsInScreenSaverPool=(boolInPool===0)?false:true;
context.switchedToFileView()
}})
}else{this.switchedToFileView()
}},switchToListView:function(){this.strFilesManagerContainerTitle=this.getCurrentType();
if(webapp.filesmanager.player){webapp.filesmanager.player=null
}this.switchContainer(this.FILE_LIST_WIDGET,this.STATUS_LIST,this.getFilesManagerContainerTitle())
},switchToFiltersView:function(){if(webapp.filesmanager.player){webapp.filesmanager.player=null
}this.switchContainer(this.FILTERS_WIDGET,this.STATUS_FILTERS,this.getFilesManagerContainerTitle())
},selectAllFilters:function(){this._arrFilters[this.getCurrentType()]=[];
for(var i in this._arrFilterList){this._arrFilterList[i].boolSelected=true;
this._arrFilters[this.getCurrentType()].push(this._arrFilterList[i].intIndex)
}webapp.filesmanager.mainWidget.reloadContainer()
},deselectAllFilters:function(){this._arrFilters[this.getCurrentType()]=[];
for(var i in this._arrFilterList){this._arrFilterList[i].boolSelected=false
}webapp.filesmanager.mainWidget.reloadContainer()
},deleteElement:function(intId){if(intId){this.setCurrentElement(this.getElementById(intId))
}var currentElement=this.getCurrentElement();
if(currentElement){var context=this;
var strContent=_(["Delete the file",":",currentElement.strLabel,"?"],"webapp.filesmanager");
var popupDel={strTitle:_("Delete confirmation","webapp.filesmanager"),strType:"warning",strContent:strContent,arrPopupButtons:[{strButtonName:"YES_BTN",strButtonIcon:"generic-ok",strButtonLabel:_("Yes","ICTouchAPI"),callback:dojo.hitch(context,context._deleteCurrentElement)},{strButtonName:"NO_BTN",strButtonIcon:"generic-cancel",strButtonLabel:_("No","ICTouchAPI"),callback:function(){ICTouchAPI.popupServices.removePopup(context.popupDel)
}}]};
this.popupDel=ICTouchAPI.popupServices.addNewPopup(popupDel,"MEDIUM")
}},_deleteCurrentElement:function(){ICTouchAPI.popupServices.removePopup(this.popupDel);
if(webapp.filesmanager.player){webapp.filesmanager.player.destroy()
}ICTouchAPI.APIServices.FileManager.deleteFile({params:[this.getCurrentElement().intIndex],context:webapp.filesmanager,callback:webapp.filesmanager.errorManager,callbackParams:dojo.hitch(this,this.refreshFileList)})
},refreshFileList:function(){this.onClickCategory(this.getCategoryByName(this.getCurrentType()).intIndex)
},setDeleteMode:function(boolMode){this.boolDeleteMode=boolMode;
var appBar=ICTouchAPI.AppBarServices.getAppBar("filesmanager","filesmanagerstatus"+this.STATUS_LIST);
var deleteButton=appBar.getButton(this.DELETE);
if(boolMode){deleteButton.setStatusIcon(this.STATUS_ON_ICON)
}else{deleteButton.setStatusIcon(this.STATUS_OFF_ICON)
}},setShuffleStatus:function(){this.boolShuffle=!this.boolShuffle;
var appBar=ICTouchAPI.AppBarServices.getAppBar("filesmanager","filesmanagerstatus"+this.STATUS_LIST);
var shuffleButton;
if(appBar){shuffleButton=appBar.getButton(this.SHUFFLE)
}var strStatusIcon=(this.boolShuffle)?this.STATUS_ON_ICON:this.STATUS_OFF_ICON;
if(shuffleButton){shuffleButton.setStatusIcon(strStatusIcon)
}},switchContainer:function(pageName,status,pageTitle,params){if(pageName!==""){this._strContainerPath="webapp.filesmanager."+pageName
}if(pageTitle){this.strFilesManagerContainerTitle=pageTitle
}if(status!==undefined){this.updateAppBar(status)
}if(webapp.filesmanager.mainWidget){webapp.filesmanager.mainWidget.reloadContainer(params)
}},updateAppBar:function(status){webapp.filesmanager.currentStatus=status;
var backFunc=dojo.hitch(webapp.filesmanager,webapp.filesmanager.buttonCallback,this.BACK);
ICTouchAPI.AppBarServices.addExitButton("filesmanager","filesmanagerstatus"+status,this.isPreviousHome(),backFunc);
this.formatAppBar(status);
ICTouchAPI.AppBarServices.setAppBar("filesmanager","filesmanagerstatus"+status,"getFilesManager")
},formatAppBar:function(status){var appBar=ICTouchAPI.AppBarServices.getAppBar("filesmanager","filesmanagerstatus"+status);
var currentType=this.getCurrentType();
var currentElement=this.getCurrentElement();
if(currentType==this.TYPE_AUDIO){if(status===this.STATUS_LIST){if(this.boolPlayList){if(this.getMediaCapability()){appBar.getButton(this.NEXT).show();
appBar.getButton(this.SHUFFLE).show()
}else{appBar.getButton(this.NEXT).hide();
appBar.getButton(this.PLAY_ALL).hide();
appBar.getButton(this.SHUFFLE).hide()
}if(this.intPlayStatus!==this.PLAY_STATUS){if(this.getMediaCapability()){appBar.getButton(this.PLAY_ALL).show()
}appBar.getButton(this.STOP_ALL).hide()
}else{appBar.getButton(this.PLAY_ALL).hide();
appBar.getButton(this.STOP_ALL).show()
}}else{appBar.getButton(this.STOP_ALL).hide();
appBar.getButton(this.NEXT).hide();
appBar.getButton(this.SHUFFLE).hide();
if(this.getMediaCapability()){appBar.getButton(this.PLAY_ALL).show()
}else{appBar.getButton(this.PLAY_ALL).hide()
}if(!this._arrFileList.length){appBar.getButton(this.PLAY_ALL).hide();
appBar.getButton(this.SHUFFLE).hide()
}else{appBar.getButton(this.PLAY_ALL).show();
appBar.getButton(this.SHUFFLE).show()
}if(!this._boolDeletable){appBar.getButton(this.DELETE).hide()
}else{appBar.getButton(this.DELETE).show()
}}}else{if(status===this.STATUS_PLAY){appBar.getButton(this.COPY).hide()
}}}else{if(status===this.STATUS_LIST){appBar.getButton(this.PLAY_ALL).hide();
appBar.getButton(this.STOP_ALL).hide();
appBar.getButton(this.NEXT).hide();
appBar.getButton(this.SHUFFLE).hide();
if(!this._boolDeletable){appBar.getButton(this.DELETE).hide()
}else{appBar.getButton(this.DELETE).show()
}}else{if(status===this.STATUS_PLAY){appBar.getButton(this.PLAY).hide();
appBar.getButton(this.PAUSE).hide();
appBar.getButton(this.STOP).hide()
}}}if(status===this.STATUS_PLAY){if(currentType==this.TYPE_PICTURE){appBar.getButton(this.STOP).hide();
appBar.getButton(this.SET_BACKGROUND).show();
appBar.getButton(this.SET_USER_PICTURE).show();
if(currentElement&&currentElement.device!="USERSPACE"&&currentElement.device!="System"){appBar.getButton(this.COPY).show();
appBar.getButton(this.SSPOOL).hide()
}else{appBar.getButton(this.COPY).hide();
appBar.getButton(this.SSPOOL).show();
if(this.boolIsInScreenSaverPool){appBar.getButton(this.SSPOOL).setStatusIcon(this.STATUS_ON_ICON)
}else{appBar.getButton(this.SSPOOL).setStatusIcon(this.STATUS_OFF_ICON)
}}var strOldBackgroundPicture=this.getUserBackgroundPicture();
var strNewBackgroundPicture=this.getCurrentElement().path;
if(strOldBackgroundPicture==strNewBackgroundPicture){appBar.getButton(this.SET_BACKGROUND).setStatusIcon(this.STATUS_ON_ICON)
}else{appBar.getButton(this.SET_BACKGROUND).setStatusIcon(this.STATUS_OFF_ICON)
}var strOldUserPicture=this.getUserPicture();
var strNewUserPicture=this.getCurrentElement().path;
if(strOldUserPicture==strNewUserPicture){appBar.getButton(this.SET_USER_PICTURE).setStatusIcon(this.STATUS_ON_ICON)
}else{appBar.getButton(this.SET_USER_PICTURE).setStatusIcon(this.STATUS_OFF_ICON)
}}else{appBar.getButton(this.STOP).show();
appBar.getButton(this.SET_BACKGROUND).hide();
appBar.getButton(this.SET_USER_PICTURE).hide();
appBar.getButton(this.SSPOOL).hide()
}}return appBar
},isPreviousHome:function(){switch(this.getContainerPath()){case this.WEBAPP_PATH+"."+this.FILE_WIDGET:return false;
case this.WEBAPP_PATH+"."+this.FILE_LIST_WIDGET:return true;
case this.WEBAPP_PATH+"."+this.FILTERS_WIDGET:return false;
default:return true
}},getMediaCapability:function(){return this._boolMPCapabilityEnable&&!this._boolTelephonyRunning
},enableOrDisableMediaUI:function(){var appBar;
var mediaCapability=this.getMediaCapability();
if(mediaCapability!==this._mediaUIEnabled){if(mediaCapability){this._mediaUIEnabled=true;
dojo.publish("filesmanager/MediaPlayerEnabled");
appBar=ICTouchAPI.AppBarServices.getAppBar("filesmanager","filesmanagerstatus"+this.STATUS_PLAY);
if(this.boolMediaPlayerIsPlaying){appBar.getButton(this.STOP).show();
if(this.intPlayStatus===this.PLAY_STATUS){appBar.getButton(this.PAUSE).show()
}else{appBar.getButton(this.PLAY).show()
}}else{appBar.getButton(this.PLAY).show()
}appBar=ICTouchAPI.AppBarServices.getAppBar("filesmanager","filesmanagerstatus"+this.STATUS_LIST);
this.formatAppBar(this.STATUS_LIST)
}else{this._mediaUIEnabled=false;
dojo.publish("filesmanager/MediaPlayerDisabled");
appBar=ICTouchAPI.AppBarServices.getAppBar("filesmanager","filesmanagerstatus"+this.STATUS_PLAY);
appBar.getButton(this.STOP).hide();
appBar.getButton(this.PLAY).hide();
appBar.getButton(this.PAUSE).hide();
this.formatAppBar(this.STATUS_LIST)
}}},toggleFilter:function(filterid){this._arrFilterList[filterid].enabled=!this._arrFilterList[filterid].enabled;
if(this.getCurrentFilters().length==0){var idx=(filterid==0)?1:0;
this._arrFilterList[idx].enabled=!this._arrFilterList[idx].enabled;
webapp.filesmanager.uiFilters.getContent().getContent().selectAtIndex(idx)
}},getFiltersList:function(){var arrItemsFilters=[];
for(var i in this._arrFilterList){arrItemsFilters.push({intIndex:this._arrFilterList[i].intIndex,boolSelected:!this._arrFilterInSetting.length||dojo.indexOf(this._arrFilterInSetting,this._arrFilterList[i].intIndex)!==-1,strSecondaryContentIcon:this._arrFilterList[i].icon,strLabel:this._arrFilterList[i].strLabel});
this._arrFilterList[i].enabled=arrItemsFilters[i].boolSelected
}return arrItemsFilters
},refreshIfNewFilters:function(){var currentFilters=this.getCurrentFilters();
var isNewFilter=false;
if(currentFilters.length!=this._arrFilterInSetting.length){isNewFilter=true
}else{for(var i in currentFilters){if(dojo.indexOf(this._arrFilterInSetting,currentFilters[i])==-1){isNewFilter=true;
break
}}}if(isNewFilter){ICTouchAPI.settingServices.setSettingValue("FilesManagerFilter",currentFilters.join(";"),this)
}},setPreviewPlaying:function(boolPreviewPlaying){this._boolPreviewPlaying=boolPreviewPlaying
},isPreviewPlaying:function(){return this._boolPreviewPlaying
}});
dojo.require("webapp.filesmanager.dataBase");
dojo.provide("webapp.filesmanager.data");
dojo.declare("webapp.filesmanager.data",webapp.filesmanager.dataBase,{formatAppBar:function(status){this.inherited(arguments)
}});
webapp.filesmanager.data=new webapp.filesmanager.data();
dojo.provide("webapp.filesmanager.getFilesManagerBase");
dojo.declare("webapp.filesmanager.getFilesManagerBase",[ICTouchAPI.webWidget,dojox.dtl._Templated],{reloadContainer:function(params){var data=webapp.filesmanager.data;
this.initVariables(params);
if(this.container){this.container.reload({objTitle:{strLabel:_(data.getFilesManagerContainerTitle(),"webapp.filesmanager")},objContent:this.objContent})
}},update:function(){}});
dojo.require("webapp.filesmanager.getFilesManagerBase");
dojo.provide("webapp.filesmanager.getFilesManager");
dojo.declare("webapp.filesmanager.getFilesManager",webapp.filesmanager.getFilesManagerBase,{templatePath:dojo.moduleUrl("webapp.filesmanager","templates/getFilesManager8082.html"),objContent:{},managerContainer:null,postCreate:function(){var data=webapp.filesmanager.data;
this.initVariables();
this.managerContainer=new UIElements.ApplicationMode.ThirdControl({menu:{name:"UIElements.MenuList.MenuListControl",params:{arrItems:webapp.filesmanager.data.getFilesManagerListContent(),autoSelectFirst:true,callback:dojo.hitch(webapp.filesmanager.data,webapp.filesmanager.data.onClickCategory)}},container:this.objContent,objContainerTitle:{strLabel:data.getFilesManagerContainerTitle()},objMenuTitle:{strLabel:data.getFilesManagerListTitle()}},this.mainPart);
this.container=this.managerContainer.getContainer();
this.menu=this.managerContainer.getMenu();
webapp.filesmanager.mainWidget=this;
webapp.filesmanager.filesmanagerList=this.managerContainer.getMenu();
webapp.filesmanager.data.objListUI=this.menu.getContent();
data.updateAppBar(data.STATUS_NONE)
},initVariables:function(params){this.objContent={};
var data=webapp.filesmanager.data;
var arrListData=null;
var funcCallback=null;
switch(webapp.filesmanager.data.getContainerPath()){case"webapp.filesmanager.getFilesManagerFileList":arrListData=data.getFilesManagerContainerContent();
funcCallback=dojo.hitch(webapp.filesmanager,webapp.filesmanager.onClickMediaList);
break;
case"webapp.filesmanager.getFilters":arrListData=data.getFilterList();
funcCallback=dojo.hitch(webapp.filesmanager.data,webapp.filesmanager.data.setFilters);
break;
default:arrListData=[];
funcCallback=null;
break
}if(!arrListData){arrListData=[]
}var boolMultiselect=false;
switch(webapp.filesmanager.data.getContainerPath()){case"webapp.filesmanager.getFilters":boolMultiselect=true;
case"webapp.filesmanager.getFilesManagerFileList":this.objContent={name:"UIElements.SelectList.SelectListControl",params:{arrItems:arrListData,boolMultiselect:boolMultiselect,itemCallback:funcCallback,showEmptyState:true,emptyText:_("No files","webapp.filesmanager")}};
break;
default:var tmpParams=params?params:{};
this.objContent={name:data.getContainerPath(),params:tmpParams};
break
}},reloadMenu:function(params){var data=webapp.filesmanager.data;
this.menu.reload({objTitle:{strLabel:data.getFilesManagerListTitle()},objContent:{name:"UIElements.MenuList.MenuListControl",params:{arrItems:data.getFilesManagerListContent(),autoSelectFirst:true,callback:dojo.hitch(data,data.onClickCategory)}}});
webapp.filesmanager.data.objListUI=this.menu.getContent()
},selectFile:function(intFileIndex){if(webapp.filesmanager.data.getContainerPath()==="webapp.filesmanager.getFilesManagerFileList"){var arrItems=this.container.getContent().arrItems;
var iMax=arrItems.length;
for(var i=0;
i<iMax;
i++){if(arrItems[i].intIndex===intFileIndex){this.container.getTitle().changeTitle(arrItems[i].name);
this.container.getContent().selectAtIndex(i);
return true
}}}return false
},unselectFile:function(intFileIndex){if(webapp.filesmanager.data.getContainerPath()==="webapp.filesmanager.getFilesManagerFileList"){var arrItems=this.container.getContent().arrItems;
var iMax=arrItems.length;
for(var i=0;
i<iMax;
i++){if(arrItems[i].intIndex===intFileIndex){this.container.getContent().unselectAtIndex(i);
return true
}}}return false
},selectAllFile:function(){if(webapp.filesmanager.data.getContainerPath()==="webapp.filesmanager.getFilesManagerFileList"){this.container.getContent().selectAll();
return true
}return false
},unselectAllFile:function(){if(webapp.filesmanager.data.getContainerPath()==="webapp.filesmanager.getFilesManagerFileList"){this.container.getContent().unselectAll();
return true
}return false
},destroy:function(){this.managerContainer.destroy();
this.inherited(arguments)
}});
dojo.provide("webapp.filesmanager.getFilesManagerFileBase");
dojo.declare("webapp.filesmanager.getFilesManagerFileBase",[ICTouchAPI.webWidget,dojox.dtl._Templated],{strMediaPath:"",strImagePath:"",intIndex:0,player:null,stopSubscribe:null,enableMPSubscribe:null,disableMPSubscribe:null,boolPlayed:null,constructor:function(){},postMixInProperties:function(){var data=webapp.filesmanager.data;
this.strMediaPath=data.getCurrentElement().path;
this.intIndex=data.getCurrentElement().intIndex;
if(data.getCurrentType()===data.TYPE_PICTURE){this.strImagePath=this.strMediaPath
}else{this.strImagePath=null
}},postCreate:function(){var data=webapp.filesmanager.data;
webapp.filesmanager.uiFile=this;
var that=this;
var func=function(){that.playPause()
};
if(data.getCurrentType()===data.TYPE_AUDIO){this.player=new UIElements.Media.Audio({intSliderX:this.intSliderX,intSliderY:this.intSliderY,intSliderWidth:this.intSliderWidth,boolCanPause:false,intMediaDuration:1000,boolSeekable:false,strMediaPath:"webapp/filesmanager/themes/Default/images/avatar_audiofile_200.png",clbkPlay:function(){},clbkPause:function(){},boolShowSliderButton:false,boolIconOnSliderButton:false},this.domFileContent);
webapp.filesmanager.player=this.player
}else{if(data.getCurrentType()===data.TYPE_VIDEO){this.player=new UIElements.Media.Video({intVideoWidth:this.intAreaWidth,intVideoHeight:this.intAreaHeight,intVideoX:this.intAreaX,intVideoY:this.intAreaY,intSliderX:this.intSliderX,intSliderY:this.intSliderY,intSliderWidth:this.intSliderWidth,clbkPlay:func,clbkPause:func},this.domFileContent);
webapp.filesmanager.player=this.player
}else{if(data.getCurrentType()===data.TYPE_WEBRADIO){this.player=new UIElements.Media.Audio({intSliderX:this.intSliderX+225,intSliderY:this.intSliderY,intSliderWidth:45,boolShowSliderTime:false,clbkPlay:func,clbkPause:func},this.domFileContent);
webapp.filesmanager.player=this.player
}else{if(data.getCurrentType()===data.TYPE_WEBTV){this.player=new UIElements.Media.Video({intVideoWidth:this.intAreaWidth,intVideoHeight:this.intAreaHeight,intVideoX:this.intAreaX,intVideoY:this.intAreaY,intSliderX:this.intSliderX,intSliderY:this.intSliderY,intSliderWidth:45,boolShowSliderTime:false,clbkPlay:func,clbkPause:func},this.domFileContent);
webapp.filesmanager.player=this.player
}else{if(data.getCurrentType()===data.TYPE_PICTURE){webapp.filesmanager.player=null
}}}}}if(data.getCurrentType()===data.TYPE_AUDIO||data.getCurrentType()===data.TYPE_WEBRADIO){if(data.getMediaCapability()){this.enablePlayer()
}else{this.disablePlayer()
}var appBar=ICTouchAPI.AppBarServices.getAppBar("filesmanager","filesmanagerstatus"+data.STATUS_PLAY);
if(!data.boolMediaPlayerIsPlaying){appBar.getButton(data.STOP).greyTint();
appBar.getButton(data.PLAY).show();
appBar.getButton(data.PAUSE).hide()
}else{appBar.getButton(data.STOP).show();
appBar.getButton(data.PLAY).hide();
appBar.getButton(data.PAUSE).show()
}this.enableMPSubscribe=dojo.subscribe("filesmanager/MediaPlayerEnabled",null,function(){that.enablePlayer()
});
this.disableMPSubscribe=dojo.subscribe("filesmanager/MediaPlayerDisabled",null,function(){that.disablePlayer()
});
this.playedSubscribe=dojo.subscribe("filesmanager/MediaPlayerPlayed",null,function(){var appBar=ICTouchAPI.AppBarServices.getAppBar("filesmanager","filesmanagerstatus"+data.STATUS_PLAY);
appBar.getButton(data.STOP).show()
});
this.stoppedMPSubscribe=dojo.subscribe("filesmanager/MediaPlayerFinished",null,function(){webapp.filesmanager.boolPlayed=false;
this.boolPlayed=false;
var appBar=ICTouchAPI.AppBarServices.getAppBar("filesmanager","filesmanagerstatus"+data.STATUS_PLAY);
appBar.getButton(data.STOP).greyTint()
});
if(!data.boolPlayList){if(data.boolMediaPlayerIsPlaying){if(data.currentIdFilePlayed===data.getCurrentElement().intIndex){ICTouchAPI.APIServices.IctMPInterface.getMediaSessionInfos({context:this,callback:function(args){webapp.filesmanager.mediaSessionInfosReceived(args)
}});
this.resetAfterMPStopped()
}else{this.subscribeToStopMP();
ICTouchAPI.APIServices.IctMPInterface.stopMP({params:[data.previousElement.intIndex]})
}}else{this.launch()
}}else{this.subscribeToStopPlayList();
data.stopPlayList()
}}},subscribeToStopMP:function(){var that=this;
var dojoSubs=dojo.subscribe("filesmanager/MediaPlayerFinished",null,function(){that.launch();
dojo.unsubscribe(dojoSubs)
})
},subscribeToStopPlayList:function(){var dojoSubs=dojo.subscribe("filesmanager/MediaPlayerStopped",this,function(){this.boolPlayed=false;
this.launch();
dojo.unsubscribe(dojoSubs)
})
},resetAfterMPStopped:function(){if(this.stopSubscribe){dojo.unsubscribe(this.stopSubscribe)
}this.stopSubscribe=dojo.subscribe("filesmanager/MediaPlayerStopped",this,function(){this.boolPlayed=false;
dojo.unsubscribe(this.stopSubscribe);
this.resetMediaBar()
})
},playPause:function(){var data=webapp.filesmanager.data;
if(webapp.filesmanager.boolPlayed==true){this.boolPlayed=true
}if(data._mediaUIEnabled===true){if(this.boolPlayed===true){if(data.boolPlayList){this.subscribeToStopMP();
data.stopPlayList()
}else{if(data.boolMediaPlayerIsPlaying){ICTouchAPI.APIServices.IctMPInterface.playPauseMP({params:[this.intIndex]})
}}}else{this.launch()
}}},launch:function(){var data=webapp.filesmanager.data;
var fm=webapp.filesmanager;
var that=this;
if(!fm.data.boolMPLaunching&&data.getMediaCapability()){fm.data.boolMPLaunching=true;
this.boolPlayed=true;
var notif=null;
if(data.getCurrentType()===data.TYPE_AUDIO){notif={strNotificationName:"play",strNotificationLabel:_("Media","webapp.filesmanager"),intNotificationValue:1,callback:function(){webapp.filesmanager.openCategory(fm.data.TYPE_AUDIO);
webapp.filesmanager.boolPlayed=true;
fm.gotFileForPK([fm.data.getCurrentElement()])
}};
ICTouchAPI.APIServices.IctMPInterface.playMedia({params:[this.intIndex,this.strMediaPath]})
}this.resetAfterMPStopped();
data.clearPlayNotifs();
data.addPlayNotif(notif)
}else{this.boolPlayed=false
}},resetMediaBar:function(){if(this.player){this.player.mediaPause();
this.player.setToTime(0)
}},enablePlayer:function(){},disablePlayer:function(){},destroy:function(){if(this.stoppedSubscribe){dojo.unsubscribe(this.stoppedSubscribe)
}if(this.playedSubscribe){dojo.unsubscribe(this.playedSubscribe)
}if(this.stopSubscribe){dojo.unsubscribe(this.stopSubscribe)
}if(this.enableMPSubscribe){dojo.unsubscribe(this.enableMPSubscribe)
}if(this.disableMPSubscribe){dojo.unsubscribe(this.disableMPSubscribe)
}if(this.stoppedMPSubscribe){dojo.unsubscribe(this.stoppedMPSubscribe)
}if(this.player){this.player.destroy()
}if(webapp.filesmanager.player){webapp.filesmanager.player.destroy()
}this.inherited(arguments)
}});
dojo.require("webapp.filesmanager.getFilesManagerFileBase");
dojo.provide("webapp.filesmanager.getFilesManagerFile");
dojo.declare("webapp.filesmanager.getFilesManagerFile",webapp.filesmanager.getFilesManagerFileBase,{templatePath:dojo.moduleUrl("webapp.filesmanager","templates/getFilesManagerFile8082.html"),intAreaX:20,intAreaY:5,intAreaWidth:450,intAreaHeight:200,intSliderX:43,intSliderY:215,intSliderWidth:390});
dojo.provide("webapp.filesmanager.getFiltersBase");
dojo.declare("webapp.filesmanager.getFiltersBase",[ICTouchAPI.webWidget,dojox.dtl._Templated],{domFiltersContent:null,postCreate:function(){ICTouchAPI.AppBarServices.addExitButton("filesmanager","getFilters",false,{context:this,func:this.back});
ICTouchAPI.AppBarServices.setAppBar("filesmanager","getFilters","getFilters");
var strTitle=_("Filesmanager filters","webapp.filesmanager");
this.webapp.uiFilters=new UIElements.ApplicationMode.FullControl({content:{name:"UIElements.SelectList.SelectListControl",params:{arrItems:webapp.filesmanager.data.getFiltersList(),boolMultiselect:true,itemCallback:dojo.hitch(webapp.filesmanager.data,webapp.filesmanager.data.toggleFilter)}},objTitle:{strLabel:strTitle}},this.domFiltersContent);
this.inherited(arguments)
},back:function(){if(webapp.filesmanager.data.getCurrentFilters().length==0){this.webapp.openPopup("error",_("Please select at least one filter","webapp.filesmanager"))
}else{ICTouchAPI.transitionServices.getScreen({name:"webapp.filesmanager.getFilesManager",params:{}});
webapp.filesmanager.data.refreshIfNewFilters()
}}});
dojo.require("webapp.filesmanager.getFiltersBase");
dojo.provide("webapp.filesmanager.getFilters");
dojo.declare("webapp.filesmanager.getFilters",webapp.filesmanager.getFiltersBase,{templatePath:dojo.moduleUrl("webapp.filesmanager","templates/getFilters8082.html")});
dojo.require("webapp.screensaver.defaultScreensaverBase");
dojo.provide("webapp.filesmanager.screensaverSlideshowBase");
dojo.declare("webapp.filesmanager.screensaverSlideshowBase",webapp.screensaver.defaultScreensaverBase,{initScreensaver:function(){this.webapp.uiScreensaver=this;
this.arrSlideshow=this.webapp.data.getScreensaverPoolFiles()
}});
dojo.require("webapp.filesmanager.screensaverSlideshowBase");
dojo.provide("webapp.filesmanager.screensaverSlideshow");
dojo.declare("webapp.filesmanager.screensaverSlideshow",webapp.filesmanager.screensaverSlideshowBase,{templatePath:dojo.moduleUrl("webapp.filesmanager","templates/screensaverSlideshow8082.html")});