dojo.provide("webapp.filesmanager.getFiltersBase");
dojo.declare("webapp.filesmanager.getFiltersBase",
	[ICTouchAPI.webWidget, dojox.dtl._Templated],
	{
		domFiltersContent	: null,

		postCreate : function() {
			// Create the static back button
			ICTouchAPI.AppBarServices.addExitButton("filesmanager", "getFilters", false, {
				context: this,
				func: this.back
			});

			ICTouchAPI.AppBarServices.setAppBar("filesmanager", "getFilters", "getFilters");

			// Create screen content
			var strTitle = _('Filesmanager filters', "webapp.filesmanager");
			this.webapp.uiFilters = new UIElements.ApplicationMode.FullControl(
			{
				content : {
						name	: "UIElements.SelectList.SelectListControl",
						params  : {
							arrItems : webapp.filesmanager.data.getFiltersList(),
							boolMultiselect: true,
							itemCallback: dojo.hitch(webapp.filesmanager.data, webapp.filesmanager.data.toggleFilter)
						}
					},
				objTitle : {
					strLabel: strTitle
				}
			}, this.domFiltersContent);
			this.inherited(arguments);
		},

		back : function() {
			if(webapp.filesmanager.data.getCurrentFilters().length == 0){
				this.webapp.openPopup("error", _("Please select at least one filter", "webapp.filesmanager"));
			}
			else{
				ICTouchAPI.transitionServices.getScreen({
					name: "webapp.filesmanager.getFilesManager",
					params: {}
				});
				webapp.filesmanager.data.refreshIfNewFilters();
			}
		}

	}
);
