dojo.provide("webapp.filesmanager.getFilesManagerFileBase");
dojo.declare("webapp.filesmanager.getFilesManagerFileBase",
	[ICTouchAPI.webWidget, dojox.dtl._Templated],
	{
    strMediaPath : "",

    strImagePath : "",
	intIndex : 0,
    player :null,
	stopSubscribe : null,
	enableMPSubscribe : null,
	disableMPSubscribe : null,
	boolPlayed : null,

    constructor : function () {

	},

	postMixInProperties : function() {
		var data = webapp.filesmanager.data;
		this.strMediaPath = data.getCurrentElement().path;
		this.intIndex = data.getCurrentElement().intIndex;
		if(data.getCurrentType() === data.TYPE_PICTURE){
		   this.strImagePath = this.strMediaPath;
        }
		else{
		   this.strImagePath = null;
        }
	},

	postCreate:function(){
		var data = webapp.filesmanager.data;
		webapp.filesmanager.uiFile = this;
		// We set the Media path and the type
		var that = this;
		var func = function() { that.playPause() };

		// We initialize the Media UI, according to the type. Autoplay set to false.
        if(data.getCurrentType() === data.TYPE_AUDIO) // Audio
        {
            this.player = new UIElements.Media.Audio(
            {
				intSliderX					: this.intSliderX,
				intSliderY					: this.intSliderY,
				intSliderWidth				: this.intSliderWidth,
				boolCanPause				: false,
				intMediaDuration			: 1000,
				boolSeekable				: false,
				strMediaPath				: "webapp/filesmanager/themes/Default/images/avatar_audiofile_200.png",
				clbkPlay					: function(){},
				clbkPause					: function(){},
				boolShowSliderButton		: false,
				boolIconOnSliderButton		: false
				//clbkPlay					: func,
				//clbkPause					: func

            }, this.domFileContent);
            webapp.filesmanager.player = this.player;
        }
        else if(data.getCurrentType() === data.TYPE_VIDEO) // Video
        {
            this.player  = new UIElements.Media.Video(
            {
				intVideoWidth				: this.intAreaWidth,
				intVideoHeight				: this.intAreaHeight,

				intVideoX					: this.intAreaX,
				intVideoY					: this.intAreaY,

				intSliderX					: this.intSliderX,
				intSliderY					: this.intSliderY,
				intSliderWidth				: this.intSliderWidth,

				clbkPlay					: func,
				clbkPause					: func

            }, this.domFileContent);
            webapp.filesmanager.player = this.player;
        }
		else if(data.getCurrentType() === data.TYPE_WEBRADIO) // Web radio
        {
            this.player = new UIElements.Media.Audio(
            {
				intSliderX					: this.intSliderX + 225,
				intSliderY					: this.intSliderY,
				intSliderWidth				: 45, // There is no real slider for a web radio
				boolShowSliderTime			: false,

				clbkPlay					: func,
				clbkPause					: func

            }, this.domFileContent);
            webapp.filesmanager.player = this.player;
        }
        else if(data.getCurrentType() === data.TYPE_WEBTV) // Web tv
        {
            this.player  = new UIElements.Media.Video(
            {
				intVideoWidth				: this.intAreaWidth,
				intVideoHeight				: this.intAreaHeight,

				intVideoX					: this.intAreaX,
				intVideoY					: this.intAreaY,

				intSliderX					: this.intSliderX,
				intSliderY					: this.intSliderY,
				intSliderWidth				: 45, // There is no real slider for a web tv
				boolShowSliderTime			: false,

				clbkPlay					: func,
				clbkPause					: func

            }, this.domFileContent);
            webapp.filesmanager.player = this.player;
        }
        else if(data.getCurrentType() === data.TYPE_PICTURE) // image
        {
            // nothing more to do
            webapp.filesmanager.player = null;
        }

		// start the mediaplayer
		if(data.getCurrentType() === data.TYPE_AUDIO || data.getCurrentType() === data.TYPE_WEBRADIO) {
			//Enable or disable player depending on capabilities
			if(data.getMediaCapability()) {
				this.enablePlayer();
			}
			else {
				this.disablePlayer();
			}
			//Hide stop button if media not play
			var appBar = ICTouchAPI.AppBarServices.getAppBar("filesmanager", "filesmanagerstatus"+data.STATUS_PLAY);
			if (!data.boolMediaPlayerIsPlaying) {
				appBar.getButton(data.STOP).greyTint();
				appBar.getButton(data.PLAY).show();
				appBar.getButton(data.PAUSE).hide();
			}
			else {
				appBar.getButton(data.STOP).show();
				appBar.getButton(data.PLAY).hide();
				appBar.getButton(data.PAUSE).show();
			}
			//Subscribe
			this.enableMPSubscribe =  dojo.subscribe('filesmanager/MediaPlayerEnabled', null ,function(){
				that.enablePlayer();
			});
			this.disableMPSubscribe =  dojo.subscribe('filesmanager/MediaPlayerDisabled', null ,function(){
				that.disablePlayer();
			});
			this.playedSubscribe =  dojo.subscribe('filesmanager/MediaPlayerPlayed', null ,function(){
				var appBar = ICTouchAPI.AppBarServices.getAppBar("filesmanager", "filesmanagerstatus"+data.STATUS_PLAY);
				appBar.getButton(data.STOP).show();
			});
			this.stoppedMPSubscribe =  dojo.subscribe('filesmanager/MediaPlayerFinished', null ,function(){
                webapp.filesmanager.boolPlayed = false;
				this.boolPlayed = false;
				var appBar = ICTouchAPI.AppBarServices.getAppBar("filesmanager", "filesmanagerstatus"+data.STATUS_PLAY);
				appBar.getButton(data.STOP).greyTint();
			});
			if(!data.boolPlayList) { //if not playlist mode
				if(data.boolMediaPlayerIsPlaying) {
					//if selected file is different from played file, stop played file and launch selected file
					if(data.currentIdFilePlayed === data.getCurrentElement().intIndex) {
						ICTouchAPI.APIServices.IctMPInterface.getMediaSessionInfos({context:this, callback:function(args){
							webapp.filesmanager.mediaSessionInfosReceived(args);
						}});
						this.resetAfterMPStopped();
					}
 					else {
						this.subscribeToStopMP();
						ICTouchAPI.APIServices.IctMPInterface.stopMP({params:[data.previousElement.intIndex]});
					}
				} else {
					this.launch();
				}
			}
			else {
				this.subscribeToStopPlayList();
				data.stopPlayList();
			}
		}
	},

	subscribeToStopMP : function() {
		var that = this;
		var dojoSubs = dojo.subscribe('filesmanager/MediaPlayerFinished', null ,function(){
			that.launch();
			dojo.unsubscribe(dojoSubs);
		});
	},

	subscribeToStopPlayList : function() {
		var dojoSubs = dojo.subscribe('filesmanager/MediaPlayerStopped', this ,function(){
			this.boolPlayed = false;
			this.launch();
			dojo.unsubscribe(dojoSubs);
		});
	},

	resetAfterMPStopped : function() {
		//Reset the media UI after the media stop
		if(this.stopSubscribe) {
			dojo.unsubscribe(this.stopSubscribe);
		}
		this.stopSubscribe = dojo.subscribe('filesmanager/MediaPlayerStopped', this ,function(){
			this.boolPlayed = false;
			dojo.unsubscribe(this.stopSubscribe);
			this.resetMediaBar();
		});
	},


	// Function that play or pause the mediaplayer and the media UI
	playPause : function() {
		var data = webapp.filesmanager.data;

        if(webapp.filesmanager.boolPlayed == true)
            this.boolPlayed = true;

		if(data._mediaUIEnabled===true) {
			if(this.boolPlayed===true) {
				if(data.boolPlayList) { // If in playlist mode (means the mediaplayer isn't launched yet), we stop the playlist and launch the mediaplayer
					this.subscribeToStopMP();
					data.stopPlayList();
				} else if(data.boolMediaPlayerIsPlaying) { // if not in playlist mode, we just pause or play
					ICTouchAPI.APIServices.IctMPInterface.playPauseMP({params: [this.intIndex]}); // core function
				}
			}
			else {
				this.launch();
			}
		}
	},

	// Launch the mediaplayer
	launch : function() {
		//TODO : Modify params (loop, volume, index)
		//[fileId,filePath,x,y,width,height,volume, loopPlay, index(milliseconds)]
		var data = webapp.filesmanager.data;
		var fm = webapp.filesmanager;
		var that = this;
		if(!fm.data.boolMPLaunching && data.getMediaCapability()) {
			fm.data.boolMPLaunching = true;
			this.boolPlayed = true;
			var notif = null;
			if (data.getCurrentType() === data.TYPE_AUDIO) {
				notif ={strNotificationName: "play", strNotificationLabel: _("Media", "webapp.filesmanager"), intNotificationValue: 1, callback : function(){
					webapp.filesmanager.openCategory(fm.data.TYPE_AUDIO);
                    webapp.filesmanager.boolPlayed = true;
					fm.gotFileForPK([fm.data.getCurrentElement()]);
				}};
				ICTouchAPI.APIServices.IctMPInterface.playMedia({params: [this.intIndex,this.strMediaPath]}); // core function
			}
			this.resetAfterMPStopped();
			data.clearPlayNotifs();
			data.addPlayNotif(notif);
		}
		else {
			this.boolPlayed = false;
		}
	},

	resetMediaBar : function() {
		if(this.player) {
			this.player.mediaPause();
			this.player.setToTime(0);
		}
	},

	enablePlayer : function() {

	},

	disablePlayer : function() {

	},


    destroy : function(){
		if(this.stoppedSubscribe) {
			dojo.unsubscribe(this.stoppedSubscribe);
		}
		if(this.playedSubscribe) {
			dojo.unsubscribe(this.playedSubscribe);
		}
		if(this.stopSubscribe) {
		dojo.unsubscribe(this.stopSubscribe);
		}
		if(this.enableMPSubscribe) {
			dojo.unsubscribe(this.enableMPSubscribe);
		}
		if(this.disableMPSubscribe) {
			dojo.unsubscribe(this.disableMPSubscribe);
		}
		if(this.stoppedMPSubscribe){
			dojo.unsubscribe(this.stoppedMPSubscribe);
		}
		if (this.player) {
			this.player.destroy();
		}
		if(webapp.filesmanager.player){
			webapp.filesmanager.player.destroy();
		}
        this.inherited(arguments);
    }
});
