dojo.require("webapp.filesmanager.getFilesManagerBase");
dojo.provide("webapp.filesmanager.getFilesManager");
dojo.declare("webapp.filesmanager.getFilesManager",
	webapp.filesmanager.getFilesManagerBase,
	{
		templatePath: dojo.moduleUrl("webapp.filesmanager","templates/getFilesManager8082.html"),
		objContent : {},
        managerContainer    : null,

		postCreate:function(){
			var data = webapp.filesmanager.data;
			this.initVariables();
			this.managerContainer = new UIElements.ApplicationMode.ThirdControl(
			{
				menu : {
					name    : "UIElements.MenuList.MenuListControl",
					params  : {
						arrItems: webapp.filesmanager.data.getFilesManagerListContent(),
						autoSelectFirst : true,
						callback: dojo.hitch(webapp.filesmanager.data, webapp.filesmanager.data.onClickCategory)
					}
				},

				container : this.objContent,
				objContainerTitle : {strLabel : data.getFilesManagerContainerTitle()},
				objMenuTitle : {strLabel : data.getFilesManagerListTitle()}
			},this.mainPart);
			this.container = this.managerContainer.getContainer();
			this.menu = this.managerContainer.getMenu();
			webapp.filesmanager.mainWidget = this;
			webapp.filesmanager.filesmanagerList = this.managerContainer.getMenu();
			webapp.filesmanager.data.objListUI = this.menu.getContent();
			data.updateAppBar(data.STATUS_NONE);
			// data.objListUI.selectItemByIndex(data.getCurrentType(), true);
			// data.switchContainer("getFilesManagerFileList", data.STATUS_LIST, data.getFilesManagerContainerTitle());
		},

		initVariables : function (params) {
			this.objContent = {};
			var data = webapp.filesmanager.data;
			var arrListData = null;
			var funcCallback = null;
			switch (webapp.filesmanager.data.getContainerPath())
			{
				case "webapp.filesmanager.getFilesManagerFileList" :
					arrListData = data.getFilesManagerContainerContent();
					funcCallback = dojo.hitch(webapp.filesmanager, webapp.filesmanager.onClickMediaList);
					break;
				case "webapp.filesmanager.getFilters" :
					arrListData = data.getFilterList();
					funcCallback = dojo.hitch(webapp.filesmanager.data, webapp.filesmanager.data.setFilters);
					break;
				default :
					arrListData = [];
					funcCallback = null;
					break;
			}
			if( !arrListData) {
				arrListData = [];
			}
			var boolMultiselect = false;
			switch (webapp.filesmanager.data.getContainerPath())
			{
				case "webapp.filesmanager.getFilters" :
					boolMultiselect = true;
                    //break;
				case "webapp.filesmanager.getFilesManagerFileList" :
					this.objContent = {
						name : "UIElements.SelectList.SelectListControl",
						params : {
							arrItems: arrListData,
							boolMultiselect: boolMultiselect,
							itemCallback : funcCallback,
							showEmptyState: true,
							emptyText: _("No files", "webapp.filesmanager")
						}
					};
					break;
				default :
					var tmpParams = params? params : {};
					this.objContent = {
						name: data.getContainerPath(),
						params: tmpParams
					};
					break;
			}
		},

		// Reload the Menu
		reloadMenu: function(params) {
			var data = webapp.filesmanager.data;
			this.menu.reload({
                objTitle: {strLabel : data.getFilesManagerListTitle()},
                objContent: {
                    name    : "UIElements.MenuList.MenuListControl",
					params  : {
						arrItems: data.getFilesManagerListContent(),
						autoSelectFirst : true,
						callback: dojo.hitch(data, data.onClickCategory)
					}
                }
            });
			webapp.filesmanager.data.objListUI = this.menu.getContent();
		},



		selectFile : function(intFileIndex) {
			if(webapp.filesmanager.data.getContainerPath()==="webapp.filesmanager.getFilesManagerFileList") {
				var arrItems = this.container.getContent().arrItems;
				var iMax = arrItems.length;
				for(var i=0; i<iMax; i++) {
					if(arrItems[i].intIndex === intFileIndex) {
                                                // change title according to file played
                                                this.container.getTitle().changeTitle(arrItems[i].name);
						this.container.getContent().selectAtIndex(i);
						return true;
					}
				}
			}
			return false;
		},

		unselectFile : function(intFileIndex) {
			if(webapp.filesmanager.data.getContainerPath()==="webapp.filesmanager.getFilesManagerFileList") {
				var arrItems = this.container.getContent().arrItems;
				var iMax = arrItems.length;
				for(var i=0; i<iMax; i++) {
					if(arrItems[i].intIndex === intFileIndex) {
						this.container.getContent().unselectAtIndex(i);
						return true;
					}
				}
			}
			return false;
		},

		selectAllFile : function() {
			if(webapp.filesmanager.data.getContainerPath()==="webapp.filesmanager.getFilesManagerFileList") {
				this.container.getContent().selectAll();
				return true;
			}
			return false;
		},

		unselectAllFile : function() {
			if(webapp.filesmanager.data.getContainerPath()==="webapp.filesmanager.getFilesManagerFileList") {
				this.container.getContent().unselectAll();
				return true;
			}
			return false;
		},



        destroy : function(){
            this.managerContainer.destroy();
            this.inherited(arguments);
        }

    }
);
