dojo.provide("webapp.filesmanager.dataBase");
dojo.declare("webapp.filesmanager.dataBase", null, {

    _arrAppButtons	: [],
    _arrSysButtons	: [],
	_mediaUIEnabled	: true,
	isFileChanged	: false,

	// External UIs
	objListUI : null,

	// Modes
	boolFilterMode			: false,
	boolDeleteMode          : false,
	boolShuffle             : false,
	boolIsInScreenSaverPool	: false,
	boolPlayList			: false,
	boolMediaPlayerIsPlaying: false,
	boolMPLaunching			: false,
	intCurrentPlayed		: 0,
	currentIdFilePlayed		: null,
	intPlayStatus			: 0,
	_boolTelephonyRunning	: false,
	_boolMPCapabilityEnable	: true,
	_boolPreviewPlaying	: false,

	objFiltersContainer			: null,

	// List of status for the appBar
    STATUS_LIST		: 0,
    STATUS_PLAY		: 1,
    STATUS_FILTERS	: 2,
	STATUS_NONE		: 3,
    NB_STATUS       : 4,

	DEVICE_USERSPACE: 0,
	DEVICE_USB		: 1,

    _arrTypeList	: [],
	_arrFilterList	: [], // list of filters to display
	_arrFilterInSetting : [],
	_arrFileList	: [],
	_arrDeviceList	: [],
	_arrNotifs		: [],

	_arrScreensaverPoolFiles : [],

    _currentCategory: "",
    _currentElement	: null,
	previousElement : null,
	DEVICE			: "Device",


	// Different Types for the appBar
	TYPE_AUDIO      : "Audio",
	TYPE_VIDEO		: "Video",
	TYPE_PICTURE	: "Picture",
	TYPE_WEBRADIO	: "Web Radio",
	TYPE_WEBTV		: "Webtv",
	TYPE_BOOKMARKS	: "Bookmark",

	// Status Icons for appButtons
	STATUS_ON_ICON          : 'notif-on',
	STATUS_OFF_ICON         : 'notif-off',

	// Variables containing paths and titles
	FILE_LIST_WIDGET					: "getFilesManagerFileList",
	FILE_WIDGET							: "getFilesManagerFile",
	TYPE_LIST_WIDGET					: "getFilesManagerList",
	FILTERS_WIDGET						: "getFilters",
	WEBAPP_PATH							: "webapp.filesmanager",
    strFilesManagerListTitle            : _('My files ShortTtl','webapp.filesmanager'),
	strFilesManagerContainerTitle       : "Title",
	_strContainerPath					: "",

	// Constant values for the button's name sorted by widget
	// Files list
	FILTERS			: "FILTERS_BTN",
	DELETE			: "DELETE_BTN",
	PLAY_ALL		: "PLAY_ALL_BTN",
	STOP_ALL		: "STOP_ALL_BTN",
	NEXT			: "NEXT_BTN",
	SHUFFLE			: "SHUFFLE_BTN",

	// File
	PLAY			: "PLAY_BTN", // Added for MR
	SSPOOL          : "SSPOOL_BTN",
	SET_BACKGROUND	: "SET_BACKGROUND_BTN",
	SET_USER_PICTURE	: "SET_USER_PICTURE_BTN",
	// "Set Ringing" button will be used in a futur release
	//SET_RINGING		: "SET_RINGING_BTN",
	COPY			: "COPY_BTN",
	STOP			: "STOP_BTN",
	PAUSE			: "PAUSE_BTN",

	// Filters
	SELECT_ALL		: "SELECT_ALL_BTN",
	DESELECT_ALL	: "DESELECT_ALL_BTN",

	// Link popup (or not ?)
	CANCEL			: "CANCEL_BTN",
	OK				: "OK_BTN",

	// Everywhere :)
	BACK			: "BACK_BTN",

	//playStatus
	STOP_STATUS		: 0,
	PLAY_STATUS		: 1,
	PAUSE_STATUS	: 2,

	//_currentSize : 0,
    _maxSize : 200,
    _boolDeletable  : false,
	strUserBackgroundPicture : "",
	strUserPicture : "",

	constructor : function(){
		this.populateFields();
		this.loadList();
		this._arrFilterList = [
			{
				intIndex : this.DEVICE_USERSPACE,
				strLabel : _("Show files stored in the phone", "webapp.filesmanager"),
				enabled : true,
				icon : "filesmanager_filter-userspace"
			},
			{
				intIndex : this.DEVICE_USB,
				strLabel : _("Show files stored in the connected USB device", "webapp.filesmanager"),
				enabled : true,
				icon : "filesmanager_filter-usb"
			}
		];
	},

	populateFields : function(){
        // definition of buttons
        var func = dojo.hitch( webapp.filesmanager, webapp.filesmanager.buttonCallback);
		var arrButtons = [];
	    arrButtons.push({strButtonName: this.FILTERS,       strButtonLabel: _('Filter','ICTouchAPI'),      strButtonIcon: 'generic-filter',       callback: func});
	    arrButtons.push({strButtonName: this.DELETE, strButtonLabel: _('Delete','ICTouchAPI'), strButtonIcon: 'generic-mode-delete', callback: func, strStatusIcon: this.STATUS_OFF_ICON});
	    arrButtons.push({strButtonName: this.PLAY_ALL, 		strButtonLabel: _('Play all',"webapp.filesmanager"),     strButtonIcon: 'filesmanager-play-all',         callback: func});
	    arrButtons.push({strButtonName: this.STOP_ALL, 		strButtonLabel: _('Stop all',"webapp.filesmanager"),     strButtonIcon: 'filesmanager-stop',         callback: func});
	    arrButtons.push({strButtonName: this.NEXT, 			strButtonLabel: _('Next',"webapp.filesmanager"),         strButtonIcon: 'filesmanager-next',             callback: func});
	    arrButtons.push({strButtonName: this.SHUFFLE, 		strButtonLabel: _('Shuffle',"webapp.filesmanager"),      strButtonIcon: 'filesmanager-shuffle',          callback: func,	strStatusIcon: this.STATUS_OFF_ICON});
        this._arrAppButtons[this.STATUS_LIST] = arrButtons;

        arrButtons = [];
	    arrButtons.push({strButtonName: this.PLAY,          strButtonLabel: _('Play',"webapp.filesmanager"),         strButtonIcon: 'filesmanager-play',		callback: func});
		arrButtons.push({strButtonName: this.PAUSE,          strButtonLabel: _('Pause',"webapp.filesmanager"),         strButtonIcon: 'filesmanager-pause',		callback: func});
		arrButtons.push({strButtonName: this.STOP,          strButtonLabel: _('Stop',"webapp.filesmanager"),         strButtonIcon: 'filesmanager-stop',			callback: func});
	    arrButtons.push({strButtonName: this.SSPOOL,        strButtonLabel: _('Add to SsPool',"webapp.filesmanager"),   strButtonIcon: 'screensaver-application',      callback: func, strStatusIcon: this.STATUS_OFF_ICON});
	    arrButtons.push({strButtonName: this.SET_BACKGROUND,    strButtonLabel: _('Set background',"webapp.filesmanager"),       strButtonIcon: 'filesmanager-set-as-background',        callback: func});
		arrButtons.push({strButtonName: this.SET_USER_PICTURE,  strButtonLabel: _('Set user picture',"webapp.filesmanager"),     strButtonIcon: 'filesmanager-user-photo-avatars',          callback: func});
        // "Set Ringing" button will be used in a futur release
		//arrButtons.push({strButtonName: this.SET_RINGING,       strButtonLabel: _('Set ringing',"webapp.filesmanager"),      strButtonIcon: 'filesmanager-set-ringing',              callback: func});
        arrButtons.push({strButtonName: this.COPY,              strButtonLabel: _('Copy',"webapp.filesmanager"),         strButtonIcon: 'filesmanager-copy-files',               callback: func});
        this._arrAppButtons[this.STATUS_PLAY] = arrButtons;

		arrButtons = [];
	    arrButtons.push({strButtonName: this.SELECT_ALL,    strButtonLabel: _('Select all',"webapp.filesmanager"),       strButtonIcon: 'filesmanager-select-all',       callback: func});
	    arrButtons.push({strButtonName: this.DESELECT_ALL,  strButtonLabel: _('Deselect all',"webapp.filesmanager"),     strButtonIcon: 'filesmanager-unselect-all',     callback: func});
	    this._arrAppButtons[this.STATUS_FILTERS] = arrButtons;

		this._arrAppButtons[this.STATUS_NONE] = [];
		// We register every appBar
		for (var j = 0; j < this.NB_STATUS; j++) {
            var appBar = ICTouchAPI.AppBarServices.getAppBar("filesmanager", "filesmanagerstatus" + j);
             for (var k in this._arrAppButtons[j]) {
                var objButton = new UIElements.AppButton.AppButtonControl(this._arrAppButtons[j][k]);
                appBar.addActionButton(objButton);
            }
        }
		ICTouchAPI.APIServices.FileManager.getPoolSize({params:[ICTouchAPI.tools.POOL_SS], context:this, callback:this._gotScreensaverPoolSize});
	},

	_gotScreensaverPoolSize : function(size){
		ICTouchAPI.APIServices.FileManager.getFilesInPool({params:[ICTouchAPI.tools.POOL_SS, 0, size], context:this, callback:this._gotFilesInScreensaverPool});
	},

	_gotFilesInScreensaverPool : function(arr){
		for(var i=0;i<arr.length;i++){
			this._arrScreensaverPoolFiles.push(arr[i].url);
		}
	},

	addFileInScreensaverPool : function(file){
		this._arrScreensaverPoolFiles.push(file);
	},

	removeFileInScreensaverPool : function(file){
		for(var i=0;i<this._arrScreensaverPoolFiles.length;i++){
			if (this._arrScreensaverPoolFiles[i] == file){
				this._arrScreensaverPoolFiles.splice(i,1);
			}
		}
	},

	getScreensaverPoolFiles : function(){
		return this._arrScreensaverPoolFiles;
	},

	getFilesManagerListTitle : function() {
		return this.strFilesManagerListTitle;
	},

	getFilesManagerContainerTitle : function() {
		return this.strFilesManagerContainerTitle;
	},

	// media Types
	getFilesManagerListContent : function() {
        return this._arrTypeList;
	},

	getFilesManagerContainerContent : function() {
        return this._arrFileList;
	},

	getContainerPath : function(){
        return this._strContainerPath;
    },

	getCurrentElement : function(){
        return this._currentElement;
    },

	setCurrentElement : function(elem){
        this._currentElement = elem;
		//this.intCurrentPlayed = elem.intIndex;
    },

	getFilters : function(strCategory) {
		if(this._arrFilters[strCategory]){
			return this._arrFilters[strCategory];
        }
		else{
			return [];
        }
	},

	setFilters : function(magicNumber) {
		var found = false;
		var category = this.getCurrentType();
		if(this._arrFilters[category]!==undefined) {
			for(var i=0; i < this._arrFilters[category].length; i++) {
				if(this._arrFilters[category][i] === magicNumber) {
					this._arrFilters[category].splice(i,1);
					found = true;
				}
			}

			if(!found){
				this._arrFilters[category].push(magicNumber);
			}
		} else {
			this._arrFilters[category] = [];
			this._arrFilters[category].push(magicNumber);
		}
	},

	getUserBackgroundPicture : function() {
		return this.strUserBackgroundPicture;
	},

	setUserBackgroundPicture : function(strPicture) {
		this.strUserBackgroundPicture = strPicture;
		// if we are on status play, recompute appBar
		if(webapp.filesmanager.currentStatus == this.STATUS_PLAY){
			this.formatAppBar(this.STATUS_PLAY);
		}
	},

	getUserPicture : function() {
		return this.strUserPicture;
	},

	setUserPicture : function(strPicture) {
		this.strUserPicture = strPicture;
		// if we are on status play, recompute appBar
		if(webapp.filesmanager.currentStatus == this.STATUS_PLAY){
			this.formatAppBar(this.STATUS_PLAY);
		}
	},

	getNotifs : function() {
		return this._arrNotifs;
	},

	getCategoryByName : function(strName) {
		var list = this.getFilesManagerListContent();
		for(var i=0;i<list.length;i++) {
			if(list[i].category === strName)
			{
				return list[i];
			}
		}
		return null;
	},

	getCategoryById : function(intId) {
		var list = this.getFilesManagerListContent();
		for(var i=0;i<list.length;i++) {
			if(list[i].intIndex === intId)
			{
				return list[i].category;
			}
		}
		return null;
	},

	getElementById : function (intId) {
		var list = this.getFilesManagerContainerContent();
		for(var i=0;i<list.length;i++) {
			if(list[i].intIndex === intId)
			{
				return list[i];
			}
		}
		return null;
	},

    getCurrentType : function () {
        return this._currentCategory;
    },

	setCurrentType : function(strCategory) {
		this._currentCategory = strCategory;
	},

	// Function that stop every playlist
	stopPlayList : function(status) {
		if(this.boolPlayList) {
			this.boolPlayList = false;
			ICTouchAPI.APIServices.IctMPInterface.stopMP({params: [this.currentIdFilePlayed]});
			this.clearPlayNotifs();
		}
	},

	stop : function() {
		ICTouchAPI.APIServices.IctMPInterface.stopMP({params: [this._currentElement.intIndex]});
		this.clearPlayNotifs();
	},

	// Add a notification to the array and on the interface
	addPlayNotif : function(objNotif) {
		objNotif.strNotificationName += this.getNotifs().length;
		ICTouchAPI.notificationServices.addNotification(objNotif);
		this._arrNotifs.push(objNotif);
	},

	// Remove every notification about play and clear the array
	clearPlayNotifs : function(strType) {

		for(var i = 0; i<this.getNotifs().length;i++)
		{
			ICTouchAPI.notificationServices.removeNotification(this.getNotifs()[i].strNotificationName);
		}
		this._arrNotifs = [];
	},

    setFilesManagerContainerContent : function(intTypeId) {
        // through the type list, check for the id
        for(var i=0;i<this._arrTypeList.length;i++)
        {
            if(this._arrTypeList[i].intIndex === intTypeId)
            {
                this.strFilesManagerContainerTitle = this._arrTypeList[i].category;
                break;
            }
        }
    },

    loadList : function() {
        // get events medias type
        ICTouchAPI.APIServices.FileManager.getAllFileCategories({params:[1, 2], context:this, callback:this.loadedList});
    },

    loadedList : function (args) {
        var arrList = args;
        this._arrTypeList = [];

        // load elements
		if(this.boolFilterMode){
			this._arrTypeList.push({strType: "normal", intIndex: -1, category: this.DEVICE, strPrimaryContent: _(this.DEVICE,"webapp.filesmanager")});
		}
        for(var i=0; i < arrList.length; i++) {

            this._arrTypeList.push({strType: "normal", intIndex: arrList[i].idFileCategory, category: arrList[i].categoryName, strPrimaryContent: _(arrList[i].categoryName,"webapp.filesmanager")});
        }
		if(webapp.filesmanager.mainWidget) {
			webapp.filesmanager.mainWidget.reloadMenu();
			if(this.boolFilterMode){
				this.onClickCategory(-1);
            }
			else if(this._arrTypeList[0]){
				this.onClickCategory(this._arrTypeList[0].intIndex);
            }
			else{
				this.updateAppBar(this.STATUS_NONE);
            }
		}
    },

	onClickCategory : function(intMediaTypeId) {
		//Set the current Category
		this.setCurrentType(this.getCategoryById(intMediaTypeId));
        // set the title
        this.setFilesManagerContainerContent(intMediaTypeId);
		//show the list of files, but first get the number of files for the categroy selected
		ICTouchAPI.APIServices.FileManager.getFilesInCategorySize({context: this, params: [this.getCurrentType()], callback: this.loadFileList});
	},

	loadFileList : function(intSize,params) {
		this.isFileChanged = false;
		if (intSize) {
			//this._currentSize = intSize;
			if(!this._arrFilterInSetting.length){
				 ICTouchAPI.settingServices.getSetting("FilesManagerFilter", this, this.filtersLoaded, params);
			}
			else{
				this.filtersLoaded(null,params);
			}
        } else {
			// If we don't have a size, or if it is 0, just reload the 2/3 with an empty array (white screen)
			this.loadedFileList([],params);
		}
	},

	filtersLoaded : function(filterList,params){
		if(filterList){
			this._arrFilterInSetting = filterList.jsValue.split(";");
		}
		if(this._arrFilterInSetting.length == this._arrFilterList.length || !this._arrFilterInSetting.length){
            ICTouchAPI.APIServices.FileManager.getFileDescriptions({params:[this.getCurrentType(), 0, this._maxSize], context:this, callback:this.loadedFileList, callbackParams:params});
		}
		else{
			ICTouchAPI.APIServices.FileManager.getExtensions({params:[this.getCurrentType()], context:this, callback:this.loadFilesWithFilter});
		}
	},

	loadFilesWithFilter : function(strList){
		ICTouchAPI.APIServices.FileManager.getFilesWithFilter({params:[this.getCurrentType(), 0, this._maxSize,strList, this._arrFilterInSetting.join(";")], context:this, callback:this.loadedFileList}) ;
	},

    loadedFilterList : function (strList) {
		var arrList;
        if(strList){
			arrList = strList.split(";");
        }
		this._arrFilterList = [];
		if(this.getCurrentType()===this.DEVICE) {
			this._arrFilterList.push({intIndex : ""+this.DEVICE_USERSPACE, strLabel : _("USERSPACE", "webapp.filesmanager"), boolSelected : this.isFiltered(""+this.DEVICE_USERSPACE)});
			this._arrFilterList.push({intIndex : ""+this.DEVICE_USB, strLabel : _("USB", "webapp.filesmanager"), boolSelected : this.isFiltered(""+this.DEVICE_USB)});
		} else {
			if(arrList) {
				if(arrList[0] !== ""){
					for(var i=0; i < arrList.length; i++) {
						var strLabel = arrList[i]; // TODO : i18n
						this._arrFilterList.push({
							intIndex: arrList[i],
							strLabel: strLabel,
							boolSelected: this.isFiltered(arrList[i])
						 });
					}
                }
			}
		}
		// Security to check if a magicNumber is filtered and doesn't exist in database.
		this.checkMagicNumberValidity();

        this.switchToFiltersView();
    },

	checkMagicNumberValidity : function() {
		var filterList = this.getFilterList();
		var filters = this.getFilters(this.getCurrentType());
		var found = false;
		for(var i in filters) {
			for(var j in filterList) {
				if(filters[i]===filterList[j].intIndex){
					found = true;
                }
			}
			if(!found) {
				this._arrFilterList.push({intIndex: filters[i], strLabel: filters[i], boolSelected: true});
			}
			found = false;
		}
	},

	getCurrentFilters : function() {
		var arrFilters = [];
		for (var i in this._arrFilterList){
			if(this._arrFilterList[i].enabled){
				arrFilters.push(this._arrFilterList[i].intIndex);
            }
		}
		return arrFilters;
	},

    loadedFileList : function (arrList,params) {
        this.storeFileList(arrList);
		this.switchToListView();
        if (this.boolDeleteMode && !this._boolDeletable) {
            this.setDeleteMode(false);
        }
    },

	storeFileList : function(arrFileList) {
		this._boolDeletable = false;
		if(arrFileList) {
			this._arrFileList = [];
			for(var i=0; i < arrFileList.length; i++)
			{
				var objFile = dojo.clone(arrFileList[i]);
				this.formatFileObject(objFile);
				if (objFile.intIndex === this.currentIdFilePlayed) {
					objFile.boolSelected = true;
				}
				this._arrFileList.push(objFile);
                if ((!this._boolDeletable) && (objFile.device=="USERSPACE")) {
                    this._boolDeletable = true;
				}
			}
		}
	},

	// Format the object as expected
	formatFileObject : function(objFile) {
		if(objFile.intIndex === undefined){
			objFile.intIndex = objFile.id;
        }
		delete objFile.id;
		objFile.type = this.getCurrentType();
		objFile.size = (objFile.size) ? objFile.size : null;
		objFile.device = (objFile.device) ? objFile.device : null;
		objFile.path = objFile.url;
		objFile.strCheckedIcon = "filesmanager-play-32";
		if (objFile.canOpen == 0) {
			objFile.additionalStyle = "unavailable";
		}
		//var strLabel = objFile.name + '    ' + ((objFile.size) ? objFile.size+'b ' : '    ') + '    ' + ((objFile.device=="USERSPACE") ? _("USERSPACE", "webapp.filesmanager") : _("USB", "webapp.filesmanager"));
		var device = "";
		if(objFile.device ==="USERSPACE" || objFile.device === "System"){
			device = objFile.device;
		} else {
			// when USB, the exact string is not "USB" but the identifier of the USB device.
			device = "USB";
		}
		var filesize = this.getSizeLabel(objFile.size)
		var strLabel = _([objFile.name,filesize,device],"webapp.filesmanager");
		objFile.strLabel = strLabel;
	},

	getSizeLabel : function(size){
		if (!size){
			return "";
		}

		var extTab = ["b","kb","Mb","Gb"];
		var extIndex = 0;
		//As long as the unit can be changed
		while (size/1024>=1){
			extIndex++;
			size = size / 1024;
		}
		var finalSize = size.toFixed(2);
		//Delete the useless 0 at the end of the number
		finalSize = finalSize.toString().replace(/0*$/,"");
		//delete the . if it is the last character
		if (finalSize[finalSize.length-1] == "."){
			finalSize = finalSize.replace(".","");
		}
		return finalSize+" "+extTab[extIndex];

	},


    switchToFileView : function () {
		this.strFilesManagerContainerTitle = this.getCurrentElement().name;
		this.isInPools();
        // change view
//      var params = {strMediaPath:this.getCurrentElement().path,intType:this.getCurrentElement().type};
    },

	switchedToFileView : function() {
		this.switchContainer(this.FILE_WIDGET, this.STATUS_PLAY, this.getFilesManagerContainerTitle());
	},

	// Sets the boolean "isInPool"
	isInPools : function() {
		var context = this;
		this.boolIsInScreenSaverPool = false;
		var currentType = this.getCurrentType();
		if(currentType == this.TYPE_PICTURE){
			ICTouchAPI.APIServices.FileManager.fileExistsInPool({params:[ICTouchAPI.tools.POOL_SS, context.getCurrentElement().intIndex], context:webapp.filesmanager, callback:webapp.filesmanager.errorManager, callbackParams:function(boolInPool) {
				context.boolIsInScreenSaverPool = (boolInPool===0)? false : true;
				context.switchedToFileView();
			}});
		}
		else {
			this.switchedToFileView();
		}
	},

    switchToListView : function () {
		this.strFilesManagerContainerTitle = this.getCurrentType();
        // set player to null
        if(webapp.filesmanager.player){
            webapp.filesmanager.player = null;
        }
        this.switchContainer(this.FILE_LIST_WIDGET, this.STATUS_LIST, this.getFilesManagerContainerTitle());
    },

	switchToFiltersView : function () {
        // set player to null
        if(webapp.filesmanager.player){
            webapp.filesmanager.player = null;
        }

        this.switchContainer(this.FILTERS_WIDGET, this.STATUS_FILTERS, this.getFilesManagerContainerTitle());
    },

	selectAllFilters : function() {
		this._arrFilters[this.getCurrentType()] = [];
		for(var i in this._arrFilterList) {
			this._arrFilterList[i].boolSelected = true;
			this._arrFilters[this.getCurrentType()].push(this._arrFilterList[i].intIndex);
		}
		webapp.filesmanager.mainWidget.reloadContainer();
	},

	deselectAllFilters : function() {
		this._arrFilters[this.getCurrentType()] = [];
		for(var i in this._arrFilterList){
			this._arrFilterList[i].boolSelected = false;
        }
		webapp.filesmanager.mainWidget.reloadContainer();
	},

	// Called to delete a selected File, or current File by default
    deleteElement : function(intId) {
		if(intId){
			this.setCurrentElement(this.getElementById(intId));
        }
		var currentElement = this.getCurrentElement();
        if(currentElement)
        {
            // confirmation popup
            var context = this;
            var strContent = _(["Delete the file", ":", currentElement.strLabel, "?"], "webapp.filesmanager");
            var popupDel = {
                 strTitle: _("Delete confirmation", "webapp.filesmanager"), strType: "warning", strContent: strContent,
                 arrPopupButtons: [
                     // {strButtonLabel: _('Yes', "ICTouchAPI"), callback : dojo.hitch(context, context._deleteCurrentElement)},
                     // {strButtonLabel: _('No', "ICTouchAPI"), callback : function(){ICTouchAPI.popupServices.removePopup(context.popupDel);}}
                     {strButtonName: "YES_BTN",
                           strButtonIcon: "generic-ok",
                           strButtonLabel: _('Yes', "ICTouchAPI"), callback : dojo.hitch(context, context._deleteCurrentElement)},
                     {strButtonName: "NO_BTN",
                        strButtonIcon: "generic-cancel",
                        strButtonLabel: _('No', "ICTouchAPI"), callback : function(){ICTouchAPI.popupServices.removePopup(context.popupDel);}}
                    ]
                };
		this.popupDel = ICTouchAPI.popupServices.addNewPopup(popupDel, "MEDIUM");
        }
    },

	// Callback of delete popup' button "yes"
    _deleteCurrentElement : function() {
        ICTouchAPI.popupServices.removePopup(this.popupDel);
		//this.setDeleteMode(false);
        // stop Playing
        if(webapp.filesmanager.player){
            webapp.filesmanager.player.destroy();
        }

		ICTouchAPI.APIServices.FileManager.deleteFile({params:[this.getCurrentElement().intIndex], context:webapp.filesmanager, callback:webapp.filesmanager.errorManager, callbackParams:dojo.hitch(this, this.refreshFileList)});
    },

	// Refresh the file list with the current Type
    refreshFileList : function() {
        this.onClickCategory(this.getCategoryByName(this.getCurrentType()).intIndex);
    },

	// Set the delete mode to "boolMode"
	setDeleteMode : function(boolMode) {
		this.boolDeleteMode = boolMode;
		var appBar = ICTouchAPI.AppBarServices.getAppBar("filesmanager","filesmanagerstatus"+this.STATUS_LIST);
		var deleteButton = appBar.getButton(this.DELETE);
		if(boolMode){
			deleteButton.setStatusIcon(this.STATUS_ON_ICON);
        }
		else{
			deleteButton.setStatusIcon(this.STATUS_OFF_ICON);
        }
	},

	// Set the shuffle mode and change the status icon
	setShuffleStatus : function() {
		this.boolShuffle = !this.boolShuffle;
		var appBar = ICTouchAPI.AppBarServices.getAppBar("filesmanager", "filesmanagerstatus"+this.STATUS_LIST);
		var shuffleButton;
        if(appBar){
			shuffleButton = appBar.getButton(this.SHUFFLE);
        }
		var strStatusIcon = (this.boolShuffle) ? this.STATUS_ON_ICON : this.STATUS_OFF_ICON;
		if(shuffleButton){
			shuffleButton.setStatusIcon(strStatusIcon);
        }
	},


	// set a new content for the container of the agenda and call an update of the appBar
	switchContainer: function(pageName, status, pageTitle, params) {
		//crms00245479 comment the next 2 lines
//		if(this.boolDeleteMode) // If we are in delete mode, we remove it
//			this.setDeleteMode(false);
		if(pageName !== ""){
			this._strContainerPath = "webapp.filesmanager."+pageName;
        }
		if(pageTitle){
			this.strFilesManagerContainerTitle = pageTitle;
        }
		if(status!== undefined) {
			this.updateAppBar(status);
		}
		if(webapp.filesmanager.mainWidget){
			webapp.filesmanager.mainWidget.reloadContainer(params);
        }
	},

	// set the action bar corresponding to the status
	updateAppBar: function(status) {
		// set the status
		webapp.filesmanager.currentStatus = status;

		// Create the static back button
		var backFunc = dojo.hitch( webapp.filesmanager, webapp.filesmanager.buttonCallback, this.BACK);
		ICTouchAPI.AppBarServices.addExitButton("filesmanager","filesmanagerstatus"+status,this.isPreviousHome(), backFunc);

		// Register action bars according to state
		this.formatAppBar(status);
		ICTouchAPI.AppBarServices.setAppBar("filesmanager","filesmanagerstatus"+status, "getFilesManager");
	},

	// Set the action bar buttons according to the type of files
	formatAppBar : function(status) {
		var appBar = ICTouchAPI.AppBarServices.getAppBar("filesmanager", "filesmanagerstatus"+status);

		var currentType = this.getCurrentType();

		var currentElement = this.getCurrentElement();

		// Manage audio type
		if (currentType == this.TYPE_AUDIO) {
			// Manage player buttons
			if (status === this.STATUS_LIST) {
				if(this.boolPlayList) {
					if(this.getMediaCapability()) {
						appBar.getButton(this.NEXT).show();
						appBar.getButton(this.SHUFFLE).show();
					}
					else { // no media capability
						appBar.getButton(this.NEXT).hide();
						appBar.getButton(this.PLAY_ALL).hide();
						appBar.getButton(this.SHUFFLE).hide();
					}
					if( this.intPlayStatus!==this.PLAY_STATUS) {
						if(this.getMediaCapability()) {
							appBar.getButton(this.PLAY_ALL).show();
						}
						appBar.getButton(this.STOP_ALL).hide();
					}
					else { // status playing
						appBar.getButton(this.PLAY_ALL).hide();
						appBar.getButton(this.STOP_ALL).show();
					}
				}
				else { // no playlist mode
					appBar.getButton(this.STOP_ALL).hide();
					appBar.getButton(this.NEXT).hide();
					appBar.getButton(this.SHUFFLE).hide();
					if(this.getMediaCapability()) {
						appBar.getButton(this.PLAY_ALL).show();
					}
					else { // no media capability
						appBar.getButton(this.PLAY_ALL).hide();
					}
                    if (!this._arrFileList.length) {
                        appBar.getButton(this.PLAY_ALL).hide();
                        appBar.getButton(this.SHUFFLE).hide();
				}
                    else {
                        appBar.getButton(this.PLAY_ALL).show();
                        appBar.getButton(this.SHUFFLE).show();
			}
                    if (!this._boolDeletable) {
                        appBar.getButton(this.DELETE).hide();
                    }
                    else {
                        appBar.getButton(this.DELETE).show();
                    }
				}
			} else if (status === this.STATUS_PLAY) {
				appBar.getButton(this.COPY).hide();
			}
		}
		else { // not type audio
			if (status === this.STATUS_LIST) {
				appBar.getButton(this.PLAY_ALL).hide();
				appBar.getButton(this.STOP_ALL).hide();
				appBar.getButton(this.NEXT).hide();
				appBar.getButton(this.SHUFFLE).hide();
                if (!this._boolDeletable) {
                    appBar.getButton(this.DELETE).hide();
				}
                else {
                    appBar.getButton(this.DELETE).show();
                }
			}
			else if (status === this.STATUS_PLAY) { // not in list mode
				appBar.getButton(this.PLAY).hide();
				appBar.getButton(this.PAUSE).hide();
				appBar.getButton(this.STOP).hide();
			}
		}
		// Manage picture type
		if (status === this.STATUS_PLAY) { // status play && not type audio
			if (currentType == this.TYPE_PICTURE) {
				appBar.getButton(this.STOP).hide();
				appBar.getButton(this.SET_BACKGROUND).show();
				appBar.getButton(this.SET_USER_PICTURE).show();
				// Manage buttons for USB files
				if(currentElement && currentElement.device != "USERSPACE" && currentElement.device != "System"){
					appBar.getButton(this.COPY).show();
					appBar.getButton(this.SSPOOL).hide();
				} else {
					appBar.getButton(this.COPY).hide();
					appBar.getButton(this.SSPOOL).show();
					if(this.boolIsInScreenSaverPool){
						appBar.getButton(this.SSPOOL).setStatusIcon(this.STATUS_ON_ICON);
					}
					else{
						appBar.getButton(this.SSPOOL).setStatusIcon(this.STATUS_OFF_ICON);
					}
				}
				// Manage set_background button
				var strOldBackgroundPicture = this.getUserBackgroundPicture();
				var strNewBackgroundPicture = this.getCurrentElement().path;
				if(strOldBackgroundPicture == strNewBackgroundPicture){
					appBar.getButton(this.SET_BACKGROUND).setStatusIcon(this.STATUS_ON_ICON);
				} else {
					appBar.getButton(this.SET_BACKGROUND).setStatusIcon(this.STATUS_OFF_ICON);
				}
				// Manage 'My picture' button
				var strOldUserPicture = this.getUserPicture();
				var strNewUserPicture = this.getCurrentElement().path;
				if(strOldUserPicture == strNewUserPicture){
					appBar.getButton(this.SET_USER_PICTURE).setStatusIcon(this.STATUS_ON_ICON);
				} else {
					appBar.getButton(this.SET_USER_PICTURE).setStatusIcon(this.STATUS_OFF_ICON);
				}
			}
 			else { // no picture type
 				appBar.getButton(this.STOP).show();
 				appBar.getButton(this.SET_BACKGROUND).hide();
 				appBar.getButton(this.SET_USER_PICTURE).hide();
				appBar.getButton(this.SSPOOL).hide();
 			}
 		}
	return appBar;
},

	isPreviousHome : function() {
		switch(this.getContainerPath()) {
			case this.WEBAPP_PATH+"."+this.FILE_WIDGET :
				return false;
				//break;
			case this.WEBAPP_PATH+"."+this.FILE_LIST_WIDGET :
				return true;
				//break;
			case this.WEBAPP_PATH+"."+this.FILTERS_WIDGET :
				return false;
				//break;
			default :
				return true;
				//break;
		}
	},

	//Return true if it's possible to play a media
	getMediaCapability : function() {
		return this._boolMPCapabilityEnable && !this._boolTelephonyRunning;
	},

	//Enable or disable media control element(appButton and slider)
	enableOrDisableMediaUI : function() {
		var appBar;
		var mediaCapability = this.getMediaCapability();
		if(mediaCapability!==this._mediaUIEnabled) {
			if(mediaCapability) {
				this._mediaUIEnabled = true;
				dojo.publish('filesmanager/MediaPlayerEnabled');
				appBar = ICTouchAPI.AppBarServices.getAppBar("filesmanager", "filesmanagerstatus"+this.STATUS_PLAY);
				if(this.boolMediaPlayerIsPlaying) {
					appBar.getButton(this.STOP).show();
					if(this.intPlayStatus===this.PLAY_STATUS) {
						appBar.getButton(this.PAUSE).show();
					}
					else {
						appBar.getButton(this.PLAY).show();
					}
				}
				else {
					appBar.getButton(this.PLAY).show();
				}
				appBar = ICTouchAPI.AppBarServices.getAppBar("filesmanager", "filesmanagerstatus"+this.STATUS_LIST);
				this.formatAppBar(this.STATUS_LIST);
			}
			else {
				this._mediaUIEnabled = false;
				dojo.publish('filesmanager/MediaPlayerDisabled');
				appBar = ICTouchAPI.AppBarServices.getAppBar("filesmanager", "filesmanagerstatus"+this.STATUS_PLAY);
				appBar.getButton(this.STOP).hide();
				appBar.getButton(this.PLAY).hide();
				appBar.getButton(this.PAUSE).hide();
				this.formatAppBar(this.STATUS_LIST);
				//appBar.getButton(this.STOP_ALL).hide();
			}
		}

	},

	toggleFilter : function(filterid){
		this._arrFilterList[filterid].enabled = !this._arrFilterList[filterid].enabled;
        if(this.getCurrentFilters().length == 0){
            var idx = (filterid == 0) ? 1 : 0;
            this._arrFilterList[idx].enabled = !this._arrFilterList[idx].enabled;
            webapp.filesmanager.uiFilters.getContent().getContent().selectAtIndex(idx);
        }
	},

	getFiltersList : function() {

		var arrItemsFilters = [];
		// create filter array for the selectList
		for (var i in this._arrFilterList) {
			arrItemsFilters.push({
				intIndex: this._arrFilterList[i].intIndex,
				boolSelected: !this._arrFilterInSetting.length || dojo.indexOf(this._arrFilterInSetting, this._arrFilterList[i].intIndex)!==-1,
				strSecondaryContentIcon : this._arrFilterList[i].icon,
				strLabel: this._arrFilterList[i].strLabel
			});
			this._arrFilterList[i].enabled = arrItemsFilters[i].boolSelected;
		}
		return arrItemsFilters;
	},

	refreshIfNewFilters : function(){
		var currentFilters = this.getCurrentFilters();
		var isNewFilter = false;
		if(currentFilters.length != this._arrFilterInSetting.length){
			isNewFilter = true;
		}
		else{
			for(var i in currentFilters){
				if(dojo.indexOf(this._arrFilterInSetting, currentFilters[i])==-1){
					isNewFilter = true;
					break;
				}
			}
		}
		if(isNewFilter){
			ICTouchAPI.settingServices.setSettingValue("FilesManagerFilter", currentFilters.join(";"), this);
		}
	},

	setPreviewPlaying : function(boolPreviewPlaying) {
	    this._boolPreviewPlaying = boolPreviewPlaying;
	},

	isPreviewPlaying : function() {
	    return this._boolPreviewPlaying;
	}

});
