dojo.provide("webapp.filesmanager.controlBase");
dojo.declare("webapp.filesmanager.controlBase",[ICTouchAPI.webApplication],
{

    currentStatus: 0,
	objAppBar: null,
        popup : null,
	uiFile : null,
	player : null,
	_clickHandler : null,
	strCategoryToOpen : "",
	strFileToOpen : "",

	uiFilters : null,
	uiScreensaver : null,

	screensaversView : "screensaverSlideshow",
    boolPlayed : false, // Boolean to determine if an audio file is playing

	constructor : function()
	{
		ICTouchAPI.skinServices.linkWebappsStyles("webapp.filesmanager","webapp.screensaver");
		ICTouchAPI.skinServices.linkWebappsStyles("UIElements.Keyboard","webapp.filesmanager", true, false, true, false);
		ICTouchAPI.tools.registerHomepageButton(["webapp.filesmanager.getFilesManager", "FILESMANAGER_BTN", "filesmanager-application", _("My files","webapp.filesmanager")]);
		ICTouchAPI.tools.registerHomepageKey(["webapp.filesmanager.getFilesManager", "FILESMANAGER_BTN", "filesmanager-application", _("My files","webapp.filesmanager"), null, function(){ICTouchAPI.transitionServices.getScreen({name: "webapp.filesmanager.getFilesManager", params:{}});}]);
        ICTouchAPI.eventServices.subscribeToEvent(this, "MPLoading", this.notifyPlayerLoading);
        ICTouchAPI.eventServices.subscribeToEvent(this, "MPStopped", this.notifyPlayerStopped);
        ICTouchAPI.eventServices.subscribeToEvent(this, "MPPlaying", this.notifyPlayerPlaying);
        ICTouchAPI.eventServices.subscribeToEvent(this, "MPBuffering", this.notifyPlayerBuffering);
        ICTouchAPI.eventServices.subscribeToEvent(this, "MPPaused", this.notifyPlayerPaused);
        ICTouchAPI.eventServices.subscribeToEvent(this, "MPError", this.notifyPlayerError);
        ICTouchAPI.eventServices.subscribeToEvent(this, "MPFinished", this.notifyPlayerFinished);
		ICTouchAPI.eventServices.subscribeToEvent(this, "MPState", this.notifyPlayerState);
        ICTouchAPI.eventServices.subscribeToEvent(this, "FILE_LIST_CHANGED", this.notifyFileListChanged);
        ICTouchAPI.eventServices.subscribeToEvent(this, "MediaSessionInfos", this.notifyMediaSessionInfosReceived);
//		ICTouchAPI.eventServices.subscribeToEvent(this, "CallStartedEvent", this.pausePlayer);
	},

	loaded: function() {
		ICTouchAPI.eventServices.subscribeToEvent(this, "TelephonyRunningEvent", this.notifyTelephonyRunningEvent);

		ICTouchAPI.settingServices.subscribeToSetting(this, "UserBackgroundPicture", this.onUserBackgroundPictureChanged);
		ICTouchAPI.settingServices.getSetting("UserBackgroundPicture", this, this.onUserBackgroundPictureChanged);

		ICTouchAPI.settingServices.subscribeToSetting(this, "UserPhoto", this.onUserPhotoChanged);
		ICTouchAPI.settingServices.getSetting("UserPhoto", this, this.onUserPhotoChanged);

	},

	load: function() {
		//help
		var widgetsTab = [];
		for(var i=0; i<webapp.filesmanager.data.NB_STATUS; i++) {
			widgetsTab.push("filesmanagerstatus"+i);
		}
		dojo.publish("needHelpEvent",["filesmanager",widgetsTab]);
		ICTouchAPI.settingServices.subscribeToSetting(this, "FilesManagerFilter", dojo.hitch(this.data, this.data.filtersLoaded));
	},

	onUserBackgroundPictureChanged : function(objSetting) {
		if(objSetting){
			this.data.setUserBackgroundPicture(objSetting.jsValue);
		}
	},

	onUserPhotoChanged : function(objSetting) {
		if(objSetting){
			this.data.setUserPicture(objSetting.jsValue);
		}
	},

	// Public functions

	// Go to the filesmanager webapp and open a category according to it's name
	openCategory : function(strName) {
        ICTouchAPI.transitionServices.getScreen({name: "webapp.filesmanager.getFilesManager", params:{}});
		if(strName != this.data.getCurrentType()){
			this.strCategoryToOpen = strName;
			this._openCategory();
		}
	},

	tryOpenCategoryOrFile : function(strCategoryName, strFileName){
		ICTouchAPI.transitionServices.getScreen({name: "webapp.filesmanager.getFilesManager", params:{}});
		this.strCategoryToOpen = strCategoryName;
		if(strFileName != ""){
			this.strFileToOpen = strFileName;
		}
		if(!this._clickHandler){
			this._clickHandler = dojo.subscribe("iframe.show", dojo.hitch(this, function(currentIframeId){
				if(currentIframeId == "webapp.filesmanager.getFilesManager"){
					this._openCategory();
					this._openFile();
				}
			}));
		}
	},

	_openCategory : function(){
		if(!isNaN(parseInt(this.strCategoryToOpen))){
				this.data.objListUI.selectItemByIndex(parseInt(this.strCategoryToOpen), true);
			}
			else{
				var category = webapp.filesmanager.data.getCategoryByName(this.strCategoryToOpen);
		if(category !== null){
				this.data.objListUI.selectItemByIndex(category.intIndex, true);
        }
		else{
			console.error("Error 404 : No category with this name");
        }
			}
			this.strCategoryToOpen = "";
	},

	_openFile : function(){
		if (this.strFileToOpen != "") {
		    ICTouchAPI.APIServices.FileManager.getFile({params:[this.strFileToOpen], context:this, callback:this.gotFileForPK});
			this.strFileToOpen = "";
		}
	},

	onScreensaverOn : function() {
		if(this.uiScreensaver!=null) {
			this.uiScreensaver.launchSlideshow();
		}
	},

	onScreensaverOff : function() {
		if(this.uiScreensaver!=null) {
			this.uiScreensaver.stopSlideshow();
		}
	},
	// End of public functions

    buttonCallback : function(buttonId) {
		var data = webapp.filesmanager.data;
		switch(buttonId)
		{
			case data.PAUSE :
			case data.PLAY :
				this.uiFile.playPause();
				break;
			case data.PLAY_ALL:
				if(!this.data.boolPlayList || this.data.intPlayStatus===this.data.STOP_STATUS) {
				data.clearPlayNotifs(); // For all MediaPlayer Notifs
				var that = this;
        		var notif ={strNotificationName: "play", strNotificationLabel: _("Play all", "webapp.filesmanager"), intNotificationValue: 1, callback : function(){that.openCategory(that.data.TYPE_AUDIO)}};
				data.addPlayNotif(notif);
				data.boolPlayList = true;
				data.switchContainer("", data.STATUS_LIST);
				// Start the next song with -1 as current Played. So, if in shuffle mode, it will change it randomly, and otherwise, it will make +1 => 0 => first song
				data.intCurrentPlayed = -1;
				if(data.boolMediaPlayerIsPlaying)
					ICTouchAPI.APIServices.IctMPInterface.stopMP({params: [data.getCurrentElement().intIndex]});
				else
					this.notifyPlayerFinished();
				}
				else {
					ICTouchAPI.APIServices.IctMPInterface.playPauseMP({params: [this.data.currentIdFilePlayed]});
				}
				break;
			case data.STOP_ALL:
				data.stopPlayList(data.STATUS_LIST);
				data.switchContainer("", data.STATUS_LIST, this.data.getCurrentType());
        		break;
			case data.STOP:
				data.stop();
				if(data.isFileChanged){
					data.refreshFileList();
				}
				else{
				// data.switchContainer("getFilesManagerFileList", data.STATUS_LIST, data.getFilesManagerContainerTitle());
				data.switchToListView();
                            }
        		break;
			case data.NEXT:
				this.nextPlaylist();
				break;
			case data.SHUFFLE:
				data.setShuffleStatus();
				break;
			case data.FILTERS:
				this.showFilters();
				break;
            case data.DELETE:
				(data.boolDeleteMode)? data.setDeleteMode(false) : data.setDeleteMode(true);
				data.updateAppBar(data.STATUS_LIST);
				break;
            case data.SSPOOL:
                    if(!data.boolIsInScreenSaverPool) {
					this.addInPool(ICTouchAPI.tools.POOL_SS, data.getCurrentElement().path);
                    } else {
				this.removeFromPool(ICTouchAPI.tools.POOL_SS, data.getCurrentElement().path);
                    }
				break;
            case data.SET_BACKGROUND:
				var strOldBackgroundPicture = data.getUserBackgroundPicture();
				var strNewBackgroundPicture = data.getCurrentElement().path;
				if(strOldBackgroundPicture == strNewBackgroundPicture){
					ICTouchAPI.settingServices.setSettingValue("UserBackgroundPicture", "");
				} else {
					ICTouchAPI.settingServices.setSettingValue("UserBackgroundPicture", strNewBackgroundPicture);
				}
				break;
			case data.SET_USER_PICTURE:
				var strOldPicture = data.getUserPicture();
				var strNewPicture = data.getCurrentElement().path;
				if(strOldPicture == strNewPicture){
					ICTouchAPI.settingServices.setSettingValue("UserPhoto", "");
				} else {
					ICTouchAPI.settingServices.setSettingValue("UserPhoto", strNewPicture);
				}
 				break;
				// "Set Ringing" button will be used in a futur release
//            case data.SET_RINGING:
//        		if(!data.boolIsInRingingPool) {
//					this.addInPool(ICTouchAPI.tools.POOL_RM, data.getCurrentElement().path);
//					data.boolIsInRingingPool = true;
//				}
//				ICTouchAPI.settingServices.setSettingValue("UserRingingMelody", data.getCurrentElement().path);
//				data.updateAppBar(data.STATUS_PLAY);
//				break;
            case data.COPY:
				var currentElement = data.getCurrentElement();
				if (currentElement.device != data.DEVICE_USERSPACE){
					this.copyFile(currentElement.intIndex, data.DEVICE_USERSPACE, false);
				}
				break;
			case data.SELECT_ALL :
				data.selectAllFilters();
				break;
			case data.DESELECT_ALL :
				data.deselectAllFilters();
				break;
            default:
                console.warn("buttonCallback > No callback set for Button Id : "+buttonId);
                break;
		}
	},

	// Start the loading spinner
	notifyPlayerLoading : function(objEvent) {
        // TODO
    },

	notifyPlayerStopped : function(objEvent) {
		if(objEvent && objEvent.value && (objEvent.value==-100 || objEvent.value==-200)) {
		    this.data.setPreviewPlaying(false);
		    return ;
		}
		this.data.intPlayStatus = this.data.STOP_STATUS;
		dojo.publish('filesmanager/MediaPlayerStopped');
		this.notifyPlayerFinished(objEvent);
		// else
			// remove icon
    },

	// Stop any loading spinner that is running. If in media player mode (2nd level), call UI Media method ï¿½mediaPlayï¿½.
	notifyPlayerPlaying : function(objEvent, objEvent2) {
	    if(objEvent && objEvent.value && (objEvent.value==-100 || objEvent.value==-200)) {
		    this.data.setPreviewPlaying(true);
			return ;
	    }
		dojo.publish('filesmanager/MediaPlayerPlayed');
		this.data.intPlayStatus = this.data.PLAY_STATUS;
		var intDuration = 10000;
		if(objEvent2 && objEvent2.value){
			intDuration = objEvent2.value;
		}
		//Select this file in file list
		this.data.currentIdFilePlayed = objEvent.value;
		var node = this.data.getElementById(objEvent.value);
		if(node) {
			node.boolSelected = true;
		}
		if (this.mainWidget){
		this.mainWidget.unselectAllFile();
		this.mainWidget.selectFile(objEvent.value);
		}

		if(!this.data.boolPlayList) { // Mediaplayer Mode
			this.data.boolMediaPlayerIsPlaying = true; // MP is playing
			this.data.boolMPLaunching = false; //MP isn't launching anymore
			var appBar = ICTouchAPI.AppBarServices.getAppBar("filesmanager", "filesmanagerstatus"+this.data.STATUS_PLAY);
			appBar.getButton(this.data.PLAY).hide();
			appBar.getButton(this.data.PAUSE).show();
			if(this.player!=null) {
				var max = intDuration>250 ? intDuration-250 : 1;
				this.player.setMediaDuration(max);
				this.player.mediaPlay();
			}
		}
		else {
			this.data.formatAppBar(this.data.STATUS_LIST);
		}
		// Stop any loading spinner that is running TODO
    },

	// Start the loading spinner on the currently displayed widget.
	notifyPlayerBuffering : function(objEvent) {
        // TODO
    },

	notifyPlayerPaused : function(objEvent, objEvent2) {
		this.data.intPlayStatus = this.data.PAUSE_STATUS;
		var data = webapp.filesmanager.data;
		var intTime = 0;
		if(objEvent2 && objEvent2.value){
			intTime = objEvent2.value;
		}
		if(data.boolPlayList) {
			this.data.formatAppBar(this.data.STATUS_LIST);
			return;
			//  @TODO: If in playlist mode, change play icon to ï¿½pauseï¿½ icon. TODO
		} else { // Mediaplayer Mode
			//hide the notifications of all media types
			var appBar = ICTouchAPI.AppBarServices.getAppBar("filesmanager", "filesmanagerstatus"+this.data.STATUS_PLAY);
			appBar.getButton(this.data.PLAY).show();
			appBar.getButton(this.data.PAUSE).hide();
			if(this.player!=null) {
				this.player.setToTime(intTime/1000);
				this.player.mediaPause();
			}
		}
    },

	// Stop any loading spinner that is running.
	notifyPlayerError : function(objEvent, objEvent2, objEvent3) {
		this.notifyPlayerStopped(objEvent3);
		this.data.clearPlayNotifs();
		ICTouchAPI.popupServices.errorPopup(_("Error", "ICTouchAPI"), _("Could not load media", "webapp.filesmanager"), _("Ok", "ICTouchAPI"), 666); // id ?
    },

	// If we are in playlist mode, it launchs the next one. If we are in mediaPlayer mode, it stops.
	notifyPlayerFinished : function(objEvent) {

		//Unselect played file in file list
		if(objEvent!=null) {
		    if(objEvent.value && (objEvent.value==-100 || objEvent.value==-200)) {
			this.data.setPreviewPlaying(false);
				return ;
		    }
			this.data.currentIdFilePlayed = null;
			var node = this.data.getElementById(objEvent.value);
			if(node) {
				node.boolSelected = false;
			}
			if (this.mainWidget){
			this.mainWidget.unselectAllFile();
			this.mainWidget.unselectFile(objEvent.value);
		}
		}
		this.data.intPlayStatus = this.data.STOP_STATUS;

		if(this.data.boolPlayList) { // We are in playlist mode
			this.data.formatAppBar(this.data.STATUS_LIST);
			this.data.boolMediaPlayerIsPlaying = false;
			var max = this.data.getFilesManagerContainerContent().length-1;
			if(this.data.boolShuffle)
				this.data.intCurrentPlayed = Math.round(Math.random()*max);
			else
				this.data.intCurrentPlayed = (this.data.intCurrentPlayed == max) ? 0 : this.data.intCurrentPlayed+1;
			var currentSong = this.data.getFilesManagerContainerContent()[this.data.intCurrentPlayed];
			this.data.currentIdFilePlayed = currentSong.intIndex;

			//MediaPlayer.playMedia([this.intIndex,this.strMediaPath]); // core function
			ICTouchAPI.APIServices.IctMPInterface.playMedia({params: [currentSong.intIndex,currentSong.path]});
			// Remove the "play" list icon for any song in FILES_LIST and add it to the current played song. TODO
		} else if(this.data.boolMediaPlayerIsPlaying || this.data.boolMPLaunching){
            if(!this.data.boolMPLaunching){
			this.data.clearPlayNotifs();
            }
			this.data.boolMPLaunching = false;
			this.data.boolMediaPlayerIsPlaying = false;
			var appBar = ICTouchAPI.AppBarServices.getAppBar("filesmanager", "filesmanagerstatus"+this.data.STATUS_PLAY);
			appBar.getButton(this.data.PLAY).show();
			appBar.getButton(this.data.PAUSE).hide();
			dojo.publish('filesmanager/MediaPlayerFinished');
		}
	},

	mediaSessionInfosReceived : function(args) {
		var appBar = ICTouchAPI.AppBarServices.getAppBar("filesmanager", "filesmanagerstatus"+this.data.STATUS_PLAY);
		if(args.sessionState===2 && this.data.getMediaCapability()) {
			appBar.getButton(this.data.PLAY).hide();
			appBar.getButton(this.data.PAUSE).show();
		}
		else {
			appBar.getButton(this.data.PLAY).show();
			appBar.getButton(this.data.PAUSE).hide();
		}
		if(this.player) {
			var max = args.totalTime>250 ? args.totalTime-250 : 1;
			this.player.setMediaDuration(max);
			this.player.setToTime((args.currentIndex)/1000);
			if(args.sessionState===2 && this.data.getMediaCapability()) {
				this.player.mediaPlay();
			}
			else {
				this.player.mediaPause();
			}
		}
	},

	// If file list changed and we are displaying it, we reload it
	notifyFileListChanged : function(objEvent) {
		var data = webapp.filesmanager.data;
		data.isFileChanged = true;
		if(data.getContainerPath() == data.WEBAPP_PATH+"."+data.FILE_LIST_WIDGET) {
            for(var i in objEvent.value) {
                if(objEvent.value[i].categoryName == data.getCurrentType()) {
			data.refreshFileList();
		}
            }
		}
	},

	// Set Media UI
	notifyPlayerState : function(intDevice, boolDistant, intIndex, intState, intTotalTime, doubleVolume) {
		var appBar = ICTouchAPI.AppBarServices.getAppBar("filesmanager", "filesmanagerstatus"+this.data.STATUS_PLAY);
		if(intState.value===2 && this.data.getMediaCapability()) {
			appBar.getButton(this.data.PLAY).hide();
			appBar.getButton(this.data.PAUSE).show();
		}
		else {
			appBar.getButton(this.data.PLAY).show();
			appBar.getButton(this.data.PAUSE).hide();
		}
		if(this.player) {
			var max = intTotalTime.value>250 ? intTotalTime.value-250 : 1;
			this.player.setMediaDuration(max);
			this.player.setToTime((intIndex.value)/1000);
			if(intState.value===2 && this.data.getMediaCapability()) {
				this.player.mediaPlay();
			}
			else {
				this.player.mediaPause();
			}
		}
	},

	notifyTelephonyRunningEvent : function(objStatus) {
		this.data._boolTelephonyRunning = (objStatus.value===1)
		this.data.enableOrDisableMediaUI();
	},

	notifyMPCapabilityChange : function(strCapability, intStatus) {
		this.data._boolMPCapabilityEnable = (intStatus===ICTouchAPI.CapabilityServices.AVAILABLE);
		this.data.enableOrDisableMediaUI();
	},

	// Callback of the "next" button
	nextPlaylist : function() {
		var data = webapp.filesmanager.data;
		ICTouchAPI.APIServices.IctMPInterface.stopMP({params: [data.getFilesManagerContainerContent()[data.intCurrentPlayed].intIndex], callback: function(){
			webapp.filesmanager.notifyPlayerFinished();
		},
		errorCallback : function(args){
			console.error("----------- nextErrorCallback ----------");
			console.error(args);
		}});
	},

	onClickMediaList : function(id) {
		var data = webapp.filesmanager.data;
		var file = data.getElementById(id);
		data.previousElement = dojo.clone(data.getCurrentElement());
		data.setCurrentElement(file);
		if(data.getCurrentElement().canOpen == 0) {
		    this.getWarningPopup();
		    return ;
		}
		//Uncheck selected file
		this.mainWidget.unselectFile(id);
		data.getElementById(id).boolSelected = false;
		if(data.boolDeleteMode) {
			if(data.getCurrentElement().device == 'USERSPACE'){
				data.deleteElement(id);
				//Check current played file
				if(data.currentIdFilePlayed!=null) {
					var playedFile = data.getElementById(data.currentIdFilePlayed);
					//data.setCurrentElement(playedFile);
					playedFile.boolSelected = true;
					this.mainWidget.selectFile(this.data.currentIdFilePlayed);
				}
			}else{
				this.errorManager(-6, null);
			}
		}
		else {
			if(data.getCurrentType() == data.TYPE_BOOKMARKS) {
				webapp.browser.openLink(file.path);
			} else {
				data.switchToFileView(id);
			}
		}
	},

        /**
        *   Method called to show a warning popup when a wrong admin password has been submited
        */
        getWarningPopup : function(){
            var context = this;
		var strContent = _("The selected file could not be displayed. The image size exceeds the limit viewable.","webapp.filesmanager");
		var strTitle = _("Warning","ICTouchAPI");
		var popupData = {
			strTitle: strTitle,
			strType: "warning",
			strContent: strContent,
			arrPopupButtons: [
			{
				strButtonLabel: _("Ok","ICTouchAPI"),
				callback : function(){
					ICTouchAPI.popupServices.removePopup(context.objPopup);
				}
			}
			]
		};
		this.objPopup = ICTouchAPI.popupServices.addNewPopup(popupData, "MEDIUM");
	},

    pausePlayer : function() {
        // force to pause cause due to a callEvent
        if(webapp.filesmanager.player)
            webapp.filesmanager.player.domMedia.pause();
    },

	// Function that throws popup according to the problem specified in strType and strMessage
	openPopup : function(strType, strMessage) {
		var data = webapp.filesmanager.data;
		var context = this;
		var func = function(){ICTouchAPI.popupServices.removePopup(context.popup);};
		var popup = {
			strTitle: _(strType, "webapp.filesmanager"),
			strContent : strMessage,
			strType : strType,
			arrPopupButtons: [
				{strButtonName : data.OK, strButtonLabel: _("Ok", "ICTouchAPI"), strButtonIcon: "generic-ok", callback : func},
			]
		};
		this.popup = ICTouchAPI.popupServices.addNewPopup(popup, "MEDIUM");
	},

	// Call the core function removeFileFromPool and match the errors
	removeFromPool : function(strPool, strPath) {
		var that = this;
		ICTouchAPI.APIServices.FileManager.removeFileFromPool({params:[strPool, strPath], context:this, callback:this.errorManager, callbackParams:function(intReturn){that.onPoolChanged(strPool, intReturn, "remove", strPath)}});
	},

	// Call the core function addFileInPool and match the errors
	addInPool : function(strPool, strPath) {
		var that = this;
		ICTouchAPI.APIServices.FileManager.addFileInPool({params:[strPool, strPath], context:this, callback:this.errorManager, callbackParams:function(intReturn){that.onPoolChanged(strPool, intReturn, "add", strPath)}});
	},

	onPoolChanged : function(strPool, intReturn, strAction, filePath) {
		if(intReturn===0) {
			this.poolChanged(strPool, strAction, filePath);
		}
	},

	// Added to call core function copyFileToDevice
	copyFile : function (idFile, device, boolOverwrite) {
		ICTouchAPI.APIServices.FileManager.copyFileToDevice({params:[idFile, device, boolOverwrite], context:webapp.filesmanager, callback:webapp.filesmanager.errorManager});
		this.createCopySpinner();
	},

	cancelCopy : function() {
		this.destroyCopySpinner();
		ICTouchAPI.popupServices.removePopup(this.popupOverwrite);
	},

	createCopySpinner : function() {
		this.destroyCopySpinner();
		this._objSpinner = new UIElements.Spinner.SpinnerControl({strMessage : _('Copy in progress...', "webapp.filesmanager"), boolForeground:true}, document.body);
		this._spinnerHandler = setTimeout(dojo.hitch(this, this.destroyCopySpinner), 2000);
	},

	destroyCopySpinner : function() {
		if(this._objSpinner){
			this._objSpinner.destroy();
			this._objSpinner = null;
		}
		if(this._spinnerHandler){
			clearTimeout(this._spinnerHandler);
			this._spinnerHandler = null;
		}
	},

	// Manage every IctFileManager module's errors
	errorManager : function(intReturn, funcCallback) {
		var data = webapp.filesmanager.data;
		var boolError = true;
		var strMessage = "";
		switch (intReturn) {
			case -1:
				strMessage = "TECHNICAL_PROBLEM";
				break;
			case -2:
				strMessage = "CATEGORY_DOES_NOT_EXIST";
				break;
			case -3:
				strMessage = "UNKNOWN_FILE_IDENTIFIER";
				break;
			case -4:
				strMessage = "URL_ALREADY_EXIST";
				break;
			case -5:
				strMessage = "NAME_ALREADY_EXIST";
				break;
			case -6:
				strMessage = "PERMISSION_DENIED";
				break;
			case -7:
				strMessage = "FILE_DOES_NOT_EXIST";
				break;
			case -8:
				strMessage = "FILE_IS_A_LINK";
				break;
			case -9:
				strMessage = "FILE_ALREADY_ON_THE_DEVICE";
				break;
			case -10:
				strMessage = "USB_KEY_NOT_CONNECTED";
				break;
			case -11:
				strMessage = "UNKNOWN_DEVICE_IDENTIFIER";
				break;
			case -12:
				strMessage = "DEVICE_FULL";
				break;
			case -13: // Special error, it is when we ask if the user want to overwrite a file
				boolError = false;
				var context = this;
				var popupOverwrite = {
					strTitle:  _("FILE_ALREADY_EXIST", "webapp.filesmanager"),
					strContent:  _("DO_OVERWRITE", "webapp.filesmanager"),
					strType: "warning",
					arrPopupButtons: [
						{strButtonName : "Yes", strButtonIcon: "generic-ok", strButtonLabel: _('Yes', "ICTouchAPI"), callback : function(){context.copyFile(data.getCurrentElement().intIndex, data.DEVICE_USERSPACE, true);ICTouchAPI.popupServices.removePopup(context.popupOverwrite);}},
						{strButtonName : "No", strButtonIcon: "generic-cancel", strButtonLabel: _('No', "ICTouchAPI"), callback : function(){context.cancelCopy()}},
					]
				};
				this.popupOverwrite = ICTouchAPI.popupServices.addNewPopup(popupOverwrite, "MEDIUM");
				break;
			case -14:
				strMessage = "NEGATIVE_ORDER";
				break;
			case -15:
				strMessage = "CATEGORY_ALREADY_EXIST";
				break;
			case -16:
				strMessage = "POOL_ALREADY_EXIST";
				break;
			case -17:
				strMessage = "POOL_DOES_NOT_EXIST";
				break;
			case -18:
				strMessage = "FILE_TYPE_ALREADY_EXIST";
				break;
			default:
				boolError = false;
				break;
		}
		if(funcCallback)
			funcCallback(intReturn);
		if(boolError)
			ICTouchAPI.popupServices.errorPopup(_("Error", "ICTouchAPI"), _(strMessage, "webapp.filesmanager"), _("Ok", "ICTouchAPI"));
	},

	gotFileForPK : function(arrFiles) {
		if(arrFiles.length == 0)
			ICTouchAPI.popupServices.errorPopup(_("Error", "ICTouchAPI"), _("FILE_DOES_NOT_EXIST", "webapp.filesmanager"), _("Ok", "ICTouchAPI"));
		else {
			webapp.filesmanager.data.formatFileObject(arrFiles[0]);
			webapp.filesmanager.data.setCurrentElement(arrFiles[0]);
			webapp.filesmanager.data.switchToFileView();
		}
	},
	
	poolChanged : function(strPoolName, strAction, filePath){
		var data=webapp.filesmanager.data;
		var strPoolNameToi18n;
		var btnAddButton;
		//var strRemoveButton;
		var appBar = ICTouchAPI.AppBarServices.getAppBar("filesmanager", "filesmanagerstatus"+data.STATUS_PLAY);
		// get the right button name according to the changed pool
		if (strPoolName == ICTouchAPI.tools.POOL_SS) {
			strPoolNameToi18n = "Screensaver Pool";
			btnAddButton = appBar.getButton(data.SSPOOL);
			data.boolIsInScreenSaverPool = !data.boolIsInScreenSaverPool;

			if (strAction == "add") {
				this.data.addFileInScreensaverPool(filePath);
			}
			else if (strAction == "remove") {
				this.data.removeFileInScreensaverPool(filePath);
			}
			if (this.uiScreensaver){
				this.uiScreensaver.updateSlideshow(this.data.getScreensaverPoolFiles());
			}
		}
		// update buttons add/remove
		if (strAction == "add") {
            btnAddButton.setStatusIcon(data.STATUS_ON_ICON);
		}
		else if (strAction == "remove") {
			btnAddButton.setStatusIcon(data.STATUS_OFF_ICON);
		}

		//Publish an event to reload the list containing the files of the pool(ex : wakeup)
		//Useless now until pools management (other than screensaver) is rescoped.
		//dojo.publish("ReloadPool",[]);
	},

	showFilters : function() {
		ICTouchAPI.transitionServices.getScreen({
			name: "webapp.filesmanager.getFilters",
			params: {}
		});
	}
});
