/*managerassistant*/
// Provide and create the managerassistant webapp.
dojo.provide("webapp.managerassistant.controlBase");
dojo.declare("webapp.managerassistant.controlBase",[ICTouchAPI.webApplication],{

	popupFilters	: null,

	constructor: function(){
		// Subscribe to all the events

		ICTouchAPI.skinServices.linkWebappsStyles("webapp.getManagerPreview","webapp.managerassistant", false, true, false);
		ICTouchAPI.skinServices.linkWebappsStyles("webapp.getManagerPreview","webapp.managerassistant", true, false, true);
		ICTouchAPI.skinServices.linkWebappsStyles("webapp.getManagerPreview","webapp.communication", true, false, true);
		ICTouchAPI.skinServices.linkWebappsStyles("webapp.getManagerPreview","webapp.communication", false, true, false);
		ICTouchAPI.skinServices.linkWebappsStyles("webapp.getManagerPreview","webapp.instantmessaging", true, false, true);
		ICTouchAPI.skinServices.linkWebappsStyles("webapp.getManagerPreview","webapp.userinfo", true, false, true);
		ICTouchAPI.skinServices.linkWebappsStyles("webapp.getBackupAssistantPreview","webapp.managerassistant", false, true, false);

	},
	/**
	 * Update data.boolEnableMAPreview with the value of setting EnableManagerassistantPreview and register/unregister the previewContainer
	 * @params {object} objSetting : setting object with boolean value.
	 */
	updateMAEnableState : function(objSetting){
		var data = webapp.managerassistant.data;
		data.boolEnableMAPreview = objSetting.jsValue;
		this._registerHomepageContainer();
	},

	/**
	 * Register or unregister the previewContainer according to setting EnableManagerassistantPreview
	 * and the state of BackupAssistant mode.
	 */
	_registerHomepageContainer : function() {
		ICTouchAPI.debugServices.info("webapp.managerassistant.controlBase - _registerHomepageContainer");
		// If the preview Manager/Assistant is enabled, look for the preview to register according to the BackupAssistant state
		if(this.data.boolEnableMAPreview){
			// if the BackupAssistant is enabled, register the BackupAssistant preview (and unregister the Manager/Assistant preview if it was still registered)
			if (this.data.getBackupAssistantEnabled()) {
				this._registerBackupAssistantPreview();				
			}
			// if the BackupAssistant is not enabled, look to register the Manager/Assistant preview (and unregister the BackupAssistant preview if it was still registered)
			else {
				this._registerManagerAssistantPreview();
			}
		} else {
			// If the preview Manager/Assistant is not enabled, look for unregistering Manager/Assistant and BackupAssistant if one of them was registered
			this._unregisterManagerAssistantPreview();
			this._unregisterBackupAssistantPreview();
		}
	},


	/**
	 * Register the Manager/Assistant preview if needed (i.e. if it was not already registered and there is more than 0 manager/assistant).
	 * If the BackupAssistant preview was registered, unregister it before registering Manager/Assistant preview (can't be both registered at the same time).
	 */
	_registerManagerAssistantPreview : function() {
		ICTouchAPI.debugServices.info("webapp.managerassistant.controlBase - _registerManagerAssistantPreview");
		if (this.data.isBackupPreviewRegistered) {
			this._unregisterBackupAssistantPreview();
		}
		if(!this.data.isPreview && this.data.getNbMA() > 0){
			ICTouchAPI.tools.registerHomepageContainer(["webapp.managerassistant.getManagerPreview", this]);
			this.data.isPreview = true;
		}
	},

	/**
	 * Unregister the Manager/Assistant preview if needed (i.e. if it was registered).
	 */
	_unregisterManagerAssistantPreview : function() {
		ICTouchAPI.debugServices.info("webapp.managerassistant.controlBase - _unregisterManagerAssistantPreview");
		if(this.data.isPreview){
			if(this.previewContainer && typeof this.previewContainer.destroy == 'function'){
				this.previewContainer.destroy();
			}
			ICTouchAPI.tools.unregisterHomepageContainer(["webapp.managerassistant.getManagerPreview"]);
			this.data.isPreview = false;
		}
	},


	/**
	 * Register the BackupAssistant preview if needed (i.e. if it was not already registered).
	 * If the Manager/Assistant preview was registered, unregister it before registering BackupAssistant preview (can't be both registered at the same time).
	 */
	_registerBackupAssistantPreview : function() {
		ICTouchAPI.debugServices.info("webapp.managerassistant.controlBase - _registerBackupAssistantPreview");
		if (this.data.isPreview) {
			this._unregisterManagerAssistantPreview();
		}
		if (!this.data.isBackupPreviewRegistered){
			ICTouchAPI.tools.registerHomepageContainer(["webapp.managerassistant.getBackupAssistantPreview", this]);
			this.data.isBackupPreviewRegistered = true;
		}
	},

	/**
	 * Unregister the BackupAssistant preview if needed (i.e. if it was registered).
	 */
	_unregisterBackupAssistantPreview : function() {
		ICTouchAPI.debugServices.info("webapp.managerassistant.controlBase - _unregisterBackupAssistantPreview");
		if(this.data.isBackupPreviewRegistered){
			if(this.previewContainer && typeof this.previewContainer.destroy == 'function'){
				this.previewContainer.destroy();
			}
			ICTouchAPI.tools.unregisterHomepageContainer(["webapp.managerassistant.getBackupAssistantPreview"]);
			this.data.isBackupPreviewRegistered = false;
		}
	},

	loaded : function() {
		ICTouchAPI.eventServices.subscribeToEvent(this, "FilteringLevelChangedEvent", this.onFilteringLevelChanged);
		ICTouchAPI.eventServices.subscribeToEvent(this, "AssistantAddedEvent", this.onManagerAssistantAdded);
		ICTouchAPI.eventServices.subscribeToEvent(this, "ManagerAddedEvent", this.onManagerAssistantAdded);
		ICTouchAPI.eventServices.subscribeToEvent(this, "AssistantRemovedEvent", this.onManagerAssistantRemoved);
		ICTouchAPI.eventServices.subscribeToEvent(this, "ManagerRemovedEvent", this.onManagerAssistantRemoved);
		ICTouchAPI.eventServices.subscribeToEvent(this, "WhiteListModifiedEvent", this.onWhiteListModified);
		ICTouchAPI.eventServices.subscribeToEvent(this, "WhiteListRemovedEvent", this.onWhiteListRemoved);
		ICTouchAPI.eventServices.subscribeToEvent(this, "IM_PRESENCE_CHANGE", this.onPresenceChanged);
		ICTouchAPI.eventServices.subscribeToEvent(this, "BackupAssistantEnabled", this.onBackupAssistantChanged);

		ICTouchAPI.settingServices.subscribeToSetting(this, "EnableUserPhoto", this.enablePhoto);
		ICTouchAPI.settingServices.getSetting("EnableUserPhoto", this, this.enablePhoto);

		ICTouchAPI.settingServices.subscribeToSetting(this, "EnableWebappInstantmessaging", this.enableIM);
		ICTouchAPI.settingServices.getSetting("EnableWebappInstantmessaging", this, this.enableIM);

		ICTouchAPI.settingServices.subscribeToSetting(this, "EnableManagerassistantPreview", this.updateMAEnableState);
		ICTouchAPI.settingServices.getSetting("EnableManagerassistantPreview", this, this.updateMAEnableState);

		ICTouchAPI.settingServices.subscribeToSetting(this, "UserRole", this.updateUserRole);
		ICTouchAPI.settingServices.getSetting("UserRole", this, this.updateUserRole);

		ICTouchAPI.settingServices.subscribeToSetting(this, "LoginName", this.updateLoginName);
		ICTouchAPI.settingServices.getSetting("LoginName", this, this.updateLoginName);

		ICTouchAPI.settingServices.subscribeToSetting(this,"IMAvailable",this.updateIMAvailable);
		ICTouchAPI.settingServices.getSetting("IMAvailable",this,this.updateIMAvailable);

		ICTouchAPI.settingServices.subscribeToSetting(this,"TelephonyPresenceAvailable",this.updateTelephonyPresenceAvailable);
		ICTouchAPI.settingServices.getSetting("TelephonyPresenceAvailable",this,this.updateTelephonyPresenceAvailable);

		ICTouchAPI.settingServices.subscribeToSetting(this,"EnableManagerassistantPresence",this.updateEnableMAPresence);
		ICTouchAPI.settingServices.getSetting("EnableManagerassistantPresence",this,this.updateEnableMAPresence);
                
		ICTouchAPI.settingServices.subscribeToSetting(this,"ManagerWhitelist",this.updateWhiteUserRights);
		ICTouchAPI.settingServices.getSetting("ManagerWhitelist",this,this.updateWhiteUserRights);
                // Specific mode for OXO R900
                ICTouchAPI.settingServices.getSetting("ManagerAssistantNoManagerNotification", this, this.enableNoMANotif);

		// When we leave mode selection screen, apply the selected mode
		dojo.subscribe("iframe.hide", this, this.applySelectedMode);
	},

	buttonBackCallback : function() {
		dojo.publish("OpenHomepage");
	},

	/**
	 * Callback of the Backup button (in Filters screen)
	 */
	onBackupButton : function () {
		ICTouchAPI.debugServices.info("webapp.managerassistant.controlBase - onBackupButton");
		// ask userservices to select the User routing profile
		dojo.publish("userservices.selectUserDevice");
		// open userservices view
		ICTouchAPI.transitionServices.getScreen({
			name: "webapp.userservices.getUserService",
			params : {}
		});
	},

	/**
	 * Callback of the BackupAssistant preview
	 */
	onBackupAssistantPreview: function () {
		ICTouchAPI.debugServices.info("webapp.managerassistant.controlBase - onBackupAssistantPreview");
		// open userservices view
		ICTouchAPI.transitionServices.getScreen({
			name: "webapp.userservices.getUserService",
			params : {}
		});
	},
	
	load : function(){
		this._getLists();
	},

	enableNoMANotif : function(objSetting) {
		if(objSetting){
			this.data.updateNoMANotif(objSetting.jsValue);
		}
               
	},

        enablePhoto : function(objSetting) {
		if(objSetting){
			this.data.updateEnablePhoto(objSetting.jsValue);
		}
	},

	updateUserRole : function(objSetting) {
		if(objSetting){
			this.data.setUserRole(objSetting.jsValue);
			this.data.updateBackupButton();
		}
	},

	updateLoginName : function(objSetting) {
		if(objSetting){
			this.data.setLoginName(objSetting.jsValue);
		}
	},

	updateIMAvailable : function(objSetting) {
		if(objSetting){
			this.data.setIMPresenceAvailable(objSetting.jsValue);
		}
	},

	updateTelephonyPresenceAvailable : function(objSetting) {
		if(objSetting){
			this.data.setTelephonyPresenceAvailable(objSetting.jsValue);
		}
	},

	updateEnableMAPresence : function(objSetting) {
		if(objSetting){
			this.data.updateEnablePresenceInMA(objSetting.jsValue);
		}
	},

	/**
	 * Call core function consultWhiteList and returns a list of contact
	 * @params {string} login : login of the manager
	 */
	consultLists : function(login) {
		ICTouchAPI.APIServices.IctUser.consultWhiteList(
			{params:[login], context:this, callback:this._consultedLists, callbackParams:login});
	},

	/**
	 * Callback of consult white list (core function)
	 * Call a function from data to replace the current list for the manager
	 * @params {array} arrContacts : an array of contact objects corresponding to the white list
	 * @params {string} login : login of the manager
	 */
	_consultedLists : function(arrContacts, login) {
		if(arrContacts && login) {
			this.data.setWhiteList(login, arrContacts);
		}
	},

	/**
	 * Ask IM module for the presence of a contact.
	 * @params {string} contactId
	 */
	getPresenceForContact : function(contactId) {
		ICTouchAPI.APIServices.InstantMessaging.getPresenceForContact({context : this, params: [contactId], callback: this.setPresence});
	},

	/**
	 * Callback of IM_PRESENCE_CHANGED
	 * Format the result and call setPresence to change the presence in previews
	 * @params {event:array} presenceList : list of presences
	 */
	onPresenceChanged:function(presenceList) {
		if(presenceList && presenceList.value){
			this.setPresence(presenceList.value);
		}
		presenceList=null;
	},

	/**
	 * Callback of BackupAssistantEnabled
	 * Update _boolBackupAssistantEnabled and update the homepage preview as needed according to the state of BackupAssistant mode
	 * @params {Object} boolEnableBackup : value sent in the event 'BackupAssistantEnabled'
	 */
	onBackupAssistantChanged:function(boolEnableBackup) {
		ICTouchAPI.debugServices.info("webapp.managerassistant.controlBase - onBackupAssistantChanged");
		if(boolEnableBackup && boolEnableBackup.value !== undefined) {
			ICTouchAPI.debugServices.debug("webapp.managerassistant.controlBase - onBackupAssistantChanged / new value is: " + boolEnableBackup.value);
			// Update the internal boolean
			this.data.setBackupAssistantEnabled(boolEnableBackup.value);
			// Update the preview according to the state of Backup Assistant
			this._registerHomepageContainer();
		}
		boolEnableBackup=null;
	},
	
	/**
	 * Update the presence of managers and assistants
	 * @params {array} presenceList : list of presences
	 */
	setPresence : function(presenceList) {
		ICTouchAPI.debugServices.info("webapp.managerassistant.controlBase - setPresence");
		if(presenceList.length){
			for(var i in presenceList){
				// Try to find a match with a manager or an assistant and update the presence
				this.data.updatePresenceInContact(presenceList[i].imAddress, presenceList[i].imPresenceValue.value.labelStatus, presenceList[i].telephonicPresenceValue.value.labelStatus);
			}
		}
		ICTouchAPI.debugServices.info("webapp.managerassistant.controlBase - setPresence end");
	},

	/**
	 * Callback of WhiteListRemovedEvent
	 * Replace the white list of a manager
	 * @params {event:array} whiteList : a list of contacts
	 */
	onWhiteListModified : function() {
		var objArguments = ICTouchAPI.tools.getEventArguments(arguments);
		var whiteList = objArguments.whiteList;
		this.data.setWhiteList(this.data.getLoginName(), whiteList);
	},

	/**
	 * Callback of WhiteListModifiedEvent
	 * Remove the white list of a manager
	 */
	onWhiteListRemoved : function() {
		this.data.removeWhiteList(this.data.getLoginName());
	},

	/**
	 * Update local variable '_boolEnableIM' and reload the preview container
	 * @params {object} objSetting : setting 'EnableUserPhoto'
	 */
	enableIM : function(objSetting) {
		if(objSetting){
			this.data.updateEnableIM(objSetting.jsValue);
		}
	},

	/**
	 *	Start business call for Assistant and Manager list.
	 *	If we are Assistant, we will maybe receive ManagerAddedEvent in addition of the callback
	 *	If we are Manager, we will maybe receive AssistantAddedEvent in addition of the callback
	 */
	_getLists : function() {
		ICTouchAPI.APIServices.IctUser.getAssistantList(
			{params:[], context:this.data, callback:this.data.addManagerAssistants});
			//loadedManagers
		ICTouchAPI.APIServices.IctUser.getManagerList(
			{params:[], context:this.data, callback:this.data.addManagerAssistants});
		// load white list if the role is manager
		if (this.data.getRole() == this.data.MANAGER_ROLE) {
			this.consultLists(this.data.getLoginName());
		}
	},

	/**
	 * Callback of business call for Assistant and Manager list.
	 * @params arrManagerAssistant {array} a list of contact objects
	 */
	_gotList : function(arrManagerAssistant) {
		// Update the data
		this.data.addManagerAssistants(arrManagerAssistant);

		// Nullify arguments
		arrManagerAssistant = null;
	},

	/**
	 * Ask for presence and filtering level.
	 * @params objContact {object} a contact object
	 */
	askForInfo : function(objContact) {
		ICTouchAPI.debugServices.info("webapp.managerassistant.controlBase - askForInfo");
		// Get current filtering level
		var loginForFilter = "";
		if(this.data.getRole() == this.data.MANAGER_ROLE){
			loginForFilter = this.data.loginName;
		} else {
			loginForFilter = objContact.loginName;
		}
		ICTouchAPI.APIServices.IctUser.getFilteringLevel({params:[loginForFilter], context: this, callback :this._gotFilteringLevel, callbackParams:loginForFilter});

		// Get current IM presence
		if(this.data.getEnablePresenceInMA() || this.data.getIMPresenceAvailable() || this.data.getTelephonyPresenceAvailable()){
			this.getPresenceForContact(objContact.contactId);
		}
		ICTouchAPI.debugServices.info("webapp.managerassistant.controlBase - askForInfo end");
	},

	/**
	 * Callback of core function getFilteringLevel's call.
	 * @params filteringLevel {string} the mode we have to set
	 * @params strLogin {string} the login of the contact we have to set
	 */
	_gotFilteringLevel : function(filteringLevel, strLogin) {
		this.data.setFilteringLevel(strLogin, filteringLevel && filteringLevel.value);
	},

	/**
	 * Callback of FILTER button, opens a new Filter popup
	 * @params {event:string} manager : the login of the manager
	 * @params {event:string} filteringlevel : enum filteringLevel
	 */
	openFilters : function() {
		ICTouchAPI.debugServices.info("webapp.managerassistant.controlBase - openFilters");
		// We store current data of the manager/assistant, to restore it in case of cancel
		var data = this.data;

		var login = data.strCurrentSelectedLogin;

		var objManagerAssistant = data.getManagerAssistantByLogin(login);

		// webapp.managerassistant.data.objFiltersContainer is a select list
		if(data.objFiltersContainer){
			data.objFiltersContainer.unselectAll();
			data.objFiltersContainer.selectAtIndex(data.getFilterNumberByMode(objManagerAssistant.mode));
			this.storeSelectedMode(objManagerAssistant.mode);
		} else {
			data.filters[data.getFilterNumberByMode(objManagerAssistant.mode)].boolSelected = true;
			this.storeSelectedMode(objManagerAssistant.mode);
		}

		ICTouchAPI.transitionServices.getScreen({
			name : "webapp.managerassistant.getFilters",
			params : {}
		})
		ICTouchAPI.debugServices.info("webapp.managerassistant.controlBase - openFilters end");
	},

	/**
	 * Callback of the filter popup (OK button)
	 * Set the filtering level with new parameters
	 * @params
	 */
	storeSelectedMode : function(strMode) {
		this._strSelectedMode = strMode;
	},

	/**
	 * Apply the selected mode to the selected manager / assistant (event iframe.hide)
	 * @params strScreenName {string} name of the hidden screen
	 */
	applySelectedMode : function(strScreenName) {
		ICTouchAPI.debugServices.info("webapp.managerassistant.controlBase - applySelectedMode");
		if(strScreenName == "webapp.managerassistant.getFilters"){
			var currentLogin = this.data.strCurrentSelectedLogin;
			var loginManager;
			// SetFilteringLevel is called with the manager login, it doesn't matter if we are assistant or manager
			if(this.data.getRole == this.data.MANAGER_ROLE){
				loginManager = this.data.loginName;
			} else {
				loginManager = currentLogin;
			}
			ICTouchAPI.APIServices.IctUser.setFilteringLevel({params:[loginManager, this._strSelectedMode]});
		}
		ICTouchAPI.debugServices.info("webapp.managerassistant.controlBase - applySelectedMode end");
	},

	/**
	 * Callback of IntrudeInCall button and PickUpCall button
	 * Simply call core function associated to the button
	 * @params {string} buttonId : id of the button
	 */
	onGetCallButtons : function(buttonId){
		if(webapp.communication){
			var objComLogEntry = webapp.communication.data.getSelectedEntry();
			var login = (this.data.getRole() == this.data.MANAGER_ROLE) ? objComLogEntry.objCallData.assistant : objComLogEntry.objCallData.manager;
			if(buttonId == this.data.INTRUDE){
				if(login){
					ICTouchAPI.APIServices.Telephony.intrudeCall({params:[objComLogEntry.objCallData.callRef, login, false]});
				}
			} else if(buttonId == this.data.PICK_UP){
				if(login){
					var objContact = this.data.getMAByLogin(login);
					if(objContact != null){
						var phoneNumber = ICTouchAPI.tools.getContactPhone(objContact.objContact);
						if(phoneNumber != ""){
							ICTouchAPI.APIServices.Telephony.pickupCall({params:[objComLogEntry.objCallData.callRef, phoneNumber]});
						}
					}
				}

			}
		}
	},

	/**
	 * Callback of callManager button (only available for assistant)
	 * Simply calls the manager
	 */
	onCallManagerButton: function(){
		// callToManager functionnality is only available on assistant side
		if (this.data.getRole() === this.data.ASSISTANT_ROLE) {
			// Search the associated manager phone number to the current call
			var strManagerPhoneNumber = this.data.getManagerPhoneNumber();
			if(webapp.communication){
				webapp.communication.apiCall(strManagerPhoneNumber, false);
			}
			else {
				ICTouchAPI.debugServices.warning("webapp.managerassistant.controlBase - onCallManagerButton / webapp.communication not existing");
			}
		}
		else {
			ICTouchAPI.debugServices.warning("webapp.managerassistant.controlBase - onCallManagerButton / Current role is not ASSISTANT_ROLE, do not initiate the call To Manager");
		}
	},

	/**
	 * Callback of callAssistant button (only available for manager)
	 * Simply calls the assistant
	 */
	onCallAssistantButton: function(){
		// TransferToAssistant functionnality is only available on manager side
		if (this.data.getRole() === this.data.MANAGER_ROLE) {
			var assistant = this.data.getManagerAssistants()[0];
			if (assistant && assistant.objContact) {
				var phoneNumber = ICTouchAPI.tools.getContactPhone(assistant.objContact);
				if(webapp.communication){
					webapp.communication.apiCall(phoneNumber, false);
				}else {
					ICTouchAPI.debugServices.warning("webapp.managerassistant.controlBase - onCallAssistantButton / webapp.communication not existing");
				}
			} else {
				ICTouchAPI.debugServices.warning("webapp.managerassistant.controlBase - onCallAssistantButton / No manager found or no objContact in manager object");
			}
		} else {
			ICTouchAPI.debugServices.warning("webapp.managerassistant.controlBase - onCallAssistantButton / Current role is not MANAGER_ROLE, do not initiate the Transfert To the assistant");
		}
	},

	/**
	 * Callback of TransferToManager button (only available for assistant)
	 * Simply call a transfer of the current phone call to the manager
	 */
	onTransfertToManagerButton: function(){
		// Get the current ongoing phone call
		if(webapp.communication){
			var objSelectedComLogEntry = webapp.communication.data.getSelectedEntry();

			// Search the associated manager phone number to the current call
			var strManagerPhoneNumber = this.data.getManagerPhoneNumber();

			// TransferToManager functionnality is only available on assistant side
			if (this.data.getRole() === this.data.ASSISTANT_ROLE && strManagerPhoneNumber) {
				ICTouchAPI.APIServices.Telephony.transferPhoneCallToNumber({params:[objSelectedComLogEntry.intIndex,
												    strManagerPhoneNumber,
												    false]
				});
			}
			else {
				ICTouchAPI.debugServices.warning("webapp.managerassistant.controlBase - onTransfertToManagerButton / Current role is not ASSISTANT_ROLE, do not initiate the Transfert To Manager");
			}
		}
		else {
			ICTouchAPI.debugServices.warning("webapp.managerassistant.controlBase - onTransfertToManagerButton / webapp.communication not existing");
		}
	},

	/**
	 * Callback of TransferToAssistant button (only available for manager)
	 * Simply call a transfer of the current phone call to the assistant
	 */
	onTransfertToAssistantButton: function(){
		// Get the current ongoing phone call
		if (webapp.communication) {
		    var objComLogEntryId = webapp.communication.data.getSelectedEntryId();

			// TransferToAssistant functionnality is only available on manager side
			if (this.data.getRole() === this.data.MANAGER_ROLE) {
			    var assistant = this.data.getManagerAssistants()[0];
			    if (assistant && assistant.objContact) {
				var phoneNumber = ICTouchAPI.tools.getContactPhone(assistant.objContact);
				if(phoneNumber){
					ICTouchAPI.APIServices.Telephony.transferPhoneCallToNumber({params:[objComLogEntryId, phoneNumber, false]});
				} else {
					ICTouchAPI.debugServices.warning("webapp.managerassistant.controlBase - onTransfertToAssistantButton / no phoneNumber found for the manager");
				}
			    }
			    else {
				ICTouchAPI.debugServices.warning("webapp.managerassistant.controlBase - onTransfertToAssistantButton / No manager found or no objContact in manager object");
			    }
			} else {
				ICTouchAPI.debugServices.warning("webapp.managerassistant.controlBase - onTransfertToAssistantButton / Current role is not MANAGER_ROLE, do not initiate the Transfert To the assistant");
			}
		} else {
			ICTouchAPI.debugServices.warning("webapp.managerassistant.controlBase - onTransfertToAssistantButton / webapp.communication not existing");
		}
	},

	/**
	 * Callback of Whitelist buttons in Communication and Contacts
	 * Add or remove the selected contact in the whitelist
	 * @param {string} strWebapp name of the webapp
	 * @param {string} buttonId id of the button
	 */
	onWhiteListButton : function(strWebapp, buttonId){
		var objContact = null;
		// Get the current contact of the calling webapp
		if(strWebapp === this.data.TO_COMM && webapp.communication){
			objContact = webapp.communication.data.getCurrentContact();
		} else if (strWebapp === this.data.TO_CONTACT && webapp.contacts) {
			objContact = webapp.contacts.data.getCurrentContact();
		}
		// Extract all phoneNumbers to add/remove them in whiteList
		var arrPhoneNumbers = this.data.getContactPhones(objContact);
		if(arrPhoneNumbers.length > 0){
			// Depending of the calling button, add or remove the phoneNumbers
			if(this.data.isInWhiteList(arrPhoneNumbers)){
				this.removeContactFromWL(arrPhoneNumbers);
			} else {
				this.addContactInWL(arrPhoneNumbers);
			}
		}
	},

	/**
	 * Callback of FilteringLevelChangedEvent
	 * @params {event:string} manager : the login of the manager
	 * @params {event:string} filteringlevel : enum filteringLevel (in 'value' field)
	 */
	onFilteringLevelChanged : function() {
		ICTouchAPI.debugServices.info("webapp.managerassistant.controlBase - onFilteringLevelChanged");
		var objArguments = ICTouchAPI.tools.getEventArguments(arguments);
		var managerLogin = objArguments.manager;
		var filteringLevel = objArguments.filteringlevel.value;
		this.data.setFilteringLevel(managerLogin, filteringLevel);
		ICTouchAPI.debugServices.info("webapp.managerassistant.controlBase - onFilteringLevelChanged end");
	},

	/**
	 * Delete all the numbers of the selected contact in the white list
	 */
	onDeleteContact : function() {
		if(this.data.getRole() == this.data.MANAGER_ROLE){
			//var managerLogin = this.data.arrManager[this.data.intCurrentWhiteListManager].strLabel;
			var arrPhoneNumbers = this.data.arrWhiteList[this.data.intCurrentWhiteListContact].arrPhones;
			this.removeContactFromWL(arrPhoneNumbers);
		}
	},

	/**
	 * Look for a contact if the contact list with search webapp
	 */
	onSearchContact : function() {
		// Create the search object with parameters
		var objSearch = {
			lineClickCallback : {
				neededData : "Contact",
				context: this,
				func: this.onSearchCallback
			},
			useDefaultCallMethod : false,
			stealth : true
		};
		// Start the search
		if(webapp.search){
			webapp.search.doSearch(objSearch, function(){ICTouchAPI.transitionServices.back();});
		}
	},

	/**
	 * Callback of doSearch function of search webapp
	 * @params {object} objContact : contact object
	 */
	onSearchCallback : function(objContact) {
		if(this.data.getRole() == this.data.MANAGER_ROLE){
			var arrPhones = this.data.getContactPhones(objContact);
			if(arrPhones){
				this.addContactInWL(arrPhones);
			}
		}
		ICTouchAPI.transitionServices.back();
	},

	/**
	 * Remove a contact from the White list
	 * @params {array} arrPhoneNumbers : the contact to remove from the white list
	 */
	removeContactFromWL : function(arrPhoneNumbers) {
		ICTouchAPI.APIServices.IctUser.removeContactsInWhiteList({params:[arrPhoneNumbers]});
	},

	/**
	 * Add a contact to the White list
	 * @params {array} arrPhoneNumbers : the contact to add to the white list
	 * @params {string} strLogin : the login of the manager
	 */
	addContactInWL : function(arrPhoneNumbers) {
		ICTouchAPI.APIServices.IctUser.addContactsInWhiteList({params:[arrPhoneNumbers]});
	},

	/**
	 *	Register or refresh the preview container on homepage.
	 */
	setPreview : function(){
		ICTouchAPI.debugServices.info("webapp.managerassistant.controlBase - setPreview");
		var that = this;
		
		// Clear the timer handler
		if(!this._hSetPreview){
			clearTimeout(this._hSetPreview);
			this._hSetPreview = null;
		}

		this._hSetPreview = setTimeout(function(){that._setPreview();},1000);
		ICTouchAPI.debugServices.info("webapp.managerassistant.controlBase - setPreview end");
	},
	
	_setPreview : function() {
		ICTouchAPI.debugServices.info("webapp.managerassistant.controlBase - _setPreview");
		// Clear the timer handler
		if(this._hSetPreview){
			clearTimeout(this._hSetPreview);
			this._hSetPreview = null;
		}
		
		var data = webapp.managerassistant.data;
		if(data.getNbMA() > 0){
			if(!data.isPreview) {
				// Register or unregister according to setting EnableManagerassistantPreview
				this._registerHomepageContainer();
			} else {
				this.refreshPreview();
			}
		} else {
			if(data.boolEnableMAPreview){
				this._unregisterManagerAssistantPreview();
			}
		}
		ICTouchAPI.debugServices.info("webapp.managerassistant.controlBase - _setPreview end");
	},

	/**
	 * Function called by webapp Homepage after the register of a preview.
	 * Instanciate the right preview view according to the view registered in webapp Homepage.
	 */
	setHomepageContainer : function (strWebapp, div) {
		if (strWebapp === "webapp.managerassistant.getManagerPreview") {
		webapp.managerassistant.previewContainer = new webapp.managerassistant.getManagerPreview({ }, div);
		}
		else if (strWebapp === "webapp.managerassistant.getBackupAssistantPreview") {
			var data = webapp.managerassistant.data;
			var strTitle = (data.getRole() == data.MANAGER_ROLE)? data.ASSISTANT_ROLE:data.MANAGER_ROLE;
			webapp.managerassistant.previewContainer = new UIElements.Container.ContainerControl(
			{
				objTitle: {
					strLabel 	: _(strTitle, data.i18n)
				},

				objContent: {
					name 	: "webapp.managerassistant.getBackupAssistantPreview",
					params  : {}
				},
				strHeight : "Full"
			},
			div);
		}
	},

	/**
	 *	Callback of 'AssistantAddedEvent' or 'ManagerAddedEvent'.
	 *	Add the contact to list and preview
	 */
	onManagerAssistantAdded : function(){
		ICTouchAPI.debugServices.info("webapp.managerassistant.controlBase - onManagerAssistantAdded");
		var objArguments = ICTouchAPI.tools.getEventArguments(arguments);
		var objContact = objArguments.assistant || objArguments.manager;

		// Add the assistant / manager in data
		if(objContact){
			this.data.addManagerAssistants([objContact]);
		}
		ICTouchAPI.debugServices.info("webapp.managerassistant.controlBase - onManagerAssistantAdded end");
	},

	/**
	 *	Callback of 'AssistantRemovedEvent' or 'ManagerRemovedEvent'.
	 *	Remove the contact from list and preview
	 *	@param strLogin {event:string} the login of the contact to remove
	 */
	onManagerAssistantRemoved : function(strLogin) {
		var isRemoved = false;
		if(strLogin && strLogin.value){
			isRemoved = this.data.removeManagerAssistant(strLogin.value);
		}
		if(!isRemoved){
			console.warn('webapp.managerassistant.controlBase - onManagerAssistantRemoved / Contact '+ (strLogin && strLogin.value) +' to remove not found')
		}
	},

	/**
	 * Refresh Preview Container if it exist
	 */
	refreshPreview : function()
	{
		if(this.previewContainer && this.previewContainer != null && typeof(this.previewContainer.refresh) == 'function')
			this.previewContainer.refresh();
	},

	updateWhiteUserRights : function(objSetting){
		if(objSetting){
			webapp.managerassistant.data.intWhitelistUserRights = objSetting.user_rights;
		}
	}
});

/*managerassistant*/
// Provide and create the managerassistant webapp.
dojo.require("webapp.managerassistant.controlBase");
dojo.provide("webapp.managerassistant");
dojo.declare("webapp.managerassistant",webapp.managerassistant.controlBase,{
});

webapp.managerassistant = new webapp.managerassistant();
dojo.provide("webapp.managerassistant.dataBase");
dojo.declare("webapp.managerassistant.dataBase",null,{

	//STATIC VARIABLE
	MANAGER_ROLE	: "Manager",
	ASSISTANT_ROLE	: "Assistant",
	UNKNOWN_ROLE	: "Unknown",

    filters			: [],

	TO_CONTACT		: "contact",
	TO_COMM			: "communication",

	i18n			: "webapp.managerassistant",

	// For Settings widget
	intCurrentWhiteListManager	: null,
	intCurrentWhiteListContact	: null,
	arrWidgetsData		: [],
	WIDGET_MANAGER_LIST	: 0,
	WIDGET_WHITE_LIST	: 1,
	WIDGET_NONE			: 2,
	arrManager			: [], // Contains index and login for the manager list in settings
	lstWhiteList			: {},
	arrWhiteList		: [],
	boolOnSettingWidget	: false,

	//Filtering levels
	NO_FILTER				: "NO_FILTER",
	ASSISTANT_NOTIFICATION	: "ASSISTANT_NOTIFICATION",
	MANAGER_NOTIFICATION	: "MANAGER_NOTIFICATION",
	FORWARD_TO_ASSISTANT	: "FORWARD_TO_ASSISTANT",

	//Buttons Variables
	BACK				: "BACK_BTN",
	WHITE_LIST_ADD		: "WHITE_LIST_ADD_BTN",
	WHITE_LIST_REMOVE	: "WHITE_LIST_REMOVE_BTN",
	ADD_WHITE_LIST		: "ADD_WHITE_LIST_BTN",
	DEL_WHITE_LIST		: "DEL_WHITE_LIST_BTN",
	INTRUDE				: "INTRUDE_BTN",
	PICK_UP				: "PICK_UP_BTN",
	TRANSFER_TO_MANAGER	: "TRANSFER_TO_MANAGER_BTN",
	TRANSFER_TO_ASSISTANT	: "TRANSFER_TO_ASSISTANT_BTN",
	CALL_MANAGER		: "CALL_MANAGER_BTN",
	CALL_ASSISTANT		: "CALL_ASSISTANT_BTN",
	// Backup assistant button (filters screen)
	BACKUP				: "BACKUP_BTN",
	// Used in the preview
	CALL				: "CALL_BTN",
	IM					: "IM_BTN",
	MODE				: "MODE_BTN",

	//Configuration Variables
	_userRole		: null,
	_arrManagerAssistants	: [], // objContacts
	//_lstSearchs			: {},
	lstManagerAssistantUI	: {}, // preview UI

	_imActivated	: true,
	isPreview		: false,
	isBackupPreviewRegistered	: false,
	_boolEnablePhoto: false,
	_boolEnableIM	: false,
	_boolBackupAssistantEnabled	: false,
	boolEnableMAPreview	: null,
	loginName		: "",
	intWhitelistUserRights : "",

	_boolPresenceAvailableInMA : false,
        
        isOXOMode : false,

	//searchId		: 0,
	//intCurrentContact : 0,

	strCurrentSelectedLogin	: null,

	constructor : function(){
		this._arrManagerAssistants = [];
		this._lstSearchs = {};
		this.arrWhiteList = [];

		this._userRole = this.UNKNOWN_ROLE;

		var strIconSize = "32";
		
		//construct the filters

		this.filters.push({
            intIndex: this.FORWARD_TO_ASSISTANT,
            strLabel: _(this.getDisplayFromMode(this.FORWARD_TO_ASSISTANT), this.i18n),
			strSecondaryContentIcon : this.getIconFromMode(this.FORWARD_TO_ASSISTANT, strIconSize)
        });
		this.filters.push({
            intIndex: this.MANAGER_NOTIFICATION,
            strLabel: _(this.getDisplayFromMode(this.MANAGER_NOTIFICATION), this.i18n),
			strSecondaryContentIcon : this.getIconFromMode(this.MANAGER_NOTIFICATION, strIconSize)
        });
        this.filters.push({
            intIndex: this.ASSISTANT_NOTIFICATION,
            strLabel: _(this.getDisplayFromMode(this.ASSISTANT_NOTIFICATION), this.i18n),
			strSecondaryContentIcon : this.getIconFromMode(this.ASSISTANT_NOTIFICATION, strIconSize)
        });
		this.filters.push({
            intIndex: this.NO_FILTER,
            strLabel: _(this.getDisplayFromMode(this.NO_FILTER), this.i18n),
			strSecondaryContentIcon : this.getIconFromMode(this.NO_FILTER, strIconSize)
        });

		// Buttons for settings widget
		this.arrWidgetsData[this.WIDGET_WHITE_LIST] = {buttons : []};
//		this.arrWidgetsData[this.WIDGET_MANAGER_LIST] = {buttons : []};
//		this.arrWidgetsData[this.WIDGET_NONE] = {buttons : []};

		var objIntrudeButton = {
			strButtonName: this.INTRUDE ,
			strButtonLabel:  _("Intrude", "webapp.managerassistant"),
			strButtonIcon: 'managerassistant-intrusion',
			arrCapabilities: [{module : "Telephony", capability :"intrude", instance: -1}],
			callback: dojo.hitch(webapp.managerassistant, webapp.managerassistant.onGetCallButtons)
		};

		var objPickUpButton = {
			strButtonName: this.PICK_UP ,
			strButtonLabel:  _("Get call", "webapp.managerassistant"),
			strButtonIcon: 'manager-assistant-manage-call',
			arrCapabilities: [{module : "Telephony", capability :"pickUp", instance: -1}],
			callback: dojo.hitch(webapp.managerassistant, webapp.managerassistant.onGetCallButtons)
		};

		var objCallManagerButton = {
			strButtonName: this.CALL_MANAGER ,
			strButtonLabel:  _("Manager", "webapp.managerassistant"),
			strButtonIcon: 'managerassistant-call-manager',
			arrCapabilities: [{module : "Telephony", capability :"callManager", instance: -1}],
			callback: dojo.hitch(webapp.managerassistant, webapp.managerassistant.onCallManagerButton)
		};

		var objCallAssistantButton = {
			strButtonName: this.CALL_ASSISTANT ,
			strButtonLabel:  _("Assistant", "webapp.managerassistant"),
			strButtonIcon: 'managerassistant-call-assistant',
			arrCapabilities: [{module : "Telephony", capability :"callAssistant", instance: -1}],
			callback: dojo.hitch(webapp.managerassistant, webapp.managerassistant.onCallAssistantButton)
		};

		var objTransfertToManagerButton = {
			strButtonName: this.TRANSFER_TO_MANAGER ,
			strButtonLabel:  _("To manager", "webapp.managerassistant"),
			strButtonIcon: 'managerassistant-deflect-manager',
			arrCapabilities: [{module : "Telephony", capability :"transferToManager", instance: -1}],
			callback: dojo.hitch(webapp.managerassistant, webapp.managerassistant.onTransfertToManagerButton)
		};

		var objTransfertToAssistantButton = {
			strButtonName: this.TRANSFER_TO_ASSISTANT ,
			strButtonLabel:  _("To assistant", "webapp.managerassistant"),
			strButtonIcon: 'communication-deflect-to-default',
			arrCapabilities: [{module : "Telephony", capability :"transferToAssistant", instance: -1}],
			callback: dojo.hitch(webapp.managerassistant, webapp.managerassistant.onTransfertToAssistantButton)
		};

		if (webapp.communication) {
            //this._addWhiteListButtonToExternal(this.TO_COMM);
			webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_FILTERED_CALL, objIntrudeButton);
			webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_FILTERED_RING, objPickUpButton);
			webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_CALLS, objCallManagerButton);
			webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_DOUBLE_CALL, objCallManagerButton);
			webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_CALLS, objCallAssistantButton);
			webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_DOUBLE_CALL, objCallAssistantButton);
			webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_CALLS, objTransfertToManagerButton);
			webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_DOUBLE_CALL, objTransfertToManagerButton);
			webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_CALLS, objTransfertToAssistantButton);
			webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_DOUBLE_CALL, objTransfertToAssistantButton);
        }
        // If the webapp communication is not loaded yet, subscribe to the event
        // "webapp.communication.loaded" emitted after the creation of the
        // communication view (posteCreate of getCommunicationBase)
        else {
            var handler = dojo.subscribe("webapp.communication.loaded", this, function() {
                //this._addWhiteListButtonToExternal(this.TO_COMM);
				webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_FILTERED_CALL, objIntrudeButton);
				webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_FILTERED_RING, objPickUpButton);
				webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_CALLS, objCallManagerButton);
				webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_DOUBLE_CALL, objCallManagerButton);
				webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_CALLS, objCallAssistantButton);
				webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_DOUBLE_CALL, objCallAssistantButton);
				webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_CALLS, objTransfertToManagerButton);
				webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_DOUBLE_CALL, objTransfertToManagerButton);
				webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_CALLS, objTransfertToAssistantButton);
				webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_DOUBLE_CALL, objTransfertToAssistantButton);

				dojo.unsubscribe(handler);
            });
        }

		if (webapp.contacts) {
            this._addWhiteListButtonToExternal(this.TO_CONTACT);
        }
        // If the webapp contacts is not loaded yet, subscribe to the event
        // "webapp.contacts.loaded" emitted after the creation of the
        // contacts view (posteCreate of getContactsBase)
        else {
            var handler = dojo.subscribe("webapp.contacts.loaded", this, function() {
                this._addWhiteListButtonToExternal(this.TO_CONTACT);
				dojo.unsubscribe(handler);
            });
        }

		var appBar = ICTouchAPI.AppBarServices.createAppBar("managerassistant", "filters", [this.BACKUP]);
		// Create the backup assistant button
		var backup_btn = new UIElements.AppButton.AppButtonControl(
			{
				strButtonName: this.BACKUP,
				strButtonLabel: _("Backup", "webapp.managerassistant"),
				strButtonIcon: "managerassistant-backup",
				callback: {
					context : webapp.managerassistant,
					func : webapp.managerassistant.onBackupButton
				}
			}
		);
		appBar.addAppButton(backup_btn);
		appBar.buildDom();
	},

	/**
	 * Add the white list button to contact or communication according to strWebapp
	 * @params {string} strWebapp : "contact" or "communication"
	 */
	_addWhiteListButtonToExternal:function(strWebapp) {
		var func = dojo.hitch(webapp.managerassistant, webapp.managerassistant.onWhiteListButton, strWebapp);
		var buttonAdd = {
			strButtonName: this.WHITE_LIST_ADD,
			strButtonLabel:  _("White List", "webapp.managerassistant"),
			strButtonIcon: 'manager-assistant-white-list',
			strStatusIcon: 'notif-off',
			callback: func
		};

		if(strWebapp == this.TO_COMM){
			dojo.subscribe("ManageExternalButtonsCom", this, this.onManageCommButton);
			webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_LOG, buttonAdd);
			webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_CALLS, buttonAdd);
			webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_LOG_CONFERENCE_PARTICIPANT_SELECTED, buttonAdd);
			webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_HOLD, buttonAdd);
			webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_HELD, buttonAdd);
			webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_INCOMING, buttonAdd);
			webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_CONFERENCE_PARTICIPANT_SELECTED, buttonAdd);

		} else if (strWebapp == this.TO_CONTACT) {
			dojo.subscribe("ManageExternalButtonsContact", this, this.onManageContactButton);
			webapp.contacts.addButton(buttonAdd);
		}
	},

	/**
	 * Indicate whether or not the button allows to add or remove the contact in white list in communication webapp
	 * @params {object} objContact : the current complete contact object
	 * @params {int} intStatus : the status of the communication webapp
	 */
	onManageCommButton : function(objContact, intStatus) {
		this.onManageGeneralButton(objContact, intStatus, this.TO_COMM);
	},

	/**
	 * Indicate whether or not the button allows to add or remove the contact in white list in contacts webapp
	 * @params {object} objContact : the current complete contact object
	 * @params {int} intStatus : the status of the communication webapp
	 */
	onManageContactButton : function(objContact, intStatus) {
		this.onManageGeneralButton(objContact, intStatus, this.TO_CONTACT);
	},

	/**
	 * Global function to manage Contact or Comm button
	 */
	onManageGeneralButton : function(objContact, intStatus, strWebapp) {
		var arrPhoneNumbers = this.getContactPhones(objContact);
		var clbkParams = {status:intStatus, phoneNumbers:arrPhoneNumbers, webapp:strWebapp, objContact:objContact};
		var boolInWhiteList = false;
		if(arrPhoneNumbers.length && this.getRole() == this.MANAGER_ROLE){
			boolInWhiteList = this.isInWhiteList(arrPhoneNumbers);
		}
		this.updateWLButton(boolInWhiteList, clbkParams);
	},

	/**
	 * Returns an array with all the phoneNumbers of a contact
	 * @params {object} objContact : a contact object
	 * @note : maybe to put in tools.js, one day
	 */
	getContactPhones : function(objContact) {
		var arrPhoneNumbers = [];
		if(objContact){
			if(objContact.officePhoneCan){
				arrPhoneNumbers.push(objContact.officePhoneCan);
			}
			if(objContact.personalHomeCan){
				arrPhoneNumbers.push(objContact.personalHomeCan);
			}
			if(objContact.personalMobileCan){
				arrPhoneNumbers.push(objContact.personalMobileCan);
			}
			if(objContact.faxCan){
				arrPhoneNumbers.push(objContact.faxCan);
			}
			if(objContact.personalFax){
				arrPhoneNumbers.push(objContact.personalFax);
			}
			if(objContact.assistant){
				arrPhoneNumbers.push(objContact.assistant);
			}
		}
		objContact = null;
		return arrPhoneNumbers;
	},
	
	/**
	 * update the whiteList button in communication / contacts webapp
	 * @params {bool} boolInWL : indicates whether or not the contact is in White list
	 * @params {object} params : contains the contact object, the status and the target webapp
	 */
	updateWLButton : function(boolInWL, params) {
		ICTouchAPI.debugServices.info("webapp.managerassistant.dataBase - updateWLButton");
		var appBar = null;
		var localContactType = null;
		var dmContactType = null;
		// Get current Communication appbar
		if(params.webapp == this.TO_COMM && webapp.communication){
			var numAppBar = webapp.communication.data.getNumAppBarFromStatus(params.status);
			appBar = ICTouchAPI.AppBarServices._getAppBarWidget("communication", "comstatus"+numAppBar);
		}
		// Get current Contacts appbar
		if(params.webapp == this.TO_CONTACT && webapp.contacts){
			appBar = ICTouchAPI.AppBarServices._getAppBarWidget("contacts", "contactsstatus"+params.status);
			localContactType = ICTouchAPI.tools.enumContactType.LOCAL;
			dmContactType = ICTouchAPI.tools.enumContactType.DM;
		}
		var btnWLAdd = null;
		if(appBar){
			btnWLAdd = appBar.getButton(this.WHITE_LIST_ADD);
		}
		if(btnWLAdd){
			if(this.intWhitelistUserRights !== 0 && this.getRole() == this.MANAGER_ROLE && params.objContact && (params.objContact.type == localContactType || params.objContact.type == dmContactType)){
				if(!boolInWL){
					btnWLAdd.show();
					btnWLAdd.setStatusIcon('notif-off');
				} else {
					btnWLAdd.show();
					btnWLAdd.setStatusIcon('notif-on');
				}
			} else {
				btnWLAdd.hide();
			}
			if(params.objContact && params.objContact.officePhone == "anonymous") {
				btnWLAdd.hide();
			}
		}
		ICTouchAPI.debugServices.info("webapp.managerassistant.dataBase - updateWLButton end");
	},

	/**
	 * Function called by updateUserRole, when the user role is got / has changed
	 * Check if the button "Backup" has to be shown/hidden according to the user role (manager -> hidden / assistant -> shown)
	 */
	updateBackupButton : function() {
		ICTouchAPI.debugServices.info("webapp.managerassistant.dataBase - updateBackupButton");
		ICTouchAPI.debugServices.debug("webapp.managerassistant.dataBase - updateBackupButton / role is: " + this.getRole());
		var appBar = ICTouchAPI.AppBarServices._getAppBarWidget("managerassistant", "filters");
		if (appBar){
			var btnBackup = appBar.getButton(this.BACKUP);
			if (btnBackup){
				if(this.getRole() == this.MANAGER_ROLE) {
					ICTouchAPI.debugServices.debug("webapp.managerassistant.dataBase - updateBackupButton / role is manager, hide the backup button");
					// Role is manager -> hide the backup button
					btnBackup.hide();
				}
				else if (this.getRole() == this.ASSISTANT_ROLE) {
					ICTouchAPI.debugServices.debug("webapp.managerassistant.dataBase - updateBackupButton / role is assistant, show the backup button");
					// Role is assistant -> show the backup button
					btnBackup.show();
				}
			}
		}
	},

	/**
	 * Replace the current white list of a manager by a new one
	 * @params {string} manager : manager login
	 * @params {array} arrContacts : an array with all contacts in the white list of the manager
	 */
	setWhiteList : function(manager, arrContacts) {
		ICTouchAPI.debugServices.info("webapp.managerassistant.dataBase - setWhiteList");
		if(this.loginName == manager){
			var arrWhiteList = [];
			for(var i=0 ; i<arrContacts.length ; i++){
				var label = ICTouchAPI.tools.getContactDisplayName(arrContacts[i]);/*((arrContacts[i].firstName)? arrContacts[i].firstName : "" )+" "+ ((arrContacts[i].name)? arrContacts[i].name : "");*/
				arrWhiteList.push({intIndex:i, arrPhones :this.getContactPhones(arrContacts[i]), strLabel : label});
			}
			this.arrWhiteList = arrWhiteList;
		}
		// If we are displaying the whiteList in settings, refresh it.
		if(this.boolOnSettingWLWidget && webapp.settings){
			webapp.settings.refreshWebappView();
		}

		if (webapp.communication){
			var objContactComm = webapp.communication.data.getCurrentContact();
			var intStatusComm = webapp.communication.getStatus();
			if(objContactComm){
				this.onManageCommButton(objContactComm, intStatusComm);
			}
		}

		if(webapp.contacts){
			var objContactContacts = webapp.contacts.data.getCurrentContact();
			var intStatusContacts = webapp.contacts.data.STATUS_HOME;
			if(objContactContacts){
				this.onManageContactButton(objContactContacts, intStatusContacts);
			}
		}
		ICTouchAPI.debugServices.info("webapp.managerassistant.dataBase - setWhiteList end");
	},

	/**
	 * Delete the white list of a manager
	 * @params {string} manager : the manager's login
	 */
	removeWhiteList : function(manager) {
		if(this.loginName == manager){
			this.arrWhiteList = [];
		}
	},

	/**
	 * Parse the whole local white list to check if a contact is in it.
	 * @params arrNumber {array} a list with every canonical number of the contact.
	 */
	isInWhiteList : function(arrNumber) {
		var i;
		var j;
		var whiteList = this.getWhiteList();
		for(i = 0 ; i < whiteList.length ; i++){
			for(j = 0 ; j < arrNumber.length ; j++){
				if(whiteList[i].arrPhones.indexOf(arrNumber[j]) != -1){
					// It is in white list
					arrNumber = null;
					return true;
				}
			}
		}
		// If we reach that point, those numbers are not in white list
		arrNumber = null;
		return false;
	},

	/**
	 * Return the contact object of a manager or an assistant, or null if not found
	 * @params {string} strLogin : login of the manager or assistant
	 */
	getMAByLogin : function(strLogin) {
		for (var i in this._arrManagerAssistants) {
			if(this._arrManagerAssistants[i].login == strLogin){
				return this._arrManagerAssistants[i];
			}
		}
		return null;
	},

	/**
	 * Update local variable '_boolEnablePhoto' and reload the preview container
	 * @params {bool} value : jsValue of setting 'EnableUserPhoto'
	 */
	updateEnablePhoto : function(value) {
		if(value){ // if undefined, I want it to be "false"
			this._boolEnablePhoto = true;
		} else {
			this._boolEnablePhoto = false;
		}
		webapp.managerassistant.refreshPreview();
	},
        
        updateNoMANotif : function(value) {
		if(value){ // if undefined, I want it to be "false"
			this.isOXOMode = true;
                        var strIconSize = "32";
                        this.filters = [];
              //rebuilt the filters for OXO Mode
        this.filters.push({
            intIndex: this.FORWARD_TO_ASSISTANT,
            strLabel: _(this.getDisplayFromMode(this.FORWARD_TO_ASSISTANT), this.i18n),
			strSecondaryContentIcon : this.getIconFromMode(this.FORWARD_TO_ASSISTANT, strIconSize)
        });

        this.filters.push({
            intIndex: this.ASSISTANT_NOTIFICATION,
            strLabel: _(this.getDisplayFromMode(this.ASSISTANT_NOTIFICATION), this.i18n),
			strSecondaryContentIcon : this.getIconFromMode(this.ASSISTANT_NOTIFICATION, strIconSize)
        });
	this.filters.push({
            intIndex: this.NO_FILTER,
            strLabel: _(this.getDisplayFromMode(this.NO_FILTER), this.i18n),
			strSecondaryContentIcon : this.getIconFromMode(this.NO_FILTER, strIconSize)
        });
		} else {
			this.isOXOMode = false;
		}
		webapp.managerassistant.refreshPreview();
	},

	/**
	 * Update local variable '_boolEnablePhoto' and reload the preview container
	 * @params {object} objSetting : setting 'EnableUserPhoto'
	 */
	updateEnableIM : function(boolState) {
		if(boolState){
			this._boolEnableIM = true;
		} else {
			this._boolEnableIM = false;
		}
	},

	getEnableIM : function() {
		return this._boolEnableIM;
	},

	/**
	 * Update local variable '_boolBackupAssistantEnabled'
	 * @params {Boolean} boolState : new value for _boolBackupAssistantEnabled
	 */
	setBackupAssistantEnabled : function(boolState) {
		if(boolState){
			this._boolBackupAssistantEnabled = true;
		} else {
			this._boolBackupAssistantEnabled = false;
		}
	},

	/**
	 * Get the local variable '_boolBackupAssistantEnabled'
	 * @return true is BackupAssistant mode is enabled, false otherwise
	 */
	getBackupAssistantEnabled : function() {
		return this._boolBackupAssistantEnabled;
	},

	/**
	 * Set the filtering level of a manager.
	 * @params {string} strManagerLogin : login of the manager
	 * @params {string} strFilteringLevel : enum of filteringLevel
	 */
	setFilteringLevel : function(strManagerLogin, strMode) {
		ICTouchAPI.debugServices.info("webapp.managerassistant.dataBase - setFilteringLevel");
		var strShortModeLabel = this.getShortDisplayFromMode(strMode);
		var strModeIcon = this.getIconFromMode(strMode);
		var arrLoginToUpdate = [];

		// Search Manager/Assistant object by login
		var objManagerAssistant = this.getManagerAssistantByLogin(strManagerLogin);
		if(objManagerAssistant && this.lstManagerAssistantUI[objManagerAssistant.objContact.contactId]) {
			arrLoginToUpdate.push(strManagerLogin);
		} else {
			if(strManagerLogin == this.loginName){
				// We are manager, update each assistant
				for(var j in this.lstManagerAssistantUI){
					var strLoginName = this.lstManagerAssistantUI[j].objContact.loginName;
					ICTouchAPI.debugServices.info("webapp.managerassistant.dataBase - setFilteringLevel - update assistant: " + strLoginName);
					arrLoginToUpdate.push(strLoginName);
				}
			}
		}

		// Update local data for each impacted manager / assistant
		for(var k = 0 ; k < arrLoginToUpdate.length ; k++){
			var objManagerAssistant = this.getManagerAssistantByLogin(arrLoginToUpdate[k]);

			if(objManagerAssistant && objManagerAssistant.mode !== strMode){
				objManagerAssistant.mode = strMode;

				// Update preview manager card
				this.lstManagerAssistantUI[objManagerAssistant.objContact.contactId].updateMode(strShortModeLabel, strModeIcon);
			}
		}

		if(this.objFiltersContainer && (this.strCurrentSelectedLogin == strManagerLogin || this.getRole() == this.MANAGER_ROLE)){
			this.objFiltersContainer.unselectAll();
			this.objFiltersContainer.selectAtIndex(this.getFilterNumberByMode(strMode));
			webapp.managerassistant.storeSelectedMode(strMode);
		}
		ICTouchAPI.debugServices.info("webapp.managerassistant.dataBase - setFilteringLevel end");
	},

	/**
	 * Set the role of the user
	 * @params {string} strRole : string "Manager" / "Assistant" / "Unknown"
	 */
	setUserRole : function(strRole) {
		this._userRole = strRole;
		if(strRole == this.MANAGER_ROLE && this.loginName){
			this.arrManager = [{intIndex:0, strLabel:this.loginName, login:this.loginName}];
		}
	},

	/**
	 * Set the login name of the user
	 * @params {string} strLogin : the login of the user
	 */
	setLoginName : function(strLogin) {
		this.loginName = strLogin;
		if(this.getRole() == this.MANAGER_ROLE && strLogin){
			this.arrManager = [{intIndex:0, strLabel:strLogin, login:strLogin}];
		}
	},

	/**
	 * Add one or several manager/assistant in preview and local data
	 * @params {array[objContact]} arrManagerAssistant : an array of contacts
	 */
	addManagerAssistants : function(arrManagerAssistant) {
		ICTouchAPI.debugServices.info("webapp.managerassistant.dataBase - addManagerAssistants");
		var boolResetPreview = false;
		if(arrManagerAssistant.length){
			for (var i in arrManagerAssistant) {
				var objContact = {
					objContact: arrManagerAssistant[i],
					intIndex: this._arrManagerAssistants.length,
					login: arrManagerAssistant[i].loginName,
					mode : null,
					IMPresence : null,
					telephonyPresence : null
				};

				//var index = this._arrManagerAssistants.length;
				// add it only if the manager isn't already logged
				if(!this.isManagerAssistantExisting(arrManagerAssistant[i].loginName)){
					this._arrManagerAssistants.push(objContact);
					boolResetPreview = true;
					// If we are assistant, add the manager to the list for settings
					if(this.getRole() != this.MANAGER_ROLE){
						var objManager = {
							intIndex: this.arrManager.length,
							strLabel: arrManagerAssistant[i].loginName
						}
						this.arrManager.push(objManager);
					}
					//webapp.managerassistant.consultLists(arrManagerAssistant[i].loginName);
					dojo.publish("HomepagePreviewModeChange", [true]);
				}
			}
		}
		// If we have one, set the preview container.
		if(boolResetPreview) {
				webapp.managerassistant.setPreview();
		}
		ICTouchAPI.debugServices.info("webapp.managerassistant.dataBase - addManagerAssistants end");
	},

	isManagerAssistantExisting : function(strLogin) {
		var bExist = false;
		for(var i in this._arrManagerAssistants){
			if(this._arrManagerAssistants[i].login == strLogin){
				bExist = true;
			}
		}
		strLogin = null;
		return bExist;
	},

	/**
	 * Remove a manager or assistant from preview and local data
	 * @params {string} strManagerAssistant is the manager or assistant login
	 */
	removeManagerAssistant : function(strManagerAssistant) {
		var MARemoved = false;
		for(var i=0 ; i < this._arrManagerAssistants.length ; i++){
			if(this._arrManagerAssistants[i].login == strManagerAssistant){
				this._arrManagerAssistants.splice(i,1);
				MARemoved = true;
				break;
			}
		}
		if(MARemoved){
			webapp.managerassistant.setPreview();
		}
		strManagerAssistant = null;
		return MARemoved;
	},

	/**
	 * Get one manager or assistant by his login name
	 * @params strLogin {string} the login of the manager or assistant
	 */
	getManagerAssistantByLogin : function(strLogin) {
		ICTouchAPI.debugServices.info("webapp.managerassistant.dataBase - getManagerAssistantByLogin");
		var objManagerAssistant = null;

		for(var i = 0 ; i < this._arrManagerAssistants.length ; i++){
			if(this._arrManagerAssistants[i].login == strLogin){
				objManagerAssistant = this._arrManagerAssistants[i];
				break;
			}
		}

		strLogin = null;

		ICTouchAPI.debugServices.info("webapp.managerassistant.dataBase - getManagerAssistantByLogin end");
		return objManagerAssistant;
	},

	/**
	 * Get the list of managers / assistants for display in UI.
	 */
	getManagerAssistantData : function() {
		ICTouchAPI.debugServices.info("webapp.managerassistant.dataBase - getManagerAssistantData");
		var arrMA = [];
		var objMA = null;
		for(var i=0 ; i < this._arrManagerAssistants.length ; i++){
			objMA = this.formatMAForDisplay(this._arrManagerAssistants[i]);
			arrMA.push(objMA);
		}
		ICTouchAPI.debugServices.info("webapp.managerassistant.dataBase - getManagerAssistantData end");
		return arrMA;
	},

	/**
	 * return the phone number of the manager associated to the current comlog
	 */
	getManagerPhoneNumber : function() {
	    if (webapp.communication) {
		    var objSelectedComLogEntry = webapp.communication.data.getSelectedEntry();

		    var objManager = this.getMAByLogin(objSelectedComLogEntry.objCallData.manager);
		    if (objManager && objManager.objContact) {
			return ICTouchAPI.tools.getContactPhone(objManager.objContact);
		    }
		    else {
			ICTouchAPI.debugServices.warning("webapp.managerassistant.dataBase - getManagerPhoneNumber found no manager!");
		    }
	    }
	    return null;
	},

	/**
	 * return an object readable by a menuList
	 * @params objMA {object} a contact object corresponding to the manager / assistant
	 */
	formatMAForDisplay : function(objMA) {
		ICTouchAPI.debugServices.info("webapp.managerassistant.dataBase - formatMAForDisplay");
		var objInfo = {
			objContact : objMA.objContact,
			strPrimaryContent: ICTouchAPI.tools.getContactDisplayName(objMA.objContact),
			strSecondaryContent: _(this.getShortDisplayFromMode(objMA.mode), "webapp.managerassistant"),
			intIndex: objMA.intIndex,
			objIconLeft : {icon: ICTouchAPI.tools.getTelephonyPresenceIconPath(objMA.telephonyPresence, '32')},
			strPicture : (objMA.objContact && objMA.objContact.photo) ? objMA.objContact.photo : ICTouchAPI.tools.getDefaultPhotoPath("user", 50),
			strModeIcon : this.getIconFromMode(objMA.mode) || 'managerassistant-off',
			boolNotSelectable : true,
			alternateStyle : true
		}

		if(!this.getEnablePhoto()){
			delete objInfo.strPicture;
		}

		// avoid space on the left of the menu list.
		if(!this.getTelephonyPresenceAvailable() && !this.getIMPresenceAvailable() && !this.getEnablePresenceInMA()){
			objInfo.strIconLeft = undefined;
		}
		objMA = null;

		ICTouchAPI.debugServices.info("webapp.managerassistant.dataBase - formatMAForDisplay end");
		return objInfo;
	},

	/**
	 * Get the display for a mode in filters widget.
	 * @params strMode {string} the constant string representing the mode.
	 */
	getDisplayFromMode : function(strMode) {
		var strDisplayMode = " ";
		if(strMode == this.NO_FILTER){
			strDisplayMode = "Off";
		} else if(strMode == this.ASSISTANT_NOTIFICATION){
			strDisplayMode = "manager receives assistant monitors";
		} else if(strMode == this.MANAGER_NOTIFICATION){
			strDisplayMode = "manager monitors assistant receives";
		} else if(strMode == this.FORWARD_TO_ASSISTANT){
			strDisplayMode = "manager does not receives assistant receives";
		} else {
                    ICTouchAPI.debugServices.warning("webapp.managerassistant.dataBase - undefined DISPLAY MODE");
                }
		strMode = null;
		return strDisplayMode;
	},

	/**
	 * Get the short display for a mode in manager/assistant preview, according to the Role.
	 * @params strMode {string} the constant string representing the mode.
	 */
	getShortDisplayFromMode : function(strMode) {
		var strDisplayMode = " ";
		var boolManager = (this.getRole() == this.MANAGER_ROLE);
		if(strMode == this.NO_FILTER){
			strDisplayMode = "manager/assistant off";
		} else if(strMode == this.ASSISTANT_NOTIFICATION){
			strDisplayMode = (boolManager) ? "monitors calls" : "receives calls";
		} else if(strMode == this.MANAGER_NOTIFICATION){
			strDisplayMode = (boolManager) ? "receives calls" : "monitors calls";
		} else if(strMode == this.FORWARD_TO_ASSISTANT){
			strDisplayMode = (boolManager) ? "receives calls" : "doesn't receive calls";
		}
                else {
                    ICTouchAPI.debugServices.warning("webapp.managerassistant.dataBase - undefined DISPLAY MODE");
                }
		strMode = null;
		return strDisplayMode;
	},

	/**
	 * Get the icon for a mode, with or without size.
	 * @params strMode {string} the constant string representing the mode.
	 * @params strSize {string} (optional) a size for the icon class
	 */
	getIconFromMode : function(strMode, strSize) {
		var strModeIcon = "";
		if(strMode == this.NO_FILTER){
			strModeIcon = "managerassistant-off";
		} else if(strMode == this.ASSISTANT_NOTIFICATION){
			strModeIcon = "managerassistant-manager-receives";
		} else if(strMode == this.MANAGER_NOTIFICATION){
			strModeIcon = "managerassistant-manager-monitors";
		} else if(strMode == this.FORWARD_TO_ASSISTANT){
			strModeIcon = "managerassistant-manager-no-receives";
		}
                else {
                    ICTouchAPI.debugServices.warning("webapp.managerassistant.dataBase - undefined DISPLAY MODE");
                }
		if(strSize){
			strModeIcon = strModeIcon + "-" + strSize;
		}
		strMode = null;
		strSize = null;
		return strModeIcon;
	},

	getNbMA : function() {
		return this._arrManagerAssistants.length;
	},

	getEnablePhoto : function() {
		return this._boolEnablePhoto;
	},

	getWhiteList : function() {
		return this.arrWhiteList || [];
	},

	getManagerList : function() {
		return this.arrManager || [];
	},

	getRole : function(){
		return this._userRole;
	},

	getLoginName : function() {
		return this.loginName;
	},

	getManagerAssistants : function() {
		return this._arrManagerAssistants;
	},

	getFiltersData : function() {
		return this.filters;
	},

	getIMPresenceAvailable : function() {
		return this.boolIMPresenceAvailable;
	},

	getTelephonyPresenceAvailable : function() {
		return this.boolTelephonyPresenceAvailable;
	},

	isImActivated : function() {
		return (webapp.instantmessaging)?true:false ;
	},

	setIMPresenceAvailable : function(boolIMPresenceAvailable) {
		this.boolIMPresenceAvailable = boolIMPresenceAvailable;
		boolIMPresenceAvailable = null;
	},

	setTelephonyPresenceAvailable : function(boolTelephonyPresenceAvailable) {
		this.boolTelephonyPresenceAvailable = boolTelephonyPresenceAvailable;
		boolTelephonyPresenceAvailable = null;
	},

	/**
	 * Update local variable '_boolPresenceAvailableInMA'
	 * @params {boolean} boolState setting 'EnableManagerassistantPresence' value
	 */
	updateEnablePresenceInMA : function(boolState) {
		ICTouchAPI.debugServices.debug("webapp.managerassistant.dataBase - updateEnablePresenceInMA");
		if(boolState){
			this._boolPresenceAvailableInMA = true;
		} else {
			this._boolPresenceAvailableInMA = false;
		}

		// Reload manager/assistant cards to manage new presence setting.
		var arrMA = this.getManagerAssistants();
		var objInfo = null;
		for(var i = 0 ; i < arrMA.length ; i++){
			objInfo = this.formatMAForDisplay(arrMA[i]);
			this.lstManagerAssistantUI[arrMA[i].objContact.contactId].updateInfo(objInfo);
		}
	},

	getEnablePresenceInMA : function() {
		return this._boolPresenceAvailableInMA;
	},

	getFilterNumberByMode : function(strMode) {
		var id = 0;

		for(var i = 0 ; i < this.filters.length ; i++){
			if(this.filters[i].intIndex == strMode){
				id = i;
				break;
			}
		}
		
		strMode = null;

		return id;
	},

	/**
	 * Update the presence of a manager / assistant
	 * @params imAddress {string} im address of the contact
	 * @params IMPresence {string} a label for the IM presence
	 * @params telephonyPresence {string} a label for the telephony presence
	 */
	updatePresenceInContact : function(imAddress, IMPresence, telephonyPresence) {
		ICTouchAPI.debugServices.info("webapp.managerassistant.dataBase - updatePresenceInContact");
		for(var i = 0 ; i < this._arrManagerAssistants.length ; i++){
			if(this._arrManagerAssistants[i].objContact.collaborationId == imAddress){
				if(this._arrManagerAssistants[i].telephonyPresence !== telephonyPresence){
					this._arrManagerAssistants[i].telephonyPresence = telephonyPresence;
				}
				if(this._arrManagerAssistants[i].IMPresence !== IMPresence){
					this._arrManagerAssistants[i].IMPresence = IMPresence;
				}

				var contactId = this._arrManagerAssistants[i].objContact.contactId;

				if(this.lstManagerAssistantUI[contactId]){
					var objInfo = this.formatMAForDisplay(this._arrManagerAssistants[i]);
					this.lstManagerAssistantUI[contactId].updateInfo(objInfo);
				}

				break;
			}
		}
		
		imAddress = null;
		IMPresence = null;
		telephonyPresence = null;
		ICTouchAPI.debugServices.info("webapp.managerassistant.dataBase - updatePresenceInContact end");
	},

	getCurrentWhiteListManagerLogin : function() {
		var manager = this.arrManager[this.intCurrentWhiteListManager];
		if(manager && manager.loginName){
			return manager.loginName;
		}
		return "";
	},

	contactsListFeedback : function (value) {
		ICTouchAPI.debugServices.info("webapp.managerassistant.dataBase - contactsListFeedback");
		var values = value.split(".");
		var buttonName = values.shift();
		var buttonArg = values.join('.') || '';
		switch(buttonName)
		{
			case this.CALL:
				if(webapp.communication && buttonArg){
					webapp.communication.apiCall(buttonArg, true);
				}
				break;
			case this.IM:
				var user = this.getMAByLogin(buttonArg);
				if(user && user.objContact && webapp.instantmessaging){
					webapp.instantmessaging.prepareToSendIm(user.objContact);
				} else {
					console.warn("ManagerAssistant - DataBase - contactsListFeedback : missing user of no IM");
				}
				break;
			case this.MODE:
				this.strCurrentSelectedLogin = buttonArg;
				webapp.managerassistant.openFilters();
				break;
			default:
				console.warn("will do nothing to "+values[1]);
		}
		ICTouchAPI.debugServices.info("webapp.managerassistant.dataBase - contactsListFeedback end");
	},

	/***********************************************************
	 ******* Specific functions for settings integration *******
	 ***********************************************************/

	initForView : function(view) {
		webapp.settings.refreshWebappView();
		this.boolOnSettingWLWidget = true;
	},

	stopForView : function(view) {
		this.boolOnSettingWLWidget = false;
	},

	getActionBarAppButtonsFromView : function(view) {
		if(this.getRole() == this.MANAGER_ROLE){
			return this.arrWidgetsData[this.WIDGET_WHITE_LIST].buttons;
		} else {
			return [];
		}
	},

	initAppBarButtons : function(view) {
		/*if(this.arrWhiteList.length == 0){
			var actionBar =  webapp.settings.getActionBar();
			var btn = actionBar.getButton(this.DELETE);
			if (btn) {
				btn.greyTint();
			}
		}*/
	}
});

dojo.require("webapp.managerassistant.dataBase");
dojo.provide("webapp.managerassistant.data");
dojo.declare("webapp.managerassistant.data",webapp.managerassistant.dataBase,{
});
webapp.managerassistant.data = new webapp.managerassistant.data();

dojo.provide("webapp.managerassistant.getManagerDetailsBase");
dojo.declare("webapp.managerassistant.getManagerDetailsBase",
    [ICTouchAPI.webWidget, dojox.dtl._Templated],
    {
		// UIObjects
		objCallButton			: null,
		objIMButton				: null,
		objFilterButton			: null,
		objMAInfo				: null,

		// Data
		objManagerAssistant		: null,
		boolEnableIM			: null,

		// Dom references
		domContactInfo			: null,
		domCallButton			: null,
		domIMButton				: null,
		domFilterButton			: null,
		domList					: null,

		constructor : function(objManagerAssistant) {
			if(objManagerAssistant){
				this.objManagerAssistant = objManagerAssistant;
			}
		},

		postMixInProperties : function() {
			webapp.managerassistant.data.lstManagerAssistantUI[this.objManagerAssistant.objContact.contactId] = this;
			this.boolEnableIM = webapp.managerassistant.data.getEnableIM();
		},

		postCreate : function(){
			ICTouchAPI.debugServices.info("webapp.managerassistant.getManagerDetailsBase - postCreate");
			var data = webapp.managerassistant.data;
			var func = dojo.hitch(data,data.contactsListFeedback);

			// Create the info area
			this.objMAInfo = new UIElements.MenuList.MenuListControl({
				arrItems : [this.objManagerAssistant],
				boolPreview : true,
				autoSelectFirst : false,
				boolScroll : false
			}, this.domContactInfo);
			
			// Create the Call button
			this.objCallButton = new UIElements.AppButton.AppButtonControl({
				strButtonName: data.CALL+"."+this.objManagerAssistant.objContact.officePhone,
				strButtonLabel: _("Call", "webapp.managerassistant"),
				strButtonIcon: 'communication-call',
				intIconSize : 32,
				callback: func
			}, this.domCallButton);

			if(this.boolEnableIM){
				// Create the IM button
				this.objIMButton = new UIElements.AppButton.AppButtonControl({
					strButtonName: data.IM+"."+this.objManagerAssistant.objContact.loginName,
					strButtonLabel: _("IM", "webapp.managerassistant"),
					strButtonIcon: 'im-application',
					intIconSize : 32,
					callback: func
				}, this.domIMButton);
			}

			// Create the Filter button on second dom
			this.objFilterButton = new UIElements.AppButton.AppButtonControl({
				strButtonName: data.MODE+"."+this.objManagerAssistant.objContact.loginName,
				strButtonLabel: _('Mode', 'webapp.managerassistant'),
				strButtonIcon: this.objManagerAssistant.strModeIcon,
				intIconSize : 32,
				callback: func
			}, this.domFilterButton);

			// Now that the widget is initiated, ask for mode and presence info.
			webapp.managerassistant.askForInfo(this.objManagerAssistant.objContact);

			ICTouchAPI.debugServices.info("webapp.managerassistant.getManagerDetailsBase - postCreate end");
		},

		/**
		 * Update the Mode button + mode text
		 * @params strShortMode {string} a short label for the new mode
		 * @params strModeIcon {string} the icon of the new mode
		 */
		updateMode : function(strShortMode, strModeIcon){
			ICTouchAPI.debugServices.info("webapp.managerassistant.getManagerDetailsBase - updateMode");
			this.objMAInfo.updateSecondaryContent(0, strShortMode);
			this.objFilterButton.attr('strButtonIcon', strModeIcon);
			ICTouchAPI.debugServices.info("webapp.managerassistant.getManagerDetailsBase - updateMode end");
		},

		/**
		 * Show or hide the IM button according to it's state
		 */
		updateIMButton : function(){
			ICTouchAPI.debugServices.info("webapp.managerassistant.getManagerDetailsBase - updateIMButton");
			if(webapp.managerassistant.data.getEnableIM()){
				this.objIMButton.show();
			} else {
				this.objIMButton.hide();
			}
			ICTouchAPI.debugServices.info("webapp.managerassistant.getManagerDetailsBase - updateIMButton end");
		},

		/**
		 * Update the info area.
		 * @params objInfo {object} an object of every changes for the info area
		 */
		updateInfo : function(objInfo) {
			ICTouchAPI.debugServices.info("webapp.managerassistant.getManagerDetailsBase - updateInfo");
			this.objMAInfo.updateItem(objInfo);
			ICTouchAPI.debugServices.info("webapp.managerassistant.getManagerDetailsBase - updateInfo end");
		},

		destroy : function() {
			ICTouchAPI.debugServices.debug("webapp.managerassistant.getManagerDetailsBase - destroy");
			delete webapp.managerassistant.data.lstManagerAssistantUI[this.objManagerAssistant.objContact.contactId];
			this.inherited(arguments);
		}
    });dojo.require("webapp.managerassistant.getManagerDetailsBase");
dojo.provide("webapp.managerassistant.getManagerDetails");
dojo.declare("webapp.managerassistant.getManagerDetails",
    webapp.managerassistant.getManagerDetailsBase,
    {
        templatePath: dojo.moduleUrl("webapp.managerassistant","templates/getManagerDetails8082.html"),
    }
);
dojo.provide("webapp.managerassistant.getManagerPreviewBase");
dojo.declare("webapp.managerassistant.getManagerPreviewBase",
	[ICTouchAPI.webWidget, dojox.dtl._Templated],
	{
		arrManagerAssistant		: [],
		domList					: [],
		scroll					: null,

	constructor : function() {
		this.domList = [];
	},

	postCreate:function(){
		var data = webapp.managerassistant.data;
		var strTitle = (data.getRole() == data.MANAGER_ROLE)? data.ASSISTANT_ROLE:data.MANAGER_ROLE;
		new UIElements.Container.ContainerControl({
			objTitle: {
				strLabel 	: _(strTitle, data.i18n)
			},

			objContent: {
				name 	: "webapp.managerassistant.getManagerList",
				params  : {}
			},
			strHeight : "Full"
		}, this.domContainer);
	}
	
});
dojo.require("webapp.managerassistant.getManagerPreviewBase");
dojo.provide("webapp.managerassistant.getManagerPreview");
dojo.declare("webapp.managerassistant.getManagerPreview",
    webapp.managerassistant.getManagerPreviewBase,
    {
        templatePath: dojo.moduleUrl("webapp.managerassistant","templates/getManagerPreview8082.html"),
    }
);
dojo.provide("webapp.managerassistant.getBackupAssistantPreviewBase");
dojo.declare("webapp.managerassistant.getBackupAssistantPreviewBase",
	[ICTouchAPI.webWidget, dojox.dtl._Templated],
	{

	strBackupLabel1 : null,
	strBackupLabel2 : null,

	attributeMap : {
		strBackupLabel1 : { node : "domStrBackupLabel1", type: "innerHTML"},
		strBackupLabel2 : { node : "domStrBackupLabel2", type: "innerHTML"}
	},

	constructor : function() {
	},

	postMixInProperties : function() {
		this.strBackupLabel1 = _("Backup mode", "webapp.managerassistant");
		this.strBackupLabel2 = _("Tap here and select another routing profile to deactivate backup mode", "webapp.managerassistant");
	},

	postCreate:function(){
	},

	_clicked:function(){
		webapp.managerassistant.onBackupAssistantPreview();
	}

	/*destroy: function() {
		if (this.strBackupLabel1) {
			delete this.strBackupLabel1;
		}
		if (this.strBackupLabel2) {
			delete this.strBackupLabel2;
		}
		this.inherited(arguments);
	},*/
	
});
dojo.require("webapp.managerassistant.getBackupAssistantPreviewBase");
dojo.provide("webapp.managerassistant.getBackupAssistantPreview");
dojo.declare("webapp.managerassistant.getBackupAssistantPreview",
    webapp.managerassistant.getBackupAssistantPreviewBase,
    {
        templatePath: dojo.moduleUrl("webapp.managerassistant","templates/getBackupAssistantPreview8082.html"),
    }
);
dojo.provide("webapp.managerassistant.getFiltersBase");
dojo.declare("webapp.managerassistant.getFiltersBase",
	[ICTouchAPI.webWidget, dojox.dtl._Templated],
	{
		objFiltersContent	: null,
		domFiltersContent	: null,

		postCreate:function(){
		ICTouchAPI.debugServices.info("webapp.managerassistant.getFiltersBase - postCreate");
			var strTitle = _("Manager and Assistant mode", webapp.managerassistant.data.i18n);
			var func = {
				context:this.webapp,
				func: this.webapp.storeSelectedMode
			}
			var ctrl = new UIElements.ApplicationMode.FullControl(
			{
				content : {
					name    : "UIElements.SelectList.SelectListControl",
					params  : {
						arrItems: webapp.managerassistant.data.getFiltersData(),
						intContainerSize: 4,
						boolMultiselect: false,
						itemCallback: func
					}
				},
				objTitle : {
					strLabel: strTitle
				}
			}, this.domSelectList);

			// Manage the appBar.
			ICTouchAPI.AppBarServices.setAppBar("managerassistant", "filters", "getFilters");

			// Create appbar for filters
			var backFunc = {
				context : webapp.managerassistant,
				func : webapp.managerassistant.buttonBackCallback
			}
			// Create the static back button
			ICTouchAPI.AppBarServices.addExitButton("managerassistant", "filters", true, backFunc);

			// 1st getContent gives the ApplicationMode object ; 2nd one gives the container below the title
			webapp.managerassistant.data.objFiltersContainer = ctrl.getContent().getContent();
			ICTouchAPI.debugServices.info("webapp.managerassistant.getFiltersBase - postCreate end");
		},

		destroy : function() {
			delete webapp.managerassistant.data.objFiltersContainer;
			this.inherited(arguments);
		}
	}
);
dojo.require("webapp.managerassistant.getFiltersBase");
dojo.provide("webapp.managerassistant.getFilters");
dojo.declare("webapp.managerassistant.getFilters",
	webapp.managerassistant.getFiltersBase,
	{
		templatePath: dojo.moduleUrl("webapp.managerassistant","templates/getFilters8082.html")
	}
);
dojo.provide("webapp.managerassistant.getManagerListBase");
dojo.declare("webapp.managerassistant.getManagerListBase",
    [ICTouchAPI.webWidget, dojox.dtl._Templated],
    {
		arrMA : null,

		arrMaWidgets : null,

		constructor : function() {
			this.arrMA = webapp.managerassistant.data.getManagerAssistantData();
		},

		postMixInProperties : function() {
			webapp.managerassistant.data.objPreviewListWidget = this;
		},

		postCreate : function() {
			ICTouchAPI.debugServices.info("webapp.managerassistant.getManagerListBase - postCreate");
			this.arrMaWidgets = [];
			for(var i = 0 ; i< this.arrMA.length ; i++){
				var objWidget = new webapp.managerassistant.getManagerDetails(this.arrMA[i]);
				this.arrMaWidgets.push({
					objWidget : objWidget,
					intIndex : this.arrMA[i].intIndex,
					contactId : this.arrMA[i].contactId
				});
			}

			webapp.managerassistant.data.objManagerList = new UIElements.CustomList.CustomListControl({
				arrItems: this.arrMaWidgets,
				boolMultiselect: true,
				intSelectLimit: 0
			}, this.domList);
			ICTouchAPI.debugServices.info("webapp.managerassistant.getManagerListBase - postCreate end");
		},

		/**
		 * Ask an update of telephony / IM presence for a manager / assistant.
		 * @params contactId {string} the Id of the manager / assistant
		 * @params IMPresence {string} the im presence
		 * @params telephonyPresence {string} the telephony presence
		 */
		updatePresence : function(contactId, IMPresence, telephonyPresence) {
			ICTouchAPI.debugServices.info("webapp.managerassistant.getManagerListBase - updatePresence");
			for(var i = 0 ; i< this.arrMaWidgets.length ; i++){
				if(this.arrMaWidgets[i].contactId == contactId){
					this.arrMaWidgets[i].updatePresence(IMPresence, telephonyPresence);
					break;
				}
			}
			ICTouchAPI.debugServices.info("webapp.managerassistant.getManagerListBase - updatePresence end");
		},

		destroy : function() {
			delete webapp.managerassistant.data.objManagerList;
			this.inherited(arguments);
		}
	}
);
dojo.require("webapp.managerassistant.getManagerListBase");
dojo.provide("webapp.managerassistant.getManagerList");
dojo.declare("webapp.managerassistant.getManagerList",
    webapp.managerassistant.getManagerListBase,
    {
        templatePath: dojo.moduleUrl("webapp.managerassistant","templates/getManagerList8082.html")
    }
);
dojo.provide("webapp.managerassistant.getWhiteListBase");
dojo.declare("webapp.managerassistant.getWhiteListBase",
    [ICTouchAPI.webWidget, dojox.dtl._Templated],
    {
		constructor : function() {

		},

		postMixInProperties : function() {

		},

		postCreate : function() {
			var data = webapp.managerassistant.data;
			if(data.getRole() == data.MANAGER_ROLE){
				var arrContacts = data.getWhiteList();
				var func = function(index){
					var myDS = ICTouchAPI.dataStoreServices.getStore('contacts');
					var objContact = myDS.find(["officePhone","personalHome","personalMobile","officePhoneCan","personalHomeCan","personalMobileCan","personalFax"],arrContacts[index].arrPhones[0])[0];
					if(webapp.contacts) {
						webapp.contacts.showContact({
						objContact : objContact
						});
					}
				}
				if(arrContacts && arrContacts.length){
					new UIElements.SelectList.SelectListControl({
						arrItems: arrContacts,
						intContainerSize: 7,
						boolMultiselect: false,
						intSelectLimit: 1,
						boolScroll: true,
						itemCallback: func
					}, this.domList);
				}
			} else {
				console.log('Only managers are allowed to see and manage a white list');
			}
		}
	}
);
dojo.require("webapp.managerassistant.getWhiteListBase");
dojo.provide("webapp.managerassistant.getWhiteList");
dojo.declare("webapp.managerassistant.getWhiteList",
    webapp.managerassistant.getWhiteListBase,
    {
        templatePath: dojo.moduleUrl("webapp.managerassistant","templates/getWhiteList8082.html")
    }
);


