dojo.provide("webapp.managerassistant.getManagerListBase");
dojo.declare("webapp.managerassistant.getManagerListBase",
    [ICTouchAPI.webWidget, dojox.dtl._Templated],
    {
		arrMA : null,

		arrMaWidgets : null,

		constructor : function() {
			this.arrMA = webapp.managerassistant.data.getManagerAssistantData();
		},

		postMixInProperties : function() {
			webapp.managerassistant.data.objPreviewListWidget = this;
		},

		postCreate : function() {
			ICTouchAPI.debugServices.info("webapp.managerassistant.getManagerListBase - postCreate");
			this.arrMaWidgets = [];
			for(var i = 0 ; i< this.arrMA.length ; i++){
				var objWidget = new webapp.managerassistant.getManagerDetails(this.arrMA[i]);
				this.arrMaWidgets.push({
					objWidget : objWidget,
					intIndex : this.arrMA[i].intIndex,
					contactId : this.arrMA[i].contactId
				});
			}

			webapp.managerassistant.data.objManagerList = new UIElements.CustomList.CustomListControl({
				arrItems: this.arrMaWidgets,
				boolMultiselect: true,
				intSelectLimit: 0
			}, this.domList);
			ICTouchAPI.debugServices.info("webapp.managerassistant.getManagerListBase - postCreate end");
		},

		/**
		 * Ask an update of telephony / IM presence for a manager / assistant.
		 * @params contactId {string} the Id of the manager / assistant
		 * @params IMPresence {string} the im presence
		 * @params telephonyPresence {string} the telephony presence
		 */
		updatePresence : function(contactId, IMPresence, telephonyPresence) {
			ICTouchAPI.debugServices.info("webapp.managerassistant.getManagerListBase - updatePresence");
			for(var i = 0 ; i< this.arrMaWidgets.length ; i++){
				if(this.arrMaWidgets[i].contactId == contactId){
					this.arrMaWidgets[i].updatePresence(IMPresence, telephonyPresence);
					break;
				}
			}
			ICTouchAPI.debugServices.info("webapp.managerassistant.getManagerListBase - updatePresence end");
		},

		destroy : function() {
			delete webapp.managerassistant.data.objManagerList;
			this.inherited(arguments);
		}
	}
);
