dojo.provide("webapp.managerassistant.getManagerDetailsBase");
dojo.declare("webapp.managerassistant.getManagerDetailsBase",
    [ICTouchAPI.webWidget, dojox.dtl._Templated],
    {
		// UIObjects
		objCallButton			: null,
		objIMButton				: null,
		objFilterButton			: null,
		objMAInfo				: null,

		// Data
		objManagerAssistant		: null,
		boolEnableIM			: null,

		// Dom references
		domContactInfo			: null,
		domCallButton			: null,
		domIMButton				: null,
		domFilterButton			: null,
		domList					: null,

		constructor : function(objManagerAssistant) {
			if(objManagerAssistant){
				this.objManagerAssistant = objManagerAssistant;
			}
		},

		postMixInProperties : function() {
			webapp.managerassistant.data.lstManagerAssistantUI[this.objManagerAssistant.objContact.contactId] = this;
			this.boolEnableIM = webapp.managerassistant.data.getEnableIM();
		},

		postCreate : function(){
			ICTouchAPI.debugServices.info("webapp.managerassistant.getManagerDetailsBase - postCreate");
			var data = webapp.managerassistant.data;
			var func = dojo.hitch(data,data.contactsListFeedback);

			// Create the info area
			this.objMAInfo = new UIElements.MenuList.MenuListControl({
				arrItems : [this.objManagerAssistant],
				boolPreview : true,
				autoSelectFirst : false,
				boolScroll : false
			}, this.domContactInfo);
			
			// Create the Call button
			this.objCallButton = new UIElements.AppButton.AppButtonControl({
				strButtonName: data.CALL+"."+this.objManagerAssistant.objContact.officePhone,
				strButtonLabel: _("Call", "webapp.managerassistant"),
				strButtonIcon: 'communication-call',
				intIconSize : 32,
				callback: func
			}, this.domCallButton);

			if(this.boolEnableIM){
				// Create the IM button
				this.objIMButton = new UIElements.AppButton.AppButtonControl({
					strButtonName: data.IM+"."+this.objManagerAssistant.objContact.loginName,
					strButtonLabel: _("IM", "webapp.managerassistant"),
					strButtonIcon: 'im-application',
					intIconSize : 32,
					callback: func
				}, this.domIMButton);
			}

			// Create the Filter button on second dom
			this.objFilterButton = new UIElements.AppButton.AppButtonControl({
				strButtonName: data.MODE+"."+this.objManagerAssistant.objContact.loginName,
				strButtonLabel: _('Mode', 'webapp.managerassistant'),
				strButtonIcon: this.objManagerAssistant.strModeIcon,
				intIconSize : 32,
				callback: func
			}, this.domFilterButton);

			// Now that the widget is initiated, ask for mode and presence info.
			webapp.managerassistant.askForInfo(this.objManagerAssistant.objContact);

			ICTouchAPI.debugServices.info("webapp.managerassistant.getManagerDetailsBase - postCreate end");
		},

		/**
		 * Update the Mode button + mode text
		 * @params strShortMode {string} a short label for the new mode
		 * @params strModeIcon {string} the icon of the new mode
		 */
		updateMode : function(strShortMode, strModeIcon){
			ICTouchAPI.debugServices.info("webapp.managerassistant.getManagerDetailsBase - updateMode");
			this.objMAInfo.updateSecondaryContent(0, strShortMode);
			this.objFilterButton.attr('strButtonIcon', strModeIcon);
			ICTouchAPI.debugServices.info("webapp.managerassistant.getManagerDetailsBase - updateMode end");
		},

		/**
		 * Show or hide the IM button according to it's state
		 */
		updateIMButton : function(){
			ICTouchAPI.debugServices.info("webapp.managerassistant.getManagerDetailsBase - updateIMButton");
			if(webapp.managerassistant.data.getEnableIM()){
				this.objIMButton.show();
			} else {
				this.objIMButton.hide();
			}
			ICTouchAPI.debugServices.info("webapp.managerassistant.getManagerDetailsBase - updateIMButton end");
		},

		/**
		 * Update the info area.
		 * @params objInfo {object} an object of every changes for the info area
		 */
		updateInfo : function(objInfo) {
			ICTouchAPI.debugServices.info("webapp.managerassistant.getManagerDetailsBase - updateInfo");
			this.objMAInfo.updateItem(objInfo);
			ICTouchAPI.debugServices.info("webapp.managerassistant.getManagerDetailsBase - updateInfo end");
		},

		destroy : function() {
			ICTouchAPI.debugServices.debug("webapp.managerassistant.getManagerDetailsBase - destroy");
			delete webapp.managerassistant.data.lstManagerAssistantUI[this.objManagerAssistant.objContact.contactId];
			this.inherited(arguments);
		}
    });