dojo.provide("webapp.managerassistant.dataBase");
dojo.declare("webapp.managerassistant.dataBase",null,{

	//STATIC VARIABLE
	MANAGER_ROLE	: "Manager",
	ASSISTANT_ROLE	: "Assistant",
	UNKNOWN_ROLE	: "Unknown",

    filters			: [],

	TO_CONTACT		: "contact",
	TO_COMM			: "communication",

	i18n			: "webapp.managerassistant",

	// For Settings widget
	intCurrentWhiteListManager	: null,
	intCurrentWhiteListContact	: null,
	arrWidgetsData		: [],
	WIDGET_MANAGER_LIST	: 0,
	WIDGET_WHITE_LIST	: 1,
	WIDGET_NONE			: 2,
	arrManager			: [], // Contains index and login for the manager list in settings
	lstWhiteList			: {},
	arrWhiteList		: [],
	boolOnSettingWidget	: false,

	//Filtering levels
	NO_FILTER				: "NO_FILTER",
	ASSISTANT_NOTIFICATION	: "ASSISTANT_NOTIFICATION",
	MANAGER_NOTIFICATION	: "MANAGER_NOTIFICATION",
	FORWARD_TO_ASSISTANT	: "FORWARD_TO_ASSISTANT",

	//Buttons Variables
	BACK				: "BACK_BTN",
	WHITE_LIST_ADD		: "WHITE_LIST_ADD_BTN",
	WHITE_LIST_REMOVE	: "WHITE_LIST_REMOVE_BTN",
	ADD_WHITE_LIST		: "ADD_WHITE_LIST_BTN",
	DEL_WHITE_LIST		: "DEL_WHITE_LIST_BTN",
	INTRUDE				: "INTRUDE_BTN",
	PICK_UP				: "PICK_UP_BTN",
	TRANSFER_TO_MANAGER	: "TRANSFER_TO_MANAGER_BTN",
	TRANSFER_TO_ASSISTANT	: "TRANSFER_TO_ASSISTANT_BTN",
	CALL_MANAGER		: "CALL_MANAGER_BTN",
	CALL_ASSISTANT		: "CALL_ASSISTANT_BTN",
	// Backup assistant button (filters screen)
	BACKUP				: "BACKUP_BTN",
	// Used in the preview
	CALL				: "CALL_BTN",
	IM					: "IM_BTN",
	MODE				: "MODE_BTN",

	//Configuration Variables
	_userRole		: null,
	_arrManagerAssistants	: [], // objContacts
	//_lstSearchs			: {},
	lstManagerAssistantUI	: {}, // preview UI

	_imActivated	: true,
	isPreview		: false,
	isBackupPreviewRegistered	: false,
	_boolEnablePhoto: false,
	_boolEnableIM	: false,
	_boolBackupAssistantEnabled	: false,
	boolEnableMAPreview	: null,
	loginName		: "",
	intWhitelistUserRights : "",

	_boolPresenceAvailableInMA : false,
        
        isOXOMode : false,

	//searchId		: 0,
	//intCurrentContact : 0,

	strCurrentSelectedLogin	: null,

	constructor : function(){
		this._arrManagerAssistants = [];
		this._lstSearchs = {};
		this.arrWhiteList = [];

		this._userRole = this.UNKNOWN_ROLE;

		var strIconSize = "32";
		
		//construct the filters

		this.filters.push({
            intIndex: this.FORWARD_TO_ASSISTANT,
            strLabel: _(this.getDisplayFromMode(this.FORWARD_TO_ASSISTANT), this.i18n),
			strSecondaryContentIcon : this.getIconFromMode(this.FORWARD_TO_ASSISTANT, strIconSize)
        });
		this.filters.push({
            intIndex: this.MANAGER_NOTIFICATION,
            strLabel: _(this.getDisplayFromMode(this.MANAGER_NOTIFICATION), this.i18n),
			strSecondaryContentIcon : this.getIconFromMode(this.MANAGER_NOTIFICATION, strIconSize)
        });
        this.filters.push({
            intIndex: this.ASSISTANT_NOTIFICATION,
            strLabel: _(this.getDisplayFromMode(this.ASSISTANT_NOTIFICATION), this.i18n),
			strSecondaryContentIcon : this.getIconFromMode(this.ASSISTANT_NOTIFICATION, strIconSize)
        });
		this.filters.push({
            intIndex: this.NO_FILTER,
            strLabel: _(this.getDisplayFromMode(this.NO_FILTER), this.i18n),
			strSecondaryContentIcon : this.getIconFromMode(this.NO_FILTER, strIconSize)
        });

		// Buttons for settings widget
		this.arrWidgetsData[this.WIDGET_WHITE_LIST] = {buttons : []};
//		this.arrWidgetsData[this.WIDGET_MANAGER_LIST] = {buttons : []};
//		this.arrWidgetsData[this.WIDGET_NONE] = {buttons : []};

		var objIntrudeButton = {
			strButtonName: this.INTRUDE ,
			strButtonLabel:  _("Intrude", "webapp.managerassistant"),
			strButtonIcon: 'managerassistant-intrusion',
			arrCapabilities: [{module : "Telephony", capability :"intrude", instance: -1}],
			callback: dojo.hitch(webapp.managerassistant, webapp.managerassistant.onGetCallButtons)
		};

		var objPickUpButton = {
			strButtonName: this.PICK_UP ,
			strButtonLabel:  _("Get call", "webapp.managerassistant"),
			strButtonIcon: 'manager-assistant-manage-call',
			arrCapabilities: [{module : "Telephony", capability :"pickUp", instance: -1}],
			callback: dojo.hitch(webapp.managerassistant, webapp.managerassistant.onGetCallButtons)
		};

		var objCallManagerButton = {
			strButtonName: this.CALL_MANAGER ,
			strButtonLabel:  _("Manager", "webapp.managerassistant"),
			strButtonIcon: 'managerassistant-call-manager',
			arrCapabilities: [{module : "Telephony", capability :"callManager", instance: -1}],
			callback: dojo.hitch(webapp.managerassistant, webapp.managerassistant.onCallManagerButton)
		};

		var objCallAssistantButton = {
			strButtonName: this.CALL_ASSISTANT ,
			strButtonLabel:  _("Assistant", "webapp.managerassistant"),
			strButtonIcon: 'managerassistant-call-assistant',
			arrCapabilities: [{module : "Telephony", capability :"callAssistant", instance: -1}],
			callback: dojo.hitch(webapp.managerassistant, webapp.managerassistant.onCallAssistantButton)
		};

		var objTransfertToManagerButton = {
			strButtonName: this.TRANSFER_TO_MANAGER ,
			strButtonLabel:  _("To manager", "webapp.managerassistant"),
			strButtonIcon: 'managerassistant-deflect-manager',
			arrCapabilities: [{module : "Telephony", capability :"transferToManager", instance: -1}],
			callback: dojo.hitch(webapp.managerassistant, webapp.managerassistant.onTransfertToManagerButton)
		};

		var objTransfertToAssistantButton = {
			strButtonName: this.TRANSFER_TO_ASSISTANT ,
			strButtonLabel:  _("To assistant", "webapp.managerassistant"),
			strButtonIcon: 'communication-deflect-to-default',
			arrCapabilities: [{module : "Telephony", capability :"transferToAssistant", instance: -1}],
			callback: dojo.hitch(webapp.managerassistant, webapp.managerassistant.onTransfertToAssistantButton)
		};

		if (webapp.communication) {
            //this._addWhiteListButtonToExternal(this.TO_COMM);
			webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_FILTERED_CALL, objIntrudeButton);
			webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_FILTERED_RING, objPickUpButton);
			webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_CALLS, objCallManagerButton);
			webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_DOUBLE_CALL, objCallManagerButton);
			webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_CALLS, objCallAssistantButton);
			webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_DOUBLE_CALL, objCallAssistantButton);
			webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_CALLS, objTransfertToManagerButton);
			webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_DOUBLE_CALL, objTransfertToManagerButton);
			webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_CALLS, objTransfertToAssistantButton);
			webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_DOUBLE_CALL, objTransfertToAssistantButton);
        }
        // If the webapp communication is not loaded yet, subscribe to the event
        // "webapp.communication.loaded" emitted after the creation of the
        // communication view (posteCreate of getCommunicationBase)
        else {
            var handler = dojo.subscribe("webapp.communication.loaded", this, function() {
                //this._addWhiteListButtonToExternal(this.TO_COMM);
				webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_FILTERED_CALL, objIntrudeButton);
				webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_FILTERED_RING, objPickUpButton);
				webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_CALLS, objCallManagerButton);
				webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_DOUBLE_CALL, objCallManagerButton);
				webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_CALLS, objCallAssistantButton);
				webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_DOUBLE_CALL, objCallAssistantButton);
				webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_CALLS, objTransfertToManagerButton);
				webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_DOUBLE_CALL, objTransfertToManagerButton);
				webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_CALLS, objTransfertToAssistantButton);
				webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_DOUBLE_CALL, objTransfertToAssistantButton);

				dojo.unsubscribe(handler);
            });
        }

		if (webapp.contacts) {
            this._addWhiteListButtonToExternal(this.TO_CONTACT);
        }
        // If the webapp contacts is not loaded yet, subscribe to the event
        // "webapp.contacts.loaded" emitted after the creation of the
        // contacts view (posteCreate of getContactsBase)
        else {
            var handler = dojo.subscribe("webapp.contacts.loaded", this, function() {
                this._addWhiteListButtonToExternal(this.TO_CONTACT);
				dojo.unsubscribe(handler);
            });
        }

		var appBar = ICTouchAPI.AppBarServices.createAppBar("managerassistant", "filters", [this.BACKUP]);
		// Create the backup assistant button
		var backup_btn = new UIElements.AppButton.AppButtonControl(
			{
				strButtonName: this.BACKUP,
				strButtonLabel: _("Backup", "webapp.managerassistant"),
				strButtonIcon: "managerassistant-backup",
				callback: {
					context : webapp.managerassistant,
					func : webapp.managerassistant.onBackupButton
				}
			}
		);
		appBar.addAppButton(backup_btn);
		appBar.buildDom();
	},

	/**
	 * Add the white list button to contact or communication according to strWebapp
	 * @params {string} strWebapp : "contact" or "communication"
	 */
	_addWhiteListButtonToExternal:function(strWebapp) {
		var func = dojo.hitch(webapp.managerassistant, webapp.managerassistant.onWhiteListButton, strWebapp);
		var buttonAdd = {
			strButtonName: this.WHITE_LIST_ADD,
			strButtonLabel:  _("White List", "webapp.managerassistant"),
			strButtonIcon: 'manager-assistant-white-list',
			strStatusIcon: 'notif-off',
			callback: func
		};

		if(strWebapp == this.TO_COMM){
			dojo.subscribe("ManageExternalButtonsCom", this, this.onManageCommButton);
			webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_LOG, buttonAdd);
			webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_CALLS, buttonAdd);
			webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_LOG_CONFERENCE_PARTICIPANT_SELECTED, buttonAdd);
			webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_HOLD, buttonAdd);
			webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_HELD, buttonAdd);
			webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_INCOMING, buttonAdd);
			webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_CONFERENCE_PARTICIPANT_SELECTED, buttonAdd);

		} else if (strWebapp == this.TO_CONTACT) {
			dojo.subscribe("ManageExternalButtonsContact", this, this.onManageContactButton);
			webapp.contacts.addButton(buttonAdd);
		}
	},

	/**
	 * Indicate whether or not the button allows to add or remove the contact in white list in communication webapp
	 * @params {object} objContact : the current complete contact object
	 * @params {int} intStatus : the status of the communication webapp
	 */
	onManageCommButton : function(objContact, intStatus) {
		this.onManageGeneralButton(objContact, intStatus, this.TO_COMM);
	},

	/**
	 * Indicate whether or not the button allows to add or remove the contact in white list in contacts webapp
	 * @params {object} objContact : the current complete contact object
	 * @params {int} intStatus : the status of the communication webapp
	 */
	onManageContactButton : function(objContact, intStatus) {
		this.onManageGeneralButton(objContact, intStatus, this.TO_CONTACT);
	},

	/**
	 * Global function to manage Contact or Comm button
	 */
	onManageGeneralButton : function(objContact, intStatus, strWebapp) {
		var arrPhoneNumbers = this.getContactPhones(objContact);
		var clbkParams = {status:intStatus, phoneNumbers:arrPhoneNumbers, webapp:strWebapp, objContact:objContact};
		var boolInWhiteList = false;
		if(arrPhoneNumbers.length && this.getRole() == this.MANAGER_ROLE){
			boolInWhiteList = this.isInWhiteList(arrPhoneNumbers);
		}
		this.updateWLButton(boolInWhiteList, clbkParams);
	},

	/**
	 * Returns an array with all the phoneNumbers of a contact
	 * @params {object} objContact : a contact object
	 * @note : maybe to put in tools.js, one day
	 */
	getContactPhones : function(objContact) {
		var arrPhoneNumbers = [];
		if(objContact){
			if(objContact.officePhoneCan){
				arrPhoneNumbers.push(objContact.officePhoneCan);
			}
			if(objContact.personalHomeCan){
				arrPhoneNumbers.push(objContact.personalHomeCan);
			}
			if(objContact.personalMobileCan){
				arrPhoneNumbers.push(objContact.personalMobileCan);
			}
			if(objContact.faxCan){
				arrPhoneNumbers.push(objContact.faxCan);
			}
			if(objContact.personalFax){
				arrPhoneNumbers.push(objContact.personalFax);
			}
			if(objContact.assistant){
				arrPhoneNumbers.push(objContact.assistant);
			}
		}
		objContact = null;
		return arrPhoneNumbers;
	},
	
	/**
	 * update the whiteList button in communication / contacts webapp
	 * @params {bool} boolInWL : indicates whether or not the contact is in White list
	 * @params {object} params : contains the contact object, the status and the target webapp
	 */
	updateWLButton : function(boolInWL, params) {
		ICTouchAPI.debugServices.info("webapp.managerassistant.dataBase - updateWLButton");
		var appBar = null;
		var localContactType = null;
		var dmContactType = null;
		// Get current Communication appbar
		if(params.webapp == this.TO_COMM && webapp.communication){
			var numAppBar = webapp.communication.data.getNumAppBarFromStatus(params.status);
			appBar = ICTouchAPI.AppBarServices._getAppBarWidget("communication", "comstatus"+numAppBar);
		}
		// Get current Contacts appbar
		if(params.webapp == this.TO_CONTACT && webapp.contacts){
			appBar = ICTouchAPI.AppBarServices._getAppBarWidget("contacts", "contactsstatus"+params.status);
			localContactType = ICTouchAPI.tools.enumContactType.LOCAL;
			dmContactType = ICTouchAPI.tools.enumContactType.DM;
		}
		var btnWLAdd = null;
		if(appBar){
			btnWLAdd = appBar.getButton(this.WHITE_LIST_ADD);
		}
		if(btnWLAdd){
			if(this.intWhitelistUserRights !== 0 && this.getRole() == this.MANAGER_ROLE && params.objContact && (params.objContact.type == localContactType || params.objContact.type == dmContactType)){
				if(!boolInWL){
					btnWLAdd.show();
					btnWLAdd.setStatusIcon('notif-off');
				} else {
					btnWLAdd.show();
					btnWLAdd.setStatusIcon('notif-on');
				}
			} else {
				btnWLAdd.hide();
			}
			if(params.objContact && params.objContact.officePhone == "anonymous") {
				btnWLAdd.hide();
			}
		}
		ICTouchAPI.debugServices.info("webapp.managerassistant.dataBase - updateWLButton end");
	},

	/**
	 * Function called by updateUserRole, when the user role is got / has changed
	 * Check if the button "Backup" has to be shown/hidden according to the user role (manager -> hidden / assistant -> shown)
	 */
	updateBackupButton : function() {
		ICTouchAPI.debugServices.info("webapp.managerassistant.dataBase - updateBackupButton");
		ICTouchAPI.debugServices.debug("webapp.managerassistant.dataBase - updateBackupButton / role is: " + this.getRole());
		var appBar = ICTouchAPI.AppBarServices._getAppBarWidget("managerassistant", "filters");
		if (appBar){
			var btnBackup = appBar.getButton(this.BACKUP);
			if (btnBackup){
				if(this.getRole() == this.MANAGER_ROLE) {
					ICTouchAPI.debugServices.debug("webapp.managerassistant.dataBase - updateBackupButton / role is manager, hide the backup button");
					// Role is manager -> hide the backup button
					btnBackup.hide();
				}
				else if (this.getRole() == this.ASSISTANT_ROLE) {
					ICTouchAPI.debugServices.debug("webapp.managerassistant.dataBase - updateBackupButton / role is assistant, show the backup button");
					// Role is assistant -> show the backup button
					btnBackup.show();
				}
			}
		}
	},

	/**
	 * Replace the current white list of a manager by a new one
	 * @params {string} manager : manager login
	 * @params {array} arrContacts : an array with all contacts in the white list of the manager
	 */
	setWhiteList : function(manager, arrContacts) {
		ICTouchAPI.debugServices.info("webapp.managerassistant.dataBase - setWhiteList");
		if(this.loginName == manager){
			var arrWhiteList = [];
			for(var i=0 ; i<arrContacts.length ; i++){
				var label = ICTouchAPI.tools.getContactDisplayName(arrContacts[i]);/*((arrContacts[i].firstName)? arrContacts[i].firstName : "" )+" "+ ((arrContacts[i].name)? arrContacts[i].name : "");*/
				arrWhiteList.push({intIndex:i, arrPhones :this.getContactPhones(arrContacts[i]), strLabel : label});
			}
			this.arrWhiteList = arrWhiteList;
		}
		// If we are displaying the whiteList in settings, refresh it.
		if(this.boolOnSettingWLWidget && webapp.settings){
			webapp.settings.refreshWebappView();
		}

		if (webapp.communication){
			var objContactComm = webapp.communication.data.getCurrentContact();
			var intStatusComm = webapp.communication.getStatus();
			if(objContactComm){
				this.onManageCommButton(objContactComm, intStatusComm);
			}
		}

		if(webapp.contacts){
			var objContactContacts = webapp.contacts.data.getCurrentContact();
			var intStatusContacts = webapp.contacts.data.STATUS_HOME;
			if(objContactContacts){
				this.onManageContactButton(objContactContacts, intStatusContacts);
			}
		}
		ICTouchAPI.debugServices.info("webapp.managerassistant.dataBase - setWhiteList end");
	},

	/**
	 * Delete the white list of a manager
	 * @params {string} manager : the manager's login
	 */
	removeWhiteList : function(manager) {
		if(this.loginName == manager){
			this.arrWhiteList = [];
		}
	},

	/**
	 * Parse the whole local white list to check if a contact is in it.
	 * @params arrNumber {array} a list with every canonical number of the contact.
	 */
	isInWhiteList : function(arrNumber) {
		var i;
		var j;
		var whiteList = this.getWhiteList();
		for(i = 0 ; i < whiteList.length ; i++){
			for(j = 0 ; j < arrNumber.length ; j++){
				if(whiteList[i].arrPhones.indexOf(arrNumber[j]) != -1){
					// It is in white list
					arrNumber = null;
					return true;
				}
			}
		}
		// If we reach that point, those numbers are not in white list
		arrNumber = null;
		return false;
	},

	/**
	 * Return the contact object of a manager or an assistant, or null if not found
	 * @params {string} strLogin : login of the manager or assistant
	 */
	getMAByLogin : function(strLogin) {
		for (var i in this._arrManagerAssistants) {
			if(this._arrManagerAssistants[i].login == strLogin){
				return this._arrManagerAssistants[i];
			}
		}
		return null;
	},

	/**
	 * Update local variable '_boolEnablePhoto' and reload the preview container
	 * @params {bool} value : jsValue of setting 'EnableUserPhoto'
	 */
	updateEnablePhoto : function(value) {
		if(value){ // if undefined, I want it to be "false"
			this._boolEnablePhoto = true;
		} else {
			this._boolEnablePhoto = false;
		}
		webapp.managerassistant.refreshPreview();
	},
        
        updateNoMANotif : function(value) {
		if(value){ // if undefined, I want it to be "false"
			this.isOXOMode = true;
                        var strIconSize = "32";
                        this.filters = [];
              //rebuilt the filters for OXO Mode
        this.filters.push({
            intIndex: this.FORWARD_TO_ASSISTANT,
            strLabel: _(this.getDisplayFromMode(this.FORWARD_TO_ASSISTANT), this.i18n),
			strSecondaryContentIcon : this.getIconFromMode(this.FORWARD_TO_ASSISTANT, strIconSize)
        });

        this.filters.push({
            intIndex: this.ASSISTANT_NOTIFICATION,
            strLabel: _(this.getDisplayFromMode(this.ASSISTANT_NOTIFICATION), this.i18n),
			strSecondaryContentIcon : this.getIconFromMode(this.ASSISTANT_NOTIFICATION, strIconSize)
        });
	this.filters.push({
            intIndex: this.NO_FILTER,
            strLabel: _(this.getDisplayFromMode(this.NO_FILTER), this.i18n),
			strSecondaryContentIcon : this.getIconFromMode(this.NO_FILTER, strIconSize)
        });
		} else {
			this.isOXOMode = false;
		}
		webapp.managerassistant.refreshPreview();
	},

	/**
	 * Update local variable '_boolEnablePhoto' and reload the preview container
	 * @params {object} objSetting : setting 'EnableUserPhoto'
	 */
	updateEnableIM : function(boolState) {
		if(boolState){
			this._boolEnableIM = true;
		} else {
			this._boolEnableIM = false;
		}
	},

	getEnableIM : function() {
		return this._boolEnableIM;
	},

	/**
	 * Update local variable '_boolBackupAssistantEnabled'
	 * @params {Boolean} boolState : new value for _boolBackupAssistantEnabled
	 */
	setBackupAssistantEnabled : function(boolState) {
		if(boolState){
			this._boolBackupAssistantEnabled = true;
		} else {
			this._boolBackupAssistantEnabled = false;
		}
	},

	/**
	 * Get the local variable '_boolBackupAssistantEnabled'
	 * @return true is BackupAssistant mode is enabled, false otherwise
	 */
	getBackupAssistantEnabled : function() {
		return this._boolBackupAssistantEnabled;
	},

	/**
	 * Set the filtering level of a manager.
	 * @params {string} strManagerLogin : login of the manager
	 * @params {string} strFilteringLevel : enum of filteringLevel
	 */
	setFilteringLevel : function(strManagerLogin, strMode) {
		ICTouchAPI.debugServices.info("webapp.managerassistant.dataBase - setFilteringLevel");
		var strShortModeLabel = this.getShortDisplayFromMode(strMode);
		var strModeIcon = this.getIconFromMode(strMode);
		var arrLoginToUpdate = [];

		// Search Manager/Assistant object by login
		var objManagerAssistant = this.getManagerAssistantByLogin(strManagerLogin);
		if(objManagerAssistant && this.lstManagerAssistantUI[objManagerAssistant.objContact.contactId]) {
			arrLoginToUpdate.push(strManagerLogin);
		} else {
			if(strManagerLogin == this.loginName){
				// We are manager, update each assistant
				for(var j in this.lstManagerAssistantUI){
					var strLoginName = this.lstManagerAssistantUI[j].objContact.loginName;
					ICTouchAPI.debugServices.info("webapp.managerassistant.dataBase - setFilteringLevel - update assistant: " + strLoginName);
					arrLoginToUpdate.push(strLoginName);
				}
			}
		}

		// Update local data for each impacted manager / assistant
		for(var k = 0 ; k < arrLoginToUpdate.length ; k++){
			var objManagerAssistant = this.getManagerAssistantByLogin(arrLoginToUpdate[k]);

			if(objManagerAssistant && objManagerAssistant.mode !== strMode){
				objManagerAssistant.mode = strMode;

				// Update preview manager card
				this.lstManagerAssistantUI[objManagerAssistant.objContact.contactId].updateMode(strShortModeLabel, strModeIcon);
			}
		}

		if(this.objFiltersContainer && (this.strCurrentSelectedLogin == strManagerLogin || this.getRole() == this.MANAGER_ROLE)){
			this.objFiltersContainer.unselectAll();
			this.objFiltersContainer.selectAtIndex(this.getFilterNumberByMode(strMode));
			webapp.managerassistant.storeSelectedMode(strMode);
		}
		ICTouchAPI.debugServices.info("webapp.managerassistant.dataBase - setFilteringLevel end");
	},

	/**
	 * Set the role of the user
	 * @params {string} strRole : string "Manager" / "Assistant" / "Unknown"
	 */
	setUserRole : function(strRole) {
		this._userRole = strRole;
		if(strRole == this.MANAGER_ROLE && this.loginName){
			this.arrManager = [{intIndex:0, strLabel:this.loginName, login:this.loginName}];
		}
	},

	/**
	 * Set the login name of the user
	 * @params {string} strLogin : the login of the user
	 */
	setLoginName : function(strLogin) {
		this.loginName = strLogin;
		if(this.getRole() == this.MANAGER_ROLE && strLogin){
			this.arrManager = [{intIndex:0, strLabel:strLogin, login:strLogin}];
		}
	},

	/**
	 * Add one or several manager/assistant in preview and local data
	 * @params {array[objContact]} arrManagerAssistant : an array of contacts
	 */
	addManagerAssistants : function(arrManagerAssistant) {
		ICTouchAPI.debugServices.info("webapp.managerassistant.dataBase - addManagerAssistants");
		var boolResetPreview = false;
		if(arrManagerAssistant.length){
			for (var i in arrManagerAssistant) {
				var objContact = {
					objContact: arrManagerAssistant[i],
					intIndex: this._arrManagerAssistants.length,
					login: arrManagerAssistant[i].loginName,
					mode : null,
					IMPresence : null,
					telephonyPresence : null
				};

				//var index = this._arrManagerAssistants.length;
				// add it only if the manager isn't already logged
				if(!this.isManagerAssistantExisting(arrManagerAssistant[i].loginName)){
					this._arrManagerAssistants.push(objContact);
					boolResetPreview = true;
					// If we are assistant, add the manager to the list for settings
					if(this.getRole() != this.MANAGER_ROLE){
						var objManager = {
							intIndex: this.arrManager.length,
							strLabel: arrManagerAssistant[i].loginName
						}
						this.arrManager.push(objManager);
					}
					//webapp.managerassistant.consultLists(arrManagerAssistant[i].loginName);
					dojo.publish("HomepagePreviewModeChange", [true]);
				}
			}
		}
		// If we have one, set the preview container.
		if(boolResetPreview) {
				webapp.managerassistant.setPreview();
		}
		ICTouchAPI.debugServices.info("webapp.managerassistant.dataBase - addManagerAssistants end");
	},

	isManagerAssistantExisting : function(strLogin) {
		var bExist = false;
		for(var i in this._arrManagerAssistants){
			if(this._arrManagerAssistants[i].login == strLogin){
				bExist = true;
			}
		}
		strLogin = null;
		return bExist;
	},

	/**
	 * Remove a manager or assistant from preview and local data
	 * @params {string} strManagerAssistant is the manager or assistant login
	 */
	removeManagerAssistant : function(strManagerAssistant) {
		var MARemoved = false;
		for(var i=0 ; i < this._arrManagerAssistants.length ; i++){
			if(this._arrManagerAssistants[i].login == strManagerAssistant){
				this._arrManagerAssistants.splice(i,1);
				MARemoved = true;
				break;
			}
		}
		if(MARemoved){
			webapp.managerassistant.setPreview();
		}
		strManagerAssistant = null;
		return MARemoved;
	},

	/**
	 * Get one manager or assistant by his login name
	 * @params strLogin {string} the login of the manager or assistant
	 */
	getManagerAssistantByLogin : function(strLogin) {
		ICTouchAPI.debugServices.info("webapp.managerassistant.dataBase - getManagerAssistantByLogin");
		var objManagerAssistant = null;

		for(var i = 0 ; i < this._arrManagerAssistants.length ; i++){
			if(this._arrManagerAssistants[i].login == strLogin){
				objManagerAssistant = this._arrManagerAssistants[i];
				break;
			}
		}

		strLogin = null;

		ICTouchAPI.debugServices.info("webapp.managerassistant.dataBase - getManagerAssistantByLogin end");
		return objManagerAssistant;
	},

	/**
	 * Get the list of managers / assistants for display in UI.
	 */
	getManagerAssistantData : function() {
		ICTouchAPI.debugServices.info("webapp.managerassistant.dataBase - getManagerAssistantData");
		var arrMA = [];
		var objMA = null;
		for(var i=0 ; i < this._arrManagerAssistants.length ; i++){
			objMA = this.formatMAForDisplay(this._arrManagerAssistants[i]);
			arrMA.push(objMA);
		}
		ICTouchAPI.debugServices.info("webapp.managerassistant.dataBase - getManagerAssistantData end");
		return arrMA;
	},

	/**
	 * return the phone number of the manager associated to the current comlog
	 */
	getManagerPhoneNumber : function() {
	    if (webapp.communication) {
		    var objSelectedComLogEntry = webapp.communication.data.getSelectedEntry();

		    var objManager = this.getMAByLogin(objSelectedComLogEntry.objCallData.manager);
		    if (objManager && objManager.objContact) {
			return ICTouchAPI.tools.getContactPhone(objManager.objContact);
		    }
		    else {
			ICTouchAPI.debugServices.warning("webapp.managerassistant.dataBase - getManagerPhoneNumber found no manager!");
		    }
	    }
	    return null;
	},

	/**
	 * return an object readable by a menuList
	 * @params objMA {object} a contact object corresponding to the manager / assistant
	 */
	formatMAForDisplay : function(objMA) {
		ICTouchAPI.debugServices.info("webapp.managerassistant.dataBase - formatMAForDisplay");
		var objInfo = {
			objContact : objMA.objContact,
			strPrimaryContent: ICTouchAPI.tools.getContactDisplayName(objMA.objContact),
			strSecondaryContent: _(this.getShortDisplayFromMode(objMA.mode), "webapp.managerassistant"),
			intIndex: objMA.intIndex,
			objIconLeft : {icon: ICTouchAPI.tools.getTelephonyPresenceIconPath(objMA.telephonyPresence, '32')},
			strPicture : (objMA.objContact && objMA.objContact.photo) ? objMA.objContact.photo : ICTouchAPI.tools.getDefaultPhotoPath("user", 50),
			strModeIcon : this.getIconFromMode(objMA.mode) || 'managerassistant-off',
			boolNotSelectable : true,
			alternateStyle : true
		}

		if(!this.getEnablePhoto()){
			delete objInfo.strPicture;
		}

		// avoid space on the left of the menu list.
		if(!this.getTelephonyPresenceAvailable() && !this.getIMPresenceAvailable() && !this.getEnablePresenceInMA()){
			objInfo.strIconLeft = undefined;
		}
		objMA = null;

		ICTouchAPI.debugServices.info("webapp.managerassistant.dataBase - formatMAForDisplay end");
		return objInfo;
	},

	/**
	 * Get the display for a mode in filters widget.
	 * @params strMode {string} the constant string representing the mode.
	 */
	getDisplayFromMode : function(strMode) {
		var strDisplayMode = " ";
		if(strMode == this.NO_FILTER){
			strDisplayMode = "Off";
		} else if(strMode == this.ASSISTANT_NOTIFICATION){
			strDisplayMode = "manager receives assistant monitors";
		} else if(strMode == this.MANAGER_NOTIFICATION){
			strDisplayMode = "manager monitors assistant receives";
		} else if(strMode == this.FORWARD_TO_ASSISTANT){
			strDisplayMode = "manager does not receives assistant receives";
		} else {
                    ICTouchAPI.debugServices.warning("webapp.managerassistant.dataBase - undefined DISPLAY MODE");
                }
		strMode = null;
		return strDisplayMode;
	},

	/**
	 * Get the short display for a mode in manager/assistant preview, according to the Role.
	 * @params strMode {string} the constant string representing the mode.
	 */
	getShortDisplayFromMode : function(strMode) {
		var strDisplayMode = " ";
		var boolManager = (this.getRole() == this.MANAGER_ROLE);
		if(strMode == this.NO_FILTER){
			strDisplayMode = "manager/assistant off";
		} else if(strMode == this.ASSISTANT_NOTIFICATION){
			strDisplayMode = (boolManager) ? "monitors calls" : "receives calls";
		} else if(strMode == this.MANAGER_NOTIFICATION){
			strDisplayMode = (boolManager) ? "receives calls" : "monitors calls";
		} else if(strMode == this.FORWARD_TO_ASSISTANT){
			strDisplayMode = (boolManager) ? "receives calls" : "doesn't receive calls";
		}
                else {
                    ICTouchAPI.debugServices.warning("webapp.managerassistant.dataBase - undefined DISPLAY MODE");
                }
		strMode = null;
		return strDisplayMode;
	},

	/**
	 * Get the icon for a mode, with or without size.
	 * @params strMode {string} the constant string representing the mode.
	 * @params strSize {string} (optional) a size for the icon class
	 */
	getIconFromMode : function(strMode, strSize) {
		var strModeIcon = "";
		if(strMode == this.NO_FILTER){
			strModeIcon = "managerassistant-off";
		} else if(strMode == this.ASSISTANT_NOTIFICATION){
			strModeIcon = "managerassistant-manager-receives";
		} else if(strMode == this.MANAGER_NOTIFICATION){
			strModeIcon = "managerassistant-manager-monitors";
		} else if(strMode == this.FORWARD_TO_ASSISTANT){
			strModeIcon = "managerassistant-manager-no-receives";
		}
                else {
                    ICTouchAPI.debugServices.warning("webapp.managerassistant.dataBase - undefined DISPLAY MODE");
                }
		if(strSize){
			strModeIcon = strModeIcon + "-" + strSize;
		}
		strMode = null;
		strSize = null;
		return strModeIcon;
	},

	getNbMA : function() {
		return this._arrManagerAssistants.length;
	},

	getEnablePhoto : function() {
		return this._boolEnablePhoto;
	},

	getWhiteList : function() {
		return this.arrWhiteList || [];
	},

	getManagerList : function() {
		return this.arrManager || [];
	},

	getRole : function(){
		return this._userRole;
	},

	getLoginName : function() {
		return this.loginName;
	},

	getManagerAssistants : function() {
		return this._arrManagerAssistants;
	},

	getFiltersData : function() {
		return this.filters;
	},

	getIMPresenceAvailable : function() {
		return this.boolIMPresenceAvailable;
	},

	getTelephonyPresenceAvailable : function() {
		return this.boolTelephonyPresenceAvailable;
	},

	isImActivated : function() {
		return (webapp.instantmessaging)?true:false ;
	},

	setIMPresenceAvailable : function(boolIMPresenceAvailable) {
		this.boolIMPresenceAvailable = boolIMPresenceAvailable;
		boolIMPresenceAvailable = null;
	},

	setTelephonyPresenceAvailable : function(boolTelephonyPresenceAvailable) {
		this.boolTelephonyPresenceAvailable = boolTelephonyPresenceAvailable;
		boolTelephonyPresenceAvailable = null;
	},

	/**
	 * Update local variable '_boolPresenceAvailableInMA'
	 * @params {boolean} boolState setting 'EnableManagerassistantPresence' value
	 */
	updateEnablePresenceInMA : function(boolState) {
		ICTouchAPI.debugServices.debug("webapp.managerassistant.dataBase - updateEnablePresenceInMA");
		if(boolState){
			this._boolPresenceAvailableInMA = true;
		} else {
			this._boolPresenceAvailableInMA = false;
		}

		// Reload manager/assistant cards to manage new presence setting.
		var arrMA = this.getManagerAssistants();
		var objInfo = null;
		for(var i = 0 ; i < arrMA.length ; i++){
			objInfo = this.formatMAForDisplay(arrMA[i]);
			this.lstManagerAssistantUI[arrMA[i].objContact.contactId].updateInfo(objInfo);
		}
	},

	getEnablePresenceInMA : function() {
		return this._boolPresenceAvailableInMA;
	},

	getFilterNumberByMode : function(strMode) {
		var id = 0;

		for(var i = 0 ; i < this.filters.length ; i++){
			if(this.filters[i].intIndex == strMode){
				id = i;
				break;
			}
		}
		
		strMode = null;

		return id;
	},

	/**
	 * Update the presence of a manager / assistant
	 * @params imAddress {string} im address of the contact
	 * @params IMPresence {string} a label for the IM presence
	 * @params telephonyPresence {string} a label for the telephony presence
	 */
	updatePresenceInContact : function(imAddress, IMPresence, telephonyPresence) {
		ICTouchAPI.debugServices.info("webapp.managerassistant.dataBase - updatePresenceInContact");
		for(var i = 0 ; i < this._arrManagerAssistants.length ; i++){
			if(this._arrManagerAssistants[i].objContact.collaborationId == imAddress){
				if(this._arrManagerAssistants[i].telephonyPresence !== telephonyPresence){
					this._arrManagerAssistants[i].telephonyPresence = telephonyPresence;
				}
				if(this._arrManagerAssistants[i].IMPresence !== IMPresence){
					this._arrManagerAssistants[i].IMPresence = IMPresence;
				}

				var contactId = this._arrManagerAssistants[i].objContact.contactId;

				if(this.lstManagerAssistantUI[contactId]){
					var objInfo = this.formatMAForDisplay(this._arrManagerAssistants[i]);
					this.lstManagerAssistantUI[contactId].updateInfo(objInfo);
				}

				break;
			}
		}
		
		imAddress = null;
		IMPresence = null;
		telephonyPresence = null;
		ICTouchAPI.debugServices.info("webapp.managerassistant.dataBase - updatePresenceInContact end");
	},

	getCurrentWhiteListManagerLogin : function() {
		var manager = this.arrManager[this.intCurrentWhiteListManager];
		if(manager && manager.loginName){
			return manager.loginName;
		}
		return "";
	},

	contactsListFeedback : function (value) {
		ICTouchAPI.debugServices.info("webapp.managerassistant.dataBase - contactsListFeedback");
		var values = value.split(".");
		var buttonName = values.shift();
		var buttonArg = values.join('.') || '';
		switch(buttonName)
		{
			case this.CALL:
				if(webapp.communication && buttonArg){
					webapp.communication.apiCall(buttonArg, true);
				}
				break;
			case this.IM:
				var user = this.getMAByLogin(buttonArg);
				if(user && user.objContact && webapp.instantmessaging){
					webapp.instantmessaging.prepareToSendIm(user.objContact);
				} else {
					console.warn("ManagerAssistant - DataBase - contactsListFeedback : missing user of no IM");
				}
				break;
			case this.MODE:
				this.strCurrentSelectedLogin = buttonArg;
				webapp.managerassistant.openFilters();
				break;
			default:
				console.warn("will do nothing to "+values[1]);
		}
		ICTouchAPI.debugServices.info("webapp.managerassistant.dataBase - contactsListFeedback end");
	},

	/***********************************************************
	 ******* Specific functions for settings integration *******
	 ***********************************************************/

	initForView : function(view) {
		webapp.settings.refreshWebappView();
		this.boolOnSettingWLWidget = true;
	},

	stopForView : function(view) {
		this.boolOnSettingWLWidget = false;
	},

	getActionBarAppButtonsFromView : function(view) {
		if(this.getRole() == this.MANAGER_ROLE){
			return this.arrWidgetsData[this.WIDGET_WHITE_LIST].buttons;
		} else {
			return [];
		}
	},

	initAppBarButtons : function(view) {
		/*if(this.arrWhiteList.length == 0){
			var actionBar =  webapp.settings.getActionBar();
			var btn = actionBar.getButton(this.DELETE);
			if (btn) {
				btn.greyTint();
			}
		}*/
	}
});

