/*managerassistant*/
// Provide and create the managerassistant webapp.
dojo.provide("webapp.managerassistant.controlBase");
dojo.declare("webapp.managerassistant.controlBase",[ICTouchAPI.webApplication],{

	popupFilters	: null,

	constructor: function(){
		// Subscribe to all the events

		ICTouchAPI.skinServices.linkWebappsStyles("webapp.getManagerPreview","webapp.managerassistant", false, true, false);
		ICTouchAPI.skinServices.linkWebappsStyles("webapp.getManagerPreview","webapp.managerassistant", true, false, true);
		ICTouchAPI.skinServices.linkWebappsStyles("webapp.getManagerPreview","webapp.communication", true, false, true);
		ICTouchAPI.skinServices.linkWebappsStyles("webapp.getManagerPreview","webapp.communication", false, true, false);
		ICTouchAPI.skinServices.linkWebappsStyles("webapp.getManagerPreview","webapp.instantmessaging", true, false, true);
		ICTouchAPI.skinServices.linkWebappsStyles("webapp.getManagerPreview","webapp.userinfo", true, false, true);
		ICTouchAPI.skinServices.linkWebappsStyles("webapp.getBackupAssistantPreview","webapp.managerassistant", false, true, false);

	},
	/**
	 * Update data.boolEnableMAPreview with the value of setting EnableManagerassistantPreview and register/unregister the previewContainer
	 * @params {object} objSetting : setting object with boolean value.
	 */
	updateMAEnableState : function(objSetting){
		var data = webapp.managerassistant.data;
		data.boolEnableMAPreview = objSetting.jsValue;
		this._registerHomepageContainer();
	},

	/**
	 * Register or unregister the previewContainer according to setting EnableManagerassistantPreview
	 * and the state of BackupAssistant mode.
	 */
	_registerHomepageContainer : function() {
		ICTouchAPI.debugServices.info("webapp.managerassistant.controlBase - _registerHomepageContainer");
		// If the preview Manager/Assistant is enabled, look for the preview to register according to the BackupAssistant state
		if(this.data.boolEnableMAPreview){
			// if the BackupAssistant is enabled, register the BackupAssistant preview (and unregister the Manager/Assistant preview if it was still registered)
			if (this.data.getBackupAssistantEnabled()) {
				this._registerBackupAssistantPreview();				
			}
			// if the BackupAssistant is not enabled, look to register the Manager/Assistant preview (and unregister the BackupAssistant preview if it was still registered)
			else {
				this._registerManagerAssistantPreview();
			}
		} else {
			// If the preview Manager/Assistant is not enabled, look for unregistering Manager/Assistant and BackupAssistant if one of them was registered
			this._unregisterManagerAssistantPreview();
			this._unregisterBackupAssistantPreview();
		}
	},


	/**
	 * Register the Manager/Assistant preview if needed (i.e. if it was not already registered and there is more than 0 manager/assistant).
	 * If the BackupAssistant preview was registered, unregister it before registering Manager/Assistant preview (can't be both registered at the same time).
	 */
	_registerManagerAssistantPreview : function() {
		ICTouchAPI.debugServices.info("webapp.managerassistant.controlBase - _registerManagerAssistantPreview");
		if (this.data.isBackupPreviewRegistered) {
			this._unregisterBackupAssistantPreview();
		}
		if(!this.data.isPreview && this.data.getNbMA() > 0){
			ICTouchAPI.tools.registerHomepageContainer(["webapp.managerassistant.getManagerPreview", this]);
			this.data.isPreview = true;
		}
	},

	/**
	 * Unregister the Manager/Assistant preview if needed (i.e. if it was registered).
	 */
	_unregisterManagerAssistantPreview : function() {
		ICTouchAPI.debugServices.info("webapp.managerassistant.controlBase - _unregisterManagerAssistantPreview");
		if(this.data.isPreview){
			if(this.previewContainer && typeof this.previewContainer.destroy == 'function'){
				this.previewContainer.destroy();
			}
			ICTouchAPI.tools.unregisterHomepageContainer(["webapp.managerassistant.getManagerPreview"]);
			this.data.isPreview = false;
		}
	},


	/**
	 * Register the BackupAssistant preview if needed (i.e. if it was not already registered).
	 * If the Manager/Assistant preview was registered, unregister it before registering BackupAssistant preview (can't be both registered at the same time).
	 */
	_registerBackupAssistantPreview : function() {
		ICTouchAPI.debugServices.info("webapp.managerassistant.controlBase - _registerBackupAssistantPreview");
		if (this.data.isPreview) {
			this._unregisterManagerAssistantPreview();
		}
		if (!this.data.isBackupPreviewRegistered){
			ICTouchAPI.tools.registerHomepageContainer(["webapp.managerassistant.getBackupAssistantPreview", this]);
			this.data.isBackupPreviewRegistered = true;
		}
	},

	/**
	 * Unregister the BackupAssistant preview if needed (i.e. if it was registered).
	 */
	_unregisterBackupAssistantPreview : function() {
		ICTouchAPI.debugServices.info("webapp.managerassistant.controlBase - _unregisterBackupAssistantPreview");
		if(this.data.isBackupPreviewRegistered){
			if(this.previewContainer && typeof this.previewContainer.destroy == 'function'){
				this.previewContainer.destroy();
			}
			ICTouchAPI.tools.unregisterHomepageContainer(["webapp.managerassistant.getBackupAssistantPreview"]);
			this.data.isBackupPreviewRegistered = false;
		}
	},

	loaded : function() {
		ICTouchAPI.eventServices.subscribeToEvent(this, "FilteringLevelChangedEvent", this.onFilteringLevelChanged);
		ICTouchAPI.eventServices.subscribeToEvent(this, "AssistantAddedEvent", this.onManagerAssistantAdded);
		ICTouchAPI.eventServices.subscribeToEvent(this, "ManagerAddedEvent", this.onManagerAssistantAdded);
		ICTouchAPI.eventServices.subscribeToEvent(this, "AssistantRemovedEvent", this.onManagerAssistantRemoved);
		ICTouchAPI.eventServices.subscribeToEvent(this, "ManagerRemovedEvent", this.onManagerAssistantRemoved);
		ICTouchAPI.eventServices.subscribeToEvent(this, "WhiteListModifiedEvent", this.onWhiteListModified);
		ICTouchAPI.eventServices.subscribeToEvent(this, "WhiteListRemovedEvent", this.onWhiteListRemoved);
		ICTouchAPI.eventServices.subscribeToEvent(this, "IM_PRESENCE_CHANGE", this.onPresenceChanged);
		ICTouchAPI.eventServices.subscribeToEvent(this, "BackupAssistantEnabled", this.onBackupAssistantChanged);

		ICTouchAPI.settingServices.subscribeToSetting(this, "EnableUserPhoto", this.enablePhoto);
		ICTouchAPI.settingServices.getSetting("EnableUserPhoto", this, this.enablePhoto);

		ICTouchAPI.settingServices.subscribeToSetting(this, "EnableWebappInstantmessaging", this.enableIM);
		ICTouchAPI.settingServices.getSetting("EnableWebappInstantmessaging", this, this.enableIM);

		ICTouchAPI.settingServices.subscribeToSetting(this, "EnableManagerassistantPreview", this.updateMAEnableState);
		ICTouchAPI.settingServices.getSetting("EnableManagerassistantPreview", this, this.updateMAEnableState);

		ICTouchAPI.settingServices.subscribeToSetting(this, "UserRole", this.updateUserRole);
		ICTouchAPI.settingServices.getSetting("UserRole", this, this.updateUserRole);

		ICTouchAPI.settingServices.subscribeToSetting(this, "LoginName", this.updateLoginName);
		ICTouchAPI.settingServices.getSetting("LoginName", this, this.updateLoginName);

		ICTouchAPI.settingServices.subscribeToSetting(this,"IMAvailable",this.updateIMAvailable);
		ICTouchAPI.settingServices.getSetting("IMAvailable",this,this.updateIMAvailable);

		ICTouchAPI.settingServices.subscribeToSetting(this,"TelephonyPresenceAvailable",this.updateTelephonyPresenceAvailable);
		ICTouchAPI.settingServices.getSetting("TelephonyPresenceAvailable",this,this.updateTelephonyPresenceAvailable);

		ICTouchAPI.settingServices.subscribeToSetting(this,"EnableManagerassistantPresence",this.updateEnableMAPresence);
		ICTouchAPI.settingServices.getSetting("EnableManagerassistantPresence",this,this.updateEnableMAPresence);
                
		ICTouchAPI.settingServices.subscribeToSetting(this,"ManagerWhitelist",this.updateWhiteUserRights);
		ICTouchAPI.settingServices.getSetting("ManagerWhitelist",this,this.updateWhiteUserRights);
                // Specific mode for OXO R900
                ICTouchAPI.settingServices.getSetting("ManagerAssistantNoManagerNotification", this, this.enableNoMANotif);

		// When we leave mode selection screen, apply the selected mode
		dojo.subscribe("iframe.hide", this, this.applySelectedMode);
	},

	buttonBackCallback : function() {
		dojo.publish("OpenHomepage");
	},

	/**
	 * Callback of the Backup button (in Filters screen)
	 */
	onBackupButton : function () {
		ICTouchAPI.debugServices.info("webapp.managerassistant.controlBase - onBackupButton");
		// ask userservices to select the User routing profile
		dojo.publish("userservices.selectUserDevice");
		// open userservices view
		ICTouchAPI.transitionServices.getScreen({
			name: "webapp.userservices.getUserService",
			params : {}
		});
	},

	/**
	 * Callback of the BackupAssistant preview
	 */
	onBackupAssistantPreview: function () {
		ICTouchAPI.debugServices.info("webapp.managerassistant.controlBase - onBackupAssistantPreview");
		// open userservices view
		ICTouchAPI.transitionServices.getScreen({
			name: "webapp.userservices.getUserService",
			params : {}
		});
	},
	
	load : function(){
		this._getLists();
	},

	enableNoMANotif : function(objSetting) {
		if(objSetting){
			this.data.updateNoMANotif(objSetting.jsValue);
		}
               
	},

        enablePhoto : function(objSetting) {
		if(objSetting){
			this.data.updateEnablePhoto(objSetting.jsValue);
		}
	},

	updateUserRole : function(objSetting) {
		if(objSetting){
			this.data.setUserRole(objSetting.jsValue);
			this.data.updateBackupButton();
		}
	},

	updateLoginName : function(objSetting) {
		if(objSetting){
			this.data.setLoginName(objSetting.jsValue);
		}
	},

	updateIMAvailable : function(objSetting) {
		if(objSetting){
			this.data.setIMPresenceAvailable(objSetting.jsValue);
		}
	},

	updateTelephonyPresenceAvailable : function(objSetting) {
		if(objSetting){
			this.data.setTelephonyPresenceAvailable(objSetting.jsValue);
		}
	},

	updateEnableMAPresence : function(objSetting) {
		if(objSetting){
			this.data.updateEnablePresenceInMA(objSetting.jsValue);
		}
	},

	/**
	 * Call core function consultWhiteList and returns a list of contact
	 * @params {string} login : login of the manager
	 */
	consultLists : function(login) {
		ICTouchAPI.APIServices.IctUser.consultWhiteList(
			{params:[login], context:this, callback:this._consultedLists, callbackParams:login});
	},

	/**
	 * Callback of consult white list (core function)
	 * Call a function from data to replace the current list for the manager
	 * @params {array} arrContacts : an array of contact objects corresponding to the white list
	 * @params {string} login : login of the manager
	 */
	_consultedLists : function(arrContacts, login) {
		if(arrContacts && login) {
			this.data.setWhiteList(login, arrContacts);
		}
	},

	/**
	 * Ask IM module for the presence of a contact.
	 * @params {string} contactId
	 */
	getPresenceForContact : function(contactId) {
		ICTouchAPI.APIServices.InstantMessaging.getPresenceForContact({context : this, params: [contactId], callback: this.setPresence});
	},

	/**
	 * Callback of IM_PRESENCE_CHANGED
	 * Format the result and call setPresence to change the presence in previews
	 * @params {event:array} presenceList : list of presences
	 */
	onPresenceChanged:function(presenceList) {
		if(presenceList && presenceList.value){
			this.setPresence(presenceList.value);
		}
		presenceList=null;
	},

	/**
	 * Callback of BackupAssistantEnabled
	 * Update _boolBackupAssistantEnabled and update the homepage preview as needed according to the state of BackupAssistant mode
	 * @params {Object} boolEnableBackup : value sent in the event 'BackupAssistantEnabled'
	 */
	onBackupAssistantChanged:function(boolEnableBackup) {
		ICTouchAPI.debugServices.info("webapp.managerassistant.controlBase - onBackupAssistantChanged");
		if(boolEnableBackup && boolEnableBackup.value !== undefined) {
			ICTouchAPI.debugServices.debug("webapp.managerassistant.controlBase - onBackupAssistantChanged / new value is: " + boolEnableBackup.value);
			// Update the internal boolean
			this.data.setBackupAssistantEnabled(boolEnableBackup.value);
			// Update the preview according to the state of Backup Assistant
			this._registerHomepageContainer();
		}
		boolEnableBackup=null;
	},
	
	/**
	 * Update the presence of managers and assistants
	 * @params {array} presenceList : list of presences
	 */
	setPresence : function(presenceList) {
		ICTouchAPI.debugServices.info("webapp.managerassistant.controlBase - setPresence");
		if(presenceList.length){
			for(var i in presenceList){
				// Try to find a match with a manager or an assistant and update the presence
				this.data.updatePresenceInContact(presenceList[i].imAddress, presenceList[i].imPresenceValue.value.labelStatus, presenceList[i].telephonicPresenceValue.value.labelStatus);
			}
		}
		ICTouchAPI.debugServices.info("webapp.managerassistant.controlBase - setPresence end");
	},

	/**
	 * Callback of WhiteListRemovedEvent
	 * Replace the white list of a manager
	 * @params {event:array} whiteList : a list of contacts
	 */
	onWhiteListModified : function() {
		var objArguments = ICTouchAPI.tools.getEventArguments(arguments);
		var whiteList = objArguments.whiteList;
		this.data.setWhiteList(this.data.getLoginName(), whiteList);
	},

	/**
	 * Callback of WhiteListModifiedEvent
	 * Remove the white list of a manager
	 */
	onWhiteListRemoved : function() {
		this.data.removeWhiteList(this.data.getLoginName());
	},

	/**
	 * Update local variable '_boolEnableIM' and reload the preview container
	 * @params {object} objSetting : setting 'EnableUserPhoto'
	 */
	enableIM : function(objSetting) {
		if(objSetting){
			this.data.updateEnableIM(objSetting.jsValue);
		}
	},

	/**
	 *	Start business call for Assistant and Manager list.
	 *	If we are Assistant, we will maybe receive ManagerAddedEvent in addition of the callback
	 *	If we are Manager, we will maybe receive AssistantAddedEvent in addition of the callback
	 */
	_getLists : function() {
		ICTouchAPI.APIServices.IctUser.getAssistantList(
			{params:[], context:this.data, callback:this.data.addManagerAssistants});
			//loadedManagers
		ICTouchAPI.APIServices.IctUser.getManagerList(
			{params:[], context:this.data, callback:this.data.addManagerAssistants});
		// load white list if the role is manager
		if (this.data.getRole() == this.data.MANAGER_ROLE) {
			this.consultLists(this.data.getLoginName());
		}
	},

	/**
	 * Callback of business call for Assistant and Manager list.
	 * @params arrManagerAssistant {array} a list of contact objects
	 */
	_gotList : function(arrManagerAssistant) {
		// Update the data
		this.data.addManagerAssistants(arrManagerAssistant);

		// Nullify arguments
		arrManagerAssistant = null;
	},

	/**
	 * Ask for presence and filtering level.
	 * @params objContact {object} a contact object
	 */
	askForInfo : function(objContact) {
		ICTouchAPI.debugServices.info("webapp.managerassistant.controlBase - askForInfo");
		// Get current filtering level
		var loginForFilter = "";
		if(this.data.getRole() == this.data.MANAGER_ROLE){
			loginForFilter = this.data.loginName;
		} else {
			loginForFilter = objContact.loginName;
		}
		ICTouchAPI.APIServices.IctUser.getFilteringLevel({params:[loginForFilter], context: this, callback :this._gotFilteringLevel, callbackParams:loginForFilter});

		// Get current IM presence
		if(this.data.getEnablePresenceInMA() || this.data.getIMPresenceAvailable() || this.data.getTelephonyPresenceAvailable()){
			this.getPresenceForContact(objContact.contactId);
		}
		ICTouchAPI.debugServices.info("webapp.managerassistant.controlBase - askForInfo end");
	},

	/**
	 * Callback of core function getFilteringLevel's call.
	 * @params filteringLevel {string} the mode we have to set
	 * @params strLogin {string} the login of the contact we have to set
	 */
	_gotFilteringLevel : function(filteringLevel, strLogin) {
		this.data.setFilteringLevel(strLogin, filteringLevel && filteringLevel.value);
	},

	/**
	 * Callback of FILTER button, opens a new Filter popup
	 * @params {event:string} manager : the login of the manager
	 * @params {event:string} filteringlevel : enum filteringLevel
	 */
	openFilters : function() {
		ICTouchAPI.debugServices.info("webapp.managerassistant.controlBase - openFilters");
		// We store current data of the manager/assistant, to restore it in case of cancel
		var data = this.data;

		var login = data.strCurrentSelectedLogin;

		var objManagerAssistant = data.getManagerAssistantByLogin(login);

		// webapp.managerassistant.data.objFiltersContainer is a select list
		if(data.objFiltersContainer){
			data.objFiltersContainer.unselectAll();
			data.objFiltersContainer.selectAtIndex(data.getFilterNumberByMode(objManagerAssistant.mode));
			this.storeSelectedMode(objManagerAssistant.mode);
		} else {
			data.filters[data.getFilterNumberByMode(objManagerAssistant.mode)].boolSelected = true;
			this.storeSelectedMode(objManagerAssistant.mode);
		}

		ICTouchAPI.transitionServices.getScreen({
			name : "webapp.managerassistant.getFilters",
			params : {}
		})
		ICTouchAPI.debugServices.info("webapp.managerassistant.controlBase - openFilters end");
	},

	/**
	 * Callback of the filter popup (OK button)
	 * Set the filtering level with new parameters
	 * @params
	 */
	storeSelectedMode : function(strMode) {
		this._strSelectedMode = strMode;
	},

	/**
	 * Apply the selected mode to the selected manager / assistant (event iframe.hide)
	 * @params strScreenName {string} name of the hidden screen
	 */
	applySelectedMode : function(strScreenName) {
		ICTouchAPI.debugServices.info("webapp.managerassistant.controlBase - applySelectedMode");
		if(strScreenName == "webapp.managerassistant.getFilters"){
			var currentLogin = this.data.strCurrentSelectedLogin;
			var loginManager;
			// SetFilteringLevel is called with the manager login, it doesn't matter if we are assistant or manager
			if(this.data.getRole == this.data.MANAGER_ROLE){
				loginManager = this.data.loginName;
			} else {
				loginManager = currentLogin;
			}
			ICTouchAPI.APIServices.IctUser.setFilteringLevel({params:[loginManager, this._strSelectedMode]});
		}
		ICTouchAPI.debugServices.info("webapp.managerassistant.controlBase - applySelectedMode end");
	},

	/**
	 * Callback of IntrudeInCall button and PickUpCall button
	 * Simply call core function associated to the button
	 * @params {string} buttonId : id of the button
	 */
	onGetCallButtons : function(buttonId){
		if(webapp.communication){
			var objComLogEntry = webapp.communication.data.getSelectedEntry();
			var login = (this.data.getRole() == this.data.MANAGER_ROLE) ? objComLogEntry.objCallData.assistant : objComLogEntry.objCallData.manager;
			if(buttonId == this.data.INTRUDE){
				if(login){
					ICTouchAPI.APIServices.Telephony.intrudeCall({params:[objComLogEntry.objCallData.callRef, login, false]});
				}
			} else if(buttonId == this.data.PICK_UP){
				if(login){
					var objContact = this.data.getMAByLogin(login);
					if(objContact != null){
						var phoneNumber = ICTouchAPI.tools.getContactPhone(objContact.objContact);
						if(phoneNumber != ""){
							ICTouchAPI.APIServices.Telephony.pickupCall({params:[objComLogEntry.objCallData.callRef, phoneNumber]});
						}
					}
				}

			}
		}
	},

	/**
	 * Callback of callManager button (only available for assistant)
	 * Simply calls the manager
	 */
	onCallManagerButton: function(){
		// callToManager functionnality is only available on assistant side
		if (this.data.getRole() === this.data.ASSISTANT_ROLE) {
			// Search the associated manager phone number to the current call
			var strManagerPhoneNumber = this.data.getManagerPhoneNumber();
			if(webapp.communication){
				webapp.communication.apiCall(strManagerPhoneNumber, false);
			}
			else {
				ICTouchAPI.debugServices.warning("webapp.managerassistant.controlBase - onCallManagerButton / webapp.communication not existing");
			}
		}
		else {
			ICTouchAPI.debugServices.warning("webapp.managerassistant.controlBase - onCallManagerButton / Current role is not ASSISTANT_ROLE, do not initiate the call To Manager");
		}
	},

	/**
	 * Callback of callAssistant button (only available for manager)
	 * Simply calls the assistant
	 */
	onCallAssistantButton: function(){
		// TransferToAssistant functionnality is only available on manager side
		if (this.data.getRole() === this.data.MANAGER_ROLE) {
			var assistant = this.data.getManagerAssistants()[0];
			if (assistant && assistant.objContact) {
				var phoneNumber = ICTouchAPI.tools.getContactPhone(assistant.objContact);
				if(webapp.communication){
					webapp.communication.apiCall(phoneNumber, false);
				}else {
					ICTouchAPI.debugServices.warning("webapp.managerassistant.controlBase - onCallAssistantButton / webapp.communication not existing");
				}
			} else {
				ICTouchAPI.debugServices.warning("webapp.managerassistant.controlBase - onCallAssistantButton / No manager found or no objContact in manager object");
			}
		} else {
			ICTouchAPI.debugServices.warning("webapp.managerassistant.controlBase - onCallAssistantButton / Current role is not MANAGER_ROLE, do not initiate the Transfert To the assistant");
		}
	},

	/**
	 * Callback of TransferToManager button (only available for assistant)
	 * Simply call a transfer of the current phone call to the manager
	 */
	onTransfertToManagerButton: function(){
		// Get the current ongoing phone call
		if(webapp.communication){
			var objSelectedComLogEntry = webapp.communication.data.getSelectedEntry();

			// Search the associated manager phone number to the current call
			var strManagerPhoneNumber = this.data.getManagerPhoneNumber();

			// TransferToManager functionnality is only available on assistant side
			if (this.data.getRole() === this.data.ASSISTANT_ROLE && strManagerPhoneNumber) {
				ICTouchAPI.APIServices.Telephony.transferPhoneCallToNumber({params:[objSelectedComLogEntry.intIndex,
												    strManagerPhoneNumber,
												    false]
				});
			}
			else {
				ICTouchAPI.debugServices.warning("webapp.managerassistant.controlBase - onTransfertToManagerButton / Current role is not ASSISTANT_ROLE, do not initiate the Transfert To Manager");
			}
		}
		else {
			ICTouchAPI.debugServices.warning("webapp.managerassistant.controlBase - onTransfertToManagerButton / webapp.communication not existing");
		}
	},

	/**
	 * Callback of TransferToAssistant button (only available for manager)
	 * Simply call a transfer of the current phone call to the assistant
	 */
	onTransfertToAssistantButton: function(){
		// Get the current ongoing phone call
		if (webapp.communication) {
		    var objComLogEntryId = webapp.communication.data.getSelectedEntryId();

			// TransferToAssistant functionnality is only available on manager side
			if (this.data.getRole() === this.data.MANAGER_ROLE) {
			    var assistant = this.data.getManagerAssistants()[0];
			    if (assistant && assistant.objContact) {
				var phoneNumber = ICTouchAPI.tools.getContactPhone(assistant.objContact);
				if(phoneNumber){
					ICTouchAPI.APIServices.Telephony.transferPhoneCallToNumber({params:[objComLogEntryId, phoneNumber, false]});
				} else {
					ICTouchAPI.debugServices.warning("webapp.managerassistant.controlBase - onTransfertToAssistantButton / no phoneNumber found for the manager");
				}
			    }
			    else {
				ICTouchAPI.debugServices.warning("webapp.managerassistant.controlBase - onTransfertToAssistantButton / No manager found or no objContact in manager object");
			    }
			} else {
				ICTouchAPI.debugServices.warning("webapp.managerassistant.controlBase - onTransfertToAssistantButton / Current role is not MANAGER_ROLE, do not initiate the Transfert To the assistant");
			}
		} else {
			ICTouchAPI.debugServices.warning("webapp.managerassistant.controlBase - onTransfertToAssistantButton / webapp.communication not existing");
		}
	},

	/**
	 * Callback of Whitelist buttons in Communication and Contacts
	 * Add or remove the selected contact in the whitelist
	 * @param {string} strWebapp name of the webapp
	 * @param {string} buttonId id of the button
	 */
	onWhiteListButton : function(strWebapp, buttonId){
		var objContact = null;
		// Get the current contact of the calling webapp
		if(strWebapp === this.data.TO_COMM && webapp.communication){
			objContact = webapp.communication.data.getCurrentContact();
		} else if (strWebapp === this.data.TO_CONTACT && webapp.contacts) {
			objContact = webapp.contacts.data.getCurrentContact();
		}
		// Extract all phoneNumbers to add/remove them in whiteList
		var arrPhoneNumbers = this.data.getContactPhones(objContact);
		if(arrPhoneNumbers.length > 0){
			// Depending of the calling button, add or remove the phoneNumbers
			if(this.data.isInWhiteList(arrPhoneNumbers)){
				this.removeContactFromWL(arrPhoneNumbers);
			} else {
				this.addContactInWL(arrPhoneNumbers);
			}
		}
	},

	/**
	 * Callback of FilteringLevelChangedEvent
	 * @params {event:string} manager : the login of the manager
	 * @params {event:string} filteringlevel : enum filteringLevel (in 'value' field)
	 */
	onFilteringLevelChanged : function() {
		ICTouchAPI.debugServices.info("webapp.managerassistant.controlBase - onFilteringLevelChanged");
		var objArguments = ICTouchAPI.tools.getEventArguments(arguments);
		var managerLogin = objArguments.manager;
		var filteringLevel = objArguments.filteringlevel.value;
		this.data.setFilteringLevel(managerLogin, filteringLevel);
		ICTouchAPI.debugServices.info("webapp.managerassistant.controlBase - onFilteringLevelChanged end");
	},

	/**
	 * Delete all the numbers of the selected contact in the white list
	 */
	onDeleteContact : function() {
		if(this.data.getRole() == this.data.MANAGER_ROLE){
			//var managerLogin = this.data.arrManager[this.data.intCurrentWhiteListManager].strLabel;
			var arrPhoneNumbers = this.data.arrWhiteList[this.data.intCurrentWhiteListContact].arrPhones;
			this.removeContactFromWL(arrPhoneNumbers);
		}
	},

	/**
	 * Look for a contact if the contact list with search webapp
	 */
	onSearchContact : function() {
		// Create the search object with parameters
		var objSearch = {
			lineClickCallback : {
				neededData : "Contact",
				context: this,
				func: this.onSearchCallback
			},
			useDefaultCallMethod : false,
			stealth : true
		};
		// Start the search
		if(webapp.search){
			webapp.search.doSearch(objSearch, function(){ICTouchAPI.transitionServices.back();});
		}
	},

	/**
	 * Callback of doSearch function of search webapp
	 * @params {object} objContact : contact object
	 */
	onSearchCallback : function(objContact) {
		if(this.data.getRole() == this.data.MANAGER_ROLE){
			var arrPhones = this.data.getContactPhones(objContact);
			if(arrPhones){
				this.addContactInWL(arrPhones);
			}
		}
		ICTouchAPI.transitionServices.back();
	},

	/**
	 * Remove a contact from the White list
	 * @params {array} arrPhoneNumbers : the contact to remove from the white list
	 */
	removeContactFromWL : function(arrPhoneNumbers) {
		ICTouchAPI.APIServices.IctUser.removeContactsInWhiteList({params:[arrPhoneNumbers]});
	},

	/**
	 * Add a contact to the White list
	 * @params {array} arrPhoneNumbers : the contact to add to the white list
	 * @params {string} strLogin : the login of the manager
	 */
	addContactInWL : function(arrPhoneNumbers) {
		ICTouchAPI.APIServices.IctUser.addContactsInWhiteList({params:[arrPhoneNumbers]});
	},

	/**
	 *	Register or refresh the preview container on homepage.
	 */
	setPreview : function(){
		ICTouchAPI.debugServices.info("webapp.managerassistant.controlBase - setPreview");
		var that = this;
		
		// Clear the timer handler
		if(!this._hSetPreview){
			clearTimeout(this._hSetPreview);
			this._hSetPreview = null;
		}

		this._hSetPreview = setTimeout(function(){that._setPreview();},1000);
		ICTouchAPI.debugServices.info("webapp.managerassistant.controlBase - setPreview end");
	},
	
	_setPreview : function() {
		ICTouchAPI.debugServices.info("webapp.managerassistant.controlBase - _setPreview");
		// Clear the timer handler
		if(this._hSetPreview){
			clearTimeout(this._hSetPreview);
			this._hSetPreview = null;
		}
		
		var data = webapp.managerassistant.data;
		if(data.getNbMA() > 0){
			if(!data.isPreview) {
				// Register or unregister according to setting EnableManagerassistantPreview
				this._registerHomepageContainer();
			} else {
				this.refreshPreview();
			}
		} else {
			if(data.boolEnableMAPreview){
				this._unregisterManagerAssistantPreview();
			}
		}
		ICTouchAPI.debugServices.info("webapp.managerassistant.controlBase - _setPreview end");
	},

	/**
	 * Function called by webapp Homepage after the register of a preview.
	 * Instanciate the right preview view according to the view registered in webapp Homepage.
	 */
	setHomepageContainer : function (strWebapp, div) {
		if (strWebapp === "webapp.managerassistant.getManagerPreview") {
		webapp.managerassistant.previewContainer = new webapp.managerassistant.getManagerPreview({ }, div);
		}
		else if (strWebapp === "webapp.managerassistant.getBackupAssistantPreview") {
			var data = webapp.managerassistant.data;
			var strTitle = (data.getRole() == data.MANAGER_ROLE)? data.ASSISTANT_ROLE:data.MANAGER_ROLE;
			webapp.managerassistant.previewContainer = new UIElements.Container.ContainerControl(
			{
				objTitle: {
					strLabel 	: _(strTitle, data.i18n)
				},

				objContent: {
					name 	: "webapp.managerassistant.getBackupAssistantPreview",
					params  : {}
				},
				strHeight : "Full"
			},
			div);
		}
	},

	/**
	 *	Callback of 'AssistantAddedEvent' or 'ManagerAddedEvent'.
	 *	Add the contact to list and preview
	 */
	onManagerAssistantAdded : function(){
		ICTouchAPI.debugServices.info("webapp.managerassistant.controlBase - onManagerAssistantAdded");
		var objArguments = ICTouchAPI.tools.getEventArguments(arguments);
		var objContact = objArguments.assistant || objArguments.manager;

		// Add the assistant / manager in data
		if(objContact){
			this.data.addManagerAssistants([objContact]);
		}
		ICTouchAPI.debugServices.info("webapp.managerassistant.controlBase - onManagerAssistantAdded end");
	},

	/**
	 *	Callback of 'AssistantRemovedEvent' or 'ManagerRemovedEvent'.
	 *	Remove the contact from list and preview
	 *	@param strLogin {event:string} the login of the contact to remove
	 */
	onManagerAssistantRemoved : function(strLogin) {
		var isRemoved = false;
		if(strLogin && strLogin.value){
			isRemoved = this.data.removeManagerAssistant(strLogin.value);
		}
		if(!isRemoved){
			console.warn('webapp.managerassistant.controlBase - onManagerAssistantRemoved / Contact '+ (strLogin && strLogin.value) +' to remove not found')
		}
	},

	/**
	 * Refresh Preview Container if it exist
	 */
	refreshPreview : function()
	{
		if(this.previewContainer && this.previewContainer != null && typeof(this.previewContainer.refresh) == 'function')
			this.previewContainer.refresh();
	},

	updateWhiteUserRights : function(objSetting){
		if(objSetting){
			webapp.managerassistant.data.intWhitelistUserRights = objSetting.user_rights;
		}
	}
});

