dojo.provide("webapp.supervision.controlBase");
dojo.declare("webapp.supervision.controlBase",[ICTouchAPI.webApplication],
{
	/* --------------------------------- Public attributes ------------------------------------ */



	/* --------------------------------- Private attributes ----------------------------------- */

	/**
	 * @property
	 * @type {Array}
	 * @private
	 */
	_arrListPreviewNames : [],

	/**
	 * @property
	 * @type {Array}
	 * @private
	 */
	_arrListPreviews : [],

	/**
	 * @property
	 * @type {Integer}
	 * @private
	 */
	_intTimeLastClick : 0,

	/* ------------------------------------ Constructor --------------------------------------- */

	/**
	* @constructs
	*/
	constructor : function() {
		// Subscribe to every event from supervisionServices
		dojo.subscribe("supervision.groupAdded", this, this._onGroupAdded);
		dojo.subscribe("supervision.groupModified", this, this._onGroupModified);
		dojo.subscribe("supervision.groupDeleted", this, this._onGroupDeleted);
		dojo.subscribe("supervision.incomingCallsNumberChanged", this, this._onIncomingCallsNumberChanged);

		// Init notification
		this._initPickupNotification();

		// Fill list preview names
		this._arrListPreviewNames.push("webapp.supervision.getSupFirstPreview");
		this._arrListPreviewNames.push("webapp.supervision.getSupSecondPreview");
		this._arrListPreviewNames.push("webapp.supervision.getSupThirdPreview");

		// Link webapp styles
		ICTouchAPI.skinServices.linkWebappsStyles("webapp.getSupFirstPreview", "webapp.communication", false, true);
		ICTouchAPI.skinServices.linkWebappsStyles("webapp.getSupFirstPreview", "webapp.userinfo", false, true);
		ICTouchAPI.skinServices.linkWebappsStyles("webapp.getSupSecondPreview", "webapp.communication", false, true);
		ICTouchAPI.skinServices.linkWebappsStyles("webapp.getSupSecondPreview", "webapp.userinfo", false, true);
		ICTouchAPI.skinServices.linkWebappsStyles("webapp.getSupThirdPreview", "webapp.communication", false, true);
		ICTouchAPI.skinServices.linkWebappsStyles("webapp.getSupThirdPreview", "webapp.userinfo", false, true);

		ICTouchAPI.skinServices.linkWebappsStyles("webapp.getSupFirstPreview", "webapp.communication", true, false, true);
		ICTouchAPI.skinServices.linkWebappsStyles("webapp.getSupFirstPreview", "webapp.userinfo", true, false, true);
		ICTouchAPI.skinServices.linkWebappsStyles("webapp.getSupSecondPreview", "webapp.communication", true, false, true);
		ICTouchAPI.skinServices.linkWebappsStyles("webapp.getSupSecondPreview", "webapp.userinfo", true, false, true);
		ICTouchAPI.skinServices.linkWebappsStyles("webapp.getSupThirdPreview", "webapp.communication", true, false, true);
		ICTouchAPI.skinServices.linkWebappsStyles("webapp.getSupThirdPreview", "webapp.userinfo", true, false, true);
	},

	/* ----------------------------------- Getter / Setter------------------------------------- */



	/* ----------------------------------- Public methods ------------------------------------- */

	/**
	 * Function called by Homepage webapp when you try to register a preview
	 * @param {string} strWebapp the preview name
	 * @param {Object} div the node on which we will attach the preview
	 */
	setHomepageContainer : function (strWebapp, div) {
		if(strWebapp == this._arrListPreviewNames[0]){
			this._arrListPreviews[0] = new webapp.supervision.getSupFirstPreview({}, div);
		} else if (strWebapp == this._arrListPreviewNames[1]){
			this._arrListPreviews[1] = new webapp.supervision.getSupSecondPreview({}, div);
		} else if (strWebapp == this._arrListPreviewNames[2]){
			this._arrListPreviews[2] = new webapp.supervision.getSupThirdPreview({}, div);
		}
		this.data._updatePreviewTitles();
		strWebapp=null;
		div=null;
	},

	/* --------------------------------- Private Methods -------------------------------------- */

	/**
	 * @private
	 */
	registerPreview : function(intPreviewNumber) {
		var strPreview = this._arrListPreviewNames[intPreviewNumber];

		this._arrListPreviews[intPreviewNumber] = this._arrListPreviewNames[intPreviewNumber];

		ICTouchAPI.tools.registerHomepageContainer([strPreview, this]);
	},

	/**
	 * @private
	 */
	unregisterPreview : function(intNbToUnregister) {
		var strPreview;
		var objPreview;
		
		for(var i = 0 ; i < intNbToUnregister && this._arrListPreviews.length > 0 ; i++){
			// Get preview name
			strPreview = this._arrListPreviewNames[this._arrListPreviews.length - 1];

			// Remove one preview from array and destroy it
			objPreview = this._arrListPreviews.pop();
			if(typeof objPreview !== "string"){
				objPreview.destroy();
			}

			// Unregister the preview
			ICTouchAPI.tools.unregisterHomepageContainer([strPreview]);
		}
	},

	/**
	 * Call/pick up a call of a user
	 * @param {String} strLogin is the unique login of the user you clicked on
	 * @private
	 */
	onSupervisedClick : function(strLogin) {
		var currentTime = (new Date()).getTime();
		if(currentTime - this._intTimeLastClick > 3000){
			this._intTimeLastClick = currentTime;
			if(strLogin){
				ICTouchAPI.supervisionServices.callPickupByLogin(strLogin);
			}
		} else {
			ICTouchAPI.debugServices.warning("webapp.supervision.controlBase - onSupervisedClick / Click not managed because to close from last one.")
		}
	},

	/**
	 * Open contactCard of a user
	 * @param {String} strLogin is the unique login of the user you clicked on
	 * @private
	 */
	onSupervisedLongPress : function(strLogin) {
		if(strLogin && webapp.contacts){
			var objSupervised = ICTouchAPI.supervisionServices.getSupUserByLogin(strLogin);
			if(objSupervised){
				var objShowContactArgs = {};
				var objContact = ICTouchAPI.dataStoreServices.getStore('contacts').find(["officePhoneCan", "officePhone"], objSupervised.identity.officePhone.number)[0];
				if(objContact){
					objShowContactArgs.intId = objContact.contactId;
				} else {
					objContact = this.data._formatContactForShow(dojo.clone(objSupervised.identity));

					objShowContactArgs.objContact = objContact;
				}
				webapp.contacts.showContact(objShowContactArgs);
			} else {
				ICTouchAPI.debugServices.warning("webapp.supervision.controlBase - onSupervisedLongPress / Member with login "+ strLogin + " not found.")
			}
		}
	},

	/**
	 * @private
	 */
	onNotificationPickup : function() {
		dojo.publish("OpenHomepage", [{boolPreview:true}]);
	},

	/**
	 * Callback of dojo event : "supervision.groupAdded"
	 * @private
	 */
	_onGroupAdded : function(groupName, arrMembers) {
		// Set groupName
		this.data.setGroupName(groupName || "Supervision");

		// Add new members
		this.data.addNewMembers(arrMembers);
	},

	/**
	 * Callback of dojo event : "supervision.groupModified"
	 * @private
	 */
	_onGroupModified : function(groupName, arrAdded, arrModified, arrDeleted) {
		// Groupname is given only if it is modified
		if(groupName){
			this.data.setGroupName(groupName);
		}

		// Delete members
		if(arrDeleted){
			this.data.removeMembers(arrDeleted);
		}

		// Modify members
		if(arrModified){
			this.data.modifyMembers(arrModified);
		}

		// Add new members
		if(arrAdded){
			this.data.addNewMembers(arrAdded);
		}

		// Remove empty previews
		this.data._removeEmptyPreviews();
	},

	/**
	 * Callback of dojo event : "supervision.groupDeleted"
	 * @private
	 */
	_onGroupDeleted : function() {
		// Reset number of supervised
		this.data.setNbMembers(0);

		// Remove every preview
		this.unregisterPreview(3);

		// Clear notification
		ICTouchAPI.notificationServices.setNotificationValue("Pickup", 0);
	},

	/**
	 * @private
	 */
	_initPickupNotification : function() {
		ICTouchAPI.notificationServices.addNotification({
			strNotificationName: "Pickup",
			strNotificationLabel: _("Pickup", "webapp.supervision"),
			intNotificationValue: 0,
			callback: {
				context:this,
				func:this.onNotificationPickup
			}
		});
	},

	/**
	 * Callback of dojo event : "supervision.incomingCallsNumberChanged"
	 * @private
	 */
	_onIncomingCallsNumberChanged : function(intCallsNumber) {
		ICTouchAPI.notificationServices.setNotificationValue("Pickup", intCallsNumber);
	}
});
dojo.require("webapp.supervision.controlBase");
dojo.provide("webapp.supervision");
dojo.declare("webapp.supervision",webapp.supervision.controlBase,
{
});

webapp.supervision = new webapp.supervision();
dojo.provide("webapp.supervision.dataBase");
dojo.declare("webapp.supervision.dataBase", null, {
	/* --------------------------------- Public attributes ------------------------------------ */

	/**
	 * @property
	 * @type Object
	 */
	objSupFirstPreview : null,

	/**
	 * @property
	 * @type Object
	 */
	objSupSecondPreview : null,

	/**
	 * @property
	 * @type Object
	 */
	objSupThirdPreview : null,

	/* --------------------------------- Private attributes ----------------------------------- */

	/**
	 * @property
	 * @type String
	 * @private
	 */
	_strGroupName : "",

	/**
	 * @property
	 * @type Number
	 * @private
	 */
	_intNbMembers : 0,

	/**
	 * @property
	 * @type Number
	 * @private
	 */
	_intNbByPreview : 5,

	/**
	 * @property Static value
	 * @type Number
	 * @private
	 */
	CONTACT_TYPE : {
		UDA : 1
	},

	/* ------------------------------------ Constructor --------------------------------------- */

	/**
	* @constructs
	*/
	constructor : function() {

	},

	/* ----------------------------------- Getter / Setter------------------------------------- */

	getGroupName : function() {
		return this._strGroupName;
	},

	setGroupName : function(strGroupName) {
		if(this._strGroupName != strGroupName){
			this._strGroupName = strGroupName;
			this._updatePreviewTitles();
		}
	},
	
	getNbMembers : function() {
		return this._intNbMembers;
	},

	setNbMembers : function(intNbMembers) {
		this._intNbMembers = intNbMembers;
	},

	getNbByPreview : function() {
		return this._intNbByPreview;
	},

	setNbByPreview : function(intNbByPreview) {
		this._intNbByPreview = intNbByPreview;
	},

	/* ----------------------------------- Public methods ------------------------------------- */

	/**
	 * Add new members in corresponding previews
	 * @param {array} arrNewMembers is an array of members to add
	 */
	addNewMembers : function(arrNewMembers) {
		var intNbCurrentMembers, i, intNbToAdd;
		var arrFormatedMember;
		var intNbByPreview = this.getNbByPreview();

		while(arrNewMembers.length > 0 && this.getNbMembers() < intNbByPreview * 3){
			arrFormatedMember = [];
			// Format all members to add on one list
			intNbCurrentMembers = this.getNbMembers();
			intNbToAdd = intNbByPreview - (intNbCurrentMembers % intNbByPreview);

			// Do not add more than number of members you have to add
			if(intNbToAdd > arrNewMembers.length){
				intNbToAdd = arrNewMembers.length;
			}

			// Do not add more members than previews may contain
			if(intNbToAdd + intNbCurrentMembers > intNbByPreview * 3){
				intNbToAdd = intNbByPreview * 3 - intNbCurrentMembers;
			}

			for(i = 0 ; i < intNbToAdd; i++){
				arrFormatedMember.push(this._formatMemberForList(arrNewMembers.shift()));
			}

			// Try to add on the corresponding preview
			if(intNbCurrentMembers < intNbByPreview){
				if(!this.objSupFirstPreview){
					webapp.supervision.registerPreview(0);
				} else {
					this.objSupFirstPreview.pushItems(arrFormatedMember, true);
				}
			} else if (intNbCurrentMembers < intNbByPreview*2){
				if(!this.objSupSecondPreview){
					webapp.supervision.registerPreview(1);
				} else {
					this.objSupSecondPreview.pushItems(arrFormatedMember, true);
				}
			} else if (intNbCurrentMembers < intNbByPreview*3){
				if(!this.objSupThirdPreview){
					webapp.supervision.registerPreview(2);
				} else {
					this.objSupThirdPreview.pushItems(arrFormatedMember, true);
				}
			}
			this.setNbMembers(this.getNbMembers() + intNbToAdd);
		}

		// Update title to set the right number
		this._updatePreviewTitles();
	},

	/**
	 * Remove members from corresponding previews
	 * @param {array} arrRemovedMembers is an array of members to remove
	 */
	removeMembers : function(arrRemovedMembers) {
		var strLogin;
		var removed;
		for(var i = 0 ; i < arrRemovedMembers.length ; i++){
			removed = false;
			strLogin = arrRemovedMembers[i];

			// Try to remove from each list and store if succeded
			if(this.objSupFirstPreview){
				removed = this.objSupFirstPreview.removeItemByIntIndex(strLogin, true);
			}
			if(this.objSupSecondPreview && !removed){
				removed = this.objSupSecondPreview.removeItemByIntIndex(strLogin, true);
			}
			if(this.objSupThirdPreview && !removed){
				removed = this.objSupThirdPreview.removeItemByIntIndex(strLogin, true);
			}

			// If it was really removed, decrease the number of members
			if(removed){
				this.setNbMembers(this.getNbMembers() - 1);
			}
		}

		this._reorderMembers();

		// Update title to set the right number
		this._updatePreviewTitles();
	},

	/**
	 * Remove members from corresponding previews
	 * @param {array} arrModifiedMembers is an array of members to remove
	 */
	modifyMembers : function(arrModifiedMembers) {
		var objMember;
		for(var i = 0 ; i < arrModifiedMembers.length ; i++){
			objMember = this._formatMemberForList(arrModifiedMembers[i]);
			if(this.objSupFirstPreview){
				this.objSupFirstPreview.updateItem(objMember)
			}
			if(this.objSupSecondPreview){
				this.objSupSecondPreview.updateItem(objMember)
			}
			if(this.objSupThirdPreview){
				this.objSupThirdPreview.updateItem(objMember)
			}
		}
	},

	/* --------------------------------- Private Methods -------------------------------------- */

	_updatePreviewTitles : function() {
		// For each preview, update its title if it is existing.
		webapp.supervision._arrListPreviews.forEach(function(preview) {
			if(typeof preview !== "string" && preview.supervisionContainer && preview.supervisionContainer.getTitle && preview.supervisionContainer.getTitle()){
				preview.supervisionContainer.getTitle().changeTitle(_([this.getGroupName(), "(" + preview.supervisionContainer.getContent().arrItems.length + ")"],"webapp.supervision"), 0);
			}
		}, this);
	},

	/**
	 * @private
	 */
	_addMembersOnPreview : function(intStart, intTo, objListToAdd) {

		// Format members to add
		var arrMembers = ICTouchAPI.supervisionServices.getSupUsers(intStart, intTo);
		var arrFormatedMembers = [];
		for(var i = 0 ; i < arrMembers.length ; i++){
			arrFormatedMembers.push(this._formatMemberForList(arrMembers[i]));
		}

		// Add the array of members
		objListToAdd.pushItems(arrFormatedMembers, true);

		this._updatePreviewTitles();
	},

	/**
	 * @private
	 */
	_formatMemberForList : function(objMember) {
		var objFormatedMember = {
			intIndex : objMember.identity.login,
			boolNotSelectable : true,
			additionalStyle: "",
			strSecondaryContentStyle : "italic",
			strSecondaryContentWeight : "normal"
		};

		if(objMember.ringState){
			// If the member had an incomingCall in ringing state, presence is displayed on second line
			objFormatedMember.strPrimaryIcon = "communication-log-in-ringing-blue-48";
			objFormatedMember.strSecondaryContent = ICTouchAPI.tools.getContactDisplayName(objMember.identity);
			objFormatedMember.strPrimaryContent = (objMember.firstIncomingCall.caller.displayName)? _(objMember.firstIncomingCall.caller.displayName, "ICTouchAPI") : ICTouchAPI.tools.getContactDisplayName(objMember.firstIncomingCall.caller);
			objFormatedMember.arrSecondaryIcon = [{
					icon : "arrow-callee-supervision-26",
					width : 26
				}, {
					icon : objMember.presence + "-16",
					width : 20
				}];
			objFormatedMember.additionalStyle = "buttonList";
			objFormatedMember.objIconLeft = null;
		} else {
			objFormatedMember.strPrimaryContent = ICTouchAPI.tools.getContactDisplayName(objMember.identity);
			// If the member had no incomingCall in ringing state, presence is displayed on the left
			objFormatedMember.strPrimaryIcon = undefined;
			objFormatedMember.strSecondaryContent = "";
			objFormatedMember.arrSecondaryIcon = [];
			objFormatedMember.additionalStyle = "";
			objFormatedMember.objIconLeft = {
				icon : objMember.presence + "-24",
				width : 24
			}
		}

		return objFormatedMember;
	},

	_formatContactForShow : function(objContact) {
		objContact.officePhoneCan = objContact.officePhone.canonicalNumber;
		objContact.officePhone = objContact.officePhone.number;
		objContact.contactId = objContact.login;
		objContact.type = this.CONTACT_TYPE.UDA;

		return objContact;
	},

	/**
	 * @private
	 */
	_reorderMembers : function() {
		if(this.objSupFirstPreview){
			// Store the number of free space on first preview
			var nbToMove = this._intNbByPreview - this.objSupFirstPreview.arrItems.length;

			if(this.objSupSecondPreview){
				// Transfer from second preview to first one
				this.objSupFirstPreview.pushItems(this.objSupSecondPreview.sliceItems(0,nbToMove), true);

				// Store the number of free space on second preview
				nbToMove = this._intNbByPreview - this.objSupSecondPreview.arrItems.length;

				if(this.objSupThirdPreview){
					// Transfer from second preview to first one
					this.objSupSecondPreview.pushItems(this.objSupThirdPreview.sliceItems(0,nbToMove), true);
				}
			}
		}

	},

	/**
	 * @private
	 */
	_removeEmptyPreviews : function() {
		// Remove third preview if empty
		if(this.objSupThirdPreview && this.objSupThirdPreview.arrItems.length == 0){
			webapp.supervision.unregisterPreview(1);
		}

		// Remove second preview if empty
		if(this.objSupSecondPreview && this.objSupSecondPreview.arrItems.length == 0){
			webapp.supervision.unregisterPreview(1);
		}

		// Remove first preview if empty
		if(this.objSupFirstPreview && this.objSupFirstPreview.arrItems.length == 0){
			webapp.supervision.unregisterPreview(1);
		}
	}
});
dojo.require("webapp.supervision.dataBase");
dojo.provide("webapp.supervision.data");
dojo.declare("webapp.supervision.data", webapp.supervision.dataBase, {
	
});

webapp.supervision.data = new webapp.supervision.data();dojo.provide("webapp.supervision.getSupFirstPreviewBase");
dojo.declare("webapp.supervision.getSupFirstPreviewBase",
	[ICTouchAPI.webWidget, dijit._Templated],
	{
		domSupPreview				: null,
		supervisionContainer 		: null,

		postCreate : function() {
			this.supervisionContainer = new UIElements.Container.ContainerControl({
				objTitle: {
					strLabel: _(this.webapp.data.getGroupName(),"webapp.supervision")
				},
				objContent: {
					name : "UIElements.MenuList.MenuListControl",
					params : {
						boolPreview : true,
						boolShowNormalLeftIcon: true,
						boolHighlightSelected : false,
						autoSelectFirst : false,
						showEmptyState: false,
						boolScroll: false,
						intLiHeight : 54,

						callback : function(intIndex) {
							webapp.supervision.onSupervisedClick(intIndex);
						},

						callbackLongPress : function(intIndex) {
							webapp.supervision.onSupervisedLongPress(intIndex);
						}
					}
				}
			}, this.domSupPreview);

			var data = webapp.supervision.data;
			data.objSupFirstPreview = this.supervisionContainer.getContent();
			data.objSupFirstTitle = this.supervisionContainer.getTitle();

			data._addMembersOnPreview(0, data.getNbByPreview(), data.objSupFirstPreview);
		},

		destroy : function(){
			this.supervisionContainer.destroy();
			delete webapp.supervision.data.objSupFirstPreview;
			this.inherited(arguments);
		}
	}
	);
dojo.require("webapp.supervision.getSupFirstPreviewBase");
// Provide and create the communication webapp.
dojo.provide("webapp.supervision.getSupFirstPreview");
dojo.declare("webapp.supervision.getSupFirstPreview",
	webapp.supervision.getSupFirstPreviewBase,
	{
		templatePath: dojo.moduleUrl("webapp.supervision","templates/getSupPreview8082.html")
	}
	);
dojo.provide("webapp.supervision.getSupSecondPreviewBase");
dojo.declare("webapp.supervision.getSupSecondPreviewBase",
	[ICTouchAPI.webWidget, dijit._Templated],
	{
		domSupPreview				: null,
		supervisionContainer 		: null,

		postCreate : function() {
			this.supervisionContainer = new UIElements.Container.ContainerControl({
				objTitle: {
					strLabel: _(this.webapp.data.getGroupName(),"webapp.supervision")
				},
				objContent: {
					name : "UIElements.MenuList.MenuListControl",
					params : {
						boolPreview : true,
						boolShowNormalLeftIcon: true,
						boolHighlightSelected : false,
						autoSelectFirst : false,
						showEmptyState: false,
						boolScroll: false,
						intLiHeight : 54,

						callback : function(intIndex) {
							webapp.supervision.onSupervisedClick(intIndex);
						},

						callbackLongPress : function(intIndex) {
							webapp.supervision.onSupervisedLongPress(intIndex);
						}
					}
				}
			}, this.domSupPreview);

			var data = webapp.supervision.data;
			data.objSupSecondPreview = this.supervisionContainer.getContent();
			data.objSupSecondTitle = this.supervisionContainer.getTitle();

			data._addMembersOnPreview(data.getNbByPreview(), 2 * data.getNbByPreview(), data.objSupSecondPreview);
		},

		destroy : function(){
			this.supervisionContainer.destroy();
			delete webapp.supervision.data.objSupSecondPreview;
			this.inherited(arguments);
		}
	}
	);
dojo.require("webapp.supervision.getSupSecondPreviewBase");
// Provide and create the communication webapp.
dojo.provide("webapp.supervision.getSupSecondPreview");
dojo.declare("webapp.supervision.getSupSecondPreview",
	webapp.supervision.getSupSecondPreviewBase,
	{
		templatePath: dojo.moduleUrl("webapp.supervision","templates/getSupPreview8082.html")
	}
	);
dojo.provide("webapp.supervision.getSupThirdPreviewBase");
dojo.declare("webapp.supervision.getSupThirdPreviewBase",
	[ICTouchAPI.webWidget, dijit._Templated],
	{
		domSupPreview				: null,
		supervisionContainer 		: null,

		postCreate : function() {
			this.supervisionContainer = new UIElements.Container.ContainerControl({
				objTitle: {
					strLabel: _(this.webapp.data.getGroupName(),"webapp.supervision")
				},
				objContent: {
					name : "UIElements.MenuList.MenuListControl",
					params : {
						boolPreview : true,
						boolShowNormalLeftIcon: true,
						boolHighlightSelected : false,
						autoSelectFirst : false,
						showEmptyState: false,
						boolScroll: false,
						intLiHeight : 54,

						callback : function(intIndex) {
							webapp.supervision.onSupervisedClick(intIndex);
						},

						callbackLongPress : function(intIndex) {
							webapp.supervision.onSupervisedLongPress(intIndex);
						}
					}
				}
			}, this.domSupPreview);
			
			var data = webapp.supervision.data;
			data.objSupThirdPreview = this.supervisionContainer.getContent();
			data.objSupThirdTitle = this.supervisionContainer.getTitle();

			data._addMembersOnPreview(2 * data.getNbByPreview(), 3 * data.getNbByPreview(), data.objSupThirdPreview);
		},

		destroy : function(){
			this.supervisionContainer.destroy();
			delete webapp.supervision.data.objSupThirdPreview;
			this.inherited(arguments);
		}
	}
	);
dojo.require("webapp.supervision.getSupThirdPreviewBase");
// Provide and create the communication webapp.
dojo.provide("webapp.supervision.getSupThirdPreview");
dojo.declare("webapp.supervision.getSupThirdPreview",
	webapp.supervision.getSupThirdPreviewBase,
	{
		templatePath: dojo.moduleUrl("webapp.supervision","templates/getSupPreview8082.html")
	}
	);
