dojo.provide("webapp.supervision.dataBase");
dojo.declare("webapp.supervision.dataBase", null, {
	/* --------------------------------- Public attributes ------------------------------------ */

	/**
	 * @property
	 * @type Object
	 */
	objSupFirstPreview : null,

	/**
	 * @property
	 * @type Object
	 */
	objSupSecondPreview : null,

	/**
	 * @property
	 * @type Object
	 */
	objSupThirdPreview : null,

	/* --------------------------------- Private attributes ----------------------------------- */

	/**
	 * @property
	 * @type String
	 * @private
	 */
	_strGroupName : "",

	/**
	 * @property
	 * @type Number
	 * @private
	 */
	_intNbMembers : 0,

	/**
	 * @property
	 * @type Number
	 * @private
	 */
	_intNbByPreview : 5,

	/**
	 * @property Static value
	 * @type Number
	 * @private
	 */
	CONTACT_TYPE : {
		UDA : 1
	},

	/* ------------------------------------ Constructor --------------------------------------- */

	/**
	* @constructs
	*/
	constructor : function() {

	},

	/* ----------------------------------- Getter / Setter------------------------------------- */

	getGroupName : function() {
		return this._strGroupName;
	},

	setGroupName : function(strGroupName) {
		if(this._strGroupName != strGroupName){
			this._strGroupName = strGroupName;
			this._updatePreviewTitles();
		}
	},
	
	getNbMembers : function() {
		return this._intNbMembers;
	},

	setNbMembers : function(intNbMembers) {
		this._intNbMembers = intNbMembers;
	},

	getNbByPreview : function() {
		return this._intNbByPreview;
	},

	setNbByPreview : function(intNbByPreview) {
		this._intNbByPreview = intNbByPreview;
	},

	/* ----------------------------------- Public methods ------------------------------------- */

	/**
	 * Add new members in corresponding previews
	 * @param {array} arrNewMembers is an array of members to add
	 */
	addNewMembers : function(arrNewMembers) {
		var intNbCurrentMembers, i, intNbToAdd;
		var arrFormatedMember;
		var intNbByPreview = this.getNbByPreview();

		while(arrNewMembers.length > 0 && this.getNbMembers() < intNbByPreview * 3){
			arrFormatedMember = [];
			// Format all members to add on one list
			intNbCurrentMembers = this.getNbMembers();
			intNbToAdd = intNbByPreview - (intNbCurrentMembers % intNbByPreview);

			// Do not add more than number of members you have to add
			if(intNbToAdd > arrNewMembers.length){
				intNbToAdd = arrNewMembers.length;
			}

			// Do not add more members than previews may contain
			if(intNbToAdd + intNbCurrentMembers > intNbByPreview * 3){
				intNbToAdd = intNbByPreview * 3 - intNbCurrentMembers;
			}

			for(i = 0 ; i < intNbToAdd; i++){
				arrFormatedMember.push(this._formatMemberForList(arrNewMembers.shift()));
			}

			// Try to add on the corresponding preview
			if(intNbCurrentMembers < intNbByPreview){
				if(!this.objSupFirstPreview){
					webapp.supervision.registerPreview(0);
				} else {
					this.objSupFirstPreview.pushItems(arrFormatedMember, true);
				}
			} else if (intNbCurrentMembers < intNbByPreview*2){
				if(!this.objSupSecondPreview){
					webapp.supervision.registerPreview(1);
				} else {
					this.objSupSecondPreview.pushItems(arrFormatedMember, true);
				}
			} else if (intNbCurrentMembers < intNbByPreview*3){
				if(!this.objSupThirdPreview){
					webapp.supervision.registerPreview(2);
				} else {
					this.objSupThirdPreview.pushItems(arrFormatedMember, true);
				}
			}
			this.setNbMembers(this.getNbMembers() + intNbToAdd);
		}

		// Update title to set the right number
		this._updatePreviewTitles();
	},

	/**
	 * Remove members from corresponding previews
	 * @param {array} arrRemovedMembers is an array of members to remove
	 */
	removeMembers : function(arrRemovedMembers) {
		var strLogin;
		var removed;
		for(var i = 0 ; i < arrRemovedMembers.length ; i++){
			removed = false;
			strLogin = arrRemovedMembers[i];

			// Try to remove from each list and store if succeded
			if(this.objSupFirstPreview){
				removed = this.objSupFirstPreview.removeItemByIntIndex(strLogin, true);
			}
			if(this.objSupSecondPreview && !removed){
				removed = this.objSupSecondPreview.removeItemByIntIndex(strLogin, true);
			}
			if(this.objSupThirdPreview && !removed){
				removed = this.objSupThirdPreview.removeItemByIntIndex(strLogin, true);
			}

			// If it was really removed, decrease the number of members
			if(removed){
				this.setNbMembers(this.getNbMembers() - 1);
			}
		}

		this._reorderMembers();

		// Update title to set the right number
		this._updatePreviewTitles();
	},

	/**
	 * Remove members from corresponding previews
	 * @param {array} arrModifiedMembers is an array of members to remove
	 */
	modifyMembers : function(arrModifiedMembers) {
		var objMember;
		for(var i = 0 ; i < arrModifiedMembers.length ; i++){
			objMember = this._formatMemberForList(arrModifiedMembers[i]);
			if(this.objSupFirstPreview){
				this.objSupFirstPreview.updateItem(objMember)
			}
			if(this.objSupSecondPreview){
				this.objSupSecondPreview.updateItem(objMember)
			}
			if(this.objSupThirdPreview){
				this.objSupThirdPreview.updateItem(objMember)
			}
		}
	},

	/* --------------------------------- Private Methods -------------------------------------- */

	_updatePreviewTitles : function() {
		// For each preview, update its title if it is existing.
		webapp.supervision._arrListPreviews.forEach(function(preview) {
			if(typeof preview !== "string" && preview.supervisionContainer && preview.supervisionContainer.getTitle && preview.supervisionContainer.getTitle()){
				preview.supervisionContainer.getTitle().changeTitle(_([this.getGroupName(), "(" + preview.supervisionContainer.getContent().arrItems.length + ")"],"webapp.supervision"), 0);
			}
		}, this);
	},

	/**
	 * @private
	 */
	_addMembersOnPreview : function(intStart, intTo, objListToAdd) {

		// Format members to add
		var arrMembers = ICTouchAPI.supervisionServices.getSupUsers(intStart, intTo);
		var arrFormatedMembers = [];
		for(var i = 0 ; i < arrMembers.length ; i++){
			arrFormatedMembers.push(this._formatMemberForList(arrMembers[i]));
		}

		// Add the array of members
		objListToAdd.pushItems(arrFormatedMembers, true);

		this._updatePreviewTitles();
	},

	/**
	 * @private
	 */
	_formatMemberForList : function(objMember) {
		var objFormatedMember = {
			intIndex : objMember.identity.login,
			boolNotSelectable : true,
			additionalStyle: "",
			strSecondaryContentStyle : "italic",
			strSecondaryContentWeight : "normal"
		};

		if(objMember.ringState){
			// If the member had an incomingCall in ringing state, presence is displayed on second line
			objFormatedMember.strPrimaryIcon = "communication-log-in-ringing-blue-48";
			objFormatedMember.strSecondaryContent = ICTouchAPI.tools.getContactDisplayName(objMember.identity);
			objFormatedMember.strPrimaryContent = (objMember.firstIncomingCall.caller.displayName)? _(objMember.firstIncomingCall.caller.displayName, "ICTouchAPI") : ICTouchAPI.tools.getContactDisplayName(objMember.firstIncomingCall.caller);
			objFormatedMember.arrSecondaryIcon = [{
					icon : "arrow-callee-supervision-26",
					width : 26
				}, {
					icon : objMember.presence + "-16",
					width : 20
				}];
			objFormatedMember.additionalStyle = "buttonList";
			objFormatedMember.objIconLeft = null;
		} else {
			objFormatedMember.strPrimaryContent = ICTouchAPI.tools.getContactDisplayName(objMember.identity);
			// If the member had no incomingCall in ringing state, presence is displayed on the left
			objFormatedMember.strPrimaryIcon = undefined;
			objFormatedMember.strSecondaryContent = "";
			objFormatedMember.arrSecondaryIcon = [];
			objFormatedMember.additionalStyle = "";
			objFormatedMember.objIconLeft = {
				icon : objMember.presence + "-24",
				width : 24
			}
		}

		return objFormatedMember;
	},

	_formatContactForShow : function(objContact) {
		objContact.officePhoneCan = objContact.officePhone.canonicalNumber;
		objContact.officePhone = objContact.officePhone.number;
		objContact.contactId = objContact.login;
		objContact.type = this.CONTACT_TYPE.UDA;

		return objContact;
	},

	/**
	 * @private
	 */
	_reorderMembers : function() {
		if(this.objSupFirstPreview){
			// Store the number of free space on first preview
			var nbToMove = this._intNbByPreview - this.objSupFirstPreview.arrItems.length;

			if(this.objSupSecondPreview){
				// Transfer from second preview to first one
				this.objSupFirstPreview.pushItems(this.objSupSecondPreview.sliceItems(0,nbToMove), true);

				// Store the number of free space on second preview
				nbToMove = this._intNbByPreview - this.objSupSecondPreview.arrItems.length;

				if(this.objSupThirdPreview){
					// Transfer from second preview to first one
					this.objSupSecondPreview.pushItems(this.objSupThirdPreview.sliceItems(0,nbToMove), true);
				}
			}
		}

	},

	/**
	 * @private
	 */
	_removeEmptyPreviews : function() {
		// Remove third preview if empty
		if(this.objSupThirdPreview && this.objSupThirdPreview.arrItems.length == 0){
			webapp.supervision.unregisterPreview(1);
		}

		// Remove second preview if empty
		if(this.objSupSecondPreview && this.objSupSecondPreview.arrItems.length == 0){
			webapp.supervision.unregisterPreview(1);
		}

		// Remove first preview if empty
		if(this.objSupFirstPreview && this.objSupFirstPreview.arrItems.length == 0){
			webapp.supervision.unregisterPreview(1);
		}
	}
});
