dojo.provide("webapp.supervision.controlBase");
dojo.declare("webapp.supervision.controlBase",[ICTouchAPI.webApplication],
{
	/* --------------------------------- Public attributes ------------------------------------ */



	/* --------------------------------- Private attributes ----------------------------------- */

	/**
	 * @property
	 * @type {Array}
	 * @private
	 */
	_arrListPreviewNames : [],

	/**
	 * @property
	 * @type {Array}
	 * @private
	 */
	_arrListPreviews : [],

	/**
	 * @property
	 * @type {Integer}
	 * @private
	 */
	_intTimeLastClick : 0,

	/* ------------------------------------ Constructor --------------------------------------- */

	/**
	* @constructs
	*/
	constructor : function() {
		// Subscribe to every event from supervisionServices
		dojo.subscribe("supervision.groupAdded", this, this._onGroupAdded);
		dojo.subscribe("supervision.groupModified", this, this._onGroupModified);
		dojo.subscribe("supervision.groupDeleted", this, this._onGroupDeleted);
		dojo.subscribe("supervision.incomingCallsNumberChanged", this, this._onIncomingCallsNumberChanged);

		// Init notification
		this._initPickupNotification();

		// Fill list preview names
		this._arrListPreviewNames.push("webapp.supervision.getSupFirstPreview");
		this._arrListPreviewNames.push("webapp.supervision.getSupSecondPreview");
		this._arrListPreviewNames.push("webapp.supervision.getSupThirdPreview");

		// Link webapp styles
		ICTouchAPI.skinServices.linkWebappsStyles("webapp.getSupFirstPreview", "webapp.communication", false, true);
		ICTouchAPI.skinServices.linkWebappsStyles("webapp.getSupFirstPreview", "webapp.userinfo", false, true);
		ICTouchAPI.skinServices.linkWebappsStyles("webapp.getSupSecondPreview", "webapp.communication", false, true);
		ICTouchAPI.skinServices.linkWebappsStyles("webapp.getSupSecondPreview", "webapp.userinfo", false, true);
		ICTouchAPI.skinServices.linkWebappsStyles("webapp.getSupThirdPreview", "webapp.communication", false, true);
		ICTouchAPI.skinServices.linkWebappsStyles("webapp.getSupThirdPreview", "webapp.userinfo", false, true);

		ICTouchAPI.skinServices.linkWebappsStyles("webapp.getSupFirstPreview", "webapp.communication", true, false, true);
		ICTouchAPI.skinServices.linkWebappsStyles("webapp.getSupFirstPreview", "webapp.userinfo", true, false, true);
		ICTouchAPI.skinServices.linkWebappsStyles("webapp.getSupSecondPreview", "webapp.communication", true, false, true);
		ICTouchAPI.skinServices.linkWebappsStyles("webapp.getSupSecondPreview", "webapp.userinfo", true, false, true);
		ICTouchAPI.skinServices.linkWebappsStyles("webapp.getSupThirdPreview", "webapp.communication", true, false, true);
		ICTouchAPI.skinServices.linkWebappsStyles("webapp.getSupThirdPreview", "webapp.userinfo", true, false, true);
	},

	/* ----------------------------------- Getter / Setter------------------------------------- */



	/* ----------------------------------- Public methods ------------------------------------- */

	/**
	 * Function called by Homepage webapp when you try to register a preview
	 * @param {string} strWebapp the preview name
	 * @param {Object} div the node on which we will attach the preview
	 */
	setHomepageContainer : function (strWebapp, div) {
		if(strWebapp == this._arrListPreviewNames[0]){
			this._arrListPreviews[0] = new webapp.supervision.getSupFirstPreview({}, div);
		} else if (strWebapp == this._arrListPreviewNames[1]){
			this._arrListPreviews[1] = new webapp.supervision.getSupSecondPreview({}, div);
		} else if (strWebapp == this._arrListPreviewNames[2]){
			this._arrListPreviews[2] = new webapp.supervision.getSupThirdPreview({}, div);
		}
		this.data._updatePreviewTitles();
		strWebapp=null;
		div=null;
	},

	/* --------------------------------- Private Methods -------------------------------------- */

	/**
	 * @private
	 */
	registerPreview : function(intPreviewNumber) {
		var strPreview = this._arrListPreviewNames[intPreviewNumber];

		this._arrListPreviews[intPreviewNumber] = this._arrListPreviewNames[intPreviewNumber];

		ICTouchAPI.tools.registerHomepageContainer([strPreview, this]);
	},

	/**
	 * @private
	 */
	unregisterPreview : function(intNbToUnregister) {
		var strPreview;
		var objPreview;
		
		for(var i = 0 ; i < intNbToUnregister && this._arrListPreviews.length > 0 ; i++){
			// Get preview name
			strPreview = this._arrListPreviewNames[this._arrListPreviews.length - 1];

			// Remove one preview from array and destroy it
			objPreview = this._arrListPreviews.pop();
			if(typeof objPreview !== "string"){
				objPreview.destroy();
			}

			// Unregister the preview
			ICTouchAPI.tools.unregisterHomepageContainer([strPreview]);
		}
	},

	/**
	 * Call/pick up a call of a user
	 * @param {String} strLogin is the unique login of the user you clicked on
	 * @private
	 */
	onSupervisedClick : function(strLogin) {
		var currentTime = (new Date()).getTime();
		if(currentTime - this._intTimeLastClick > 3000){
			this._intTimeLastClick = currentTime;
			if(strLogin){
				ICTouchAPI.supervisionServices.callPickupByLogin(strLogin);
			}
		} else {
			ICTouchAPI.debugServices.warning("webapp.supervision.controlBase - onSupervisedClick / Click not managed because to close from last one.")
		}
	},

	/**
	 * Open contactCard of a user
	 * @param {String} strLogin is the unique login of the user you clicked on
	 * @private
	 */
	onSupervisedLongPress : function(strLogin) {
		if(strLogin && webapp.contacts){
			var objSupervised = ICTouchAPI.supervisionServices.getSupUserByLogin(strLogin);
			if(objSupervised){
				var objShowContactArgs = {};
				var objContact = ICTouchAPI.dataStoreServices.getStore('contacts').find(["officePhoneCan", "officePhone"], objSupervised.identity.officePhone.number)[0];
				if(objContact){
					objShowContactArgs.intId = objContact.contactId;
				} else {
					objContact = this.data._formatContactForShow(dojo.clone(objSupervised.identity));

					objShowContactArgs.objContact = objContact;
				}
				webapp.contacts.showContact(objShowContactArgs);
			} else {
				ICTouchAPI.debugServices.warning("webapp.supervision.controlBase - onSupervisedLongPress / Member with login "+ strLogin + " not found.")
			}
		}
	},

	/**
	 * @private
	 */
	onNotificationPickup : function() {
		dojo.publish("OpenHomepage", [{boolPreview:true}]);
	},

	/**
	 * Callback of dojo event : "supervision.groupAdded"
	 * @private
	 */
	_onGroupAdded : function(groupName, arrMembers) {
		// Set groupName
		this.data.setGroupName(groupName || "Supervision");

		// Add new members
		this.data.addNewMembers(arrMembers);
	},

	/**
	 * Callback of dojo event : "supervision.groupModified"
	 * @private
	 */
	_onGroupModified : function(groupName, arrAdded, arrModified, arrDeleted) {
		// Groupname is given only if it is modified
		if(groupName){
			this.data.setGroupName(groupName);
		}

		// Delete members
		if(arrDeleted){
			this.data.removeMembers(arrDeleted);
		}

		// Modify members
		if(arrModified){
			this.data.modifyMembers(arrModified);
		}

		// Add new members
		if(arrAdded){
			this.data.addNewMembers(arrAdded);
		}

		// Remove empty previews
		this.data._removeEmptyPreviews();
	},

	/**
	 * Callback of dojo event : "supervision.groupDeleted"
	 * @private
	 */
	_onGroupDeleted : function() {
		// Reset number of supervised
		this.data.setNbMembers(0);

		// Remove every preview
		this.unregisterPreview(3);

		// Clear notification
		ICTouchAPI.notificationServices.setNotificationValue("Pickup", 0);
	},

	/**
	 * @private
	 */
	_initPickupNotification : function() {
		ICTouchAPI.notificationServices.addNotification({
			strNotificationName: "Pickup",
			strNotificationLabel: _("Pickup", "webapp.supervision"),
			intNotificationValue: 0,
			callback: {
				context:this,
				func:this.onNotificationPickup
			}
		});
	},

	/**
	 * Callback of dojo event : "supervision.incomingCallsNumberChanged"
	 * @private
	 */
	_onIncomingCallsNumberChanged : function(intCallsNumber) {
		ICTouchAPI.notificationServices.setNotificationValue("Pickup", intCallsNumber);
	}
});
