dojo.provide("webapp.settings.getSettingsToasterBase");
dojo.declare("webapp.settings.getSettingsToasterBase",
	[ICTouchAPI.webWidget, dojox.dtl._Templated],
	{
		templatePath: dojo.moduleUrl("webapp.settings","templates/getSettingsToaster.html"),

		arrElementUI			: null,
		domToasterElement		: null,
		domToasterOkButton		: null,
		domToasterCancelButton	: null,
        okKey                   : null,
        cancelKey               : null,
		isActive				: false,

		postCreate:function(){

			this.okKey=new UIElements.Keyboard.Key({
					strButtonText: _("Cancel","ICTouchAPI"),
					funcCallback: dojo.hitch(this,this.buttonCancelPressed)

					}, this.domToasterCancelButton);

			this.cancelKey=new UIElements.Keyboard.Key({
					strButtonText: _("Ok","ICTouchAPI"),
					funcCallback: dojo.hitch(this,this.buttonOkPressed)

					}, this.domToasterOkButton);
		},

		setElement : function(arrUi){
			if (this.arrElementUI){
				this.unsetElement();
            }
			this.arrElementUI = arrUi;
			for (var i in arrUi)
			{
				this.arrElementUI[i].placeAt(this.domToasterElement, "first");
			}
		},

		unsetElement : function(){
			while(this.domToasterElement.firstChild){
				this.domToasterElement.removeChild(this.domToasterElement.firstChild);
            }
		},


		buttonOkPressed : function(){
			webapp.settings.getToasterValidated(this.arrElementUI);
		},

		buttonCancelPressed : function(){
			webapp.settings.getToasterCanceled();
		},

		active : function(){
			this.isActive = true;
		},

		unactive : function(){
			this.isActive = false;
		},

		isActived : function() {
			return this.isActive;
		},

        destroy : function(){
            this.okKey.destroy();
            this.cancelKey.destroy();
            this.inherited(arguments);
        }



	}
);

