dojo.provide("webapp.settings.getSettingsDateContentBase");
dojo.declare("webapp.settings.getSettingsDateContentBase",
	[ICTouchAPI.webWidget, dojox.dtl._Templated],
	{
		domCalendar	: null,
		domHour : null,

		boolTime					: false,
		boolDate					: false,

		hourUI						: null,

		intMinute					: 0,
		intHour						: 0,
		intMin						: 0,
		intMax						: 23,
		strAMPM						: _("am", "ICTouchAPI"),
		arrCalendarPlannedEvents	: [],

		attributeMap: {
            strMonth: {node: "domCalendarTitle",type: "innerHTML"}
        },

		postCreate:function(){

			if (this.boolTime)
			{

				if(!webapp.settings.data._bool24hformat)
				{
					if(this.intHour === 0 || this.intHour === 12){
                         this.intHour+= 12;
                    }
					if(this.intHour > 12){
						 this.strAMPM = _("pm", "ICTouchAPI");
						 this.intHour -= 12;
					}
					this.intMax = 12;
				}
				this.hourUI = new UIElements.ValueSelect.TimeSelect({
					intHourValue: this.intHour,
					intMinuteValue: this.intMinute,
					is24hourFormat : webapp.settings.data._bool24hformat,
					momentDay : this.strAMPM,
					strFormat: "%02d"
				}, this.domHour);
			}

			if (this.boolDate)
			{
				// Calendar
				webapp.settings.data.objCalendarUI = new UIElements.Calendar.CalendarControl({ strCalendarType: "medium",
														arrPlannedEvents : this.arrCalendarPlannedEvents }, this.domCalendar);
				var date = webapp.settings.data.objCalendarUI.attr("displayMonth");
				this.attr("strMonth",ICTouchAPI.tools.ucfirst(date.format('MMMM yyyy',dojo.locale)));
			}


            // save this widget
            webapp.settings.dateTimeConfigureContent = this;
        },


        clickLeftIcon : function() {
            // decrease month
            webapp.settings.data.objCalendarUI._adjustDisplay("month", -1);
            var date = webapp.settings.data.objCalendarUI.attr("displayMonth");
            // update the label
            this.attr("strMonth", ICTouchAPI.tools.ucfirst(date.format('MMMM yyyy',dojo.locale)));
        },

        clickRightIcon : function() {
            // decrease month
            webapp.settings.data.objCalendarUI._adjustDisplay("month", 1);
            var date = webapp.settings.data.objCalendarUI.attr("displayMonth");
            // update the label
            this.attr("strMonth", ICTouchAPI.tools.ucfirst(date.format('MMMM yyyy',dojo.locale)));
        },

		getValue : function() {

			var arrValues = [];

			if (this.boolDate){
				arrValues.push(webapp.settings.data.objCalendarUI.getValue());
            }
			else{
				arrValues.push(null);
            }
			if (this.boolTime){
				arrValues.push(this.hourUI.getHourValue());
				arrValues.push(this.hourUI.getMinuteValue());
				arrValues.push(this.hourUI.getMomentDayValue());
			}

			return arrValues;
		},

        destroy : function(){
            this.hourUI.destroy();
            webapp.settings.data.objCalendarUI.destroy();
            this.inherited(arguments);
        }


		
	}
);


