dojo.provide("webapp.settings.dataBase");

dojo.declare("webapp.settings.dataBase", null, {
	_arrAllButtons                  : [],
	_arrSysButtons                  : [],

	_arrEntries                     : [], //the array holding our categories for the menu
	_boolLoading					: false,
	_boolNeedReload					: false,
	strSettingsListTitle			: "Settings",
	strSettingsContainerTitle		: "",
	_arrDetails						: [],
	intCurrentCategory				: 0,
	intViewLevel					: 0,
	objCurrentSetting				: null,
	currentSettingWebapp			: "",
	intCurrentSetting				: 0,
	objSettingUI					: null,
	intChoiceListSelected			: 0,
	objAdminButtonUI				: null,
	arrOverriddenSettings			: [],
	arrOverriddeException			: [],
	_24hformat						: false, // 12 \ 24
	webappView						: false,
	currentWebappName				: "",
	currentWebappViewName			: "",
	objWrongSequence				: {},

	adminTimeLimit					: 180,
	adminTimer						: 0,

	MOMENT_DAY_AM					: "AM",
	MOMENT_DAY_PM					: "PM",

	_checkChange					: true,
	resetInProgress					: false,
	// Constant values for the button's id
	BACK: "BACK_BTN",
	ADMIN: "ADMIN_BTN",
	VALIDATE: "VALIDATE_BTN",
        OK: "OK_BTN",

	// View level
	VIEW_LEVEL_1	: 0,
	VIEW_LEVEL_2	: 1,
	NB_VIEW			: 2,


	boolAdminLogged  : false, // are we in admin session, may differs from strMode !
	rebootRequired : false,

	// Enum setting rights as they are in the bdd
	SETTING_WRITABLE: 2, // RW
	SETTING_READABLE: 1, // R
	SETTING_NORIGHTS: 0, // 0

	//variables used to set a timer on the loadDetails function, this timer is meant to give enought time to the load function to be done
	//properly and avoid to freeze the 2/3 on unproper presentationList destruction
	//boolean to know if we are currently loading some details
	boolAllowedLoadingDetails : true,
	//reference on the lodaing security timer
	intAllowedLoadingDetailsTimeoutID : 0,

	ERR_STD_POPUP_LABEL : "Error: the setting could not be saved.",
	ERR_ALT_POPUP_LABEL : null,

	constructor : function(){
		this.intViewLevel = this.VIEW_LEVEL_1;
		var func = dojo.hitch( webapp.settings, webapp.settings.buttonCallback);
		var backFunc = dojo.hitch( webapp.settings, webapp.settings.buttonCallback, this.BACK);

		// NEW_SETTINGS
		this._arrAllButtons[this.ADMIN] = {
			strButtonName: this.ADMIN,
			strButtonLabel: _('Admin',"webapp.settings"),
			callback : func,
			strButtonIcon: 'settings-admin',
			strStatusIcon:'notif-off'
		};
		this._arrAllButtons[this.VALIDATE] = {
			strButtonName: this.VALIDATE,
			strButtonLabel: _('Validate',"webapp.settings"),
			callback : func,
			strButtonIcon: 'app-64px-validate'
		};
		//getSettingDateFormat
		ICTouchAPI.settingServices.getSettingValue("TimeFormat", this, function(value) {
			// save the setting
			if(value !== null){
				this._24hformat = value;
			}
		});
		// Localize
		for (var i in this._arrAllButtons) {
			//this._arrAllButtons[i].strButtonLabel = _(this._arrAllButtons[i].strButtonLabel, "webapp.settings");
			}

		// Create the static back button
		ICTouchAPI.AppBarServices.addExitButton("settings", "getSettings0", this.isPreviousHome(), backFunc);

		//we load the list of the Menu Main categories and categories
		this.loadList();
	},

	buildErrorPopupLabelMinMax : function(min,max){
		if(max === undefined){
			webapp.settings.data.ERR_ALT_POPUP_LABEL = [
			"ErrHigherEqual",
			""+min];
		}else if(min === undefined){
			webapp.settings.data.ERR_ALT_POPUP_LABEL = [
			"ErrLowerEqual",
			""+max];
		}else{
			webapp.settings.data.ERR_ALT_POPUP_LABEL = [
			"ErrOutOfBound",
			""+min,
			"and",
			""+max];
		}
	},

	/*
	 * Load the main categories then subcategory for each one
	 */
	loadList : function() {
		// Don't start reloading when we already in the process
		// i just d'ont get it : if we are loading the list for the menu ... we ask a reload ?
		if( this._boolLoading ) {
			this._boolNeedReload = true;
			return;
		}
		// it seem we notify the loading of the menu
		this._boolLoading = true;
		// we set the _arrEntries empty (Holding the menu list of categories)

		//this._arrEntries = [];
		// Joel: since _arrDetails caches data, it must be cleared when (re)loading the whole list
		// we set the _arrDetails empty (holding all the UIElements displayed once)
		this._arrDetails = [];
		// We get the main categories
		ICTouchAPI.APIServices.SettingsManager.getMainCategoriesWithCheck({
			params:[ICTouchAPI.settingServices.strMode],
			context:this,
			callback:this.loadedMainCategories,
			errorCallback:this.loadingFailed
		});
	},

	/*
	 * Method is called when the categories failed to be loaded.
	 * If this failure is because anthentication was required, the user is prompted to enter admin's password.
	 */
	loadingFailed: function(strErrorValue) {
		// no more loadings
		this._boolLoading = false;
		if (strErrorValue === "NeedLogin"){//"AUTH_REQUIRED") {
			// If authentification is required, try going in admin mode and reload categories
			var strUserMode = ICTouchAPI.settingServices.MODE_ADMIN;
			var funcCallback = this.loginDone;
			var cxContext = this;
			ICTouchAPI.keyboardServices.deployKeyboard(
				ICTouchAPI.KeyboardTypes.PASSWORD,
				null,
				{
					funcCallbackOk : function(password) {
						// Try login
						ICTouchAPI.APIServices.ICTGate.login({
							params:[strUserMode, password],
							context:cxContext,
							callback:funcCallback
						}) ;
					},
					funcCallbackExit : function() {
						// Back to user mode
						webapp.settings.switchAdminMode(false);
					}
				}
				);
		}
	},

	//Open the required keyboard when asking to switch in ADMIN mode
	getAdminKeyBoard : function(){
		var strUserMode = ICTouchAPI.settingServices.MODE_ADMIN;
		var funcCallback = this.loginDone;
		var cxContext = this;
		ICTouchAPI.keyboardServices.deployKeyboard(
			ICTouchAPI.KeyboardTypes.PASSWORD,
			null,
			{
				funcCallbackOk : function(password) {
					// Try login
					ICTouchAPI.APIServices.ICTGate.login({
						params:[strUserMode, password],
						context:cxContext,
						callback:funcCallback
					}) ;
				},
				funcCallbackExit : function() {
					// Back to user mode
					webapp.settings.switchAdminMode(false);
				},
				strInputTitle : _("Please enter the admin password","webapp.settings"),
				hideStarsIfPasswordEmpty :true
			}
		);
	},
	//This function is called only byt the ADMIN keyboard, so we can be sure we are switching from USER to ADMIN
	loginDone : function(strMsgLogin){
		ICTouchAPI.settingServices.strMode = ICTouchAPI.settingServices.MODE_ADMIN;
		this.clearDetails();
		this.launchTimer();
		this.checkLogin(strMsgLogin);
	},

	checkLogin: function(strMsgLogin) {
		if (ICTouchAPI.settingServices.strMode === ICTouchAPI.settingServices.MODE_ADMIN && strMsgLogin === "Login Ok")
		{
			// reload we have right rights
			this.loadList();
			// flag this as admin session
			this.boolAdminLogged = true;
			// switch the button to reflect the real state
			webapp.settings.switchAdminButton(true);
		}
		else
		{
			//show the warning popup here
			webapp.settings.getWarningAdminPwdPopup();
			// logout and go back user mode
			this.logout();
		//webapp.settings.switchAdminButton(false);
		}
	},

	// need to logout to return back to USER mode
	logout : function()
	{
		ICTouchAPI.APIServices.ICTGate.logout({
			context:this,
			callback:this.loggedOut
		});
	},

	loggedOut : function(strMsg)
	{
		// Back to user mode
		ICTouchAPI.settingServices.strMode = ICTouchAPI.settingServices.MODE_USER;
		this.boolAdminLogged = false;
		webapp.settings.switchAdminMode(false);
	},

	//called once the main categories of the menu have been returned
	loadedMainCategories: function(_arr) {
		//_arr : an array holding the main categories
		//we start a chain of recursives calls
		this._arrEntries = [];
		this.loadNextSubCategories(_arr, 0);
	},

	/*
	 * load the subcategory
	 * this function will call itself in its callback until every subcategory has been loaded
	 */
	loadNextSubCategories: function(_arr, idx) {
		//_arr : hold the main categories
		//idx : index on the current main category
		//if at least one of the params do not match the expectations
		if (!_arr || idx >= _arr.length) {
			//if listUI hold a reference to the left part of the main container of the webapp we refresh it
			//to do : check that refresh actually works ........
			if (webapp.settings.listUI){
				webapp.settings.listUI.refresh();
			}
			//we notify the end of the load ? note : i really don't get the usage nor the meaning of this boolean
			this._boolLoading = false;
			//same here
			if (this._boolNeedReload) {
				this._boolNeedReload = false;
				this.loadList();
			}
			//we start once again the load
			return;
		}
		//in _arrEntries we add an entry corresponding to the main categories of the 'idx' index
		this._arrEntries.push({
			//the index is the index of the last row
			intIndex: this._arrEntries.length,
			//seems we save the name to be displayed and some references about the context
			strPrimaryContent: _(_arr[idx].name, "webapp.settings"),
			//the previous content which will be displayed is a title which is supposed to hold categories and be extended or colapsed
			strType: "title",
			//i have to track down the usage of this data befoe to explain it
			boolEmphasis: _arr[idx].missing_mandatory
		});

		ICTouchAPI.APIServices.SettingsManager.getCategoriesWithCheck({
			//the name of the main categories holding the categories we are looking for
			//the current mode ?? admin or user to check the acces rights (i suppose)
			params: [_arr[idx].name, ICTouchAPI.settingServices.strMode],
			context: this,
			callback: this.loadedSubCategory,
			errorCallback: null,
			callbackParams: {
				array: _arr,
				index: idx
			}
		});

	},

	//called by loadNextSubCategories in order to built the menu list of the categories
	loadedSubCategory : function(_arrSub, params) {
		//_arrSub : returned by the platform, hold the categories of the current main category
		//params : hold the array of the main categories and the index of the current category
		//an index to target the last row of the table
		var indexMain = this._arrEntries.length-1;
		//we each categories into the _arrSub
		for (var i = 0; i < _arrSub.length; i++) {
			this._arrEntries.push({
				//index of the new object added at the end of the array
				intIndex: this._arrEntries.length,
				//some data to display and references on the targeted category
				strPrimaryContent: _(_arrSub[i].name, "webapp.settings"),
				//the type of the record (title | normal)
				strType: "normal",
				//the location of this record within the menu list
				strMainCat: params.array[params.index].name,
				//the index of the refering main category (the title above me)
				indexMainCat: indexMain,
				//name of the being included category
				strSubCat: _arrSub[i].name,
				//to track down ... duno yet
				boolEmphasis: _arrSub[i].missing_mandatory
			});
		}
		//calling the caller function on the next main category we will loop until all them ain categories will be done
		this.loadNextSubCategories(params.array, params.index + 1);
	},

	/*
	 * Load the settings associated with a subcategory and make it the activ subcategory
	 * This is mostly used when a user click on a subcategory
	 */
	loadDetails : function(intIndex) {
		//intIndex : index of the clicked element in the menu list
		//alert("enter in loadDetails");
		//this.intCurrentSetting = 0;
		//this.objCurrentSetting = null;
		//Reset error sequence
		this.objWrongSequence = {};
		//reset a timer linked to the admin mode
		if(ICTouchAPI.settingServices.strMode === ICTouchAPI.settingServices.MODE_ADMIN){
			this.resetTimer();
		}
		//???
		this._checkChange=true;
		//we change the index refering to the last 'current category' up to the new 'current category' index
		this.intCurrentCategory = intIndex;
		//getting a quick reference on the clicked category
		var obj = this._arrEntries[intIndex];

		//the level of the view ? seem to be deprecqted qnd should be erased
		this.intViewLevel = this.VIEW_LEVEL_1;

		// update action Bar
		webapp.settings.updateActionBar();

		this._arrDetails = [];

		// If homepage category clicked, go to progkeys
		if(obj.strSubCat == "homepage" && webapp.progkeys){
			this.clearDetails();
			webapp.progkeys.data.syncProgKeysWithHomepage();
			ICTouchAPI.transitionServices.getScreen({name : "webapp.progkeys.getProgKeys", params : {}});
			return ;
		}

		this.strSettingsContainerTitle = _(obj.strSubCat, "webapp.settings");

		this.before = new Date().getTime();
		// getSettings with the user mode and an error callback
		ICTouchAPI.settingServices.getSettings(
			obj.strMainCat,                         //the main category
			obj.strSubCat,                          //the category (clicked row)
			ICTouchAPI.settingServices.strMode,     //mode user or admin
			this,                                   //the context
			this.loadedDetails,                     //the callback
			this.loadingFailed,                     //callback if we fail
			intIndex);                              //indexe of the clicked item

	},

	/*
	 * Callback for the settings from current activ subcategory
	 * It will fill the _arrDetails[index] with data suitable for ClickableList
	 */
	loadedDetails : function(_arr, intIndex) {
		var start = new Date().getTime();
		ICTouchAPI.debugServices.info("webapp.settings.data - loadedDetails ("+ (start-this.before) + ")");
		this._arrDetails = [];
		//_arr : the array holding settigns
		//intIndex : index of the clicked row and previously of the corresponding row in _arrDetails

		//TYPE_WEBAPP appear to be the type used to notify that there is a view proposed in the refering webapp
		var item;
		if (_arr && _arr[0] && _arr[0].type === ICTouchAPI.settingServices.TYPE_WEBAPP){
			this.currentSettingWebapp = _arr[0].module;
			//we get some references on the webapp holding the setting
			var wa = ICTouchAPI.tools.getObjectReference("webapp."+_arr[0].module);
			//just checking nothing is wrong abotu the webapp
			if(wa){
				//some references
				item = {
					strContent: _arr[0].value,
					strLabel: _(_arr[0].label, "webapp.settings"),
					boolEnabled: _arr[0].boolenabled,
					objSetting: _arr[0]
				};
				//this._arrDetails[intIndex].push(item);
				//we add the item in the _arrDetails
				this._arrDetails.push(item);
				//we get / build the view from the webapp
				webapp.settings.getView(_arr[0]);
			}
			ICTouchAPI.debugServices.info("webapp.settings.data - loadedDetails done ("+ (new Date().getTime() - start) +")");
			return;
		}
		//else for each setting returned
		for (var i in _arr) {
			//Setting enabled or not
			var enabled = false;
			// check Writing Rights of the setting
			if(ICTouchAPI.settingServices.strMode === ICTouchAPI.settingServices.MODE_USER)
			{
				if(_arr[i].user_rights && _arr[i].user_rights === this.SETTING_WRITABLE){
					enabled = true;
				}
			}
			else if(ICTouchAPI.settingServices.strMode === ICTouchAPI.settingServices.MODE_ADMIN)
			{
				if(_arr[i].admin_rights &&  _arr[i].admin_rights === this.SETTING_WRITABLE){
					enabled = true;
				}
			}
			//Getting the UIElement
			//var objUI = webapp.settings.getSettingUI(_arr[i]);
			var objUIType = webapp.settings.getSettingUIType(_arr[i]);

			//Embed means to be directly accessable on the page (no lsts or toaster or  .. ) just like input text
			var func;
            if ( objUIType === webapp.settings._UI_TYPE_EMBED && enabled)
			{
				if (this.arrOverriddenSettings[_arr[i].id]) {
					if(this.arrOverriddeException[_arr[i].id]){
						item = {
							objContent: webapp.settings.getSettingUI(_arr[i]),
							strLabel: _(_arr[i].label, "webapp.settings"),
							boolEnabled: enabled,
							objSetting: _arr[i]
						};
						item.callback = dojo.hitch(this, this.callOverridden, _arr[i]);
					}
				}else{
					item = {
						objContent: webapp.settings.getSettingUI(_arr[i]),
						strLabel: _(_arr[i].label, "webapp.settings"),
						boolEnabled: enabled,
						objSetting: _arr[i]
					};
					func = dojo.hitch(this, this.setCurrentObj, intIndex, this._arrDetails.length /*this._arrDetails[intIndex].length*/);
					item.callback = func;
				}
			}else{
				//getting the string value if was an object
				if (objUIType === webapp.settings._UI_TYPE_EMBED
						|| objUIType === webapp.settings._UI_TYPE_TOASTER){
					value = webapp.settings.getSettingTextualValue(_arr[i]);
				}
				else if(_arr[i].typeData.name == ICTouchAPI.settingServices.TYPE_PASSWORD){
					value = "*****";
				}
				else {
					value = webapp.settings.getSettingUI(_arr[i]);
				}
				item = {
					strContent: value,
					strLabel: _(_arr[i].label, "webapp.settings"),
					boolEnabled: enabled,
					objSetting: _arr[i]
				};
				if ( objUIType === webapp.settings._UI_TYPE_TOASTER )
				{
					func = dojo.hitch(this, this.loadToaster, intIndex, this._arrDetails.length);
					item.callback = func;
				}
				else if (this.arrOverriddenSettings[_arr[i].id]) {
					item.callback = dojo.hitch(this, this.callOverridden, _arr[i]);
				}
			}
			item.boolEmphasis = _arr[i].missing_mandatory;
			this._arrDetails.push(item);
		}

		//webapp.settings.detailsUI.setContainer("webapp.settings.getSettingsContainer");
		if (this.webappView){

			//we go back to the view of the webapp setting
			webapp.settings.backToSettingView();

		}
		else {
			if (webapp.settings.detailsUI && !this.webappView){
				try{
					webapp.settings.detailsUI.refresh();
				}catch(e){
					ICTouchAPI.debugServices.error("webapp.settings.dataBase - loadedDetails / refresh of the detailsUI view crashed");
					this._arrDetails = [];
					webapp.settings.resetActionBar();
					webapp.settings.thirdUI.setContainer("webapp.settings.getSettingsContainer",{});
					webapp.settings.detailsUI = webapp.settings.thirdUI.getContainer();
					if(this.intCurrentCategory >= 0){
						this.loadDetails(this.intCurrentCategory);
					}
				}
			//if (this.intCurrentSetting)
			//	webapp.settings.detailsUI.objContent.moveToItem(this.intCurrentSetting);
			}
		}
		ICTouchAPI.debugServices.info("webapp.settings.data - loadedDetails done ("+ (new Date().getTime() - start) +")");
	},

	updateSetting: function(newSetting) {
		if (this.objCurrentSetting.id === newSetting.id) {
			this.objCurrentSetting = newSetting;
			/*if(this.objCurrentSetting.id == "Language") {
			    this.loadDetails(this.intCurrentCategory);
			}*/
		}
		for(var i=0; i<this._arrDetails.length; i++) {
			if (this._arrDetails[i].objSetting.id === newSetting.id) {
				this._arrDetails[i].objSetting = newSetting;
				if (typeof this._arrDetails[i].objContent != "undefined" && typeof this._arrDetails[i].objContent.associatedSetting != "undefined") {
					this._arrDetails[i].objContent.associatedSetting = newSetting;
				}
				return;
			}
		}
	},

	/*
	 * Call overridden setting edition
	 */
	callOverridden : function(objSetting,value) {
		if (this.arrOverriddenSettings[objSetting.id]){ // should be true
			this.arrOverriddenSettings[objSetting.id](objSetting, value,webapp.settings.detailsUI);
		}
	},

	/*
	 * Load the toaster for edition
	 */
	loadToaster : function(intCategory, intSetting) {
		this.intCurrentSetting = intSetting;
		//this.objCurrentSetting = this._arrDetails[intCategory][intSetting].objSetting;
		this.objCurrentSetting = this._arrDetails[intSetting].objSetting;
		webapp.settings.getToaster(this.objCurrentSetting);
	},

	/*
	 * Load a specific setting when the user clicks on it
	 * Update the view into edit mode
	 */
	loadSetting : function(intCategory, intSetting) {
		this.intViewLevel = this.VIEW_LEVEL_2;
		// update action Bar
		webapp.settings.updateActionBar();

		//this.objCurrentSetting = this._arrDetails[intCategory][intSetting].objSetting;
		this.objCurrentSetting = this._arrDetails[intSetting].objSetting;
		this.strSettingsContainerTitle = _(this.objCurrentSetting.label, "webapp.settings");
		if (webapp.settings.detailsUI && !this.webappView){
			webapp.settings.detailsUI.refresh();
		}
	},

	getActionBarAppButtons : function(intViewLevel){
		switch (intViewLevel) {
			case this.VIEW_LEVEL_1:
				//{
				if (ICTouchAPI.settingServices.strMode === ICTouchAPI.settingServices.MODE_ADMIN){
					this._arrAllButtons[this.ADMIN].strStatusIcon = "notif-on";
				}
				else{
					this._arrAllButtons[this.ADMIN].strStatusIcon = "notif-off";
				}
				return [this._arrAllButtons[this.ADMIN]];
			//}
			case this.VIEW_LEVEL_2:
				return [this._arrAllButtons[this.VALIDATE]];
			default:
				return [];
		}
	},

	getAppBarSysButtons: function(){
		return this._arrSysButtons;
	},

	getSettingsContainerTitle: function(){
		return this.strSettingsContainerTitle;
	},

	getSettingsListTitle:function(){
		return this.strSettingsListTitle;
	},

	getListEntries: function(){
		return this._arrEntries;
	},

	/*
	 * Get current activ details list for ClickableList
	 */
	getDetails: function(){
		//var intIndex = this.intCurrentCategory;
		// Do some sanity checks and return a safe default if it fails
		//if( intIndex === undefined || intIndex < 0 )
		//	return [];
		//if( this._arrDetails[intIndex] === undefined )
		if( this._arrDetails === undefined ){
			return [];
		}
		//return this._arrDetails[intIndex];
		return this._arrDetails;
	},

	/**
	 * Clears the details UI, used when switching User mode
	 * as we LoadList();
	 */
	clearDetails: function() {
		//Reset error sequence
		this.objWrongSequence = {};
		// force LVL 1 - update bars - update title
		this.intViewLevel = this.VIEW_LEVEL_1;
		webapp.settings.updateActionBar();
		this.strSettingsContainerTitle = "";
		// force no category
		this.intCurrentCategory = undefined;
		//make empty the 2/3 panel
		this._arrDetails = [];
		//reset the currently targeting UI
		this.intCurrentSetting = 0;
		this.objCurrentSetting = null;
		//Refresh the 2/3 panel on an empty _arrDetails array if this is not a webapp view
		if (webapp.settings.detailsUI && !this.webappView){
			webapp.settings.detailsUI.refresh();
		}
		// if the current setting displayed is a webapp view (bluetooth)
		// call backToSettingView to close it
		if(this.webappView){
			//rebuild the 2/3 panel based on _arrDetails (empty)
			webapp.settings.backToSettingView();
		}
		return;
	},


	setCurrentObj : function(intCategory, intSetting) {
		this.intCurrentSetting = intSetting;
		//this.objCurrentSetting = this._arrDetails[intCategory][intSetting].objSetting;
		this.objCurrentSetting = this._arrDetails[intSetting].objSetting;
	},


	launchTimer : function(){
		this.resetTimer();
		if( this.intervalHandler ){
			clearInterval(this.intervalHandler);
		}
		var that = this;
		var func = function () {
			that.updateTimer();
		};
		this.intervalHandler = setInterval(func, 1000);
	},

	updateTimer : function(){
		this.adminTimer++;
		if (this.adminTimer === this.adminTimeLimit){
			webapp.settings.switchAdminMode(false);
		}
	},

	resetTimer : function(){
		this.adminTimer = 0;
	},

	isPreviousHome : function() {
		return true;
	},

	checkSequenceError : function() {
		var error = false;
		for(var i in this.objWrongSequence) {
			error = true;
			break;
		}
		return error;
	},

	setReboot: function(reboot) {
		this.rebootRequired = reboot ? true : false;
	},

	getResetInProgress : function(){
		return this.resetInProgress;
	},

	setResetInProgress : function(_bool){
		this.resetInProgress = _bool;
	}

});
