dojo.provide("webapp.settings.controlBase");
dojo.declare("webapp.settings.controlBase",[ICTouchAPI.webApplication],
{
	listUI					: null, //reference on the left part of the main view, the main menu
	detailsUI				: null, //reference on the right part of the main view, the part with the UIElements
	thirdUI                 : null, //reference on the global container
	categoriesListUI        : null, //reference on the list of settings present in the menu

	webappViewUI	: null,
	objPopup		: null,
	toasterUI		: null,
	boolNeedReboot	: false,
    settingsContainer : null,
    containerList       : null,
    viewContainer       : null,
	resetUserDataImage	: null,
	resetUserDataFrame	: null,

	// UI type constants
	_UI_TYPE_EMBED		: "embed",		// used for types such as boolean, texts (directly editable)
	_UI_TYPE_TOASTER	: "toaster",	// used for types that require to open a toaster such as calendar or choice
	_UI_TYPE_OTHER		: "other",		// used for types that require a specific screen, or disabled settings (no specific UI in list)
	_UI_TYPE_WEBAPP		: "webapp",		// used for types that require a specific view from another webapp

	_UI_SELECT_MINUTE	: "valueMinute", //used to differency the value select for time
	_UI_SELECT_HOUR		: "valueHour",
	_UI_SELECT_MOMENT	: "momentDay",
	_UI_AM				: "am",
	_UI_PM				: "pm",

	// @author: Ludovic Cadart
	// @date 24/09/09
	// The callBack buttons can have different behaviors depending on the context
	// by default the callBack button loads the homepage screen
	_backButton: null,
	_directionCallBackButtonByDefault: "webapp.homepage.getHomepage",
	_directionCallBackButton: null,

	constructor : function() {
		var func = function(){
			//if we left the webapp viewing a category's settings
			if(webapp.settings.data.intCurrentCategory){
				//we rebuilt the page so that any modification should be handled
				webapp.settings.data.loadDetails(webapp.settings.data.intCurrentCategory);
			}
			//callback for enterMMI
				var funcEnterMMI = function(arg){
					if(!arg){
                            //if not : back to the Homepage (the previous view)
                            ICTouchAPI.transitionServices.back();
					}else{
						//allowed => keep going
						ICTouchAPI.transitionServices.getScreen({
								name: "webapp.settings.getSettings",
								params: {}
						});
					}
				};
			//we call the enterMMI function to check our capability to enter into the setting webapp
			ICTouchAPI.settingServices.enterMMI({
				context : this,
				callback : funcEnterMMI
			});
		};

		//Used to display the play icon in cases of previews settings
		ICTouchAPI.skinServices.linkWebappsStyles("UIElements.DialogBox","webapp.filesmanager",true,false,true,false);
		ICTouchAPI.skinServices.linkWebappsStyles("UIElements.Keyboard","webapp.settings", true, false, true, false);
		//If the webapp is required, we create access from the homepage
		ICTouchAPI.settingServices.getSettingValue("EnableWebappSettings", this, function(value) {
			if(value === true){
		//we add the webapp button to the homepage action buttons, the call back function "func" allow us to
        //call the enterMMI() function of the SettingManager
		ICTouchAPI.tools.registerHomepageButton(["webapp.settings.getSettings", "SETTINGS_BTN", "settings-application", _('SettingsBtn','webapp.settings'),func]);
				ICTouchAPI.tools.registerHomepageKey(["webapp.settings.getSettings", "SETTINGS_BTN", "settings-application", _('SettingsBtn','webapp.settings'),null,func]);
			}
		})

        //subscriptions to some settings and events
		ICTouchAPI.settingServices.subscribeToSetting(this, "TimeFormat", this.onTimeFormatChanged);
		ICTouchAPI.eventServices.subscribeToEvent(this, "show_webapp_settings", this.onShowWebappEvent);
		ICTouchAPI.eventServices.subscribeToEvent(this, "ChangedSettingEvent", this.onSettingChanged);

		ICTouchAPI.eventServices.subscribeToEvent(this, "SENSKEY_USER", this.ring_stop_preview);
		ICTouchAPI.eventServices.subscribeToEvent(this, "SENSKEY_COMM", this.ring_stop_preview);
		ICTouchAPI.eventServices.subscribeToEvent(this, "SENSKEY_EVENT", this.ring_stop_preview);
		ICTouchAPI.eventServices.subscribeToEvent(this, "SENSKEY_HOME", this.ring_stop_preview);

		ICTouchAPI.eventServices.subscribeToEvent(this, "WS_AUTHENTICATERESULT", this.clbLoginUserData);
		ICTouchAPI.eventServices.subscribeToEvent(this, "resetLocalDataAuthenticateResult", this.clbLocalLoginUserData);
		ICTouchAPI.eventServices.subscribeToEvent(this, "reset_data_default", this.showResetUserDataFrame);
		//ICTouchAPI.eventServices.subscribeToEvent(this, "reset_data_default_complete", this.hideResetUserDataFrame);
		// by default the callback button returns to the homepage
		this._directionCallBackButton = this._directionCallBackButtonByDefault;

		//Actions definition
		//For the moment no core function are defined
		ICTouchAPI.settingServices.addActionMethod("melody_preview", dojo.hitch(this,this.ring_preview));
		ICTouchAPI.settingServices.addActionMethod("melody_stop", dojo.hitch(this,this.ring_stop_preview));

		//we send an event to notify the load of the setting webapp
		ICTouchAPI.APIServices.ICTGate.notifyEventPresentation({
			params:["SettingsLoaded"]
		});
		this.preloadResetUserDataFrame();
	},

	load: function() {
		//help
		var widgetsTab = [];
		for(var i=0; i<webapp.settings.data.NB_VIEW; i++) {
			widgetsTab.push("getSettings"+i);
		}
		dojo.publish("needHelpEvent",["settings",widgetsTab]);
	},

	loaded : function() {
		//suscribe to an application event to reload categories when rights changed
		ICTouchAPI.eventServices.subscribeToEvent(this, "ChangedSettingsRightsEvent", this.reloadList);
		dojo.subscribe("settings/reloadCurrentCategory",this,function(){
			this.data.loadDetails(this.data.intCurrentCategory);
		});
		this.overrideResetSettings();
	},

	reloadList : function() {
		this.data.loadList();
	},


	/*
	 * setBackButton method sets the future screen further to a
	 * click on Back button
	 * @param : {string}
	 * @author: Ludovic Cadart
	 * @date : 24/09/09
	 */
	setBackButton: function(direction){
		this._directionCallBackButton = direction;
	},

	/*
     * setByDefaultDirectionCallBackButton method sets the default screen
     * further to a click on Back button
     *
     * @author: Ludovic Cadart
     * @date : 24/09/09
     */
	setByDefaultDirectionCallBackButton: function(){
		this._directionCallBackButton = this._directionCallBackButtonByDefault;
	},

	/*
	 * Callback when a button from appbar is clicked
	 */
	buttonCallback: function(buttonId) {
		var data = this.data;
		switch (buttonId) {
			case data.BACK:
				// If we go out of settings webapp
				if(this.data.checkSequenceError()) {
					this.getSequenceErrorPopup();
				}
				else {
					if (data.intViewLevel === data.VIEW_LEVEL_1) {
						// If no reboot is required
						if (!data.rebootRequired) {
							this.quitSettingsWebapp();
						}
						// If reboot is required
						else {
							this.showRebootRequired(dojo.hitch(this, this.quitSettingsWebapp));
						}
					} else {
						this.checkChange(dojo.hitch(this, this.goToLevelOne));
					}
				}
				break;

			// switch to admin mode
			case data.ADMIN:
				//this.switchAdminMode(data.strMode != data.MODE_ADMIN);
				this.switchAdminMode(ICTouchAPI.settingServices.strMode !== ICTouchAPI.settingServices.MODE_ADMIN);
				break;


			default:
				console.warn("buttonCallbak : no callback is defined for this button id:"+buttonId);
		}
	},

	//called to leave the webapp
	quitSettingsWebapp: function() {
		//unlock the webapp and let the settingManager handle the reboot
		ICTouchAPI.settingServices.exitMMI();
		//go back to the homepage
		ICTouchAPI.transitionServices.stealth("webapp.settings.getSettings");
		ICTouchAPI.transitionServices.back();
		ICTouchAPI.transitionServices.unstealth("webapp.settings.getSettings");

	},
	overrideSetting: function(id, callback) {
		webapp.settings.data.arrOverriddenSettings[id] = callback;
	},

	overrideResetSettings: function(){
		var that = this;
		var funcResetFactory = function(objSetting, value, detailsUI ) {
			that.askPasswordForResetFactory(objSetting, value,detailsUI)
		};
		this.overrideSetting("EnableResetFactory",funcResetFactory);
		this.data.arrOverriddeException["EnableResetFactory"] = true;
		var funcResetUserData = function(objSetting, value, detailsUI) {
			that.askPasswordForResetUserData(objSetting, value, detailsUI)
		};
		this.overrideSetting("EnableResetUserData",funcResetUserData);
		this.data.arrOverriddeException["EnableResetUserData"] = true;
	},

	askPasswordForResetFactory: function(objSetting, intIndex, detailsUI){
		if(intIndex == 0){//Pos 0 - OptionChooser is on YES value
			this.raiseResetFactoryKeyboard();
		}
	},

	askPasswordForResetUserData: function(objSetting, intIndex, detailsUI){
		if(intIndex == 0){//Pos 0 - OptionChooser is on YES value
			if(this.data.boolAdminLogged){//If logged as admin we launch the reset user data
				this.showResetUserDataFrame();
				var cbContext = this;
				ICTouchAPI.APIServices.ICTSaveRestore.resetToDefault({
					context:cbContext
				});
			}else{//Else we ask the user password
				this.raiseResetUserDataKeyboard();
			}
		}
	},

	raiseResetFactoryKeyboard: function(){
		var strUserMode = ICTouchAPI.settingServices.MODE_DEFAULTADMIN;
		var funcCallback = this.clbLoginDefaultAdmin;
		var cbContext = this;
		ICTouchAPI.keyboardServices.deployKeyboard(
			ICTouchAPI.KeyboardTypes.PASSWORD,
			null,
			{
				funcCallbackOk : function(password) {
					// Try login as default admin
					ICTouchAPI.APIServices.ICTGate.login({
						params:[strUserMode, password],
						context:cbContext,
						callback:funcCallback
					});
				},
				funcCallbackExit : function() {
					// We do nothing
					webapp.settings.data.loadDetails(webapp.settings.data.intCurrentCategory);
				},
				strInputTitle : _("Enter factory administrator password to confirm the reset to factory","webapp.settings"),
				hideStarsIfPasswordEmpty :true
			}
			);
	},

	raiseResetUserDataKeyboard: function(){
		var cbContext = this;
		ICTouchAPI.keyboardServices.deployKeyboard(
			ICTouchAPI.KeyboardTypes.PASSWORD,
			null,
			{
				funcCallbackOk : function(password) {
				// Send user password
					ICTouchAPI.APIServices.IctUser.eraseUserData({
						params:[password],
						context:cbContext
					});
				},
				funcCallbackExit : function() {
					// We do nothing
					webapp.settings.data.loadDetails(webapp.settings.data.intCurrentCategory);
				},
				strInputTitle : _("Enter your password to confirm deletion of the user data","webapp.settings"),
				hideStarsIfPasswordEmpty :true
			}
			);
	},
	
	/**
	 * Called when the authentification fails
	 */
	clbLocalLoginUserData : function() {
		var objArguments = ICTouchAPI.tools.getEventArguments(arguments);
		if(objArguments.result == "failure"){
			this.raiseResetUserDataKeyboard();
		}
	},

	/**
	 * Called on OT when the authentification is done in the server
	 */
	clbLoginUserData: function(){
		var objArguments = ICTouchAPI.tools.getEventArguments(arguments);
		if(objArguments.reqId == "IctUser eraseUserData"){
			if (objArguments.response){
				this.showResetUserDataFrame();
			}
		}
	},


	clbLoginDefaultAdmin: function(strMsgLogin){
		if (strMsgLogin === "Login Ok"){
			var context = this;
			var popupData = {
				strTitle: _("Reset to factory", 'webapp.settings'),
				strType: "warning",
				strContent : _("You are just about to reset the phone to factory configuration. Are you sure you want to proceed ?", 'webapp.settings'),
				arrPopupButtons: [
				{
					strButtonLabel: _('Yes', "ICTouchAPI"),
					strButtonIcon: "generic-ok",
					callback : function(){
						ICTouchAPI.debugServices.error("webapp.settings - call resetFactory");
						ICTouchAPI.APIServices.Platform.resetToFactory({
							params:["MMI", "Reset to factory"]
						});
					}
				},

				{
					strButtonLabel: _('No', "ICTouchAPI"),
					strButtonIcon: "generic-cancel",
					callback : function(){
						ICTouchAPI.popupServices.removePopup(context.popupLoginDefaultAdmin);
						webapp.settings.data.loadDetails(webapp.settings.data.intCurrentCategory);
					}
				}
				]
			};

			this.popupLoginDefaultAdmin = ICTouchAPI.popupServices.addNewPopup(popupData, "MEDIUM");
		}else{
			this.data.loadDetails(this.data.intCurrentCategory);
		}
	},

	preloadResetUserDataFrame : function(){
		//preloading the image for the transition iFrame
		this.resetUserDataImage = new Image();
		this.resetUserDataImage.src = "/webapp/settings/themes/Default/images/resetuserdata.png";
		//create the iFrame (hidded)
		this.resetUserDataFrame = this._createResetUserDataFrame(this.resetUserDataImage.src);
	},
	
	showResetUserDataFrame : function(){
		this.resetUserDataFrame._show();
	},

	hideResetUserDataFrame : function(){
		this.resetUserDataFrame._hide();
	},

	_createResetUserDataFrame : function(strImgPath){
		var myFrame = dojo.byId("resetUserData");
		if(!myFrame){
			var iFrame = dojo.create("iframe",{
				'id':'resetUserData',
				'src':'iframe.html'
			},dojo.body());
			dojo.style(iFrame,{
				'height':'480px',
				'width':'800px',
				'top':'0px',
				'left':'-1000px',
				'zIndex':'20000'
			});

			var loaded = function () {
				var body = iFrame.contentDocument.body;
				var head = dojo.query("head", iFrame.contentDocument)[0];

				// Add CSS for Spinner
				dojo.create("link", {
					rel: "stylesheet",
					type: "text/css",
					href: "http://127.0.0.1/library/ICTouchAPI/UIElements/Spinner/themes/Default/css/base.css"
				}, head);
				dojo.create("img", {
					src: strImgPath,
					style: "pointer-events: none"
				}, body);
				this.spinner = new UIElements.Spinner.SpinnerControl({
					strMessage : _('Reset user data in progress...', "webapp.settings"),
					boolForeground:true
				}, body);

				iFrame.removeEventListener("load", loaded, false);
			};
			iFrame.addEventListener("load", loaded, false);

			iFrame._show = function(){
				webapp.settings.data.setResetInProgress(true);
				clearTimeout(this.hideTimer);
				dojo.style(this,'left','0px');
				this.hideTimer = setTimeout(function(){
					iFrame._hide();
				}, 45000);
			};

			iFrame._hide = function(){
				clearTimeout(this.hideTimer);
				dojo.style(this,'left','-1000px');
				webapp.settings.data.setResetInProgress(false);
				webapp.settings.data.loadDetails(webapp.settings.data.intCurrentCategory);
			};
			//linking the iFrame to our document

			return iFrame;
		}else{
			//returning the existing iFrame
			return myFrame;
		}
	},

	checkChange: function(callbackDone) {
		webapp.settings.data._checkChange=false;
		var oldValue = "";
		if(this.data.objCurrentSetting!==null)
		{
			oldValue=this.data.objCurrentSetting.jsValue;
		}
		var newValue = this.getNewValue();
		// Joel: temporary removed until setting validation process fully implemented
		if( oldValue != newValue ){
			this.showConfirmation(newValue, callbackDone);
		}else if(callbackDone){
			callbackDone();
		}else{
	//Nothing
	}
	},

	showConfirmation: function(newValue, callbackDone) {
		// confirmation popup
		var context = this;
		var strContent = _("Save changes before exiting?", "webapp.settings");
		var popupDel = {
			strTitle: _("Save confirmation", "webapp.settings"),
			strType: "warning",
			"strContent": strContent,
			arrPopupButtons: [
			{
				strButtonLabel: _("Yes", "ICTouchAPI"),
                                strButtonIcon: "generic-ok",
				callback : function(){
					context.closePopupConfirmSave();
					context.saveSetting(newValue, callbackDone);
				}
				},

				{
				strButtonLabel: _("No", "ICTouchAPI"),
                                strButtonIcon: "generic-cancel",
				callback : function(){
					context.closePopupConfirmSave();
					context.data.objCurrentSetting = null;
					callbackDone();
				}
				}
			]
			};
		this.objPopupConfirmSave = ICTouchAPI.popupServices.addNewPopup(popupDel, "MEDIUM");
	},

	closePopupConfirmSave: function() {
		if( this.objPopupConfirmSave !== null )
		{
			ICTouchAPI.popupServices.removePopup(this.objPopupConfirmSave);
			this.objPopupConfirmSave = null;
		}
	},


	showRebootRequired: function(callbackDone) {
		// reboot required popup
		var context = this;
		var strContent = _("Reboot is required. Reboot now ?", "webapp.settings");
		var popupDel = {
			strTitle: _("Reboot required", "webapp.settings"),
			strType: "warning",
			"strContent": strContent,
			arrPopupButtons: [
			{
				strButtonName: context.data.YES_BTN,
				strButtonIcon: "generic-ok",
				strButtonLabel: _("Yes", "ICTouchAPI"),
				callback : function(){
					context.lockPopupRebootRequired();
					webapp.settings.quitSettingsWebapp();
				}
				},

				{
				strButtonName: context.data.NO_BTN,
				strButtonIcon: "generic-cancel",
				strButtonLabel: _("No", "ICTouchAPI"),
				callback : function(){
					context.closePopupRebootRequired();
				}
				}
			]
			};
		this.objPopupRebootRequired = ICTouchAPI.popupServices.addNewPopup(popupDel, "MEDIUM");
	},

	closePopupRebootRequired: function() {
		if (this.objPopupRebootRequired !== null) {
			ICTouchAPI.popupServices.removePopup(this.objPopupRebootRequired);
			this.objPopupRebootRequired = null;
		}
	},

	lockPopupRebootRequired: function() {
		if (this.objPopupRebootRequired !== null) {
			for (var i in this.objPopupRebootRequired.arrPopupButtons) {
				this.objPopupRebootRequired.arrPopupButtons[i].greyTint();
			}
		}
	},

	goToLevelOne: function() {
		var data = this.data;
		data.intViewLevel = data.VIEW_LEVEL_1;
		//Remove this function call to avoid double entry for each setting details
		//data.loadDetails(data.intCurrentCategory);
	},

	updateActionBar: function() {
		var intValue = this.data.intViewLevel;
		//        var appBar = ICTouchAPI.AppBarServices.getAppBar("settings", "getSettings" + intValue);
		//        appBar.updateAppBar();

		//ICTouchAPI.AppBarServices.updateAppBar("settings", "getSettings" + intValue);
		ICTouchAPI.AppBarServices.setAppBar("settings", "getSettings"+intValue, "getSettings");
	},

	/*
	 * Return the String value from an object setting
	 */
	getSettingTextualValue: function(objSetting) {
		if (objSetting.isUndefined === 0) {
			switch (objSetting.typeData.name) {
                                case ICTouchAPI.settingServices.TYPE_ENABLER:
				case ICTouchAPI.settingServices.TYPE_BOOLEAN:
					if (objSetting.jsValue !== undefined){
						return (objSetting.jsValue) ? _(objSetting.typeData.params.name2, "webapp.settings") : _(objSetting.typeData.params.name1, "webapp.settings");
                    }
                    break;
				case ICTouchAPI.settingServices.TYPE_CHOICE:
					if (objSetting.jsValue >= 0){
						return _(objSetting.allowedValues[objSetting.jsValue].name, "webapp.settings");
                    }
					break;
				case ICTouchAPI.settingServices.TYPE_PASSWORD:
					return objSetting.value;//CRI : crms00260967
					//break;
				case ICTouchAPI.settingServices.TYPE_DATE:
                                        // OK we should use the current locale, but for now the dictionnaries don't
                                        // have these dateFormat and timeFormat values...
                                        // and I don't know how this objSetting  will really de used!!
					return objSetting.jsValue.format('M/d/yy', 'en');
				        //
					// WAS return dojo.date.locale.format(objSetting.jsValue, {
					//	selector: "date"
					//});
					//break;
				case ICTouchAPI.settingServices.TYPE_DATETIME:
                                        return objSetting.jsValue.format('M/d/yy h:mm a', 'en');
					// WAS: return dojo.date.locale.format(objSetting.jsValue);
					//break;
				case ICTouchAPI.settingServices.TYPE_LIST:
					return _(objSetting.value, "webapp.settings");
					//break;
				case ICTouchAPI.settingServices.TYPE_TIME:
					var tabHour = objSetting.jsValue.split(":");
					if( !webapp.settings.data._24hformat ) {
						var hour = parseInt(tabHour[0],10);
						var moment = _("am", "ICTouchAPI");
						if (hour>=12){
							hour -=12;
							moment = _("pm", "ICTouchAPI");
						}
						if (hour === 0){
                            hour = 12;
                        }
						if (hour <10) {
                            hour = "0"+hour;
                        }
						return hour+":"+tabHour[1]+" "+moment;
					}
					return  tabHour[0]+":"+tabHour[1];

					//break;
				case ICTouchAPI.settingServices.TYPE_PHONE:
				case ICTouchAPI.settingServices.TYPE_IPPORT:
				case ICTouchAPI.settingServices.TYPE_FLOAT:
				case ICTouchAPI.settingServices.TYPE_NUMERIC:
					return objSetting.value.toString();
					//break;
				default:
					return objSetting.jsValue;
			}
		}
		return "";
	},

	setInput : function(objUI){
		webapp.settings.data.objCurrentSetting=objUI.associatedSetting;
		webapp.settings.data.objSettingUI=objUI;
	},

	/*
	 * Return the value from an object setting
	 */
	 //build a generic UI matching the setting passed to the function
	getSettingUI : function(objSetting) {
		var objUI = "UNDEFINED";

		// If the setting was overridden, consider it as type "OTHER"
		if (this.data.arrOverriddenSettings[objSetting.id] && !this.data.arrOverriddeException[objSetting.id]) {
			objUI = objSetting.jsValue;
		}
		else {
			switch (objSetting.typeData.name) {
                                case ICTouchAPI.settingServices.TYPE_ENABLER:
				case ICTouchAPI.settingServices.TYPE_BOOLEAN:
					var items;
					if (objSetting.typeData.params.name2 == "true" && objSetting.typeData.params.name1 == "false") {
						items = [_("yes","ICTouchAPI"), _("no","ICTouchAPI")];
					}
					else {
						items = [_(objSetting.typeData.params.name2,"webapp.settings"), _(objSetting.typeData.params.name1,"webapp.settings")];
					}
					objUI = new UIElements.OptionChooser.OptionChooserControl({
						arrItems: items,
						intIndex : objSetting.jsValue?0:1,
						funcCallback : dojo.hitch(this, this.settingChanged, objSetting),
						intOptionWidth: 110
					});
					break;

				case ICTouchAPI.settingServices.TYPE_PASSWORD:
					objUI = new UIElements.InputField.InputFieldControl({
						keyboardType: ICTouchAPI.KeyboardTypes.PASSWORD,
                                                boolPassword: true,
						strInputText: this.getSettingTextualValue(objSetting),//CRI : crms00260967
						strInputTitle : _(objSetting.label,"webapp.settings"),
						isMultiLines: false,
						funcCallback: dojo.hitch(this, this.settingChanged, objSetting),
						associatedSetting : objSetting,
						strEventId : "settings.InputFieldClicked." + objSetting.id
					});
					dojo.subscribe("settings.InputFieldClicked." + objSetting.id,this,this.setInput);
					break;

				case ICTouchAPI.settingServices.TYPE_TEXT:
				case ICTouchAPI.settingServices.TYPE_LIST:
					objUI = new UIElements.InputField.InputFieldControl({
						keyboardType: ICTouchAPI.KeyboardTypes.ALPHANUM,
						strInputText: this.getSettingTextualValue(objSetting),
						strInputTitle : _(objSetting.label,"webapp.settings"),
						isMultiLines: false,
						funcCallback: dojo.hitch(this, this.settingChanged, objSetting),
						associatedSetting : objSetting,
						strEventId : "settings.InputFieldClicked." + objSetting.id
					});
					dojo.subscribe("settings.InputFieldClicked." + objSetting.id,this,this.setInput);
					break;

				case ICTouchAPI.settingServices.TYPE_PHONE:
					objUI = new UIElements.InputField.InputFieldControl({
						keyboardType: ICTouchAPI.KeyboardTypes.NUM,
						strInputText: this.getSettingTextualValue(objSetting),
						strInputTitle : _(objSetting.label,"webapp.settings"),
						isMultiLines: false,
						funcCallback: dojo.hitch(this, this.settingChanged, objSetting),
						associatedSetting : objSetting,
						strEventId : "settings.InputFieldClicked." + objSetting.id
					});
					dojo.subscribe("settings.InputFieldClicked." + objSetting.id,this,this.setInput);
					break;




				case ICTouchAPI.settingServices.TYPE_FLOAT:
				case ICTouchAPI.settingServices.TYPE_IPPORT:
				case ICTouchAPI.settingServices.TYPE_IPADDRESS:
					objUI = new UIElements.InputField.InputFieldControl({
						keyboardType: ICTouchAPI.KeyboardTypes.ALPHANUM,
						strInputText: this.getSettingTextualValue(objSetting),
						strInputTitle : _(objSetting.label,"webapp.settings"),
						isMultiLines: false,
						funcCallback: dojo.hitch(this, this.settingChanged, objSetting),
						numLockKeyboard : 1,
						associatedSetting : objSetting,
						strEventId : "settings.InputFieldClicked." + objSetting.id
					});
					dojo.subscribe("settings.InputFieldClicked." + objSetting.id,this,this.setInput);
					break;
				case ICTouchAPI.settingServices.TYPE_IPDOMAIN:
					objUI = new UIElements.InputField.InputFieldControl({
						keyboardType: ICTouchAPI.KeyboardTypes.ALPHANUM,
						strInputText: this.getSettingTextualValue(objSetting),
						strInputTitle : _(objSetting.label,"webapp.settings"),
						isMultiLines: false,
						funcCallback: dojo.hitch(this, this.settingChanged, objSetting),
						numLockKeyboard : 0,
						associatedSetting : objSetting,
						strEventId : "settings.InputFieldClicked." + objSetting.id
					});
					dojo.subscribe("settings.InputFieldClicked." + objSetting.id,this,this.setInput);
					break;

				case ICTouchAPI.settingServices.TYPE_CHOICE:
				case ICTouchAPI.settingServices.TYPE_DATE :
				case ICTouchAPI.settingServices.TYPE_DATETIME :
				case ICTouchAPI.settingServices.TYPE_TIME :
					objUI = objSetting.jsValue;
					break;
				case ICTouchAPI.settingServices.TYPE_NUMERIC:
					objUI = new UIElements.InputField.InputFieldControl({
						keyboardType: ICTouchAPI.KeyboardTypes.NUM,
						strInputText: this.getSettingTextualValue(objSetting),
						strInputTitle : _(objSetting.label,"webapp.settings"),
						isMultiLines: false,
						funcCallback: dojo.hitch(this, this.settingChanged, objSetting),
						associatedSetting : objSetting,
						strEventId : "settings.InputFieldClicked." + objSetting.id
					});
					dojo.subscribe("settings.InputFieldClicked." + objSetting.id,this,this.setInput);
					break;
				case ICTouchAPI.settingServices.TYPE_WEBAPP :
					objUI = objSetting.jsValue;
					break;
				default:
					objUI = objSetting.jsValue;
					break;
			}
		}
		return objUI;
	},
	getSettingUIType : function(objSetting) {
		var type = this._UI_TYPE_OTHER;
		// If the setting was overridden, consider it as type "OTHER"
		if (this.data.arrOverriddenSettings[objSetting.id] && !this.data.arrOverriddeException[objSetting.id]) {
			return type;
		}
		switch (objSetting.typeData.name) {
                        case ICTouchAPI.settingServices.TYPE_ENABLER:
			case ICTouchAPI.settingServices.TYPE_BOOLEAN:
			case ICTouchAPI.settingServices.TYPE_PASSWORD:
			case ICTouchAPI.settingServices.TYPE_TEXT:
			case ICTouchAPI.settingServices.TYPE_LIST:
			case ICTouchAPI.settingServices.TYPE_PHONE:
			case ICTouchAPI.settingServices.TYPE_FLOAT:
			case ICTouchAPI.settingServices.TYPE_IPPORT:
			case ICTouchAPI.settingServices.TYPE_IPADDRESS:
			case ICTouchAPI.settingServices.TYPE_IPDOMAIN:
				type = this._UI_TYPE_EMBED;
				break;
			case ICTouchAPI.settingServices.TYPE_CHOICE:
			case ICTouchAPI.settingServices.TYPE_DATE :
			case ICTouchAPI.settingServices.TYPE_DATETIME :
			case ICTouchAPI.settingServices.TYPE_TIME :
				type = this._UI_TYPE_TOASTER;
				break;
			case ICTouchAPI.settingServices.TYPE_NUMERIC:
					type = this._UI_TYPE_EMBED;
				break;
			case ICTouchAPI.settingServices.TYPE_WEBAPP :
				type = this._UI_TYPE_WEBAPP;
				break;
			default:
				type = this._UI_TYPE_OTHER;
				break;
		}
		return type;
	},

	getToaster : function(objSetting) {
		var objUi = null;
		switch (objSetting.typeData.name) {
			case ICTouchAPI.settingServices.TYPE_CHOICE:
				objUi = this.getUiChoiceToaster(objSetting);
				break;
			case ICTouchAPI.settingServices.TYPE_TIME:
				objUi = this.getUiTimeToaster(objSetting);
				break;
			case ICTouchAPI.settingServices.TYPE_DATE:
				objUi = this.getUiDateToaster(objSetting);
				break;
			case ICTouchAPI.settingServices.TYPE_DATETIME:
				objUi = this.getUiDateTimeToaster(objSetting);
				break;
		}

		/*
		if (!this.toasterUI)
			this.toasterUI = new webapp.settings.getSettingsToaster({},null);
		if (this.toasterUI.isActived())
			ICTouchAPI.toasterServices.hideContent(this.toasterUI);
		this.toasterUI.active();
		this.toasterUI.setElement(objUi);
		*/
		this.toasterUI = ICTouchAPI.toasterServices.showDialogBox(objUi, {
			strTitle: _(objSetting.label, "webapp.settings"),
			funcOk: dojo.hitch(this, this.getToasterValidated),
			funcCancel: dojo.hitch(this, this.getToasterCanceled),
			onHide: dojo.hitch(this, this.toggleWebappVisibility, true)
		});
	},


	getUiChoiceToaster : function(objSetting) {

 		var objUi = null;

 		var func = dojo.hitch(webapp.settings, webapp.settings.onChoiceClicked);
 		var _arrChoice = new Array();
		if(objSetting.action && objSetting.action.preview){
			var strPreviewIcon = "generic-search";
			var actionFunc = dojo.hitch(ICTouchAPI.settingServices, ICTouchAPI.settingServices.callMethodForAction)
			if (objSetting.allowedValues[0]){
				var link = objSetting.allowedValues[0].id;
				if (link.indexOf(".mp3") !== -1 || link.indexOf(".wav") !== -1 || link.indexOf(".ogg") !== -1){
					strPreviewIcon = "filesmanager-play";
				}
			}
			for (var i = 0; i <  objSetting.allowedValues.length; i++) {
				_arrChoice.push({
					intIndex: i,
					strLabel: _(objSetting.allowedValues[i].name,"webapp.settings"),
					boolSelected: (objSetting.jsValue == i),
					strActionIcon : strPreviewIcon
				});
			}
			objUi = new UIElements.SelectList.SelectListControl({
				arrItems: _arrChoice,
				intContainerSize: 6,
				itemCallback: func,
				buttonCallback : actionFunc,
				buttonCallbackParams : {
					action : objSetting.action.preview
				}
			});
		}
		else{
			for (var i = 0; i <  objSetting.allowedValues.length; i++) {
				_arrChoice.push({
					intIndex: i,
					strLabel: _(objSetting.allowedValues[i].name,"webapp.settings"),
					boolSelected: (objSetting.jsValue == i)
				});
			}
			objUi = new UIElements.SelectList.SelectListControl({
 			arrItems: _arrChoice,
 			intContainerSize: 6,
 			itemCallback: func
 		});
		}
		// Starting at 6 elements the toaster takes the whole screen
		if (objSetting.allowedValues.length >= 6) {
			// Don't hide now or the user will see the screen disappear
			var context = this;
			setTimeout(function(){
				context.toggleWebappVisibility(false);
			}, 1000);
		}
		//listUiForTest = objUi;
		return objUi;
 	},

	getUiTimeToaster : function(objSetting) {
		// Jerome TODO: remplacer ce truc par un TimeSelect
		var objUi = null;
		var tabHour = objSetting.value.split(":");
		var valueHour = tabHour[0];
		var momentDay = null;
		var valueMinute = tabHour[1];
		var is24hourFormat = webapp.settings.data._24hformat;
		objUi = new UIElements.ValueSelect.TimeSelect({
			intHourValue: valueHour,
			intMinuteValue: valueMinute,
			is24hourFormat : is24hourFormat,
			momentDay : momentDay,
			strFormat: "%02d",
			strName : this._UI_SELECT_MINUTE
		});
		return objUi;
	},

	getUiDateToaster : function(objSetting) {
		var arrCalendarPlannedEvents = [];
		/*
                 var strKeyDate = dojo.date.locale.format(objSetting.jsValue, {
			datePattern:"yyyy-MM-dd",
			selector:"date"
		});
                */
               var strKeyDate = objSetting.jsValue.format("yyyy-MM-dd", dojo.locale);
		arrCalendarPlannedEvents[strKeyDate] = true;
		var view = new webapp.settings.getSettingsDateContent(
		{
			arrCalendarPlannedEvents : arrCalendarPlannedEvents,
			boolDate: true
		},null);
		return view;
	},

	getUiDateTimeToaster : function(objSetting) {
		var arrCalendarPlannedEvents = [];
                var strKeyDate = objSetting.jsValue.format("yyyy-MM-dd", dojo.locale);

		arrCalendarPlannedEvents[strKeyDate] = true;
		/*cal = new UIElements.Calendar.CalendarControl({
				strCalendarType: "medium",
				arrPlannedEvents : arrCalendarPlannedEvents,
				})
		arrUi.unshift(cal);*/
		var view = new webapp.settings.getSettingsDateContent({
			arrCalendarPlannedEvents : arrCalendarPlannedEvents,
			boolDate: true,
			boolTime: true,
			intHour : objSetting.jsValue.getHours(),
			intMinute :objSetting.jsValue.getMinutes()
		}, null);
		return view;
	},

	getUiNumericToaster : function(objSetting) {
		var objUi = null;

		objUi = new UIElements.InputField.InputFieldControl({
			keyboardType: ICTouchAPI.KeyboardTypes.NUM,
			strInputText: this.getSettingTextualValue(objSetting),
			isMultiLines: false,
			funcCallback: dojo.hitch(this, this.settingChanged, objSetting)
		});
		return objUi;
	},

	getToasterCanceled : function() {
		this.toggleWebappVisibility(true);
		if(this.data.objCurrentSetting && this.data.objCurrentSetting.action && this.data.objCurrentSetting.action.exit_preview && this.data.objCurrentSetting.typeData.name == ICTouchAPI.settingServices.TYPE_CHOICE){
			ICTouchAPI.settingServices.callMethodForAction(null, {
				action:this.data.objCurrentSetting.action.exit_preview
			})
		}
		ICTouchAPI.toasterServices.destroyContent(this.toasterUI);
		this.toasterUI.destroy();
		this.toasterUI = null;
	},

	getToasterValidated : function(){
		this.toggleWebappVisibility(true);
		var objSetting = this.data.objCurrentSetting;
		var arrUiSetting = [this.toasterUI.getContent()];
		switch (objSetting.typeData.name) {
			case ICTouchAPI.settingServices.TYPE_CHOICE:
				this.getChoiceToasterValidated(arrUiSetting);
				break;
			case ICTouchAPI.settingServices.TYPE_TIME:
				this.getTimeToasterValidated(arrUiSetting);
				break;
			case ICTouchAPI.settingServices.TYPE_DATE:
				this.getDateToasterValidated(arrUiSetting);
				break;
			case ICTouchAPI.settingServices.TYPE_DATETIME:
				this.getDateTimeToasterValidated(arrUiSetting);
				break;
			/*case ICTouchAPI.settingServices.TYPE_NUMERIC:
				this.getNumericToasterValidated(arrUiSetting);
				break;*/
		}
		ICTouchAPI.toasterServices.destroyContent(this.toasterUI);
		this.toasterUI = null;
	},

	getChoiceToasterValidated : function(arrUiSetting) {
		var objSetting = this.data.objCurrentSetting;
		var func = dojo.hitch(this, this.goToLevelOne);
		var value = arrUiSetting[0].getSelected()[0];
		if(objSetting && objSetting.action && objSetting.action.exit_preview){
			ICTouchAPI.settingServices.callMethodForAction(value, {
				action:objSetting.action.exit_preview
			})
		}

		ICTouchAPI.settingServices.setSettingValue(objSetting.id, value, this, this.settingSaved, func);
	},

	getTimeToasterValidated : function(arrUiSetting) {
		var objSetting = this.data.objCurrentSetting;
		var func = dojo.hitch(this, this.goToLevelOne);
		var setting = arrUiSetting[0].getValue();
		// Format it for SettingManager or else it fails
		var value = dojox.string.sprintf("%02d:%02d:00", setting[0], setting[1]);
		ICTouchAPI.settingServices.setSettingValue(objSetting.id, value, this, this.settingSaved, func);
	},

	getDateToasterValidated : function(arrUiSetting) {
		var func = dojo.hitch(this, this.goToLevelOne);
		var objSetting = this.data.objCurrentSetting;
		var value = arrUiSetting[0].getValue()[0];
		ICTouchAPI.settingServices.setSettingValue(objSetting.id, value, this, this.settingSaved, func);
	},

	getDateTimeToasterValidated : function(arrUiSetting) {
		// TODO Jerome: a remplacer par un Time
		var func = dojo.hitch(this, this.goToLevelOne);
		var objSetting = this.data.objCurrentSetting;
		var arr_value = arrUiSetting[0].getValue();
		var value = arr_value[0];
		var hour = arr_value[1];
		if (arr_value[3] == "PM")
		{
			if (hour === 12 || hour === 0){
                hour-=12;
            }


			hour +=12;
		}
		value.setHours(hour);
		value.setMinutes(arr_value[2]);
		ICTouchAPI.settingServices.setSettingValue(objSetting.id, value, this, this.settingSaved, func);
	},

	/*getNumericToasterValidated : function(arrUiSetting) {
		var func = dojo.hitch(this, this.goToLevelOne);
		var objSetting = this.data.objCurrentSetting;
		var value = arrUiSetting[0].getValue();
		if (value < objSetting.typeData.params.min || value > objSetting.typeData.params.max){
			this.rollBack();
			this.getErrorPopup();
			return;
		}
		ICTouchAPI.settingServices.setSettingValue(objSetting.id, value, this, this.settingSaved, func);
	},*/

	/*
	  * This function is a callbakc when a setting is changed
	  */
	settingChanged : function(objSetting, value) {
		if(this.data.arrOverriddenSettings[objSetting.id] && this.data.arrOverriddeException[objSetting.id]){
			this.data.callOverridden(objSetting, value);
		}else{

		var func = dojo.hitch(this, this.goToLevelOne);
		switch (objSetting.typeData.name) {
			//Settin with boolean value
                        case ICTouchAPI.settingServices.TYPE_ENABLER:
			case ICTouchAPI.settingServices.TYPE_BOOLEAN:
				if (value == 0){
					ICTouchAPI.settingServices.setSettingValue(objSetting.id, true, this, this.settingSaved, func);
                }
                else{
					ICTouchAPI.settingServices.setSettingValue(objSetting.id, false, this, this.settingSaved, func);
                }
                break;

			//setting with text or password value
			case ICTouchAPI.settingServices.TYPE_PASSWORD:
			case ICTouchAPI.settingServices.TYPE_TEXT:
				if (objSetting.jsValue !== undefined)
				{
					ICTouchAPI.settingServices.setSettingValue(objSetting.id, value, this, this.settingSaved, func);
				}
				break;
			case ICTouchAPI.settingServices.TYPE_LIST:
				if (objSetting.jsValue !== undefined)
				{
					var arrValue = value.split(";");
					ICTouchAPI.settingServices.setSettingValue(objSetting.id, arrValue, this, this.settingSaved, func);
				}
				break;

			//Setting with phone number value
			case ICTouchAPI.settingServices.TYPE_PHONE:
				if (objSetting.jsValue !== undefined)
				{
					var val = parseInt(value,10);
					ICTouchAPI.settingServices.setSettingValue(objSetting.id, val, this, this.settingSaved, func);
				}
				break;

			//Setting with ip adress value
			case ICTouchAPI.settingServices.TYPE_IPADDRESS:
                var ip,i;
				if (objSetting.jsValue !== undefined)
				{
					ip = value.split(".");
					if (ip.length !== 4)
					{
						this.rollBack();
						this.getErrorPopup();
						return;
					}
					var upTo255 = false;
					for (i in ip)
					{
						if (parseInt(ip[i],10) > 255 || parseInt(ip[i],10) < 0){
							upTo255 = true;
						}
						if (ip[i] != parseInt(ip[i],10) && ip[i] != "00"+parseInt(ip[i],10) && ip[i] != "0"+parseInt(ip[i],10))
						{
							this.rollBack();
							this.getErrorPopup();
							return;
						}
					}
					if (upTo255){
						this.rollBack();
						this.getErrorPopup();
						return;
					}
					ICTouchAPI.settingServices.setSettingValue(objSetting.id, value, this, this.settingSaved, func);
				}
				break;
			case ICTouchAPI.settingServices.TYPE_IPDOMAIN:
				//alert(dojo.toJson(objSetting));
				if (objSetting.jsValue !== undefined)
				{
					var valid = false;
					ip = value.split(".");

					if(ip.length === 4){
						valid = true;
						var expInt = /^[0-9]+$/;
						for (i in ip)
						{
							if(expInt.exec(i) === null)
							{
								valid = false;
							}
							else if (parseInt(ip[i],10) > 255 || parseInt(ip[i],10) < 0){
								valid = false;
							}
							else if (ip[i] != parseInt(ip[i],10) && ip[i] != "00"+parseInt(ip[i],10) && ip[i] != "0"+parseInt(ip[i],10))
							{
								valid = false;
							}
						}
					}
                    var reg,n;
                    if(!valid){
						reg = /^([a-zA-Z][a-zA-Z0-9\-]+(\.|\-*\.))+[a-zA-Z]{2,6}$/;
						n = reg.exec(value);
						if(n !== null){
							valid = true;
                        }
					}
					if(!valid){
						reg = /^(([12][0-9]|[0-9]?)[0-9]\.){3}([12][0-9]|[0-9]?)[0-9]$/;
						n = reg.exec(value);
						if(n !== null){
							valid = true;
                        }
					}
					if(!valid){
 						reg = /^([a-zA-Z0-9\-]+\.)*[a-zA-Z0-9\-]+$/;
						n = reg.exec(value);
						if(n !== null){
							valid = true;
                        }
					}
					if(!valid){
						reg = /^([0-9A-Fa-f]{0,4}:){2,7}[0-9A-Fa-f]{0,4}$/;
						n = reg.exec(value);
						if(n !== null){
							valid = true;
                        }
					}
					if(!valid){
						if(valid == ""){
							valid = true;
						}
					}

					if(!valid){
						this.rollBack();
						this.getErrorPopup();
						return;
					}
					ICTouchAPI.settingServices.setSettingValue(objSetting.id, value, this, this.settingSaved, func);
				}
				break;
			case ICTouchAPI.settingServices.TYPE_FLOAT:
				if (objSetting.jsValue !== undefined)
				{
					if(value != parseFloat(value).toString())
					{
						this.rollBack();
						this.getErrorPopup();
						return;
					}
					ICTouchAPI.settingServices.setSettingValue(objSetting.id, value, this, this.settingSaved, func);
				}
				break;
			case ICTouchAPI.settingServices.TYPE_IPPORT:
				var intValue;
                if (objSetting.jsValue !== undefined)
				{
					intValue = parseInt(value,10);
					if(intValue > 65535 || intValue < 0  || value != intValue.toString())
					{
                                                /*webapp.settings.data.ERR_ALT_POPUP_LABEL = [
                                                    "ErrOutOfBound",
                                                    ""+0,
                                                    "and",
                                                    ""+65535];*/
                                                webapp.settings.data.buildErrorPopupLabelMinMax(0, 65535);
						this.rollBack();
						this.getErrorPopup();
						return;
					}
					ICTouchAPI.settingServices.setSettingValue(objSetting.id, intValue, this, this.settingSaved, func);
				}
				break;
			case ICTouchAPI.settingServices.TYPE_NUMERIC: //only if max value > 100 else it's a toaster
				if (objSetting.jsValue !== undefined)
				{
					intValue = parseInt(value,10);
					//alert(objSetting.typeData.params.max);
					if(value != intValue.toString() || intValue < objSetting.typeData.params.min || intValue > objSetting.typeData.params.max)
					{
                        webapp.settings.data.buildErrorPopupLabelMinMax(objSetting.typeData.params.min, objSetting.typeData.params.max);
						this.rollBack();
						this.getErrorPopup();
						return;
					}
					ICTouchAPI.settingServices.setSettingValue(objSetting.id, intValue, this, this.settingSaved, func);
				}
				break;
			default :
				break;
			}
		}
	},

	/*
	 *This function shows up a popup for an error while saving a setting's value
	 */
		getErrorPopup : function (message){
			var context = this;
			if (message){
				var strContent = _(message,"webapp.settings");
			}
			else{
				if(webapp.settings.data.ERR_ALT_POPUP_LABEL){
					strContent = _(webapp.settings.data.ERR_ALT_POPUP_LABEL,"webapp.settings");
				}else{
					strContent = _(webapp.settings.data.ERR_STD_POPUP_LABEL,"webapp.settings");
				}
			}
			var popupData = {
				strTitle: _("Settings error","webapp.settings"),
				strType: "error",
				strContent: strContent,
				arrPopupButtons: [
				{
					strButtonName: this.data.OK,
					strButtonLabel: _("Ok","ICTouchAPI"),
                                        strButtonIcon: "generic-ok",
					callback : function(){
						ICTouchAPI.popupServices.removePopup(context.objPopup);
					}
				}
				]
			};

			this.objPopup = ICTouchAPI.popupServices.addNewPopup(popupData, "MEDIUM");

			webapp.settings.data.ERR_ALT_POPUP_LABEL = "";
		},

		rollBack : function(){
			if(ICTouchAPI.settingServices.isDisplayedSequence(this.data.objCurrentSetting.id)) {
				return;
			}
			for(var i=0;i<this.data._arrDetails.length;i++){
				if(this.data._arrDetails[i].objSetting.id == this.data.objCurrentSetting.id){
					var detail = this.data._arrDetails[i];
					switch ( this.getSettingUIType(detail.objSetting)) {
						case this._UI_TYPE_EMBED:
							var declaredClass =  detail.objContent.declaredClass;
							if (declaredClass === "UIElements.OptionChooser.OptionChooserControl"){
								detail.objContent.setValue(this.data.objCurrentSetting.jsValue?0:1);
							}
							else if (declaredClass === "UIElements.InputField.InputFieldControl") {
								var value = this.getSettingTextualValue(this.data.objCurrentSetting);
								detail.objContent.setInputFieldContent(value, false, false);
							}
							break;
						case this._UI_TYPE_TOASTER :
							break;
						case this._UI_TYPE_WEBAPP:
							break;
						case this._UI_TYPE_OTHER :
							break;
						default:
							break;
					}
				}
			}
		},

		getSequenceErrorPopup : function() {
			var context = this;
			var msg = [];
			for(var i in this.data.objWrongSequence) {
				msg.push(this.data.objWrongSequence[i]);
				msg.push("<br>");
			}
			var popupData = {
				strTitle: _("Settings error","webapp.settings"),
				strType: "error",
				strContent: _(msg,"webapp.settings"),
				arrPopupButtons: [
				{
					strButtonLabel: _("Ok","ICTouchAPI"),
                                        strButtonIcon: "generic-ok",
					callback : function(){
						ICTouchAPI.popupServices.removePopup(context.objPopup);
					}
				}
				]
			};
			this.objPopup = ICTouchAPI.popupServices.addNewPopup(popupData, "MEDIUM");
		},

        /**
        *   Method called to show a warning popup when a wrong admin password has been submited
        */
        getWarningAdminPwdPopup : function(){
            var context = this;
		var strContent = _("WrongAdminPwd","webapp.settings");
		var popupData = {
			strTitle: _("Settings warning","webapp.settings"),
			strType: "warning",
			strContent: strContent,
			arrPopupButtons: [
			{
				strButtonName: "WARNING_ADM_BTN",
                                strButtonLabel: _("Ok","ICTouchAPI"),
                                strButtonIcon: "generic-ok",
				callback : function(){
					ICTouchAPI.popupServices.removePopup(context.objPopup);
				}
				}
			]
		};
                    this.objPopup = ICTouchAPI.popupServices.addNewPopup(popupData, "MEDIUM");

	},


	/*
	 * This function save the setting using settingServices
	 * Unvalidate the previously saved value
	 */
	saveSetting : function(newValue, callbackDone) {
		var data = webapp.settings.data;
		if(ICTouchAPI.settingServices.strMode === ICTouchAPI.settingServices.MODE_ADMIN){
			data.resetTimer();
		}
		var setting = this.data.objCurrentSetting;
		ICTouchAPI.settingServices.setSettingValue(setting.id, newValue, this, this.settingSaved, callbackDone);
	},

	getNewValue: function() {
		var newValue = "";
		if(this.data.objCurrentSetting!==null)
		{
			var setting = this.data.objCurrentSetting;

			switch (setting.typeData.name) {
                                case ICTouchAPI.settingServices.TYPE_ENABLER:
				case ICTouchAPI.settingServices.TYPE_BOOLEAN:
					newValue = (this.data.objSettingUI.getValue() === 1) ? true : false;
					break;
				case ICTouchAPI.settingServices.TYPE_CHOICE:
					newValue = this.data.intChoiceListSelected;
					break;
				case ICTouchAPI.settingServices.TYPE_NUMERIC:
					newValue = this.data.objSettingUI.intValue;
					break;
				case ICTouchAPI.settingServices.TYPE_TEXT:
					newValue = ICTouchAPI.keyboardServices.getValue();
					ICTouchAPI.keyboardServices.closeKeyboard(-1);
					break;
				case ICTouchAPI.settingServices.TYPE_PASSWORD:
					newValue = ICTouchAPI.keyboardServices.getValue();
					ICTouchAPI.keyboardServices.closeKeyboard(-1);
					break;
				case ICTouchAPI.settingServices.TYPE_FLOAT:
					newValue = ICTouchAPI.keyboardServices.getValue();
					ICTouchAPI.keyboardServices.closeKeyboard(-1);
					break;
				case ICTouchAPI.settingServices.TYPE_IPADDRESS:
					newValue = ICTouchAPI.keyboardServices.getValue();
					ICTouchAPI.keyboardServices.closeKeyboard(-1);
					break;
				case ICTouchAPI.settingServices.TYPE_IPDOMAIN:
					newValue = ICTouchAPI.keyboardServices.getValue();
					ICTouchAPI.keyboardServices.closeKeyboard(-1);
					break;
				case ICTouchAPI.settingServices.TYPE_IPPORT:
					newValue = ICTouchAPI.keyboardServices.getValue();
					ICTouchAPI.keyboardServices.closeKeyboard(-1);
					break;
				case ICTouchAPI.settingServices.TYPE_DATE:
					newValue = this.data.objSettingUI.attr("value");
					break;
				case ICTouchAPI.settingServices.TYPE_PHONE:
					newValue = ICTouchAPI.keyboardServices.getValue();
					ICTouchAPI.keyboardServices.closeKeyboard(-1);
					break;
			}
		}
		return newValue;
	},

	/*
	 * Callback when the settings has been saved or it has failed
	 * It show a popup when needed and switch the view to first level
	 */
	settingSaved : function(objUpdateReport, func) {
		//error : objUpdateReport has been viewed undefined
		// Invalidate current saved setting
		//this.data._arrDetails[intIndex] = undefined;
		//this.data._arrDetails = undefined;

		//GPY : TODO : If the update show an error, DO NOT call loadDetails the settings should not be
		//recalled .. else the SEQUENCE cannot be managed by the settingServices
		//in few words calling for settings from a category, redefine the "current user written setting" up to the last saved setting value
		//so if the UI is destroyed it's rebuild based on the last correctly saved value .. else the UI value will be stored within settingServices
		//and used to build the serializable value for a sequence ..

		if(!objUpdateReport){
		// alert('no objUpdateReport ');
		}else if(objUpdateReport.valid !== 1){
			// error popup
			this.rollBack();
			if(ICTouchAPI.settingServices.isDisplayedSequence(this.data.objCurrentSetting.id)) {
				//Save error message
				var strContent;
				if (objUpdateReport.message){
					strContent = objUpdateReport.message;
				}
				else{
					if(webapp.settings.data.ERR_ALT_POPUP_LABEL) {
						strContent = _(webapp.settings.data.ERR_ALT_POPUP_LABEL,"webapp.settings");
					}else{
						strContent = _(webapp.settings.data.ERR_STD_POPUP_LABEL,"webapp.settings");
					}
				}
				webapp.settings.data.ERR_ALT_POPUP_LABEL = "";
				var sequenceId = ICTouchAPI.settingServices.getDisplayedSequence(this.data.objCurrentSetting.id);
				this.data.objWrongSequence[sequenceId] = strContent;
			}
			else {
				this.getErrorPopup(objUpdateReport.message);
			}

		//alert('the setting has not been saved. TODO:change the UIElements color ! ');
		}else{
			//setting saved

			if (this.data.objCurrentSetting && this.data.objCurrentSetting.missing_mandatory)
			{
				this.data.objCurrentSetting.missing_mandatory = false;
				this.verifyMandatory(this.data.objCurrentSetting.mainCategory,this.data.objCurrentSetting.category);
			}
			if(ICTouchAPI.settingServices.isDisplayedSequence(this.data.objCurrentSetting.id)) {
				var sequenceId = ICTouchAPI.settingServices.getDisplayedSequence(this.data.objCurrentSetting.id);
				delete this.data.objWrongSequence[sequenceId];
			}

			// Get the new value and update it in arrDetails & associatedSetting in UIElement
			ICTouchAPI.settingServices.getSetting(this.data.objCurrentSetting.id, this.data, this.data.updateSetting, null);

			//reset object for confirmation popup not reappear endlessly
			this.data.objCurrentSetting = null;
		}

	},

	onChoiceClicked : function(intIndex) {
		this.data.intChoiceListSelected = intIndex;
	},

	/**
	 * Change ADMIN_BTN state and reload categories
	 */
	// NEW_SETTINGS
	switchAdminMode : function(boolAdmin) {
		var data = webapp.settings.data;
		//Reset error sequence
		data.objWrongSequence = {};
		if (!boolAdmin) {
			if(ICTouchAPI.settingServices.strMode === ICTouchAPI.settingServices.MODE_ADMIN)
			{
				// we have to logout, we come back after with the logout callback
				data.logout();
			}
			else
			{
				ICTouchAPI.settingServices.strMode = ICTouchAPI.settingServices.MODE_USER;
				data.loadList();
				data.clearDetails();
				// we have to set button to off
				this.switchAdminButton(boolAdmin);
			}
		}
		else {

                        webapp.settings.data.getAdminKeyBoard();

		}
	},

	/**
	 * Switch the button status text to the right status
	 */
	switchAdminButton : function(boolAdmin) {
		var data = webapp.settings.data;
		if (boolAdmin)
		{
			data.objAdminButtonUI.setStatusIcon('notif-on');
			data.objAdminButtonUI.statusEnabled = true;
		}
		else
		{
			data.objAdminButtonUI.setStatusIcon('notif-off');
			data.objAdminButtonUI.statusEnabled = false;
		}
	},

	onTimeFormatChanged: function(objSetting) {
        this.data._24hformat = objSetting.jsValue;
        //this.data.loadList();
	},

	onShowWebappEvent : function(args){
		ICTouchAPI.transitionServices.getScreen({
			name: "webapp.settings.getSettings",
			params: {}
		});
		var context = this;
		var strContent = "Some mandatory settings are undefined. Please define them.";
		var popupMandatory = {
			strTitle: "Mandatory settings",
			strContent: strContent,
			strType: "error",
			arrPopupButtons: [
			{
                            	strButtonName: "SETTING_UNDEF_BTN",
                                strButtonLabel: _("Ok","ICTouchAPI"),
                                strButtonIcon: "generic-ok",
				callback : function(){
					ICTouchAPI.popupServices.removePopup(context.objPopupMandatory);
				}
				}
			]
			};
		this.objPopupMandatory = ICTouchAPI.popupServices.addNewPopup(popupMandatory, "MEDIUM");

	},

	verifyMandatory : function(mainCategory) {
		var cats = this.data.getListEntries();
		var det = this.data.getDetails();
		var bMissing = false;
		for(var i in det)
		{
			if(det[i].objSetting.missing_mandatory)
			{
				bMissing = true;
				break;
			}
		}
		if (!bMissing)
		{
			this.categoriesListUI.toggleEmphasis(this.data.intCurrentCategory,false);
			cats[this.data.intCurrentCategory].boolEmphasis = false;
			bMissing = false;
			var main = cats[this.data.intCurrentCategory].indexMainCat;
			for(i in cats)
			{
				if(cats[i].indexMainCat == main && cats[i].boolEmphasis)
				{
					bMissing = true;
					break;
				}
			}
			if (!bMissing)
			{
				this.categoriesListUI.toggleEmphasis(main,false);
			}
		}
	},

	onMenuCollapse : function() {
		if(!this.data.checkSequenceError()) {
			this.data.clearDetails();
		}
	},



	//defining the callback function called when the menulist is clicked
	onMenuClick : function(value) {
		//we hide the toasters (keyboard, UIElements)
		ICTouchAPI.toasterServices.hideAll();
		if(this.data.checkSequenceError()) {
			this.getSequenceErrorPopup();
			var currentCategory = this.data.intCurrentCategory;
			webapp.settings.categoriesListUI.selectItemByIndex(currentCategory,false);
		}
		else {
			this.selectMenuEntry(value);
		}
	},

	selectMenuEntry : function(value) {
			webapp.settings.data.loadDetails(value);
	},


	//----------------------------------------- //
	//Specific functions to webapp integration  //
	//----------------------------------------- //

	resetActionBar : function(){
		//var backFunc = dojo.hitch( webapp.settings, webapp.settings.buttonCallback, this.data.BACK);
		var data = webapp.settings.data;

		// Register action bars according to state
		var actionBar2 = ICTouchAPI.AppBarServices.getAppBar("settings", "getSettings1");
		actionBar2.removeAllActionButtons();
		dojo.forEach(data.getActionBarAppButtons(data.VIEW_LEVEL_2), function(button) {
			var objButton = new UIElements.AppButton.AppButtonControl(button);
			actionBar2.addActionButton(objButton);
		});

		actionBar2.updateAppBar("settings", "getSettings1");

		// Register action bars according to state
		var actionBar = ICTouchAPI.AppBarServices.getAppBar("settings", "getSettings0");
		actionBar.removeAllActionButtons();
		dojo.forEach(data.getActionBarAppButtons(data.VIEW_LEVEL_1), function(button) {
			var objButton = new UIElements.AppButton.AppButtonControl(button);
			if (button.strButtonName === data.ADMIN){
				data.objAdminButtonUI = objButton;
            }
			actionBar.addActionButton(objButton);
		});

		actionBar.updateAppBar("settings","getSettings0");
		// author ludovic cadart
		// added code
		// when it is requested to transition services to display a widget, for instance settings.getSettings
		// the transitionServices is going to search the settings.getSettings action bar (always the same name as widget)
		// when a widget has several action bars, it has to inform actionBarServices which is current
		// thanks to the following method
		ICTouchAPI.AppBarServices.setAppBar("settings","getSettings0", "getSettings");
	},


	getActionBar : function() {
		var intValue = webapp.settings.data.intViewLevel;
		return ICTouchAPI.AppBarServices.getAppBar("settings", "getSettings" + intValue);
	},

	/**
	 * Callback when you click on a setting of type "CUSTOM[WEBAPP]"
	 * @params {object} objSetting : complete setting object
	 */
	getView : function(objSetting) {

		this.getViewFromName(objSetting.module, objSetting.label, objSetting.value);
	},

	/**
	 * Set a new view in the 2/3 of the webapp
	 * @params {string} webappName : name of the webapp (e.g. 'bluetooth')
	 * @params {string} title : title of the 2/3 container (without i18n, it's done here)
	 * @params {string} view : name of the view (e.g. 'webapp.bluetooth.getMyDevices')
	 */
	getViewFromName : function(webappName,title,view){
		this.resetActionBar();
		webapp.settings.data.webappView = true;
		var wa = ICTouchAPI.tools.getObjectReference("webapp."+webappName);

		// If it is not the first widget loaded, call the stopForView function with the former view
		if(wa && wa.data.stopForView && webapp.settings.data.currentWebappViewName!==  ""){
			wa.data.stopForView(webapp.settings.data.currentWebappViewName);
		}
		webapp.settings.data.currentWebappName = webappName;
		webapp.settings.data.currentWebappViewName = view;
		webapp.settings.thirdUI.setContainer("webapp.settings.getViewContainer",{
			title:_(title, "webapp."+webappName),
			content:view
		});

		if(wa && wa.data.initForView){ // Security to be sure the function exists in the other webapp
		wa.data.initForView(view);
		}

		var intValue = this.data.intViewLevel;
		var actionBar = ICTouchAPI.AppBarServices.getAppBar("settings", "getSettings" + intValue);

		if(wa.data.getActionBarAppButtonsFromView){ // Security to be sure the function exists in the other webapp
		dojo.forEach(wa.data.getActionBarAppButtonsFromView(view), function(button) {
			var objButton = new UIElements.AppButton.AppButtonControl(button);
			actionBar.addActionButton(objButton);
		});
		}

		ICTouchAPI.AppBarServices.updateAppBar("settings", "getSettings" + intValue);
		if(wa && wa.data.initForView){ // Security to be sure the function exists in the other webapp
			wa.data.initAppBarButtons(view);
		}
	},

	/**
	 * Called when we leave the 'webappView' mode to a normal setting display
	 */
	backToSettingView : function() {

		var wa = ICTouchAPI.tools.getObjectReference("webapp."+webapp.settings.data.currentWebappName);

		if(wa && wa.data.stopForView){
			wa.data.stopForView(webapp.settings.data.currentWebappViewName);
		}
		webapp.settings.data.currentWebappViewName = "";
		this.resetActionBar();
		webapp.settings.data.webappView = false;
		webapp.settings.thirdUI.setContainer("webapp.settings.getSettingsContainer",{});
		webapp.settings.detailsUI = webapp.settings.thirdUI.getContainer();
	},

	refreshWebappView : function() {
		if (this.webappViewUI){
			this.webappViewUI.refresh();
        }
	},
	onSettingChanged : function(objSetting){
		for(var i=0;i<this.data._arrDetails.length;i++){
			if(this.data._arrDetails[i].objSetting.id == objSetting.value.id){
				var detail = this.data._arrDetails[i];
				switch ( this.getSettingUIType(detail.objSetting)) {
					case this._UI_TYPE_EMBED:
						break;
					case this._UI_TYPE_TOASTER :
						if(detail.strContent != null && detail.strContent != undefined){
							if(objSetting.value.type == ICTouchAPI.settingServices.TYPE_CHOICE){
								this.settingsContainer.getContent().setItemTextContent(
									i,
									_(detail.objSetting.allowedValues[objSetting.value.jsValue].name, "webapp.settings")
									);
							}
							else{
								this.settingsContainer.getContent().setItemTextContent(i, objSetting.value.jsValue);
							}
						}
						break;
					case this._UI_TYPE_WEBAPP:
						break;
					case this._UI_TYPE_OTHER :
						break;
					default:
						break;
				}
				this.data._arrDetails[i].objSetting = objSetting.value;
				break;
			}
		}
	},

	toggleWebappVisibility: function(visible) {
		dojo.toggleClass(this.thirdUI.domNode, "setting_hidden", !visible);
	},

	unlock : function(){
		if (typeof this.toasterUI == "object" && this.toasterUI !== null) {
			ICTouchAPI.toasterServices.destroyContent(this.toasterUI);
			this.toasterUI = null;
		}
		this.toggleWebappVisibility(true);
		this.data.loadList();
		this.data.clearDetails();
		this.inherited(arguments);
	},

//--------------------------------------------- //
//End Specific functions to webapp integration  //
//--------------------------------------------- //

	//--------------------------------------------- //
	//Specific functions for settings action		//
	//--------------------------------------------- //

	ring_preview : function(args){
		var url = this.data.objCurrentSetting.allowedValues[args.params[0]].id;
		ICTouchAPI.APIServices.IctMPInterface.preview({
			params: [url]
		});
	},

	ring_stop_preview : function(args){
		ICTouchAPI.APIServices.IctMPInterface.stopPreview({});
	}

	//--------------------------------------------- //
	//End Specific functions for settings action	//
	//--------------------------------------------- //
});
