dojo.provide("webapp.instantmessaging.dataBase");
dojo.declare("webapp.instantmessaging.dataBase",null,{

	_imTitle : "Instant Messaging",
	_dateFormat		: "",
	_24hformat		: "",
	STATUS_HOME		: 0,
	arrWidgetsData : [],
	objCurrentContact : null,
	objContactBeforeSending : null,
	objConversation     : null,
	objCurrentConvID    : {id: -1, contactId : ""},
	imContentUI    : null,
    buddyContactId			: -1,
    messageMaxNumber        :15,
    cptMessage : 0,
	scrollTopValue			: 372,//the correct value by convention
    header : [],
    message :[],
    strDefaultPhotoPath : "",
	STATUS_NORMAL : 0,
	STATUS_LOG		: 2,

	WRITE_BTN   : "WRITE_BTN",
	CLOSE_BTN   : "CLOSE_BTN",
	ANSWER_BY_IM    : "ANSWER_BY_IM",
	IM              : "IM",
	ADD_TO_BUDDYLIST : "ADD_TO_BUDDYLIST",
	MODIFY_DISPLAY_NAME : "MODIFY_DISPLAY_NAME",
	REMOVE_FROM_BUDDYLIST : "REMOVE_FROM_BUDDYLIST",

	constructor : function(){
		dojo.subscribe("handleComExternalButtons", null, dojo.hitch(this, this.handleComExternalButtons));

		this.arrWidgetsData[this.STATUS_NORMAL] = {
			container: "webapp.instantmessaging.getImContent",
			buttons: [  ]
		};

		this._imTitle=_("Instant Messaging", "webapp.instantmessaging");


		ICTouchAPI.settingServices.getSetting("DateFormat", this, function(objSetting) {
			// save the setting
			if (objSetting != null) {
				this._dateFormat = objSetting.allowedValues[objSetting.jsValue].name;
			}
			// get another setting
			ICTouchAPI.settingServices.getSettingValue("TimeFormat", this, function(value) {
				// save the setting
				if (value != null) {
					this._24hformat = value;
				}
			});
		});
        this.strDefaultPhotoPath = "http://localhost/webapp/userinfo/themes/Default/images/default-user-photo.png";
        this.header=new Array(this.messageMaxNumber);
        this.message=new Array(this.messageMaxNumber);
        // Check if the webapp communication is already loaded before adding the buttons
		// "write " and "Close " to the webapp communication
		if (webapp.communication&&webapp.instantmessaging.boolIMAvailable&&ICTouchAPI.presenceServices.isImAvailable()) {
			this._addIMButtonsToCommunication();
		}
		// If the webapp communication is not loaded yet, subscribe to the event
		// "webapp.communication.loaded" emitted after the creation of the
		// communication view (posteCreate of getCommunicationBase)
		else {
			dojo.subscribe("webapp.communication.loaded", this, function() {
				this._addIMButtonsToCommunication();
			});
		}

	},

    _addIMButtonsToCommunication : function(){
        //webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_LOG, {strButtonName: this.WRITE_BTN, strButtonLabel:_("Write", "webapp.instantmessaging"), strButtonIcon: 'im-application', capabiltyName: "IMConnected", callback: {context: webapp.instantmessaging, func:webapp.instantmessaging.buttonCallback}});
		//webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_LOG, {strButtonName: this.CLOSE_BTN, strButtonLabel:_("Close", "webapp.instantmessaging"), strButtonIcon: 'im-stop', capabiltyName: "IMConnected", callback: {context: webapp.instantmessaging, func:webapp.instantmessaging.buttonCallback}});
		var answerByImBtn = {strButtonName: this.ANSWER_BY_IM, strButtonLabel:_("Send IM", "webapp.instantmessaging"), strButtonIcon: 'im-application', capabiltyName: null, callback: {context: webapp.instantmessaging, func:webapp.instantmessaging.buttonCallback}};
		webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_INCOMING, answerByImBtn);
		webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_HOLD, answerByImBtn);
		webapp.communication.addButtonForStatus(webapp.communication.data.STATUS_CALLS, answerByImBtn);
    },

	handleContactPresence : function(objContact, status){
		this.objCurrentContact=objContact;
		var appBar = ICTouchAPI.AppBarServices._getAppBarWidget("contacts", "contactsstatus"+status);
		var btnAddBuddy = appBar.getButton(this.ADD_TO_BUDDYLIST);
		var btnRemoveBuddy = appBar.getButton(this.REMOVE_FROM_BUDDYLIST);
		var btnModifyBuddy = appBar.getButton(this.MODIFY_DISPLAY_NAME);
		var btnIM = appBar.getButton(this.IM);
		if (objContact == null) {
			btnAddBuddy.hide();
			btnRemoveBuddy.hide();
			btnModifyBuddy.hide();
			if (btnIM) {
				btnIM.hide();
			}
		}
		else{
			ICTouchAPI.APIServices.InstantMessaging.getPresenceForContact({
				context : this,
				params: [objContact.contactId],
				callback: this.handleIMButtons
			});
		}
	},

	handleIMButtons: function(presenceList) {

		var appBar = ICTouchAPI.AppBarServices._getAppBarWidget("contacts", "contactsstatus"+this.STATUS_HOME);//this.HomeSTATUS de contact
		var btnAddBuddy = appBar.getButton(this.ADD_TO_BUDDYLIST);
		var btnRemoveBuddy = appBar.getButton(this.REMOVE_FROM_BUDDYLIST);
		var btnModifyName = appBar.getButton(this.MODIFY_DISPLAY_NAME);
		var btnIM = appBar.getButton(this.IM);
		if(ICTouchAPI.presenceServices.isImAvailable()){
		//if no presence
		if (!presenceList[0] || presenceList.length == 0) {
			dojo.publish("InBuddyList",[false]);
			//and a local contact
			if (!this.objCurrentContact.type == this.TYPE_UDA) {
				//and has coll ID
				if (this.objCurrentContact.collaborationId != "") {
					btnAddBuddy.show();
				}
				//or does not have coll ID
				else {
					btnAddBuddy.hide();
				}
			}
			//and distant contact
			else {
				// If it already has a collaborationId
				if (this.objCurrentContact.collaborationId != "") {
					btnAddBuddy.show();
				}
				// no collaborationId but a login Name
				else if (this.objCurrentContact.loginName != "") {
					ICTouchAPI.APIServices.InstantMessaging.getCollaborationId({
						context: this,
						params: [this.objCurrentContact.loginName]
					});
				}
				// does not have a loginName
				else {
					btnAddBuddy.hide();
				}
			}
			//in any case if it does not have a presence
			btnRemoveBuddy.hide();
			btnModifyName.hide();
			if (btnIM) {
				btnIM.hide();
			}
			this.photoPath = "";
		}
		//it has presence
		else {
			dojo.publish("InBuddyList",[true]);
			this.photoPath = ICTouchAPI.tools.getPresenceIconPath(presenceList[0].imPresenceValue.value.labelStatus, "24");
			//and has coll ID
			if (this.objCurrentContact.collaborationId != "") {
				btnAddBuddy.hide();
				btnRemoveBuddy.show();
				btnModifyName.show();
				if (btnIM&&webapp.instantmessaging.boolIMAvailable&&ICTouchAPI.presenceServices.isImAvailable()) {
					btnIM.show();
				}
				this.currentContactDisplayName = presenceList[0].displayName;
			}
			//or does not have a coll ID
			else {
				ICTouchAPI.APIServices.InstantMessaging.getCollaborationId({
						context: this,
						params: [this.objCurrentContact.loginName]
					});
				btnAddBuddy.hide();
				btnRemoveBuddy.hide();
				btnModifyName.hide();
				if (btnIM) {
					btnIM.hide();
				}
			}
		}
		}
		else{
			btnAddBuddy.hide();
			btnRemoveBuddy.hide();
			btnModifyName.hide();
			if (btnIM) {
				btnIM.hide();
			}
		}

	},

	getImTitle : function ()
	{
		return this._imTitle;
	},

	//hide or show the buttons from Communication webapp's appbar
	handleComExternalButtons: function(type) {
		var appBar = ICTouchAPI.AppBarServices._getAppBarWidget("communication", "comstatus"+this.STATUS_LOG);
		var btnWrite = appBar.getButton(this.WRITE_BTN);
		var btnClose = appBar.getButton(this.CLOSE_BTN);
		
		//if the type is IM then show the butons
		if (btnWrite && btnClose) {
			if (type == 4&&webapp.instantmessaging.boolIMAvailable&&ICTouchAPI.presenceServices.isImAvailable()) {
				btnWrite.show();
				btnClose.show();
			}
			else {
				btnWrite.hide();
				btnClose.hide();
			}
		}
	}


});
