dojo.provide("webapp.instantmessaging.controlBase");
dojo.declare("webapp.instantmessaging.controlBase", ICTouchAPI.webApplication,
{
	currentStatus			: 0,
	container				: null,
	domNode					: null,
	warningPopup			: null,
	errorPopup				: null,
	boolIMAvailable			:true,
	// Widgets
	mainWidget				: null,
	idType					: 4,

	constructor : function() {
		ICTouchAPI.settingServices.subscribeToSetting(this, "IMAvailable", this.onIMActivated);
		ICTouchAPI.settingServices.getSetting("IMAvailable",this,this.onIMActivated);
		//ICTouchAPI.skinServices.linkWebappsStyles("webapp.communication", "webapp.instantmessaging", true);
        //ICTouchAPI.skinServices.linkWebappsStyles("webapp.instantmessaging", "webapp.instantmessaging", true, true, true);//Load icons in middle iframe
		ICTouchAPI.eventServices.subscribeToEvent(this, "IM_RECEIVED", this.onImReceived);
		ICTouchAPI.eventServices.subscribeToEvent(this, "IM_CONVERSATION_READ", this.onConversationRead);
		ICTouchAPI.eventServices.subscribeToEvent(this, "IM_CONVERSATION_DELETED", this.onConversationDeleted);

		ICTouchAPI.eventServices.subscribeToEvent(this, "IM_ERROR_NTF", this.onErrorNTF);

		ICTouchAPI.eventServices.subscribeToEvent(this, "IM_CONVERSATION_CLOSED", this.onConversationClosed);

		dojo.subscribe("ComlogExternalTypeClicked"+this.idType, null, dojo.hitch(this, this.handlerFunc));
		dojo.subscribe("ManageExternalButtonsCom", this, this.onManageButtonsEvent);
	},

	loaded : function () {
		dojo.subscribe("ManageExternalButtonsContact", this.data, this.data.handleContactPresence);
	},

	onIMActivated : function(objSetting){
		if(objSetting){
			if(objSetting.jsValue==true){
				this.boolIMAvailable=true;
//				ICTouchAPI.tools.registerHomepageButton(["webapp.instantmessaging", "IM_BTN", "im-application", _('Chat', 'webapp.instantmessaging'), undefined, dojo.hitch(webapp.instantmessaging, this.onCreation)]);
//                                ICTouchAPI.tools.registerHomepageKey(["webapp.instantmessaging", "IM_BTN", "im-application", _('Chat', 'webapp.instantmessaging'), undefined, dojo.hitch(webapp.instantmessaging, this.onCreation)]);
			}
			else{
				this.boolIMAvailable=false;
			}
		}
	},

	onConversationClosed : function (idConv)
	{
	},
	//hide the button btnAnswerIM if there is no real contact
	onManageButtonsEvent: function(objContact, strStatus) {
		var numStatus = webapp.communication.data.getNumAppBarFromStatus(strStatus);
		var appBar = ICTouchAPI.AppBarServices._getAppBarWidget("communication", "comstatus"+numStatus);
        var btnAnswerIM = appBar.getButton(this.data.ANSWER_BY_IM);
		if (btnAnswerIM) {
			if (objContact && objContact.contactId && objContact.contactId != -1 && numStatus==webapp.communication.data.STATUS_INCOMING) {
				btnAnswerIM.show();
                webapp.instantmessaging.data.objCurrentContact = objContact;
			}
			else {
				btnAnswerIM.hide();
			}
		}
	},

	onErrorNTF : function (errorId)
	{
		var strMessage = "";
		switch(errorId) {
			case 1:strMessage = _("Cannot send IM (SIPUA Error)", "webapp.instantmessaging");
				break;
			case 2:strMessage = _("Cannot set presence (SIPUA Error)", "webapp.instantmessaging");
				break;
			case 3:strMessage = _("Cannot close conversation. It does not appear to be openned", "webapp.instantmessaging");
				break;
			case 4:strMessage = _("Cannot close conversation (SIPUA Error)", "webapp.instantmessaging");
				break;
			case 5:strMessage = _("Cannot open conversation (SIPUA Error)", "webapp.instantmessaging");
				break;
			case 6:strMessage = _("Cannot remove Buddy from list", "webapp.instantmessaging");
				break;
			case 7:strMessage = _("Cannot modify Buddy", "webapp.instantmessaging");
				break;
			case 8:strMessage = _("Cannot add Buddy to list", "webapp.instantmessaging");
				break;
		}

		if (strMessage != "") {
			ICTouchAPI.popupServices.errorPopup(_("Error", "ICTouchAPI"), strMessage, _("OK", "ICTouchAPI"), errorId)
		}
	},

	addBuddyOk : function(strContent){
		ICTouchAPI.APIServices.InstantMessaging.addContactInBuddyList({
			context: webapp.instantmessaging,//this ?
			params: [webapp.instantmessaging.data.objCurrentContact.collaborationId, webapp.instantmessaging.data.objCurrentContact.contactId, strContent]
		});
	},

	modifyBuddyOk : function(strContent){
			ICTouchAPI.APIServices.InstantMessaging.modifyContactfromBuddyList({
			context: webapp.contacts,
			params: [webapp.contacts.data.objCurrentContact.contactId,strContent]
		});

	},


	buttonCallback : function(buttonId) {
		var data = webapp.instantmessaging.data;
		switch(buttonId)
		{
			case data.WRITE_BTN:
				if(webapp.communication){
					// Copy the contact you want to send to
					webapp.instantmessaging.data.objCurrentContact = dojo.clone(webapp.communication.data.getCurrentContact());
					if(webapp.instantmessaging.data.objCurrentContact.contactId==-1){
						var phoneNumber=webapp.communication.data.getSelectedEntry().objLogData.listContactSummary[0].officePhone;
						var contactId=webapp.communication.data.getSelectedEntry().objLogData.contactId;
						if(phoneNumber==webapp.instantmessaging.data.objCurrentContact.officePhone){
							webapp.instantmessaging.data.objCurrentContact.contactId=contactId;
						}
						if(phoneNumber==webapp.instantmessaging.data.objCurrentContact.mobilePhone){
							webapp.instantmessaging.data.objCurrentContact.contactId=contactId;
						}
						if(phoneNumber==webapp.instantmessaging.data.objCurrentContact.homePhone){
							webapp.instantmessaging.data.objCurrentContact.contactId=contactId;
						}
					}
					webapp.instantmessaging.writeIm();
				}
				break;
			case data.CLOSE_BTN:
				if (data.objCurrentConvID.id != -1) {
					ICTouchAPI.APIServices.InstantMessaging.closeConversation({params :[data.objCurrentConvID.id], context: this});
				}

				break;
			case data.ANSWER_BY_IM:
				if(webapp.communication){
					var callId = webapp.communication.data.getSelectedEntryId();
					if (callId) {
						ICTouchAPI.APIServices.Telephony.ignoreCall({params: [callId], context: this});
				}
					this.prepareToSendIm(webapp.communication.data.objCurrentContact);
				}
				break;
			case data.IM:
				if(webapp.contacts){
					this.prepareToSendIm(webapp.contacts.data.objCurrentContact);
				}
				break;
			case this.data.ADD_TO_BUDDYLIST:
				if(webapp.contacts){
					webapp.instantmessaging.data.objCurrentContact = dojo.clone(webapp.contacts.data.objCurrentContact);
					ICTouchAPI.keyboardServices.deployKeyboard(ICTouchAPI.KeyboardTypes.ALPHANUM, null, {
						strDefaultText: "",
						funcCallbackOk : this.addBuddyOk
					});
				}
				break;
			case this.data.REMOVE_FROM_BUDDYLIST:
				if(webapp.contacts){
					this.data.objCurrentContact = dojo.clone(webapp.contacts.data.objCurrentContact);
					ICTouchAPI.APIServices.InstantMessaging.removeContactFromBuddyList({
						context: this,
						params: [this.data.objCurrentContact.contactId]
					});
				}
				break;
			case this.data.MODIFY_DISPLAY_NAME:
				if(webapp.contacts){
					this.data.objCurrentContact = dojo.clone(webapp.contacts.data.objCurrentContact);
					//open the keyboard and change the display name of the contact
					ICTouchAPI.keyboardServices.deployKeyboard(ICTouchAPI.KeyboardTypes.ALPHANUM, null, {
						strDefaultText: this.data.objCurrentContact.DisplayName,
						funcCallbackOk : this.modifyBuddyOk
					});
				}
			break;
			default :
				console.warn("No callback is associated with this ID : " + buttonId);
				break;
		}
	},

	// Public function
	// Set all what is required to send an IM
	prepareToSendIm : function(objContact){
		// Copy the contact you want to send to
		this.data.objCurrentContact = dojo.clone(objContact);
		// Go in communication webapp
		this._callCommunicationWebapp();
		// Set an IM context (2/3, with title and content)
		this.container.reload({
			objTitle: {
				strLabel: _([ICTouchAPI.tools.getContactDisplayName(this.data.objCurrentContact),"-","Instant Messaging"], "webapp.instantmessaging")
			},
			objContent: {
				name: "webapp.instantmessaging.getImContent",
				params: {}
			}
		});
		// Show keyboard to send the IM message
		this.writeIm();
	},

	// Show keyboard with send IM as callback
	writeIm : function(){
		var func = dojo.hitch(webapp.instantmessaging, webapp.instantmessaging.handleSendIM);
		webapp.instantmessaging.data.objContactBeforeSending=webapp.instantmessaging.data.objCurrentContact;
		ICTouchAPI.keyboardServices.deployKeyboard(ICTouchAPI.KeyboardTypes.EMOTICON, null, {
			funcCallbackOk : func,
			multiline	    : true,
			strDefaultMode: ICTouchAPI.KeyboardAlphanumMode.CAPS
		});
	},

	_callCommunicationWebapp:function() {
				if (webapp.communication)
				{
					ICTouchAPI.transitionServices.getScreen({
						name: "webapp.communication.getCommunication",
						params: {}
					});
					this.container = webapp.communication.mainWidget.container;

		}
	},
	onSendIM :function(conversationId)
	{
		webapp.instantmessaging.data.objCurrentConvID.id = conversationId;
		ICTouchAPI.APIServices.InstantMessaging.getConversationById({params: [webapp.instantmessaging.data.objCurrentConvID.id], context: this, callback: this.loadedConversation});

	},

	onAnswerIM :function(idIM)
	{
		ICTouchAPI.APIServices.InstantMessaging.getConversationById({params: [webapp.instantmessaging.data.objCurrentConvID.id], context: this, callback: this.loadedConversation});
	},

    formatText :function(text) {
			var reg = new RegExp("\n", "g");
			text = text.replace(reg, "<br/>");
			return text;
    },

	handleSendIM : function(strContent)
	{
        strContent=webapp.instantmessaging.formatText(strContent);
	   var data = webapp.instantmessaging.data;
	   if(webapp.instantmessaging.data.objCurrentContact!=webapp.instantmessaging.data.objContactBeforeSending){
			webapp.instantmessaging.data.objCurrentContact=webapp.instantmessaging.data.objContactBeforeSending;
	   }
			ICTouchAPI.APIServices.InstantMessaging.sendIM({params: [data.objCurrentContact.contactId, strContent], context: this, callback: webapp.instantmessaging.onSendIM});
	},

	handlerFunc : function(item, container, conversationID)
	{
		if (item)
			this.container = container;
		ICTouchAPI.APIServices.IctDirectory.getContactById({params:[item.objLogData.contactId], context:this, callback:this.loadedDetails});
		webapp.instantmessaging.data.objCurrentConvID.id = item.objLogData.conversationId;

	},

	loadedConversation : function(objConversation)
	{

		var data = webapp.instantmessaging.data;
		if (objConversation && objConversation[0]) {
			data.objConversation = objConversation[0];
			var date, time;
			var lastname, firstname;

			lastname = webapp.userinfo.data.getUserLastName();
			firstname = webapp.userinfo.data.getUserFirstName();
			for(var i=1;i<=15;i++){
                if(objConversation[0].messageList[i-1]){
                        data.imContentUI["domMessage"+i].innerHTML=objConversation[0].messageList[i-1].message;
                        if(data.imContentUI["domMessage"+i].innerHTML){
                                data.imContentUI["domMessage"+i].innerHTML=ICTouchAPI.tools.textEmoIcon(data.imContentUI["domMessage"+i].innerHTML);
                        }
                        date = ICTouchAPI.tools.getFormatedDate(new Date(objConversation[0].messageList[i-1].receivedTime.datetime.year,objConversation[0].messageList[i-1].receivedTime.datetime.month - 1,objConversation[0].messageList[i-1].receivedTime.datetime.day),data._dateFormat);
                        time = ICTouchAPI.tools.getFormatedTimeWithSeconds(objConversation[0].messageList[i-1].receivedTime.datetime.hour,objConversation[0].messageList[i-1].receivedTime.datetime.minute,objConversation[0].messageList[i-1].receivedTime.datetime.second,data._24hformat);
                        if (objConversation[0].messageList[i-1].direction === 0) {
                                data.imContentUI["domMessageHeader"+i].innerHTML = ICTouchAPI.tools.getContactDisplayName(data.objCurrentContact) + " - " + date + " " + time;
                        } else {
								var objContactTmp = {name : lastname, firstName : firstname};
                                data.imContentUI["domMessageHeader"+i].innerHTML = ICTouchAPI.tools.getContactDisplayName(objContactTmp) + " - " + date + " " + time;
                        }
				}
				}
			//mark conversation as read if not already read
			/*if (!objConversation[0].isRead) {
				ICTouchAPI.APIServices.InstantMessaging.setConversationAsRead({params: [data.objCurrentConvID.id], context: this});
			}*/
            if(objConversation[0].isClosed){
                var appBar=ICTouchAPI.AppBarServices._getAppBarWidget("communication", "comstatus"+this.data.STATUS_LOG);
                var btnClose=appBar.getButton(this.data.CLOSE_BTN);
                if(btnClose){
                    btnClose.hide();
                }
            }
			}
		webapp.instantmessaging.domNode.scrollTop=webapp.instantmessaging.data.scrollTopValue;

	},

	loadedDetails : function(objContactList)
	{
		if (objContactList && objContactList[0]) {
			webapp.instantmessaging.data.objCurrentContact = objContactList[0];
			webapp.instantmessaging.data.objCurrentConvID.contactId = objContactList[0].contactId;

		}
		else{
			webapp.instantmessaging.data.objCurrentContact = {firstName: "Unknown", name: ""};
		}

		//show the IM widget
		this.container.reload({
			objTitle: {
				strLabel: _([ICTouchAPI.tools.getContactDisplayName(webapp.instantmessaging.data.objCurrentContact),"-","Instant Messaging"],"webapp.instantmessaging")
                },
			objContent: {
				name: "webapp.instantmessaging.getImContent",
				params: {}
			}
		});
		//refresh the conversation info
		ICTouchAPI.APIServices.InstantMessaging.getConversationById({params: [webapp.instantmessaging.data.objCurrentConvID.id], context: this, callback: this.loadedConversation});

	},

	onCreation : function()
	{
		if (webapp.communication)
		{
			webapp.communication.data._intCallIdToSelect = null;
			webapp.communication.data._intLogIdToSelect = null;
			webapp.communication.data.loadComlogListByFilter(webapp.communication.data.COMLOG_FILTER_IM_BUSINESS_ID,webapp.communication.data.FILTER_READ);
			ICTouchAPI.transitionServices.getScreen({
				name: "webapp.communication.getCommunication",
				params: {}
			});
		}
	},

	onConversationRead : function()
	{
	},

	onConversationDeleted : function()
	{


	},
	onImReceived : function(message)
	{

		var data = webapp.instantmessaging.data;
		if (ICTouchAPI.transitionServices.getCurrentScreenName() == "webapp.communication.getCommunication") {
			//if it he right conversation and the right contact that is active on screen, then show the im
			if(message.value.idConversation == webapp.instantmessaging.data.objCurrentConvID.id &&
			   message.value.contactId == webapp.instantmessaging.data.objCurrentConvID.contactId)
			{/*
				var date, time;
				date = ICTouchAPI.tools.getFormatedDate(new Date(message.value.receivedTime.datetime.year,message.value.receivedTime.datetime.month - 1,message.value.receivedTime.datetime.day),data._dateFormat);
				time = ICTouchAPI.tools.getFormatedTime(new Date(message.value.receivedTime.datetime.hour,message.value.receivedTime.datetime.minute,message.value.receivedTime.datetime.second),data._24hformat);
				//refresh ImContent

                for(var i=1;i<14;i++){
                        data.imContentUI["domMessage"+i].innerHTML = data.imContentUI["domMessage"+(i+1)].innerHTML;
                        data.imContentUI["domMessageHeader"+i].innerHTML = data.imContentUI["domMessageHeader"+(i+1)].innerHTML;
                }

                data.imContentUI.domMessage15.innerHTML = ICTouchAPI.tools.textEmoIcon(message.value.message);

                if (webapp.instantmessaging.data.objCurrentContact){
					data.imContentUI.domMessageHeader15.innerHTML = webapp.instantmessaging.data.objCurrentContact.firstName + " " + webapp.instantmessaging.data.objCurrentContact.name + " - " + date + " " + time;

			}
                else{

					data.imContentUI.domMessageHeader15.innerHTML = " ";
				}*/

			}

			//if not increment the notif
			else
			{
				ICTouchAPI.notificationServices.incNotification("InstantMessaging");
			}
		}
		else {
			ICTouchAPI.notificationServices.incNotification("InstantMessaging");
		}

	},

	onNotificationNewIM : function()
	{
		if (webapp.communication)
		{
			/*for (var i in webapp.communication.data._arrFilters)
				webapp.communication.data._arrFilters[i].enabled = (i == webapp.communication.data.COMLOG_FILTER_IM);*/
			// switch on unread mode
			//webapp.communication.data.intReadFilter = webapp.communication.data.FILTER_UNREAD;

			webapp.communication.data._intCallIdToSelect = null;
			webapp.communication.data._intLogIdToSelect = null;
			webapp.communication.data.loadList(false, true);
			ICTouchAPI.transitionServices.getScreen({
				name: "webapp.communication.getCommunication",
				params: {}
			});
		}
	},

	//orphan function
	onImDisconnected : function()
	{
		//display a warning because the connection was lost
		var context = this;
		var popupData = {
			strTitle: _("IM Disconnected", 'webapp.instantmessaging'),
			strContent : _("A problem occured with the IM server, the connection is lost", 'webapp.instantmessaging'),
			arrPopupButtons: [{
				strButtonLabel:  _("Ok", "ICTouchAPI"),
				callback: function() {
					context.yesWarningCallback();
				}
			},]
		};
		this.warningPopup = ICTouchAPI.popupServices.addNewPopup(popupData, "MEDIUM");
	},

	yesWarningCallback: function() {
		ICTouchAPI.popupServices.removePopup(this.warningPopup);
	},

	onIMFailedEvent : function(idConversation, message, errorCode)
	{
		var context = this;
		var popupData = {
			strTitle: _("Unknown Error", 'webapp.instantmessaging'),
			strContent : _("A problem occured while sending your message!", 'webapp.instantmessaging'),
			arrPopupButtons: [{
				strButtonLabel:  _("Ok", "ICTouchAPI"),
				callback: function() {
					context.yesErrorCallback();
				}
			},]
		};
		this.errorPopup = ICTouchAPI.popupServices.addNewPopup(popupData, "MEDIUM");
	},

	yesErrorCallback: function() {
		ICTouchAPI.popupServices.removePopup(this.errorPopup);
	},

	checkError: function(status) {
		var strMessage = "";
		switch (status) {
			case 1:strMessage = _("Conversation does not exist", "webapp.instantmessaging");
				break;
			default:
				strMessage = _("Unknown error message", "webapp.instantmessaging");
				break;
		}
		if (strMessage != "") {
			ICTouchAPI.popupServices.errorPopup(_("Error", "ICTouchAPI"), strMessage, _("Ok", "ICTouchAPI"), status)
			return true;
		}
		return false;
	}
});
