dojo.require("webapp.browser.getBrowserContentBase");
dojo.provide("webapp.browser.dataBase");

dojo.declare("webapp.browser.dataBase", null, {
	_strContainerPath 		: "webapp.browser.getBrowserContent",
	// _strTitle 				: "",

	sandBox	: null,
	arrBookmarks : ["http://www.google.com"],
	bookmarkCursor : 0,
	lastBookmark : 0,
	bookmarkLimit : 5,
	boolNext : false,
	boolPrevious : false,

	BACK 			: "BACK_BTN",
	URL 			: "URL_BTN",
	BOOKMARKS 		: "BOOKMARKS_BTN",
	PREVIOUS 		: "PREVIOUS_BTN",
	NEXT 			: "NEXT_BTN",
	RELOAD 			: "RELOAD_BTN",
	ADD_BOOKMARK 	: "ADD_BOOKMARK_BTN",
	FULLSCREEN_MODE : "FULLSCREEN_MODE_BTN",
	NORMAL_MODE 	: "NORMAL_MODE_BTN",

	// TO CHANGE
	constructor : function(){
		// definition of buttons
		var func = dojo.hitch( webapp.browser, webapp.browser.buttonCallback);

		var arrButtons = [];
		arrButtons.push({strButtonName: this.URL,				strButtonLabel: _("URL", "webapp.browser"), 			strButtonIcon: 'browser-access-by-url', strStatusText:'', strStatusIcon:'', callback: func});
		arrButtons.push({strButtonName: this.BOOKMARKS, 		strButtonLabel: _("Bookmarks", "webapp.browser"), 		strButtonIcon: 'browser-access-by-favorite', strStatusText:'', strStatusIcon:'', callback: func});
		arrButtons.push({strButtonName: this.PREVIOUS, 			strButtonLabel: _("Previous", "webapp.browser"), 		strButtonIcon: 'browser-back', strStatusText:'', strStatusIcon:'', callback: func});
		arrButtons.push({strButtonName: this.NEXT, 				strButtonLabel: _("Next", "webapp.browser"), 			strButtonIcon: 'browser-next', strStatusText:'', strStatusIcon:'', callback: func});
		arrButtons.push({strButtonName: this.RELOAD, 			strButtonLabel: _("Reload", "webapp.browser"), 			strButtonIcon: 'browser-refresh', strStatusText:'', strStatusIcon:'', callback: func});
		arrButtons.push({strButtonName: this.ADD_BOOKMARK, 		strButtonLabel: _("Add Bookmark", "webapp.browser"),	strButtonIcon: 'browser-add-bookmarks', strStatusText:'', strStatusIcon:'', callback: func});
		arrButtons.push({strButtonName: this.FULLSCREEN_MODE, 	strButtonLabel: _("FullScreen Mode", "webapp.browser"), strButtonIcon: 'browser-fullscreen', strStatusText:'', strStatusIcon:'', callback: func});
		// arrButtons.push({strButtonName: this.NORMAL_MODE, 		strButtonLabel: _("Normal Mode", "webapp.browser"), 	strButtonIcon: 'browser-minimize', strStatusText:'', strStatusIcon:'', callback: func});

		var appBar = ICTouchAPI.AppBarServices.getAppBar("browser", "browser");
		for (var k in arrButtons) {
			var objButton = new UIElements.AppButton.AppButtonControl(arrButtons[k]);
			appBar.addActionButton(objButton);
		}
		ICTouchAPI.settingServices.subscribeToSetting(webapp.browser, "AccessByURL", this.onAllowURL);
		ICTouchAPI.settingServices.subscribeToSetting(webapp.browser, "LockedBookmark", this.onLockBookmark);
	},

	getContainerTitle : function() {
		return this._strTitle;
	},

	setContainerTitle : function(str) {
		this._strTitle = str;
	},

	getContainerPath : function(){
		return this._strContainerPath;
	},

	setContainerPath : function(str) {
		this._strContainerPath = str;
	},

	// open URL given in parameters
	openURL : function(URL) {
		webapp.browser.getBrowserContent.domIFrame.src = URL;
	},


	// clear the history for every link after the cursor
	clearUpperHistory : function() {
		while(this.arrBookmarks[this.bookmarkCursor+1]) {
			this.arrBookmarks.pop();
		}
		this.lastBookmark = this.bookmarkCursor;
	},

	// select a new URL and update the history
	addNewUrlInHistory : function(URL){
		this.boolNext = false;
		this.arrBookmarks.push(URL);
		if(this.bookmarkCursor == this.bookmarkLimit) {
			this.arrBookmarks.shift();
			this.bookmarkCursor--;
		}
		this._next();
	},

	// Go to the next link in the history
	_next : function() {
		this.bookmarkCursor++;
		if(this.lastBookmark <= this.bookmarkCursor) {
			this.lastBookmark = this.bookmarkCursor;
			this.boolNext = false;
		}
		if(this.bookmarkCursor>0)
			this.boolPrevious = true;
		this.loadURL();
		this.updateAppBar();
	},

	// Go to the next link in the history
	_previous : function() {
		this.bookmarkCursor--;
		if(this.bookmarkCursor <=0) {
			this.boolPrevious = false;
		}
		this.boolNext = true;
		this.loadURL();
		this.updateAppBar();
	},

	// Load the current URL pointed by the cursor
	loadURL : function() {
		
		if(this.arrBookmarks[this.bookmarkCursor]) {
			if(this.sandBox) {
				this.sandBox.loadHTML(this.arrBookmarks[this.bookmarkCursor]);
			} else {
				
			}
		} else{
			console.error("Unable to load URL : error 404");
                }
	},

	// Update the App Bar
	updateAppBar : function() {
		var appBar = ICTouchAPI.AppBarServices.getAppBar("browser", "browser");
		// Show or hide button next
		if(this.boolNext)
			appBar.getButton(this.NEXT).show();
		else
			appBar.getButton(this.NEXT).hide();
		// Show or hide button previous
		if(this.boolPrevious)
			appBar.getButton(this.PREVIOUS).show();
		else
			appBar.getButton(this.PREVIOUS).hide();
		// Create the static back button
		var backFunc = dojo.hitch( webapp.browser, webapp.browser.buttonCallback, this.BACK);
		ICTouchAPI.AppBarServices.addExitButton("browser", "browser", true, backFunc);

		// Set the appBar
		ICTouchAPI.AppBarServices.setAppBar("browser", "browser", "getBrowser");
	},

	// Fired when the admin setting AccessByURL changes
	onLockBookmark : function(objSetting) {
		var appBar = ICTouchAPI.AppBarServices.getAppBar("browser", "browser");
		if(objSetting.value)
			appBar.getButton(this.ADD_BOOKMARK).hide();
		else
			appBar.getButton(this.ADD_BOOKMARK).show();
		webapp.filesmanager.data.boolForbidBookmarks = objSetting.value;
	},

	// Fired when the admin setting LockedBookmark changes
	onAllowURL : function(objSetting) {
	
		var appBar = ICTouchAPI.AppBarServices.getAppBar("browser", "browser");
		if(objSetting.value)
			appBar.getButton(this.URL).show();
		else
			appBar.getButton(this.URL).hide();
	}
});
