dojo.provide("webapp.browser.controlBase");
dojo.declare("webapp.browser.controlBase",[ICTouchAPI.webApplication],
{
	// TO CHANGE
	constructor: function()
	{
		ICTouchAPI.tools.registerHomepageButton(["webapp.browser.getBrowser", "BROWSER_BTN", "browser-application", _("Browser", "webapp.browser")]);
		ICTouchAPI.tools.registerHomepageKey(["webapp.browser.getBrowser", "BROWSER_BTN", "browser-application", _("Browser", "webapp.browser")]);
	},

	// Public methods
/* 	Load the link given in parameter in dojo sandbox.
	Update browser history:
	If the cursor doesn't point to the last item in history, remove all the urls from history that follow the cursor.
	Then push the new url in history array, and increment the cursor.
	Disable NEXT_BTN.
	If the cursor is > 0 (or not undefined), enable PREVIOUS_BTN. */
	openLink : function(URL) {
		ICTouchAPI.transitionServices.getScreen({name: "webapp.browser.getBrowser", params: {} });
		var data = webapp.browser.data;
		data.clearUpperHistory();
		data.addNewUrlInHistory(URL);
		data.openURL(URL);
	},

	// Reload the url pointed by the cursor in history.
	reload : function() {
		webapp.browser.data.loadURL();
	},

	// Decrement the cursor in history, and load the corresponding url. If the cursor is 0, disable the PREVIOUS_BTN. Enable NEXT_BTN.
	previous : function() {
		webapp.browser.data._previous();
	},

	// Increment the cursor in history, and load the corresponding url. If the cursor points to the last history item, disable the NEXT_BTN. Enable PREVIOUS_BTN.
	next : function() {
		webapp.browser.data._next();
	},

	// Switch to fullscreen mode: the topbar and the appbar are hidden (modify HTML styles to hide them).
	fullscreenMode : function() {
		var domContent = webapp.browser.getBrowserContent.domContent;
		var domIFrame = webapp.browser.getBrowserContent.domIFrame;
		dojo.style(domContent, "position", "fixed");
		dojo.style(domContent, "left", "0px");
		dojo.style(domContent, "top", "0px");
		domIFrame.style.width = "800px";
		domIFrame.style.height = "480px";
		domContent.style.zIndex = 1200;
		dojo.style(webapp.browser.getBrowserContent.normalScreenBt, "display", "");
	},

	// Switch to normal mode: show the topbar and the appbar (modify HTML styles to show them).
	normalMode : function() {
		//TODO
	},
	// End of public methods

	// Callback of the keyboard called on button Add Bookmark
	addBookmark : function(strName) {
		var data = webapp.browser.data;
		webapp.filesmanager.createLink(/*Category*/"Bookmarks",/*Link Name*/ strName,/*Link Adress*/data.arrBookmarks[data.bookmarkCursor]);
	},


	/**
	 * onProgKeyConfig
	 * for Add/Edit progkey Arguments Testing.
	 */
	onProgKeyConfig : function(objAction){
		this._onProgKeyConfig(objAction);
		return null;
	},

	_onProgKeyConfig : function (objAction) {
		if(objAction.action == "open-bookmarks") {
			webapp.progkeys.currentAddWidget.boolReset = false;
			ICTouchAPI.transitionServices.getScreen({name: "webapp.progkeys.getProgKeyAdd", params: {}});
			webapp.progkeys.currentAddWidget.nextStep();
		}
	},

	_progKeySetArgs : function(bookmark) {
			ICTouchAPI.keyboardServices.closeKeyboard(ICTouchAPI.keyboardServices.CLOSE_ACTION_NONE);
			// We notify progkeys that he doesn't have to reset the display and variables this time
			webapp.progkeys.setProgkeysArgumentsNextStep(bookmark);
	},

	/**
	 * onProgKeyAction
	 * @return : list of Template of actions
	 */
	onProgKeyAction : function() {
		var listActions = [];
		listActions.push({
			webAppName : "browser",
			action : "open-bookmarks",
			type : 1,
			icon : "/webapp/progkeys/demo/calendar.png",
			label : "Open favorites bookmarks"
		});
		return listActions;
	},

	onProgKeyClick : function(objAction) {
		if(objAction.action == "open-bookmarks") {
			webapp.filesmanager.openCategory("Bookmarks");
		}
	},

});

