dojo.require("webapp.browser.controlBase");
dojo.provide("webapp.browser");
dojo.declare("webapp.browser",webapp.browser.controlBase,{

	buttonCallback : function(buttonId) {
		var data = webapp.browser.data;
		switch(buttonId)
		{
			// The back button load the last container
			case data.BACK:
				dojo.publish("OpenHomepage");
				break;
			case data.URL:
				var func = dojo.hitch(this, this.openLink);
				ICTouchAPI.keyboardServices.deployKeyboard(ICTouchAPI.KeyboardTypes.ALPHANUM, null, {funcCallbackOk: func, strDefaultText: data.arrBookmarks[data.bookmarkCursor] || ""});
				break;
			case data.NEXT:
				this.next();
				break;
			case data.PREVIOUS:
				this.previous();
				break;
			case data.RELOAD:
				this.reload();
				break;
			case data.FULLSCREEN_MODE:
				this.fullscreenMode();
				break;
			case data.NORMAL_MODE:
				this.normalMode();
				break;
			case data.BOOKMARKS:
				webapp.filesmanager.openCategory("Bookmarks");
				break;
			case data.ADD_BOOKMARK:
				var func = dojo.hitch(this, this.addBookmark);
				ICTouchAPI.keyboardServices.deployKeyboard(ICTouchAPI.KeyboardTypes.ALPHANUM, null, {funcCallbackOk: func, strDefaultText: ""});
				break;
			default:
				console.warn("buttonCallback > No callback set for Button Id : "+buttonId);
				break;
		}
	}
});

webapp.browser=new webapp.browser();
