/**
 * @class UIElements._base
 * @extends dijit._Widget
 * @abstract
 * Abstract class for all UI Elements
 */
dojo.provide("UIElements._base");
dojo.declare("UIElements._base",
	dijit._Widget,
	{
		/* --------------------------------- Public attributes ------------------------------------ */

		/* --------------------------------- Private attributes ----------------------------------- */

		/**
		 * @ignore
		 */
		_connectedEvents : [],

                /**
		 * @ignore
		 */
		_subLanguageChanged : null,

		_highlightClass: "selected",
		_handlerStopHighlight : null,
		_domCurrentHighlight : null,

		/**
		 * setTimeout handler for the long press callback feature
		 * @ignore
		 * @type {Boolean}
		 */
		_waitingHighlight : null,
		/**
		 * true if we must wait for highlighting, false otherwise
		 * @ignore
		 * @type {Boolean}
		 */
		_enableWaitingHighlight : false,
		/**
		 * setTimeout handler for the long press callback feature
		 * @ignore
		 */
		_handlerLongPress : null,


		/* ------------------------------------ Constructor --------------------------------------- */

		constructor: function(args){
			var splitString = this.declaredClass.split(".");
			var strLast = splitString.pop();
			this.namespace = splitString.join(".");
			this._subLanguageChanged = null;

                        if(!generalConfig.simulation) {
			this._subLanguageChanged = dojo.subscribe("languageChanged", this, function() {
				for (var i in this.attributeMap) {
					if(this[i] && this[i].isI18Ned) {
						this.attr(i, this[i]);
					}
				}
			});
                        }

			this._connectedEvents = [];

			/*
			 * This is some special code that enables the tracking of which element leaks in chrome's profiler
			 * This works by creating a new object called like the widget we are currently constructing
			 */
			if (generalConfig.developer == true) {
				eval("this.objTracking = new function myIC_UI_"+strLast+"(){}");
			}
		},

		destroy : function(){
			dojo.unsubscribe(this._subLanguageChanged);
			this._unsubscribeHighlight(this._handlerStopHighlight);
			this._handlerStopHighlight = null;
			if (this._waitingHighlight) {
				window.clearTimeout(this._waitingHighlight);
				this._waitingHighlight = null;
			}
			for(var attr in this) {
				/*
				 * Search for scroll elements to be destroyed
				 * If firstElementChild or lastElementChild is null, uninit will crash
				*/
				var elt = this[attr];
				if (elt && elt.IctScroll && elt.firstElementChild && elt.lastElementChild) {
					FXScroll.unInit(elt);
				}
			}

			this.inherited(arguments);
			// Before destroying the UIElement, remove all its i18n handlers to avoid memory leaks.
			ICTouchAPI.i18nServices.unsubscribeAllI18nHandlers(this);
			// Also remove all registered events.
			this._removeAllEvents();
		},

		/* ----------------------------------- Getter / Setter------------------------------------- */

		/**
		 * Get the name of the class that created the widget.
                 * @ignore
		 * @return {String} the class name.
		 */
		getInstanceOf: function (){
			return this.declaredClass;
		},

		/**
		 * Method for changing the UIElement's value ( if applicable )
                 * @ignore
		 */
		setValue: function () {
			ICTouchAPI.debugServices.info("setValue not defined for "+this.declaredClass, false);
		},

		/* ----------------------------------- Public methods ------------------------------------- */


		/* --------------------------------- Private Methods -------------------------------------- */

		/**
		 * Clear all timers
		 * @ignore
		 */
		_clearTimers: function() {
			if (this._handlerLongPress) {
				clearTimeout(this._handlerLongPress);
			}
			this._handlerLongPress = null;
		},

		/**
		 * Launch this.funcCallback on mouse down event
		 *  @param {Event} clickEvent mouse down event
		 */
		startHandlerLongPress: function(liNode) {
			// Start the long press timer if a longpress callback is present
			if (typeof this.eventLongPress == "function") {
				this._handlerLongPress = setTimeout(dojo.hitch(this, this.eventLongPress,liNode), 1000);
			}
		},

		/**
		 * Launch this.funcCallbackRelease on mouse up event
		 */
		stopHandlerLongPress: function() {
			this._clearTimers();
		},

		/**
		 * Wait a moment then apply the highlighting effect
                 * @ignore
		 * @return {Boolean} highlight effect will start

		 */
		_startHighlight: function(e, args) {
			if (e && e.currentTarget) {
				// So it works with both dojoAttachPoint and attachEvent method
				var context = (args && args.PARENT_WIDGET) ? args.PARENT_WIDGET : this;
				context._stopHighlight();
				context._handlerStopHighlight = context._subscribeHighlight(e.currentTarget);
				context._domCurrentHighlight = e.currentTarget;
				var _currentTarget = e.currentTarget;

				// Trigger the long press handler
				context.startHandlerLongPress(_currentTarget);

				if(context._enableWaitingHighlight) {
				    var func = function (){
					    dojo.addClass(_currentTarget, context._highlightClass);
				    }
				    context._waitingHighlight = window.setTimeout(func, 100);
				} else {
				    dojo.addClass(_currentTarget, context._highlightClass);
				}
				return true;
			}
			return false;
		},

		/**
		 * Stop the highlighting effect
                 * @ignore
		* @return {Object} the HtmlElement if the user did a click , null in other case
		 */
		_stopHighlight: function(e) {
			if (this._domCurrentHighlight) {
				if (this._waitingHighlight) {
					window.clearTimeout(this._waitingHighlight);
					this._waitingHighlight = null;
				}
				this._unsubscribeHighlight(this._handlerStopHighlight);
				this._handlerStopHighlight = null;
				dojo.removeClass(this._domCurrentHighlight, this._highlightClass);
				var clickedElement = this._domCurrentHighlight;
				this._domCurrentHighlight = null;

				// If the focus is released, stop the long press handling
				this.stopHandlerLongPress();
				return (e && e.type == "mouseup") ? clickedElement : null;
			}
			return null;
		},

		/**
		 * Subscribe to all events that will stop the highlight
		 * @ignore
		 * @return {Object} opaque subscribe handler
		 */
		_subscribeHighlight: function(element) {
			var handler = [];
			handler.push(FXScroll.observeState("start", this, this._stopHighlight));
			handler.push(dojo.connect(element, "mouseup", this, this._stopHighlight));
			handler.push(dojo.connect(element, "mouseleave", this, this._stopHighlight));
			return handler;
		},

		/**
		 * Unsubscribe the handler
		 * @ignore
		 * @param {Object} Object returned by _subscribeHighlight
		 */
		_unsubscribeHighlight: function(handler) {
			if (!handler) {
				return;
			}
			var item;
			// First item is the FXScroll handler
			item = handler.shift();
			FXScroll.unobserveState(item);
			// Rest is dojo connect
			while (handler.length) {
				item = handler.pop();
				dojo.disconnect(item);
			}
		},

		/**
		 * @param {String} type element type
		 * @return {HTMLElement} a dom Element with associated methods for :
		 * @ignore
		 * - mixing in params
		 * - attaching event (so they're referenced and destroyed in the end)
		 * - removing the event
		 * - storing extra information
		 * - appending other nodes
		 */
		newElement : function (type) {
			var elem = type != "documentFragment" ?  document.createElement(type) : document.createDocumentFragment();
			elem.mixin = this._mixin();
			elem.attachEvent = this._attachEvent(elem);
			elem._removeEvent = this._removeEvent(elem);
			elem._infos = {};
			elem._children = [];
			elem._removeMyEvents = this._removeMyEvents(elem);
			elem._removeChildren = function () {
					var l=elem._children.length;
					for (var i =0; i<l; i++) {
							elem._children[i].remove(true);
					}
			};
			elem.append = this.append;
			elem.condAppend = this._condAppend;
			elem.storeInfo = function (infoName, infoValue) {
				this._infos[infoName] = infoValue;
				return infoValue;
			}
			elem.getInfo = function (infoName) {
				return this._infos[infoName] || false;
			}
			elem.remove = function (leaveDom) {
				ICTouchAPI.i18nServices.unsubscribeAllI18nHandlers(this);
				this._removeChildren();
				this._removeMyEvents();
				if (this.parentNode && !leaveDom) {
					this.parentNode.removeChild(this);
				}
				return true;
			}
			return elem;
		},

		/**
		 * Update the widget content, this method may be redefined by each uiElement
		 * @return {boolean} true if a full reload is required
		 * @ignore
		 */
		updateContent : function(params){
			params = null;
			return true;
		},

		/**
		 * @ignore
		 * Call this method with old function name and new one, it will execute it and console warn a message
		 * saying the old one is not to use anymore.
		 */
		_deprecated : function (oldName, newFunc, args) {
			console.warn(this.declaredClass + "." + oldName + " is deprecated, please use " + newFunc + " instead.");
			return this[newFunc].apply(this, args);
		},

		/**
		 * @ignore
		 * Attaches an event and storing it.
		 * Event that'll be removed at UIElement destruction
		 */
		_attachEvent : function () {
			var that = this;

			return function (args, callbackArgs) {

				if (!args) {
					return false;
				} else {
					// Enclose callback
					var callback = function(event) {
						if (typeof that[args.func] === "function") {
							that[args.func].apply(this, [event, callbackArgs]);
						}
					}

					// Store its info
					that._storeEvent(this, {
						"event" : args.event,
						"func" : callback,
						"capture" : args.capture
					});


					callbackArgs = callbackArgs || {};
					// callbackArgs will be given as custom arguments to the
					// encapsulated callback.
					callbackArgs.PARENT_WIDGET = that;

					this.addEventListener(args.event, callback, args.capture);

					return this;
				}

			}
		},

		/**
		 * @ignore
		 * Remove the event
		 */
		_removeEvent : function (to) {
			return function (args) {
				to.removeEventListener(args.event, args.func, args.capture);
				return to;
			}
		},

		/**
	 * @ignore
	 * Mixes in extra params, also auto i18nize strings.
	 */
		_mixin : function () {
			return function (from) {
				for (var i in from) {
					if (from.hasOwnProperty(i)) {
						if (i === "innerHTML" && typeof from[i] === "object" && from[i].isI18Ned) {
							ICTouchAPI.i18nServices.addI18nHandler(this, from[i].fillInnerHTML(this));
						} else if (i === "style") {
							this.setAttribute(i, from[i]);
						} else {
							this[i] = from[i];
						}
					}
				}
				return this;
			}
		},

		/**
		 * @ignore
		 * Appends child to given node if condition is satisfied
		 */
		_condAppend : function  (ifWhat, appendWhat) {
			if (!!(ifWhat)) {
				this.append(appendWhat);
			}
			return this;
		},

		append : function (appendWhat) {
				this.appendChild(appendWhat);
				this._children.push(appendWhat);
		},

		/**
		 * @ignore
		 * Save event in database
		 */
		_storeEvent : function (node, args) {
			this._connectedEvents.push({
				"node" : node,
				"args" : args
			});
		},

		/**
		 * @ignore
		 * Removes all widget's events
		 */
		_removeAllEvents : function () {
			var event;
			while (event = this._connectedEvents.pop()) {
				event.node._removeEvent(event.args);
			}
		},

		/**
		 * @ignore
		 * Remove specifics elem's events
		 */
		_removeMyEvents : function (elem) {
			var that = this;
			return function () {
				for (var i=0; i<that._connectedEvents.length; i++) {
					if (that._connectedEvents.hasOwnProperty(i)) {
						if (that._connectedEvents[i]["node"] === elem) {
							elem._removeEvent(that._connectedEvents[i]["args"]);
							that._connectedEvents.splice(i, 1);
							i--;
						}
					}
				}
			}
		}

	});
