/**
 * @class UIElements.Video.VideoControlBase
 * @namespace UIElements.Video
 * @extends UIElements._base
 * @ignore
 * Abstract Class<br>
 * Video is a UIElements placeholder for live video display. Actual video pixels
 * are overlaid on the screen at lower level (QT)
 */
dojo.provide("UIElements.Video.VideoControlBase");

dojo.declare("UIElements.Video.VideoControlBase",
	[UIElements._base, dijit._Templated],
	{
		/* --------------------------------- Private attributes ----------------------------------- */

		/**
         * @private
         */
		_strBaseClass			: "Video", // Base class of this UI
		_strCallerDeclaredClass	: null,
		_handlerUIDisplayed		: null,
		sipCallId: -1,

		/* --------------------------------- Public attributes ------------------------------------ */

		/**
         * @public
         */

		callId: -1,

		pip: 1,


		/**
         * @property
         * @type Array
         */
		attributeMap: {
		},

		/* ------------------------------------ Constructor --------------------------------------- */

		constructor : function(args) {
		},

		// Function called before displaying the output (allows you to check variables)
		postMixInProperties : function() {
		},


		/* ----------------------------------- Public methods ------------------------------------- */

		showVideoContent : function () {
			ICTouchAPI.debugServices.info('UIElements.Video.VideoControlBase - showVideoContent');
			var context = this;
			setTimeout(function() {
				/* Read current CSS properties */
				context.setStyle();

				if( context.callId >= 0 ) {
					ICTouchAPI.debugServices.debug('UIElements.Video.VideoControlBase - showVideoContent / call VideoServices.show for callId: ' + context.callId);
					ICTouchAPI.VideoServices.show( {
						callId:context.callId,
						sipCallId : context.sipCallId,
						callerUI: context.id,
						callerScreen: context._strCallerDeclaredClass,
						pip: context.pip
					} );
				} else {
					ICTouchAPI.debugServices.debug('UIElements.Video.VideoControlBase - showVideoContent / no callId provided, call VideoServices.showLocal');
					ICTouchAPI.VideoServices.showLocal( {
						callerUI: context.id,
						callerScreen: context._strCallerDeclaredClass
					} );
				}
			}, 200);
		},

		hideVideoContent : function () {
			ICTouchAPI.debugServices.info('UIElements.Video.VideoControlBase - hideVideoContent');
			ICTouchAPI.VideoServices.hide();
		},


		getCoordinate : function() {
			var objCoordinate = {};
			// Get the VideoContent div domNode
			var contentDomNode = this.domNode; //dojo.query('div',this.domNode)[0];
			// Get the relative position and size of the VideoContent div
			var clientRect = contentDomNode.getBoundingClientRect();
			// width rounded to a multiple of 8
			objCoordinate.w = clientRect.width & 0xFFF8;
			// center the window horizontally
			objCoordinate.x = clientRect.left + ((clientRect.width - objCoordinate.w) >> 1);
			// height rounded to a multiple of 2
			objCoordinate.h = clientRect.height & 0xFFFE;
			objCoordinate.y = clientRect.top;
			return objCoordinate;
		},

		displayError: function() {
			dojo.addClass( this.domNode, "Error");
		},

		displayVideo: function() {
			dojo.removeClass( this.domNode, "Error");
		},

		/* --------------------------------- Private Methods -------------------------------------- */
		/**
         * @private
         */
		postCreate : function () {
			ICTouchAPI.debugServices.info('UIElements.Video.VideoControlBase - postCreate');
			this._strCallerDeclaredClass = this._getCallerDeclaredClass(this);
		},

		startup : function () {
			ICTouchAPI.debugServices.info('UIElements.Video.VideoControlBase - startup');
			if (ICTouchAPI.transitionServices.getCurrentScreenName() === this._strCallerDeclaredClass) {
				ICTouchAPI.debugServices.debug('UIElements.Video.VideoControlBase - startup / view ' + this._strCallerDeclaredClass + ' is displayed, call showVideoContent');
				this.showVideoContent();
			}
			else {
				ICTouchAPI.debugServices.debug('UIElements.Video.VideoControlBase - startup / view ' + this._strCallerDeclaredClass + ' is not displayed, subscribe to WEBAPP_SHOW and call showVideoContent when the view will be displayed');
				this._handlerUIDisplayed = dojo.subscribe( "ICTouchAPI.transitionServices.WEBAPP_SHOW", this, function (evt) {
					if (evt.id === this._strCallerDeclaredClass) {
						ICTouchAPI.debugServices.debug('UIElements.Video.VideoControlBase - startup / view ' + this._strCallerDeclaredClass + ' is now displayed, call showVideoContent');
						dojo.unsubscribe(this._handlerUIDisplayed);
						var context = this;
						setTimeout(function(){
							context.showVideoContent();
						}, 0);
					}
				});
			}
		},

		destroy : function (destroyVideo) {
			ICTouchAPI.debugServices.info('UIElements.Video.VideoControlBase - destroy');
			if (this._handlerUIDisplayed) {
				dojo.unsubscribe(this._handlerUIDisplayed);
			}
			if(undefined === destroyVideo){
				destroyVideo = false;
			}
			ICTouchAPI.debugServices.debug('UIElements.Video.VideoControlBase / destroy - callId: '+this.callId);
			if (this.callId >= 0) {
				if(destroyVideo){
					ICTouchAPI.debugServices.debug('UIElements.Video.VideoControlBase - destroy / call VideoServices.destroy');
					ICTouchAPI.VideoServices.destroy( this.callId );
					this.callId = -1;
				} else {
					ICTouchAPI.debugServices.debug('UIElements.Video.VideoControlBase - destroy / call VideoServices.hide');
					// Video is hidden but not stopped (ex: held, hold, transfer, etc...)
					ICTouchAPI.VideoServices.hide({
						callId: this.callId,
						videoStableState: 2
					}); // stable state = 2 for _VIDEO_HIDDEN
				}
			} else {
				if(destroyVideo){
					ICTouchAPI.VideoServices.destroy( undefined, this._strCallerDeclaredClass);
				}
				else {
					ICTouchAPI.debugServices.debug('UIElements.Video.VideoControlBase - destroy / hide video default');
					ICTouchAPI.VideoServices.hide();
				}
			}
			this.inherited(arguments);
		},

		getStyle : function() {
			var bgRGBString = dojo.getComputedStyle(this.domNode).backgroundColor,
			textRGBString = dojo.getComputedStyle(this.domNode).color;

			var bgRGBColor = /^rgb\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3})\)$/.exec( bgRGBString ),
			textRGBColor = /^rgb\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3})\)$/.exec( textRGBString );

			if( bgRGBColor && undefined !== bgRGBColor[1] && textRGBColor && undefined !== textRGBColor[1] )
			{
				var color = [ parseInt(bgRGBColor[1]), parseInt(bgRGBColor[2]), parseInt(bgRGBColor[3]), 0 ];
				var tColor = [ parseInt(textRGBColor[1]), parseInt(textRGBColor[2]), parseInt(textRGBColor[3]), 0 ];

				var bgColor = color[2]|color[1]<<8|color[0]<<16|color[3]<<24,
				textColor = tColor[2]|tColor[1]<<8|tColor[0]<<16|tColor[3]<<24,
				mainMessage = ( this.callId >= 0 ) ? _("waitingVideo","UIElements.Video") : "",//"Waiting for the video of the other party..." : "", // _('ERROR_DIR_MAX_REACHED', "webapp.communication"), // "Waiting for the video of the other party..."
				pipMessage = ( this.callId >= 0 ) ? _("pipMessage","UIElements.Video") : ""; // _('ERROR_DIR_MAX_REACHED', "webapp.communication");  // "Tap here to broadcast or mute your video"

				/*  */
				ICTouchAPI.VideoServices.setParams( bgColor, mainMessage, textColor, pipMessage );
			}

		},
        setStyle : function() {
			ICTouchAPI.debugServices.info('UIElements.Video.VideoControlBase - setStyle');
			var params = this.getStyle();
			if (params) {
				ICTouchAPI.VideoServices.setParams( params.bgColor, params.mainMessage, params.textColor, params.pipMessage );
            }
		},

		_getCallerDeclaredClass : function(context) {
			var object = dijit.getEnclosingWidget(context.domNode.parentNode);
			if (object !== null) {
				return this._getCallerDeclaredClass(object);
			}
			else {
				return context.declaredClass;
			}
		}

	}
	);
