/**
 * @class UIElements.ValueSelect.TimeSelectBase
 * @extends UIElements._base
 * Abstract Class - Do not use it directly
 */
dojo.provide("UIElements.ValueSelect.TimeSelectBase");
dojo.declare("UIElements.ValueSelect.TimeSelectBase",
	[UIElements._base, dijit._Templated],
	{

		/* --------------------------------- Public attributes ------------------------------------ */

		/**
		 * hour value
		 * @property
		 * @type Number
		 */
		intHourValue			: 0,

		/**
		 * hour label
		 * @property
		 * @type String
		 */
		strHour					: null,

		/**
		 * minute value
		 * @property
		 * @type Number
		 */
		intMinuteValue			: 0,

		/**
		 * minute label
		 * @property
		 * @type String
		 */
		strMinute				: null,

		/**
		 * change hour
		 * @property
		 * @type Boolean
		 */
		boolChangeHour			: false, // Should the hour counter changer when we over/underflow minute
		/**
		 * time format
		 * @property
		 * @type Boolean
		 */
		is24hourFormat			: true,

		/**
		 * Callback called value change
		 * This property is set when instanciating the UIElement
		 * @property
		 * @type {Function}
		 */
		callback				: null,

		/* --------------------------------- Private attributes ----------------------------------- */

		/**
		 * @ignore
		 */
		uiHour					: null,
		/**
		 * @ignore
		 */
		uiMinute				: null,
		/**
		 * @ignore
		 */
		uiAMPM				: null,
		/**
		 * @ignore
		 */
		domHour					: null,
		/**
		 * @ignore
		 */
		domMinute				: null,
		/**
		 * @ignore
		 */
		i18n					: "UIElements.ValueSelect",
		/**
		 * @ignore
		 */
		_boolMorning			: true,

		/* ------------------------------------ Constructor --------------------------------------- */

		constructor : function(args){
			if(args.strHour){
				this.strHour=args.strHour;
			}
			if(args.strMinute){
				this.strMinute=args.strMinute;
			}
		},

		postMixInProperties : function(){
			var min=1;
			var max=12;
			var value=this.intHourValue%12
			if(this.is24hourFormat){
				min=0;
				max=23;
				value=this.intHourValue;
			}
			else{
				value = ICTouchAPI.tools.get12HourFrom24(this.intHourValue).intHours;
			}
			this.uiHourParams = {
				intRangeMin	: min,
				intRangeMax	: max,
				intValue	: value,
				strFormat	: "%02d",
				intStep		: 1,
				callback	: this.callback
			};

			this.uiMinuteParams = {
				intRangeMin	: 0,
				intRangeMax	: 59,
				intValue	: this.intMinuteValue,
				strFormat	: "%02d",
				intStep		: 1,
				callback	: this.callback
			}
		},

		destroy: function() {
			if( this.uiHour ) {
				this.uiHour.destroy();
			}
			if( this.uiMinute ) {
				this.uiMinute.destroy();
			}
			this.inherited(arguments);
		},

		postCreate : function () {
			// Prepare parameters sent to hour rotate slider

			this.uiHour = new UIElements.ValueSelect.ScrollSelect(this.uiHourParams, this.domHour);
			this.uiMinute = new UIElements.ValueSelect.ScrollSelect(this.uiMinuteParams, this.domMinute);
			// need to know if we are in am or pm
			this._boolMorning = true;

			if(this.is24hourFormat && this.intHourValue  >= 12){
				this._boolMorning = false;
			}
			if(!this.is24hourFormat)
			{
				this._boolMorning = ICTouchAPI.tools.get12HourFrom24(this.intHourValue).boolIsMorning ? true : false;
				this._createAMPMUI();
			}
			delete this.uiHourParams;
			delete this.uiMinuteParams;

			this.setValue(this.intHourValue, this.intMinuteValue);
		},

		/* ----------------------------------- Getter / Setter------------------------------------- */

		/**
		 * Return the time value
		 * @return {Array} hour and minute
		 */

		getValue : function() {
			var hour = this.uiHour.intValue;
			var minute = this.uiMinute.intValue;
			if( !this.is24hourFormat) {
				hour = ICTouchAPI.tools.get24HourFrom12(hour, this._boolMorning);
			}
			return [hour, minute];
		},

		/**
		 * set value
		 * @param {Number} hour new hour
		 * @param {Number} minute new minute
		 */
		setValue : function(hour, minute) {
			this.uiMinute.attr("intValue", minute);
			if(this.is24hourFormat){
				this.uiHour.attr("intValue", hour);
			}
			else{
				var value = ICTouchAPI.tools.get12HourFrom24(hour);
				this.uiHour.attr("intValue", value.intHours);
				this._boolMorning = value.boolIsMorning;
				if(this.uiAMPM){
					this.uiAMPM.attr("intIndex", value.boolIsMorning ? 0 : 1);
				}
				else{
					this._createAMPMUI();
				}

			}
		},

		set24hourFormat : function(is24hourFormat){
			if(this.domAmPmSlider){
				if(is24hourFormat){
					dojo.addClass(this.domHalfDaySelect, "AMPMFormat");
					this.uiHour.setMinRangeValue(0);
					this.uiHour.setMaxRangeValue(23);
				}
				else{
					if(!this.uiAMPM){
						this._createAMPMUI();
					}
					dojo.removeClass(this.domHalfDaySelect, "AMPMFormat");
					this.uiHour.setMinRangeValue(1);
					this.uiHour.setMaxRangeValue(12);
				}
			}
			this.is24hourFormat = is24hourFormat;
		},

		/* ----------------------------------- Public methods ------------------------------------- */

		/* --------------------------------- Private Methods -------------------------------------- */

		/**
		 * @ignore
		 */
		_createAMPMUI : function(){
			var _arrBool = [_("am", "ICTouchAPI"), _("pm", "ICTouchAPI")];
			this.uiAMPM = new UIElements.OptionChooser.OptionChooserControl({
				arrItems: _arrBool,
                intOptionWidth: 95,
				intIndex: this._boolMorning ? 0 : 1,
				funcCallback:dojo.hitch(this,this._halfDayChanged)
			}, this.domAmPmSlider);
		},

		/**
		 * @ignore
		 * Update the hour UI according to the format and the current moment in day
		 */
		_halfDayChanged: function() {
			this._boolMorning = !this._boolMorning;
			if(this.callback){
				this.callback();
			}
			}

	});
