/**
 * @class UIElements.ValueSelect.ScrollSelectBase
 * @extends UIElements._base
 * Abstract Class - Do not use it directly
 * 
 */
dojo.provide("UIElements.ValueSelect.ScrollSelectBase");
dojo.declare("UIElements.ValueSelect.ScrollSelectBase",
	[UIElements._base, dijit._Templated],
	{


		/* --------------------------------- Public attributes ------------------------------------ */

		/**
		 * value
		 * @property
		 * @type Number
		 */
		intValue			: 0,
		/**
		 * Minimal range
		 * @property
		 * @type Number
		 */
		intRangeMin			: null,
		/**
		 * Maximal range
		 * @property
		 * @type Number
		 */
		intRangeMax			: null,
		/**
		 * step size
		 * @property
		 * @type Number
		 */
		intStep				: 1,
		/**
		 * endless loop
		 * @property
		 * @type Boolean
		 */
		boolLoop			: true,
		/**
		 * prefix string
		 * @property
		 * @type String
		 */
		strPrefix			: "",
		/**
		 * suffix string
		 * @property
		 * @type String
		 */
		strSuffix			: "",
		/**
		 * format
		 * @property
		 * @type String
		 */
		strFormat			: "",
		/**
		 * size string
		 * @property
		 * @type String
		 */
		strSize				: "",

		/**
		 * Callback called value change
		 * This property is set when instanciating the UIElement
		 * @property
		 * @type {Function}
		 */
		callback : {},

		/* --------------------------------- Private attributes ----------------------------------- */

		/**
		 * @ignore
		 */
		_objFeedback		: null,
		/**
		 * @ignore
		 */
		domInputText		: null,
		/**
		 * @ignore
		 */
		domUpButton			: null,
		/**
		 * @ignore
		 */
		domDownButton		: null,
		/**
		 * @ignore
		 */
		attributeMap: {
			strPrefix: {
				node: "domPrefixText",
				type: "innerHTML"
			},
			strSuffix: {
				node: "domSuffixText",
				type: "innerHTML"
			}
		},

		/* ------------------------------------ Constructor --------------------------------------- */

		constructor : function() {
			this.callback = {};
		},

		postMixInProperties : function() {
			if (this.intRangeMin === null || this.intRangeMax === null)
				this.boolLoop = false;   // can't loop when no range is defined
		},

		postCreate : function () {
			this.domInputText.value = dojox.string.sprintf(this.strFormat, this.intValue);
			dijit.typematic.addMouseListener(this.domUpButton, this, this._increaseValue, 50, 500);
			dijit.typematic.addMouseListener(this.domDownButton, this, this._decreaseValue, 50, 500);
			this.connect(this.domUpButton, "onmousedown", this._feedback);
			this.connect(this.domDownButton, "onmousedown", this._feedback);
			if (this.strSize){
				dojo.addClass(this.domNode, this.strSize);
			}
			this.subscribe("iframe.hide", this._stop);
			this.subscribe("toaster.show", this._stop);
		},

		/* ----------------------------------- Getter / Setter------------------------------------- */

		/**
		 * return the value
		 * @return {Number} return the value
		 */

		getValue : function() {
			return this.attr("intValue");
		},

		/**
		 * Set the value up to the given one
		 * @param {Number} value new value
		 */
		setValue : function(value) {
			this.attr("intValue", value);
		},

		/**
		 * Set Minimal range
		 * @param {Number} value new value
		 */
		setMaxRangeValue : function(value) {
			this.intRangeMax = value;
		},

		/**
		 * Set Maximal range
		 * @param {Number} value new value
		 */
		setMinRangeValue : function(value) {
			this.intRangeMin = value;
		},

		/* ----------------------------------- Public methods ------------------------------------- */

		/* --------------------------------- Private Methods -------------------------------------- */

		/**
		 * @ignore
		 */
		_increaseValue : function(count) {
			// When count < 0 it's to signal that the iteration has stopped
			if( count < 0 )
				return;
			var value = this.intValue + this.intStep;
			if (this.intRangeMax !== null && value > this.intRangeMax) {
				if (this.boolLoop)
					value = this.intRangeMin;
				else
					value = this.intRangeMax;
			}
			this.attr('intValue', value);
			this._executeCallback("callback");
		},

		/**
		 * @ignore
		 */
		_decreaseValue : function(count) {
			if( count < 0 )
				return;
			var value = this.intValue - this.intStep;
			if (this.intRangeMin !== null && value < this.intRangeMin) {
				if (this.boolLoop)
					value = this.intRangeMax;
				else
					value = this.intRangeMin;
			}
			this.attr('intValue', value);
			this._executeCallback("callback");
		},

		/**
		 * @ignore
		 */
		_setIntValueAttr : function(newValue) {
			// Round to 0.1 ( avoid rounding errors )
			newValue = Math.round(newValue*10)/10;
			if( this.strFormat !== "" )
				this.domInputText.innerHTML = dojox.string.sprintf(this.strFormat, newValue);
			else
				this.domInputText.innerHTML = newValue;
			this.intValue = newValue;
		},

		/**
		 * @ignore
		 */
		_feedback : function (event) {
		},


		/**
		 * Stop automatic increasing/decreasing values
		 * @ignore
		 */
        _stop : function () {
            dijit.typematic.stop();
        },

		/**
		 * A generic function for executing the UI element callbacks
		 * @ignore
		 * @param {String} name the name of the callback to execute
		 * @param {Object} params the callback's parameters
		 * @return {Boolean} the result of the callback execution or false
		 */
		_executeCallback : function(name, params) {
			// If the callback is a function
			var cb = this[name];
			if (typeof cb === "function") {
				// Execute it
				return cb(params);
			// If it's an object
			} else if (cb && typeof cb.func === "function") {
				// Execute it in the given context, or in the current one.
				cb.func.call(cb.context || window, params || null);
			} else {
				return false;
			}
		}
	});
