/**
 * @class UIElements.Spinner.SpinnerControlBase
 * @extends UIElements._base
 * Abstract Class - Do not use it directly
 */
dojo.provide("UIElements.Spinner.SpinnerControlBase");
dojo.declare("UIElements.Spinner.SpinnerControlBase",
	[UIElements._base, dijit._Templated],
	{

		/* --------------------------------- Public attributes ------------------------------------ */

		/**
		 * Message to be displayed, override default spinner message
		 * @property
		 * @type String
		 */
		strMessage			: "Loading...", // Override default spinner message

		/**
		 * Should the spinner be over the content
		 * @property
		 * @type Boolean
		 */
		boolForeground		: false,

		/* --------------------------------- Private attributes ----------------------------------- */

		/**
		 * @ignore
		 */
		domRotating			: null,
		/**
		 * @ignore
		 */
		_i18n				: "UIElements.Spinner",
		/**
		 * @ignore
		 */
		_boolRotating       : false,
		/**
		 * @ignore
		 */
		_intRotatingSpeed   : 0.25,
		/**
		 * @ignore
		 */
		_intInterval        : 100,
		/**
		 * @ignore
		 */
		_handlerInterval    : null,
		/**
		 * @ignore
		 */
		_intAngle       : 0,
		/**
		 * @ignore
		 */
		attributeMap: {
			strMessage: {
				node: "domMessage",
				type: "innerHTML"
			}
		},

		/* ------------------------------------ Constructor --------------------------------------- */

		constructor: function() {
                    if(!generalConfig.simulation) {
                         // Translate the default message
                        this.strMessage = _(this.strMessage, this._i18n);
                    }
		},

		postMixInProperties: function() {
			this.srcNodeRef = dojo.create("div", { }, this.srcNodeRef);
		},

		postCreate: function() {
			if( this._boolRotating ) {
				var that = this;
				var func = function() {
					that._rotateSpinner();
				}
				this._handlerInterval = setInterval(func, this._intInterval);
				this._rotateSpinner();
			}
			dojo.toggleClass(this.domNode, "foreground", this.boolForeground);
		},

		destroy: function() {
			if( this._handlerInterval ) {
				clearInterval(this._handlerInterval);
			}
			if (this.domRotating) {
				this.domRotating.parentNode.removeChild(this.domRotating);
			}
			this.inherited(arguments);
		},

		/* ----------------------------------- Getter / Setter------------------------------------- */

		/* ----------------------------------- Public methods ------------------------------------- */

		/* --------------------------------- Private Methods -------------------------------------- */

		/**
		 * @ignore
		 */
		_rotateSpinner: function() {
			var angle = this._intAngle;
			this.domRotating.style['-webkit-transform'] = "rotate(" + angle + "deg)";
			this._intAngle = angle+20;
		},

	});
