/**
 * @class UIElements.Slider.RotateBase
 * @extends UIElements._base
 * Abstract Class - Do not use it directly
 */
dojo.provide("UIElements.Slider.RotateBase");
dojo.declare("UIElements.Slider.RotateBase",
	[UIElements._base, dijit._Templated],
	{
		/* --------------------------------- Public attributes ------------------------------------ */

		/**
		 * suffix
		 * @property
		 * @type String
		 */
		strSuffix	: "",
		/**
		 * prefix
		 * @property
		 * @type String
		 */
		strPrefix	: "",
		/**
		 * title
		 * @property
		 * @type String
		 */
		strTitle	: null,
		/**
		 * format
		 * @property
		 * @type String
		 */
		strFormat	: null,
		/**
		 * minimum
		 * @property
		 * @type Number
		 */
		intMinimum	: 0,
		/**
		 * Maximum
		 * @property
		 * @type Number
		 */
		intMaximum	: 23,
		/**
		 * value
		 * @property
		 * @type Number
		 */
		intValue	: 0,
		/**
		 * Is only used for display. Setting this attribute will force minimum to 0 and maximum to arrItems.length-1
		 * @property
		 * @type Array
		 */
		arrItems	: null,

		/* --------------------------------- Private attributes ----------------------------------- */

		/**
		 * @ignore
		 */
		_floatValue		: 0,
		/**
		 * @ignore
		 */
		domTitle		: null,
		/**
		 * @ignore
		 */
		domValue		: null,
		/**
		 * @ignore
		 */
		domPrefix		: null,
		/**
		 * @ignore
		 */
		domSuffix		: null,
		/**
		 * @ignore
		 */
		domSprite		: null,
		/**
		 * @ignore
		 */
		domIncrement	: null,
		/**
		 * @ignore
		 */
		domDecrement	: null,
		/**
		 * @ignore
		 */
		attributeMap: {
			strTitle: {
				node: "domTitle",
				type: "innerHTML"
			},
			strSuffix: {
				node: "domSuffix",
				type: "innerHTML"
			},
			strPrefix: {
				node: "domPrefix",
				type: "innerHTML"
			}
		},
		/**
		 * @ignore
		 */
		_strBaseClass	: "",
		/**
		 * @ignore
		 */
		_objCoords		: null,
		/**
		 * @ignore
		 */
		_handlerMove	: null,
		/**
		 * @ignore
		 */
		_intRange		: 0,

		/**
		 * @ignore
		 * At which point are we in the outter ( scrollable ) zone ?
		 */
		_outerRadius	: 55,

		/**
		 * @ignore
		 * How many steps are in the sprite
		 */
		_intSprites			: 24,
		/**
		 * @ignore
		 * Half length of the spinner
		 */
		_intSpinnerLength	: 83,
		/**
		 * @ignore
		 * Distance from the middle where we doesn't start any action
		 */
		_intButtonDeadZone	: 15,

		/* ------------------------------------ Constructor --------------------------------------- */

		constructor : function(args){
			if(args.strTitle){
				this.strTitle=args.strTitle;
			}
		},

		postMixInProperties: function() {
			this._intRange = this.intMaximum - this.intMinimum + 1;
		},

		postCreate: function() {
			// Force first refresh
			var realValue = this.intValue;
			this.intValue = -1;
			this.attr('intValue', realValue);
			this.connect(this, "onMouseLeave", this._spinnerLeave);			
		},

		destroy: function() {
			if( this._handlerMove )
				dojo.disconnect(this._handlerMove);
			this.inherited(arguments);
		},

		/* ----------------------------------- Getter / Setter------------------------------------- */

		/* ----------------------------------- Public methods ------------------------------------- */

		/**
		 * Increment the current value
		 * @param {Number} count Only used by typematic, shouldn't be used by anything else
		 */
		increment: function(count) {
			// When count < 0 it's to signal that the iteration has stopped
			if( count < 0 )
				return;

			// Bypass dijits attr function to enhance speed
			if( this.intValue == this.intMaximum ) {
				this._setIntValueAttr(this.intMinimum);
				this.overrun();
			}
			else {
				this._setIntValueAttr(this.intValue+1);
			}
		},

		/**
		 * Decrement the current value
		 * @param {Number} count Only used by typematic, shouldn't be used by anything else
		 */
		decrement: function(count) {
			// When count < 0 it's to signal that the iteration has stopped
			if( count < 0 )
				return;

			// Bypass dijits attr function to enhance speed
			if( this.intValue == this.intMinimum ) {
				this._setIntValueAttr(this.intMaximum);
				this.underrun();
			}
			else {
				this._setIntValueAttr(this.intValue-1);
			}
		},

		/**
		 * Event triggered when we cycle from the upper bound to the lower bound
		 */
		overrun: function() {  },

		/**
		 * Event triggered when we cycle from the lower bound to upper bound
		 */
		underrun: function() {  },

		/* --------------------------------- Private Methods -------------------------------------- */

		/**
		 * @ignore
		 * intValue setter
		 */
		_setIntValueAttr: function(value) {
			if( value == this.intValue ) {
				return;
			}
			// Clamp value
			this.intValue = Math.min(this.intMaximum, Math.max(this.intMinimum, value));
			// Display the content of arrItems if available
			if( this.arrItems != null ) {
				this.domValue.innerHTML = this.arrItems[this.intValue];
			}
			// Only use sprintf when necessary
			else if( typeof this.strFormat == "string" ) {
				this.domValue.innerHTML = dojox.string.sprintf(this.strFormat, this.intValue);
			}
			// Default display method
			else {
				this.domValue.innerHTML = this.intValue;
			}

			// Change the value to the internal representation
			this._floatValue = (this.intValue - this.intMinimum) / this._intRange;
			this._refresh();
		},

		/**
		 * @ignore
		 * You must set intValue for this to take effect
		 */
		_setArrItemsAttr: function(items) {
			if( items != null ) {
				this.intMinimum = 0;
				this.intMaximum = items.length-1;
				this._intRange = this.intMaximum - this.intMinimum + 1;
			}

			this.arrItems = items;
		},

		/**
		 * @ignore
		 * You must set intValue for this to take effect
		 */
		_setIntMinimumAttr: function(minimum) {
			if( this.arrItems == null ) {
				this.intMinimum = minimum;
				this._intRange = this.intMaximum - this.intMinimum + 1;
			}
		},

		/**
		 * @ignore
		 * You must set intValue for this to take effect
		 */
		_setIntMaximumAttr: function(maximum) {
			if( this.arrItems == null ) {
				this.intMaximum = maximum;
				this._intRange = this.intMaximum - this.intMinimum + 1;
			}
		},

		/**
		 * @ignore
		 * Update the position of the button and change sprite ( normalize should only be used when the range is changed )
		 */
		_refresh: function(normalizeFloatValue) {
			if( normalizeFloatValue ) {
				var value = this._floatValue*this._intRange;
				this._floatValue = Math.round(value)/this._intRange;
			}

			if( this._strBaseClass == "" ) {
				this._strBaseClass = this.domSprite.className;
			}
			this.domSprite.className = this._strBaseClass + " sprite-"+Math.round(this._floatValue*this._intSprites);
		},

		/**
		 * @ignore
		 * This will call the function dijit.typematic.trigger when we aren't in the dead zone
		 * If y > 0 then it's increment, else it's decrement
		 */
		_triggerTypematic: function(event) {
			var y = event.pageY - this._objCoords.y - this._intSpinnerLength;
			if( Math.abs(y) < this._intButtonDeadZone )
				return;
			if( y < 0 )
				dijit.typematic.trigger(event, this, this.domIncrement, this.increment, this.domIncrement, 0.85);
			else
				dijit.typematic.trigger(event, this, this.domDecrement, this.decrement, this.domDecrement, 0.85);
		},

		/**
		 * @ignore
		 * Event handler when a mouse button is pushed
		 */
		_spinnerDown: function(event) {
			dojo.stopEvent(event);
			this._objCoords = dojo.coords(this.domSprite.parentNode, false);
			// If we are in the outer radius start scrolling else the click will be passed down to the buttons
			if( this._spinnerMove(event, true) )
				this._handlerMove = dojo.connect(this.domNode, "mousemove", this, this._spinnerMove);
			else
				this._triggerTypematic(event);
		},

		/**
		 * @ignore
		 * Event handler when mouse is moved
		 */
		_spinnerMove: function(event, first) {
			var x = event.pageX - this._objCoords.x - this._intSpinnerLength;
			var y = event.pageY - this._objCoords.y - this._intSpinnerLength;

			var rad = Math.sqrt(x*x + y*y);

			/*
			 * If this is called the first time during a scroll ( on mouseDown ) and we are in the inner radius of the scroll,
			 * do nothing and return false to show it to _spinnerDown
			 */
			if( first && rad < this._outerRadius )
				return false;

			x /= rad;

			var angle = y < 0 ? -Math.acos(x) : Math.acos(x);

			// Save the last value for the overrun / underrun test
			var lastValue = this._floatValue;

			this._floatValue = angle / ( 2 * Math.PI ) + 0.25;
			if( this._floatValue < 0 )
				this._floatValue += 1.0;

			// Bypass dijit's attr function and directly call the setter
			this._setIntValueAttr(Math.round(this._floatValue*this._intRange)+this.intMinimum);

			if( lastValue >= 0.75 && this._floatValue < 0.25 ) {
				this.overrun();
			}

			if( lastValue < 0.25 && this._floatValue >= 0.75 ) {
				this.underrun();
			}

			return true;
		},

		/**
		 * @ignore
		 * Event handler when mouse leaves the UIElement
		 */
		_spinnerLeave: function(event) {
			this._spinnerUp(event);
		},

		/**
		 * @ignore
		 * Event handler when mouse button is released or the mouse leaves the UIElement
		 */
		_spinnerUp: function(event) {
			dojo.stopEvent(event);
			if( this._handlerMove ) {
				dojo.disconnect(this._handlerMove);
				this._handlerMove = null;
				this._objCoords = null;
			}
			else {
				dijit.typematic.stop();
			}
		}		
	});

