/**
 * @class UIElements.Slider.Linear
 * @ignore
 * @extends UIElements.Slider.LinearBase
 */
dojo.provide("UIElements.Slider.Linear");
dojo.require("UIElements.Slider.LinearBase");
dojo.declare("UIElements.Slider.Linear",
	UIElements.Slider.LinearBase,
	{
		/* --------------------------------- Public attributes ------------------------------------ */

		/**
		 * Slider width
		 * @property
		 * @type Number
		 */
		intSliderWidth		: 150,

		/* --------------------------------- Private attributes ----------------------------------- */

		/**
		 * @private
		 */
		templatePath		: dojo.moduleUrl("UIElements.Slider", "templates/Linear8052.html"),
		/**
		 * @private
		 */
		cssFile				: ["base.css", "8052.css"],

		/* ------------------------------------ Constructor --------------------------------------- */

		/* ----------------------------------- Getter / Setter------------------------------------- */

		/* ----------------------------------- Public methods ------------------------------------- */

		/**
		 * navigate within the slider
		 * @param {String} action navigation action to perform
		 */
		navigate: function(action) {
			var val = 0;
			switch(action)
			{
				case "DOWN":
				case "LEFT":
					val = -1;
					break;
				case "UP":
				case "RIGHT":
					val = 1;
					break;

			}
			if( val != 0)
			{
				var step = this.computeStep();
				this.setValue(this.getValue()+step*val);
			}
			this._updateDisplay();
		},

		/**
		 * Automaticaly compute the step
		 */
		computeStep: function() {
			var step = Math.round((this.intMaximum-this.intMinimum)*0.10);
			return Math.max(step, 1);
		},

		/* --------------------------------- Private Methods -------------------------------------- */
	}
);

