/**
 * @class UIElements.Slider.GraduateBase
 * @extends UIElements.Slider.Linear
 * Abstract Class - Do not use it directly
 */
dojo.require("UIElements.Slider.Linear");
dojo.provide("UIElements.Slider.GraduateBase");
dojo.declare("UIElements.Slider.GraduateBase",
	UIElements.Slider.Linear,
	{
		/* --------------------------------- Public attributes ------------------------------------ */

		/**
		 * show touch
		 * @property
		 * @type Boolean
		 */
		boolShowTouch		: false,
		/**
		 * show Label on the button
		 * @property
		 * @type Boolean
		 */
		boolShowButtonLabel	: true,
		/**
		 * maximum
		 * @property
		 * @type Number
		 */
		intMaximum			: 10,

		/* --------------------------------- Private attributes ----------------------------------- */

		/**
		 * @ignore
		 */
		domGraduations		: null,

		/* ------------------------------------ Constructor --------------------------------------- */

		postCreate: function() {
			this._showGraduations();

			//add a class if the tooltip feature is enabled
			if (this.boolShowTouch)
				dojo.addClass(this.domNode, "showTooltip");

			this.inherited(arguments);
		},

		/* ----------------------------------- Getter / Setter------------------------------------- */

		/**
		 * Set the value
		 * @param {Number} value : new value
		 */
		setValue: function(value) {
			value = Math.round(value);
			this.inherited(arguments, [value]);
		},

		/* ----------------------------------- Public methods ------------------------------------- */

		/* --------------------------------- Private Methods -------------------------------------- */

		/**
		 * @ignore
		 */
		_showGraduations: function() {
			var range = this.intMaximum - this.intMinimum + 1;
			for(var i=0; i<range; ++i)
			{
				dojo.create("td", {
					"class": "border"
				}, this.domGraduations, "last");
				dojo.create("td", { }, this.domGraduations, "last");
			}
		},
		/**
		 * @ignore
		 */
		_updateDisplay : function() {
			this.inherited(arguments);
			var toShow = this.getValue();
			if (this.boolShowButtonLabel){
			if( this.boolShowTouch )
				this.domButtonContent.innerHTML = "<em>" + toShow + "</em>" + "<span>" + toShow + "</span>";
			else
				this.domButtonContent.innerHTML = "<em>" + toShow + "</em>";
		}
		}
	});
