dojo.provide("UIElements.SimpleButton.SimpleButtonControlBase");

dojo.declare("UIElements.SimpleButton.SimpleButtonControlBase",
	[UIElements._base, dijit._Templated],
	{
		// All attributes of this class are available in the template
		strButtonName			: null,
		strButtonType			: null,
		strOtherClass			: null,
		strButtonText			: null,
		strButtonIcon			: null,
		strSubText				: null,

		intWidth				: 1,
		intHeight				: 1,

		domButtonIcon			: null,
		domButtonText			: null,
		domSubText				: null,
		funcCallback			: null,
		funcCallbackRelease		: null,
		myFeedback				: null,

		_strBaseClass			: "simpleButton", // Base class of this UI

		attributeMap: {
			strButtonText: { node: "domButtonText", type: "innerHTML" },
			strSubText: { node: "domSubText", type: "innerHTML" }
		},

		constructor : function(args) {
			this.myFeedback = ICTouchAPI.feedbackServices.initFeedback("click");
		},

		// Function called before displaying the output (allows you to check variables)
		postMixInProperties : function() {
			this.strButtonText = this.strButtonText || "";
			this.strSubText = this.strSubText || "";
		},

		postCreate : function () {
			if (this.strButtonIcon)
				dojo.addClass(this.domButtonIcon, this.strButtonIcon);
			if (this.strButtonName) {
				this.domNode.setAttribute("buttonname",this.strButtonName);
			}
			this._updateClasses();
		},

		actionNotification:function(clickEvent){
			this.myFeedback.feedback(clickEvent);
			this.funcCallback(this.strButtonText);
		},

		// WRK : crms00204576
		releaseNotification:function(){
			if (typeof this.funcCallbackRelease === "function") {
				this.funcCallbackRelease();
			}
		},

		_feedBack:function(clickEvent){
			this.myFeedback.feedback(clickEvent);
		},

		replaceText: function (strText) {
			if (strText.isI18Ned) {
				strText = strText.getTranslation();
			};
			this.attr("strButtonText", strText);
			// Workaround webkit bug ?
			this.domButtonText.style.opacity = "0.99";
			this.domButtonText.style.opacity = "";
		},

		replaceIcon: function (strIcon) {
			this.attr("strButtonIcon", strIcon);
		},

		_getIconSize: function(){
			var size = 0;
			switch(this.strButtonType){
				case "TextButton":
					size = "10";
					break;
				case "ActionButton":
					// Smaller icon if we have text
					var smallSize = ( this.strButtonText.length > 0 ) ? "24" : "32";
					size = ( this.intWidth > 1 ) ? "64" : smallSize;
					break;
			}
			return size;
		},

		_setStrButtonIconAttr: function (strIcon) {
			strIcon = strIcon + "-" + this._getIconSize();
			/*if( this.init )
			{
				var func = dojo.hitch(this, function(item) {
					this.domButtonIcon = item;
				});
				var transition = new UIEffects.Transition.CssClass(this.domButtonIcon, {
					strNewClass: strIcon,
					strOldClass: this.strButtonIcon,
					funcTransitionEnd: func
				});
				transition.launch();
			}
			else
			{*/
			dojo.removeClass(this.domButtonIcon, this.strButtonIcon);
			dojo.addClass(this.domButtonIcon, strIcon);
			/*	this.init = true;
			}*/
			this.strButtonIcon = strIcon;
		},

		_setStrButtonType: function(value) {
			this.strButtonType = value;
			this._updateClasses();
		},

		_setStrOtherClass: function(value) {
			this.strOtherClass = value;
			this._updateClasses();
		},

		_setIntWidthAttr: function(value) {
			this.intWidth = value;
			this._updateClasses();
		},

		_setIntHeightAttr: function(value) {
			this.intHeight = value;
			this._updateClasses();
		},

		_updateClasses: function() {
			var name = this._strBaseClass;
			if( this.strButtonType ) {
				name = name + " " + this.strButtonType;
			}
			if( this.strOtherClass ) {
				name = name + " " + this.strOtherClass;
			}
			name = name + " width-" + this.intWidth + " height-" + this.intHeight;
			this.domNode.className = name;
		}
	}
);
