/**
 * @class UIElements.SideTray.SideTrayControlBase
 * @extends UIElements._base
 * @ignore
 * Abstract Class - Do not use it directly
 */
dojo.provide("UIElements.SideTray.SideTrayControlBase");
dojo.declare("UIElements.SideTray.SideTrayControlBase",
	[UIElements._base, dijit._Templated],
	{
		/* --------------------------------- Public attributes ------------------------------------ */

		/* --------------------------------- Private attributes ----------------------------------- */

		domArrow     : null,
		domContent	 : null,
		domSTContent : null,
		isTrayOpen	 : false,
		domAppBar	 : null,
		appBarUi	 : null,
		objVideoButton : null,
		videoButtonUi : null,
		
		
		/* ------------------------------------ Constructor --------------------------------------- */

		/* ----------------------------------- Getter / Setter------------------------------------- */

		/* ----------------------------------- Public methods ------------------------------------- */


		constructor : function(){
	
		},
		
		postCreate : function(){
			this.buildAppBar();
			//this.domSTContent.style.display = 'none';

			this.openTray();
		},
		
		/**
		 * Hide a given node
		 * @param {HTMLElement} node node to be hidden
		 */
		hide : function () {
			dojo.toggleClass(this.domArrow,"generic-arrow-right-32", false);
			dojo.toggleClass(this.domArrow,"generic-arrow-left-32", true);
		},
		/**
		 * Show a given node
		 * @param {HTMLElement} node shown to be hidden
		 */
		switchState : function() {
			var that = this;
			setTimeout(function(){that.updateState();},15);
		},
		
		updateState : function() {
			if(this.isTrayOpen) {
				this.closeTray();
			} else {
				this.openTray();
			}
		},
		
		openTray : function() {
			this.domSTContent.style.display = 'block';
			this.isTrayOpen = true;
			this.domArrow.className = "Arrow generic-arrow-right-32";
		},
		
		closeTray : function() {
			this.domSTContent.style.display = 'none';
			this.isTrayOpen = false;
			this.domArrow.className = "Arrow generic-arrow-left-32";
		},
		
		buildAppBar: function() {
			//Create the appbar
			this.appBarUi = new UIElements.AppBar.AppBarWidget({
				webAppName:"communication",
				widgetName:"videoSideTray"
			});
			//Create the video button
			this.videoButtonUi = new UIElements.AppButton.AppButtonControl(this.objVideoButton);
			//Add it to the appbar
			this.appBarUi.addActionButton(this.videoButtonUi);
			
			//Place the appBar in the dom
			this.appBarUi.placeAt(this.domAppBar);
		},
		
		destroy: function() {

			this.inherited(arguments);
		}

	/* --------------------------------- Private Methods -------------------------------------- */
	}
	);
