/**
 * @class UIElements.SelectList.SelectListItemBase
 * @extends UIElements._base
 * Abstract Class - Do not use it directly
 */
dojo.provide("UIElements.SelectList.SelectListItemBase");
dojo.declare("UIElements.SelectList.SelectListItemBase",
	[UIElements._base, dojox.dtl._Templated],
	{
		/* --------------------------------- Public attributes ------------------------------------ */

		/**
		 * Secondary content icon
		 * @property
		 * @type String
		 */
		strSecondaryContentIcon		: "",
		/**
		 * Secondary design icon
		 * @property
		 * @type String
		 */
		strSecondaryDesignIcon		: "",
		/**
		 * Checked icon
		 * @property
		 * @type String
		 */
		strCheckedIcon				: null,
		/**
		 * Unchecked icon
		 * @property
		 * @type String
		 */
		strUncheckedIcon         	: null,
		/**
		 * label
		 * @property
		 * @type String
		 */
		strLabel					: "",
		/**
		 * Action icon
		 * @property
		 * @type String
		 */
		strActionIcon				: "",
		/**
		 * Additionnal style: alternative css class (optional, provided in the item)
		 * @property
		 * @type String
		 */
		additionalStyle		: "",
		/**
		 * Button callback function
		 * @property
		 * @type Function
		 */
		buttonCallback				: null,
		/**
		 * Items callback function
		 * @property
		 * @type Function
		 */
		itemCallback				: null,
		/**
		 * Selected
		 * @property
		 * @type Boolean
		 */
		boolSelected				: false,
		/**
		 * Enabled (if item is not enabled, it appears grey tint and not selectable)
		 * @property
		 * @type Boolean
		 */
		boolEnabled				: true,
		/**
		 * Index
		 * @property
		 * @type Number
		 */
		intIndex					: -1,

		/* --------------------------------- Private attributes ----------------------------------- */

		/**
		 * @ignore
		 */
		_itemCallbackFunc			: null,
		/**
		 * @ignore
		 */
		_buttonCallbackFunc			: null,
		/**
		 * @ignore
		 */
		_boolSecondaryIcon			: false,
		/**
		 * @ignore
		 */
		_funcCallback				: null,
		/**
		 * @ignore
		 */
		_objContext					: null,
		/**
		 * @ignore
		 */
		_callbackValue				: null,
		/**
		 * @ignore
		 */
		_objLastEvent				: null,
		/**
		 * @ignore
		 */
		_checked					: false,
		/**
		 * @ignore
		 */
		_funActioncCallback			: null,
		/**
		 * @ignore
		 */
		_objActionContext			: null,
		/**
		 * @ignore
		 */
		_callbackActionValue		: null,
		/**
		 * @ignore
		 */
		domCheckIcon				: null,
		/**
		 * @ignore
		 */
		domUncheckIcon				: null,
		/**
		 * @ignore
		 */
		domSecondaryIcon			: null,
		/**
		 * @ignore
		 */
		domActionButton				: null,
		/**
		 * @ignore
		 */
		domActionIcon				: null,
		/**
		 * @ignore
		 */
		attributeMap: {
			"strLabel": {
				node: "domLabel",
				type: "innerHTML"
			}
		},
		/**
		 * true if we must wait for highlighting, false otherwise
		 * @ignore
		 * @type {Boolean}
		 */
		_enableWaitingHighlight : true,

		/* ------------------------------------ Constructor --------------------------------------- */

		postMixInProperties : function() {
			this.strActionIcon = this.strActionIcon || "";
			if (this.strSecondaryDesignIcon || this.strSecondaryContentIcon){
				this._boolSecondaryIcon = true;
			}
		},

		postCreate : function () {
			var icon;
			if (this.strSecondaryDesignIcon){
				icon = this.strSecondaryDesignIcon + "-" + this._intIconSize;
				dojo.addClass(this.domSecondaryIcon, icon);
			}
			if (this.additionalStyle){
				dojo.addClass(this.domNode, this.additionalStyle);
			}
			if (this.strActionIcon){
				icon = this.strActionIcon + "-" + this._intIconSize;
				dojo.addClass(this.domActionIcon, icon);
				this.domActionButton.intIndex = this.intIndex;
			}
			if (this.boolSelected) {
				this.select();
			}
			else {
				this.unselect();
			}
			if (this.boolEnabled == false){
				dojo.toggleClass(this.domNode, "disabledModeSelectList", true);
				dojo.toggleClass(this.domNode, "selectableLine", false);
			}
			this.domNode.intIndex = this.intIndex;
		},

		destroy: function() {
			delete this._funcCallback;
			delete this._objContext;
			delete this._objLastEvent;
			this.inherited(arguments);
		},

		/* ----------------------------------- Getter / Setter------------------------------------- */

		/**
		 * set the click event's callback function
		 * @param {Object} context the event context
		 * @param {Function} funcCallback callback function to be runned
		 * @param {Number} value ???
		 */
		setClickCallback: function(context, funcCallback, value) {
			this._funcCallback = funcCallback;
			this._objContext = context;
			this._callbackValue = value;
		},

		/**
		 * return true if the dom icon has the "checked" class
		 * @return {Boolean} domIcon has checked class ?
		 */
		isSelected : function() {
			return this._checked;
		},

		/**
		 * return the Enabled state of the item
		 * @return {Boolean} domNode has not disabledMode class ?
		 */
		isEnabled : function() {
			return this.boolEnabled;
		},

		/* ----------------------------------- Public methods ------------------------------------- */

		/**
		 * Select
		 */
		select : function () {
			this._checked = true;
			this._updateIcon(true);
		},

		/**
		 * Unselect
		 */
		unselect : function() {
			this._checked = false;
			this._updateIcon(false);
		},

		/* --------------------------------- Private Methods -------------------------------------- */

		/**
		 * @ignore
		 */
		setActionCallback: function(context, funcCallback, value) {
			this._funcActionCallback = funcCallback;
			this._objActionContext = context;
			this._callbackActionValue = value;
		},

		/**
		 * @ignore
		 */
		_clicked: function(event) {
			//There is a very odd behavior here, every event comes two times so for now this is a workaround
			if( event === this._objLastEvent ) {
				return;
			}
			this._objLastEvent = event;
			if( typeof this._funcCallback == "function" ) {
				this._funcCallback.call(this._objContext, this._callbackValue);
			}
		},

		/**
		 * @ignore
		 */
		_actionClicked: function(event) {
			//There is a very odd behavior here, every event comes two times so for now this is a workaround
			if( event === this._objLastEvent ) {
				return;
			}
			this._objLastEvent = event;
			if( typeof this._funcActionCallback == "function" ) {
				this._funcActionCallback.call(this._objActionContext, this._callbackActionValue);
			}
		},

		/**
		 * Every remove and addClass are done here according to the boolChecked flag
		 * @ignore
		 */
		_updateIcon: function(boolChecked) {
			// Check that strCheckedIcon and strUncheckedIcon isn't garbage
			if( typeof this.strCheckedIcon == "string" && this.strCheckedIcon.length ) {
				dojo.toggleClass(this.domIcon, this.strCheckedIcon, boolChecked);
			}
			else {
				dojo.toggleClass(this.domIcon, "checked", boolChecked);
			}
			if( typeof this.strUncheckedIcon == "string" && this.strUncheckedIcon.length ) {
				dojo.toggleClass(this.domIcon, this.strUncheckedIcon, !boolChecked);
			}
			else {
				dojo.toggleClass(this.domIcon, "unchecked", !boolChecked);
			}
		},

		/**
		 * @ignore
		 */
		_setItemCallbackAttr : function(callback) {
			this._itemCallbackFunc = ICTouchAPI.tools.callbackToHitch(callback);
		},

		/**
		 * @ignore
		 */
		_setButtonCallbackAttr : function(callback) {
			this._buttonCallbackFunc = ICTouchAPI.tools.callbackToHitch(callback);
		}

	}
	);
