/**
 * @class UIElements.SelectList.SelectListControl
 * @ignore
 * @extends UIElements.SelectList.SelectListControlBase
 */
dojo.require("UIElements.SelectList.SelectListControlBase");
dojo.provide("UIElements.SelectList.SelectListControl");
dojo.declare("UIElements.SelectList.SelectListControl",
	UIElements.SelectList.SelectListControlBase,
	{
		/* --------------------------------- Public attributes ------------------------------------ */

		/**
		 * size of items
		 * @property
		 * @type Number
		 */
		intItemSize		: 32,

		/**
		 * focus
		 * @property
		 * @type Number
		 */
		intFocus		: 0,

		

		/* --------------------------------- Private attributes ----------------------------------- */

		/**
		 * @private
		 */
		templatePath			: dojo.moduleUrl("UIElements.SelectList","templates/SelectList8052.html"),
		/**
		 * @private
		 */
		cssFile                 : ["base.css", "8052.css"],

		/* ------------------------------------ Constructor --------------------------------------- */

		/* ----------------------------------- Public methods ------------------------------------- */
		
		/**
		 * update the focus
		 */
		updateFocus: function() {
			var len = this.arrItemsUI.length;
			if( len < 1 )
				return;
			this.intFocus = Math.max(0, Math.min(len-1, this.intFocus));
			for(var i=0; i<len; ++i)
			{
				var obj = this.arrItemsUI[i];
				dojo.toggleClass(obj, "focus", (i == this.intFocus));
			}
		},


		/**
		 * navigate within the slider
		 * @param {String} action navigation action to perform
		 */
		navigate: function(action) {
			switch(action)
			{
				case "UP":
					this.intFocus--;
					this.updateFocus();
					break;
				case "DOWN":
					this.intFocus++;
					this.updateFocus();
					break;
				case "OK":
					// Create fake click event
					var obj = this.arrItemsUI[this.intFocus];
					var event = {
						currentTarget: obj
					};
					this._clicked(event);
					break;
			}
		}
	/* --------------------------------- Private Methods -------------------------------------- */
	}
	);
