/*
 * @class UIElements.ScrollPanel.ScrollPanelControlBase
 * @namespace UIElements.ScrollPanel
 * @ignore
 */
dojo.provide("UIElements.ScrollPanel.ScrollPanelControlBase");
dojo.declare("UIElements.ScrollPanel.ScrollPanelControlBase",
	[UIElements._base, dijit._Templated],
	{

		/* --------------------------------- Public attributes ------------------------------------ */

		/* --------------------------------- Private attributes ----------------------------------- */

		_objScroll: null,

		/* ------------------------------------ Constructor --------------------------------------- */

		postCreate : function () {
			// Parameter for scrollList not used in ScrollPanel
			this.boolHasScrollPanel = true;
			this.refresh(this);
		},

		destroy : function () {
			if( this._objScroll )
				this._objScroll.destroy();
			this.inherited(arguments);
		},

		/* ----------------------------------- Getter / Setter------------------------------------- */

		/*
		 * is moving
		 */
		isMoving : function () {
			//return false;
			return this._objScroll.isMoving();
		},

		/*
		 * return the scroll object
		 */
		getScroll : function () {
			return this._objScroll;
		},

		/* ----------------------------------- Public methods ------------------------------------- */

		/*
		 * Refresh the scroll
		 * @param {Object} params : parameter for the scroll object refresh function
		 */
		refresh : function(params) {
			if( this._objScroll )
			{
				this._objScroll.refresh(params);
			}
			else
			{
				var listRoot = dojo.query(">", this.containerNode);
				listRoot = (listRoot.length > 1) ? this.containerNode : listRoot[0];
				this._objScroll = new UIEffects.Scroll.VerticalList(listRoot, params);
			}
		},

		/* --------------------------------- Private Methods -------------------------------------- */
	}
	);
