/**
 * @class UIElements.ProgressBar.ProgressBarControlBase
 * @extends UIElements._base
 * Abstract Class - Do not use it directly
 */
dojo.provide("UIElements.ProgressBar.ProgressBarControlBase");
dojo.declare("UIElements.ProgressBar.ProgressBarControlBase",
	[UIElements._base, dijit._Templated],
	{
		/* --------------------------------- Public attributes ------------------------------------ */

		/**
		 * current value
		 * @property
		 * @type Number
		 */
		intValue			: 0,
		/**
		 * minimum value
		 * @property
		 * @type Number
		 */
		intMinimum			: 0,
		/**
		 * maximum value
		 * @property
		 * @type Number
		 */
		intMaximum			: 100,		
		/**
		 * Do we have to show the time ?
		 * @property
		 * @type String
		 */
		boolShowTime		: false,		

		/* --------------------------------- Private attributes ----------------------------------- */

		/**
		 * @ignore
		 */
		domBar				: null,		
		/**
		 * @ignore
		 * Length of the bar
		 */
		_intRealWidth		: 0,
		/**
		 * @ignore
		 * marginBox of the bar
		 */
		_mbBar				: null,
		/**
		 * @ignore
		 * Pixel where the button begins
		 */
		_intStart			: 0,
		/**
		 * @ignore
		 * Pixel where the button ends
		 */
		_intEnd				: 0,		
		/**
		 * @ignore
		 * FrameId where this UI is contained
		 */
		_strFrameId			: null,

		/* ------------------------------------ Constructor --------------------------------------- */


		constructor : function() {
		},

		postMixInProperties : function() {
		},

		postCreate: function() {
			ICTouchAPI.tools.removeWhitespaceNodes(this.domBar);

			if(this.boolShowTime )
			{
				this.domPlayedTime.innerHTML = this._floatToTime(this.intValue);
				this.domTotalTime.innerHTML = (this.intMaximum)? this._floatToTime(this.intMaximum) : '';
			}


			this.setBarWidth(this.intBarWidth);
			this.setValue(this.intValue);
			this.subscribe("iframe.show", this._display);
		},

		destroy: function() {			
			this.inherited(arguments);
		},

		/* ----------------------------------- Getter / Setter------------------------------------- */

		/**
		 * Set the progressBar width
		 * @param {Number} width new width
		 */
		setBarWidth: function(width) {
			this.intBarWidth = width;
			if( this.boolShowTime )
			{
				var mbTotal = dojo.marginBox(this.domTotalTime);
				width -= mbTotal.w*2;
			}
			
			this._intRealWidth = width;			
			dojo.style(this.domBar, "width", width + "px");

			// Need to workaround a webkit bug where the width: inherit isn't applied when the div is outside of display
			var list = dojo.query(".applyWidth", this.domNode);
			list.style("width", width + "px");

			// These 2 values tweaks where the button start and end ( magic values )
			this._intEnd = width;
			this._intStart = 0;

			// set value and update display
			this._updateDisplay();
		},

		/**
		 * Set the maximum value
		 * @param {Number} max new max
		 */
		setMax : function(intMax) {
			this.intMaximum = intMax;
			if(this.boolShowTime ) {
				this.domTotalTime.innerHTML = (this.intMaximum)? this._floatToTime(this.intMaximum) : '';
			}
		},
		/**
		 * Set the current value
		 * @param {Number} value new value
		 */
		setValue: function(value) {
			this.intValue = Math.max(this.intMinimum, Math.min(this.intMaximum, value)); // Clamp between min & max
			//Apply godd color on bumper
			if(this.intValue===this.intMinimum) {
				dojo.addClass(this.domLeftBump,"minValue");
			}
			else {
				dojo.removeClass(this.domLeftBump,"minValue");
			}
			if(this.intValue===this.intMaximum) {
				dojo.addClass(this.domRightBump,"maxValue");
			}
			else {
				dojo.removeClass(this.domRightBump,"maxValue");
			}
			this._updateDisplay();
			this.valuechange();
		},
		/**
		 * get the current value
		 * @return {Number} return the value
		 */
		getValue: function() {
			return this.intValue;
		},

		/* ----------------------------------- Public methods ------------------------------------- */
		

		/**
		 * Event triggered when value changed
		 */
		valuechange : function() {

		},

		/* --------------------------------- Private Methods -------------------------------------- */

		/**
		 * @ignore
		 * When an iframe is shown reset the size so everything can be computed correctly
		 * This function is tricky because sometimes the styles aren't loaded when the UI is displayed, so we wait some more
		 */
		_display: function(strCurrentFrameId) {
			// Retrieve our frame's frameId
			if( this._strFrameId == null ) {
				this._strFrameId = ICTouchAPI.tools.getFrameId(this.domNode);
			}

			if( this._strFrameId == strCurrentFrameId ) {
				// It's our frame
				this.setBarWidth(this.intBarWidth);

				if( this.domBar.scrollWidth == 0 || this.domBar.scrollLeft == 0 ) {
					// Style didn't load yet when scrollWidth or scrollLeft equals 0, retry after 100ms
					var context = this;
					setTimeout(function(){
						context._display(strCurrentFrameId);
					}, 100);
				}
			}
		},
		
		/**
		 * @ignore
		 */
		_setValueAbsolute : function(pixelValue) {
			// Convert value from pixel to meaningful intValue
			this.intValue = ((pixelValue-this._intStart)*(this.intMaximum-this.intMinimum)/(this._intEnd-this._intStart))+this.intMinimum;
			this.setValue(this.intValue);
		},
		/**
		 * @ignore
		 */
		placeAt : function() {
			this.inherited(arguments);
			this.setBarWidth(this.intBarWidth);
		},
		/**
		 * @ignore
		 */
		_updateDisplay : function() {
			// Compute the left position of the button and progressBar
			var left = this._intStart+(this.intValue-this.intMinimum) * (this._intEnd-this._intStart)/(this.intMaximum-this.intMinimum);			
			this.domBar.scrollLeft = this._intRealWidth-left;

			if( this.boolShowTime )
				this.domPlayedTime.innerHTML = this._floatToTime(this.intValue);
		},
		/**
		 * @ignore
		 */
		_floatToTime : function(intValue) {
			var val = Math.round(intValue);
			var secs = val%60;
			var pad = secs < 10 ? '0' : '';
			return Math.floor(val/60) + ":" + pad + secs;
		},
		
		/**
		 * @ignore
		 */
		refreshDisplay : function (){
			this._updateDisplay();
		}
	});
