/**
* @class UIElements.PresentationList.PresentationListControlBase
* @extends UIElements._base
* Abstract Class - Do not use it directly
*/
dojo.provide("UIElements.PresentationList.PresentationListControlBase");
dojo.declare("UIElements.PresentationList.PresentationListControlBase",
	[UIElements._base, dojox.dtl._Templated], {

		/* --------------------------------- Public attributes ------------------------------------ */
		/**
		 * Items to display in the list
		 * @property
		 * @type {Array}
		 */
		arrItems		: [ ],
		/**
		 * Show Icons
		 * @property
		 * @type {Boolean}
		 */
		boolShowIcon	: false,
		/**
		 * Show Highlight when user presses on PresentationList item?
		 * @property
		 * @type {Boolean}
		 */
		boolShowHighlight	: false,
		/**
		 * Show Labels
		 * @property
		 * @type {Boolean}
		 */
		boolShowLabel	: false,
		/**
		 * Scroll
		 * @property
		 * @type {Boolean}
		 */
		boolScroll		: true,
        /**
         * Display style of the list, possible values : default, contactcard
         * @property
         * @type {String}
         */
        strDisplay     : "default",

		/* --------------------------------- Private attributes ----------------------------------- */

		/**
		 * @ignore
		 */
		domObjContent : 0,
		/**
		 * @ignore
		 */
		domItems		: [ ],
		/**
		 * @ignore
		 */
		domArrIcons		: [ ],
		/**
		 * @ignore
		 */
		domArrIconsLabel : [ ],
		/**
		 * @ignore
		 */
		domList			: null,
		/**
		 * @ignore
		 */
		domTextContent	: [ ],
		/**
		 * @ignore
		 */
		domContent	: [ ],
		/**
		 * @ignore
		 */
		domLabel	: [ ],
		/**
		 * @ignore
		 * Max items on screen
		 */
		_intMaxItems	: 8,
		/**
		 * @ignore
		 * Index of first element shown
		 */
		_intStart		: 0,
		/**
		 * @ignore
		 * Index of last element shown
		 */
		_intEnd			: 0,
		/**
		 * true if we must wait for highlighting, false otherwise
		 * @ignore
		 * @type {Boolean}
		 */
		_enableWaitingHighlight : true,

		/* ------------------------------------ Constructor --------------------------------------- */

		constructor     : function(){
			this.arrItems = [ ];
			this.domArrIcons = [ ];
			this.domArrIconsLabel = [ ];
			this.domItems = [ ];
			this.domContent = [ ];
			this.domLabel = [ ];
		},

		postMixInProperties : function() {
			for(var i=0; i<this.arrItems.length; ++i) {
				var obj = this.arrItems[i];

				var strLabel = obj.strLabel?obj.strLabel:"";
				var strContent = obj.strContent?obj.strContent:"";

				var handlers = ICTouchAPI.i18nServices.i18nList([strLabel], this._swapLang(i, 0) );
				ICTouchAPI.i18nServices.addI18nHandlers(this, handlers);
				var handlers2 = ICTouchAPI.i18nServices.i18nList([strContent], this._swapLang(i, 1) );
				ICTouchAPI.i18nServices.addI18nHandlers(this, handlers2);

				/*if (strLabel){
					obj.strLabel = strLabel;
				}
				if (strContent){
					obj.strContent = strContent;
				}*/

				if (!obj.strLabel){
					obj.strLabel = "";
				}

				if (obj.objContent){
					obj.boolObjContent = true;
				}
			}
		},

		postCreate : function () {
			var len = this.arrItems.length;
			for(var i=0; i<len; ++i) {
				if(this.arrItems[i].callback){
					this.arrItems[i].callback = ICTouchAPI.tools.callbackToHitch(this.arrItems[i].callback);

					// Attach to the dom element the function to attach and remove an event from _base. (as on function "newElement" from _base)
					this.domItems[i].attachEvent = this._attachEvent();
					this.domItems[i]._removeEvent = this._removeEvent(this.domItems[i]);

					// Call the attachEvent function that has just been created. (will automatically fire _removeEvent when the list is destroyed)
					this.domItems[i].attachEvent({event: "mousedown", func: "_startHighlight", capture: true});
				}

				if (this.arrItems[i].objIconLabel) {
				    dojo.addClass(this.domArrIconsLabel[i], this.arrItems[i].objIconLabel.strIcon);
				    if(this.arrItems[i].objIconLabel.width) {
					dojo.style(this.domArrIconsLabel[i], {
					    "min-width": this.arrItems[i].objIconLabel.width + "px",
					    "max-width": this.arrItems[i].objIconLabel.width + "px"
					})
				    }
				}

				if (this.arrItems[i].strLabel.isI18Ned){
					this.domLabel[i].innerHTML = this.arrItems[i].strLabel.getTranslation();
					if (this.arrItems[i].objIconLabel && this.arrItems[i].objIconLabel.width) {
					    dojo.style(this.domLabel[i], {
						"min-width": (110 - this.arrItems[i].objIconLabel.width) + "px",
						"max-width": (110 - this.arrItems[i].objIconLabel.width) + "px"
					    })
					}
				//this.arrItems[i].strLabel.fillInnerHTML(this.domLabel[i])
				}
				else{
					this.domLabel[i].innerHTML = this.arrItems[i].strLabel;
				}

				if (this.arrItems[i].strIcon && this.boolShowIcon) {
					dojo.addClass(this.domArrIcons[i], this.arrItems[i].strIcon+"-"+this._iconSize);
				}
				if (this.arrItems[i].strHighlight && this.boolShowHighlight) {
					dojo.addClass(this.domItems[i], this.arrItems[i].strHighlight);
				}
				if (this.arrItems[i].additionalStyle) {
					dojo.addClass(this.domContent[i], this.arrItems[i].additionalStyle);
				}
				if (this.arrItems[i].boolEnabled === false){
					dojo.addClass(this.domItems[i], "disabledMode");
					this.domItems[i].isDisabled = true;
				}
				this.domItems[i].callback = this.arrItems[i].callback;
				if (this.arrItems[i].boolObjContent === true) {
					this.arrItems[i].objContent.placeAt(this.domContent[i], "replace");
				}
				else {
					if (this.arrItems[i].strContent.isI18Ned){
						this.domContent[i].innerText = "";
						this.domContent[i].innerHTML = this.arrItems[i].strContent.getTranslation();
					//this.arrItems[i].strContent.fillInnerHTML(this.domContent[i])
					}
					else{
						this.domContent[i].innerHTML = "";
						this.domContent[i].innerText = this.arrItems[i].strContent;
					}
					if(typeof this.arrItems[i].callback == "function") {
						dojo.addClass(this.domItems[i], "hasAction");
					}
				}

				var positionalClass = "middle";
				positionalClass = i === 0 ? "first" : positionalClass;
				positionalClass = i === len-1 ? "last" : positionalClass;
				dojo.addClass(this.domItems[i], positionalClass);

				dojo.toggleClass(this.domItems[i], "emphasis", (this.arrItems[i].boolEmphasis == true));

				// Only keep the first _intMaxItems into the dom
				if( i >= this._intMaxItems && this.boolScroll) {
					this.domList.removeChild(this.domItems[i]);
				}
			}

            // Change the list display
            if(this.strDisplay != "default") {
                dojo.addClass(this.domNode, this.strDisplay);
            }

			this._intEnd = Math.min(len, this._intMaxItems)-1;

			if(this.boolScroll) {
				this._initScroll();
			}
		},

		// return true if the current list is not equal to the arrItems argument
		// This function may be called to avoid a refresh of the list when it is not requiered.
		isListModified : function (arrItems) {
			var modified = false;

			//No items: list deleted. modified is true
			if (!arrItems) {
				modified = true;
			}

			// check if the number of fields is the same
			if (!modified){
				if(arrItems.length != this.arrItems.length){
					modified = true;
				}
			}

			// Then, check if every field of the new array is the same in the old one
			if(!modified){
				for(var i in arrItems){
					if(arrItems[i].strId != this.arrItems[i].strId || arrItems[i].strContent != this.arrItems[i].strContent || arrItems[i].strIcon != this.arrItems[i].strIcon){
						modified = true;
						break;
					}
				}
			}
			// Finally, check if every field of the old array is the same in the new one
			if(!modified){
				for(i in this.arrItems){
					if(arrItems[i].strId != this.arrItems[i].strId || arrItems[i].strContent != this.arrItems[i].strContent){
						modified = true;
						break;
					}
				}
			}

			return modified;
		},

		destroy: function() {

			for(var i=0; i<this.arrItems.length; ++i) {
				if (this.arrItems[i].boolObjContent) {
					this.arrItems[i].objContent.destroy();
				}
			}

			this.inherited(arguments);
		},

		/* ----------------------------------- Public methods ------------------------------------- */

		/**
		 * @ignore
		 */
		_swapLang : function (intItem, intType)  {
			var that = this;
			if(intType === 0) {
				return function (name, value) {
					if (that.domLabel && that.domLabel[intItem]) {
						return that.domLabel[intItem].innerHTML = value;
					} else {
						return false;
					}
				}
			} else if(intType === 1) {
				return function (name, value) {
					if (that.domContent && that.domContent[intItem] && !that.arrItems[intItem].boolObjContent) {
						return that.domContent[intItem].innerHTML = value;
					} else {
						return false;
					}
				}
			} else {
				return function () {
					return;
				}
			}
		},

		/**
		 * @ignore
		 */
		_initScroll: function() {
			var objScrollParams = {
				"handler" : this.domNode,
				"easing" : true,
				"scrollType" : "vertical"
			};
			// If we have more items than _intMaxItems then start the pagination mechanism
			if( this.domItems.length > this._intMaxItems ) {
				objScrollParams.pagination = {
					"callback" : this.pagination,
					"context" : this
				}
			}
			// Add the scrolling functionality
			this.scroll = FXScroll.init(objScrollParams);
		},

		/**
		 * @ignore
		 * @param {HTMLElement} element to be scrolled
		 * @return {Function} return a function ...
		 */
		pagination : function (element) {

			// If the list is scrolled more than 50 pixels
			if (this.domNode.scrollTop >= 50) {
				// Push an item at the end of the list and remove the first one.
				// Return the amount of pixels to "unscroll"
				return -50 * this.push(1);
			// If the list is scrolled to the top most
			} else if (!this.domNode.scrollTop) {
				// Add an item at the top of the list and remove the last one
				return 50 *this.unshift(1);
			} else {
				// If nothing changed, return 0.
				return 0;
			}

		},

		/**
		 * @ignore
		 * If the number of elements gets to big, removes the top nodes
		 * @param {Number} nb number of elements to be added
		 * @return {Boolean} result
		*/
		push : function(nb) {
			var node;
			// Do nothing if we are already at the end
			if( this._intEnd >= this.domItems.length-1 ) {
				return 0;
			}
			node = this.domItems[this._intStart];
			this.domList.removeChild(node);
			this._intStart++;
			this._intEnd++;
			node = this.domItems[this._intEnd];
			dojo.place(node, this.domList, "last");
			var item = this.arrItems[this._intEnd];
			if(item.objContent && item.objContent.refreshDisplay){
				item.objContent.refreshDisplay();
			}
			return 1;
		},

		/**
		 * @ignore
		 * @param {Number} nb number of elements to be unshifted
		 * @return {Boolean} result
		 */
		unshift : function(nb) {
			var node;
			// Do nothing if we are already at the end
			if( this._intStart <= 0 ) {
				return 0;
			}
			node = this.domItems[this._intEnd];
			this.domList.removeChild(node);
			this._intStart--;
			this._intEnd--;
			node = this.domItems[this._intStart];
			dojo.place(node, this.domList, "first");
			return 1;
		},

		/**
		 * @ignore
		 * run the event callback
		 * @param {Event} event number of elements to be unshifted
		 *
		 */
		itemAction : function(event) {
			if (event.currentTarget.isDisabled == true){
				return;
			}
			if (event.currentTarget.callback)
				event.currentTarget.callback();
		},

		/**
		 * @ignore
		 * move to the Item
		 * @param {Number} index index of the targeted Item
		 *
		 */
		moveToItem : function(intIndex) {
			this.scroll.getScroll().moveToItem(intIndex)
		},

		/**
		 * @ignore
		 * move to the Item
		 * @param {Number} index index of the targeted Item
		 * @param {Boolean} emphasis is Emphasis enabled ?
		 *
		 */
		toggleEmphasis: function (intIndex, boolEmphasis) {
			if(intIndex >= 0 && intIndex < this.arrSecondary.length)
			{
				dojo.toggleClass(this.arrSecondary[intIndex], "emphasis", (boolEmphasis == true));
			}
		},

		/**
		 * @ignore
		 */
		toggleDisabledMode: function(intIndex, disabledMode) {
			if(intIndex >= 0 && intIndex < this.domItems.length)
			{
				dojo.toggleClass(this.domItems[intIndex], "disabledMode", (disabledMode == true));
				this.domItems[intIndex].isDisabled = disabledMode;
			}
		},

		/**
		 * @ignore
		 * setItemTextContent change text of an item according to this position
		 * @param {Number} intPos Position
		 * @param {String} strText Text
		 */
		setItemTextContent: function(intPos, strText) {
			if(this.arrItems[intPos].boolObjContent!==true) {
				if (strText.isI18Ned) {
					strText = strText.getTranslation();
				};
				this.domContent[intPos].innerHTML = strText;
			}
		},

		/**
		 * @public
		 * Change the label of an item according to this position
		 * @param {Number} intPos Position
		 * @param {String} strText Text
		 */
		setItemLabel : function(intPos, strText) {
			if (strText.isI18Ned) {
				strText = strText.getTranslation();
			}
			this.domLabel[intPos].innerHTML = strText;
		}

	});
