/**
* @class UIElements.OptionChooser.OptionChooserControlBase
* @extends UIElements._base
* Abstract Class - Do not use it directly
*/
dojo.provide("UIElements.OptionChooser.OptionChooserControlBase");

dojo.declare("UIElements.OptionChooser.OptionChooserControlBase",
	[UIElements._base, dojox.dtl._Templated],
	{

		/* --------------------------------- Public attributes ------------------------------------ */

		/**
		 * Array of string that form the available options
		 * @property
		 * @type Array
		 */
		arrItems			: null,

		/**
		 * Index of selected option
		 * @property
		 * @type Number
		 */
		intIndex			: 0, // Can be changed with ui.attr('intIndex', newValue);

		/**
		 * Width of an individual option in px
		 * @property
		 * @type Number
		 */
		intOptionWidth		: 76, // Can be changed with ui.attr('intOptionWidth', newValue); (80px if no padding)

		/**
		 * Function called when the value change
		 * @property
		 * @type Function
		 */
		funcCallback		: null,

		/* --------------------------------- Private attributes ----------------------------------- */

		/**
		 * @ignore
		 */
		_funcCallbackFunc	: null,
		/**
		 * @ignore
		 */
		_boolActive			: false,
		/**
		 * @ignore
		 */
		_arrRow				: null,
		/**
		 * @ignore
		 */
		_intStart			: -1,
		/**
		 * @ignore
		 */
		domLabel				: null,

		/* ------------------------------------ Constructor --------------------------------------- */

		constructor: function() {
			this._arrRow = [];
			this.domLabel = [];
		},

		postMixInProperties : function() {
			if(this.arrItems) {
				for(var i=0; i<this.arrItems.length; ++i) {
					var obj = this.arrItems[i];
					var handler = ICTouchAPI.i18nServices.i18nList([obj], this._swapLang(i));
					ICTouchAPI.i18nServices.addI18nHandlers(this, handler);
				}
			}
		},

		postCreate: function() {
			if(!generalConfig.simulation) {
				if(this.arrItems) {
					for(var i=0; i<this.arrItems.length; ++i) {
						dojo.toggleClass(this._arrRow[i], "active", ( i === this.intIndex ));
						this._arrRow[i].intIndex = i;
						if (this.arrItems[i].isI18Ned) {
							this.domLabel[i].innerHTML = this.arrItems[i].getTranslation();
						}
						else {
							this.domLabel[i].innerHTML = this.arrItems[i];
						}
					}
				}
				this._setIntOptionWidthAttr(this.intOptionWidth);
				// This cannot be done with a dojoAttachEvent
				this.connect(this, "onMouseLeave", this._finish);
			}
		},

		/* ----------------------------------- Getter / Setter------------------------------------- */

		/**
		 * method for changing the UIElement's value
		 * @param {Number} newValue This will change the main selected item
		 */
		setValue: function (newValue) {
			this._setIntIndexAttr(newValue);
		},

		/**
		 * get the current selected index
		 * @return {Number} the current selected item
		 */
		getValue: function() {
			return this.intIndex;
		},

		/* --------------------------------- Private Methods -------------------------------------- */

		/**
		 * @ignore
		 */
		_mousedown: function(event) {
			this._intStart = this.intIndex;
			var newIndex = event.currentTarget.intIndex;
			this._setIntIndexAttr(newIndex);
			// Mark this as active
			this._boolActive = true;
		},

		/*
		 * This function must be removed when the new scroll ( with axis constrait ) will be implemented
		 * Do not forget to remove all reference to this
		 * @ignore
		 */
		_fixScroll: function() {
			if(this._containingScroll == undefined){
				var currentNode = this.domNode;
				while(!this._containingScroll && currentNode){
					if(currentNode.IctScroll){
						this._containingScroll = currentNode.IctScroll;
					}
					currentNode = currentNode.parentNode;
				}
			}
			if(this._containingScroll){
				this._containingScroll.cancelEvent = false;
			}else{
				this._containingScroll = false;
			}
		},

		/**
		 * @ignore
		 */
		_mousemove: function(event) {
			// Ignore the event if it isn't active
			if( this._boolActive ) {
				var newIndex = event.currentTarget.intIndex;
				this._setIntIndexAttr(newIndex);
				// This remove the capture feature of the scroll
				this._fixScroll();
			}
		},

		/**
		 * @ignore
		 * Callback when the user stop using the option chooser
		 */
		_finish: function(event) {
			if( this._boolActive && this._intStart != this.intIndex ) {
				// When we stop with the OptionChooser launch callback

				if( this._funcCallbackFunc )
					this._funcCallbackFunc(this.intIndex);
				this._feedback(event);
			}
			//crms00247940 : mousemove function was called before mouse down,
			//because of the boolActive value kept at "true" the intIndex was always changed.
			this._boolActive = false;

		},

		/**
		 * @ignore
		 */
		_setIntIndexAttr: function(newIndex) {
			if( newIndex != this.intIndex ) {
				dojo.removeClass(this._arrRow[this.intIndex], "active");
				dojo.addClass(this._arrRow[newIndex], "active");
				this.intIndex = newIndex;
			}
		},

		/**
		 * @ignore
		 */
		_setIntOptionWidthAttr: function(newWidth) {
			var i, len, realWidth, totalWidth = 0;
			len = this._arrRow.length;
			for(i=0; i<len; ++i) {
				// -3px ( border: 2px, margin: 1px ) but last item that doesn't have any margin
				realWidth = i === len-1 ? newWidth - 3 : newWidth - 2;
				dojo.style(this._arrRow[i], "width", realWidth + "px");
				totalWidth += realWidth+3;
			}
			dojo.style(this.domNode, "width", totalWidth+"px");
			this.intOptionWidth = newWidth;
		},

		/**
		 * @ignore
		 */
		_feedback: function() {

		},

		/**
		 * @ignore
		 */
		_setFuncCallbackAttr : function(callback) {
			this._funcCallbackFunc = ICTouchAPI.tools.callbackToHitch(callback);
		},
		
		_swapLang : function (intItem) {
			var context = this;
			return function (name, value) {
				if (context.domLabel && context.domLabel[intItem]) {
					return context.domLabel[intItem].innerHTML = value;
				} else {
					return false;
				}
			}
		}

	});
