/**
* @class UIElements.NotificationButton.NotificationButtonControlBase
* @extends UIElements._base
* Abstract Class - Do not use it directly
*/
dojo.provide("UIElements.NotificationButton.NotificationButtonControlBase");
dojo.declare("UIElements.NotificationButton.NotificationButtonControlBase",
	[UIElements._base, dojox.dtl._Templated],
	{
		/* --------------------------------- Public attributes ------------------------------------ */

		/**
		 * Notification value
		 * @property
		 * @type Number
		 */
		intNotificationValue		: 0,
		/**
		 * Notification name
		 * @property
		 * @type String
		 */
		strNotificationName			: "",
		/**
		 * Notification type
		 * @property
		 * @type String
		 */
		strNotificationType			: "",
		/**
		 * Notification icone name
		 * @property
		 * @type String
		 */
		strNotificationIcon			: "",
		/**
		 * Notification label
		 * @property
		 * @type String
		 */
		strNotificationLabelIcon			: "",
		/**
		 * Notification bottom label
		 * @property
		 * @type String
		 */
		strNotificationLabelBottomIcon			: "",

		/**
		 * Notification icons displayed in the second line
		 * @property
		 * @type Array
		 */
		arrNotificationIconBottom : [],

		/**
		 * Notification label
		 * @property
		 * @type String
		 */
		strNotificationLabel		: "",

		/**
		 * Notification bottom label
		 * @property
		 * @type String
		 */
		strNotificationLabelBottom: "",

		/**
		 * callback function
		 * @property
		 * @type Function
		 */
		callback					: null,
		/**
		 * my feedback
		 * @property
		 * @type Function
		 */
		myFeedback					: null,

		/* --------------------------------- Private attributes ----------------------------------- */

		/**
		 * @ignore
		 */
		_callbackFunc				: null,
		/**
		 * @ignore
		 */
		_intPosition				: -1,
		/**
		 * @ignore
		 */
		intNotifPosition			: -1,
		/**
		 * @ignore
		 */
		arrPositionClass			: ["firstNotif","secondNotif","thirdNotif","largeNotif","hiddenNotif"],
		/**
		 * @ignore
		 */
		domNotificationLabel : null,
		/**
		 * @ignore
		 */
		domNotificationLabelIcon : null,

		/**
		 * @ignore
		 */
		domNotificationLabelBottom : null,

		/**
		 * @ignore
		 */
		domNotificationLabelBottomIcon : null,

		/**
		 * @ignore
		 */
		domNotificationIconBottom: [],

		/**
		 * @ignore
		 */
		domNotificationType			: null,
		/**
		 * @ignore
		 */
		domNotificationValue		: null,

		/**
		 * @ignore
		 */
		_state:                         "IDLE",

		/**
		 * @ignore
		 */
		attributeMap: {
			strNotificationLabel: {
				node: "domNotificationLabel",
				type: "innerHTML"
			},

			strNotificationLabelBottom : {
				node: "domNotificationLabelBottom",
				type: "innerHTML"
			}
		},

		/* ------------------------------------ Constructor --------------------------------------- */

		constructor : function() {
		//this.myFeedback = ICTouchAPI.feedbackServices.initFeedback("click");
		    this.domNotificationIconBottom = [];
		},


		postCreate : function () {
			if(!generalConfig.simulation) {
				if (this.strNotificationType){
					dojo.addClass(this.domNotificationType, this.strNotificationType);
				}
				if (this.strNotificationIcon){
					dojo.addClass(this.domNotificationValue, this.strNotificationIcon);
				}
				if (this.strNotificationLabelIcon){
					dojo.addClass(this.domNotificationLabelIcon, this.strNotificationLabelIcon);
				}
				if (this.strNotificationLabelBottomIcon){
					dojo.addClass(this.domNotificationLabelBottomIcon, this.strNotificationLabelBottomIcon);
				}
				if (!this.strNotificationLabelBottom){
					dojo.style(this.domNotificationLabelBottom, "display", "none");
				}

				if (this.arrNotificationIconBottom) {
					// Define the length in pixels of all bottom icons
					var widthIcons = 140-9;
					var maxHeight = 15;
					for(var counterIcon = 0; counterIcon < this.arrNotificationIconBottom.length; counterIcon++) {
						// Calculate the total length and the highest icon of the bottom icons
						if (this.arrNotificationIconBottom[counterIcon].width) {
							widthIcons -= this.arrNotificationIconBottom[counterIcon].width;
						} else {
							// Default value, see largeNotification CSS
							widthIcons -= 15;
						}
						// Determines the highest icon
						if (this.arrNotificationIconBottom[counterIcon].width) {
							if (this.arrNotificationIconBottom[counterIcon].width > maxHeight) {
								maxHeight = this.arrNotificationIconBottom[counterIcon].width;
							}
						}
					}

					for(var counterIcon = 0; counterIcon < this.arrNotificationIconBottom.length; counterIcon++) {
						dojo.addClass(this.domNotificationIconBottom[counterIcon], this.arrNotificationIconBottom[counterIcon].icon);
						if (!counterIcon) {
							// Define the default left margin for the first icon
							dojo.style(this.domNotificationIconBottom[counterIcon],"margin-left","9px");
						}
						dojo.style(this.domNotificationIconBottom[counterIcon],"width",maxHeight+"px");
						dojo.style(this.domNotificationIconBottom[counterIcon],"height",maxHeight+"px");
					}

					/*	If bottom icons are defined, the label has no margin-left.
					The available width is calculated depending of the number of defined bottom icons.
					The font style is set to italic to fit the large notification.
					*/
					if (this.strNotificationLabelBottom) {
						dojo.style(this.domNotificationLabelBottom,"margin-left","0px");
						dojo.style(this.domNotificationLabelBottom,"width", widthIcons+"px");
						dojo.style(this.domNotificationLabelBottom,"font-style","italic");
					}
				}
			}
		},

		/* ----------------------------------- Getter / Setter------------------------------------- */

		/**
		 * Set the position
		 * @param {Number} intPosition the new position
		 */
		setPosition : function(intPosition) {
			var strClass = null;
			if(this.arrPositionClass[intPosition]) {
				strClass = this.arrPositionClass[intPosition];
			}
			if(intPosition != this.intNotifPosition) {
				if(this.arrPositionClass[this.intNotifPosition]) {
					dojo.removeClass(this.domNotification,this.arrPositionClass[this.intNotifPosition]);
				} else {
					dojo.removeClass(this.domNotification,"hiddenNotif");
				}
			}
			if(strClass) {
				dojo.addClass(this.domNotification,strClass);
			} else {
				dojo.addClass(this.domNotification,"hiddenNotif");
			}
			this.intNotifPosition = intPosition;
		},

		/**
		 * Set the value
		 * @param {Number} value new value
		 */
		setValue : function(value){
			this.intNotificationValue=value;
			this.domNotificationValue.innerHTML = value;
		},

		/* ----------------------------------- Public methods ------------------------------------- */

		/* --------------------------------- Private Methods -------------------------------------- */

		_startHighlight : function() {
			// Launch default highlight and get its status
			var boolHighlight = this.inherited(arguments);
			if(boolHighlight) {
                    this._state = "PENDING";
			}
                },

		_stopHighlight : function() {
			var clicked = this.inherited(arguments);
			if(clicked) {
                    if(this._state == "PENDING") {
                        if( this._callbackFunc ) {
                                this._callbackFunc();
                        }
                        this._state = "IDLE";
                    }
			}
                },

		/**
		 * @ignore
		 */
		_setCallbackAttr : function(callback) {
			this._callbackFunc = ICTouchAPI.tools.callbackToHitch(callback);
		}
	}
	);
