/**
 * @class UIElements.NavigationBar.NavigationBarBase
 * @namespace UIElements.NavigationBar
 * @extends UIElements._base
 * Abstract Class<br>
 */
dojo.provide("UIElements.NavigationBar.NavigationBarBase");
dojo.declare("UIElements.NavigationBar.NavigationBarBase",
	[UIElements._base,
	dijit._Templated],
	{
		/* --------------------------------- Public attributes ------------------------------------ */


		

		/* --------------------------------- Private attributes ----------------------------------- */

		domArrListPage : null,
		intMaxPage : 1,
		intCurrentPage : 1,
		displayCallBack : null,
		domList : null,
		domArrowLeft : null,
		domArrowRight : null,

		/* ------------------------------------ Constructor --------------------------------------- */

		constructor : function(){
			this.domArrListPage = [];
		},

		postMixInProperties : function(){

		},

		postCreate : function(){
			if(!generalConfig.simulation) {
				this._updatePageList();
				this._updateArrows();
			}
		},

		/* ----------------------------------- Getter / Setter------------------------------------- */




		/* ----------------------------------- Public methods ------------------------------------- */

		/**
		 * Go to specific page and update navigation bar items
		 * @param {number} intPageNumber the new current page number
		 */
		goToPage : function (intPageNumber){
			var page = null;

			// Update current page (and correct if not existant)
			if (intPageNumber.currentTarget && intPageNumber.currentTarget.attributes.getNamedItem('position').value) {
				// Automatic case if we want to authorize a click on each icon, not used for the moment
				page = parseInt(intPageNumber.currentTarget.attributes.getNamedItem('position').value);
			} else if (typeof(intPageNumber)=='number' && parseInt(intPageNumber)== intPageNumber) {
				page = intPageNumber;
			} else {
				page = parseInt(this.intCurrentPage);
			}

			if(typeof page != "number" || page == NaN){
				ICTouchAPI.debugServices.error("UIElements.NavigationBar.NavigationBarBase - goToPage / The page number entered is not a number : "+intPageNumber);
				return;
			}

			if(page != this.intCurrentPage){

				// Remove current class to last page and add normal class instead
				dojo.removeClass(this.domArrListPage[this.intCurrentPage-1], "current");
				dojo.addClass(this.domArrListPage[this.intCurrentPage-1], "normal");

				if (page>this.intMaxPage) {
					this.intCurrentPage = parseInt(this.intMaxPage);
				} else if (page<1) {
					this.intCurrentPage = 1;
				} else {
					this.intCurrentPage = parseInt(page);
				}

				// Remove normal class to new current page and add current class instead
				dojo.removeClass(this.domArrListPage[this.intCurrentPage-1], "normal");
				dojo.addClass(this.domArrListPage[this.intCurrentPage-1], "current");

				// Show selected page
				this.displayCallBack(this.intCurrentPage);

				this._updateArrows();
			} else {
				ICTouchAPI.debugServices.warning("UIElements.NavigationBar.NavigationBarBase - goToPage / The page number was already the same : "+page);
			}
		},

		/**
		 * Change the number of pages and update the icons display.
		 * @param {Number} intMaxPage the new number of pages
		 */
		setMaxPage : function(intMaxPage) {
			if(this.intMaxPage != intMaxPage){
				var newMaxPage = parseInt(intMaxPage);
				if(newMaxPage != NaN){
					this.intMaxPage = parseInt(intMaxPage);

					// Check that the selected page is not higher than the new maxPage
					if (this.intCurrentPage>this.intMaxPage) {
						this.intCurrentPage = parseInt(this.intMaxPage);
					}

					this._updatePageList();

					this._updateArrows();
				} else {
					ICTouchAPI.debugServices.error("UIElements.NavigationBar.NavigationBarBase - setMaxPage / The number of pages entered is not a number : "+intMaxPage);
				}
			} else {
				ICTouchAPI.debugServices.warning("UIElements.NavigationBar.NavigationBarBase - setMaxPage / The number of pages was already the same : "+intMaxPage);
			}
		},

		/**
		 * Go to previous page
		 */
		previous : function() {
			this.goToPage(parseInt(this.intCurrentPage)-1);
		},

		/**
		 * Go to next page
		 */
		next : function() {
			this.goToPage(parseInt(this.intCurrentPage)+1);
		},

		/* --------------------------------- Private Methods -------------------------------------- */

		_updatePageList : function() {
			// Update navigation bar : list of pages
			dojo.empty(this.domList);
			this.domArrListPage = [];

			for (var i=1;i<=this.intMaxPage;i++) {
				var li = dojo.create("li", {"class":"item", dojoAttachPoint:"domPageItem"+i, position:i}, this.domList);
				if (i == 1) {
						dojo.addClass(li, "home");
				}
				if (i == this.intCurrentPage) {
					dojo.addClass(li, "current");
				} else {
					dojo.addClass(li, "normal");
				}
				this.domArrListPage.push(li);
			}
		},

		_updateArrows : function() {
			// Update navigation bar : hide or show arrows
			if (this.intCurrentPage <= 1) {
				dojo.addClass(this.domArrowLeft, "hide");
			} else {
				dojo.removeClass(this.domArrowLeft, "hide");
			}
			if (this.intCurrentPage >= this.intMaxPage) {
				dojo.addClass(this.domArrowRight, "hide");
			} else {
				dojo.removeClass(this.domArrowRight, "hide");
			}
		}

	});
