/**
* @class UIElements.MenuList.MenuListControl
* @extends UIElements.MenuList.MenuListControlBase
* The MenuList displays items that contain at least the following fields:
* <pre><code>
* - {String} strPrimaryContent The primary text content displayed
* - {String} strSecondaryContent The second text content displayed
* - {String} strPicture The path to the picture displayed
* - {String} strPrimaryIcon The CSS class for the Primary icon
* - {String} strsecondaryIcon The CSS class for the Secondary icon
* - {Number} intIndex The index for retrieving the item
* </code></pre>
* Depending to your need, the item can contains any additionnal field
*/
dojo.require("UIElements.MenuList.MenuListControlBase");
dojo.provide("UIElements.MenuList.MenuListControl");
dojo.declare("UIElements.MenuList.MenuListControl",
	UIElements.MenuList.MenuListControlBase,
	{
		// The path to the template is defined here
		/* --------------------------------- Public attributes ------------------------------------ */

		/**
		 * path to the template
		 * @property
		 * @type {String}
		 */
		templatePath	: dojo.moduleUrl("UIElements.MenuList","templates/MenuList8082.html"),

		/**
		 * Array of css files
		 * @property
		 * @type {Array}
		 */
		cssFile         : ["base.css", "8082.css"],

		/* --------------------------------- Private attributes ----------------------------------- */

		/* ------------------------------------ Constructor --------------------------------------- */

		constructor : function(){

		}

	/* ----------------------------------- Getter / Setter------------------------------------- */

	/* ----------------------------------- Public methods ------------------------------------- */

	/* --------------------------------- Private Methods -------------------------------------- */

	}
	);
